/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlink;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUrlHyperlinkDetector
extends AbstractTaskHyperlinkDetector {
    private static final Pattern URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]*[a-zA-Z0-9%_~!$&?#'(*+;:@/=-])");

    @Override
    protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int indexInContent, int contentOffset) {
        ArrayList<TaskUrlHyperlink> links = null;
        Matcher m = URL_PATTERN.matcher(content);
        while (m.find()) {
            if (!TaskUrlHyperlinkDetector.isInRegion(indexInContent, m)) continue;
            try {
                String urlString = m.group(1);
                new URL(urlString);
                if (links == null) {
                    links = new ArrayList<TaskUrlHyperlink>();
                }
                links.add(new TaskUrlHyperlink(TaskUrlHyperlinkDetector.determineRegion(contentOffset, m), urlString));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return links;
    }

    private static boolean isInRegion(int offsetInText, Matcher m) {
        return offsetInText == -1 || offsetInText >= m.start() && offsetInText <= m.end();
    }

    private static IRegion determineRegion(int textOffset, Matcher m) {
        return new Region(textOffset + m.start(), m.end() - m.start());
    }
}

