/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.token;

import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class HyperlinkReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(?:(\"|\\!)([^\"]+)\\" + (1 + groupOffset) + ":([^\\s]+))";
    }

    protected int getPatternGroupCount() {
        return 3;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkReplacementTokenProcessor();
    }

    private static class HyperlinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkReplacementTokenProcessor() {
        }

        public void emit() {
            String hyperlinkBoundaryText = this.group(1);
            String hyperlinkSrc = this.group(2);
            String href = this.group(3);
            if (hyperlinkBoundaryText.equals("\"")) {
                this.builder.link(href, hyperlinkSrc);
            } else {
                this.builder.imageLink(href, hyperlinkSrc);
            }
        }
    }
}

