/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.services;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEvent;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEventListener;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;

public class UsageDataService {
    private static final String MONITORS_EXTENSION_POINT = "org.eclipse.epp.usagedata.gathering.monitors";
    private boolean monitoring = false;
    private ListenerList monitors = new ListenerList();
    private ListenerList eventListeners = new ListenerList();
    Job eventConsumerJob;
    protected LinkedBlockingQueue<UsageDataEvent> events = new LinkedBlockingQueue();
    private Map<String, String> bundleVersionMap = new HashMap<String, String>();

    public void startMonitoring() {
        if (this.isMonitoring()) {
            return;
        }
        this.startMonitors();
        this.startEventConsumerJob();
        this.monitoring = true;
    }

    public synchronized void stopMonitoring() {
        if (!this.isMonitoring()) {
            return;
        }
        this.stopMonitors();
        this.stopEventConsumerJob();
        this.monitoring = false;
    }

    public boolean isMonitoring() {
        return this.monitoring;
    }

    protected void startEventConsumerJob() {
        if (this.eventConsumerJob != null) {
            return;
        }
        this.eventConsumerJob = new Job("Usage Data Event consumer"){
            boolean cancelled;
            {
                this.cancelled = false;
            }

            public IStatus run(IProgressMonitor monitor) {
                UsageDataService.this.waitForWorkbenchToFinishStarting();
                while (!this.isCancelled()) {
                    UsageDataEvent event = UsageDataService.this.getQueuedEvent();
                    UsageDataService.this.dispatchEvent(event);
                }
                return Status.OK_STATUS;
            }

            synchronized boolean isCancelled() {
                return this.cancelled;
            }

            protected synchronized void canceling() {
                this.cancelled = true;
            }
        };
        this.eventConsumerJob.setSystem(true);
        this.eventConsumerJob.setPriority(30);
        this.eventConsumerJob.schedule(1000L);
    }

    protected void waitForWorkbenchToFinishStarting() {
        while (!EclipseStarter.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void stopEventConsumerJob() {
        this.eventConsumerJob.cancel();
        this.eventConsumerJob = null;
    }

    private UsageDataEvent getQueuedEvent() {
        try {
            return this.events.take();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void recordEvent(String what, String kind, String description, String bundleId) {
        this.recordEvent(what, kind, description, bundleId, null);
    }

    public void recordEvent(String what, String kind, String description, String bundleId, String bundleVersion) {
        UsageDataEvent event = new UsageDataEvent(what, kind, description, bundleId, bundleVersion, System.currentTimeMillis());
        this.recordEvent(event);
    }

    private void recordEvent(UsageDataEvent event) {
        this.events.add(event);
    }

    private void dispatchEvent(UsageDataEvent event) {
        this.registerBundleVersion(event);
        if (event.bundleVersion == null) {
            event.bundleVersion = this.getBundleVersion(event.bundleId);
        }
        Object[] listeners = this.eventListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            UsageDataEventListener listener = (UsageDataEventListener)listeners[index];
            this.dispatchEvent(event, listener);
            ++index;
        }
    }

    private void dispatchEvent(UsageDataEvent event, UsageDataEventListener listener) {
        try {
            listener.accept(event);
        }
        catch (Throwable e) {
            UsageDataCaptureActivator.getDefault().logException("The listener (" + listener.getClass() + ") threw an exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBundleVersion(UsageDataEvent event) {
        if (!"bundle".equals(event.kind)) {
            return;
        }
        if (!"started".equals(event.what)) {
            return;
        }
        Map<String, String> map = this.bundleVersionMap;
        synchronized (map) {
            this.bundleVersionMap.put(event.bundleId, event.bundleVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBundleVersion(String bundleId) {
        if (bundleId == null) {
            return null;
        }
        Map<String, String> map = this.bundleVersionMap;
        synchronized (map) {
            return this.bundleVersionMap.get(bundleId);
        }
    }

    protected void startMonitors() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(MONITORS_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("monitor".equals(element.getName())) {
                try {
                    Object monitor = element.createExecutableExtension("class");
                    if (monitor instanceof UsageMonitor) {
                        this.startMonitor((UsageMonitor)monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void startMonitor(UsageMonitor monitor) {
        monitor.startMonitoring(this);
        this.monitors.add((Object)monitor);
    }

    protected void stopMonitors() {
        Object[] objectArray = this.monitors.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object monitor = objectArray[n2];
            this.stopMonitor((UsageMonitor)monitor);
            ++n2;
        }
    }

    private void stopMonitor(UsageMonitor monitor) {
        monitor.stopMonitoring();
        this.monitors.remove((Object)monitor);
    }

    public void addUsageDataEventListener(UsageDataEventListener listener) {
        this.eventListeners.add((Object)listener);
    }

    public void removeUsageDataEventListener(UsageDataEventListener listener) {
        this.eventListeners.remove((Object)listener);
    }
}

