/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.IToggleBreakpointsTargetManagerListener;
import org.eclipse.debug.internal.ui.actions.ToggleBreakpointsTargetManager;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ToggleBreakpointAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;
    private IToggleBreakpointsTargetManagerListener fListener = new IToggleBreakpointsTargetManagerListener(){

        public void preferredTargetsChanged() {
            ToggleBreakpointAction.this.update();
        }
    };
    static /* synthetic */ Class class$0;

    public ToggleBreakpointAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(ActionMessages.ToggleBreakpointAction_0);
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
        ToggleBreakpointsTargetManager.getDefault().addChangedListener(this.fListener);
    }

    public void run() {
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        int line = this.fRulerInfo.getLineOfLastMouseButtonActivity();
        if (line == -1) {
            return;
        }
        try {
            IToggleBreakpointsTargetExtension extension;
            ITextSelection selection = this.getTextSelection(document, line);
            IToggleBreakpointsTarget toggleTarget = ToggleBreakpointsTargetManager.getDefault().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
            if (toggleTarget == null) {
                return;
            }
            if (toggleTarget instanceof IToggleBreakpointsTargetExtension && (extension = (IToggleBreakpointsTargetExtension)toggleTarget).canToggleBreakpoints(this.fPart, (ISelection)selection)) {
                extension.toggleBreakpoints(this.fPart, (ISelection)selection);
                return;
            }
            if (toggleTarget.canToggleLineBreakpoints(this.fPart, (ISelection)selection)) {
                toggleTarget.toggleLineBreakpoints(this.fPart, (ISelection)selection);
            } else if (toggleTarget.canToggleWatchpoints(this.fPart, (ISelection)selection)) {
                toggleTarget.toggleWatchpoints(this.fPart, (ISelection)selection);
            } else if (toggleTarget.canToggleMethodBreakpoints(this.fPart, (ISelection)selection)) {
                toggleTarget.toggleMethodBreakpoints(this.fPart, (ISelection)selection);
            }
        }
        catch (BadLocationException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    private void reportException(Exception e) {
        DebugUIPlugin.errorDialog(this.fPart.getSite().getShell(), ActionMessages.ToggleBreakpointAction_1, ActionMessages.ToggleBreakpointAction_2, e);
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
        ToggleBreakpointsTargetManager.getDefault().removeChangedListener(this.fListener);
    }

    private IDocument getDocument() {
        IDocument doc;
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((doc = (IDocument)this.fPart.getAdapter((Class)clazz)) != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        int line;
        IDocument document = this.getDocument();
        if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
            try {
                IToggleBreakpointsTargetExtension extension;
                ITextSelection selection = this.getTextSelection(document, line);
                IToggleBreakpointsTarget adapter = ToggleBreakpointsTargetManager.getDefault().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
                if (adapter == null) {
                    this.setEnabled(false);
                    return;
                }
                if (adapter instanceof IToggleBreakpointsTargetExtension && (extension = (IToggleBreakpointsTargetExtension)adapter).canToggleBreakpoints(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
                if (adapter.canToggleLineBreakpoints(this.fPart, (ISelection)selection) | adapter.canToggleWatchpoints(this.fPart, (ISelection)selection) | adapter.canToggleMethodBreakpoints(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (BadLocationException e) {
                this.reportException((Exception)((Object)e));
            }
        }
        this.setEnabled(false);
    }

    private ITextSelection getTextSelection(IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }
}

