/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ContextPerspectiveManager
implements ITaskActivationListener,
IPerspectiveListener4 {
    private final Set<String> managedPerspectiveIds;
    private final Set<String> actionSetsToSuppress;
    private final IPreferenceStore preferenceStore;

    public ContextPerspectiveManager(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.managedPerspectiveIds = new HashSet<String>();
        this.actionSetsToSuppress = new HashSet<String>();
        this.actionSetsToSuppress.add("org.eclipse.ui.edit.text.actionSet.annotationNavigation");
        this.actionSetsToSuppress.add("org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo");
        this.actionSetsToSuppress.add("org.eclipse.ui.externaltools.ExternalToolsSet");
    }

    public void addManagedPerspective(String id) {
        this.managedPerspectiveIds.add(id);
    }

    public void removeManagedPerspective(String id) {
        this.managedPerspectiveIds.remove(id);
    }

    public void taskActivated(ITask task) {
        try {
            IWorkbenchWindow launchingWindow = this.getWorkbenchWindow();
            if (launchingWindow != null) {
                IPerspectiveDescriptor descriptor = launchingWindow.getActivePage().getPerspective();
                this.setPerspectiveIdFor(null, descriptor.getId());
                String perspectiveId = this.getPerspectiveIdFor(task);
                this.showPerspective(perspectiveId);
            }
        }
        catch (Exception exception) {}
    }

    public void taskDeactivated(ITask task) {
        try {
            IWorkbenchWindow launchingWindow;
            if (PlatformUI.isWorkbenchRunning() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage") && (launchingWindow = this.getWorkbenchWindow()) != null) {
                IPerspectiveDescriptor descriptor = launchingWindow.getActivePage().getPerspective();
                this.setPerspectiveIdFor(task, descriptor.getId());
                String previousPerspectiveId = this.getPerspectiveIdFor(null);
                this.showPerspective(previousPerspectiveId);
            }
        }
        catch (Exception exception) {}
    }

    private void showPerspective(String perspectiveId) {
        if (perspectiveId != null && perspectiveId.length() > 0 && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage")) {
            IWorkbenchWindow launchingWindow = this.getWorkbenchWindow();
            try {
                try {
                    if (launchingWindow != null) {
                        launchingWindow.getShell().setRedraw(false);
                        PlatformUI.getWorkbench().showPerspective(perspectiveId, launchingWindow);
                    }
                }
                catch (Exception exception) {
                    if (launchingWindow != null) {
                        launchingWindow.getShell().setRedraw(true);
                    }
                }
            }
            finally {
                if (launchingWindow != null) {
                    launchingWindow.getShell().setRedraw(true);
                }
            }
        }
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            window = windows[0];
        }
        return window;
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.cleanActionSets(page, perspective);
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
        this.cleanActionSets(page, perspectiveDescriptor);
    }

    private void cleanActionSets(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
        if (this.managedPerspectiveIds.contains(perspectiveDescriptor.getId()) && page instanceof WorkbenchPage) {
            IActionSetDescriptor[] actionSetDescriptors;
            Perspective perspective = ((WorkbenchPage)page).getActivePerspective();
            HashSet<IActionSetDescriptor> toRemove = new HashSet<IActionSetDescriptor>();
            IActionSetDescriptor[] iActionSetDescriptorArray = actionSetDescriptors = ((WorkbenchPage)page).getActionSets();
            int n = actionSetDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IActionSetDescriptor actionSetDescriptor = iActionSetDescriptorArray[n2];
                if (this.actionSetsToSuppress.contains(actionSetDescriptor.getId())) {
                    toRemove.add(actionSetDescriptor);
                }
                ++n2;
            }
            perspective.turnOffActionSets(toRemove.toArray(new IActionSetDescriptor[toRemove.size()]));
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void preTaskActivated(ITask task) {
    }

    public void preTaskDeactivated(ITask task) {
    }

    private String getPerspectiveIdFor(ITask task) {
        if (task != null) {
            return this.preferenceStore.getString("org.eclipse.mylyn.ui.perspectives.task." + task.getHandleIdentifier());
        }
        return this.preferenceStore.getString("org.eclipse.mylyn.ui.perspectives.task.none");
    }

    private void setPerspectiveIdFor(ITask task, String perspectiveId) {
        if (task != null) {
            this.preferenceStore.setValue("org.eclipse.mylyn.ui.perspectives.task." + task.getHandleIdentifier(), perspectiveId);
        } else {
            this.preferenceStore.setValue("org.eclipse.mylyn.ui.perspectives.task.none", perspectiveId);
        }
    }
}

