/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class P2Utils {
    private static final String SRC_INFO_FOLDER = "org.eclipse.equinox.source";
    private static final String SRC_INFO_PATH = "org.eclipse.equinox.source" + File.separator + "source.info";
    private static final String BUNDLE_INFO_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    private static final String BUNDLE_INFO_PATH = "org.eclipse.equinox.simpleconfigurator" + File.separator + "bundles.info";
    static /* synthetic */ Class class$0;

    P2Utils() {
    }

    public static BundleInfo findBundle(String symbolicName, Version version, boolean isSourceBundle) {
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((version != null ? 1 : 0) != 0);
        return P2Utils.findBundle(symbolicName, new VersionRange(version, true, version, true), isSourceBundle);
    }

    private static void addLocationDirs(List locations, Location location, boolean useParent) {
        while (location != null) {
            URL url = location.getURL();
            if (url != null) {
                try {
                    File dir = new File(FileLocator.toFileURL((URL)url).getPath());
                    if (useParent) {
                        dir = dir.getParentFile();
                    }
                    if (!locations.contains(dir)) {
                        locations.add(dir);
                    }
                }
                catch (IOException e) {
                    JUnitPlugin.log(e);
                }
            }
            location = location.getParentLocation();
        }
    }

    public static BundleInfo findBundle(String symbolicName, VersionRange versionRange, boolean isSourceBundle) {
        SimpleConfiguratorManipulator manipulator;
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((versionRange != null ? 1 : 0) != 0);
        JUnitPlugin jUnitPlugin = JUnitPlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manipulator = (SimpleConfiguratorManipulator)jUnitPlugin.getService(clazz.getName())) == null) {
            return null;
        }
        ArrayList bundleLocations = new ArrayList();
        P2Utils.addLocationDirs(bundleLocations, Platform.getConfigurationLocation(), true);
        P2Utils.addLocationDirs(bundleLocations, Platform.getInstallLocation(), false);
        Location configLocation = Platform.getConfigurationLocation();
        while (configLocation != null) {
            URL configUrl = configLocation.getURL();
            if (configUrl != null) {
                try {
                    String bundleInfoPath = null;
                    bundleInfoPath = isSourceBundle ? SRC_INFO_PATH : BUNDLE_INFO_PATH;
                    URL bundlesTxt = new URL(configUrl.getProtocol(), configUrl.getHost(), new File(configUrl.getPath(), bundleInfoPath).getAbsolutePath());
                    Iterator i = bundleLocations.iterator();
                    while (i.hasNext()) {
                        File home = (File)i.next();
                        BundleInfo[] bundles = manipulator.loadConfiguration(bundlesTxt, home);
                        if (bundles == null) continue;
                        int j = 0;
                        while (j < bundles.length) {
                            IPath path;
                            BundleInfo bundle = bundles[j];
                            if (symbolicName.equals(bundle.getSymbolicName()) && versionRange.isIncluded(new Version(bundle.getVersion())) && (path = P2Utils.getBundleLocationPath(bundle)).toFile().exists()) {
                                return bundle;
                            }
                            ++j;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    JUnitPlugin.log(e);
                }
                catch (IOException e) {
                    JUnitPlugin.log(e);
                }
            }
            configLocation = configLocation.getParentLocation();
        }
        return null;
    }

    public static IPath getBundleLocationPath(BundleInfo bundleInfo) {
        if (bundleInfo == null) {
            return null;
        }
        URI bundleLocation = bundleInfo.getLocation();
        if (bundleLocation == null) {
            return null;
        }
        try {
            String fileStr = FileLocator.toFileURL((URL)URIUtil.toURL((URI)bundleLocation)).getPath();
            fileStr = URLDecoder.decode(fileStr, "UTF-8");
            return new Path(fileStr);
        }
        catch (IOException e) {
            JUnitPlugin.log(e);
            return null;
        }
    }
}

