/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Collections;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

public class TaskListSynchronizationScheduler {
    private long interval;
    private final ITaskJobFactory jobFactory;
    private SynchronizationJob refreshJob;

    public TaskListSynchronizationScheduler(ITaskJobFactory jobFactory) {
        this.jobFactory = jobFactory;
    }

    private SynchronizationJob createRefreshJob() {
        SynchronizationJob job = this.jobFactory.createSynchronizeRepositoriesJob(null);
        job.setSystem(true);
        job.setUser(false);
        job.setFullSynchronization(true);
        return job;
    }

    public synchronized SynchronizationJob getRefreshJob() {
        return this.refreshJob;
    }

    private synchronized void reschedule() {
        if (this.interval != 0L) {
            this.refreshJob.schedule(this.interval);
        }
    }

    public synchronized void setInterval(long interval) {
        this.setInterval(interval, interval);
    }

    public synchronized void setInterval(long delay, long interval) {
        if (this.interval != interval) {
            this.interval = interval;
            if (this.refreshJob != null) {
                this.refreshJob.cancel();
                this.refreshJob = null;
            }
            if (interval > 0L) {
                this.refreshJob = this.createRefreshJob();
                this.refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        TaskListSynchronizationScheduler.this.reschedule();
                    }
                });
                this.refreshJob.schedule(delay);
            }
        }
    }

    @Deprecated
    public SynchronizationJob synchronize(TaskRepository repository) {
        SynchronizationJob job = this.jobFactory.createSynchronizeRepositoriesJob(Collections.singleton(repository));
        job.setSystem(true);
        job.setUser(false);
        job.setFullSynchronization(false);
        job.schedule();
        return job;
    }
}

