/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Calendar;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleDatePicker;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractLocalEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.PlatformUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class PlanningPart
extends AbstractLocalEditorPart {
    private boolean needsDueDate;
    private String notesString;
    private RichTextEditor noteEditor;
    private static final int CONTROL_WIDTH = 120;
    private DatePicker dueDatePicker;
    private Text elapsedTimeText;
    private Spinner estimatedTime;
    private ScheduleDatePicker scheduleDatePicker;
    private static final String PERSONAL_NOTES = Messages.PlanningPart_Personal_Notes;
    private final ITaskListChangeListener TASK_LIST_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getElement() instanceof ITask) || (updateTask = (AbstractTask)taskContainerDelta.getElement()) == null || PlanningPart.this.getTask() == null || !updateTask.getHandleIdentifier().equals(PlanningPart.this.getTask().getHandleIdentifier()) || PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) continue;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PlanningPart.this.refresh(false);
                    }
                });
            }
        }
    };
    private final ITaskActivityListener timingListener = new TaskActivityAdapter(){

        public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
            if (task.equals(PlanningPart.this.getTask())) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (PlanningPart.this.elapsedTimeText != null && !PlanningPart.this.elapsedTimeText.isDisposed()) {
                            PlanningPart.this.updateElapsedTime();
                        }
                    }
                });
            }
        }
    };
    private CommonTextSupport textSupport;
    private TaskFormPage page;
    private Composite actualTimeComposite;
    private ToolBarManager toolBarManager;
    private boolean needsNotes = true;
    private boolean alwaysExpand;

    public PlanningPart(int sectionStyle) {
        super(sectionStyle, Messages.PersonalPart_Personal_Planning);
    }

    public void initialize(IManagedForm managedForm, TaskRepository taskRepository, AbstractTask task, boolean needsDueDate, TaskFormPage page, CommonTextSupport textSupport) {
        super.initialize(managedForm, taskRepository, task);
        this.needsDueDate = needsDueDate;
        this.page = page;
        this.textSupport = textSupport;
    }

    private boolean notesEqual() {
        if (this.getTask().getNotes() == null && this.notesString == null) {
            return true;
        }
        if (this.getTask().getNotes() != null && this.notesString != null) {
            return this.getTask().getNotes().equals(this.notesString) || this.notesString.equals(PERSONAL_NOTES);
        }
        return false;
    }

    public void commit(boolean onSave) {
        Assert.isNotNull((Object)this.getTask());
        if (!this.notesEqual()) {
            this.getTask().setNotes(this.notesString);
        }
        if (this.scheduleDatePicker != null && this.scheduleDatePicker.getScheduledDate() != null) {
            if (this.getTask().getScheduledForDate() == null || this.getTask().getScheduledForDate() != null && !this.scheduleDatePicker.getScheduledDate().equals((Object)this.getTask().getScheduledForDate()) || this.getTask().getScheduledForDate() instanceof DayDateRange) {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.getTask(), this.scheduleDatePicker.getScheduledDate());
                this.getTask().setReminded(false);
            }
        } else {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.getTask(), null);
            this.getTask().setReminded(false);
        }
        if (this.estimatedTime != null) {
            this.getTask().setEstimatedTimeHours(this.estimatedTime.getSelection());
        }
        if (this.dueDatePicker != null && this.dueDatePicker.getDate() != null) {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.getTask(), this.dueDatePicker.getDate().getTime());
        } else {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.getTask(), null);
        }
        super.commit(onSave);
    }

    public Control createControl(Composite parent, FormToolkit toolkit) {
        this.notesString = this.getTask().getNotes();
        if (this.notesString == null) {
            this.notesString = "";
        }
        Section section = this.createSection(parent, toolkit, this.isAlwaysExpand() || this.notesString.length() > 0);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = this.needsDueDate ? 6 : 4;
        composite.setLayout((Layout)layout);
        this.createScheduledDatePicker(toolkit, composite);
        if (this.needsDueDate) {
            this.createDueDatePicker(toolkit, composite);
        }
        this.createEstimatedTime(toolkit, composite);
        TasksUiInternal.getTaskList().addChangeListener(this.TASK_LIST_LISTENER);
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.timingListener);
        if (this.needsNotes()) {
            this.createNotesArea(toolkit, composite, layout.numColumns);
        }
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.setSection(toolkit, section);
        CommonUiUtil.setMenu((Composite)composite, (Menu)parent.getMenu());
        return section;
    }

    private void createNotesArea(FormToolkit toolkit, Composite parent, int numColumns) {
        AbstractTaskEditorExtension extension;
        IContextService contextService;
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 1;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().span(numColumns, -1).grab(true, true).applyTo((Control)composite);
        if (this.page != null && (contextService = (IContextService)this.page.getEditorSite().getService(IContextService.class)) != null && (extension = TaskEditorExtensions.getTaskEditorExtension(this.getRepository())) != null) {
            this.noteEditor = new RichTextEditor(this.getRepository(), 8389186, contextService, extension);
        }
        if (this.noteEditor == null) {
            this.noteEditor = new RichTextEditor(this.getRepository(), 8389186);
        }
        this.noteEditor.setSpellCheckingEnabled(true);
        this.noteEditor.createControl(composite, toolkit);
        this.noteEditor.setText(this.notesString);
        this.noteEditor.getControl().setLayoutData((Object)EditorUtil.getTextControlLayoutData(this.page, this.noteEditor.getViewer().getControl(), true));
        this.noteEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.noteEditor.setReadOnly(false);
        if (this.textSupport != null) {
            this.textSupport.install((TextViewer)this.noteEditor.getViewer(), true);
        }
        this.noteEditor.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                PlanningPart.this.notesString = PlanningPart.this.noteEditor.getText();
                if (!PlanningPart.this.notesEqual()) {
                    PlanningPart.this.markDirty();
                }
            }
        });
        this.addNotesLabelText(toolkit, composite);
        toolkit.paintBordersFor(composite);
    }

    private void addNotesLabelText(final FormToolkit toolkit, Composite composite) {
        if (this.notesString.length() == 0) {
            this.notesString = PERSONAL_NOTES;
            this.noteEditor.setText(this.notesString);
        }
        FocusListener removePersonalNotesFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (PlanningPart.this.noteEditor.getText().equals(PERSONAL_NOTES)) {
                    PlanningPart.this.noteEditor.setText("");
                    if (PlanningPart.this.noteEditor.getViewer() != null) {
                        PlanningPart.this.noteEditor.getViewer().getTextWidget().setForeground(toolkit.getColors().getForeground());
                    }
                }
            }

            public void focusLost(FocusEvent e) {
            }
        };
        boolean changeColor = false;
        if (this.noteEditor.getText().equals(PERSONAL_NOTES)) {
            changeColor = true;
        }
        if (this.noteEditor.getViewer() != null) {
            this.noteEditor.getViewer().getTextWidget().addFocusListener(removePersonalNotesFocusListener);
            if (changeColor) {
                this.noteEditor.getViewer().getTextWidget().setForeground(composite.getShell().getDisplay().getSystemColor(15));
            }
        }
    }

    private void createActualTime(FormToolkit toolkit, Composite toolbarComposite) {
        this.actualTimeComposite = toolkit.createComposite(toolbarComposite);
        this.actualTimeComposite.setBackground(null);
        this.actualTimeComposite.setBackgroundMode(2);
        RowLayout rowLayout = new RowLayout();
        EditorUtil.center(rowLayout);
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        this.actualTimeComposite.setLayout((Layout)rowLayout);
        Label label = toolkit.createLabel(this.actualTimeComposite, Messages.TaskEditorPlanningPart_Active);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText(Messages.TaskEditorPlanningPart_Time_working_on_this_task);
        label.setBackground(null);
        Composite nameValueComp = this.createComposite(this.actualTimeComposite, 2, toolkit);
        nameValueComp.setBackground(null);
        this.elapsedTimeText = new Text(nameValueComp, 0x800008);
        this.elapsedTimeText.setFont(EditorUtil.TEXT_FONT);
        this.elapsedTimeText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        toolkit.adapt((Control)this.elapsedTimeText, true, false);
        this.elapsedTimeText.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.elapsedTimeText.setBackground(null);
        this.updateElapsedTime();
        this.elapsedTimeText.setEditable(false);
        ImageHyperlink resetActivityTimeButton = toolkit.createImageHyperlink(nameValueComp, 0);
        resetActivityTimeButton.setBackground(null);
        resetActivityTimeButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        resetActivityTimeButton.setToolTipText(Messages.TaskEditorPlanningPart_Reset);
        resetActivityTimeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (MessageDialog.openConfirm((Shell)PlanningPart.this.getControl().getShell(), (String)Messages.TaskEditorPlanningPart_Confirm_Activity_Time_Deletion, (String)Messages.TaskEditorPlanningPart_Do_you_wish_to_reset_your_activity_time_on_this_task_)) {
                    MonitorUi.getActivityContextManager().removeActivityTime(PlanningPart.this.getTask().getHandleIdentifier(), 0L, System.currentTimeMillis());
                }
            }
        });
    }

    private void updateElapsedTime() {
        String elapsedTimeString;
        long elapsedTime = TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)this.getTask());
        if (elapsedTime > 0L) {
            if (this.actualTimeComposite != null && !this.actualTimeComposite.isVisible()) {
                this.actualTimeComposite.setVisible(true);
            }
        } else if (this.actualTimeComposite != null) {
            this.actualTimeComposite.setVisible(false);
        }
        if ((elapsedTimeString = DateUtil.getFormattedDurationShort((long)elapsedTime)).equals("")) {
            elapsedTimeString = Messages.TaskEditorPlanningPart_0_SECOUNDS;
        }
        this.elapsedTimeText.setText(elapsedTimeString);
    }

    private Composite createComposite(Composite parent, int col, FormToolkit toolkit) {
        Composite nameValueComp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        return nameValueComp;
    }

    private void createDueDatePicker(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, Messages.TaskEditorPlanningPart_Due);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.dueDatePicker = new DatePicker(composite, 0x800000, DatePicker.LABEL_CHOOSE, true, 0);
        GridDataFactory.fillDefaults().hint(120, -1).applyTo((Control)this.dueDatePicker);
        this.dueDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.dueDatePicker.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (this.getTask().getDueDate() != null) {
            Calendar calendar = TaskActivityUtil.getCalendar();
            calendar.setTime(this.getTask().getDueDate());
            this.dueDatePicker.setDate(calendar);
        }
        this.dueDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PlanningPart.this.markDirty();
            }
        });
        toolkit.adapt((Control)this.dueDatePicker, false, false);
        toolkit.paintBordersFor(composite);
        ImageHyperlink clearDueDate = toolkit.createImageHyperlink(composite, 0);
        clearDueDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        clearDueDate.setToolTipText(Messages.TaskEditorPlanningPart_Clear);
        clearDueDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PlanningPart.this.dueDatePicker.setDate(null);
                PlanningPart.this.markDirty();
            }
        });
    }

    private void createEstimatedTime(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, Messages.TaskEditorPlanningPart_Estimated);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.estimatedTime = new Spinner(composite, 0x800000);
        this.estimatedTime.setDigits(0);
        this.estimatedTime.setMaximum(100);
        this.estimatedTime.setMinimum(0);
        this.estimatedTime.setIncrement(1);
        this.estimatedTime.setSelection(this.getTask().getEstimatedTimeHours());
        if (!PlatformUtil.spinnerHasNativeBorder()) {
            this.estimatedTime.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        this.estimatedTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PlanningPart.this.getTask().getEstimatedTimeHours() != PlanningPart.this.estimatedTime.getSelection()) {
                    PlanningPart.this.markDirty();
                }
            }
        });
        ImageHyperlink clearEstimated = toolkit.createImageHyperlink(composite, 0);
        clearEstimated.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        clearEstimated.setToolTipText(Messages.TaskEditorPlanningPart_Clear);
        clearEstimated.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PlanningPart.this.estimatedTime.setSelection(0);
                PlanningPart.this.markDirty();
            }
        });
        toolkit.paintBordersFor(composite);
    }

    private void createScheduledDatePicker(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, Messages.TaskEditorPlanningPart_Scheduled);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.scheduleDatePicker = new ScheduleDatePicker(composite, this.getTask(), 0x800000);
        GridDataFactory.fillDefaults().hint(120, -1).applyTo((Control)this.scheduleDatePicker);
        this.scheduleDatePicker.setData("FormWidgetFactory.drawBorder", "textBorder");
        toolkit.adapt((Control)this.scheduleDatePicker, false, false);
        toolkit.paintBordersFor(composite);
        this.scheduleDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.scheduleDatePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PlanningPart.this.markDirty();
            }
        });
        ImageHyperlink clearScheduledDate = toolkit.createImageHyperlink(composite, 0);
        clearScheduledDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        clearScheduledDate.setToolTipText(Messages.TaskEditorPlanningPart_Clear);
        clearScheduledDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PlanningPart.this.scheduleDatePicker.setScheduledDate(null);
                PlanningPart.this.getTask().setReminded(false);
                PlanningPart.this.markDirty();
            }
        });
    }

    public void dispose() {
        TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.timingListener);
        TasksUiInternal.getTaskList().removeChangeListener(this.TASK_LIST_LISTENER);
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
        }
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        if (section.getTextClient() == null) {
            Composite toolbarComposite = toolkit.createComposite((Composite)section);
            toolbarComposite.setBackground(null);
            RowLayout rowLayout = new RowLayout();
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            EditorUtil.center(rowLayout);
            toolbarComposite.setLayout((Layout)rowLayout);
            this.createActualTime(toolkit, toolbarComposite);
            this.fillToolbar(toolbarComposite);
            section.setTextClient((Control)toolbarComposite);
        }
        super.setSection(toolkit, section);
    }

    private void fillToolbar(Composite parent) {
    }

    public boolean needsNotes() {
        return this.needsNotes;
    }

    public void setNeedsNotes(boolean needsNotes) {
        this.needsNotes = needsNotes;
    }

    public boolean isAlwaysExpand() {
        return this.alwaysExpand;
    }

    public void setAlwaysExpand(boolean alwaysExpand) {
        this.alwaysExpand = alwaysExpand;
    }

    protected void refresh(boolean discardChanges) {
        if (this.scheduleDatePicker != null && !this.scheduleDatePicker.isDisposed()) {
            if (this.getTask().getScheduledForDate() != null) {
                this.scheduleDatePicker.setScheduledDate(this.getTask().getScheduledForDate());
            } else {
                this.scheduleDatePicker.setScheduledDate(null);
            }
        }
        if (this.estimatedTime != null && !this.estimatedTime.isDisposed()) {
            this.estimatedTime.setSelection(this.getTask().getEstimatedTimeHours());
        }
    }
}

