/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SourceFile {
    private static final int DEFAULT_SIZE = 100;
    private SourceFileDataSource dataSource;
    private byte[] data;
    private int[] lineNumberMap;
    private int numLines;

    private static int intValueOf(byte b) {
        return b & 0xFF;
    }

    public SourceFile(SourceFileDataSource dataSource) {
        this.dataSource = dataSource;
        this.lineNumberMap = new int[100];
        this.numLines = 0;
    }

    public String getFullFileName() {
        return this.dataSource.getFullFileName();
    }

    public InputStream getInputStream() throws IOException {
        this.loadFileData();
        return new ByteArrayInputStream(this.data);
    }

    public InputStream getInputStreamFromOffset(int offset) throws IOException {
        this.loadFileData();
        return new ByteArrayInputStream(this.data, offset, this.data.length - offset);
    }

    public void addLineOffset(int offset) {
        if (this.numLines >= this.lineNumberMap.length) {
            int capacity = this.lineNumberMap.length * 2;
            int[] newLineNumberMap = new int[capacity];
            System.arraycopy(this.lineNumberMap, 0, newLineNumberMap, 0, this.lineNumberMap.length);
            this.lineNumberMap = newLineNumberMap;
        }
        this.lineNumberMap[this.numLines++] = offset;
    }

    public int getLineOffset(int line) {
        try {
            this.loadFileData();
        }
        catch (IOException e) {
            System.err.println("SourceFile.getLineOffset: " + e.getMessage());
            return -1;
        }
        if (line < 0 || line >= this.numLines) {
            return -1;
        }
        return this.lineNumberMap[line];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadFileData() throws IOException {
        if (this.data != null) {
            return;
        }
        InputStream in = null;
        try {
            int n;
            in = this.dataSource.open();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.addLineOffset(0);
            LineNumberMapBuilder mapBuilder = new LineNumberMapBuilder(this);
            byte[] buf = new byte[1024];
            while ((n = in.read(buf)) >= 0) {
                mapBuilder.addData(buf, n);
                out.write(buf, 0, n);
            }
            mapBuilder.eof();
            this.setData(out.toByteArray());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void setData(byte[] data) {
        this.data = data;
    }

    private static class LineNumberMapBuilder {
        private SourceFile sourceFile;
        private int offset;
        private int lastSeen;

        public LineNumberMapBuilder(SourceFile sourceFile) {
            this.sourceFile = sourceFile;
            this.offset = 0;
            this.lastSeen = -1;
        }

        public void addData(byte[] data, int len) {
            for (int i = 0; i < len; ++i) {
                int ch = SourceFile.intValueOf(data[i]);
                this.add(ch);
            }
        }

        public void eof() {
            this.add(-1);
        }

        private void add(int ch) {
            switch (ch) {
                case 10: {
                    this.sourceFile.addLineOffset(this.offset + 1);
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    if (this.lastSeen != 13) break;
                    this.sourceFile.addLineOffset(this.offset);
                }
            }
            this.lastSeen = ch;
            ++this.offset;
        }
    }
}

