/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.AndMatcher;
import edu.umd.cs.findbugs.filter.BugMatcher;
import edu.umd.cs.findbugs.filter.ClassMatcher;
import edu.umd.cs.findbugs.filter.CompoundMatcher;
import edu.umd.cs.findbugs.filter.DesignationMatcher;
import edu.umd.cs.findbugs.filter.FirstVersionMatcher;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.OrMatcher;
import edu.umd.cs.findbugs.filter.PriorityMatcher;
import edu.umd.cs.findbugs.filter.RelationalOp;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.Sortables;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactory {
    public static Matcher makeOrMatcher(Collection<BugAspects.SortableValue> sortables) {
        return FilterFactory.makeMatcher(sortables, false);
    }

    public static Matcher makeAndMatcher(Collection<BugAspects.SortableValue> sortables) {
        return FilterFactory.makeMatcher(sortables, true);
    }

    private static Matcher makeMatcher(Collection<BugAspects.SortableValue> sortables, boolean andOr) {
        Iterator<BugAspects.SortableValue> i$;
        if (sortables.size() == 1 && (i$ = sortables.iterator()).hasNext()) {
            BugAspects.SortableValue s = i$.next();
            return FilterFactory.makeMatcher(s);
        }
        CompoundMatcher matcher = andOr ? new AndMatcher() : new OrMatcher();
        for (BugAspects.SortableValue s : sortables) {
            matcher.addChild(FilterFactory.makeMatcher(s));
        }
        return matcher;
    }

    public static Matcher makeMatcher(Collection<Sortables> sortables, BugInstance bug) {
        Iterator<Sortables> i$;
        if (sortables.size() == 1 && (i$ = sortables.iterator()).hasNext()) {
            Sortables s = i$.next();
            return FilterFactory.makeMatcher(s, bug);
        }
        AndMatcher matcher = new AndMatcher();
        for (Sortables s : sortables) {
            matcher.addChild(FilterFactory.makeMatcher(s, bug));
        }
        return matcher;
    }

    private static Matcher makeMatcher(Sortables s, BugInstance bug) {
        switch (s) {
            case BUGCODE: {
                return new BugMatcher(s.getFrom(bug), null, null);
            }
            case CATEGORY: {
                return new BugMatcher(null, null, s.getFrom(bug));
            }
            case CLASS: {
                return new ClassMatcher(s.getFrom(bug));
            }
            case DESIGNATION: {
                return new DesignationMatcher(s.getFrom(bug));
            }
            case FIRSTVERSION: {
                return new FirstVersionMatcher(s.getFrom(bug), RelationalOp.EQ);
            }
            case LASTVERSION: {
                return new LastVersionMatcher(s.getFrom(bug), RelationalOp.EQ);
            }
            case PACKAGE: {
                String p = Sortables.CLASS.getFrom(bug);
                int lastDot = p.lastIndexOf(46);
                if (lastDot > 0) {
                    p = p.substring(0, lastDot);
                }
                return new ClassMatcher("~" + p + "\\.[^.]+");
            }
            case PRIORITY: {
                return new PriorityMatcher(Integer.toString(bug.getPriority()));
            }
            case TYPE: {
                return new BugMatcher(null, s.getFrom(bug), null);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Matcher makeMatcher(BugAspects.SortableValue sv) {
        Sortables s = sv.key;
        String value = sv.value;
        switch (s) {
            case BUGCODE: {
                return new BugMatcher(value, null, null);
            }
            case CATEGORY: {
                return new BugMatcher(null, null, value);
            }
            case CLASS: {
                return new ClassMatcher(value);
            }
            case DESIGNATION: {
                return new DesignationMatcher(value);
            }
            case FIRSTVERSION: {
                return new FirstVersionMatcher(value, RelationalOp.EQ);
            }
            case LASTVERSION: {
                return new LastVersionMatcher(value, RelationalOp.EQ);
            }
            case PACKAGE: {
                return new ClassMatcher("~" + value + "\\.[^.]+");
            }
            case PRIORITY: {
                return new PriorityMatcher(value);
            }
            case TYPE: {
                return new BugMatcher(null, value, null);
            }
        }
        throw new IllegalArgumentException();
    }
}

