/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.FieldInfo;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreorderVisitor
extends BetterVisitor
implements Constants2 {
    private ConstantPool constantPool;
    private JavaClass thisClass;
    private ClassInfo thisClassInfo;
    private MethodInfo thisMethodInfo;
    private FieldInfo thisFieldInfo;
    private String className = "none";
    private String dottedClassName = "none";
    private String packageName = "none";
    private String sourceFile = "none";
    private String superclassName = "none";
    private String dottedSuperclassName = "none";
    private boolean visitingMethod = false;
    private String methodSig = "none";
    private String dottedMethodSig = "none";
    private Method method = null;
    private String methodName = "none";
    private String fullyQualifiedMethodName = "none";
    private Field field;
    private boolean visitingField = false;
    private String fullyQualifiedFieldName = "none";
    private String fieldName = "none";
    private String fieldSig = "none";
    private String dottedFieldSig = "none";
    private boolean fieldIsStatic;
    private Code code;
    static Pattern argumentSignature = Pattern.compile("\\[*([BCDFIJSZ]|L[^;]*;)");

    protected String getStringFromIndex(int i) {
        ConstantUtf8 name = (ConstantUtf8)this.constantPool.getConstant(i);
        return name.getBytes();
    }

    protected int asUnsignedByte(byte b) {
        return 0xFF & b;
    }

    public Code getCode() {
        if (this.code == null) {
            throw new IllegalStateException("Not visiting Code");
        }
        return this.code;
    }

    public Set<String> getSurroundingCaughtExceptions(int pc) {
        HashSet<String> result = new HashSet<String>();
        if (this.code == null) {
            throw new IllegalStateException("Not visiting Code");
        }
        int size = Integer.MAX_VALUE;
        if (this.code.getExceptionTable() == null) {
            return result;
        }
        for (CodeException catchBlock : this.code.getExceptionTable()) {
            int startPC = catchBlock.getStartPC();
            int endPC = catchBlock.getEndPC();
            if (pc < startPC || pc > endPC) continue;
            int thisSize = endPC - startPC;
            if (size > thisSize) {
                result.clear();
                size = thisSize;
                result.add("C" + catchBlock.getCatchType());
                continue;
            }
            if (size != thisSize) continue;
            result.add("C" + catchBlock.getCatchType());
        }
        return result;
    }

    public int getSizeOfSurroundingTryBlock(int pc) {
        return this.getSizeOfSurroundingTryBlock(null, pc);
    }

    public int getSizeOfSurroundingTryBlock(String vmNameOfExceptionClass, int pc) {
        if (this.code == null) {
            throw new IllegalStateException("Not visiting Code");
        }
        return Util.getSizeOfSurroundingTryBlock(this.constantPool, this.code, vmNameOfExceptionClass, pc);
    }

    @Override
    public void visitCode(Code obj) {
        Attribute[] attributes;
        CodeException[] exceptions;
        this.code = obj;
        super.visitCode(obj);
        for (CodeException exception : exceptions = obj.getExceptionTable()) {
            exception.accept(this);
        }
        for (Attribute attribute : attributes = obj.getAttributes()) {
            attribute.accept(this);
        }
        this.code = null;
    }

    @Override
    public void visitConstantPool(ConstantPool obj) {
        super.visitConstantPool(obj);
        Constant[] constant_pool = obj.getConstantPool();
        for (int i = 1; i < constant_pool.length; ++i) {
            constant_pool[i].accept(this);
            byte tag = constant_pool[i].getTag();
            if (tag != 6 && tag != 5) continue;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVisitField(Field field) {
        if (this.visitingField) {
            throw new IllegalStateException("visitField called when already visiting a field");
        }
        this.visitingField = true;
        this.field = field;
        try {
            Attribute[] attributes;
            this.fullyQualifiedFieldName = null;
            this.dottedFieldSig = null;
            this.fieldSig = null;
            this.fieldName = null;
            this.thisFieldInfo = (FieldInfo)this.thisClassInfo.findField(this.getFieldName(), this.getFieldSig(), field.isStatic());
            if (this.thisFieldInfo == null) {
                throw new AssertionError((Object)("Can't get field info for " + this.getFullyQualifiedFieldName()));
            }
            this.fieldIsStatic = field.isStatic();
            field.accept(this);
            for (Attribute attribute : attributes = field.getAttributes()) {
                attribute.accept(this);
            }
        }
        finally {
            this.visitingField = false;
            this.field = null;
            this.thisFieldInfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVisitMethod(Method method) {
        if (this.visitingMethod) {
            throw new IllegalStateException("doVisitMethod called when already visiting a method");
        }
        this.visitingMethod = true;
        try {
            Attribute[] attributes;
            this.method = method;
            this.fullyQualifiedMethodName = null;
            this.dottedMethodSig = null;
            this.methodSig = null;
            this.methodName = null;
            this.thisMethodInfo = (MethodInfo)this.thisClassInfo.findMethod(this.getMethodName(), this.getMethodSig(), method.isStatic());
            if (this.thisMethodInfo == null) {
                throw new AssertionError((Object)("Can't get method info for " + this.getFullyQualifiedMethodName()));
            }
            this.method.accept(this);
            for (Attribute attribute : attributes = method.getAttributes()) {
                attribute.accept(this);
            }
        }
        finally {
            this.visitingMethod = false;
            this.method = null;
            this.thisMethodInfo = null;
        }
    }

    public boolean amVisitingMainMethod() {
        if (!this.visitingMethod) {
            throw new IllegalStateException("Not visiting a method");
        }
        if (!this.method.isStatic()) {
            return false;
        }
        if (!this.getMethodName().equals("main")) {
            return false;
        }
        return this.getMethodSig().equals("([Ljava/lang/String;)V");
    }

    @Override
    public void visitInnerClasses(InnerClasses obj) {
        InnerClass[] inner_classes;
        super.visitInnerClasses(obj);
        for (InnerClass inner_class : inner_classes = obj.getInnerClasses()) {
            inner_class.accept(this);
        }
    }

    public void visitAfter(JavaClass obj) {
    }

    public boolean shouldVisit(JavaClass obj) {
        return true;
    }

    @Override
    public void visitJavaClass(JavaClass obj) {
        this.setupVisitorForClass(obj);
        if (this.shouldVisit(obj)) {
            this.constantPool.accept(this);
            Field[] fields = obj.getFields();
            Method[] methods = obj.getMethods();
            Attribute[] attributes = obj.getAttributes();
            for (Field field : fields) {
                this.doVisitField(field);
            }
            for (FieldOrMethod fieldOrMethod : methods) {
                this.doVisitMethod((Method)fieldOrMethod);
            }
            for (Node node : attributes) {
                ((Attribute)node).accept(this);
            }
            this.visitAfter(obj);
        }
    }

    public void setupVisitorForClass(JavaClass obj) {
        this.constantPool = obj.getConstantPool();
        this.thisClass = obj;
        ConstantClass c = (ConstantClass)this.constantPool.getConstant(obj.getClassNameIndex());
        this.className = this.getStringFromIndex(c.getNameIndex());
        this.dottedClassName = this.className.replace('/', '.');
        this.packageName = obj.getPackageName();
        this.sourceFile = obj.getSourceFileName();
        this.dottedSuperclassName = obj.getSuperclassName();
        this.superclassName = this.dottedSuperclassName.replace('.', '/');
        ClassDescriptor cDesc = DescriptorFactory.createClassDescriptor(this.className);
        try {
            this.thisClassInfo = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(XClass.class, cDesc);
        }
        catch (CheckedAnalysisException e) {
            throw new AssertionError((Object)("Can't find ClassInfo for " + cDesc));
        }
        super.visitJavaClass(obj);
    }

    @Override
    public void visitLineNumberTable(LineNumberTable obj) {
        LineNumber[] line_number_table;
        super.visitLineNumberTable(obj);
        for (LineNumber aLine_number_table : line_number_table = obj.getLineNumberTable()) {
            aLine_number_table.accept(this);
        }
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable obj) {
        LocalVariable[] local_variable_table;
        super.visitLocalVariableTable(obj);
        for (LocalVariable aLocal_variable_table : local_variable_table = obj.getLocalVariableTable()) {
            aLocal_variable_table.accept(this);
        }
    }

    public XClass getXClass() {
        if (this.thisClassInfo == null) {
            throw new AssertionError((Object)"XClass information not set");
        }
        return this.thisClassInfo;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.thisClassInfo;
    }

    public XMethod getXMethod() {
        return this.thisMethodInfo;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.thisMethodInfo;
    }

    public XField getXField() {
        return this.thisFieldInfo;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.thisFieldInfo;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @SlashedClassName
    public String getClassName() {
        return this.className;
    }

    @DottedClassName
    public String getDottedClassName() {
        return this.dottedClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    @SlashedClassName
    public String getSuperclassName() {
        return this.superclassName;
    }

    @DottedClassName
    public String getDottedSuperclassName() {
        return this.dottedSuperclassName;
    }

    public JavaClass getThisClass() {
        return this.thisClass;
    }

    public String getFullyQualifiedMethodName() {
        if (!this.visitingMethod) {
            throw new IllegalStateException("getFullyQualifiedMethodName called while not visiting method");
        }
        if (this.fullyQualifiedMethodName == null) {
            this.getDottedSuperclassName();
            this.getMethodName();
            this.getDottedMethodSig();
            StringBuilder ref = new StringBuilder(5 + this.dottedClassName.length() + this.methodName.length() + this.dottedMethodSig.length());
            ref.append(this.dottedClassName).append(".").append(this.methodName).append(" : ").append(this.dottedMethodSig);
            this.fullyQualifiedMethodName = ref.toString();
        }
        return this.fullyQualifiedMethodName;
    }

    public boolean visitingMethod() {
        return this.visitingMethod;
    }

    public boolean visitingField() {
        return this.visitingField;
    }

    public Field getField() {
        if (!this.visitingField) {
            throw new IllegalStateException("getField called while not visiting method");
        }
        return this.field;
    }

    public Method getMethod() {
        if (!this.visitingMethod) {
            throw new IllegalStateException("getMethod called while not visiting method");
        }
        return this.method;
    }

    public String getMethodName() {
        if (!this.visitingMethod) {
            throw new IllegalStateException("getMethodName called while not visiting method");
        }
        if (this.methodName == null) {
            this.methodName = this.getStringFromIndex(this.method.getNameIndex());
        }
        return this.methodName;
    }

    public static int getNumberArguments(String signature) {
        int count = 0;
        int pos = 1;
        boolean inArray = false;
        block5: while (true) {
            switch (signature.charAt(pos++)) {
                case ')': {
                    return count;
                }
                case '[': {
                    if (!inArray) {
                        ++count;
                    }
                    inArray = true;
                    continue block5;
                }
                case 'L': {
                    if (!inArray) {
                        ++count;
                    }
                    while (signature.charAt(pos) != ';') {
                        ++pos;
                    }
                    ++pos;
                    inArray = false;
                    continue block5;
                }
            }
            if (!inArray) {
                ++count;
            }
            inArray = false;
        }
    }

    public int getNumberMethodArguments() {
        return PreorderVisitor.getNumberArguments(this.getMethodSig());
    }

    public String getMethodSig() {
        if (!this.visitingMethod) {
            throw new IllegalStateException("getMethodSig called while not visiting method");
        }
        if (this.methodSig == null) {
            this.methodSig = this.getStringFromIndex(this.method.getSignatureIndex());
        }
        return this.methodSig;
    }

    public String getDottedMethodSig() {
        if (!this.visitingMethod) {
            throw new IllegalStateException("getDottedMethodSig called while not visiting method");
        }
        if (this.dottedMethodSig == null) {
            this.dottedMethodSig = this.getMethodSig().replace('/', '.');
        }
        return this.dottedMethodSig;
    }

    public String getFieldName() {
        if (!this.visitingField) {
            throw new IllegalStateException("getFieldName called while not visiting field");
        }
        if (this.fieldName == null) {
            this.fieldName = this.getStringFromIndex(this.field.getNameIndex());
        }
        return this.fieldName;
    }

    public String getFieldSig() {
        if (!this.visitingField) {
            throw new IllegalStateException("getFieldSig called while not visiting field");
        }
        if (this.fieldSig == null) {
            this.fieldSig = this.getStringFromIndex(this.field.getSignatureIndex());
        }
        return this.fieldSig;
    }

    public boolean getFieldIsStatic() {
        if (!this.visitingField) {
            throw new IllegalStateException("getFieldIsStatic called while not visiting field");
        }
        return this.fieldIsStatic;
    }

    public String getFullyQualifiedFieldName() {
        if (!this.visitingField) {
            throw new IllegalStateException("getFullyQualifiedFieldName called while not visiting field");
        }
        if (this.fullyQualifiedFieldName == null) {
            this.fullyQualifiedFieldName = this.getDottedClassName() + "." + this.getFieldName() + " : " + this.getFieldSig();
        }
        return this.fullyQualifiedFieldName;
    }

    @Deprecated
    public String getDottedFieldSig() {
        if (!this.visitingField) {
            throw new IllegalStateException("getDottedFieldSig called while not visiting field");
        }
        if (this.dottedFieldSig == null) {
            this.dottedFieldSig = this.fieldSig.replace('/', '.');
        }
        return this.dottedFieldSig;
    }
}

