/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.explorer.Grouping;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class GroupByAction
implements IViewActionDelegate {
    private static final String ACTION_ID_PREFIX = "findBugsEclipsePlugin.toggleGrouping.";
    private CommonNavigator navigator;

    public void init(IViewPart view) {
        if (view instanceof CommonNavigator) {
            this.navigator = (CommonNavigator)view;
        }
    }

    public void run(IAction action) {
        if (this.navigator == null) {
            return;
        }
        Grouping grouping = this.getGrouping(action.getId());
        if (grouping == null) {
            return;
        }
        BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
        provider.setGrouping(grouping);
        CommonViewer viewer = this.navigator.getCommonViewer();
        Object[] expandedElements = viewer.getExpandedElements();
        provider.reSetInput();
        viewer.setExpandedElements(expandedElements);
    }

    private Grouping getGrouping(String id) {
        if (id == null) {
            return null;
        }
        if (!id.startsWith(ACTION_ID_PREFIX)) {
            return null;
        }
        id = id.substring(ACTION_ID_PREFIX.length());
        String[] typesArr = id.split("\\.");
        ArrayList<GroupType> types = new ArrayList<GroupType>();
        for (String string : typesArr) {
            GroupType type = GroupType.valueOf(string);
            types.add(type);
        }
        return Grouping.createFrom(types);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

