/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.DeltaInfo;
import de.tobject.findbugs.view.explorer.IViewerRefreshJob;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;

final class ResourceChangeListener
implements IResourceChangeListener {
    static final int SHORT_DELAY = 250;
    static final int LONG_DELAY = 750;
    final IViewerRefreshJob refreshJob;

    ResourceChangeListener(IViewerRefreshJob refreshJob) {
        this.refreshJob = refreshJob;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas;
        boolean postBuild = event.getType() == 16;
        boolean accepted = false;
        for (IMarkerDelta mdelta : markerDeltas = event.findMarkerDeltas("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true)) {
            IMarker marker = mdelta.getMarker();
            if (marker == null) continue;
            DeltaInfo deltaInfo = new DeltaInfo(marker, mdelta.getKind());
            if (BugContentProvider.DEBUG) {
                System.out.println("resource change for: " + deltaInfo);
            }
            accepted |= this.refreshJob.addToQueue(deltaInfo);
        }
        if (!accepted) {
            return;
        }
        if (postBuild) {
            this.scheduleRefreshJob(250);
        } else {
            this.scheduleRefreshJob(750);
        }
    }

    void scheduleRefreshJob(int delay) {
        this.refreshJob.schedule(delay);
    }
}

