/* The following code was generated by JFlex 1.3.5 on 11/14/02 11:44 AM */

/* HTMLLexer1.java is a generated file.  You probably want to
 * edit HTMLLexer1.lex to make changes.  Use JFlex to generate it.
 * To generate HTMLLexer1.java
 * Install <a href="http://jflex.de/">JFlex</a> v1.3.2 or later.
 * Once JFlex is in your classpath run<br>
 * <code>java JFlex.Main HTMLLexer1.lex</code><br>
 * You will then have a file called HTMLLexer1.java
 */

/*
 * This file is part of a <a href="http://ostermiller.org/syntax/">syntax
 * highlighting</a> package.
 * Copyright (C) 1999-2002 Stephen Ostermiller
 * http://ostermiller.org/contact.pl?regarding=Syntax+Highlighting
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * See COPYING.TXT for details.
 */

package com.Ostermiller.Syntax.Lexer;

import java.io.*;

/** 
 * HTMLLexer1 is a html 2.0 lexer.  Created with JFlex.  An example of how it is used:
 *  <CODE>
 *  <PRE>
 *  HTMLLexer1 shredder = new HTMLLexer1(System.in);
 *  HTMLToken1 t;
 *  while ((t = shredder.getNextToken()) != null){
 *      System.out.println(t);
 *  }
 *  </PRE>
 *  </CODE>
 *
 * <P>
 * There are two HTML Lexers that come with this package.  HTMLLexer is a basic HTML lexer
 * that knows the difference between tags, text, and comments.  HTMLLexer1 knows something
 * about the structure of tags and can return names and values from name value pairs.  It 
 * also knows about text elements such as words and character references.  The two are
 * similar but which you should use depends on your purpose.  In my opinion the HTMLLexer1
 * is much better for syntax highlighting.
 * 
 * @see HTMLLexer
 * @see HTMLToken1
 */ 


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 11/14/02 11:44 AM from the specification file
 * <tt>file:/home/steveo/personal/projects/java/com/Ostermiller/Syntax/Lexer/HTMLLexer1.lex</tt>
 */
public class HTMLLexer1 implements Lexer {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int START_SCRIPT_VALUE = 9;
  final public static int PRE_TAG = 11;
  final public static int TAG = 4;
  final public static int COMMENT_DEF = 21;
  final public static int TEXTAREA = 18;
  final public static int START_PRE_EQUAL = 12;
  final public static int START_END_TAG = 2;
  final public static int START_PRE_VALUE = 13;
  final public static int TEXTAREA_TAG = 15;
  final public static int SCRIPT = 10;
  final public static int START_TEXTAREA_EQUAL = 16;
  final public static int START_TEXTAREA_VALUE = 17;
  final public static int TAG_END = 19;
  final public static int START_EQUAL = 5;
  final public static int FINISH_END_TAG = 22;
  final public static int START_TAG = 1;
  final public static int SCRIPT_TAG = 7;
  final public static int START_VALUE = 6;
  final public static int PRE = 14;
  final public static int START_DOC_TAG = 3;
  final public static int YYINITIAL = 0;
  final public static int START_SCRIPT_EQUAL = 8;
  final public static int DOCTYPE = 20;

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  4,  0,  5,  4,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     4, 64, 60,  6,  0, 67, 57, 61,  0,  0,  0,  0,  0, 68, 62, 63, 
     1, 32, 30, 31, 33,  1,  1,  1,  1,  1,  0, 58, 59, 69, 65, 66, 
     0, 34, 46, 36, 48, 35,  3, 47, 39, 37,  2, 50, 51, 52, 40, 41, 
    53,  2, 44, 54, 38, 42,  2,  2,  7, 43, 49,  0,  0,  0,  0,  0, 
     0, 24,  9, 15, 20, 13, 26, 29, 28, 12, 56, 50, 16, 25,  8, 18, 
    11, 27, 21, 10, 17, 19, 23, 55, 14, 22, 45,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  };

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    70,   140,   210,   280,   350,   420,   490,   560,   630, 
      700,   770,   840,   910,   980,  1050,  1120,  1190,  1260,  1330, 
     1400,  1470,  1540,  1610,  1680,  1750,  1820,  1890,  1960,  2030, 
     2100,  2170,  2240,  2310,  1890,  2380,  2450,  2240,  2520,  2590, 
     2240,  2240,  2660,  2730,  2800,  2870,  2940,  2240,  3010,  2240, 
     3080,  3150,  3220,  2240,  3290,  3360,  3430,  3500,  2240,  2240, 
     3570,  3640,  3710,  3780,  3850,  3920,  3990,  2240,  2240,  4060, 
     4130,  4200,  4270,  4340,  4410,  4480,  4550,  4620,  2240,  1680, 
     4690,  4760,  4830,  4900,  4970,  5040,  5110,  5180,  5250,  5320, 
     5390,  5460,  5530,  5600,  5670,  5740,  5810,  5880,  5950,  6020, 
     6090,  6160,  6230,  6300,  6370,  6440,  6510,  6580,  6650,  6720, 
     6790,  6860,  6930,  7000,  7070,  7140,  7210,  7280,  7350,  7420, 
     7490,  7560,  7630,  7700,  2240,  2240,  7770,  7840,  7910,  7980, 
     8050,  2380,  8120,  8190,  8260,  8330,  2240,  2240,  3150,  2240, 
     3220,  8400,  8470,  8540,  2240,  3640,  2240,  3710,  8610,  8680, 
     2240,  2240,  4200,  2240,  4270,  8750,  8820,  4550,  4620,  8890, 
     8960,  9030,  9100,  9170,  9240,  9310,  9380,  9450,  9520,  9590, 
     9660,  9730,  9800,  9870,  9940, 10010, 10080, 10150, 10220, 10290, 
    10360, 10430, 10500, 10570, 10640, 10710, 10780, 10850, 10920, 10990, 
    11060, 11130, 11200, 11270, 11340, 11410, 11480, 11550, 11620, 11690, 
    11760, 11830, 11900, 11970, 12040, 12110, 12180, 12250, 12320, 12390, 
    12460, 12530, 12600, 12670, 12740, 12810, 12880, 12950, 13020, 13090, 
    13160, 13230, 13300, 13370, 13440, 13510, 13580, 13650, 13720, 13790, 
    13860, 13930, 14000, 14070, 14140, 14210, 14280, 14350, 14420, 14490, 
    14560, 14630, 14700, 14770, 14840, 14910, 14980, 15050, 15120, 15190, 
    15260, 15330, 15400, 15470, 15540, 15610, 15680, 15750, 15820, 15890, 
    15960,  1960, 16030, 16100, 16170, 16240, 16310, 16380, 16450, 16520, 
    16590, 16660, 16730,  2240, 16800, 16870, 16940, 17010, 17080, 17150, 
    17220, 17290, 17360, 17430, 17500, 17570, 17640, 17710, 17780, 17850, 
    17920, 17990, 18060, 18130, 18200, 18270, 18340, 18410, 18480, 18550, 
    18620, 18690, 18760, 18830, 18900, 18970, 19040, 19110, 19180, 19250, 
    19320, 19390, 19460, 19530, 19600, 19670, 19740, 19810, 19880, 19950, 
    20020, 20090, 20160, 20230, 20300, 20370, 20440, 20510, 20580, 20650, 
    20720, 20790, 20860, 20930, 21000, 21070, 21140, 21210, 21280, 21350, 
    21420, 21490, 21560, 21630, 21700,  2240, 21770, 21840, 21910, 21980, 
     2240, 22050, 22120, 22190, 22260, 22330, 22400, 22470, 22540, 22610, 
    22680, 22750, 22820, 22890, 22960, 23030, 23100, 23170, 23240, 23310, 
    23380, 23450, 23520, 23590, 23660, 23730, 23800, 23870, 23940, 24010, 
    24080, 24150, 24220, 24290, 24360, 24430, 24500, 24570, 24640, 24710, 
    24780, 24850, 24920, 24990, 25060, 25130, 25200,  1960, 25270, 25340, 
    25410, 25480, 25550, 25620, 25690,  2240, 25760, 25830, 25900, 25970, 
    26040,  2240, 26110, 26180, 26250, 26320, 26390,  1960, 26460, 26530, 
    26600, 26670, 26740, 26810, 26880, 26950, 27020, 27090, 27160, 27230, 
    27300, 27370, 27440, 27510, 27580, 27650,  2240, 27720
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\4\30\2\31\63\30\1\32\1\30\1\33\12\30\2\34"+
    "\2\35\3\34\3\35\1\36\1\37\5\35\1\40\14\35"+
    "\4\34\4\35\1\40\16\35\1\37\1\36\2\35\10\34"+
    "\1\41\6\34\2\42\1\31\2\34\27\42\4\34\27\42"+
    "\10\34\1\41\4\34\4\43\1\44\17\43\1\45\33\43"+
    "\1\45\20\43\1\46\2\43\1\47\1\43\1\34\3\50"+
    "\1\31\2\34\62\50\5\34\1\50\2\34\1\51\2\34"+
    "\1\50\2\34\3\50\1\31\2\34\62\50\5\34\1\50"+
    "\2\34\1\51\2\34\1\50\1\52\1\34\3\53\1\31"+
    "\2\34\62\53\3\34\1\54\1\55\1\53\2\34\1\41"+
    "\2\34\1\53\1\34\1\56\3\57\1\31\2\56\62\57"+
    "\5\56\1\57\2\56\1\60\2\56\1\57\1\56\1\61"+
    "\3\57\1\31\2\61\62\57\5\61\1\57\2\61\1\60"+
    "\2\61\1\57\1\62\1\56\3\63\1\31\2\56\62\63"+
    "\3\56\1\64\1\65\1\63\2\56\1\66\2\56\1\63"+
    "\1\56\73\67\1\70\12\67\1\71\3\72\1\31\2\71"+
    "\62\72\5\71\1\72\2\71\1\73\2\71\1\72\2\71"+
    "\3\72\1\31\2\71\62\72\5\71\1\72\2\71\1\73"+
    "\2\71\1\72\1\74\1\71\3\75\1\31\2\71\62\75"+
    "\3\71\1\76\1\77\1\75\2\71\1\46\2\71\1\75"+
    "\1\71\73\100\1\101\12\100\1\102\3\103\1\31\2\102"+
    "\62\103\5\102\1\103\2\102\1\104\2\102\1\103\2\102"+
    "\3\103\1\31\2\102\62\103\5\102\1\103\2\102\1\104"+
    "\2\102\1\103\1\105\1\106\3\107\1\31\2\106\62\107"+
    "\3\106\1\110\1\111\1\107\2\106\1\46\2\106\1\107"+
    "\1\106\73\112\1\113\12\112\106\46\74\114\1\115\1\116"+
    "\3\114\1\51\4\114\4\117\2\120\73\117\1\51\2\117"+
    "\1\121\1\117\4\34\1\31\74\34\1\51\4\34\4\30"+
    "\2\0\63\30\1\0\1\30\1\0\12\30\4\0\2\31"+
    "\100\0\4\122\1\0\1\122\1\123\1\124\1\125\1\126"+
    "\1\127\1\130\1\131\1\132\1\124\1\133\1\134\1\135"+
    "\1\136\1\137\1\140\1\141\1\142\1\122\1\143\1\144"+
    "\1\145\1\146\1\147\1\150\4\122\1\151\1\152\1\153"+
    "\1\154\1\155\1\122\1\156\1\157\1\160\1\161\1\162"+
    "\1\163\1\164\1\165\1\166\1\164\1\167\1\170\1\171"+
    "\1\172\1\173\1\174\1\122\3\0\12\122\77\0\1\175"+
    "\1\176\1\0\1\177\1\200\2\0\101\34\1\41\4\34"+
    "\1\0\3\35\3\0\62\35\5\0\1\35\5\0\1\35"+
    "\2\0\3\35\3\0\10\35\1\201\24\35\1\201\24\35"+
    "\5\0\1\35\5\0\1\35\2\0\3\35\3\0\16\35"+
    "\1\202\26\35\1\202\14\35\5\0\1\35\5\0\1\35"+
    "\2\0\3\35\3\0\6\35\1\203\25\35\1\203\25\35"+
    "\5\0\1\35\5\0\1\35\110\0\3\42\3\0\62\42"+
    "\5\0\1\42\5\0\1\42\1\0\4\34\1\204\17\34"+
    "\1\205\33\34\1\205\20\34\1\0\2\34\1\206\23\34"+
    "\1\207\26\34\1\207\27\34\1\0\105\34\1\0\2\34"+
    "\1\210\1\34\1\0\3\50\3\0\62\50\5\0\1\50"+
    "\5\0\1\50\2\0\3\53\3\0\62\53\5\0\1\53"+
    "\5\0\1\53\1\0\74\54\1\211\11\54\75\55\1\211"+
    "\10\55\101\56\1\212\4\56\1\0\3\57\3\0\62\57"+
    "\5\0\1\57\5\0\1\57\1\0\101\61\1\66\4\61"+
    "\1\0\3\63\3\0\62\63\5\0\1\63\5\0\1\63"+
    "\1\0\74\213\1\214\11\213\75\215\1\214\10\215\73\67"+
    "\1\216\105\67\1\216\3\67\1\217\1\220\5\67\101\71"+
    "\1\221\4\71\1\0\3\72\3\0\62\72\5\0\1\72"+
    "\5\0\1\72\2\0\3\75\3\0\62\75\5\0\1\75"+
    "\5\0\1\75\1\0\74\222\1\223\11\222\75\224\1\223"+
    "\10\224\73\100\1\225\105\100\1\225\3\100\1\226\6\100"+
    "\101\102\1\227\4\102\1\0\3\103\3\0\62\103\5\0"+
    "\1\103\5\0\1\103\1\0\101\106\1\230\4\106\1\0"+
    "\3\107\3\0\62\107\5\0\1\107\5\0\1\107\1\0"+
    "\74\231\1\232\11\231\75\233\1\232\10\233\73\112\1\234"+
    "\105\112\1\234\3\112\1\235\6\112\74\114\1\236\1\237"+
    "\3\114\1\0\4\114\74\236\1\114\11\236\75\237\1\114"+
    "\10\237\104\0\1\210\1\0\4\122\1\0\64\122\3\0"+
    "\13\122\1\240\2\122\1\0\2\122\1\241\6\122\1\241"+
    "\17\122\4\240\27\122\3\0\16\122\1\0\7\122\1\242"+
    "\54\122\3\0\16\122\1\0\4\122\1\243\1\244\1\122"+
    "\2\242\3\122\1\245\1\246\1\242\1\247\3\122\1\250"+
    "\40\122\3\0\16\122\1\0\10\122\1\251\5\122\1\252"+
    "\1\253\1\254\43\122\3\0\16\122\1\0\4\122\1\253"+
    "\1\122\1\255\1\256\1\257\1\122\1\260\3\122\1\261"+
    "\1\262\7\122\1\263\20\122\1\264\13\122\3\0\16\122"+
    "\1\0\5\122\1\124\1\122\1\265\1\266\2\122\1\267"+
    "\1\122\1\270\2\122\1\271\2\122\1\272\3\122\1\124"+
    "\34\122\3\0\16\122\1\0\3\122\1\273\1\122\1\274"+
    "\2\122\1\275\1\122\1\276\2\122\1\251\1\277\4\122"+
    "\1\300\1\301\1\122\1\302\1\122\1\303\33\122\3\0"+
    "\16\122\1\0\3\122\1\243\2\122\1\304\2\122\1\305"+
    "\1\276\1\122\1\306\1\122\1\307\4\122\1\300\1\310"+
    "\1\122\1\311\1\122\1\303\33\122\3\0\16\122\1\0"+
    "\7\122\1\312\1\313\1\122\1\314\1\315\1\122\1\316"+
    "\1\317\1\122\1\320\2\122\1\321\3\122\1\124\34\122"+
    "\3\0\16\122\1\0\5\122\1\322\2\122\1\242\1\122"+
    "\1\323\1\122\1\242\1\324\1\122\1\253\1\325\2\122"+
    "\1\326\1\122\1\327\7\122\1\330\26\122\3\0\16\122"+
    "\1\0\7\122\1\331\10\122\1\332\2\122\1\171\3\122"+
    "\1\333\34\122\3\0\16\122\1\0\5\122\1\334\1\335"+
    "\1\122\1\264\1\122\1\276\1\336\1\337\1\122\1\277"+
    "\1\122\1\340\2\122\1\300\1\341\3\122\1\303\33\122"+
    "\3\0\16\122\1\0\6\122\1\342\3\122\1\276\3\122"+
    "\1\277\4\122\1\343\1\344\3\122\1\303\4\122\1\330"+
    "\26\122\3\0\16\122\1\0\7\122\1\345\1\346\12\122"+
    "\1\347\11\122\1\330\26\122\3\0\16\122\1\0\5\122"+
    "\1\322\2\122\1\350\1\122\1\323\1\325\3\122\1\253"+
    "\3\122\1\351\1\122\1\327\1\122\1\352\5\122\1\330"+
    "\26\122\3\0\16\122\1\0\10\122\1\353\5\122\1\277"+
    "\4\122\1\300\40\122\3\0\16\122\1\0\3\122\1\354"+
    "\1\122\1\355\2\122\1\264\1\122\1\356\1\357\1\245"+
    "\1\122\1\277\1\122\1\360\2\122\1\300\1\321\3\122"+
    "\1\303\33\122\3\0\16\122\1\0\7\122\1\361\6\122"+
    "\1\242\1\247\3\122\1\362\40\122\3\0\16\122\1\0"+
    "\3\122\1\363\11\122\1\364\2\122\1\365\43\122\3\0"+
    "\16\122\1\0\16\122\1\262\45\122\3\0\16\122\1\0"+
    "\10\122\1\366\12\122\1\330\11\122\1\330\26\122\3\0"+
    "\16\122\1\0\10\122\1\242\3\122\1\242\6\122\1\367"+
    "\40\122\3\0\16\122\1\0\12\122\1\276\1\357\1\245"+
    "\1\122\1\277\1\122\1\360\2\122\1\300\4\122\1\303"+
    "\5\122\1\264\25\122\3\0\16\122\1\0\6\122\1\304"+
    "\3\122\1\276\1\122\1\370\1\122\1\277\4\122\1\300"+
    "\4\122\1\303\10\122\1\371\22\122\3\0\16\122\1\0"+
    "\12\122\1\314\14\122\1\124\34\122\3\0\16\122\1\0"+
    "\12\122\1\276\2\122\1\251\1\277\4\122\1\300\4\122"+
    "\1\303\33\122\3\0\16\122\1\0\23\122\1\171\3\122"+
    "\1\164\12\122\1\372\21\122\3\0\16\122\1\0\14\122"+
    "\1\245\1\122\1\242\45\122\3\0\16\122\1\0\5\122"+
    "\1\334\4\122\1\276\1\122\1\245\1\122\1\277\4\122"+
    "\1\300\1\341\3\122\1\303\5\122\1\264\25\122\3\0"+
    "\16\122\1\0\6\122\1\304\3\122\1\276\3\122\1\277"+
    "\4\122\1\300\4\122\1\303\33\122\3\0\16\122\1\0"+
    "\16\122\1\277\4\122\1\300\40\122\3\0\16\122\1\0"+
    "\27\122\1\352\34\122\3\0\16\122\1\0\10\122\1\251"+
    "\51\122\1\373\1\122\3\0\16\122\1\0\10\122\1\251"+
    "\53\122\3\0\16\122\1\0\23\122\1\367\40\122\3\0"+
    "\16\122\1\0\10\122\1\374\12\122\1\375\40\122\3\0"+
    "\16\122\1\0\23\122\1\376\40\122\3\0\16\122\1\0"+
    "\23\122\1\377\40\122\3\0\16\122\1\0\16\122\1\242"+
    "\45\122\3\0\16\122\1\0\5\122\1\124\1\122\1\242"+
    "\10\122\1\u0100\6\122\1\124\34\122\3\0\16\122\1\0"+
    "\7\122\1\u0101\2\122\1\260\51\122\3\0\16\122\1\0"+
    "\10\122\1\u0102\53\122\3\0\12\122\102\177\1\u0103\3\177"+
    "\103\200\1\u0104\2\200\1\0\3\35\3\0\16\35\1\u0105"+
    "\26\35\1\u0105\14\35\5\0\1\35\5\0\1\35\2\0"+
    "\3\35\3\0\6\35\1\u0106\25\35\1\u0106\25\35\5\0"+
    "\1\35\5\0\1\35\2\0\3\35\3\0\1\u0107\6\35"+
    "\1\u0107\52\35\5\0\1\35\5\0\1\35\1\0\22\34"+
    "\1\u0108\26\34\1\u0108\27\34\1\0\105\34\1\0\2\34"+
    "\1\0\20\34\1\u0109\24\34\1\u0109\34\34\1\0\4\34"+
    "\104\210\1\u010a\1\210\73\67\1\216\3\67\1\u010b\20\67"+
    "\1\u010c\53\67\1\u010c\4\67\1\216\16\67\2\220\65\67"+
    "\1\216\10\67\1\u010d\1\67\73\100\1\225\3\100\1\u010e"+
    "\21\100\1\u010f\51\100\1\u010f\5\100\1\225\12\100\73\112"+
    "\1\234\3\112\1\u0110\27\112\1\u0111\24\112\1\u0111\24\112"+
    "\1\234\12\112\1\122\1\240\2\122\1\0\31\122\4\240"+
    "\27\122\1\0\1\u0112\1\0\13\122\1\u0113\1\122\1\u0113"+
    "\1\0\4\122\1\u0113\3\122\1\u0113\1\122\1\u0113\4\122"+
    "\1\u0113\3\122\1\u0113\1\122\1\u0113\3\122\7\u0113\11\122"+
    "\1\u0113\1\122\1\u0113\10\122\3\0\16\122\1\0\64\122"+
    "\1\0\1\u0112\1\0\16\122\1\0\5\122\1\321\56\122"+
    "\3\0\16\122\1\0\16\122\1\u0114\45\122\3\0\16\122"+
    "\1\0\7\122\1\u0115\54\122\3\0\16\122\1\0\14\122"+
    "\1\u0116\47\122\3\0\16\122\1\0\23\122\1\u0117\40\122"+
    "\3\0\16\122\1\0\4\122\1\u0118\57\122\3\0\16\122"+
    "\1\0\14\122\1\370\47\122\3\0\16\122\1\0\13\122"+
    "\1\344\50\122\3\0\16\122\1\0\26\122\1\u0119\35\122"+
    "\3\0\16\122\1\0\22\122\1\u011a\41\122\3\0\16\122"+
    "\1\0\23\122\1\u011b\40\122\3\0\16\122\1\0\24\122"+
    "\1\242\3\122\1\u011c\33\122\3\0\16\122\1\0\12\122"+
    "\1\u011d\51\122\3\0\16\122\1\0\23\122\1\u011e\40\122"+
    "\3\0\16\122\1\0\4\122\1\u011f\1\122\1\u0120\15\122"+
    "\1\242\37\122\3\0\16\122\1\0\15\122\1\u011d\46\122"+
    "\3\0\16\122\1\0\21\122\1\242\42\122\3\0\16\122"+
    "\1\0\13\122\1\u0121\50\122\3\0\16\122\1\0\22\122"+
    "\1\242\41\122\1\0\1\u0112\1\0\16\122\1\0\20\122"+
    "\1\u0122\43\122\3\0\16\122\1\0\16\122\1\u0123\45\122"+
    "\3\0\16\122\1\0\16\122\1\u0124\45\122\3\0\16\122"+
    "\1\0\7\122\1\u0125\5\122\1\u0126\46\122\3\0\16\122"+
    "\1\0\20\122\1\u0127\43\122\3\0\16\122\1\0\14\122"+
    "\1\242\10\122\1\274\36\122\3\0\16\122\1\0\7\122"+
    "\1\353\54\122\3\0\16\122\1\0\11\122\1\u0128\52\122"+
    "\3\0\16\122\1\0\7\122\1\312\54\122\3\0\16\122"+
    "\1\0\24\122\1\344\37\122\3\0\16\122\1\0\12\122"+
    "\1\u0129\51\122\3\0\16\122\1\0\23\122\1\u012a\40\122"+
    "\3\0\16\122\1\0\16\122\1\u012b\45\122\3\0\16\122"+
    "\1\0\20\122\1\u012c\43\122\3\0\16\122\1\0\5\122"+
    "\1\u012d\56\122\3\0\16\122\1\0\7\122\1\u012e\54\122"+
    "\3\0\16\122\1\0\23\122\1\242\3\122\1\242\34\122"+
    "\3\0\16\122\1\0\20\122\1\352\3\122\1\344\37\122"+
    "\3\0\16\122\1\0\5\122\1\321\1\u012f\55\122\3\0"+
    "\16\122\1\0\16\122\1\u0130\45\122\3\0\16\122\1\0"+
    "\20\122\1\u0131\43\122\3\0\16\122\1\0\3\122\1\u011d"+
    "\13\122\1\u0132\44\122\3\0\16\122\1\0\10\122\1\u0133"+
    "\53\122\3\0\16\122\1\0\16\122\1\u0134\45\122\3\0"+
    "\16\122\1\0\3\122\1\u0135\2\122\1\263\55\122\3\0"+
    "\16\122\1\0\6\122\1\242\11\122\1\u0136\43\122\3\0"+
    "\16\122\1\0\23\122\1\330\40\122\3\0\16\122\1\0"+
    "\6\122\1\242\55\122\3\0\16\122\1\0\23\122\1\253"+
    "\2\122\1\u0119\35\122\3\0\16\122\1\0\10\122\1\u0132"+
    "\53\122\3\0\16\122\1\0\50\122\1\242\11\122\1\u0137"+
    "\1\122\3\0\16\122\1\0\24\122\1\242\37\122\3\0"+
    "\16\122\1\0\3\122\1\u0135\14\122\1\u0138\3\122\1\u0139"+
    "\1\122\1\u0119\35\122\3\0\16\122\1\0\13\122\1\u013a"+
    "\50\122\3\0\16\122\1\0\20\122\1\u0138\43\122\3\0"+
    "\16\122\1\0\13\122\1\u013b\10\122\1\u013c\37\122\3\0"+
    "\16\122\1\0\23\122\1\u013b\40\122\3\0\16\122\1\0"+
    "\7\122\1\u013d\1\u013e\4\122\1\u013f\46\122\3\0\16\122"+
    "\1\0\13\122\1\247\50\122\3\0\16\122\1\0\13\122"+
    "\1\u0140\50\122\3\0\16\122\1\0\7\122\1\u0141\54\122"+
    "\3\0\16\122\1\0\7\122\1\331\54\122\3\0\16\122"+
    "\1\0\17\122\1\u0142\44\122\1\0\1\u0112\1\0\16\122"+
    "\1\0\7\122\1\u0143\1\u0144\53\122\3\0\16\122\1\0"+
    "\5\122\1\u0145\56\122\3\0\16\122\1\0\12\122\1\u0129"+
    "\5\122\1\u0138\43\122\3\0\16\122\1\0\13\122\1\242"+
    "\50\122\3\0\16\122\1\0\22\122\1\u0146\1\u0147\40\122"+
    "\3\0\16\122\1\0\13\122\1\251\14\122\1\242\33\122"+
    "\3\0\16\122\1\0\20\122\1\u0138\7\122\1\u0148\33\122"+
    "\3\0\16\122\1\0\23\122\1\344\4\122\1\242\33\122"+
    "\3\0\16\122\1\0\3\122\1\u0135\13\122\1\u0149\1\u0138"+
    "\5\122\1\u0119\35\122\3\0\16\122\1\0\15\122\1\242"+
    "\46\122\3\0\16\122\1\0\3\122\1\242\60\122\3\0"+
    "\16\122\1\0\17\122\1\242\10\122\1\242\33\122\3\0"+
    "\16\122\1\0\21\122\1\u014a\42\122\3\0\16\122\1\0"+
    "\7\122\1\312\6\122\1\u014b\45\122\3\0\16\122\1\0"+
    "\6\122\1\u014c\55\122\3\0\16\122\1\0\7\122\1\u014d"+
    "\54\122\3\0\16\122\1\0\3\122\1\u0140\6\122\1\u014e"+
    "\4\122\1\u014f\44\122\3\0\16\122\1\0\12\122\1\u0138"+
    "\51\122\3\0\16\122\1\0\15\122\1\u0150\46\122\3\0"+
    "\16\122\1\0\20\122\1\u0151\43\122\3\0\16\122\1\0"+
    "\23\122\1\u0152\40\122\3\0\16\122\1\0\13\122\1\u0153"+
    "\7\122\1\u0154\40\122\3\0\16\122\1\0\24\122\1\u0155"+
    "\37\122\3\0\16\122\1\0\23\122\1\242\40\122\3\0"+
    "\16\122\1\0\42\122\1\242\21\122\3\0\16\122\1\0"+
    "\44\122\1\u0156\17\122\3\0\16\122\1\0\3\122\1\u0157"+
    "\57\122\1\242\3\0\16\122\1\0\13\122\1\251\50\122"+
    "\3\0\16\122\1\0\30\122\1\u0148\33\122\3\0\16\122"+
    "\1\0\6\122\1\u0158\55\122\3\0\16\122\1\0\24\122"+
    "\1\u0139\37\122\3\0\16\122\1\0\7\122\1\u0125\54\122"+
    "\3\0\16\122\1\0\30\122\1\u0155\33\122\3\0\16\122"+
    "\1\0\7\122\1\u0159\54\122\3\0\12\122\101\177\1\u015a"+
    "\1\u0103\3\177\101\200\1\u015a\1\200\1\u0104\2\200\1\0"+
    "\3\35\3\0\5\35\1\u015b\30\35\1\u015b\23\35\5\0"+
    "\1\35\5\0\1\35\2\0\3\35\3\0\12\35\1\u015c"+
    "\24\35\1\u015c\22\35\5\0\1\35\5\0\1\35\1\0"+
    "\17\34\1\u015d\24\34\1\u015d\34\34\1\0\25\34\1\u015e"+
    "\24\34\1\u015e\32\34\1\0\4\34\104\210\1\u015f\1\210"+
    "\12\67\1\u0160\53\67\1\u0160\4\67\1\216\31\67\1\u0161"+
    "\24\67\1\u0161\26\67\1\216\105\67\1\216\10\67\1\u0162"+
    "\1\67\13\100\1\u0163\51\100\1\u0163\5\100\1\225\37\100"+
    "\1\u0164\26\100\1\u0164\16\100\1\225\12\100\21\112\1\u0165"+
    "\24\112\1\u0165\24\112\1\234\27\112\1\u0166\25\112\1\u0166"+
    "\27\112\1\234\12\112\1\122\1\u0113\1\122\1\u0113\1\0"+
    "\4\122\1\u0113\3\122\1\u0113\1\122\1\u0113\4\122\1\u0113"+
    "\3\122\1\u0113\1\122\1\u0113\3\122\7\u0113\11\122\1\u0113"+
    "\1\122\1\u0113\10\122\1\0\1\u0112\1\0\16\122\1\0"+
    "\4\122\1\242\57\122\3\0\16\122\1\0\13\122\1\u013b"+
    "\50\122\3\0\16\122\1\0\7\122\1\353\54\122\1\0"+
    "\1\u0112\1\0\16\122\1\0\5\122\1\u0167\56\122\3\0"+
    "\16\122\1\0\13\122\1\370\50\122\3\0\16\122\1\0"+
    "\16\122\1\352\45\122\3\0\16\122\1\0\4\122\1\u0168"+
    "\57\122\3\0\16\122\1\0\17\122\1\u013c\44\122\3\0"+
    "\16\122\1\0\24\122\1\u0169\37\122\3\0\16\122\1\0"+
    "\14\122\1\242\47\122\3\0\16\122\1\0\20\122\1\u016a"+
    "\43\122\3\0\16\122\1\0\10\122\1\242\53\122\1\0"+
    "\1\u0112\1\0\16\122\1\0\10\122\1\242\20\122\3\242"+
    "\30\122\1\0\1\u0112\1\0\16\122\1\0\7\122\1\u0135"+
    "\54\122\3\0\16\122\1\0\6\122\1\242\15\122\1\u0132"+
    "\37\122\3\0\16\122\1\0\5\122\1\u016b\56\122\3\0"+
    "\16\122\1\0\3\122\1\u016c\60\122\3\0\16\122\1\0"+
    "\24\122\1\u016d\37\122\3\0\16\122\1\0\6\122\1\242"+
    "\10\122\1\242\44\122\3\0\16\122\1\0\14\122\1\242"+
    "\6\122\1\242\40\122\3\0\16\122\1\0\12\122\1\344"+
    "\51\122\3\0\16\122\1\0\16\122\1\u014b\45\122\3\0"+
    "\16\122\1\0\30\122\1\u016d\33\122\3\0\16\122\1\0"+
    "\10\122\1\u012e\53\122\3\0\16\122\1\0\23\122\1\u016e"+
    "\40\122\3\0\16\122\1\0\7\122\1\u016f\54\122\3\0"+
    "\16\122\1\0\5\122\1\u011d\56\122\3\0\16\122\1\0"+
    "\14\122\1\263\47\122\3\0\16\122\1\0\7\122\1\u0170"+
    "\54\122\3\0\16\122\1\0\12\122\1\242\51\122\3\0"+
    "\16\122\1\0\7\122\1\344\54\122\3\0\16\122\1\0"+
    "\17\122\1\u0132\44\122\3\0\16\122\1\0\4\122\1\u0171"+
    "\57\122\3\0\16\122\1\0\30\122\1\242\33\122\3\0"+
    "\16\122\1\0\20\122\1\u0172\43\122\3\0\16\122\1\0"+
    "\23\122\1\u012e\40\122\3\0\16\122\1\0\20\122\1\242"+
    "\43\122\3\0\16\122\1\0\4\122\1\u0173\57\122\3\0"+
    "\16\122\1\0\15\122\1\u0174\46\122\3\0\16\122\1\0"+
    "\17\122\1\u016d\44\122\3\0\16\122\1\0\10\122\1\u0171"+
    "\53\122\3\0\16\122\1\0\3\122\1\243\60\122\3\0"+
    "\16\122\1\0\14\122\1\u0175\3\122\1\u0176\43\122\3\0"+
    "\16\122\1\0\20\122\1\353\43\122\3\0\16\122\1\0"+
    "\16\122\1\u0171\45\122\3\0\16\122\1\0\3\122\1\u016d"+
    "\60\122\3\0\16\122\1\0\24\122\2\242\36\122\3\0"+
    "\16\122\1\0\12\122\1\u011e\51\122\3\0\16\122\1\0"+
    "\30\122\1\370\33\122\3\0\16\122\1\0\7\122\1\u0177"+
    "\54\122\3\0\16\122\1\0\7\122\1\u013b\54\122\3\0"+
    "\16\122\1\0\24\122\1\u0171\37\122\3\0\16\122\1\0"+
    "\30\122\1\u0178\33\122\3\0\16\122\1\0\7\122\1\u0131"+
    "\54\122\3\0\16\122\1\0\24\122\1\321\37\122\3\0"+
    "\16\122\1\0\14\122\1\u016d\47\122\3\0\16\122\1\0"+
    "\27\122\1\370\34\122\3\0\16\122\1\0\3\122\1\u0135"+
    "\60\122\3\0\16\122\1\0\20\122\1\352\43\122\3\0"+
    "\16\122\1\0\17\122\1\262\44\122\3\0\16\122\1\0"+
    "\25\122\1\242\36\122\3\0\16\122\1\0\23\122\1\252"+
    "\40\122\3\0\16\122\1\0\5\122\1\344\4\122\1\u0179"+
    "\51\122\3\0\16\122\1\0\13\122\1\u017a\50\122\3\0"+
    "\16\122\1\0\20\122\1\u017b\43\122\3\0\16\122\1\0"+
    "\24\122\1\370\37\122\3\0\16\122\1\0\47\122\1\u017c"+
    "\14\122\3\0\16\122\1\0\63\122\1\242\3\0\16\122"+
    "\1\0\6\122\1\370\55\122\3\0\16\122\1\0\10\122"+
    "\1\u017d\53\122\3\0\12\122\1\0\3\35\3\0\4\35"+
    "\1\u017e\51\35\1\u017e\3\35\5\0\1\35\5\0\1\35"+
    "\2\0\3\35\3\0\21\35\1\u017f\11\35\1\u017f\26\35"+
    "\5\0\1\35\5\0\1\35\1\0\21\34\1\u0180\24\34"+
    "\1\u0180\32\34\1\0\32\34\1\u0181\24\34\1\u0181\25\34"+
    "\1\0\4\34\17\67\1\u0182\24\67\1\u0182\26\67\1\216"+
    "\37\67\1\u0183\26\67\1\u0183\16\67\1\216\12\67\73\u0162"+
    "\1\u0184\10\u0162\1\u0185\1\u0162\25\100\1\u0186\26\100\1\u0186"+
    "\16\100\1\225\27\100\1\u0187\25\100\1\u0187\27\100\1\225"+
    "\12\100\15\112\1\u0188\25\112\1\u0188\27\112\1\234\21\112"+
    "\1\u0189\6\112\1\u0189\54\112\1\234\12\112\4\122\1\0"+
    "\27\122\1\242\34\122\3\0\16\122\1\0\23\122\1\u0138"+
    "\40\122\3\0\16\122\1\0\23\122\1\u018a\40\122\3\0"+
    "\16\122\1\0\15\122\1\353\46\122\3\0\16\122\1\0"+
    "\24\122\1\353\37\122\3\0\16\122\1\0\17\122\1\242"+
    "\44\122\3\0\16\122\1\0\10\122\1\242\53\122\3\0"+
    "\16\122\1\0\22\122\1\u016d\41\122\3\0\16\122\1\0"+
    "\13\122\1\u016a\50\122\3\0\16\122\1\0\22\122\1\242"+
    "\41\122\3\0\16\122\1\0\5\122\1\242\56\122\3\0"+
    "\16\122\1\0\10\122\1\353\53\122\3\0\16\122\1\0"+
    "\17\122\1\370\44\122\3\0\16\122\1\0\15\122\1\u0138"+
    "\46\122\3\0\16\122\1\0\23\122\1\u018b\40\122\3\0"+
    "\16\122\1\0\10\122\1\u018c\53\122\3\0\16\122\1\0"+
    "\13\122\1\u016a\13\122\1\242\34\122\3\0\16\122\1\0"+
    "\10\122\1\u0138\53\122\3\0\16\122\1\0\32\122\1\u018c"+
    "\1\u018d\30\122\3\0\16\122\1\0\7\122\1\321\54\122"+
    "\3\0\16\122\1\0\14\122\1\u0171\47\122\3\0\16\122"+
    "\1\0\43\122\1\242\20\122\3\0\16\122\1\0\20\122"+
    "\1\321\43\122\3\0\12\122\1\0\3\35\3\0\12\35"+
    "\1\u018e\24\35\1\u018e\22\35\5\0\1\35\5\0\1\35"+
    "\2\0\3\35\3\0\16\35\1\u018f\26\35\1\u018f\14\35"+
    "\5\0\1\35\5\0\1\35\1\0\26\34\1\u0190\24\34"+
    "\1\u0190\25\34\1\0\17\34\1\u0191\51\34\1\u0191\13\34"+
    "\1\0\4\34\25\67\1\u0192\26\67\1\u0192\16\67\1\216"+
    "\26\67\1\u0193\30\67\1\u0193\25\67\1\216\12\67\73\u0162"+
    "\1\u0184\3\u0162\1\u0194\4\u0162\1\u0185\74\u0162\1\u0184\10\u0162"+
    "\1\220\1\u0162\15\100\1\u0195\25\100\1\u0195\27\100\1\225"+
    "\105\100\1\225\5\100\1\u0196\4\100\7\112\1\u0197\6\112"+
    "\1\u0197\54\112\1\234\33\112\1\u0198\24\112\1\u0198\24\112"+
    "\1\234\12\112\4\122\1\0\25\122\1\242\36\122\1\0"+
    "\1\u0112\1\0\16\122\1\0\5\122\1\u0199\56\122\1\0"+
    "\1\u0112\1\0\16\122\1\0\34\122\1\242\27\122\3\0"+
    "\16\122\1\0\31\122\1\242\2\122\1\242\27\122\3\0"+
    "\12\122\1\0\3\35\3\0\6\35\1\u019a\25\35\1\u019a"+
    "\25\35\5\0\1\35\5\0\1\35\1\0\13\34\1\u019b"+
    "\51\34\1\u019b\13\34\1\0\21\34\1\u019c\25\34\1\u019c"+
    "\35\34\1\0\4\34\14\67\1\u019d\30\67\1\u019d\25\67"+
    "\1\216\25\67\1\u019e\51\67\1\u019e\5\67\1\216\12\67"+
    "\12\u0162\1\u019f\53\u0162\1\u019f\4\u0162\1\u0184\10\u0162\1\u0185"+
    "\1\u0162\73\100\1\225\5\100\1\0\4\100\21\112\1\u01a0"+
    "\24\112\1\u01a0\24\112\1\234\42\112\1\u01a1\11\112\1\u01a1"+
    "\30\112\1\234\12\112\4\122\1\0\21\122\1\325\42\122"+
    "\3\0\12\122\1\0\3\35\3\0\21\35\1\u01a2\11\35"+
    "\1\u01a2\26\35\5\0\1\35\5\0\1\35\1\0\15\34"+
    "\1\0\25\34\1\0\35\34\1\0\4\34\13\67\1\u01a3"+
    "\51\67\1\u01a3\5\67\1\216\33\67\1\u01a4\24\67\1\u01a4"+
    "\24\67\1\216\12\67\17\u0162\1\u01a5\24\u0162\1\u01a5\26\u0162"+
    "\1\u0184\10\u0162\1\u0185\1\u0162\30\112\1\u01a6\11\112\1\u01a6"+
    "\30\112\1\234\37\112\1\u01a7\26\112\1\u01a7\16\112\1\234"+
    "\12\112\21\67\1\u01a8\24\67\1\u01a8\24\67\1\216\105\67"+
    "\1\216\5\67\1\u0196\4\67\25\u0162\1\u01a9\26\u0162\1\u01a9"+
    "\16\u0162\1\u0184\10\u0162\1\u0185\1\u0162\25\112\1\u01aa\26\112"+
    "\1\u01aa\16\112\1\234\27\112\1\u01ab\25\112\1\u01ab\27\112"+
    "\1\234\12\112\73\67\1\216\5\67\1\0\4\67\14\u0162"+
    "\1\u01ac\30\u0162\1\u01ac\25\u0162\1\u0184\10\u0162\1\u0185\1\u0162"+
    "\15\112\1\u01ad\25\112\1\u01ad\27\112\1\234\42\112\1\u01ae"+
    "\11\112\1\u01ae\30\112\1\234\12\112\13\u0162\1\u01af\51\u0162"+
    "\1\u01af\5\u0162\1\u0184\10\u0162\1\u0185\1\u0162\30\112\1\u01b0"+
    "\11\112\1\u01b0\30\112\1\234\105\112\1\234\5\112\1\u0196"+
    "\4\112\21\u0162\1\u01b1\24\u0162\1\u01b1\24\u0162\1\u0184\10\u0162"+
    "\1\u0185\1\u0162\73\112\1\234\5\112\1\0\4\112\73\u0162"+
    "\1\u0184\5\u0162\1\u01b2\2\u0162\1\u0185\1\u0162\104\u01b2\1\u01b3"+
    "\105\u01b2\1\u01b4\1\u01b2\4\0\2\u01b4\73\0\1\u01b5\2\0"+
    "\1\u01b6\105\0\1\u01b2\1\0";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0, 
     0,  0,  1,  0,  1,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     9,  1,  1,  1,  1,  9,  1,  1,  9,  9,  1,  1,  1,  1,  1,  9, 
     1,  9,  1,  1,  1,  9,  1,  1,  1,  1,  9,  9,  1,  1,  1,  1, 
     1,  1,  1,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  9,  0,  0, 
     1,  1,  1,  1,  0,  0,  0,  0,  9,  9,  0,  9,  0,  0,  1,  1, 
     9,  0,  9,  0,  0,  1,  9,  9,  0,  9,  0,  0,  1,  0,  0,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  0,  0,  1,  1,  1,  0,  0,  0,  0,  1,  1,  0,  1,  0, 
     1,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1,  1,  0,  0,  9,  0, 
     1,  1,  0,  1,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0, 
     0,  0,  1,  0,  1,  0,  1,  0,  1,  1,  1,  1,  1,  1,  1,  0, 
     0,  0,  1,  0,  0,  9,  0,  1,  1,  1,  0,  9,  0,  1,  0,  0, 
     1,  1,  0,  1,  0,  0,  1,  0,  0,  0,  1,  0,  0,  1,  0,  0, 
     0,  0,  0,  0,  9,  0
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /* user code: */

	private int lastToken;

    private int nextState=YYINITIAL;
	
    /** 
     * next Token method that allows you to control if whitespace and comments are
     * returned as tokens.
     */
    public Token getNextToken(boolean returnComments, boolean returnWhiteSpace)throws IOException{
        Token t = getNextToken();
        while (t != null && ((!returnWhiteSpace && t.isWhiteSpace()) || (!returnComments && t.isComment()))){
            t = getNextToken();
        }
        return (t); 
    }

    /**
     * Prints out tokens from a file or System.in.
     * If no arguments are given, System.in will be used for input.
     * If more arguments are given, the first argument will be used as
     * the name of the file to use as input
     *
     * @param args program arguments, of which the first is a filename
     */
    public static void main(String[] args) {
        InputStream in;
        try {
            if (args.length > 0){
                File f = new File(args[0]);
                if (f.exists()){
                    if (f.canRead()){
                        in = new FileInputStream(f);
                    } else {
                        throw new IOException("Could not open " + args[0]);
                    }
                } else {
                    throw new IOException("Could not find " + args[0]);
                }                   
            } else {
                in = System.in;
            }       
            HTMLLexer1 shredder = new HTMLLexer1(in);
            Token t;
            while ((t = shredder.getNextToken()) != null) {
                if (t.getID() != CToken.WHITE_SPACE){
                    System.out.println(t);
                }
            }
        } catch (IOException e){
            System.out.println(e.getMessage());
        }
    }

    /**
     * Closes the current input stream, and resets the scanner to read from a new input stream.
	 * All internal variables are reset, the old input stream  cannot be reused
	 * (content of the internal buffer is discarded and lost).
	 * The lexical state is set to the initial state.
     * Subsequent tokens read from the lexer will start with the line, char, and column
     * values given here.
     *
     * @param reader The new input.
     * @param yyline The line number of the first token.
     * @param yychar The position (relative to the start of the stream) of the first token.
     * @param yycolumn The position (relative to the line) of the first token.
     * @throws IOException if an IOExecption occurs while switching readers.
     */
    public void reset(java.io.Reader reader, int yyline, int yychar, int yycolumn) throws IOException{
        yyreset(reader);
        this.yyline = yyline;
		this.yychar = yychar;
		this.yycolumn = yycolumn;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HTMLLexer1(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HTMLLexer1(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[27790];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public Token getNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      yychar+= yy_markedPos_l-yy_startRead;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          yy_r = false;
          yycolumn++;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof) 
            yy_peek = false;
          else 
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos = 
                       yy_startRead = yy_markedPos_l;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 74: 
        case 156: 
        case 272: 
        case 357: 
        case 392: 
        case 407: 
        case 416: 
        case 422: 
        case 426: 
        case 429: 
          { 
	lastToken = HTMLToken1.WORD;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 439: break;
        case 28: 
        case 29: 
        case 30: 
        case 31: 
        case 128: 
        case 129: 
        case 130: 
        case 260: 
        case 262: 
        case 346: 
        case 347: 
        case 381: 
        case 382: 
        case 398: 
        case 409: 
          { 
    nextState = TAG;
	lastToken = HTMLToken1.TAG_NAME;
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 440: break;
        case 14: 
        case 63: 
          { 
	lastToken = HTMLToken1.WORD;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 441: break;
        case 18: 
        case 73: 
          { 
	lastToken = HTMLToken1.WORD;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 442: break;
        case 20: 
        case 75: 
          { 
	lastToken = HTMLToken1.NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 443: break;
        case 24: 
        case 131: 
          { 
	lastToken = HTMLToken1.WHITE_SPACE;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 444: break;
        case 42: 
        case 136: 
          { 
    nextState = TAG;
	lastToken = HTMLToken1.VALUE;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 445: break;
        case 47: 
          { 
    nextState = SCRIPT;
	lastToken = HTMLToken1.TAG_END;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 446: break;
        case 64: 
        case 149: 
        case 270: 
        case 355: 
        case 390: 
          { 
	lastToken = HTMLToken1.WORD;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 447: break;
        case 60: 
        case 146: 
          { 
    nextState = PRE_TAG;
	lastToken = HTMLToken1.VALUE;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 448: break;
        case 10: 
        case 54: 
        case 143: 
        case 268: 
        case 353: 
        case 388: 
        case 436: 
          { 
	lastToken = HTMLToken1.SCRIPT;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 449: break;
        case 25: 
        case 81: 
        case 82: 
        case 83: 
        case 84: 
        case 85: 
        case 86: 
        case 87: 
        case 88: 
        case 89: 
        case 90: 
        case 91: 
        case 92: 
        case 93: 
        case 94: 
        case 95: 
        case 96: 
        case 97: 
        case 98: 
        case 99: 
        case 100: 
        case 101: 
        case 102: 
        case 103: 
        case 104: 
        case 105: 
        case 106: 
        case 107: 
        case 108: 
        case 109: 
        case 110: 
        case 111: 
        case 112: 
        case 113: 
        case 114: 
        case 115: 
        case 116: 
        case 117: 
        case 118: 
        case 119: 
        case 120: 
        case 121: 
        case 122: 
        case 123: 
        case 160: 
        case 162: 
        case 163: 
        case 164: 
        case 165: 
        case 166: 
        case 167: 
        case 168: 
        case 169: 
        case 170: 
        case 171: 
        case 172: 
        case 173: 
        case 174: 
        case 175: 
        case 176: 
        case 177: 
        case 178: 
        case 179: 
        case 181: 
        case 182: 
        case 183: 
        case 184: 
        case 185: 
        case 186: 
        case 187: 
        case 188: 
        case 189: 
        case 190: 
        case 191: 
        case 192: 
        case 193: 
        case 194: 
        case 195: 
        case 196: 
        case 197: 
        case 198: 
        case 199: 
        case 200: 
        case 201: 
        case 202: 
        case 203: 
        case 204: 
        case 205: 
        case 206: 
        case 207: 
        case 208: 
        case 209: 
        case 210: 
        case 211: 
        case 212: 
        case 213: 
        case 214: 
        case 215: 
        case 216: 
        case 217: 
        case 218: 
        case 219: 
        case 220: 
        case 221: 
        case 222: 
        case 224: 
        case 225: 
        case 226: 
        case 227: 
        case 228: 
        case 229: 
        case 230: 
        case 231: 
        case 232: 
        case 233: 
        case 234: 
        case 235: 
        case 236: 
        case 237: 
        case 238: 
        case 239: 
        case 240: 
        case 241: 
        case 242: 
        case 243: 
        case 244: 
        case 245: 
        case 246: 
        case 247: 
        case 248: 
        case 249: 
        case 250: 
        case 251: 
        case 252: 
        case 253: 
        case 254: 
        case 255: 
        case 256: 
        case 257: 
        case 275: 
        case 276: 
        case 278: 
        case 279: 
        case 280: 
        case 281: 
        case 282: 
        case 283: 
        case 284: 
        case 285: 
        case 288: 
        case 289: 
        case 290: 
        case 291: 
        case 292: 
        case 293: 
        case 294: 
        case 295: 
        case 296: 
        case 297: 
        case 298: 
        case 299: 
        case 300: 
        case 301: 
        case 302: 
        case 303: 
        case 304: 
        case 305: 
        case 306: 
        case 307: 
        case 308: 
        case 309: 
        case 310: 
        case 311: 
        case 312: 
        case 313: 
        case 314: 
        case 315: 
        case 316: 
        case 317: 
        case 318: 
        case 319: 
        case 320: 
        case 321: 
        case 322: 
        case 323: 
        case 324: 
        case 325: 
        case 326: 
        case 327: 
        case 328: 
        case 329: 
        case 330: 
        case 331: 
        case 332: 
        case 333: 
        case 334: 
        case 335: 
        case 336: 
        case 337: 
        case 338: 
        case 339: 
        case 340: 
        case 341: 
        case 342: 
        case 343: 
        case 344: 
        case 358: 
        case 359: 
        case 360: 
        case 361: 
        case 362: 
        case 363: 
        case 364: 
        case 365: 
        case 366: 
        case 367: 
        case 368: 
        case 369: 
        case 370: 
        case 371: 
        case 372: 
        case 373: 
        case 374: 
        case 375: 
        case 376: 
        case 377: 
        case 378: 
        case 379: 
        case 380: 
        case 395: 
        case 396: 
        case 408: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 450: break;
        case 55: 
        case 142: 
        case 267: 
        case 352: 
        case 386: 
        case 402: 
        case 413: 
        case 419: 
          { 
	lastToken = HTMLToken1.SCRIPT;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 451: break;
        case 58: 
          { 
    nextState = PRE;
	lastToken = HTMLToken1.TAG_END;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 452: break;
        case 411: 
          { 
    nextState = DOCTYPE;
	lastToken = HTMLToken1.TAG_NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 453: break;
        case 67: 
          { 
    nextState = TEXTAREA;
	lastToken = HTMLToken1.TAG_END;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 454: break;
        case 41: 
          { 
    nextState = START_VALUE;
	lastToken = HTMLToken1.EQUAL;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 455: break;
        case 40: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.TAG_END;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 456: break;
        case 39: 
          { 
    nextState = START_EQUAL;
	lastToken = HTMLToken1.NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 457: break;
        case 50: 
        case 139: 
          { 
    nextState = SCRIPT_TAG;
	lastToken = HTMLToken1.VALUE;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 458: break;
        case 34: 
        case 35: 
        case 36: 
        case 38: 
        case 78: 
        case 79: 
        case 80: 
          { 
    nextState = COMMENT_DEF;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 459: break;
        case 45: 
        case 137: 
          { 
    nextState = SCRIPT;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 460: break;
        case 159: 
        case 161: 
        case 180: 
        case 223: 
        case 273: 
        case 274: 
        case 277: 
        case 286: 
        case 287: 
        case 393: 
        case 394: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.CHAR_REF;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 461: break;
        case 68: 
          { 
    nextState = START_TEXTAREA_VALUE;
	lastToken = HTMLToken1.EQUAL;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 462: break;
        case 33: 
          { 
    nextState = FINISH_END_TAG;
	lastToken = HTMLToken1.END_TAG_NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 463: break;
        case 48: 
          { 
    nextState = SCRIPT;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 464: break;
        case 53: 
          { 
    nextState = SCRIPT;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 465: break;
        case 350: 
          { 
    nextState = COMMENT_DEF;
	lastToken = HTMLToken1.COMMENT;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 466: break;
        case 261: 
          { 
    nextState = PRE_TAG;
	lastToken = HTMLToken1.TAG_NAME;
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 467: break;
        case 70: 
        case 153: 
          { 
    nextState = TEXTAREA_TAG;
	lastToken = HTMLToken1.VALUE;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 468: break;
        case 69: 
        case 151: 
          { 
    nextState = TEXTAREA;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 469: break;
        case 32: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 470: break;
        case 27: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 471: break;
        case 43: 
        case 44: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 472: break;
        case 56: 
        case 144: 
          { 
    nextState = PRE;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 473: break;
        case 65: 
        case 150: 
          { 
    nextState = TEXTAREA;
	lastToken = HTMLToken1.ERROR_MALFORMED_TAG;
	
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 474: break;
        case 57: 
          { 
    nextState = START_PRE_EQUAL;
	lastToken = HTMLToken1.NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 475: break;
        case 59: 
          { 
    nextState = START_PRE_VALUE;
	lastToken = HTMLToken1.EQUAL;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 476: break;
        case 0: 
        case 23: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.WORD;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 477: break;
        case 417: 
          { 
    nextState = TEXTAREA_TAG;
	lastToken = HTMLToken1.TAG_NAME;
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 478: break;
        case 345: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.SCRIPT;
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	return(t);
 }
        case 479: break;
        case 49: 
          { 
    nextState = START_SCRIPT_VALUE;
	lastToken = HTMLToken1.EQUAL;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 480: break;
        case 66: 
          { 
    nextState = START_TEXTAREA_EQUAL;
	lastToken = HTMLToken1.NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 481: break;
        case 405: 
          { 
    nextState = YYINITIAL;
	lastToken = HTMLToken1.END_TAG_NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 482: break;
        case 397: 
          { 
    nextState = SCRIPT_TAG;
	lastToken = HTMLToken1.TAG_NAME;	
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 483: break;
        case 125: 
          { 
    nextState = START_DOC_TAG;
	lastToken = HTMLToken1.TAG_START;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 484: break;
        case 124: 
          { 
    nextState = START_END_TAG;
	lastToken = HTMLToken1.TAG_START;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 485: break;
        case 37: 
        case 51: 
        case 52: 
        case 61: 
        case 62: 
        case 71: 
        case 72: 
        case 76: 
        case 77: 
          { 
    System.err.println("Unmatched input.");
    String state = "";    
	String text = yytext();
    switch (nextState){
        case YYINITIAL: state = "YYINITIAL"; break;
        case START_TAG: state = "START_TAG"; break;
        case START_END_TAG: state = "START_END_TAG"; break;
        case START_DOC_TAG: state = "START_DOC_TAG"; break;
        case TAG: state = "TAG"; break;
        case START_EQUAL: state = "START_EQUAL"; break;
        case START_VALUE: state = "START_VALUE"; break;
        case SCRIPT_TAG: state = "SCRIPT_TAG"; break;
        case START_SCRIPT_EQUAL: state = "START_SCRIPT_EQUAL"; break;
        case START_SCRIPT_VALUE: state = "START_SCRIPT_VALUE"; break;
        case SCRIPT: state = "SCRIPT"; break;
        case PRE_TAG: state = "PRE_TAG"; break;
        case START_PRE_EQUAL: state = "START_PRE_EQUAL"; break;
        case START_PRE_VALUE: state = "START_PRE_VALUE"; break;
        case PRE: state = "PRE"; break;
        case TEXTAREA_TAG: state = "TEXTAREA_TAG"; break;
        case START_TEXTAREA_EQUAL: state = "START_TEXTAREA_EQUAL"; break;
        case START_TEXTAREA_VALUE: state = "START_TEXTAREA_VALUE"; break;
        case TEXTAREA: state = "TEXTAREA"; break;
        case TAG_END: state = "TAG_END"; break;
        case DOCTYPE: state = "DOCTYPE"; break;
        case COMMENT_DEF: state = "COMMENT_DEF"; break;
        case FINISH_END_TAG: state = "FINISH_END_TAG"; break;
    }
    System.err.println("State: " + state);
    System.err.println("Text: " + text);
    System.err.println("Line: " + (yyline+1));
    System.err.println("Column: " + (yycolumn+1));
	yy_ScanError(YY_NO_MATCH);
 }
        case 486: break;
        case 26: 
          { 
    nextState = START_TAG;
	lastToken = HTMLToken1.TAG_START;	
    String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 487: break;
        case 46: 
          { 
    nextState = START_SCRIPT_EQUAL;
	lastToken = HTMLToken1.NAME;
	String text = yytext();
	HTMLToken1 t = (new HTMLToken1(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
	yybegin(nextState);
	return(t);
 }
        case 488: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}
