/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.components;

import FontViewer.components.ListPanel;
import FontViewer.windows.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FavouriteFontsPanel
extends JPanel
implements ListPanel {
    private final int NOT_FOUND = -1;
    private final int COL_FONTNAME = 0;
    private final int COL_FONTLOC = 1;
    private MainWindow mw;
    private DefaultTableModel tm;
    private int sortCol;
    private boolean sortAsend;
    private JScrollPane favouritesScrollPane;
    private JTable favouritesTable;

    public FavouriteFontsPanel(MainWindow mw) {
        this.initComponents();
        this.mw = mw;
        this.tm = (DefaultTableModel)this.favouritesTable.getModel();
        this.sortCol = 0;
        this.sortAsend = true;
        this.favouritesTable.setAutoCreateColumnsFromModel(false);
    }

    public boolean addToFav(String name, String loc) {
        boolean found = true;
        if (this.getItemNumber(name, loc) == -1) {
            found = false;
            this.tm.addRow(new Object[]{name, loc});
            this.favouritesTable.setFont(new Font("Dialog", 0, 10));
        }
        return !found;
    }

    public boolean removeFromFav(String name, String loc) {
        boolean removed = false;
        int p = this.getItemNumber(name, loc);
        if (p != -1) {
            this.tm.removeRow(p);
            removed = true;
        }
        if (p >= this.tm.getRowCount()) {
            this.favouritesTable.changeSelection(this.tm.getRowCount() - 1, 0, false, false);
            this.setCurrentItem(this.tm.getRowCount() - 1);
        } else {
            this.favouritesTable.changeSelection(p, 0, false, false);
            this.setCurrentItem(p);
        }
        this.mw.updateDisplay();
        return removed;
    }

    public int getItemNumber(String name, String loc) {
        int itemNum = -1;
        Object[] data = this.tm.getDataVector().toArray();
        String font = "[" + name + ", " + loc + "]";
        int i = 0;
        while (i < data.length) {
            if (data[i].toString().equals(font)) {
                itemNum = i;
                i += data.length;
            }
            ++i;
        }
        return itemNum;
    }

    @Override
    public String[] getItem(int itemNumber) {
        String[] s = new String[3];
        if (itemNumber >= 0 && itemNumber < this.tm.getRowCount()) {
            s[0] = this.tm.getValueAt(itemNumber, 0).toString();
            s[1] = this.tm.getValueAt(itemNumber, 1).toString();
            s[2] = String.valueOf(itemNumber);
        }
        return s;
    }

    @Override
    public int getNumItems() {
        return this.tm.getRowCount();
    }

    @Override
    public String[] getCurrentItem() {
        int p = this.favouritesTable.getSelectedRow();
        String[] s = this.getItem(p);
        this.sortAllRowsBy(this.sortCol, this.sortAsend);
        this.favouritesTable.changeSelection(this.getItemNumber(s[0], s[1]), 0, false, false);
        return s;
    }

    @Override
    public int getCurrentItemNum() {
        return this.favouritesTable.getSelectedRow();
    }

    private void setCurrentItem(int p) {
        String[] s = this.getCurrentItem();
        try {
            if (p >= 0) {
                this.mw.setCurrentFont(s[0], s[1], Integer.parseInt(s[2]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void selectItem(String name, String loc) {
        this.setCurrentItem(this.getItemNumber(name, loc));
    }

    @Override
    public void selectNext() {
        int i = this.favouritesTable.getSelectedRow();
        if (i >= 0) {
            if (i + 1 < this.favouritesTable.getRowCount()) {
                ++i;
            }
            this.favouritesTable.changeSelection(i, 0, false, false);
            this.setCurrentItem(i);
        } else {
            this.favouritesTable.changeSelection(0, 0, false, false);
            this.setCurrentItem(0);
        }
    }

    @Override
    public void selectPrev() {
        int i = this.favouritesTable.getSelectedRow();
        if (i >= 0) {
            if (i - 1 >= 0) {
                --i;
            }
            this.favouritesTable.changeSelection(i, 0, false, false);
            this.setCurrentItem(i);
        } else {
            this.favouritesTable.changeSelection(0, 0, false, false);
            this.setCurrentItem(0);
        }
    }

    public void sortAllRowsBy(int colIndex, boolean ascending) {
        Vector<Vector> data = this.tm.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        this.tm.fireTableStructureChanged();
    }

    private void initComponents() {
        this.favouritesScrollPane = new JScrollPane();
        this.favouritesTable = new JTable();
        this.setLayout(new BorderLayout());
        this.favouritesScrollPane.setBorder(null);
        this.favouritesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"\u30d5\u30a9\u30f3\u30c8\u540d", "\u30d5\u30a9\u30eb\u30c0"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[2];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.favouritesTable.getTableHeader().setFont(new Font("Dialog", 0, 10));
        this.favouritesTable.setDoubleBuffered(true);
        this.favouritesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FavouriteFontsPanel.this.favouritesTableKeyReleased(evt);
            }
        });
        this.favouritesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FavouriteFontsPanel.this.favouritesTableMouseClicked(evt);
            }
        });
        this.favouritesScrollPane.setViewportView(this.favouritesTable);
        this.add((Component)this.favouritesScrollPane, "Center");
    }

    private void favouritesTableMouseClicked(MouseEvent evt) {
        this.setCurrentItem(this.favouritesTable.getSelectedRow());
    }

    private void favouritesTableKeyReleased(KeyEvent evt) {
        this.setCurrentItem(this.favouritesTable.getSelectedRow());
    }

    private void exitForm(WindowEvent evt) {
    }

    public class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            Vector v1 = (Vector)a;
            Vector v2 = (Vector)b;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof String && o2 instanceof String) {
                if (this.ascending) {
                    return ((String)o1).compareToIgnoreCase(o2.toString());
                }
                return ((String)o2).compareToIgnoreCase(o1.toString());
            }
            if (o1 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareToIgnoreCase(o1.toString());
        }
    }
}

