/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.components;

import FontViewer.components.AAToggleButton;
import FontViewer.components.FavouriteFontsPanel;
import FontViewer.components.ListPanel;
import FontViewer.windows.MainWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ListViewPanel
extends JPanel {
    private final int NOT_FOUND = -1;
    private final int COL_FONTNAME = 0;
    private final int COL_FONTLOC = 1;
    private int rows;
    private int columns;
    private int position;
    private int fsize;
    private String sampleText;
    private ListPanel view;
    private FavouriteFontsPanel ffp;
    private MainWindow mw;
    private AAToggleButton selectedButton;
    private AAToggleButton tmpSelectedButton;
    private JLabel fontsPerPageLabel;
    private JTextField fontsPerPageTextField;
    private JPanel listPanel;
    private JScrollPane listScrollPane;
    private JLabel navInfoLabel;
    private JPanel navigationPanel;
    private JButton nextButton;
    private JPanel optionsPanel;
    private JButton prevButton;

    public ListViewPanel(MainWindow mw, JPanel ffp, int rows, int columns) {
        this.mw = mw;
        this.ffp = (FavouriteFontsPanel)ffp;
        this.rows = rows;
        this.columns = columns;
        this.position = 0;
        this.fsize = 20;
        this.sampleText = ResourceBundle.getBundle("FontViewer.resources.Opcion").getString("defaultSampleText");
        this.initComponents();
        this.listScrollPane.getVerticalScrollBar().setUnitIncrement(100);
    }

    public void setSampleText(String s) {
        this.sampleText = s;
        this.updateDisplay();
    }

    public void setFontSize(int s) {
        this.fsize = s;
        this.updateDisplay();
    }

    public void setView(JPanel p) {
        this.view = (ListPanel)((Object)p);
        int pos = this.view.getCurrentItemNum();
        if (this.view.getNumItems() > 0) {
            if (pos < 0) {
                this.position = 0;
                this.updateDisplay();
            } else if (pos >= 0) {
                this.position = pos;
                this.updateDisplay();
            }
        } else {
            this.noDisplay();
        }
    }

    public void setPosition(int p) {
        if (p < this.position || this.position + this.rows <= p) {
            this.position = p;
            this.updateDisplay();
        }
        String[] s = this.view.getItem(p);
        this.tmpSelectedButton = (AAToggleButton)this.listPanel.getComponent(p - this.position);
        if (this.selectedButton != null) {
            this.selectedButton.setBackground(Color.WHITE);
        }
        this.selectedButton = this.tmpSelectedButton;
        this.selectedButton.setBackground((Color)UIManager.getDefaults().get("Table.selectionBackground"));
        int spos = (p - this.position) * (this.listScrollPane.getVerticalScrollBar().getMaximum() / this.rows);
        this.listScrollPane.getVerticalScrollBar().setValue(spos -= this.listScrollPane.getSize().height / 2);
    }

    private void noDisplay() {
        this.listPanel.removeAll();
        this.listPanel.setVisible(false);
        JLabel j = new JLabel("\u8868\u793a\u3059\u308b\u30d5\u30a9\u30f3\u30c8\u304c\u3042\u308a\u307e\u305b\u3093\u3002", 0);
        j.setFont(new Font("Dialog", 0, 10));
        WeakReference<JLabel> wrl = new WeakReference<JLabel>(j);
        this.navInfoLabel.setFont(new Font("Dialog", 0, 10));
        this.navInfoLabel.setText("\u30d5\u30a9\u30f3\u30c8 0~0 \uff0f 0");
        this.listPanel.add((JLabel)wrl.get());
        this.listPanel.setVisible(true);
    }

    public void updateDisplay() {
        Font f = null;
        WeakReference<Font> wrf = null;
        WeakReference<AAToggleButton> wrb = null;
        this.listPanel.removeAll();
        this.listPanel.setVisible(false);
        int last = this.position + this.rows;
        int items = this.view.getNumItems();
        if (last > items) {
            last = items;
        }
        if (this.view.getNumItems() <= this.rows) {
            this.position = 0;
        }
        this.navInfoLabel.setFont(new Font("Dialog", 0, 10));
        this.navInfoLabel.setText("\u30d5\u30a9\u30f3\u30c8 " + (this.position + 1) + "~" + last + " / " + items);
        int i = this.position;
        while (i < last) {
            AAToggleButton tb;
            String[] font = this.view.getItem(i);
            if (font[1].equals("System Font")) {
                f = new Font(font[0].toString(), 0, this.fsize);
                wrf = new WeakReference<Font>(f);
            } else {
                try {
                    f = Font.createFont(0, new FileInputStream(String.valueOf(font[1]) + File.separator + font[0]));
                    wrf = new WeakReference<Font>(f);
                }
                catch (Exception e) {
                    f = null;
                }
            }
            if (f != null) {
                tb = new AAToggleButton(this.sampleText, font[0], font[1]);
                wrb = new WeakReference<AAToggleButton>(tb);
                ((AAToggleButton)wrb.get()).setBackground(Color.WHITE);
                ((AAToggleButton)wrb.get()).setFont(f.deriveFont(0, this.fsize));
                if (!(this.view instanceof FavouriteFontsPanel)) {
                    if (this.ffp.getItemNumber(font[0], font[1]) != -1) {
                        ((AAToggleButton)wrb.get()).setSelected(true);
                    }
                    ((AAToggleButton)wrb.get()).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            AAToggleButton source = (AAToggleButton)evt.getSource();
                            ListViewPanel.this.view.selectItem(source.getFName(), source.getFLoc());
                            if (source.isSelected()) {
                                ListViewPanel.this.ffp.addToFav(source.getFName(), source.getFLoc());
                            } else {
                                ListViewPanel.this.ffp.removeFromFav(source.getFName(), source.getFLoc());
                            }
                        }
                    });
                } else {
                    ((AAToggleButton)wrb.get()).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            AAToggleButton source = (AAToggleButton)evt.getSource();
                            ListViewPanel.this.ffp.removeFromFav(source.getFName(), source.getFLoc());
                        }
                    });
                }
            } else {
                tb = new AAToggleButton("\u30d5\u30a9\u30f3\u30c8\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30f3\u30c8\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "N/A");
            }
            this.listPanel.add((AAToggleButton)wrb.get());
            ++i;
        }
        this.listPanel.setVisible(true);
    }

    public void nextPage() {
        if (this.position + this.rows < this.view.getNumItems()) {
            this.position += this.rows;
            this.updateDisplay();
        }
    }

    public void prevPage() {
        if (this.position - this.rows >= 0) {
            this.position -= this.rows;
            this.updateDisplay();
        } else if (this.position - this.rows < 0 && this.position != 0) {
            this.position = 0;
            this.updateDisplay();
        }
    }

    private void initComponents() {
        this.optionsPanel = new JPanel();
        this.fontsPerPageLabel = new JLabel();
        this.fontsPerPageTextField = new JTextField();
        this.listScrollPane = new JScrollPane();
        this.listPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.prevButton = new JButton();
        this.navInfoLabel = new JLabel();
        this.nextButton = new JButton();
        this.setLayout(new BorderLayout(2, 2));
        this.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.optionsPanel.setLayout(new GridLayout(1, 0));
        this.optionsPanel.setPreferredSize(new Dimension(10, 20));
        this.fontsPerPageLabel.setHorizontalAlignment(0);
        this.fontsPerPageLabel.setFont(new Font("Dialog", 0, 10));
        this.fontsPerPageLabel.setText("\u30d5\u30a9\u30f3\u30c8/\u30da\u30fc\u30b8");
        this.fontsPerPageLabel.setToolTipText("\u30da\u30fc\u30b8\u6bce\u306b\u30d5\u30a9\u30f3\u30c8\u3092\u8868\u793a");
        this.optionsPanel.add(this.fontsPerPageLabel);
        this.fontsPerPageTextField.setFont(new Font("Dialog", 0, 10));
        this.fontsPerPageTextField.setText(String.valueOf(this.rows));
        this.fontsPerPageTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ListViewPanel.this.fontsPerPageTextFieldKeyReleased(evt);
            }
        });
        this.optionsPanel.add(this.fontsPerPageTextField);
        this.add((Component)this.optionsPanel, "North");
        this.listScrollPane.setBorder(null);
        this.listScrollPane.setMinimumSize(new Dimension(300, 22));
        this.listPanel.setLayout(new GridLayout(1, 1));
        this.listPanel.setMinimumSize(new Dimension(300, 0));
        this.listPanel.setLayout(new GridLayout(this.rows, this.columns, 2, 0));
        this.listScrollPane.setViewportView(this.listPanel);
        this.add((Component)this.listScrollPane, "Center");
        this.navigationPanel.setLayout(new FlowLayout(1, 5, 0));
        this.navigationPanel.setPreferredSize(new Dimension(250, 26));
        this.prevButton.setFont(new Font("Dialog", 0, 10));
        this.prevButton.setText("<");
        this.prevButton.setToolTipText("\u524d\u306e\u30da\u30fc\u30b8");
        this.prevButton.setFocusPainted(false);
        this.prevButton.setPreferredSize(new Dimension(41, 20));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListViewPanel.this.prevButtonActionPerformed(evt);
            }
        });
        this.navigationPanel.add(this.prevButton);
        this.navInfoLabel.setHorizontalAlignment(0);
        this.navInfoLabel.setFont(new Font("Dialog", 0, 10));
        this.navInfoLabel.setText("\u30d5\u30a9\u30f3\u30c8 0~0 \uff0f 0");
        this.navInfoLabel.setPreferredSize(new Dimension(150, 20));
        this.navigationPanel.add(this.navInfoLabel);
        this.nextButton.setFont(new Font("Dialog", 0, 10));
        this.nextButton.setText(">");
        this.nextButton.setToolTipText("\u6b21\u306e\u30da\u30fc\u30b8");
        this.nextButton.setFocusPainted(false);
        this.nextButton.setPreferredSize(new Dimension(41, 20));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListViewPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.navigationPanel.add(this.nextButton);
        this.add((Component)this.navigationPanel, "South");
    }

    private void fontsPerPageTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int i;
                this.rows = i = Integer.parseInt(this.fontsPerPageTextField.getText());
                this.listPanel.setLayout(new GridLayout(this.rows, this.columns, 2, 0));
                this.updateDisplay();
            }
            catch (NumberFormatException nfe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.prevPage();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.nextPage();
    }

    private void exitForm(WindowEvent evt) {
    }
}

