/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.components;

import FontViewer.components.ListPanel;
import FontViewer.filters.FontFileFilter;
import FontViewer.util.QuickSort;
import FontViewer.windows.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class OtherFontsPanel
extends JPanel
implements ListPanel {
    private File currentDirectory;
    private String[] fnames;
    private String[] fontnames;
    private MainWindow mw;
    private JButton browseButton;
    private JLabel locationLabel;
    private JPanel locationPanel;
    private JTextField locationTextField;
    private JList otherFontsList;
    private JScrollPane otherFontsScrollPane;

    public OtherFontsPanel(MainWindow mw) {
        this.mw = mw;
        this.initComponents();
    }

    @Override
    public String[] getItem(int itemNumber) {
        String[] s = new String[3];
        if (itemNumber >= 0 && itemNumber < this.fnames.length) {
            s[0] = this.fnames[itemNumber];
            s[1] = this.currentDirectory.toString();
            s[2] = String.valueOf(itemNumber);
        }
        return s;
    }

    @Override
    public int getNumItems() {
        int items = 0;
        if (this.fnames != null) {
            items = this.fnames.length;
        }
        return items;
    }

    @Override
    public String[] getCurrentItem() {
        String[] s = new String[3];
        int p = this.otherFontsList.getSelectedIndex();
        if (p >= 0) {
            s[0] = this.fnames[p];
            s[1] = this.currentDirectory.toString();
            s[2] = String.valueOf(p);
        }
        return s;
    }

    @Override
    public int getCurrentItemNum() {
        return this.otherFontsList.getSelectedIndex();
    }

    private void updateFontNames() {
        Font f = null;
        WeakReference<Font> wrf = null;
        String fontfile = "";
        this.fontnames = new String[this.fnames.length];
        int i = 0;
        while (i < this.fnames.length) {
            try {
                fontfile = String.valueOf(this.currentDirectory.toString()) + File.separator + this.fnames[i];
                System.out.println("FF: " + fontfile);
                f = Font.createFont(0, new FileInputStream(fontfile));
                wrf = new WeakReference<Font>(f);
                this.fontnames[i] = ((Font)wrf.get()).getName();
            }
            catch (IOException ioe) {
                this.fontnames[i] = String.valueOf(this.fnames[i]) + "\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002 [IOException]";
            }
            catch (FontFormatException ffe) {
                this.fontnames[i] = String.valueOf(this.fnames[i]) + "\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002 [FontFormatException]";
            }
            ++i;
        }
    }

    private void updateDisplay() {
        this.fnames = this.currentDirectory.list(new FontFileFilter());
        QuickSort.sort(this.fnames, true);
        if (this.fnames.length == 0) {
            String[] message = new String[]{"\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u306b\u306f\u30d5\u30a9\u30f3\u30c8\u304c\u3042\u308a\u307e\u305b\u3093\u3002"};
            this.otherFontsList.setListData(message);
            this.otherFontsList.setEnabled(false);
        } else {
            this.otherFontsList.setListData(this.fnames);
            this.otherFontsList.setEnabled(true);
        }
        this.mw.updateDisplay();
    }

    @Override
    public void selectItem(String name, String loc) {
        this.otherFontsList.setSelectedValue(name, true);
        int p = this.otherFontsList.getSelectedIndex();
        if (p >= 0) {
            this.mw.setCurrentFont(this.fnames[p].toString(), this.currentDirectory.toString(), p);
        }
    }

    @Override
    public void selectNext() {
        int i = this.otherFontsList.getSelectedIndex();
        if (i >= 0) {
            if (i + 1 < this.fnames.length) {
                ++i;
            }
            this.setCurrentItem(i, true);
        } else {
            this.setCurrentItem(0, true);
        }
    }

    @Override
    public void selectPrev() {
        int i = this.otherFontsList.getSelectedIndex();
        if (i >= 0) {
            if (i - 1 >= 0) {
                --i;
            }
            this.setCurrentItem(i, true);
        } else {
            this.setCurrentItem(0, true);
        }
    }

    private void setCurrentItem(int p, boolean internal) {
        if (this.fnames != null) {
            if (internal) {
                this.otherFontsList.setSelectedIndex(p);
                int spos = p * (this.otherFontsScrollPane.getVerticalScrollBar().getMaximum() / this.fnames.length);
                this.otherFontsScrollPane.getVerticalScrollBar().setValue(spos -= this.otherFontsScrollPane.getSize().height / 2);
            }
            if (p >= 0) {
                this.mw.setCurrentFont(this.fnames[p].toString(), this.currentDirectory.toString(), p);
            }
        }
    }

    private void initComponents() {
        this.locationPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.browseButton = new JButton();
        this.otherFontsScrollPane = new JScrollPane();
        this.otherFontsList = new JList();
        this.setLayout(new BorderLayout(2, 2));
        this.locationPanel.setLayout(new BorderLayout(4, 0));
        this.locationLabel.setFont(new Font("Dialog", 0, 10));
        this.locationLabel.setText("\u30d5\u30a9\u30eb\u30c0\uff1a");
        this.locationPanel.add((Component)this.locationLabel, "West");
        this.locationTextField.setFont(new Font("Dialog", 0, 10));
        this.locationTextField.setToolTipText("\u8868\u793a\u3059\u308b\u30d5\u30a9\u30f3\u30c8\u304c\u3042\u308b\u30d5\u30a9\u30eb\u30c0\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a");
        this.locationTextField.setPreferredSize(new Dimension(100, 20));
        this.locationTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OtherFontsPanel.this.locationTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OtherFontsPanel.this.locationTextFieldFocusLost(evt);
            }
        });
        this.locationTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OtherFontsPanel.this.locationTextFieldKeyReleased(evt);
            }
        });
        this.locationPanel.add((Component)this.locationTextField, "Center");
        this.browseButton.setFont(new Font("Dialog", 0, 10));
        this.browseButton.setText("\u53c2\u7167");
        this.browseButton.setToolTipText("\u30d5\u30a9\u30f3\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u53c2\u7167");
        this.browseButton.setPreferredSize(new Dimension(81, 20));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OtherFontsPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.browseButton, "East");
        this.add((Component)this.locationPanel, "North");
        this.otherFontsScrollPane.setBorder(null);
        this.otherFontsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OtherFontsPanel.this.otherFontsListKeyReleased(evt);
            }
        });
        this.otherFontsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OtherFontsPanel.this.otherFontsListMouseClicked(evt);
            }
        });
        this.otherFontsScrollPane.setViewportView(this.otherFontsList);
        this.add((Component)this.otherFontsScrollPane, "Center");
    }

    private void locationTextFieldFocusLost(FocusEvent evt) {
        this.mw.setTyping(false);
    }

    private void locationTextFieldFocusGained(FocusEvent evt) {
        this.mw.setTyping(true);
    }

    private void otherFontsListKeyReleased(KeyEvent evt) {
        this.setCurrentItem(this.otherFontsList.getSelectedIndex(), false);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(new File(""));
        fc.setFileSelectionMode(1);
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() != null) {
            this.currentDirectory = fc.getSelectedFile();
            this.locationTextField.setText(this.currentDirectory.toString());
            this.updateDisplay();
        }
    }

    private void otherFontsListMouseClicked(MouseEvent evt) {
        this.setCurrentItem(this.otherFontsList.getSelectedIndex(), false);
    }

    private void locationTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.mw.setTyping(false);
            File f = new File(this.locationTextField.getText());
            if (f.exists()) {
                if (f.isDirectory()) {
                    this.currentDirectory = f;
                    this.updateDisplay();
                } else {
                    new JOptionPane();
                    JOptionPane.showMessageDialog(this, "\u30d5\u30a9\u30eb\u30c0\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 0);
                }
            } else {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "\u30d5\u30a9\u30eb\u30c0\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
    }

    private void exitForm(WindowEvent evt) {
    }
}

