/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.components;

import FontViewer.components.AATextPane;
import FontViewer.windows.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class SampleTextPanel
extends JPanel {
    private final int BOLD = 0;
    private final int ITALIC = 1;
    private final int UNDERLINE = 2;
    private Vector fontSizes;
    private String sampleText;
    private String fname;
    private String floc;
    private int fsize;
    private boolean[] fontProperties = new boolean[3];
    private MainWindow mw;
    private JButton addFavouritesButton;
    private JToggleButton boldButton;
    private JPanel fontInfoPanel;
    private JLabel fontName;
    private JLabel fontNameLabel;
    private JPanel fontPropertiesPanel;
    private JComboBox fontSizeComboBox;
    private JLabel fontSizeLabel;
    private JPanel fontSizePanel;
    private JToggleButton italicsButton;
    private JPanel optionsPanel;
    private JTextPane previewTextPane;
    private JScrollPane previewTextPaneScollPane;
    private JPanel topPanel;
    private JToggleButton underlineButton;

    public SampleTextPanel(MainWindow mw, int[] sizes) {
        this.mw = mw;
        this.sampleText = ResourceBundle.getBundle("FontViewer.resources.Opcion").getString("defaultSampleText");
        this.initFontSizes(sizes);
        this.initComponents();
        this.fname = "Default";
        this.floc = "System Font";
        this.fontSizeComboBox.setSelectedItem(this.fontSizes.get(9));
    }

    private void initFontSizes(int[] sizes) {
        this.fontSizes = new Vector(sizes.length);
        int i = 0;
        while (i < sizes.length) {
            this.fontSizes.add(new Integer(sizes[i]));
            ++i;
        }
    }

    public void setSampleText(String s) {
        this.sampleText = s;
        this.previewTextPane.setText(this.sampleText);
    }

    public void setCurrentFont(String name, String loc) {
        this.fname = name;
        this.floc = loc;
        if (!loc.equals("System Font")) {
            try {
                Font chosenFont = Font.createFont(0, new FileInputStream(String.valueOf(loc) + File.separator + this.fname));
                WeakReference<Font> wrf = new WeakReference<Font>(chosenFont);
                this.fname = ((Font)wrf.get()).getName();
            }
            catch (Exception e) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "\u30d5\u30a9\u30f3\u30c8\u306e\u8aad\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
        this.updateDisplay();
    }

    public void setFavButtonAction(String action) {
        this.addFavouritesButton.setText(action);
    }

    private void updateDisplay() {
        this.fontName.setText(this.fname);
        this.fontName.setToolTipText(this.fname);
        Style s = this.previewTextPane.getStyle("default");
        StyleConstants.setFontFamily(s, this.fname);
        StyleConstants.setFontSize(s, this.fsize);
        StyleConstants.setBold(s, this.fontProperties[0]);
        StyleConstants.setItalic(s, this.fontProperties[1]);
        StyleConstants.setUnderline(s, this.fontProperties[2]);
        this.previewTextPane.setParagraphAttributes(s, true);
    }

    private void initComponents() {
        this.previewTextPaneScollPane = new JScrollPane();
        this.previewTextPane = new AATextPane();
        this.topPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.fontPropertiesPanel = new JPanel();
        this.boldButton = new JToggleButton();
        this.italicsButton = new JToggleButton();
        this.underlineButton = new JToggleButton();
        this.addFavouritesButton = new JButton();
        this.fontInfoPanel = new JPanel();
        this.fontSizePanel = new JPanel();
        this.fontSizeLabel = new JLabel();
        this.fontSizeComboBox = new JComboBox(this.fontSizes);
        this.fontName = new JLabel();
        this.fontNameLabel = new JLabel();
        this.setLayout(new BorderLayout(2, 2));
        this.setBorder(new TitledBorder("\u30b5\u30f3\u30d7\u30eb\u30c6\u30ad\u30b9\u30c8"));
        this.previewTextPaneScollPane.setBorder(null);
        this.previewTextPane.setFont(new Font("Dialog", 0, 10));
        this.previewTextPane.setBorder(null);
        this.previewTextPane.setEditable(false);
        this.previewTextPane.setText(this.sampleText);
        this.previewTextPaneScollPane.setViewportView(this.previewTextPane);
        this.add((Component)this.previewTextPaneScollPane, "Center");
        this.topPanel.setLayout(new GridLayout(2, 0, 0, 2));
        this.topPanel.setPreferredSize(new Dimension(10, 42));
        this.optionsPanel.setLayout(new BorderLayout(2, 2));
        this.optionsPanel.setPreferredSize(new Dimension(10, 24));
        this.fontPropertiesPanel.setLayout(new GridLayout(1, 3, 2, 0));
        this.fontPropertiesPanel.setPreferredSize(new Dimension(64, 20));
        this.boldButton.setText("B");
        this.boldButton.setFont(new Font("Dialog", 2, 12));
        this.boldButton.setToolTipText("\u30dc\u30fc\u30eb\u30c9");
        this.boldButton.setMargin(new Insets(2, 2, 2, 2));
        this.boldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleTextPanel.this.boldButtonActionPerformed(evt);
            }
        });
        this.fontPropertiesPanel.add(this.boldButton);
        this.italicsButton.setText("I");
        this.italicsButton.setFont(new Font("Dialog", 3, 12));
        this.italicsButton.setToolTipText("\u30a4\u30bf\u30ea\u30c3\u30af");
        this.italicsButton.setMargin(new Insets(2, 2, 2, 2));
        this.italicsButton.setPreferredSize(new Dimension(20, 20));
        this.italicsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleTextPanel.this.italicsButtonActionPerformed(evt);
            }
        });
        this.fontPropertiesPanel.add(this.italicsButton);
        this.underlineButton.setText("U");
        this.underlineButton.setFont(new Font("Dialog", 3, 12));
        this.underlineButton.setToolTipText("\u4e0b\u7dda");
        this.underlineButton.setMargin(new Insets(2, 2, 2, 2));
        this.underlineButton.setPreferredSize(new Dimension(20, 20));
        this.underlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleTextPanel.this.underlineButtonActionPerformed(evt);
            }
        });
        this.fontPropertiesPanel.add(this.underlineButton);
        this.optionsPanel.add((Component)this.fontPropertiesPanel, "West");
        this.addFavouritesButton.setFont(new Font("Dialog", 0, 10));
        this.addFavouritesButton.setText("\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0");
        this.addFavouritesButton.setMargin(new Insets(2, 2, 2, 2));
        this.addFavouritesButton.setPreferredSize(new Dimension(130, 20));
        this.addFavouritesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleTextPanel.this.addFavouritesButtonActionPerformed(evt);
            }
        });
        this.optionsPanel.add((Component)this.addFavouritesButton, "East");
        this.topPanel.add(this.optionsPanel);
        this.fontInfoPanel.setLayout(new BorderLayout(2, 2));
        this.fontSizePanel.setLayout(new GridLayout(1, 2));
        this.fontSizePanel.setPreferredSize(new Dimension(142, 24));
        this.fontSizeLabel.setFont(new Font("Dialog", 0, 8));
        this.fontSizeLabel.setHorizontalAlignment(4);
        this.fontSizeLabel.setText("\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\uff1a");
        this.fontSizePanel.add(this.fontSizeLabel);
        this.fontSizeComboBox.setFont(new Font("Dialog", 0, 12));
        this.fontSizeComboBox.setPreferredSize(new Dimension(31, 24));
        this.fontSizeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SampleTextPanel.this.fontSizeComboBoxItemStateChanged(evt);
            }
        });
        this.fontSizePanel.add(this.fontSizeComboBox);
        this.fontInfoPanel.add((Component)this.fontSizePanel, "East");
        this.fontName.setFont(new Font("Dialog", 0, 12));
        this.fontName.setText("\u30d5\u30a9\u30f3\u30c8\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
        this.fontInfoPanel.add((Component)this.fontName, "Center");
        this.fontNameLabel.setFont(new Font("Dialog", 0, 12));
        this.fontNameLabel.setText("\u30d5\u30a9\u30f3\u30c8\u540d\uff1a");
        this.fontInfoPanel.add((Component)this.fontNameLabel, "West");
        this.topPanel.add(this.fontInfoPanel);
        this.add((Component)this.topPanel, "North");
    }

    private void fontSizeComboBoxItemStateChanged(ItemEvent evt) {
        this.fsize = (Integer)this.fontSizes.get(this.fontSizeComboBox.getSelectedIndex());
        this.updateDisplay();
        this.mw.setFontSize(this.fsize);
    }

    private void underlineButtonActionPerformed(ActionEvent evt) {
        this.fontProperties[2] = this.underlineButton.isSelected();
        this.updateDisplay();
    }

    private void italicsButtonActionPerformed(ActionEvent evt) {
        this.fontProperties[1] = this.italicsButton.isSelected();
        this.updateDisplay();
    }

    private void boldButtonActionPerformed(ActionEvent evt) {
        this.fontProperties[0] = this.boldButton.isSelected();
        this.updateDisplay();
    }

    private void addFavouritesButtonActionPerformed(ActionEvent evt) {
        if (this.addFavouritesButton.getText().length() <= 8) {
            this.mw.addToFav();
        } else {
            this.mw.removeFromFav();
        }
    }

    private void exitForm(WindowEvent evt) {
    }
}

