/*
 * Decompiled with CFR 0.152.
 */
package com.xlreader.shared.io;

import com.xlreader.shared.lang.MySystem;
import com.xlreader.shared.swing.optionpane.OPAbstract;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class S_ToBrowserDefault {
    private static final String _f_s_strClass = "com.xlreader.shared.io.S_ToBrowserDefault.";
    private static final String _f_s_strOsWindows = "windows";
    private static final String _f_s_strOsLinux = "linux";
    private static final String _f_s_strActionWindows = "rundll32";
    private static final String _f_s_strFlagWindows = "url.dll,FileProtocolHandler";
    private static final String _f_s_strActionUnix = "netscape";
    private static final String _f_s_strFlagUnix = "-remote openURL";
    private static String _s_strWarningTitle = null;
    private static String _s_strWarningBody = null;

    public static boolean s_displayURL(String strUrl) {
        block12: {
            String f_strMethod = "com.xlreader.shared.io.S_ToBrowserDefault.s_displayURL(strUrl)";
            if (strUrl == null) {
                MySystem.s_printOutError(f_strMethod, "nil strUrl");
                return false;
            }
            MySystem.s_printOutTrace(f_strMethod, "strUrl=" + strUrl);
            boolean blnWindows = S_ToBrowserDefault._s_isWindowsPlatform();
            String strCmd = null;
            try {
                if (blnWindows) {
                    strCmd = "rundll32 url.dll,FileProtocolHandler " + strUrl;
                    Runtime.getRuntime().exec(strCmd);
                    break block12;
                }
                boolean blnSendMail = strUrl.toLowerCase().startsWith("mailto:");
                if (blnSendMail && S_ToBrowserDefault._s_isLinuxPlatform()) {
                    MySystem.s_printOutWarning(f_strMethod, "blnSendMail && _s_isLinuxPlatform: not done yet, handle spaces in subject (if any)");
                }
                strCmd = "netscape -remote openURL(" + strUrl + ")";
                MySystem.s_printOutTrace(f_strMethod, "strCmd=" + strCmd);
                Process prc = Runtime.getRuntime().exec(strCmd);
                try {
                    int intExitValue = prc.waitFor();
                    MySystem.s_printOutTrace(f_strMethod, "intExitValue=" + intExitValue);
                    if (intExitValue != 0) {
                        if (blnSendMail) {
                            if (!OPAbstract.s_showWarningConfirmDialog(null, _s_strWarningTitle, _s_strWarningBody)) {
                                MySystem.s_printOutTrace(f_strMethod, "action cancelled by user, strCmd=" + strCmd);
                                return true;
                            }
                        } else {
                            strCmd = "netscape " + strUrl;
                        }
                        MySystem.s_printOutTrace(f_strMethod, "strCmd=" + strCmd);
                        Runtime.getRuntime().exec(strCmd);
                    }
                }
                catch (InterruptedException excInterrupted) {
                    excInterrupted.printStackTrace();
                    MySystem.s_printOutError(f_strMethod, "excInterrupted caught, strCmd=" + strCmd);
                    return false;
                }
            }
            catch (IOException excIO) {
                excIO.printStackTrace();
                MySystem.s_printOutError(f_strMethod, "excIO caught, strCmd=" + strCmd);
                return false;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                MySystem.s_printOutError(f_strMethod, "exc caught, strCmd=" + strCmd);
                return false;
            }
        }
        return true;
    }

    private static boolean _s_isLinuxPlatform() {
        String f_strMethod = "com.xlreader.shared.io.S_ToBrowserDefault._s_isLinuxPlatform()";
        String strOsName = null;
        try {
            strOsName = System.getProperty("os.name");
        }
        catch (SecurityException excSecurity) {
            excSecurity.printStackTrace();
            MySystem.s_printOutExit(f_strMethod, "excSecurity caught");
        }
        if (strOsName == null) {
            MySystem.s_printOutExit(f_strMethod, "nil strOsName");
        }
        return strOsName.toLowerCase().startsWith(_f_s_strOsLinux);
    }

    private static boolean _s_isWindowsPlatform() {
        String f_strMethod = "com.xlreader.shared.io.S_ToBrowserDefault._s_isWindowsPlatform()";
        String strOsName = null;
        try {
            strOsName = System.getProperty("os.name");
        }
        catch (SecurityException excSecurity) {
            excSecurity.printStackTrace();
            MySystem.s_printOutExit(f_strMethod, "excSecurity caught");
        }
        if (strOsName == null) {
            MySystem.s_printOutExit(f_strMethod, "nil strOsName");
        }
        return strOsName.toLowerCase().startsWith(_f_s_strOsWindows);
    }

    static {
        String f_strBundleFileShort = "com.xlreader.shared._res.bundle.S_ToBrowserDefault";
        String f_strBundleFileLong = "com.xlreader.shared._res.bundle.S_ToBrowserDefault.properties";
        try {
            ResourceBundle rbeResources = ResourceBundle.getBundle("com.xlreader.shared._res.bundle.S_ToBrowserDefault", Locale.getDefault());
            _s_strWarningTitle = rbeResources.getString("warningTitle");
            _s_strWarningBody = rbeResources.getString("warningBody");
        }
        catch (MissingResourceException excMissingResource) {
            excMissingResource.printStackTrace();
            MySystem.s_printOutExit(_f_s_strClass, "excMissingResource caught");
        }
    }
}

