/*****************************************************************************************
 * Copyright (c) 2004 Andrei Loskutov. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the BSD License which
 * accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/bsd-license.php Contributor: Andrei Loskutov -
 * initial API and implementation
 *
 * Last modified by: HOzawa
 *
 ****************************************************************************************/
package de.loskutov.bco.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;

import de.loskutov.bco.BytecodeOutlinePlugin;

/**
 * @author Andrei
 */
public class CompareBytecodeAction extends BytecodeAction implements IObjectActionDelegate {

    /**
     * (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        IJavaElement[] resources = getSelectedResources();        
        try {
            exec(resources[0], resources[1]);
        } catch (Exception e) {
            BytecodeOutlinePlugin.error("r̎sɎs܂F "
                + e.getMessage(), e);
        }
    }

}
