﻿
// --------------------------------------------------------------------------------------
// <auto-generated>
//
//   Generatorinformationen!
//   Generiert mit OAW am: 
//   Bitte manuellen Code nur in den PROTECTED REGIONS einpflegen!
//
// </auto-generated> 
// --------------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Data.SqlClient;
using System.Transactions;
using System.Text;
using MEGAsoft.Servis.Types;
using MEGAsoft.Servis.Types.Controlling;
using MEGAsoft.Servis.Data.Controlling.Contracts;
using MEGAsoft.Servis.Services.Common;


namespace MEGAsoft.Servis.Data.Controlling.Linq
{

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceOrderArtEntity
    /// </summary>
    public partial class ServiceOrderArtEntity : IServiceOrderArtEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(OrderArtEntityF paramF);
        partial void Lesen_NachImpl(OrderArtEntityF paramF, OrderArtEntityA paramA);
        partial void Loeschen_VorImpl(OrderArtEntityF param);
        partial void Loeschen_NachImpl(OrderArtEntityF paramF, OrderArtEntityA paramA);
        partial void Neu_VorImpl(OrderArtEntityF paramF);
        partial void Neu_NachImpl(OrderArtEntityF paramF, OrderArtEntityA paramA);
        partial void Speichern_VorImpl(OrderArtEntityF param);
        partial void Speichern_NachImpl(OrderArtEntityF paramF, OrderArtEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"OrderArtEntityA"</returns>
        OrderArtEntityA IServiceOrderArtEntity.Lesen(OrderArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            OrderArtEntityA ret = new OrderArtEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" OrderArt.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            if (!string.IsNullOrEmpty(param.VolltextSuche))
            {
                StringBuilder suchbedingung = new StringBuilder();
                string[] fields = new string[2];
                fields[0] = "OrderArt.BESTELLNUMMER";
                fields[1] = "OrderArt.BEZEICHNUNG";
                string[] volltextsuche = param.VolltextSuche.Split(' ');
                for (int j = 0; j < fields.Length; j++)
                {
                    StringBuilder suchbez = new StringBuilder();
                    for (int i = 0; i < volltextsuche.Length; i++)
                    {
                        suchbez.Append(" AND lower(" + fields[j] + ") LIKE '%");
                        suchbez.Append(volltextsuche[i].ToLower().Trim());
                        suchbez.Append("%'");
                    }
                    suchbez.Remove(0, 4); 		// erste UND bedingung muss weg
                    suchbez.Insert(0, " OR (");
                    suchbez.Append(") ");
                    suchbedingung.Append(suchbez.ToString());
                }
                suchbedingung.Remove(0, 3); 		// erste OR bedingung muss weg
                suchbedingung.Insert(0, " AND ( ");
                suchbedingung.Append(") ");

                strFilter.Append(suchbedingung.ToString());
            }
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND OrderArt.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(OrderArt.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(OrderArt.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(OrderArt.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(OrderArt.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.BestellEinheit != Guid.Empty)
            {
                strFilter.Append(" AND OrderArt.bestelleinheit='");
                strFilter.Append(param.Filter.BestellEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.OrganisationsEinheit != Guid.Empty)
            {
                strFilter.Append(" AND OrderArt.organisationseinheit='");
                strFilter.Append(param.Filter.OrganisationsEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.Artikel != Guid.Empty)
            {
                strFilter.Append(" AND OrderArt.artikel='");
                strFilter.Append(param.Filter.Artikel.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.Komission != Guid.Empty)
            {
                strFilter.Append(" AND OrderArt.Komission='");
                strFilter.Append(param.Filter.Komission.ToString());
                strFilter.Append("' ");
            }
            if (!string.IsNullOrEmpty(param.Filter.BestellNummer))
            {
                strFilter.Append(" AND lower(OrderArt.BESTELLNUMMER) LIKE '%");
                strFilter.Append(param.Filter.BestellNummer.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.Artikelpreis != 0.0)
            {
                int iDec = param.Filter.Artikelpreis.ToString().Length - (param.Filter.Artikelpreis.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(OrderArt.artikelpreis,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.Artikelpreis.ToString().Replace(",", "."));
            }
            if (param.Filter.Menge != 0.0)
            {
                int iDec = param.Filter.Menge.ToString().Length - (param.Filter.Menge.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(OrderArt.menge,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.Menge.ToString().Replace(",", "."));
            }
            if (!string.IsNullOrEmpty(param.Filter.Bezeichnung))
            {
                strFilter.Append(" AND lower(OrderArt.BEZEICHNUNG) LIKE '%");
                strFilter.Append(param.Filter.Bezeichnung.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GueltigkeitsDatum != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(OrderArt.GUELTIGKEITSDATUM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GueltigkeitsDatum.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.DauerOrderArt == true)
                strFilter.Append(" AND OrderArt.dauerOrderArt=1");
            if (param.Filter.BestellVorlaufInTagen != 0)
            {
                strFilter.Append(" AND OrderArt.bestellvorlaufintagen=");
                strFilter.Append(param.Filter.BestellVorlaufInTagen.ToString());
            }
            if (param.Filter.IstVorzugsKomission == true)
                strFilter.Append(" AND OrderArt.istvorzugsKomission=1");

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung
            strSortierung.Append("OrderArt.BEZEICHNUNG");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.OrderArt");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int bestelleinheitOid = sqlReader.GetOrdinal("bestelleinheit");
                    int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                    int artikelOid = sqlReader.GetOrdinal("artikel");
                    int KomissionOid = sqlReader.GetOrdinal("Komission");
                    int bestellnummerOid = sqlReader.GetOrdinal("bestellnummer");
                    int artikelpreisOid = sqlReader.GetOrdinal("artikelpreis");
                    int mengeOid = sqlReader.GetOrdinal("menge");
                    int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                    int gueltigkeitsdatumOid = sqlReader.GetOrdinal("gueltigkeitsdatum");
                    int dauerOrderArtOid = sqlReader.GetOrdinal("dauerOrderArt");
                    int bestellvorlaufintagenOid = sqlReader.GetOrdinal("bestellvorlaufintagen");
                    int istvorzugsKomissionOid = sqlReader.GetOrdinal("istvorzugsKomission");

                    while (sqlReader.Read())
                    {
                        OrderArtEntityDM rs = new OrderArtEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.BestellEinheit = sqlReader.IsDBNull(bestelleinheitOid) ? Guid.Empty : sqlReader.GetGuid(bestelleinheitOid);
                        rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                        rs.Artikel = sqlReader.IsDBNull(artikelOid) ? Guid.Empty : sqlReader.GetGuid(artikelOid);
                        rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                        rs.BestellNummer = sqlReader.IsDBNull(bestellnummerOid) ? string.Empty : sqlReader.GetString(bestellnummerOid);
                        if (!sqlReader.IsDBNull(artikelpreisOid))
                            rs.Artikelpreis = sqlReader.GetDouble(artikelpreisOid);
                        if (!sqlReader.IsDBNull(mengeOid))
                            rs.Menge = sqlReader.GetDouble(mengeOid);
                        rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                        rs.GueltigkeitsDatum = sqlReader.IsDBNull(gueltigkeitsdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigkeitsdatumOid);
                        rs.DauerOrderArt = sqlReader.IsDBNull(dauerOrderArtOid) ? false : sqlReader.GetBoolean(dauerOrderArtOid);
                        if (!sqlReader.IsDBNull(bestellvorlaufintagenOid))
                            rs.BestellVorlaufInTagen = sqlReader.GetInt32(bestellvorlaufintagenOid);
                        rs.IstVorzugsKomission = sqlReader.IsDBNull(istvorzugsKomissionOid) ? false : sqlReader.GetBoolean(istvorzugsKomissionOid);

                        rs.DisableUpdateMask = false;
                        ret.OrderArtEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "OrderArt";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"OrderArtEntityA"</returns>
        OrderArtEntityA IServiceOrderArtEntity.Loeschen(OrderArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            OrderArtEntityA ret = new OrderArtEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_OrderArt_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"OrderArt";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.OrderArtEntity.Count; i++)
                    {
                        if (param.OrderArtEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.OrderArtEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.OrderArtEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.OrderArtEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"OrderArtEntityA"</returns>
        OrderArtEntityA IServiceOrderArtEntity.Neu(OrderArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            OrderArtEntityA ret = new OrderArtEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_OrderArt_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.OrderArtEntity.Count; i++)
                    {
                        //if (param.OrderArtEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.OrderArtEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.OrderArtEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.OrderArtEntity[i].BestellEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@bestelleinheit"].Value = (Guid)param.OrderArtEntity[i].BestellEinheit;
                        else
                            sqlCommand1.Parameters["@bestelleinheit"].Value = DBNull.Value;
                        if (param.OrderArtEntity[i].OrganisationsEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.OrderArtEntity[i].OrganisationsEinheit;
                        else
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        if (param.OrderArtEntity[i].Artikel != Guid.Empty)
                            sqlCommand1.Parameters["@artikel"].Value = (Guid)param.OrderArtEntity[i].Artikel;
                        else
                            sqlCommand1.Parameters["@artikel"].Value = DBNull.Value;
                        if (param.OrderArtEntity[i].Komission != Guid.Empty)
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.OrderArtEntity[i].Komission;
                        else
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@bestellnummer"].Value = (string)param.OrderArtEntity[i].BestellNummer;
                        sqlCommand1.Parameters["@artikelpreis"].Value = (double)param.OrderArtEntity[i].Artikelpreis;
                        sqlCommand1.Parameters["@menge"].Value = (double)param.OrderArtEntity[i].Menge;
                        sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.OrderArtEntity[i].Bezeichnung;
                        sqlCommand1.Parameters["@gueltigkeitsdatum"].Value = (DateTime)param.OrderArtEntity[i].GueltigkeitsDatum;
                        sqlCommand1.Parameters["@dauerOrderArt"].Value = (short)param.OrderArtEntity[i].DauerOrderArt;
                        sqlCommand1.Parameters["@bestellvorlaufintagen"].Value = (int)param.OrderArtEntity[i].BestellVorlaufInTagen;
                        sqlCommand1.Parameters["@istvorzugsKomission"].Value = (short)param.OrderArtEntity[i].IstVorzugsKomission;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int bestelleinheitOid = sqlReader.GetOrdinal("bestelleinheit");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int artikelOid = sqlReader.GetOrdinal("artikel");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");
                        int bestellnummerOid = sqlReader.GetOrdinal("bestellnummer");
                        int artikelpreisOid = sqlReader.GetOrdinal("artikelpreis");
                        int mengeOid = sqlReader.GetOrdinal("menge");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int gueltigkeitsdatumOid = sqlReader.GetOrdinal("gueltigkeitsdatum");
                        int dauerOrderArtOid = sqlReader.GetOrdinal("dauerOrderArt");
                        int bestellvorlaufintagenOid = sqlReader.GetOrdinal("bestellvorlaufintagen");
                        int istvorzugsKomissionOid = sqlReader.GetOrdinal("istvorzugsKomission");


                        if (sqlReader.Read())
                        {
                            OrderArtEntityDM rs = new OrderArtEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.OrderArtEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.BestellEinheit = sqlReader.IsDBNull(bestelleinheitOid) ? Guid.Empty : sqlReader.GetGuid(bestelleinheitOid);
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.Artikel = sqlReader.IsDBNull(artikelOid) ? Guid.Empty : sqlReader.GetGuid(artikelOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                            rs.BestellNummer = sqlReader.IsDBNull(bestellnummerOid) ? string.Empty : sqlReader.GetString(bestellnummerOid);
                            if (!sqlReader.IsDBNull(artikelpreisOid))
                                rs.Artikelpreis = sqlReader.GetDouble(artikelpreisOid);
                            if (!sqlReader.IsDBNull(mengeOid))
                                rs.Menge = sqlReader.GetDouble(mengeOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.GueltigkeitsDatum = sqlReader.IsDBNull(gueltigkeitsdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigkeitsdatumOid);
                            rs.DauerOrderArt = sqlReader.IsDBNull(dauerOrderArtOid) ? false : sqlReader.GetBoolean(dauerOrderArtOid);
                            if (!sqlReader.IsDBNull(bestellvorlaufintagenOid))
                                rs.BestellVorlaufInTagen = sqlReader.GetInt32(bestellvorlaufintagenOid);
                            rs.IstVorzugsKomission = sqlReader.IsDBNull(istvorzugsKomissionOid) ? false : sqlReader.GetBoolean(istvorzugsKomissionOid);

                            rs.DisableUpdateMask = false;
                            ret.OrderArtEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"OrderArtEntityA"</returns>
        OrderArtEntityA IServiceOrderArtEntity.Speichern(OrderArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            OrderArtEntityA ret = new OrderArtEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_OrderArt_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.OrderArtEntity.Count; i++)
                    {
                        //if (param.OrderArtEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.OrderArtEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.OrderArtEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.OrderArtEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("BestellEinheit")) // && (param.OrderArtEntity[i].BestellEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@bestelleinheit"].Value = (Guid)param.OrderArtEntity[i].BestellEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestelleinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("OrganisationsEinheit")) // && (param.OrderArtEntity[i].OrganisationsEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.OrderArtEntity[i].OrganisationsEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Artikel")) // && (param.OrderArtEntity[i].Artikel != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@artikel"].Value = (Guid)param.OrderArtEntity[i].Artikel;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@artikel"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Komission")) // && (param.OrderArtEntity[i].Komission != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.OrderArtEntity[i].Komission;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BestellNummer"))
                        {
                            sqlCommand1.Parameters["@bestellnummer"].Value = (string)param.OrderArtEntity[i].BestellNummer;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestellnummer"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Artikelpreis"))
                        {
                            sqlCommand1.Parameters["@artikelpreis"].Value = (double)param.OrderArtEntity[i].Artikelpreis;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@artikelpreis"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Menge"))
                        {
                            sqlCommand1.Parameters["@menge"].Value = (double)param.OrderArtEntity[i].Menge;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@menge"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bezeichnung"))
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.OrderArtEntity[i].Bezeichnung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("GueltigkeitsDatum"))
                        {
                            sqlCommand1.Parameters["@gueltigkeitsdatum"].Value = (DateTime)param.OrderArtEntity[i].GueltigkeitsDatum;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@gueltigkeitsdatum"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("DauerOrderArt"))
                        {
                            sqlCommand1.Parameters["@dauerOrderArt"].Value = (short)param.OrderArtEntity[i].DauerOrderArt;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@dauerOrderArt"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BestellVorlaufInTagen"))
                        {
                            sqlCommand1.Parameters["@bestellvorlaufintagen"].Value = (int)param.OrderArtEntity[i].BestellVorlaufInTagen;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestellvorlaufintagen"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("IstVorzugsKomission"))
                        {
                            sqlCommand1.Parameters["@istvorzugsKomission"].Value = (short)param.OrderArtEntity[i].IstVorzugsKomission;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@istvorzugsKomission"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int bestelleinheitOid = sqlReader.GetOrdinal("bestelleinheit");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int artikelOid = sqlReader.GetOrdinal("artikel");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");
                        int bestellnummerOid = sqlReader.GetOrdinal("bestellnummer");
                        int artikelpreisOid = sqlReader.GetOrdinal("artikelpreis");
                        int mengeOid = sqlReader.GetOrdinal("menge");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int gueltigkeitsdatumOid = sqlReader.GetOrdinal("gueltigkeitsdatum");
                        int dauerOrderArtOid = sqlReader.GetOrdinal("dauerOrderArt");
                        int bestellvorlaufintagenOid = sqlReader.GetOrdinal("bestellvorlaufintagen");
                        int istvorzugsKomissionOid = sqlReader.GetOrdinal("istvorzugsKomission");


                        if (sqlReader.Read())
                        {
                            OrderArtEntityDM rs = new OrderArtEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.OrderArtEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.OrderArtEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.OrderArtEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.BestellEinheit = sqlReader.IsDBNull(bestelleinheitOid) ? Guid.Empty : sqlReader.GetGuid(bestelleinheitOid);
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.Artikel = sqlReader.IsDBNull(artikelOid) ? Guid.Empty : sqlReader.GetGuid(artikelOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                            rs.BestellNummer = sqlReader.IsDBNull(bestellnummerOid) ? string.Empty : sqlReader.GetString(bestellnummerOid);
                            if (!sqlReader.IsDBNull(artikelpreisOid))
                                rs.Artikelpreis = sqlReader.GetDouble(artikelpreisOid);
                            if (!sqlReader.IsDBNull(mengeOid))
                                rs.Menge = sqlReader.GetDouble(mengeOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.GueltigkeitsDatum = sqlReader.IsDBNull(gueltigkeitsdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigkeitsdatumOid);
                            rs.DauerOrderArt = sqlReader.IsDBNull(dauerOrderArtOid) ? false : sqlReader.GetBoolean(dauerOrderArtOid);
                            if (!sqlReader.IsDBNull(bestellvorlaufintagenOid))
                                rs.BestellVorlaufInTagen = sqlReader.GetInt32(bestellvorlaufintagenOid);
                            rs.IstVorzugsKomission = sqlReader.IsDBNull(istvorzugsKomissionOid) ? false : sqlReader.GetBoolean(istvorzugsKomissionOid);

                            rs.DisableUpdateMask = false;
                            ret.OrderArtEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new OrderArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        OrderArtLookupA IServiceOrderArtEntity.Lookup(OrderArtLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            OrderArtLookupA ret = new OrderArtLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "OrderArt");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.OrderArt");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID,BESTELLNUMMER,BEZEICHNUNG");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@sortfield", "BESTELLNUMMER");
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");
                        int bestellnummerOid = sqlReader.GetOrdinal("BESTELLNUMMER");
                        int bezeichnungOid = sqlReader.GetOrdinal("BEZEICHNUNG");

                        while (sqlReader.Read())
                        {
                            OrderArtLookupDM rs = new OrderArtLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                            rs.BestellNummer = sqlReader.IsDBNull(bestellnummerOid) ? string.Empty : sqlReader.GetString(bestellnummerOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);

                            ret.OrderArtLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new OrderArtLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceBestellungEntity
    /// </summary>
    public partial class ServiceBestellungEntity : IServiceBestellungEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(BestellungEntityF paramF);
        partial void Lesen_NachImpl(BestellungEntityF paramF, BestellungEntityA paramA);
        partial void Loeschen_VorImpl(BestellungEntityF param);
        partial void Loeschen_NachImpl(BestellungEntityF paramF, BestellungEntityA paramA);
        partial void Neu_VorImpl(BestellungEntityF paramF);
        partial void Neu_NachImpl(BestellungEntityF paramF, BestellungEntityA paramA);
        partial void Speichern_VorImpl(BestellungEntityF param);
        partial void Speichern_NachImpl(BestellungEntityF paramF, BestellungEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"BestellungEntityA"</returns>
        BestellungEntityA IServiceBestellungEntity.Lesen(BestellungEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            BestellungEntityA ret = new BestellungEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" Bestellung.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND Bestellung.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(Bestellung.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Bestellung.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(Bestellung.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Bestellung.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.OrganisationsEinheit != Guid.Empty)
            {
                strFilter.Append(" AND Bestellung.organisationseinheit='");
                strFilter.Append(param.Filter.OrganisationsEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.OrderArt != Guid.Empty)
            {
                strFilter.Append(" AND Bestellung.OrderArt='");
                strFilter.Append(param.Filter.OrderArt.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.Bestellwert != 0.0)
            {
                int iDec = param.Filter.Bestellwert.ToString().Length - (param.Filter.Bestellwert.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(Bestellung.bestellwert,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.Bestellwert.ToString().Replace(",", "."));
            }
            if (param.Filter.Bestellmenge != 0.0)
            {
                int iDec = param.Filter.Bestellmenge.ToString().Length - (param.Filter.Bestellmenge.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(Bestellung.bestellmenge,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.Bestellmenge.ToString().Replace(",", "."));
            }
            if (param.Filter.Liefertag != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Bestellung.LIEFERTAG AS float)) AS datetime)='");
                strFilter.Append(param.Filter.Liefertag.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.Bestelltag != 0)
            {
                strFilter.Append(" AND Bestellung.bestelltag=");
                strFilter.Append(param.Filter.Bestelltag.ToString());
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.Bestellung");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                    int OrderArtOid = sqlReader.GetOrdinal("OrderArt");
                    int bestellwertOid = sqlReader.GetOrdinal("bestellwert");
                    int bestellmengeOid = sqlReader.GetOrdinal("bestellmenge");
                    int liefertagOid = sqlReader.GetOrdinal("liefertag");
                    int bestelltagOid = sqlReader.GetOrdinal("bestelltag");

                    while (sqlReader.Read())
                    {
                        BestellungEntityDM rs = new BestellungEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                        rs.OrderArt = sqlReader.IsDBNull(OrderArtOid) ? Guid.Empty : sqlReader.GetGuid(OrderArtOid);
                        if (!sqlReader.IsDBNull(bestellwertOid))
                            rs.Bestellwert = sqlReader.GetDouble(bestellwertOid);
                        if (!sqlReader.IsDBNull(bestellmengeOid))
                            rs.Bestellmenge = sqlReader.GetDouble(bestellmengeOid);
                        rs.Liefertag = sqlReader.IsDBNull(liefertagOid) ? DateTime.MinValue : sqlReader.GetDateTime(liefertagOid);
                        if (!sqlReader.IsDBNull(bestelltagOid))
                            rs.Bestelltag = sqlReader.GetInt32(bestelltagOid);

                        rs.DisableUpdateMask = false;
                        ret.BestellungEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "Bestellung";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"BestellungEntityA"</returns>
        BestellungEntityA IServiceBestellungEntity.Loeschen(BestellungEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            BestellungEntityA ret = new BestellungEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_Bestellung_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"Bestellung";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.BestellungEntity.Count; i++)
                    {
                        if (param.BestellungEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.BestellungEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.BestellungEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.BestellungEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"BestellungEntityA"</returns>
        BestellungEntityA IServiceBestellungEntity.Neu(BestellungEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            BestellungEntityA ret = new BestellungEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_Bestellung_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.BestellungEntity.Count; i++)
                    {
                        //if (param.BestellungEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.BestellungEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.BestellungEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.BestellungEntity[i].OrganisationsEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.BestellungEntity[i].OrganisationsEinheit;
                        else
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        if (param.BestellungEntity[i].OrderArt != Guid.Empty)
                            sqlCommand1.Parameters["@OrderArt"].Value = (Guid)param.BestellungEntity[i].OrderArt;
                        else
                            sqlCommand1.Parameters["@OrderArt"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@bestellwert"].Value = (double)param.BestellungEntity[i].Bestellwert;
                        sqlCommand1.Parameters["@bestellmenge"].Value = (double)param.BestellungEntity[i].Bestellmenge;
                        sqlCommand1.Parameters["@liefertag"].Value = (DateTime)param.BestellungEntity[i].Liefertag;
                        sqlCommand1.Parameters["@bestelltag"].Value = (int)param.BestellungEntity[i].Bestelltag;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int OrderArtOid = sqlReader.GetOrdinal("OrderArt");
                        int bestellwertOid = sqlReader.GetOrdinal("bestellwert");
                        int bestellmengeOid = sqlReader.GetOrdinal("bestellmenge");
                        int liefertagOid = sqlReader.GetOrdinal("liefertag");
                        int bestelltagOid = sqlReader.GetOrdinal("bestelltag");


                        if (sqlReader.Read())
                        {
                            BestellungEntityDM rs = new BestellungEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.BestellungEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.OrderArt = sqlReader.IsDBNull(OrderArtOid) ? Guid.Empty : sqlReader.GetGuid(OrderArtOid);
                            if (!sqlReader.IsDBNull(bestellwertOid))
                                rs.Bestellwert = sqlReader.GetDouble(bestellwertOid);
                            if (!sqlReader.IsDBNull(bestellmengeOid))
                                rs.Bestellmenge = sqlReader.GetDouble(bestellmengeOid);
                            rs.Liefertag = sqlReader.IsDBNull(liefertagOid) ? DateTime.MinValue : sqlReader.GetDateTime(liefertagOid);
                            if (!sqlReader.IsDBNull(bestelltagOid))
                                rs.Bestelltag = sqlReader.GetInt32(bestelltagOid);

                            rs.DisableUpdateMask = false;
                            ret.BestellungEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"BestellungEntityA"</returns>
        BestellungEntityA IServiceBestellungEntity.Speichern(BestellungEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            BestellungEntityA ret = new BestellungEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_Bestellung_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.BestellungEntity.Count; i++)
                    {
                        //if (param.BestellungEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.BestellungEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.BestellungEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.BestellungEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("OrganisationsEinheit")) // && (param.BestellungEntity[i].OrganisationsEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.BestellungEntity[i].OrganisationsEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("OrderArt")) // && (param.BestellungEntity[i].OrderArt != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@OrderArt"].Value = (Guid)param.BestellungEntity[i].OrderArt;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@OrderArt"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bestellwert"))
                        {
                            sqlCommand1.Parameters["@bestellwert"].Value = (double)param.BestellungEntity[i].Bestellwert;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestellwert"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bestellmenge"))
                        {
                            sqlCommand1.Parameters["@bestellmenge"].Value = (double)param.BestellungEntity[i].Bestellmenge;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestellmenge"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Liefertag"))
                        {
                            sqlCommand1.Parameters["@liefertag"].Value = (DateTime)param.BestellungEntity[i].Liefertag;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@liefertag"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bestelltag"))
                        {
                            sqlCommand1.Parameters["@bestelltag"].Value = (int)param.BestellungEntity[i].Bestelltag;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestelltag"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int OrderArtOid = sqlReader.GetOrdinal("OrderArt");
                        int bestellwertOid = sqlReader.GetOrdinal("bestellwert");
                        int bestellmengeOid = sqlReader.GetOrdinal("bestellmenge");
                        int liefertagOid = sqlReader.GetOrdinal("liefertag");
                        int bestelltagOid = sqlReader.GetOrdinal("bestelltag");


                        if (sqlReader.Read())
                        {
                            BestellungEntityDM rs = new BestellungEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.BestellungEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.BestellungEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.BestellungEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.OrderArt = sqlReader.IsDBNull(OrderArtOid) ? Guid.Empty : sqlReader.GetGuid(OrderArtOid);
                            if (!sqlReader.IsDBNull(bestellwertOid))
                                rs.Bestellwert = sqlReader.GetDouble(bestellwertOid);
                            if (!sqlReader.IsDBNull(bestellmengeOid))
                                rs.Bestellmenge = sqlReader.GetDouble(bestellmengeOid);
                            rs.Liefertag = sqlReader.IsDBNull(liefertagOid) ? DateTime.MinValue : sqlReader.GetDateTime(liefertagOid);
                            if (!sqlReader.IsDBNull(bestelltagOid))
                                rs.Bestelltag = sqlReader.GetInt32(bestelltagOid);

                            rs.DisableUpdateMask = false;
                            ret.BestellungEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new BestellungEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        BestellungLookupA IServiceBestellungEntity.Lookup(BestellungLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            BestellungLookupA ret = new BestellungLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "Bestellung");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.Bestellung");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            BestellungLookupDM rs = new BestellungLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.BestellungLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new BestellungLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceDispoplanEntity
    /// </summary>
    public partial class ServiceDispoplanEntity : IServiceDispoplanEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(DispoplanEntityF paramF);
        partial void Lesen_NachImpl(DispoplanEntityF paramF, DispoplanEntityA paramA);
        partial void Loeschen_VorImpl(DispoplanEntityF param);
        partial void Loeschen_NachImpl(DispoplanEntityF paramF, DispoplanEntityA paramA);
        partial void Neu_VorImpl(DispoplanEntityF paramF);
        partial void Neu_NachImpl(DispoplanEntityF paramF, DispoplanEntityA paramA);
        partial void Speichern_VorImpl(DispoplanEntityF param);
        partial void Speichern_NachImpl(DispoplanEntityF paramF, DispoplanEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanEntityA"</returns>
        DispoplanEntityA IServiceDispoplanEntity.Lesen(DispoplanEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanEntityA ret = new DispoplanEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" Dispoplan.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            if (!string.IsNullOrEmpty(param.VolltextSuche))
            {
                StringBuilder suchbedingung = new StringBuilder();
                string[] fields = new string[1];
                fields[0] = "Dispoplan.BEZEICHNUNG";
                string[] volltextsuche = param.VolltextSuche.Split(' ');
                for (int j = 0; j < fields.Length; j++)
                {
                    StringBuilder suchbez = new StringBuilder();
                    for (int i = 0; i < volltextsuche.Length; i++)
                    {
                        suchbez.Append(" AND lower(" + fields[j] + ") LIKE '%");
                        suchbez.Append(volltextsuche[i].ToLower().Trim());
                        suchbez.Append("%'");
                    }
                    suchbez.Remove(0, 4); 		// erste UND bedingung muss weg
                    suchbez.Insert(0, " OR (");
                    suchbez.Append(") ");
                    suchbedingung.Append(suchbez.ToString());
                }
                suchbedingung.Remove(0, 3); 		// erste OR bedingung muss weg
                suchbedingung.Insert(0, " AND ( ");
                suchbedingung.Append(") ");

                strFilter.Append(suchbedingung.ToString());
            }
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND Dispoplan.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(Dispoplan.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Dispoplan.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(Dispoplan.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Dispoplan.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (!string.IsNullOrEmpty(param.Filter.Bezeichnung))
            {
                strFilter.Append(" AND lower(Dispoplan.BEZEICHNUNG) LIKE '%");
                strFilter.Append(param.Filter.Bezeichnung.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GueltigAbDatum != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Dispoplan.GUELTIGABDATUM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GueltigAbDatum.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GueltigBisDatum != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Dispoplan.GUELTIGBISDATUM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GueltigBisDatum.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.NettoWarenwert != 0.0)
            {
                int iDec = param.Filter.NettoWarenwert.ToString().Length - (param.Filter.NettoWarenwert.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(Dispoplan.nettowarenwert,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.NettoWarenwert.ToString().Replace(",", "."));
            }
            if (param.Filter.BruttoWarenwert != 0.0)
            {
                int iDec = param.Filter.BruttoWarenwert.ToString().Length - (param.Filter.BruttoWarenwert.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(Dispoplan.bruttowarenwert,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.BruttoWarenwert.ToString().Replace(",", "."));
            }
            if (param.Filter.TagesBudget != 0.0)
            {
                int iDec = param.Filter.TagesBudget.ToString().Length - (param.Filter.TagesBudget.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(Dispoplan.tagesbudget,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.TagesBudget.ToString().Replace(",", "."));
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung
            strSortierung.Append("Dispoplan.BEZEICHNUNG");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.Dispoplan");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                    int gueltigabdatumOid = sqlReader.GetOrdinal("gueltigabdatum");
                    int gueltigbisdatumOid = sqlReader.GetOrdinal("gueltigbisdatum");
                    int nettowarenwertOid = sqlReader.GetOrdinal("nettowarenwert");
                    int bruttowarenwertOid = sqlReader.GetOrdinal("bruttowarenwert");
                    int tagesbudgetOid = sqlReader.GetOrdinal("tagesbudget");

                    while (sqlReader.Read())
                    {
                        DispoplanEntityDM rs = new DispoplanEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                        rs.GueltigAbDatum = sqlReader.IsDBNull(gueltigabdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigabdatumOid);
                        rs.GueltigBisDatum = sqlReader.IsDBNull(gueltigbisdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigbisdatumOid);
                        if (!sqlReader.IsDBNull(nettowarenwertOid))
                            rs.NettoWarenwert = sqlReader.GetDouble(nettowarenwertOid);
                        if (!sqlReader.IsDBNull(bruttowarenwertOid))
                            rs.BruttoWarenwert = sqlReader.GetDouble(bruttowarenwertOid);
                        if (!sqlReader.IsDBNull(tagesbudgetOid))
                            rs.TagesBudget = sqlReader.GetDouble(tagesbudgetOid);

                        rs.DisableUpdateMask = false;
                        ret.DispoplanEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "Dispoplan";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanEntityA"</returns>
        DispoplanEntityA IServiceDispoplanEntity.Loeschen(DispoplanEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanEntityA ret = new DispoplanEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_Dispoplan_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"Dispoplan";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.DispoplanEntity.Count; i++)
                    {
                        if (param.DispoplanEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.DispoplanEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.DispoplanEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.DispoplanEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanEntityA"</returns>
        DispoplanEntityA IServiceDispoplanEntity.Neu(DispoplanEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanEntityA ret = new DispoplanEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_Dispoplan_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.DispoplanEntity.Count; i++)
                    {
                        //if (param.DispoplanEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.DispoplanEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.DispoplanEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.DispoplanEntity[i].Bezeichnung;
                        sqlCommand1.Parameters["@gueltigabdatum"].Value = (DateTime)param.DispoplanEntity[i].GueltigAbDatum;
                        sqlCommand1.Parameters["@gueltigbisdatum"].Value = (DateTime)param.DispoplanEntity[i].GueltigBisDatum;
                        sqlCommand1.Parameters["@nettowarenwert"].Value = (double)param.DispoplanEntity[i].NettoWarenwert;
                        sqlCommand1.Parameters["@bruttowarenwert"].Value = (double)param.DispoplanEntity[i].BruttoWarenwert;
                        sqlCommand1.Parameters["@tagesbudget"].Value = (double)param.DispoplanEntity[i].TagesBudget;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int gueltigabdatumOid = sqlReader.GetOrdinal("gueltigabdatum");
                        int gueltigbisdatumOid = sqlReader.GetOrdinal("gueltigbisdatum");
                        int nettowarenwertOid = sqlReader.GetOrdinal("nettowarenwert");
                        int bruttowarenwertOid = sqlReader.GetOrdinal("bruttowarenwert");
                        int tagesbudgetOid = sqlReader.GetOrdinal("tagesbudget");


                        if (sqlReader.Read())
                        {
                            DispoplanEntityDM rs = new DispoplanEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.DispoplanEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.GueltigAbDatum = sqlReader.IsDBNull(gueltigabdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigabdatumOid);
                            rs.GueltigBisDatum = sqlReader.IsDBNull(gueltigbisdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigbisdatumOid);
                            if (!sqlReader.IsDBNull(nettowarenwertOid))
                                rs.NettoWarenwert = sqlReader.GetDouble(nettowarenwertOid);
                            if (!sqlReader.IsDBNull(bruttowarenwertOid))
                                rs.BruttoWarenwert = sqlReader.GetDouble(bruttowarenwertOid);
                            if (!sqlReader.IsDBNull(tagesbudgetOid))
                                rs.TagesBudget = sqlReader.GetDouble(tagesbudgetOid);

                            rs.DisableUpdateMask = false;
                            ret.DispoplanEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanEntityA"</returns>
        DispoplanEntityA IServiceDispoplanEntity.Speichern(DispoplanEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanEntityA ret = new DispoplanEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_Dispoplan_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.DispoplanEntity.Count; i++)
                    {
                        //if (param.DispoplanEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.DispoplanEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.DispoplanEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.DispoplanEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("Bezeichnung"))
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.DispoplanEntity[i].Bezeichnung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("GueltigAbDatum"))
                        {
                            sqlCommand1.Parameters["@gueltigabdatum"].Value = (DateTime)param.DispoplanEntity[i].GueltigAbDatum;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@gueltigabdatum"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("GueltigBisDatum"))
                        {
                            sqlCommand1.Parameters["@gueltigbisdatum"].Value = (DateTime)param.DispoplanEntity[i].GueltigBisDatum;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@gueltigbisdatum"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("NettoWarenwert"))
                        {
                            sqlCommand1.Parameters["@nettowarenwert"].Value = (double)param.DispoplanEntity[i].NettoWarenwert;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@nettowarenwert"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BruttoWarenwert"))
                        {
                            sqlCommand1.Parameters["@bruttowarenwert"].Value = (double)param.DispoplanEntity[i].BruttoWarenwert;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bruttowarenwert"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("TagesBudget"))
                        {
                            sqlCommand1.Parameters["@tagesbudget"].Value = (double)param.DispoplanEntity[i].TagesBudget;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@tagesbudget"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int gueltigabdatumOid = sqlReader.GetOrdinal("gueltigabdatum");
                        int gueltigbisdatumOid = sqlReader.GetOrdinal("gueltigbisdatum");
                        int nettowarenwertOid = sqlReader.GetOrdinal("nettowarenwert");
                        int bruttowarenwertOid = sqlReader.GetOrdinal("bruttowarenwert");
                        int tagesbudgetOid = sqlReader.GetOrdinal("tagesbudget");


                        if (sqlReader.Read())
                        {
                            DispoplanEntityDM rs = new DispoplanEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.DispoplanEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.DispoplanEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.DispoplanEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.GueltigAbDatum = sqlReader.IsDBNull(gueltigabdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigabdatumOid);
                            rs.GueltigBisDatum = sqlReader.IsDBNull(gueltigbisdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(gueltigbisdatumOid);
                            if (!sqlReader.IsDBNull(nettowarenwertOid))
                                rs.NettoWarenwert = sqlReader.GetDouble(nettowarenwertOid);
                            if (!sqlReader.IsDBNull(bruttowarenwertOid))
                                rs.BruttoWarenwert = sqlReader.GetDouble(bruttowarenwertOid);
                            if (!sqlReader.IsDBNull(tagesbudgetOid))
                                rs.TagesBudget = sqlReader.GetDouble(tagesbudgetOid);

                            rs.DisableUpdateMask = false;
                            ret.DispoplanEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        DispoplanLookupA IServiceDispoplanEntity.Lookup(DispoplanLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanLookupA ret = new DispoplanLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "Dispoplan");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.Dispoplan");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            DispoplanLookupDM rs = new DispoplanLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.DispoplanLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new DispoplanLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceDispoplanSpeiseplanMahlzeitEntity
    /// </summary>
    public partial class ServiceDispoplanSpeiseplanMahlzeitEntity : IServiceDispoplanSpeiseplanMahlzeitEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(DispoplanSpeiseplanMahlzeitEntityF paramF);
        partial void Lesen_NachImpl(DispoplanSpeiseplanMahlzeitEntityF paramF, DispoplanSpeiseplanMahlzeitEntityA paramA);
        partial void Loeschen_VorImpl(DispoplanSpeiseplanMahlzeitEntityF param);
        partial void Loeschen_NachImpl(DispoplanSpeiseplanMahlzeitEntityF paramF, DispoplanSpeiseplanMahlzeitEntityA paramA);
        partial void Neu_VorImpl(DispoplanSpeiseplanMahlzeitEntityF paramF);
        partial void Neu_NachImpl(DispoplanSpeiseplanMahlzeitEntityF paramF, DispoplanSpeiseplanMahlzeitEntityA paramA);
        partial void Speichern_VorImpl(DispoplanSpeiseplanMahlzeitEntityF param);
        partial void Speichern_NachImpl(DispoplanSpeiseplanMahlzeitEntityF paramF, DispoplanSpeiseplanMahlzeitEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanSpeiseplanMahlzeitEntityA"</returns>
        DispoplanSpeiseplanMahlzeitEntityA IServiceDispoplanSpeiseplanMahlzeitEntity.Lesen(DispoplanSpeiseplanMahlzeitEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanSpeiseplanMahlzeitEntityA ret = new DispoplanSpeiseplanMahlzeitEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" DispoplanSpeiseplanMahlzeit.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND DispoplanSpeiseplanMahlzeit.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(DispoplanSpeiseplanMahlzeit.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(DispoplanSpeiseplanMahlzeit.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(DispoplanSpeiseplanMahlzeit.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(DispoplanSpeiseplanMahlzeit.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.SpeiseplanMahlzeit != Guid.Empty)
            {
                strFilter.Append(" AND DispoplanSpeiseplanMahlzeit.speiseplanmahlzeit='");
                strFilter.Append(param.Filter.SpeiseplanMahlzeit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.Dispoplan != Guid.Empty)
            {
                strFilter.Append(" AND DispoplanSpeiseplanMahlzeit.dispoplan='");
                strFilter.Append(param.Filter.Dispoplan.ToString());
                strFilter.Append("' ");
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.DispoplanSpeiseplanMahlzeit");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int speiseplanmahlzeitOid = sqlReader.GetOrdinal("speiseplanmahlzeit");
                    int dispoplanOid = sqlReader.GetOrdinal("dispoplan");

                    while (sqlReader.Read())
                    {
                        DispoplanSpeiseplanMahlzeitEntityDM rs = new DispoplanSpeiseplanMahlzeitEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.SpeiseplanMahlzeit = sqlReader.IsDBNull(speiseplanmahlzeitOid) ? Guid.Empty : sqlReader.GetGuid(speiseplanmahlzeitOid);
                        rs.Dispoplan = sqlReader.IsDBNull(dispoplanOid) ? Guid.Empty : sqlReader.GetGuid(dispoplanOid);

                        rs.DisableUpdateMask = false;
                        ret.DispoplanSpeiseplanMahlzeitEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "DispoplanSpeiseplanMahlzeit";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanSpeiseplanMahlzeitEntityA"</returns>
        DispoplanSpeiseplanMahlzeitEntityA IServiceDispoplanSpeiseplanMahlzeitEntity.Loeschen(DispoplanSpeiseplanMahlzeitEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanSpeiseplanMahlzeitEntityA ret = new DispoplanSpeiseplanMahlzeitEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_DispoplanSpeiseplanMahlzeit_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"DispoplanSpeiseplanMahlzeit";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.DispoplanSpeiseplanMahlzeitEntity.Count; i++)
                    {
                        if (param.DispoplanSpeiseplanMahlzeitEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.DispoplanSpeiseplanMahlzeitEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanSpeiseplanMahlzeitEntityA"</returns>
        DispoplanSpeiseplanMahlzeitEntityA IServiceDispoplanSpeiseplanMahlzeitEntity.Neu(DispoplanSpeiseplanMahlzeitEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanSpeiseplanMahlzeitEntityA ret = new DispoplanSpeiseplanMahlzeitEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_DispoplanSpeiseplanMahlzeit_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.DispoplanSpeiseplanMahlzeitEntity.Count; i++)
                    {
                        //if (param.DispoplanSpeiseplanMahlzeitEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.DispoplanSpeiseplanMahlzeitEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.DispoplanSpeiseplanMahlzeitEntity[i].SpeiseplanMahlzeit != Guid.Empty)
                            sqlCommand1.Parameters["@speiseplanmahlzeit"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].SpeiseplanMahlzeit;
                        else
                            sqlCommand1.Parameters["@speiseplanmahlzeit"].Value = DBNull.Value;
                        if (param.DispoplanSpeiseplanMahlzeitEntity[i].Dispoplan != Guid.Empty)
                            sqlCommand1.Parameters["@dispoplan"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].Dispoplan;
                        else
                            sqlCommand1.Parameters["@dispoplan"].Value = DBNull.Value;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int speiseplanmahlzeitOid = sqlReader.GetOrdinal("speiseplanmahlzeit");
                        int dispoplanOid = sqlReader.GetOrdinal("dispoplan");


                        if (sqlReader.Read())
                        {
                            DispoplanSpeiseplanMahlzeitEntityDM rs = new DispoplanSpeiseplanMahlzeitEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.DispoplanSpeiseplanMahlzeitEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.SpeiseplanMahlzeit = sqlReader.IsDBNull(speiseplanmahlzeitOid) ? Guid.Empty : sqlReader.GetGuid(speiseplanmahlzeitOid);
                            rs.Dispoplan = sqlReader.IsDBNull(dispoplanOid) ? Guid.Empty : sqlReader.GetGuid(dispoplanOid);

                            rs.DisableUpdateMask = false;
                            ret.DispoplanSpeiseplanMahlzeitEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"DispoplanSpeiseplanMahlzeitEntityA"</returns>
        DispoplanSpeiseplanMahlzeitEntityA IServiceDispoplanSpeiseplanMahlzeitEntity.Speichern(DispoplanSpeiseplanMahlzeitEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanSpeiseplanMahlzeitEntityA ret = new DispoplanSpeiseplanMahlzeitEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_DispoplanSpeiseplanMahlzeit_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.DispoplanSpeiseplanMahlzeitEntity.Count; i++)
                    {
                        //if (param.DispoplanSpeiseplanMahlzeitEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.DispoplanSpeiseplanMahlzeitEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.DispoplanSpeiseplanMahlzeitEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("SpeiseplanMahlzeit")) // && (param.DispoplanSpeiseplanMahlzeitEntity[i].SpeiseplanMahlzeit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@speiseplanmahlzeit"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].SpeiseplanMahlzeit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@speiseplanmahlzeit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Dispoplan")) // && (param.DispoplanSpeiseplanMahlzeitEntity[i].Dispoplan != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@dispoplan"].Value = (Guid)param.DispoplanSpeiseplanMahlzeitEntity[i].Dispoplan;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@dispoplan"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int speiseplanmahlzeitOid = sqlReader.GetOrdinal("speiseplanmahlzeit");
                        int dispoplanOid = sqlReader.GetOrdinal("dispoplan");


                        if (sqlReader.Read())
                        {
                            DispoplanSpeiseplanMahlzeitEntityDM rs = new DispoplanSpeiseplanMahlzeitEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.DispoplanSpeiseplanMahlzeitEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.DispoplanSpeiseplanMahlzeitEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.DispoplanSpeiseplanMahlzeitEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.SpeiseplanMahlzeit = sqlReader.IsDBNull(speiseplanmahlzeitOid) ? Guid.Empty : sqlReader.GetGuid(speiseplanmahlzeitOid);
                            rs.Dispoplan = sqlReader.IsDBNull(dispoplanOid) ? Guid.Empty : sqlReader.GetGuid(dispoplanOid);

                            rs.DisableUpdateMask = false;
                            ret.DispoplanSpeiseplanMahlzeitEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new DispoplanSpeiseplanMahlzeitEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        DispoplanSpeiseplanMahlzeitLookupA IServiceDispoplanSpeiseplanMahlzeitEntity.Lookup(DispoplanSpeiseplanMahlzeitLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            DispoplanSpeiseplanMahlzeitLookupA ret = new DispoplanSpeiseplanMahlzeitLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "DispoplanSpeiseplanMahlzeit");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.DispoplanSpeiseplanMahlzeit");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            DispoplanSpeiseplanMahlzeitLookupDM rs = new DispoplanSpeiseplanMahlzeitLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.DispoplanSpeiseplanMahlzeitLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new DispoplanSpeiseplanMahlzeitLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceLieferRhythmusEntity
    /// </summary>
    public partial class ServiceLieferRhythmusEntity : IServiceLieferRhythmusEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(LieferRhythmusEntityF paramF);
        partial void Lesen_NachImpl(LieferRhythmusEntityF paramF, LieferRhythmusEntityA paramA);
        partial void Loeschen_VorImpl(LieferRhythmusEntityF param);
        partial void Loeschen_NachImpl(LieferRhythmusEntityF paramF, LieferRhythmusEntityA paramA);
        partial void Neu_VorImpl(LieferRhythmusEntityF paramF);
        partial void Neu_NachImpl(LieferRhythmusEntityF paramF, LieferRhythmusEntityA paramA);
        partial void Speichern_VorImpl(LieferRhythmusEntityF param);
        partial void Speichern_NachImpl(LieferRhythmusEntityF paramF, LieferRhythmusEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusEntityA"</returns>
        LieferRhythmusEntityA IServiceLieferRhythmusEntity.Lesen(LieferRhythmusEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusEntityA ret = new LieferRhythmusEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" LieferRhythmus.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND LieferRhythmus.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(LieferRhythmus.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(LieferRhythmus.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(LieferRhythmus.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(LieferRhythmus.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.Komission != Guid.Empty)
            {
                strFilter.Append(" AND LieferRhythmus.Komission='");
                strFilter.Append(param.Filter.Komission.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.BestellTag != 0)
            {
                strFilter.Append(" AND LieferRhythmus.bestelltag=");
                strFilter.Append(param.Filter.BestellTag.ToString());
            }
            if (param.Filter.LieferTag != 0)
            {
                strFilter.Append(" AND LieferRhythmus.liefertag=");
                strFilter.Append(param.Filter.LieferTag.ToString());
            }
            if (param.Filter.StartDatum != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(LieferRhythmus.STARTDATUM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.StartDatum.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.AbNaechstenBestelltag == true)
                strFilter.Append(" AND LieferRhythmus.abnaechstenbestelltag=1");

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.LieferRhythmus");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int KomissionOid = sqlReader.GetOrdinal("Komission");
                    int bestelltagOid = sqlReader.GetOrdinal("bestelltag");
                    int liefertagOid = sqlReader.GetOrdinal("liefertag");
                    int startdatumOid = sqlReader.GetOrdinal("startdatum");
                    int abnaechstenbestelltagOid = sqlReader.GetOrdinal("abnaechstenbestelltag");

                    while (sqlReader.Read())
                    {
                        LieferRhythmusEntityDM rs = new LieferRhythmusEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                        if (!sqlReader.IsDBNull(bestelltagOid))
                            rs.BestellTag = sqlReader.GetInt32(bestelltagOid);
                        if (!sqlReader.IsDBNull(liefertagOid))
                            rs.LieferTag = sqlReader.GetInt32(liefertagOid);
                        rs.StartDatum = sqlReader.IsDBNull(startdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(startdatumOid);
                        rs.AbNaechstenBestelltag = sqlReader.IsDBNull(abnaechstenbestelltagOid) ? false : sqlReader.GetBoolean(abnaechstenbestelltagOid);

                        rs.DisableUpdateMask = false;
                        ret.LieferRhythmusEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "LieferRhythmus";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusEntityA"</returns>
        LieferRhythmusEntityA IServiceLieferRhythmusEntity.Loeschen(LieferRhythmusEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusEntityA ret = new LieferRhythmusEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_LieferRhythmus_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"LieferRhythmus";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.LieferRhythmusEntity.Count; i++)
                    {
                        if (param.LieferRhythmusEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.LieferRhythmusEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.LieferRhythmusEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.LieferRhythmusEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusEntityA"</returns>
        LieferRhythmusEntityA IServiceLieferRhythmusEntity.Neu(LieferRhythmusEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusEntityA ret = new LieferRhythmusEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_LieferRhythmus_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.LieferRhythmusEntity.Count; i++)
                    {
                        //if (param.LieferRhythmusEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.LieferRhythmusEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.LieferRhythmusEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.LieferRhythmusEntity[i].Komission != Guid.Empty)
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.LieferRhythmusEntity[i].Komission;
                        else
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@bestelltag"].Value = (int)param.LieferRhythmusEntity[i].BestellTag;
                        sqlCommand1.Parameters["@liefertag"].Value = (int)param.LieferRhythmusEntity[i].LieferTag;
                        sqlCommand1.Parameters["@startdatum"].Value = (DateTime)param.LieferRhythmusEntity[i].StartDatum;
                        sqlCommand1.Parameters["@abnaechstenbestelltag"].Value = (short)param.LieferRhythmusEntity[i].AbNaechstenBestelltag;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");
                        int bestelltagOid = sqlReader.GetOrdinal("bestelltag");
                        int liefertagOid = sqlReader.GetOrdinal("liefertag");
                        int startdatumOid = sqlReader.GetOrdinal("startdatum");
                        int abnaechstenbestelltagOid = sqlReader.GetOrdinal("abnaechstenbestelltag");


                        if (sqlReader.Read())
                        {
                            LieferRhythmusEntityDM rs = new LieferRhythmusEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.LieferRhythmusEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                            if (!sqlReader.IsDBNull(bestelltagOid))
                                rs.BestellTag = sqlReader.GetInt32(bestelltagOid);
                            if (!sqlReader.IsDBNull(liefertagOid))
                                rs.LieferTag = sqlReader.GetInt32(liefertagOid);
                            rs.StartDatum = sqlReader.IsDBNull(startdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(startdatumOid);
                            rs.AbNaechstenBestelltag = sqlReader.IsDBNull(abnaechstenbestelltagOid) ? false : sqlReader.GetBoolean(abnaechstenbestelltagOid);

                            rs.DisableUpdateMask = false;
                            ret.LieferRhythmusEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusEntityA"</returns>
        LieferRhythmusEntityA IServiceLieferRhythmusEntity.Speichern(LieferRhythmusEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusEntityA ret = new LieferRhythmusEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_LieferRhythmus_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.LieferRhythmusEntity.Count; i++)
                    {
                        //if (param.LieferRhythmusEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.LieferRhythmusEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.LieferRhythmusEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.LieferRhythmusEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("Komission")) // && (param.LieferRhythmusEntity[i].Komission != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.LieferRhythmusEntity[i].Komission;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BestellTag"))
                        {
                            sqlCommand1.Parameters["@bestelltag"].Value = (int)param.LieferRhythmusEntity[i].BestellTag;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestelltag"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("LieferTag"))
                        {
                            sqlCommand1.Parameters["@liefertag"].Value = (int)param.LieferRhythmusEntity[i].LieferTag;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@liefertag"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("StartDatum"))
                        {
                            sqlCommand1.Parameters["@startdatum"].Value = (DateTime)param.LieferRhythmusEntity[i].StartDatum;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@startdatum"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("AbNaechstenBestelltag"))
                        {
                            sqlCommand1.Parameters["@abnaechstenbestelltag"].Value = (short)param.LieferRhythmusEntity[i].AbNaechstenBestelltag;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@abnaechstenbestelltag"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");
                        int bestelltagOid = sqlReader.GetOrdinal("bestelltag");
                        int liefertagOid = sqlReader.GetOrdinal("liefertag");
                        int startdatumOid = sqlReader.GetOrdinal("startdatum");
                        int abnaechstenbestelltagOid = sqlReader.GetOrdinal("abnaechstenbestelltag");


                        if (sqlReader.Read())
                        {
                            LieferRhythmusEntityDM rs = new LieferRhythmusEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.LieferRhythmusEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.LieferRhythmusEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.LieferRhythmusEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                            if (!sqlReader.IsDBNull(bestelltagOid))
                                rs.BestellTag = sqlReader.GetInt32(bestelltagOid);
                            if (!sqlReader.IsDBNull(liefertagOid))
                                rs.LieferTag = sqlReader.GetInt32(liefertagOid);
                            rs.StartDatum = sqlReader.IsDBNull(startdatumOid) ? DateTime.MinValue : sqlReader.GetDateTime(startdatumOid);
                            rs.AbNaechstenBestelltag = sqlReader.IsDBNull(abnaechstenbestelltagOid) ? false : sqlReader.GetBoolean(abnaechstenbestelltagOid);

                            rs.DisableUpdateMask = false;
                            ret.LieferRhythmusEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        LieferRhythmusLookupA IServiceLieferRhythmusEntity.Lookup(LieferRhythmusLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusLookupA ret = new LieferRhythmusLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "LieferRhythmus");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.LieferRhythmus");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            LieferRhythmusLookupDM rs = new LieferRhythmusLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.LieferRhythmusLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new LieferRhythmusLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceLieferRhythmusOrgEinheitenEntity
    /// </summary>
    public partial class ServiceLieferRhythmusOrgEinheitenEntity : IServiceLieferRhythmusOrgEinheitenEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(LieferRhythmusOrgEinheitenEntityF paramF);
        partial void Lesen_NachImpl(LieferRhythmusOrgEinheitenEntityF paramF, LieferRhythmusOrgEinheitenEntityA paramA);
        partial void Loeschen_VorImpl(LieferRhythmusOrgEinheitenEntityF param);
        partial void Loeschen_NachImpl(LieferRhythmusOrgEinheitenEntityF paramF, LieferRhythmusOrgEinheitenEntityA paramA);
        partial void Neu_VorImpl(LieferRhythmusOrgEinheitenEntityF paramF);
        partial void Neu_NachImpl(LieferRhythmusOrgEinheitenEntityF paramF, LieferRhythmusOrgEinheitenEntityA paramA);
        partial void Speichern_VorImpl(LieferRhythmusOrgEinheitenEntityF param);
        partial void Speichern_NachImpl(LieferRhythmusOrgEinheitenEntityF paramF, LieferRhythmusOrgEinheitenEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusOrgEinheitenEntityA"</returns>
        LieferRhythmusOrgEinheitenEntityA IServiceLieferRhythmusOrgEinheitenEntity.Lesen(LieferRhythmusOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusOrgEinheitenEntityA ret = new LieferRhythmusOrgEinheitenEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" LieferRhythmusOrgEinheiten.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND LieferRhythmusOrgEinheiten.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(LieferRhythmusOrgEinheiten.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(LieferRhythmusOrgEinheiten.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(LieferRhythmusOrgEinheiten.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(LieferRhythmusOrgEinheiten.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.OrganisationsEinheit != Guid.Empty)
            {
                strFilter.Append(" AND LieferRhythmusOrgEinheiten.organisationseinheit='");
                strFilter.Append(param.Filter.OrganisationsEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.LieferRhythmus != Guid.Empty)
            {
                strFilter.Append(" AND LieferRhythmusOrgEinheiten.lieferrhythmus='");
                strFilter.Append(param.Filter.LieferRhythmus.ToString());
                strFilter.Append("' ");
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.LieferRhythmusOrgEinheiten");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                    int lieferrhythmusOid = sqlReader.GetOrdinal("lieferrhythmus");

                    while (sqlReader.Read())
                    {
                        LieferRhythmusOrgEinheitenEntityDM rs = new LieferRhythmusOrgEinheitenEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                        rs.LieferRhythmus = sqlReader.IsDBNull(lieferrhythmusOid) ? Guid.Empty : sqlReader.GetGuid(lieferrhythmusOid);

                        rs.DisableUpdateMask = false;
                        ret.LieferRhythmusOrgEinheitenEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "LieferRhythmusOrgEinheiten";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusOrgEinheitenEntityA"</returns>
        LieferRhythmusOrgEinheitenEntityA IServiceLieferRhythmusOrgEinheitenEntity.Loeschen(LieferRhythmusOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusOrgEinheitenEntityA ret = new LieferRhythmusOrgEinheitenEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_LieferRhythmusOrgEinheiten_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"LieferRhythmusOrgEinheiten";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.LieferRhythmusOrgEinheitenEntity.Count; i++)
                    {
                        if (param.LieferRhythmusOrgEinheitenEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.LieferRhythmusOrgEinheitenEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusOrgEinheitenEntityA"</returns>
        LieferRhythmusOrgEinheitenEntityA IServiceLieferRhythmusOrgEinheitenEntity.Neu(LieferRhythmusOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusOrgEinheitenEntityA ret = new LieferRhythmusOrgEinheitenEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_LieferRhythmusOrgEinheiten_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.LieferRhythmusOrgEinheitenEntity.Count; i++)
                    {
                        //if (param.LieferRhythmusOrgEinheitenEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.LieferRhythmusOrgEinheitenEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.LieferRhythmusOrgEinheitenEntity[i].OrganisationsEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].OrganisationsEinheit;
                        else
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        if (param.LieferRhythmusOrgEinheitenEntity[i].LieferRhythmus != Guid.Empty)
                            sqlCommand1.Parameters["@lieferrhythmus"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].LieferRhythmus;
                        else
                            sqlCommand1.Parameters["@lieferrhythmus"].Value = DBNull.Value;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int lieferrhythmusOid = sqlReader.GetOrdinal("lieferrhythmus");


                        if (sqlReader.Read())
                        {
                            LieferRhythmusOrgEinheitenEntityDM rs = new LieferRhythmusOrgEinheitenEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.LieferRhythmusOrgEinheitenEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.LieferRhythmus = sqlReader.IsDBNull(lieferrhythmusOid) ? Guid.Empty : sqlReader.GetGuid(lieferrhythmusOid);

                            rs.DisableUpdateMask = false;
                            ret.LieferRhythmusOrgEinheitenEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LieferRhythmusOrgEinheitenEntityA"</returns>
        LieferRhythmusOrgEinheitenEntityA IServiceLieferRhythmusOrgEinheitenEntity.Speichern(LieferRhythmusOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusOrgEinheitenEntityA ret = new LieferRhythmusOrgEinheitenEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_LieferRhythmusOrgEinheiten_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.LieferRhythmusOrgEinheitenEntity.Count; i++)
                    {
                        //if (param.LieferRhythmusOrgEinheitenEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.LieferRhythmusOrgEinheitenEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.LieferRhythmusOrgEinheitenEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("OrganisationsEinheit")) // && (param.LieferRhythmusOrgEinheitenEntity[i].OrganisationsEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].OrganisationsEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("LieferRhythmus")) // && (param.LieferRhythmusOrgEinheitenEntity[i].LieferRhythmus != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@lieferrhythmus"].Value = (Guid)param.LieferRhythmusOrgEinheitenEntity[i].LieferRhythmus;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@lieferrhythmus"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int lieferrhythmusOid = sqlReader.GetOrdinal("lieferrhythmus");


                        if (sqlReader.Read())
                        {
                            LieferRhythmusOrgEinheitenEntityDM rs = new LieferRhythmusOrgEinheitenEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.LieferRhythmusOrgEinheitenEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.LieferRhythmusOrgEinheitenEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.LieferRhythmusOrgEinheitenEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.LieferRhythmus = sqlReader.IsDBNull(lieferrhythmusOid) ? Guid.Empty : sqlReader.GetGuid(lieferrhythmusOid);

                            rs.DisableUpdateMask = false;
                            ret.LieferRhythmusOrgEinheitenEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new LieferRhythmusOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        LieferRhythmusOrgEinheitenLookupA IServiceLieferRhythmusOrgEinheitenEntity.Lookup(LieferRhythmusOrgEinheitenLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            LieferRhythmusOrgEinheitenLookupA ret = new LieferRhythmusOrgEinheitenLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "LieferRhythmusOrgEinheiten");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.LieferRhythmusOrgEinheiten");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            LieferRhythmusOrgEinheitenLookupDM rs = new LieferRhythmusOrgEinheitenLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.LieferRhythmusOrgEinheitenLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new LieferRhythmusOrgEinheitenLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceKomissionEntity
    /// </summary>
    public partial class ServiceKomissionEntity : IServiceKomissionEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(KomissionEntityF paramF);
        partial void Lesen_NachImpl(KomissionEntityF paramF, KomissionEntityA paramA);
        partial void Loeschen_VorImpl(KomissionEntityF param);
        partial void Loeschen_NachImpl(KomissionEntityF paramF, KomissionEntityA paramA);
        partial void Neu_VorImpl(KomissionEntityF paramF);
        partial void Neu_NachImpl(KomissionEntityF paramF, KomissionEntityA paramA);
        partial void Speichern_VorImpl(KomissionEntityF param);
        partial void Speichern_NachImpl(KomissionEntityF paramF, KomissionEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionEntityA"</returns>
        KomissionEntityA IServiceKomissionEntity.Lesen(KomissionEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionEntityA ret = new KomissionEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" Komission.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            if (!string.IsNullOrEmpty(param.VolltextSuche))
            {
                StringBuilder suchbedingung = new StringBuilder();
                string[] fields = new string[8];
                fields[0] = "Komission.BEZEICHNUNG";
                fields[1] = "Komission.BEZEICHNUNG2";
                fields[2] = "Komission.SORTIMENTSBEZEICHNUNG";
                fields[3] = "Komission.KREDITORENNUMMER";
                fields[4] = "Komission.BESTELLTEXT";
                fields[5] = "Komission.KUNDENNUMMER";
                fields[6] = "Komission.PFADPRODUKTINFORMATIONEN";
                fields[7] = "Komission.PFADMARKTBERICHT";
                string[] volltextsuche = param.VolltextSuche.Split(' ');
                for (int j = 0; j < fields.Length; j++)
                {
                    StringBuilder suchbez = new StringBuilder();
                    for (int i = 0; i < volltextsuche.Length; i++)
                    {
                        suchbez.Append(" AND lower(" + fields[j] + ") LIKE '%");
                        suchbez.Append(volltextsuche[i].ToLower().Trim());
                        suchbez.Append("%'");
                    }
                    suchbez.Remove(0, 4); 		// erste UND bedingung muss weg
                    suchbez.Insert(0, " OR (");
                    suchbez.Append(") ");
                    suchbedingung.Append(suchbez.ToString());
                }
                suchbedingung.Remove(0, 3); 		// erste OR bedingung muss weg
                suchbedingung.Insert(0, " AND ( ");
                suchbedingung.Append(") ");

                strFilter.Append(suchbedingung.ToString());
            }
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND Komission.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(Komission.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Komission.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(Komission.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(Komission.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.Vater != Guid.Empty)
            {
                strFilter.Append(" AND Komission.vater='");
                strFilter.Append(param.Filter.Vater.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.KomissionArt != Guid.Empty)
            {
                strFilter.Append(" AND Komission.Komissionart='");
                strFilter.Append(param.Filter.KomissionArt.ToString());
                strFilter.Append("' ");
            }
            if (!string.IsNullOrEmpty(param.Filter.Bezeichnung))
            {
                strFilter.Append(" AND lower(Komission.BEZEICHNUNG) LIKE '%");
                strFilter.Append(param.Filter.Bezeichnung.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.Bezeichnung2))
            {
                strFilter.Append(" AND lower(Komission.BEZEICHNUNG2) LIKE '%");
                strFilter.Append(param.Filter.Bezeichnung2.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.SortimentsBezeichnung))
            {
                strFilter.Append(" AND lower(Komission.SORTIMENTSBEZEICHNUNG) LIKE '%");
                strFilter.Append(param.Filter.SortimentsBezeichnung.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.KreditorenNummer))
            {
                strFilter.Append(" AND lower(Komission.KREDITORENNUMMER) LIKE '%");
                strFilter.Append(param.Filter.KreditorenNummer.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.Bestelltext))
            {
                strFilter.Append(" AND lower(Komission.BESTELLTEXT) LIKE '%");
                strFilter.Append(param.Filter.Bestelltext.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.KundenNummer))
            {
                strFilter.Append(" AND lower(Komission.KUNDENNUMMER) LIKE '%");
                strFilter.Append(param.Filter.KundenNummer.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.KundenNrIstIntern == true)
                strFilter.Append(" AND Komission.kundennristintern=1");
            if (!string.IsNullOrEmpty(param.Filter.PfadProduktInformationen))
            {
                strFilter.Append(" AND lower(Komission.PFADPRODUKTINFORMATIONEN) LIKE '%");
                strFilter.Append(param.Filter.PfadProduktInformationen.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.PfadMarktBericht))
            {
                strFilter.Append(" AND lower(Komission.PFADMARKTBERICHT) LIKE '%");
                strFilter.Append(param.Filter.PfadMarktBericht.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.DatenElektronischAktualisierenKz == true)
                strFilter.Append(" AND Komission.datenelektronischaktualisierenkz=1");
            if (param.Filter.BestellungenAutomatischVersendenKz == true)
                strFilter.Append(" AND Komission.bestellungenautomatischversendenkz=1");

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung
            strSortierung.Append("Komission.BEZEICHNUNG");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.Komission");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    sqlCommand1.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int vaterOid = sqlReader.GetOrdinal("vater");
                    int KomissionartOid = sqlReader.GetOrdinal("Komissionart");
                    int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                    int bezeichnung2Oid = sqlReader.GetOrdinal("bezeichnung2");
                    int sortimentsbezeichnungOid = sqlReader.GetOrdinal("sortimentsbezeichnung");
                    int kreditorennummerOid = sqlReader.GetOrdinal("kreditorennummer");
                    int bestelltextOid = sqlReader.GetOrdinal("bestelltext");
                    int kundennummerOid = sqlReader.GetOrdinal("kundennummer");
                    int kundennristinternOid = sqlReader.GetOrdinal("kundennristintern");
                    int pfadproduktinformationenOid = sqlReader.GetOrdinal("pfadproduktinformationen");
                    int pfadmarktberichtOid = sqlReader.GetOrdinal("pfadmarktbericht");
                    int datenelektronischaktualisierenkzOid = sqlReader.GetOrdinal("datenelektronischaktualisierenkz");
                    int bestellungenautomatischversendenkzOid = sqlReader.GetOrdinal("bestellungenautomatischversendenkz");

                    while (sqlReader.Read())
                    {
                        KomissionEntityDM rs = new KomissionEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.Vater = sqlReader.IsDBNull(vaterOid) ? Guid.Empty : sqlReader.GetGuid(vaterOid);
                        rs.KomissionArt = sqlReader.IsDBNull(KomissionartOid) ? Guid.Empty : sqlReader.GetGuid(KomissionartOid);
                        rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                        rs.Bezeichnung2 = sqlReader.IsDBNull(bezeichnung2Oid) ? string.Empty : sqlReader.GetString(bezeichnung2Oid);
                        rs.SortimentsBezeichnung = sqlReader.IsDBNull(sortimentsbezeichnungOid) ? string.Empty : sqlReader.GetString(sortimentsbezeichnungOid);
                        rs.KreditorenNummer = sqlReader.IsDBNull(kreditorennummerOid) ? string.Empty : sqlReader.GetString(kreditorennummerOid);
                        rs.Bestelltext = sqlReader.IsDBNull(bestelltextOid) ? string.Empty : sqlReader.GetString(bestelltextOid);
                        rs.KundenNummer = sqlReader.IsDBNull(kundennummerOid) ? string.Empty : sqlReader.GetString(kundennummerOid);
                        rs.KundenNrIstIntern = sqlReader.IsDBNull(kundennristinternOid) ? false : sqlReader.GetBoolean(kundennristinternOid);
                        rs.PfadProduktInformationen = sqlReader.IsDBNull(pfadproduktinformationenOid) ? string.Empty : sqlReader.GetString(pfadproduktinformationenOid);
                        rs.PfadMarktBericht = sqlReader.IsDBNull(pfadmarktberichtOid) ? string.Empty : sqlReader.GetString(pfadmarktberichtOid);
                        rs.DatenElektronischAktualisierenKz = sqlReader.IsDBNull(datenelektronischaktualisierenkzOid) ? false : sqlReader.GetBoolean(datenelektronischaktualisierenkzOid);
                        rs.BestellungenAutomatischVersendenKz = sqlReader.IsDBNull(bestellungenautomatischversendenkzOid) ? false : sqlReader.GetBoolean(bestellungenautomatischversendenkzOid);

                        rs.DisableUpdateMask = false;
                        ret.KomissionEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "Komission";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionEntityA"</returns>
        KomissionEntityA IServiceKomissionEntity.Loeschen(KomissionEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionEntityA ret = new KomissionEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_Komission_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"Komission";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.KomissionEntity.Count; i++)
                    {
                        if (param.KomissionEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.KomissionEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.KomissionEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.KomissionEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionEntityA"</returns>
        KomissionEntityA IServiceKomissionEntity.Neu(KomissionEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionEntityA ret = new KomissionEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_Komission_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionEntity.Count; i++)
                    {
                        //if (param.KomissionEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.KomissionEntity[i].Vater != Guid.Empty)
                            sqlCommand1.Parameters["@vater"].Value = (Guid)param.KomissionEntity[i].Vater;
                        else
                            sqlCommand1.Parameters["@vater"].Value = DBNull.Value;
                        if (param.KomissionEntity[i].KomissionArt != Guid.Empty)
                            sqlCommand1.Parameters["@Komissionart"].Value = (Guid)param.KomissionEntity[i].KomissionArt;
                        else
                            sqlCommand1.Parameters["@Komissionart"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.KomissionEntity[i].Bezeichnung;
                        sqlCommand1.Parameters["@bezeichnung2"].Value = (string)param.KomissionEntity[i].Bezeichnung2;
                        sqlCommand1.Parameters["@sortimentsbezeichnung"].Value = (string)param.KomissionEntity[i].SortimentsBezeichnung;
                        sqlCommand1.Parameters["@kreditorennummer"].Value = (string)param.KomissionEntity[i].KreditorenNummer;
                        sqlCommand1.Parameters["@bestelltext"].Value = (string)param.KomissionEntity[i].Bestelltext;
                        sqlCommand1.Parameters["@kundennummer"].Value = (string)param.KomissionEntity[i].KundenNummer;
                        sqlCommand1.Parameters["@kundennristintern"].Value = (short)param.KomissionEntity[i].KundenNrIstIntern;
                        sqlCommand1.Parameters["@pfadproduktinformationen"].Value = (string)param.KomissionEntity[i].PfadProduktInformationen;
                        sqlCommand1.Parameters["@pfadmarktbericht"].Value = (string)param.KomissionEntity[i].PfadMarktBericht;
                        sqlCommand1.Parameters["@datenelektronischaktualisierenkz"].Value = (short)param.KomissionEntity[i].DatenElektronischAktualisierenKz;
                        sqlCommand1.Parameters["@bestellungenautomatischversendenkz"].Value = (short)param.KomissionEntity[i].BestellungenAutomatischVersendenKz;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int vaterOid = sqlReader.GetOrdinal("vater");
                        int KomissionartOid = sqlReader.GetOrdinal("Komissionart");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int bezeichnung2Oid = sqlReader.GetOrdinal("bezeichnung2");
                        int sortimentsbezeichnungOid = sqlReader.GetOrdinal("sortimentsbezeichnung");
                        int kreditorennummerOid = sqlReader.GetOrdinal("kreditorennummer");
                        int bestelltextOid = sqlReader.GetOrdinal("bestelltext");
                        int kundennummerOid = sqlReader.GetOrdinal("kundennummer");
                        int kundennristinternOid = sqlReader.GetOrdinal("kundennristintern");
                        int pfadproduktinformationenOid = sqlReader.GetOrdinal("pfadproduktinformationen");
                        int pfadmarktberichtOid = sqlReader.GetOrdinal("pfadmarktbericht");
                        int datenelektronischaktualisierenkzOid = sqlReader.GetOrdinal("datenelektronischaktualisierenkz");
                        int bestellungenautomatischversendenkzOid = sqlReader.GetOrdinal("bestellungenautomatischversendenkz");


                        if (sqlReader.Read())
                        {
                            KomissionEntityDM rs = new KomissionEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.Vater = sqlReader.IsDBNull(vaterOid) ? Guid.Empty : sqlReader.GetGuid(vaterOid);
                            rs.KomissionArt = sqlReader.IsDBNull(KomissionartOid) ? Guid.Empty : sqlReader.GetGuid(KomissionartOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.Bezeichnung2 = sqlReader.IsDBNull(bezeichnung2Oid) ? string.Empty : sqlReader.GetString(bezeichnung2Oid);
                            rs.SortimentsBezeichnung = sqlReader.IsDBNull(sortimentsbezeichnungOid) ? string.Empty : sqlReader.GetString(sortimentsbezeichnungOid);
                            rs.KreditorenNummer = sqlReader.IsDBNull(kreditorennummerOid) ? string.Empty : sqlReader.GetString(kreditorennummerOid);
                            rs.Bestelltext = sqlReader.IsDBNull(bestelltextOid) ? string.Empty : sqlReader.GetString(bestelltextOid);
                            rs.KundenNummer = sqlReader.IsDBNull(kundennummerOid) ? string.Empty : sqlReader.GetString(kundennummerOid);
                            rs.KundenNrIstIntern = sqlReader.IsDBNull(kundennristinternOid) ? false : sqlReader.GetBoolean(kundennristinternOid);
                            rs.PfadProduktInformationen = sqlReader.IsDBNull(pfadproduktinformationenOid) ? string.Empty : sqlReader.GetString(pfadproduktinformationenOid);
                            rs.PfadMarktBericht = sqlReader.IsDBNull(pfadmarktberichtOid) ? string.Empty : sqlReader.GetString(pfadmarktberichtOid);
                            rs.DatenElektronischAktualisierenKz = sqlReader.IsDBNull(datenelektronischaktualisierenkzOid) ? false : sqlReader.GetBoolean(datenelektronischaktualisierenkzOid);
                            rs.BestellungenAutomatischVersendenKz = sqlReader.IsDBNull(bestellungenautomatischversendenkzOid) ? false : sqlReader.GetBoolean(bestellungenautomatischversendenkzOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionEntityA"</returns>
        KomissionEntityA IServiceKomissionEntity.Speichern(KomissionEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionEntityA ret = new KomissionEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_Komission_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionEntity.Count; i++)
                    {
                        //if (param.KomissionEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.KomissionEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("Vater")) // && (param.KomissionEntity[i].Vater != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@vater"].Value = (Guid)param.KomissionEntity[i].Vater;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@vater"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("KomissionArt")) // && (param.KomissionEntity[i].KomissionArt != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@Komissionart"].Value = (Guid)param.KomissionEntity[i].KomissionArt;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@Komissionart"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bezeichnung"))
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.KomissionEntity[i].Bezeichnung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bezeichnung2"))
                        {
                            sqlCommand1.Parameters["@bezeichnung2"].Value = (string)param.KomissionEntity[i].Bezeichnung2;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bezeichnung2"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("SortimentsBezeichnung"))
                        {
                            sqlCommand1.Parameters["@sortimentsbezeichnung"].Value = (string)param.KomissionEntity[i].SortimentsBezeichnung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@sortimentsbezeichnung"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("KreditorenNummer"))
                        {
                            sqlCommand1.Parameters["@kreditorennummer"].Value = (string)param.KomissionEntity[i].KreditorenNummer;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@kreditorennummer"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bestelltext"))
                        {
                            sqlCommand1.Parameters["@bestelltext"].Value = (string)param.KomissionEntity[i].Bestelltext;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestelltext"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("KundenNummer"))
                        {
                            sqlCommand1.Parameters["@kundennummer"].Value = (string)param.KomissionEntity[i].KundenNummer;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@kundennummer"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("KundenNrIstIntern"))
                        {
                            sqlCommand1.Parameters["@kundennristintern"].Value = (short)param.KomissionEntity[i].KundenNrIstIntern;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@kundennristintern"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("PfadProduktInformationen"))
                        {
                            sqlCommand1.Parameters["@pfadproduktinformationen"].Value = (string)param.KomissionEntity[i].PfadProduktInformationen;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@pfadproduktinformationen"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("PfadMarktBericht"))
                        {
                            sqlCommand1.Parameters["@pfadmarktbericht"].Value = (string)param.KomissionEntity[i].PfadMarktBericht;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@pfadmarktbericht"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("DatenElektronischAktualisierenKz"))
                        {
                            sqlCommand1.Parameters["@datenelektronischaktualisierenkz"].Value = (short)param.KomissionEntity[i].DatenElektronischAktualisierenKz;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@datenelektronischaktualisierenkz"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BestellungenAutomatischVersendenKz"))
                        {
                            sqlCommand1.Parameters["@bestellungenautomatischversendenkz"].Value = (short)param.KomissionEntity[i].BestellungenAutomatischVersendenKz;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestellungenautomatischversendenkz"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int vaterOid = sqlReader.GetOrdinal("vater");
                        int KomissionartOid = sqlReader.GetOrdinal("Komissionart");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int bezeichnung2Oid = sqlReader.GetOrdinal("bezeichnung2");
                        int sortimentsbezeichnungOid = sqlReader.GetOrdinal("sortimentsbezeichnung");
                        int kreditorennummerOid = sqlReader.GetOrdinal("kreditorennummer");
                        int bestelltextOid = sqlReader.GetOrdinal("bestelltext");
                        int kundennummerOid = sqlReader.GetOrdinal("kundennummer");
                        int kundennristinternOid = sqlReader.GetOrdinal("kundennristintern");
                        int pfadproduktinformationenOid = sqlReader.GetOrdinal("pfadproduktinformationen");
                        int pfadmarktberichtOid = sqlReader.GetOrdinal("pfadmarktbericht");
                        int datenelektronischaktualisierenkzOid = sqlReader.GetOrdinal("datenelektronischaktualisierenkz");
                        int bestellungenautomatischversendenkzOid = sqlReader.GetOrdinal("bestellungenautomatischversendenkz");


                        if (sqlReader.Read())
                        {
                            KomissionEntityDM rs = new KomissionEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.KomissionEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.KomissionEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.Vater = sqlReader.IsDBNull(vaterOid) ? Guid.Empty : sqlReader.GetGuid(vaterOid);
                            rs.KomissionArt = sqlReader.IsDBNull(KomissionartOid) ? Guid.Empty : sqlReader.GetGuid(KomissionartOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.Bezeichnung2 = sqlReader.IsDBNull(bezeichnung2Oid) ? string.Empty : sqlReader.GetString(bezeichnung2Oid);
                            rs.SortimentsBezeichnung = sqlReader.IsDBNull(sortimentsbezeichnungOid) ? string.Empty : sqlReader.GetString(sortimentsbezeichnungOid);
                            rs.KreditorenNummer = sqlReader.IsDBNull(kreditorennummerOid) ? string.Empty : sqlReader.GetString(kreditorennummerOid);
                            rs.Bestelltext = sqlReader.IsDBNull(bestelltextOid) ? string.Empty : sqlReader.GetString(bestelltextOid);
                            rs.KundenNummer = sqlReader.IsDBNull(kundennummerOid) ? string.Empty : sqlReader.GetString(kundennummerOid);
                            rs.KundenNrIstIntern = sqlReader.IsDBNull(kundennristinternOid) ? false : sqlReader.GetBoolean(kundennristinternOid);
                            rs.PfadProduktInformationen = sqlReader.IsDBNull(pfadproduktinformationenOid) ? string.Empty : sqlReader.GetString(pfadproduktinformationenOid);
                            rs.PfadMarktBericht = sqlReader.IsDBNull(pfadmarktberichtOid) ? string.Empty : sqlReader.GetString(pfadmarktberichtOid);
                            rs.DatenElektronischAktualisierenKz = sqlReader.IsDBNull(datenelektronischaktualisierenkzOid) ? false : sqlReader.GetBoolean(datenelektronischaktualisierenkzOid);
                            rs.BestellungenAutomatischVersendenKz = sqlReader.IsDBNull(bestellungenautomatischversendenkzOid) ? false : sqlReader.GetBoolean(bestellungenautomatischversendenkzOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        KomissionLookupA IServiceKomissionEntity.Lookup(KomissionLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionLookupA ret = new KomissionLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "Komission");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.Komission");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID,BEZEICHNUNG,BEZEICHNUNG2,VATER");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@sortfield", "BEZEICHNUNG");
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");
                        int bezeichnungOid = sqlReader.GetOrdinal("BEZEICHNUNG");
                        int bezeichnung2Oid = sqlReader.GetOrdinal("BEZEICHNUNG2");
                        int vaterOid = sqlReader.GetOrdinal("VATER");

                        while (sqlReader.Read())
                        {
                            KomissionLookupDM rs = new KomissionLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                            rs.Vater = sqlReader.IsDBNull(vaterOid) ? Guid.Empty : sqlReader.GetGuid(vaterOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.Bezeichnung2 = sqlReader.IsDBNull(bezeichnung2Oid) ? string.Empty : sqlReader.GetString(bezeichnung2Oid);

                            ret.KomissionLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new KomissionLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceKomissionArtEntity
    /// </summary>
    public partial class ServiceKomissionArtEntity : IServiceKomissionArtEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(KomissionArtEntityF paramF);
        partial void Lesen_NachImpl(KomissionArtEntityF paramF, KomissionArtEntityA paramA);
        partial void Loeschen_VorImpl(KomissionArtEntityF param);
        partial void Loeschen_NachImpl(KomissionArtEntityF paramF, KomissionArtEntityA paramA);
        partial void Neu_VorImpl(KomissionArtEntityF paramF);
        partial void Neu_NachImpl(KomissionArtEntityF paramF, KomissionArtEntityA paramA);
        partial void Speichern_VorImpl(KomissionArtEntityF param);
        partial void Speichern_NachImpl(KomissionArtEntityF paramF, KomissionArtEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtEntityA"</returns>
        KomissionArtEntityA IServiceKomissionArtEntity.Lesen(KomissionArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtEntityA ret = new KomissionArtEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" KomissionArt.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            if (!string.IsNullOrEmpty(param.VolltextSuche))
            {
                StringBuilder suchbedingung = new StringBuilder();
                string[] fields = new string[1];
                fields[0] = "KomissionArt.BEZEICHNUNG";
                string[] volltextsuche = param.VolltextSuche.Split(' ');
                for (int j = 0; j < fields.Length; j++)
                {
                    StringBuilder suchbez = new StringBuilder();
                    for (int i = 0; i < volltextsuche.Length; i++)
                    {
                        suchbez.Append(" AND lower(" + fields[j] + ") LIKE '%");
                        suchbez.Append(volltextsuche[i].ToLower().Trim());
                        suchbez.Append("%'");
                    }
                    suchbez.Remove(0, 4); 		// erste UND bedingung muss weg
                    suchbez.Insert(0, " OR (");
                    suchbez.Append(") ");
                    suchbedingung.Append(suchbez.ToString());
                }
                suchbedingung.Remove(0, 3); 		// erste OR bedingung muss weg
                suchbedingung.Insert(0, " AND ( ");
                suchbedingung.Append(") ");

                strFilter.Append(suchbedingung.ToString());
            }
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND KomissionArt.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionArt.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionArt.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionArt.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionArt.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (!string.IsNullOrEmpty(param.Filter.Bezeichnung))
            {
                strFilter.Append(" AND lower(KomissionArt.BEZEICHNUNG) LIKE '%");
                strFilter.Append(param.Filter.Bezeichnung.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.Sortierung != 0)
            {
                strFilter.Append(" AND KomissionArt.sortierung=");
                strFilter.Append(param.Filter.Sortierung.ToString());
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung
            strSortierung.Append("KomissionArt.SORTIERUNG");
            strSortierung.Append(",KomissionArt.BEZEICHNUNG");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.KomissionArt");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                    int sortierungOid = sqlReader.GetOrdinal("sortierung");

                    while (sqlReader.Read())
                    {
                        KomissionArtEntityDM rs = new KomissionArtEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                        if (!sqlReader.IsDBNull(sortierungOid))
                            rs.Sortierung = sqlReader.GetInt32(sortierungOid);

                        rs.DisableUpdateMask = false;
                        ret.KomissionArtEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "KomissionArt";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtEntityA"</returns>
        KomissionArtEntityA IServiceKomissionArtEntity.Loeschen(KomissionArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtEntityA ret = new KomissionArtEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_KomissionArt_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"KomissionArt";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.KomissionArtEntity.Count; i++)
                    {
                        if (param.KomissionArtEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.KomissionArtEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.KomissionArtEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.KomissionArtEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtEntityA"</returns>
        KomissionArtEntityA IServiceKomissionArtEntity.Neu(KomissionArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtEntityA ret = new KomissionArtEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionArt_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionArtEntity.Count; i++)
                    {
                        //if (param.KomissionArtEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionArtEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionArtEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.KomissionArtEntity[i].Bezeichnung;
                        sqlCommand1.Parameters["@sortierung"].Value = (int)param.KomissionArtEntity[i].Sortierung;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int sortierungOid = sqlReader.GetOrdinal("sortierung");


                        if (sqlReader.Read())
                        {
                            KomissionArtEntityDM rs = new KomissionArtEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionArtEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            if (!sqlReader.IsDBNull(sortierungOid))
                                rs.Sortierung = sqlReader.GetInt32(sortierungOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionArtEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtEntityA"</returns>
        KomissionArtEntityA IServiceKomissionArtEntity.Speichern(KomissionArtEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtEntityA ret = new KomissionArtEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionArt_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionArtEntity.Count; i++)
                    {
                        //if (param.KomissionArtEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionArtEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionArtEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.KomissionArtEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("Bezeichnung"))
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.KomissionArtEntity[i].Bezeichnung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Sortierung"))
                        {
                            sqlCommand1.Parameters["@sortierung"].Value = (int)param.KomissionArtEntity[i].Sortierung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@sortierung"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int sortierungOid = sqlReader.GetOrdinal("sortierung");


                        if (sqlReader.Read())
                        {
                            KomissionArtEntityDM rs = new KomissionArtEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionArtEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.KomissionArtEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.KomissionArtEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            if (!sqlReader.IsDBNull(sortierungOid))
                                rs.Sortierung = sqlReader.GetInt32(sortierungOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionArtEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        KomissionArtLookupA IServiceKomissionArtEntity.Lookup(KomissionArtLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtLookupA ret = new KomissionArtLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "KomissionArt");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.KomissionArt");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@sortfield", "SORTIERUNG,BEZEICHNUNG");
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            KomissionArtLookupDM rs = new KomissionArtLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.KomissionArtLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new KomissionArtLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceKomissionArtikelEntity
    /// </summary>
    public partial class ServiceKomissionArtikelEntity : IServiceKomissionArtikelEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(KomissionArtikelEntityF paramF);
        partial void Lesen_NachImpl(KomissionArtikelEntityF paramF, KomissionArtikelEntityA paramA);
        partial void Loeschen_VorImpl(KomissionArtikelEntityF param);
        partial void Loeschen_NachImpl(KomissionArtikelEntityF paramF, KomissionArtikelEntityA paramA);
        partial void Neu_VorImpl(KomissionArtikelEntityF paramF);
        partial void Neu_NachImpl(KomissionArtikelEntityF paramF, KomissionArtikelEntityA paramA);
        partial void Speichern_VorImpl(KomissionArtikelEntityF param);
        partial void Speichern_NachImpl(KomissionArtikelEntityF paramF, KomissionArtikelEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtikelEntityA"</returns>
        KomissionArtikelEntityA IServiceKomissionArtikelEntity.Lesen(KomissionArtikelEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtikelEntityA ret = new KomissionArtikelEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" KomissionArtikel.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            if (!string.IsNullOrEmpty(param.VolltextSuche))
            {
                StringBuilder suchbedingung = new StringBuilder();
                string[] fields = new string[3];
                fields[0] = "KomissionArtikel.OrderArtNR";
                fields[1] = "KomissionArtikel.BEZEICHNUNG";
                fields[2] = "KomissionArtikel.BESCHREIBUNG";
                string[] volltextsuche = param.VolltextSuche.Split(' ');
                for (int j = 0; j < fields.Length; j++)
                {
                    StringBuilder suchbez = new StringBuilder();
                    for (int i = 0; i < volltextsuche.Length; i++)
                    {
                        suchbez.Append(" AND lower(" + fields[j] + ") LIKE '%");
                        suchbez.Append(volltextsuche[i].ToLower().Trim());
                        suchbez.Append("%'");
                    }
                    suchbez.Remove(0, 4); 		// erste UND bedingung muss weg
                    suchbez.Insert(0, " OR (");
                    suchbez.Append(") ");
                    suchbedingung.Append(suchbez.ToString());
                }
                suchbedingung.Remove(0, 3); 		// erste OR bedingung muss weg
                suchbedingung.Insert(0, " AND ( ");
                suchbedingung.Append(") ");

                strFilter.Append(suchbedingung.ToString());
            }
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND KomissionArtikel.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionArtikel.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionArtikel.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionArtikel.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionArtikel.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.KleinsteÂbgabeEinheit != Guid.Empty)
            {
                strFilter.Append(" AND KomissionArtikel.kleinsteâbgabeeinheit='");
                strFilter.Append(param.Filter.KleinsteÂbgabeEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.BlsArtikel != Guid.Empty)
            {
                strFilter.Append(" AND KomissionArtikel.blsartikel='");
                strFilter.Append(param.Filter.BlsArtikel.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.ZusatzStoffAllergen != Guid.Empty)
            {
                strFilter.Append(" AND KomissionArtikel.zusatzstoffallergen='");
                strFilter.Append(param.Filter.ZusatzStoffAllergen.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.OrderArt != Guid.Empty)
            {
                strFilter.Append(" AND KomissionArtikel.OrderArt='");
                strFilter.Append(param.Filter.OrderArt.ToString());
                strFilter.Append("' ");
            }
            if (!string.IsNullOrEmpty(param.Filter.OrderArtNr))
            {
                strFilter.Append(" AND lower(KomissionArtikel.OrderArtNR) LIKE '%");
                strFilter.Append(param.Filter.OrderArtNr.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.Bezeichnung))
            {
                strFilter.Append(" AND lower(KomissionArtikel.BEZEICHNUNG) LIKE '%");
                strFilter.Append(param.Filter.Bezeichnung.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (!string.IsNullOrEmpty(param.Filter.Beschreibung))
            {
                strFilter.Append(" AND lower(KomissionArtikel.BESCHREIBUNG) LIKE '%");
                strFilter.Append(param.Filter.Beschreibung.ToString().ToLower());
                strFilter.Append("%'");
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung
            strSortierung.Append("KomissionArtikel.BEZEICHNUNG");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.KomissionArtikel");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int kleinsteâbgabeeinheitOid = sqlReader.GetOrdinal("kleinsteâbgabeeinheit");
                    int blsartikelOid = sqlReader.GetOrdinal("blsartikel");
                    int zusatzstoffallergenOid = sqlReader.GetOrdinal("zusatzstoffallergen");
                    int OrderArtOid = sqlReader.GetOrdinal("OrderArt");
                    int OrderArtnrOid = sqlReader.GetOrdinal("OrderArtnr");
                    int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                    int beschreibungOid = sqlReader.GetOrdinal("beschreibung");

                    while (sqlReader.Read())
                    {
                        KomissionArtikelEntityDM rs = new KomissionArtikelEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.KleinsteÂbgabeEinheit = sqlReader.IsDBNull(kleinsteâbgabeeinheitOid) ? Guid.Empty : sqlReader.GetGuid(kleinsteâbgabeeinheitOid);
                        rs.BlsArtikel = sqlReader.IsDBNull(blsartikelOid) ? Guid.Empty : sqlReader.GetGuid(blsartikelOid);
                        rs.ZusatzStoffAllergen = sqlReader.IsDBNull(zusatzstoffallergenOid) ? Guid.Empty : sqlReader.GetGuid(zusatzstoffallergenOid);
                        rs.OrderArt = sqlReader.IsDBNull(OrderArtOid) ? Guid.Empty : sqlReader.GetGuid(OrderArtOid);
                        rs.OrderArtNr = sqlReader.IsDBNull(OrderArtnrOid) ? string.Empty : sqlReader.GetString(OrderArtnrOid);
                        rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                        rs.Beschreibung = sqlReader.IsDBNull(beschreibungOid) ? string.Empty : sqlReader.GetString(beschreibungOid);

                        rs.DisableUpdateMask = false;
                        ret.KomissionArtikelEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "KomissionArtikel";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtikelEntityA"</returns>
        KomissionArtikelEntityA IServiceKomissionArtikelEntity.Loeschen(KomissionArtikelEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtikelEntityA ret = new KomissionArtikelEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_KomissionArtikel_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"KomissionArtikel";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.KomissionArtikelEntity.Count; i++)
                    {
                        if (param.KomissionArtikelEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.KomissionArtikelEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.KomissionArtikelEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.KomissionArtikelEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtikelEntityA"</returns>
        KomissionArtikelEntityA IServiceKomissionArtikelEntity.Neu(KomissionArtikelEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtikelEntityA ret = new KomissionArtikelEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionArtikel_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionArtikelEntity.Count; i++)
                    {
                        //if (param.KomissionArtikelEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionArtikelEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionArtikelEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.KomissionArtikelEntity[i].KleinsteÂbgabeEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@kleinsteâbgabeeinheit"].Value = (Guid)param.KomissionArtikelEntity[i].KleinsteÂbgabeEinheit;
                        else
                            sqlCommand1.Parameters["@kleinsteâbgabeeinheit"].Value = DBNull.Value;
                        if (param.KomissionArtikelEntity[i].BlsArtikel != Guid.Empty)
                            sqlCommand1.Parameters["@blsartikel"].Value = (Guid)param.KomissionArtikelEntity[i].BlsArtikel;
                        else
                            sqlCommand1.Parameters["@blsartikel"].Value = DBNull.Value;
                        if (param.KomissionArtikelEntity[i].ZusatzStoffAllergen != Guid.Empty)
                            sqlCommand1.Parameters["@zusatzstoffallergen"].Value = (Guid)param.KomissionArtikelEntity[i].ZusatzStoffAllergen;
                        else
                            sqlCommand1.Parameters["@zusatzstoffallergen"].Value = DBNull.Value;
                        if (param.KomissionArtikelEntity[i].OrderArt != Guid.Empty)
                            sqlCommand1.Parameters["@OrderArt"].Value = (Guid)param.KomissionArtikelEntity[i].OrderArt;
                        else
                            sqlCommand1.Parameters["@OrderArt"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@OrderArtnr"].Value = (string)param.KomissionArtikelEntity[i].OrderArtNr;
                        sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.KomissionArtikelEntity[i].Bezeichnung;
                        sqlCommand1.Parameters["@beschreibung"].Value = (string)param.KomissionArtikelEntity[i].Beschreibung;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int kleinsteâbgabeeinheitOid = sqlReader.GetOrdinal("kleinsteâbgabeeinheit");
                        int blsartikelOid = sqlReader.GetOrdinal("blsartikel");
                        int zusatzstoffallergenOid = sqlReader.GetOrdinal("zusatzstoffallergen");
                        int OrderArtOid = sqlReader.GetOrdinal("OrderArt");
                        int OrderArtnrOid = sqlReader.GetOrdinal("OrderArtnr");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int beschreibungOid = sqlReader.GetOrdinal("beschreibung");


                        if (sqlReader.Read())
                        {
                            KomissionArtikelEntityDM rs = new KomissionArtikelEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionArtikelEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.KleinsteÂbgabeEinheit = sqlReader.IsDBNull(kleinsteâbgabeeinheitOid) ? Guid.Empty : sqlReader.GetGuid(kleinsteâbgabeeinheitOid);
                            rs.BlsArtikel = sqlReader.IsDBNull(blsartikelOid) ? Guid.Empty : sqlReader.GetGuid(blsartikelOid);
                            rs.ZusatzStoffAllergen = sqlReader.IsDBNull(zusatzstoffallergenOid) ? Guid.Empty : sqlReader.GetGuid(zusatzstoffallergenOid);
                            rs.OrderArt = sqlReader.IsDBNull(OrderArtOid) ? Guid.Empty : sqlReader.GetGuid(OrderArtOid);
                            rs.OrderArtNr = sqlReader.IsDBNull(OrderArtnrOid) ? string.Empty : sqlReader.GetString(OrderArtnrOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.Beschreibung = sqlReader.IsDBNull(beschreibungOid) ? string.Empty : sqlReader.GetString(beschreibungOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionArtikelEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionArtikelEntityA"</returns>
        KomissionArtikelEntityA IServiceKomissionArtikelEntity.Speichern(KomissionArtikelEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtikelEntityA ret = new KomissionArtikelEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionArtikel_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionArtikelEntity.Count; i++)
                    {
                        //if (param.KomissionArtikelEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionArtikelEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionArtikelEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.KomissionArtikelEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("KleinsteÂbgabeEinheit")) // && (param.KomissionArtikelEntity[i].KleinsteÂbgabeEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@kleinsteâbgabeeinheit"].Value = (Guid)param.KomissionArtikelEntity[i].KleinsteÂbgabeEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@kleinsteâbgabeeinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BlsArtikel")) // && (param.KomissionArtikelEntity[i].BlsArtikel != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@blsartikel"].Value = (Guid)param.KomissionArtikelEntity[i].BlsArtikel;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@blsartikel"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("ZusatzStoffAllergen")) // && (param.KomissionArtikelEntity[i].ZusatzStoffAllergen != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@zusatzstoffallergen"].Value = (Guid)param.KomissionArtikelEntity[i].ZusatzStoffAllergen;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@zusatzstoffallergen"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("OrderArt")) // && (param.KomissionArtikelEntity[i].OrderArt != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@OrderArt"].Value = (Guid)param.KomissionArtikelEntity[i].OrderArt;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@OrderArt"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("OrderArtNr"))
                        {
                            sqlCommand1.Parameters["@OrderArtnr"].Value = (string)param.KomissionArtikelEntity[i].OrderArtNr;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@OrderArtnr"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Bezeichnung"))
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = (string)param.KomissionArtikelEntity[i].Bezeichnung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bezeichnung"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Beschreibung"))
                        {
                            sqlCommand1.Parameters["@beschreibung"].Value = (string)param.KomissionArtikelEntity[i].Beschreibung;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@beschreibung"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int kleinsteâbgabeeinheitOid = sqlReader.GetOrdinal("kleinsteâbgabeeinheit");
                        int blsartikelOid = sqlReader.GetOrdinal("blsartikel");
                        int zusatzstoffallergenOid = sqlReader.GetOrdinal("zusatzstoffallergen");
                        int OrderArtOid = sqlReader.GetOrdinal("OrderArt");
                        int OrderArtnrOid = sqlReader.GetOrdinal("OrderArtnr");
                        int bezeichnungOid = sqlReader.GetOrdinal("bezeichnung");
                        int beschreibungOid = sqlReader.GetOrdinal("beschreibung");


                        if (sqlReader.Read())
                        {
                            KomissionArtikelEntityDM rs = new KomissionArtikelEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionArtikelEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.KomissionArtikelEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.KomissionArtikelEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.KleinsteÂbgabeEinheit = sqlReader.IsDBNull(kleinsteâbgabeeinheitOid) ? Guid.Empty : sqlReader.GetGuid(kleinsteâbgabeeinheitOid);
                            rs.BlsArtikel = sqlReader.IsDBNull(blsartikelOid) ? Guid.Empty : sqlReader.GetGuid(blsartikelOid);
                            rs.ZusatzStoffAllergen = sqlReader.IsDBNull(zusatzstoffallergenOid) ? Guid.Empty : sqlReader.GetGuid(zusatzstoffallergenOid);
                            rs.OrderArt = sqlReader.IsDBNull(OrderArtOid) ? Guid.Empty : sqlReader.GetGuid(OrderArtOid);
                            rs.OrderArtNr = sqlReader.IsDBNull(OrderArtnrOid) ? string.Empty : sqlReader.GetString(OrderArtnrOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);
                            rs.Beschreibung = sqlReader.IsDBNull(beschreibungOid) ? string.Empty : sqlReader.GetString(beschreibungOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionArtikelEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionArtikelEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        KomissionArtikelLookupA IServiceKomissionArtikelEntity.Lookup(KomissionArtikelLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionArtikelLookupA ret = new KomissionArtikelLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "KomissionArtikel");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.KomissionArtikel");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID,OrderArtNR,BEZEICHNUNG");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@sortfield", "OrderArtNR");
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");
                        int OrderArtnrOid = sqlReader.GetOrdinal("OrderArtNR");
                        int bezeichnungOid = sqlReader.GetOrdinal("BEZEICHNUNG");

                        while (sqlReader.Read())
                        {
                            KomissionArtikelLookupDM rs = new KomissionArtikelLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                            rs.OrderArtNr = sqlReader.IsDBNull(OrderArtnrOid) ? string.Empty : sqlReader.GetString(OrderArtnrOid);
                            rs.Bezeichnung = sqlReader.IsDBNull(bezeichnungOid) ? string.Empty : sqlReader.GetString(bezeichnungOid);

                            ret.KomissionArtikelLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new KomissionArtikelLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceKomissionBudgetEntity
    /// </summary>
    public partial class ServiceKomissionBudgetEntity : IServiceKomissionBudgetEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(KomissionBudgetEntityF paramF);
        partial void Lesen_NachImpl(KomissionBudgetEntityF paramF, KomissionBudgetEntityA paramA);
        partial void Loeschen_VorImpl(KomissionBudgetEntityF param);
        partial void Loeschen_NachImpl(KomissionBudgetEntityF paramF, KomissionBudgetEntityA paramA);
        partial void Neu_VorImpl(KomissionBudgetEntityF paramF);
        partial void Neu_NachImpl(KomissionBudgetEntityF paramF, KomissionBudgetEntityA paramA);
        partial void Speichern_VorImpl(KomissionBudgetEntityF param);
        partial void Speichern_NachImpl(KomissionBudgetEntityF paramF, KomissionBudgetEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionBudgetEntityA"</returns>
        KomissionBudgetEntityA IServiceKomissionBudgetEntity.Lesen(KomissionBudgetEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionBudgetEntityA ret = new KomissionBudgetEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" KomissionBudget.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND KomissionBudget.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionBudget.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionBudget.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionBudget.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionBudget.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.OrganisationsEinheit != Guid.Empty)
            {
                strFilter.Append(" AND KomissionBudget.organisationseinheit='");
                strFilter.Append(param.Filter.OrganisationsEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.GeschaeftsJahr != Guid.Empty)
            {
                strFilter.Append(" AND KomissionBudget.geschaeftsjahr='");
                strFilter.Append(param.Filter.GeschaeftsJahr.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.Komission != Guid.Empty)
            {
                strFilter.Append(" AND KomissionBudget.Komission='");
                strFilter.Append(param.Filter.Komission.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.UmsatzZiel != 0.0)
            {
                int iDec = param.Filter.UmsatzZiel.ToString().Length - (param.Filter.UmsatzZiel.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(KomissionBudget.umsatzziel,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.UmsatzZiel.ToString().Replace(",", "."));
            }
            if (param.Filter.BudgetJeBestellungMin != 0.0)
            {
                int iDec = param.Filter.BudgetJeBestellungMin.ToString().Length - (param.Filter.BudgetJeBestellungMin.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(KomissionBudget.budgetjebestellungmin,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.BudgetJeBestellungMin.ToString().Replace(",", "."));
            }
            if (param.Filter.BudgetJeBestellungMax != 0.0)
            {
                int iDec = param.Filter.BudgetJeBestellungMax.ToString().Length - (param.Filter.BudgetJeBestellungMax.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(KomissionBudget.budgetjebestellungmax,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.BudgetJeBestellungMax.ToString().Replace(",", "."));
            }
            if (param.Filter.BestellwertBuchen == true)
                strFilter.Append(" AND KomissionBudget.bestellwertbuchen=1");

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.KomissionBudget");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                    int geschaeftsjahrOid = sqlReader.GetOrdinal("geschaeftsjahr");
                    int KomissionOid = sqlReader.GetOrdinal("Komission");
                    int umsatzzielOid = sqlReader.GetOrdinal("umsatzziel");
                    int budgetjebestellungminOid = sqlReader.GetOrdinal("budgetjebestellungmin");
                    int budgetjebestellungmaxOid = sqlReader.GetOrdinal("budgetjebestellungmax");
                    int bestellwertbuchenOid = sqlReader.GetOrdinal("bestellwertbuchen");

                    while (sqlReader.Read())
                    {
                        KomissionBudgetEntityDM rs = new KomissionBudgetEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                        rs.GeschaeftsJahr = sqlReader.IsDBNull(geschaeftsjahrOid) ? Guid.Empty : sqlReader.GetGuid(geschaeftsjahrOid);
                        rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                        if (!sqlReader.IsDBNull(umsatzzielOid))
                            rs.UmsatzZiel = sqlReader.GetDouble(umsatzzielOid);
                        if (!sqlReader.IsDBNull(budgetjebestellungminOid))
                            rs.BudgetJeBestellungMin = sqlReader.GetDouble(budgetjebestellungminOid);
                        if (!sqlReader.IsDBNull(budgetjebestellungmaxOid))
                            rs.BudgetJeBestellungMax = sqlReader.GetDouble(budgetjebestellungmaxOid);
                        rs.BestellwertBuchen = sqlReader.IsDBNull(bestellwertbuchenOid) ? false : sqlReader.GetBoolean(bestellwertbuchenOid);

                        rs.DisableUpdateMask = false;
                        ret.KomissionBudgetEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "KomissionBudget";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionBudgetEntityA"</returns>
        KomissionBudgetEntityA IServiceKomissionBudgetEntity.Loeschen(KomissionBudgetEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionBudgetEntityA ret = new KomissionBudgetEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_KomissionBudget_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"KomissionBudget";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.KomissionBudgetEntity.Count; i++)
                    {
                        if (param.KomissionBudgetEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.KomissionBudgetEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.KomissionBudgetEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.KomissionBudgetEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionBudgetEntityA"</returns>
        KomissionBudgetEntityA IServiceKomissionBudgetEntity.Neu(KomissionBudgetEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionBudgetEntityA ret = new KomissionBudgetEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionBudget_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionBudgetEntity.Count; i++)
                    {
                        //if (param.KomissionBudgetEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionBudgetEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionBudgetEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.KomissionBudgetEntity[i].OrganisationsEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.KomissionBudgetEntity[i].OrganisationsEinheit;
                        else
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        if (param.KomissionBudgetEntity[i].GeschaeftsJahr != Guid.Empty)
                            sqlCommand1.Parameters["@geschaeftsjahr"].Value = (Guid)param.KomissionBudgetEntity[i].GeschaeftsJahr;
                        else
                            sqlCommand1.Parameters["@geschaeftsjahr"].Value = DBNull.Value;
                        if (param.KomissionBudgetEntity[i].Komission != Guid.Empty)
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.KomissionBudgetEntity[i].Komission;
                        else
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@umsatzziel"].Value = (double)param.KomissionBudgetEntity[i].UmsatzZiel;
                        sqlCommand1.Parameters["@budgetjebestellungmin"].Value = (double)param.KomissionBudgetEntity[i].BudgetJeBestellungMin;
                        sqlCommand1.Parameters["@budgetjebestellungmax"].Value = (double)param.KomissionBudgetEntity[i].BudgetJeBestellungMax;
                        sqlCommand1.Parameters["@bestellwertbuchen"].Value = (short)param.KomissionBudgetEntity[i].BestellwertBuchen;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int geschaeftsjahrOid = sqlReader.GetOrdinal("geschaeftsjahr");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");
                        int umsatzzielOid = sqlReader.GetOrdinal("umsatzziel");
                        int budgetjebestellungminOid = sqlReader.GetOrdinal("budgetjebestellungmin");
                        int budgetjebestellungmaxOid = sqlReader.GetOrdinal("budgetjebestellungmax");
                        int bestellwertbuchenOid = sqlReader.GetOrdinal("bestellwertbuchen");


                        if (sqlReader.Read())
                        {
                            KomissionBudgetEntityDM rs = new KomissionBudgetEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionBudgetEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.GeschaeftsJahr = sqlReader.IsDBNull(geschaeftsjahrOid) ? Guid.Empty : sqlReader.GetGuid(geschaeftsjahrOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                            if (!sqlReader.IsDBNull(umsatzzielOid))
                                rs.UmsatzZiel = sqlReader.GetDouble(umsatzzielOid);
                            if (!sqlReader.IsDBNull(budgetjebestellungminOid))
                                rs.BudgetJeBestellungMin = sqlReader.GetDouble(budgetjebestellungminOid);
                            if (!sqlReader.IsDBNull(budgetjebestellungmaxOid))
                                rs.BudgetJeBestellungMax = sqlReader.GetDouble(budgetjebestellungmaxOid);
                            rs.BestellwertBuchen = sqlReader.IsDBNull(bestellwertbuchenOid) ? false : sqlReader.GetBoolean(bestellwertbuchenOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionBudgetEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionBudgetEntityA"</returns>
        KomissionBudgetEntityA IServiceKomissionBudgetEntity.Speichern(KomissionBudgetEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionBudgetEntityA ret = new KomissionBudgetEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionBudget_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionBudgetEntity.Count; i++)
                    {
                        //if (param.KomissionBudgetEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionBudgetEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionBudgetEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.KomissionBudgetEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("OrganisationsEinheit")) // && (param.KomissionBudgetEntity[i].OrganisationsEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.KomissionBudgetEntity[i].OrganisationsEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("GeschaeftsJahr")) // && (param.KomissionBudgetEntity[i].GeschaeftsJahr != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@geschaeftsjahr"].Value = (Guid)param.KomissionBudgetEntity[i].GeschaeftsJahr;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@geschaeftsjahr"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Komission")) // && (param.KomissionBudgetEntity[i].Komission != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.KomissionBudgetEntity[i].Komission;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("UmsatzZiel"))
                        {
                            sqlCommand1.Parameters["@umsatzziel"].Value = (double)param.KomissionBudgetEntity[i].UmsatzZiel;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@umsatzziel"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BudgetJeBestellungMin"))
                        {
                            sqlCommand1.Parameters["@budgetjebestellungmin"].Value = (double)param.KomissionBudgetEntity[i].BudgetJeBestellungMin;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@budgetjebestellungmin"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BudgetJeBestellungMax"))
                        {
                            sqlCommand1.Parameters["@budgetjebestellungmax"].Value = (double)param.KomissionBudgetEntity[i].BudgetJeBestellungMax;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@budgetjebestellungmax"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("BestellwertBuchen"))
                        {
                            sqlCommand1.Parameters["@bestellwertbuchen"].Value = (short)param.KomissionBudgetEntity[i].BestellwertBuchen;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@bestellwertbuchen"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int geschaeftsjahrOid = sqlReader.GetOrdinal("geschaeftsjahr");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");
                        int umsatzzielOid = sqlReader.GetOrdinal("umsatzziel");
                        int budgetjebestellungminOid = sqlReader.GetOrdinal("budgetjebestellungmin");
                        int budgetjebestellungmaxOid = sqlReader.GetOrdinal("budgetjebestellungmax");
                        int bestellwertbuchenOid = sqlReader.GetOrdinal("bestellwertbuchen");


                        if (sqlReader.Read())
                        {
                            KomissionBudgetEntityDM rs = new KomissionBudgetEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionBudgetEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.KomissionBudgetEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.KomissionBudgetEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.GeschaeftsJahr = sqlReader.IsDBNull(geschaeftsjahrOid) ? Guid.Empty : sqlReader.GetGuid(geschaeftsjahrOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);
                            if (!sqlReader.IsDBNull(umsatzzielOid))
                                rs.UmsatzZiel = sqlReader.GetDouble(umsatzzielOid);
                            if (!sqlReader.IsDBNull(budgetjebestellungminOid))
                                rs.BudgetJeBestellungMin = sqlReader.GetDouble(budgetjebestellungminOid);
                            if (!sqlReader.IsDBNull(budgetjebestellungmaxOid))
                                rs.BudgetJeBestellungMax = sqlReader.GetDouble(budgetjebestellungmaxOid);
                            rs.BestellwertBuchen = sqlReader.IsDBNull(bestellwertbuchenOid) ? false : sqlReader.GetBoolean(bestellwertbuchenOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionBudgetEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionBudgetEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        KomissionBudgetLookupA IServiceKomissionBudgetEntity.Lookup(KomissionBudgetLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionBudgetLookupA ret = new KomissionBudgetLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "KomissionBudget");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.KomissionBudget");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            KomissionBudgetLookupDM rs = new KomissionBudgetLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.KomissionBudgetLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new KomissionBudgetLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceKomissionIndustrieNaehrwertEntity
    /// </summary>
    public partial class ServiceKomissionIndustrieNaehrwertEntity : IServiceKomissionIndustrieNaehrwertEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(KomissionIndustrieNaehrwertEntityF paramF);
        partial void Lesen_NachImpl(KomissionIndustrieNaehrwertEntityF paramF, KomissionIndustrieNaehrwertEntityA paramA);
        partial void Loeschen_VorImpl(KomissionIndustrieNaehrwertEntityF param);
        partial void Loeschen_NachImpl(KomissionIndustrieNaehrwertEntityF paramF, KomissionIndustrieNaehrwertEntityA paramA);
        partial void Neu_VorImpl(KomissionIndustrieNaehrwertEntityF paramF);
        partial void Neu_NachImpl(KomissionIndustrieNaehrwertEntityF paramF, KomissionIndustrieNaehrwertEntityA paramA);
        partial void Speichern_VorImpl(KomissionIndustrieNaehrwertEntityF param);
        partial void Speichern_NachImpl(KomissionIndustrieNaehrwertEntityF paramF, KomissionIndustrieNaehrwertEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionIndustrieNaehrwertEntityA"</returns>
        KomissionIndustrieNaehrwertEntityA IServiceKomissionIndustrieNaehrwertEntity.Lesen(KomissionIndustrieNaehrwertEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionIndustrieNaehrwertEntityA ret = new KomissionIndustrieNaehrwertEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" KomissionIndustrieNaehrwert.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND KomissionIndustrieNaehrwert.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionIndustrieNaehrwert.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionIndustrieNaehrwert.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionIndustrieNaehrwert.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionIndustrieNaehrwert.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.BlsNaehrwerteAllergene != Guid.Empty)
            {
                strFilter.Append(" AND KomissionIndustrieNaehrwert.blsnaehrwerteallergene='");
                strFilter.Append(param.Filter.BlsNaehrwerteAllergene.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.KomissionArtikel != Guid.Empty)
            {
                strFilter.Append(" AND KomissionIndustrieNaehrwert.Komissionartikel='");
                strFilter.Append(param.Filter.KomissionArtikel.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.Menge != 0.0)
            {
                int iDec = param.Filter.Menge.ToString().Length - (param.Filter.Menge.ToString().IndexOf(",") + 1);
                strFilter.Append(" AND ROUND(KomissionIndustrieNaehrwert.menge,");
                strFilter.Append(iDec.ToString());
                strFilter.Append(")=");
                strFilter.Append(param.Filter.Menge.ToString().Replace(",", "."));
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.KomissionIndustrieNaehrwert");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int blsnaehrwerteallergeneOid = sqlReader.GetOrdinal("blsnaehrwerteallergene");
                    int KomissionartikelOid = sqlReader.GetOrdinal("Komissionartikel");
                    int mengeOid = sqlReader.GetOrdinal("menge");

                    while (sqlReader.Read())
                    {
                        KomissionIndustrieNaehrwertEntityDM rs = new KomissionIndustrieNaehrwertEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.BlsNaehrwerteAllergene = sqlReader.IsDBNull(blsnaehrwerteallergeneOid) ? Guid.Empty : sqlReader.GetGuid(blsnaehrwerteallergeneOid);
                        rs.KomissionArtikel = sqlReader.IsDBNull(KomissionartikelOid) ? Guid.Empty : sqlReader.GetGuid(KomissionartikelOid);
                        if (!sqlReader.IsDBNull(mengeOid))
                            rs.Menge = sqlReader.GetDouble(mengeOid);

                        rs.DisableUpdateMask = false;
                        ret.KomissionIndustrieNaehrwertEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "KomissionIndustrieNaehrwert";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionIndustrieNaehrwertEntityA"</returns>
        KomissionIndustrieNaehrwertEntityA IServiceKomissionIndustrieNaehrwertEntity.Loeschen(KomissionIndustrieNaehrwertEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionIndustrieNaehrwertEntityA ret = new KomissionIndustrieNaehrwertEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_KomissionIndustrieNaehrwert_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"KomissionIndustrieNaehrwert";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.KomissionIndustrieNaehrwertEntity.Count; i++)
                    {
                        if (param.KomissionIndustrieNaehrwertEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.KomissionIndustrieNaehrwertEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionIndustrieNaehrwertEntityA"</returns>
        KomissionIndustrieNaehrwertEntityA IServiceKomissionIndustrieNaehrwertEntity.Neu(KomissionIndustrieNaehrwertEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionIndustrieNaehrwertEntityA ret = new KomissionIndustrieNaehrwertEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionIndustrieNaehrwert_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionIndustrieNaehrwertEntity.Count; i++)
                    {
                        //if (param.KomissionIndustrieNaehrwertEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionIndustrieNaehrwertEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.KomissionIndustrieNaehrwertEntity[i].BlsNaehrwerteAllergene != Guid.Empty)
                            sqlCommand1.Parameters["@blsnaehrwerteallergene"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].BlsNaehrwerteAllergene;
                        else
                            sqlCommand1.Parameters["@blsnaehrwerteallergene"].Value = DBNull.Value;
                        if (param.KomissionIndustrieNaehrwertEntity[i].KomissionArtikel != Guid.Empty)
                            sqlCommand1.Parameters["@Komissionartikel"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].KomissionArtikel;
                        else
                            sqlCommand1.Parameters["@Komissionartikel"].Value = DBNull.Value;
                        sqlCommand1.Parameters["@menge"].Value = (double)param.KomissionIndustrieNaehrwertEntity[i].Menge;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int blsnaehrwerteallergeneOid = sqlReader.GetOrdinal("blsnaehrwerteallergene");
                        int KomissionartikelOid = sqlReader.GetOrdinal("Komissionartikel");
                        int mengeOid = sqlReader.GetOrdinal("menge");


                        if (sqlReader.Read())
                        {
                            KomissionIndustrieNaehrwertEntityDM rs = new KomissionIndustrieNaehrwertEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionIndustrieNaehrwertEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.BlsNaehrwerteAllergene = sqlReader.IsDBNull(blsnaehrwerteallergeneOid) ? Guid.Empty : sqlReader.GetGuid(blsnaehrwerteallergeneOid);
                            rs.KomissionArtikel = sqlReader.IsDBNull(KomissionartikelOid) ? Guid.Empty : sqlReader.GetGuid(KomissionartikelOid);
                            if (!sqlReader.IsDBNull(mengeOid))
                                rs.Menge = sqlReader.GetDouble(mengeOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionIndustrieNaehrwertEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionIndustrieNaehrwertEntityA"</returns>
        KomissionIndustrieNaehrwertEntityA IServiceKomissionIndustrieNaehrwertEntity.Speichern(KomissionIndustrieNaehrwertEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionIndustrieNaehrwertEntityA ret = new KomissionIndustrieNaehrwertEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionIndustrieNaehrwert_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionIndustrieNaehrwertEntity.Count; i++)
                    {
                        //if (param.KomissionIndustrieNaehrwertEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionIndustrieNaehrwertEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.KomissionIndustrieNaehrwertEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("BlsNaehrwerteAllergene")) // && (param.KomissionIndustrieNaehrwertEntity[i].BlsNaehrwerteAllergene != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@blsnaehrwerteallergene"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].BlsNaehrwerteAllergene;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@blsnaehrwerteallergene"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("KomissionArtikel")) // && (param.KomissionIndustrieNaehrwertEntity[i].KomissionArtikel != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@Komissionartikel"].Value = (Guid)param.KomissionIndustrieNaehrwertEntity[i].KomissionArtikel;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@Komissionartikel"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Menge"))
                        {
                            sqlCommand1.Parameters["@menge"].Value = (double)param.KomissionIndustrieNaehrwertEntity[i].Menge;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@menge"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int blsnaehrwerteallergeneOid = sqlReader.GetOrdinal("blsnaehrwerteallergene");
                        int KomissionartikelOid = sqlReader.GetOrdinal("Komissionartikel");
                        int mengeOid = sqlReader.GetOrdinal("menge");


                        if (sqlReader.Read())
                        {
                            KomissionIndustrieNaehrwertEntityDM rs = new KomissionIndustrieNaehrwertEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionIndustrieNaehrwertEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.KomissionIndustrieNaehrwertEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.KomissionIndustrieNaehrwertEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.BlsNaehrwerteAllergene = sqlReader.IsDBNull(blsnaehrwerteallergeneOid) ? Guid.Empty : sqlReader.GetGuid(blsnaehrwerteallergeneOid);
                            rs.KomissionArtikel = sqlReader.IsDBNull(KomissionartikelOid) ? Guid.Empty : sqlReader.GetGuid(KomissionartikelOid);
                            if (!sqlReader.IsDBNull(mengeOid))
                                rs.Menge = sqlReader.GetDouble(mengeOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionIndustrieNaehrwertEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionIndustrieNaehrwertEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        KomissionIndustrieNaehrwertLookupA IServiceKomissionIndustrieNaehrwertEntity.Lookup(KomissionIndustrieNaehrwertLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionIndustrieNaehrwertLookupA ret = new KomissionIndustrieNaehrwertLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "KomissionIndustrieNaehrwert");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.KomissionIndustrieNaehrwert");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            KomissionIndustrieNaehrwertLookupDM rs = new KomissionIndustrieNaehrwertLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.KomissionIndustrieNaehrwertLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new KomissionIndustrieNaehrwertLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }

    /// <summary>
    /// Implementierung der DatenZugriffsSchnittstelle ServiceKomissionOrgEinheitenEntity
    /// </summary>
    public partial class ServiceKomissionOrgEinheitenEntity : IServiceKomissionOrgEinheitenEntity
    {
        #region Extensibility Method
        // throw an exception inside the ext_method to abort functionality (transaction save!)
        partial void Lesen_VorImpl(KomissionOrgEinheitenEntityF paramF);
        partial void Lesen_NachImpl(KomissionOrgEinheitenEntityF paramF, KomissionOrgEinheitenEntityA paramA);
        partial void Loeschen_VorImpl(KomissionOrgEinheitenEntityF param);
        partial void Loeschen_NachImpl(KomissionOrgEinheitenEntityF paramF, KomissionOrgEinheitenEntityA paramA);
        partial void Neu_VorImpl(KomissionOrgEinheitenEntityF paramF);
        partial void Neu_NachImpl(KomissionOrgEinheitenEntityF paramF, KomissionOrgEinheitenEntityA paramA);
        partial void Speichern_VorImpl(KomissionOrgEinheitenEntityF param);
        partial void Speichern_NachImpl(KomissionOrgEinheitenEntityF paramF, KomissionOrgEinheitenEntityA paramA);
        #endregion

        /// <summary>
        /// Lesen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionOrgEinheitenEntityA"</returns>
        KomissionOrgEinheitenEntityA IServiceKomissionOrgEinheitenEntity.Lesen(KomissionOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionOrgEinheitenEntityA ret = new KomissionOrgEinheitenEntityA();
            ret.HatFehler = true;
            PagingA paging = Paging.CheckPaging(param);

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;
            SqlDataReader sqlReader = null;

            StringBuilder strFilter = new StringBuilder();
            StringBuilder strSortierung = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" KomissionOrgEinheiten.mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");
            if ((Guid)param.Filter.Rowid != Guid.Empty)
            {
                strFilter.Append(" AND KomissionOrgEinheiten.rowid='");
                strFilter.Append(param.Filter.Rowid.ToString());
                strFilter.Append("' ");
            }
            if (param.Filter.ErstelltVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionOrgEinheiten.ERSTELLTVON) LIKE '%");
                strFilter.Append(param.Filter.ErstelltVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.ErstelltAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionOrgEinheiten.ERSTELLTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.ErstelltAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if (param.Filter.GeaendertVon.ToString().Length > 0)
            {
                strFilter.Append(" AND lower(KomissionOrgEinheiten.GEAENDERTVON) LIKE '%");
                strFilter.Append(param.Filter.GeaendertVon.ToString().ToLower());
                strFilter.Append("%'");
            }
            if (param.Filter.GeaendertAm != DateTime.MinValue)
            {
                strFilter.Append(" AND CAST(FLOOR(CAST(KomissionOrgEinheiten.GEAENDERTAM AS float)) AS datetime)='");
                strFilter.Append(param.Filter.GeaendertAm.ToSqlDateFormat());
                strFilter.Append("'");
            }
            if ((Guid)param.Filter.OrganisationsEinheit != Guid.Empty)
            {
                strFilter.Append(" AND KomissionOrgEinheiten.organisationseinheit='");
                strFilter.Append(param.Filter.OrganisationsEinheit.ToString());
                strFilter.Append("' ");
            }
            if ((Guid)param.Filter.Komission != Guid.Empty)
            {
                strFilter.Append(" AND KomissionOrgEinheiten.Komission='");
                strFilter.Append(param.Filter.Komission.ToString());
                strFilter.Append("' ");
            }

            // erweiterte Sql Bedingung aus Basisobjekt
            if (!string.IsNullOrEmpty(param.ExtSqlRestriction))
            {
                strFilter.Append(" AND ");
                strFilter.Append(param.ExtSqlRestriction);
            }

            // sortierung

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Lesen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    sqlCommand1 = new SqlCommand("sp_SelectRecords", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    sqlCommand1.Parameters.AddWithValue("@tablename", "Controlling.KomissionOrgEinheiten");
                    sqlCommand1.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                    sqlCommand1.Parameters.AddWithValue("@sortfield", strSortierung.ToString());
                    sqlCommand1.Parameters.AddWithValue("@userid", param.UserId);
                    if (!string.IsNullOrEmpty(param.TableSortRefTable))
                        sqlCommand1.Parameters.AddWithValue("@tablesortreftable", param.TableSortRefTable.ToString());
                    if (!string.IsNullOrEmpty(param.TableSortColumn))
                        sqlCommand1.Parameters.AddWithValue("@tablesortcolumn", param.TableSortColumn.ToString());
                    //sqlCommand1.Parameters.AddWithValue("@pagesize", 500);
                    //sqlCommand1.Parameters.AddWithValue("@pageindex", 1);

                    sqlReader = sqlCommand1.ExecuteReader();
                    int rowidOid = sqlReader.GetOrdinal("rowid");
                    int mandantOid = sqlReader.GetOrdinal("mandant");
                    int timestampOid = sqlReader.GetOrdinal("timestamp");
                    int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                    int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                    int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                    int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                    int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                    int KomissionOid = sqlReader.GetOrdinal("Komission");

                    while (sqlReader.Read())
                    {
                        KomissionOrgEinheitenEntityDM rs = new KomissionOrgEinheitenEntityDM();
                        rs.DisableUpdateMask = true;

                        rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);
                        if (!sqlReader.IsDBNull(timestampOid))
                        {
                            byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                            sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                            rs.Timestamp = tbyte;
                        }
                        rs.Mandant = sqlReader.IsDBNull(mandantOid) ? Guid.Empty : sqlReader.GetGuid(mandantOid);
                        rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                        rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                        rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                        rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                        rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                        rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);

                        rs.DisableUpdateMask = false;
                        ret.KomissionOrgEinheitenEntity.Add(rs);
                    }
                    // sind dem benutzer alle orgeinheiten zugewiesen? 
                    if ((param.BenuterHatAlleMasterOrgEinheitenHolen) && (param.Filter.Rowid != Guid.Empty))
                    {
                        sqlCommand2 = new SqlCommand("sp_SelectHatAlleOrgEinheiten", sqlConnection);
                        sqlCommand2.CommandTimeout = 300;
                        sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand2.Parameters.Add("@tablename", System.Data.SqlDbType.VarChar);
                        sqlCommand2.Parameters["@tablename"].DbType = System.Data.DbType.String;
                        sqlCommand2.Parameters["@tablename"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@tablename"].Value = "KomissionOrgEinheiten";
                        sqlCommand2.Parameters.Add("@rowid2query", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@rowid2query"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@rowid2query"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@rowid2query"].Value = (Guid)param.Filter.Rowid;
                        sqlCommand2.Parameters.Add("@userid", System.Data.SqlDbType.UniqueIdentifier);
                        sqlCommand2.Parameters["@userid"].DbType = System.Data.DbType.Guid;
                        sqlCommand2.Parameters["@userid"].Direction = System.Data.ParameterDirection.Input;
                        sqlCommand2.Parameters["@userid"].Value = (Guid)param.UserId;
                        sqlCommand2.Parameters.Add("@hatalleorgeinheiten", System.Data.SqlDbType.Bit);
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].DbType = System.Data.DbType.Boolean;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Direction = System.Data.ParameterDirection.InputOutput;
                        sqlCommand2.Parameters["@hatalleorgeinheiten"].Value = false;

                        sqlReader.Close();
                        sqlReader = sqlCommand2.ExecuteReader();
                        ret.BenutzerHatAlleMasterOrgEinheiten = (bool)sqlCommand2.Parameters["@hatalleorgeinheiten"].Value;
                    }
                    Lesen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlReader != null)
                        sqlReader.Close();
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Loeschen.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionOrgEinheitenEntityA"</returns>
        KomissionOrgEinheitenEntityA IServiceKomissionOrgEinheitenEntity.Loeschen(KomissionOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionOrgEinheitenEntityA ret = new KomissionOrgEinheitenEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Loeschen_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // löschen aller abhängigen datensätze mit sp_DeleteRelationships
                    sqlCommand1 = new SqlCommand("dbo.sp_DeleteRelationships", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4DeleteRelationships(sqlCommand1);

                    // löschen des eigentlichen Satzes mit sp_Table_Delete
                    sqlCommand2 = new SqlCommand("Controlling.sp_KomissionOrgEinheiten_Delete", sqlConnection);
                    sqlCommand2.CommandTimeout = 300;
                    sqlCommand2.CommandType = System.Data.CommandType.StoredProcedure;
                    AddParameterDef4Delete(sqlCommand2);

                    sqlCommand1.Parameters["@tablename"].Value = (string)"KomissionOrgEinheiten";
                    sqlCommand1.Parameters["@geaendertvon"].Value = param.UserName;
                    sqlCommand2.Parameters["@mandant"].Value = param.MandantenID;
                    sqlCommand2.Parameters["@geaendertvon"].Value = param.UserName;

                    for (int i = 0; i < param.KomissionOrgEinheitenEntity.Count; i++)
                    {
                        if (param.KomissionOrgEinheitenEntity[i].Timestamp != null)
                        {
                            sqlCommand1.Parameters["@uirowid"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].Rowid;
                            sqlCommand1.ExecuteScalar();

                            int iReturnValue = (int)sqlCommand1.Parameters["@errorvalue"].Value;
                            if (iReturnValue == 1)
                            {
                                String sFKInfo = (string)sqlCommand1.Parameters["@fkdelinfo"].Value.ToString().Replace(",", "\n");
                                if (String.IsNullOrEmpty(sFKInfo))
                                    ret.FehlerText = "Es bestehen noch abhängige Daten.\nDer Datensatz kann nicht gelöscht werden!";
                                else
                                    ret.FehlerText = "Es bestehen noch abhängige Daten:\n" + sFKInfo + "\n\nDer Datensatz kann nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }

                            sqlCommand2.Parameters["@rowid"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].Rowid;
                            sqlCommand2.Parameters["@timestamp"].Value = param.KomissionOrgEinheitenEntity[i].Timestamp;

                            iReturnValue = sqlCommand2.ExecuteNonQuery();
                            if (iReturnValue == 0)
                            {
                                ret.FehlerText = "Der Datensatz konnte nicht gelöscht werden!";
                                ret.HatFehler = true;
                                return ret;
                            }
                        }
                    }
                    Loeschen_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Neu.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionOrgEinheitenEntityA"</returns>
        KomissionOrgEinheitenEntityA IServiceKomissionOrgEinheitenEntity.Neu(KomissionOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionOrgEinheitenEntityA ret = new KomissionOrgEinheitenEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Neu_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // einfügen des eigentlichen Satzes mit sp_Table_Insert
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionOrgEinheiten_Insert", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Insert(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionOrgEinheitenEntity.Count; i++)
                    {
                        //if (param.KomissionOrgEinheitenEntity[i].Timestamp == null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionOrgEinheitenEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].Rowid;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@erstelltvon"].Value = (string)param.UserName;
                        if (param.KomissionOrgEinheitenEntity[i].OrganisationsEinheit != Guid.Empty)
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].OrganisationsEinheit;
                        else
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        if (param.KomissionOrgEinheitenEntity[i].Komission != Guid.Empty)
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].Komission;
                        else
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int erstelltamOid = sqlReader.GetOrdinal("erstelltam");
                        int erstelltvonOid = sqlReader.GetOrdinal("erstelltvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");


                        if (sqlReader.Read())
                        {
                            KomissionOrgEinheitenEntityDM rs = new KomissionOrgEinheitenEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionOrgEinheitenEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = sqlReader.IsDBNull(erstelltvonOid) ? string.Empty : sqlReader.GetString(erstelltvonOid);
                            rs.ErstelltAm = sqlReader.IsDBNull(erstelltamOid) ? DateTime.MinValue : sqlReader.GetDateTime(erstelltamOid);
                            rs.GeaendertVon = rs.ErstelltVon;
                            rs.GeaendertAm = rs.ErstelltAm;
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionOrgEinheitenEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht angelegt werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Neu_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Speichern.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"KomissionOrgEinheitenEntityA"</returns>
        KomissionOrgEinheitenEntityA IServiceKomissionOrgEinheitenEntity.Speichern(KomissionOrgEinheitenEntityF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionOrgEinheitenEntityA ret = new KomissionOrgEinheitenEntityA();
            ret.HatFehler = true;

            // für ado.net
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand1 = null;
            SqlCommand sqlCommand2 = null;


            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
            {
                try
                {
                    // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                    Speichern_VorImpl(param);
                    sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                    sqlConnection.Open();

                    // speichern des eigentlichen Satzes mit sp_Table_Update
                    sqlCommand1 = new SqlCommand("Controlling.sp_KomissionOrgEinheiten_UpdateCols", sqlConnection);
                    sqlCommand1.CommandTimeout = 300;
                    AddParameterDef4Update(sqlCommand1);
                    sqlCommand1.CommandType = System.Data.CommandType.StoredProcedure;

                    for (int i = 0; i < param.KomissionOrgEinheitenEntity.Count; i++)
                    {
                        //if (param.KomissionOrgEinheitenEntity[i].Timestamp != null) // update nicht mehr über timestamp
                        //{
                        System.Collections.Generic.List<string> changedColumns = param.KomissionOrgEinheitenEntity[i].GetUpdatedColumns();

                        sqlCommand1.Parameters["@rowid"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].Rowid;
                        sqlCommand1.Parameters["@timestamp"].Value = param.KomissionOrgEinheitenEntity[i].Timestamp;
                        sqlCommand1.Parameters["@mandant"].Value = (Guid)param.MandantenID;
                        sqlCommand1.Parameters["@geaendertvon"].Value = (string)param.UserName;
                        if (changedColumns.Contains("OrganisationsEinheit")) // && (param.KomissionOrgEinheitenEntity[i].OrganisationsEinheit != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].OrganisationsEinheit;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@organisationseinheit"].Value = DBNull.Value;
                        }
                        if (changedColumns.Contains("Komission")) // && (param.KomissionOrgEinheitenEntity[i].Komission != Guid.Empty))
                        {
                            sqlCommand1.Parameters["@Komission"].Value = (Guid)param.KomissionOrgEinheitenEntity[i].Komission;
                        }
                        else
                        {
                            sqlCommand1.Parameters["@Komission"].Value = DBNull.Value;
                        }

                        SqlDataReader sqlReader = sqlCommand1.ExecuteReader();

                        int timestampOid = sqlReader.GetOrdinal("timestamp");
                        int geaendertamOid = sqlReader.GetOrdinal("geaendertam");
                        int geaendertvonOid = sqlReader.GetOrdinal("geaendertvon");
                        int organisationseinheitOid = sqlReader.GetOrdinal("organisationseinheit");
                        int KomissionOid = sqlReader.GetOrdinal("Komission");


                        if (sqlReader.Read())
                        {
                            KomissionOrgEinheitenEntityDM rs = new KomissionOrgEinheitenEntityDM();
                            rs.DisableUpdateMask = true;

                            rs.Rowid = param.KomissionOrgEinheitenEntity[i].Rowid;
                            if (!sqlReader.IsDBNull(timestampOid))
                            {
                                byte[] tbyte = new byte[sqlReader.GetBytes(timestampOid, 0, null, 0, int.MaxValue)]; // länge ermitteln
                                sqlReader.GetBytes(timestampOid, 0, tbyte, 0, int.MaxValue); // timestamp in buffer einlesen
                                rs.Timestamp = tbyte;
                            }
                            rs.Mandant = param.MandantenID;
                            rs.ErstelltVon = param.KomissionOrgEinheitenEntity[i].ErstelltVon;
                            rs.ErstelltAm = param.KomissionOrgEinheitenEntity[i].ErstelltAm;
                            rs.GeaendertVon = sqlReader.IsDBNull(geaendertvonOid) ? string.Empty : sqlReader.GetString(geaendertvonOid);
                            rs.GeaendertAm = sqlReader.IsDBNull(geaendertamOid) ? DateTime.MinValue : sqlReader.GetDateTime(geaendertamOid);
                            rs.OrganisationsEinheit = sqlReader.IsDBNull(organisationseinheitOid) ? Guid.Empty : sqlReader.GetGuid(organisationseinheitOid);
                            rs.Komission = sqlReader.IsDBNull(KomissionOid) ? Guid.Empty : sqlReader.GetGuid(KomissionOid);

                            rs.DisableUpdateMask = false;
                            ret.KomissionOrgEinheitenEntity.Add(rs);
                        }
                        else
                        {
                            ret.FehlerText = "Der Datensatz konnte nicht gespeichert werden!";
                            ret.HatFehler = true;
                            return ret;
                        }

                        sqlReader.Close();
                        //}
                    }
                    Speichern_NachImpl(param, ret);
                    scope.Complete();
                }
                catch (SqlException ex)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = "Sql-Fehler: " + ex.Number.ToString() + " " + ex.Message;

                    return ret;
                }
                catch (Exception e)
                {
                    // logging des fehlers noch implementieren
                    ret = new KomissionOrgEinheitenEntityA();
                    ret.HatFehler = true;
                    ret.FehlerText = e.Message;
                    return ret;
                }
                finally
                {
                    if (sqlCommand1 != null)
                        sqlCommand1.Dispose();
                    if (sqlCommand2 != null)
                        sqlCommand2.Dispose();
                    if (sqlConnection != null)
                        sqlConnection.Close();
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }

        /// <summary>
        /// Lookup.
        /// </summary>
        /// <param name="param">Der Parameter.</param>
        /// <returns>"LookupA"</returns>
        KomissionOrgEinheitenLookupA IServiceKomissionOrgEinheitenEntity.Lookup(KomissionOrgEinheitenLookupF param)
        {
            #region ------------------------------ Initialisierung ------------------------------

            KomissionOrgEinheitenLookupA ret = new KomissionOrgEinheitenLookupA();
            ret.HatFehler = true;
            PagingA paging = new PagingA();
            paging = Paging.CheckPaging(param);
            DateTime letzteAenderung = DateTime.MinValue;

            // für ado.net
            Verbindung verbindung = new Verbindung();
            SqlConnection sqlConnection = null;
            SqlCommand sqlCommand = null;
            SqlDataReader sqlReader = null;

            // sql filterbedingung 	
            StringBuilder strFilter = new StringBuilder();

            // queryfilter aufbereiten
            strFilter.Append(" mandant='");
            strFilter.Append(param.MandantenID.ToString());
            strFilter.Append("' ");

            #endregion --------------------------- Initialisierung Ende -------------------------


            #region ------------------------------ Implementierung ------------------------------

            letzteAenderung = LookupStatus.Lesen(param.MandantenID, "Controlling", "KomissionOrgEinheiten");
            if ((letzteAenderung > param.LetzteAenderung) || (letzteAenderung == DateTime.MinValue))
            {
                // was ist mit ... new DebuggerWriter();  // writing to the debugger log window

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        sqlConnection = new SqlConnection(VerbindungsEinstellung.ConnectionString);
                        sqlConnection.Open();

                        sqlCommand = new SqlCommand("sp_SelectRecords", sqlConnection);
                        sqlCommand.CommandType = System.Data.CommandType.StoredProcedure;
                        sqlCommand.Parameters.AddWithValue("@tablename", "Controlling.KomissionOrgEinheiten");
                        sqlCommand.Parameters.AddWithValue("@columnlist", "ROWID");
                        sqlCommand.Parameters.AddWithValue("@queryfilter", strFilter.ToString());
                        sqlCommand.Parameters.AddWithValue("@userid", param.UserId);
                        sqlCommand.Parameters.AddWithValue("@pagesize", -1); // alle datensätze holen
                        //sqlCommand.Parameters.AddWithValue("@pageindex", 1);

                        sqlReader = sqlCommand.ExecuteReader();
                        int rowidOid = sqlReader.GetOrdinal("ROWID");

                        while (sqlReader.Read())
                        {
                            KomissionOrgEinheitenLookupDM rs = new KomissionOrgEinheitenLookupDM();

                            rs.Rowid = sqlReader.IsDBNull(rowidOid) ? Guid.Empty : sqlReader.GetGuid(rowidOid);

                            ret.KomissionOrgEinheitenLookup.Add(rs);
                        }
                        ret.LetzteAenderung = letzteAenderung;
                        scope.Complete();
                    }
                    catch (Exception e)
                    {
                        // logging des fehlers noch implementieren

                        ret = new KomissionOrgEinheitenLookupA();
                        ret.HatFehler = true;
                        ret.FehlerText = e.Message;
                        throw;
                    }
                    finally
                    {
                        if (sqlReader != null)
                            sqlReader.Dispose();
                        if (sqlCommand != null)
                            sqlCommand.Dispose();
                        if (sqlConnection != null)
                            sqlConnection.Dispose();
                    }
                }
            }

            #endregion --------------------------- Implementierung Ende -------------------------


            #region ------------------------------ Rueckgabe ------------------------------

            ret.HatFehler = false;
            return ret;

            #endregion --------------------------- Rueckgabe Ende -------------------------
        }



    }
}
