<?xml version="1.0"?>
<doc>
    <assembly>
        <name>Microsoft.VisualStudio.Modeling.Sdk.DslDefinition</name>
    </assembly>
    <members>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelper">
            <summary>
            Helper class used to map shapes and model elements to help keywords.
            </summary>
            <remarks>
            Double-derived class to allow easier code customization.
            </remarks>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase">
            <summary>
            Helper class used to map shapes and model elements to F1 help keywords.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase.#ctor">
            <summary>
            Constructs a new DslDefinitionModelHelpKeywordHelperBase.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase.Initialize">
            <summary>
            Called to initialize the HelpKeywords dictionary.  Derived classes may override this to add custom keywords to the collection.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase.GetHelpKeyword(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Gets the help keyword associated with the given shape or model element instance.
            </summary>
            <returns>Help keyword, or empty string if there is no associated help keyword.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase.GetDomainRoleHelpKeyword(Microsoft.VisualStudio.Modeling.DomainRoleInfo)">
            <summary>
            Gets the help keyword associated with the given domain role.
            </summary>
            <returns>Help keyword, or empty string if there is no associated help keyword.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase.GetDomainPropertyHelpKeyword(Microsoft.VisualStudio.Modeling.DomainPropertyInfo)">
            <summary>
            Gets the help keyword associated with the given domain property.
            </summary>
            <returns>Help keyword, or empty string if there is no associated help keyword.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelperBase.HelpKeywords">
            <summary>
            Collection of key/value pairs describing help keywords for this DSL.
            Keys are strings such as domain class names that describe elements of the DSL.
            Values are corresponding help keywords.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelper.#ctor">
            <summary>
            Constructs a new DslDefinitionModelHelpKeywordHelper.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelHelpKeywordHelper.Instance">
            <summary>
            Single instance of the DslDefinitionModelHelpKeywordHelper.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptionProvider">
            <summary>
            Factory class for ExplorerBehaviorTypeDescriptors.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptionProvider.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptionProvider.CreateTypeDescriptor(System.ComponentModel.ICustomTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Called by the System.ComponentModel framework when it requires a type descriptor instance.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor">
            <summary>
            Custom type descriptor class for ExplorerBehavior elements.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.#ctor(System.ComponentModel.ICustomTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.GetProperties(System.Attribute[])">
            <summary>
            Returns a collection of property descriptors an instance of ExplorerBehavior.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.ExplorerTitlePropertyDescriptor1">
            <summary>
            Specialized property descriptor used when the Title property appears on the ExplorerBehavior class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.ExplorerTitlePropertyDescriptor1.#ctor(Microsoft.VisualStudio.Modeling.Design.ElementTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            Constructs a new ExplorerTitlePropertyDescriptor1.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.ExplorerTitlePropertyDescriptor1.Category">
            <summary>
            Category this property appears in.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.ExplorerExplorerGuidPropertyDescriptor2">
            <summary>
            Specialized property descriptor used when the ExplorerGuid property appears on the ExplorerBehavior class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.ExplorerExplorerGuidPropertyDescriptor2.#ctor(Microsoft.VisualStudio.Modeling.Design.ElementTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            Constructs a new ExplorerExplorerGuidPropertyDescriptor2.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehaviorTypeDescriptor.ExplorerExplorerGuidPropertyDescriptor2.Category">
            <summary>
            Category this property appears in.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptionProvider">
            <summary>
            Factory class for XmlSerializationBehaviorTypeDescriptors.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptionProvider.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptionProvider.CreateTypeDescriptor(System.ComponentModel.ICustomTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Called by the System.ComponentModel framework when it requires a type descriptor instance.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor">
            <summary>
            Custom type descriptor class for XmlSerializationBehavior elements.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.#ctor(System.ComponentModel.ICustomTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.GetProperties(System.Attribute[])">
            <summary>
            Returns a collection of property descriptors an instance of XmlSerializationBehavior.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionCustomPostLoadPropertyDescriptor1">
            <summary>
            Specialized property descriptor used when the CustomPostLoad property appears on the XmlSerializationBehavior class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionCustomPostLoadPropertyDescriptor1.#ctor(Microsoft.VisualStudio.Modeling.Design.ElementTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            Constructs a new XmlSerializationDefinitionCustomPostLoadPropertyDescriptor1.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionCustomPostLoadPropertyDescriptor1.Category">
            <summary>
            Category this property appears in.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionRootNamespacePropertyDescriptor2">
            <summary>
            Specialized property descriptor used when the RootNamespace property appears on the XmlSerializationBehavior class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionRootNamespacePropertyDescriptor2.#ctor(Microsoft.VisualStudio.Modeling.Design.ElementTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            Constructs a new XmlSerializationDefinitionRootNamespacePropertyDescriptor2.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionRootNamespacePropertyDescriptor2.Category">
            <summary>
            Category this property appears in.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionWriteOptionalPropertiesWithDefaultValuePropertyDescriptor3">
            <summary>
            Specialized property descriptor used when the WriteOptionalPropertiesWithDefaultValue property appears on the XmlSerializationBehavior class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionWriteOptionalPropertiesWithDefaultValuePropertyDescriptor3.#ctor(Microsoft.VisualStudio.Modeling.Design.ElementTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            Constructs a new XmlSerializationDefinitionWriteOptionalPropertiesWithDefaultValuePropertyDescriptor3.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehaviorTypeDescriptor.XmlSerializationDefinitionWriteOptionalPropertiesWithDefaultValuePropertyDescriptor3.Category">
            <summary>
            Category this property appears in.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase">
            <summary>
            Double-derived base class for DomainClass DslLibrary
            </summary>
            <summary>
            Customized DslLibraryBase code.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement">
            <summary>
            DomainClass NamedDomainElement
            Abstract base class for elements of a DSL definition which have names.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement">
            <summary>
            DomainClass AttributedDomainElement
            Domain elements that can have CLR Attributes defined on them.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement">
            <summary>
            DomainClass DomainElement
            Abstract base class of all components of a domain specific language definition.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.DomainClassId">
            <summary>
            DomainElement domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.NotesDomainPropertyId">
            <summary>
            Notes domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.notesPropertyStorage">
            <summary>
            Storage for Notes
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.Notes">
            <summary>
            Gets or sets the value of Notes domain property.
            Informal notes associated with this element.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.NotesPropertyHandler">
            <summary>
            Value handler for the DomainElement.Notes domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.NotesPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainElement.Notes domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.NotesPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.NotesPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainElement.NotesPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainElement.Notes domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.descriptionStorage">
            <summary>
            Storage for Description DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.GetDescriptionValue">
            <summary>
            Gets the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.SetDescriptionValue(System.String)">
            <summary>
            Sets the value of Description
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DomainClassId">
            <summary>
            AttributedDomainElement domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DescriptionDomainPropertyId">
            <summary>
            Description domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTrackingDomainPropertyId">
            <summary>
            IsDescriptionTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.isDescriptionTrackingPropertyStorage">
            <summary>
            Storage for IsDescriptionTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CustomAttributesDomainPropertyId">
            <summary>
            CustomAttributes domain property Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.GetCustomAttributesValue">
            <summary>
            Method to supply the readonly custom attribute CustomAttributes
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.ConstructCustomAttributesDescription(Microsoft.VisualStudio.Modeling.LinkedElementCollection{Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute})">
            <summary>
            Internal helper metohd to construct the viewable custom attributes for property grid.
            </summary>
            <param name="attributes"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CalculateDescription">
            <summary>
            Calculates the value of Description
            </summary>
            <returns>The value of Description</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.Description">
            <summary>
            Gets or sets the value of Description domain property.
            Used in the UI and in the code documentation of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTracking">
            <summary>
            Gets or sets the value of IsDescriptionTracking domain property.
            If True, the Description property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CustomAttributes">
            <summary>
            Gets or sets the value of CustomAttributes domain property.
            Used to attribute the code generated from this element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.Attributes">
            <summary>
            Gets a list of Attributes.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTrackingPropertyHandler">
            <summary>
            Tracking change handler for Description
            </summary>
            <summary>
            Value handler for the AttributedDomainElement.IsDescriptionTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the AttributedDomainElement.IsDescriptionTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.IsDescriptionTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the AttributedDomainElement.IsDescriptionTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DescriptionPropertyHandler">
            <summary>
            Value handler for the AttributedDomainElement.Description domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DescriptionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the AttributedDomainElement.Description domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DescriptionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DescriptionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.DescriptionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the AttributedDomainElement.Description domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CustomAttributesPropertyHandler">
            <summary>
            Value handler for the AttributedDomainElement.CustomAttributes domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CustomAttributesPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the AttributedDomainElement.CustomAttributes domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CustomAttributesPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributedDomainElement.CustomAttributesPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the AttributedDomainElement.CustomAttributes domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.displayNameStorage">
            <summary>
            Storage for DisplayName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.GetDisplayNameValue">
            <summary>
            Gets the value of DisplayName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.SetDisplayNameValue(System.String)">
            <summary>
            Sets the value of DisplayName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.nameStorage">
            <summary>
            Storage for Name DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.GetNameValue">
            <summary>
            Gets the value of Name
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.SetNameValue(System.String)">
            <summary>
            Sets the value of Name
            </summary>
            <param name="value"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.CalculateName">
            <summary>
            Calculates the value of Name
            </summary>
            <remarks>The base implementation just returns the storage, so that Name behaves like a regular property</remarks>
            <returns>The value of Name</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DomainClassId">
            <summary>
            NamedDomainElement domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayNameDomainPropertyId">
            <summary>
            DisplayName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeywordDomainPropertyId">
            <summary>
            HelpKeyword domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.helpKeywordPropertyStorage">
            <summary>
            Storage for HelpKeyword
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTrackingDomainPropertyId">
            <summary>
            IsDisplayNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.isDisplayNameTrackingPropertyStorage">
            <summary>
            Storage for IsDisplayNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.CalculateDisplayName">
            <summary>
            Calculates the value of DisplayName
            </summary>
            <returns>The value of DisplayName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.OnNameChanged(System.String,System.String)">
            <summary>
            Called when the Name of a NamedDomainElement changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.ValidateNameAndDisplayName(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check for blank DisplayNames
            </summary>
            <param name="context"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.ProxyIsNameTracking">
            <summary>
            Virtualized version of IsNameTracking to cope with the fact that derived classes own the IsNameTracking flags
            </summary>
            <remarks>
            Override to map to real IsNameTracking property on classes where Name is a tracking property.
            </remarks>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of this element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayName">
            <summary>
            Gets or sets the value of DisplayName domain property.
            The name that will be displayed in the generated designer for this element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeyword">
            <summary>
            Gets or sets the value of HelpKeyword domain property.
            Optional keyword used to index F1 help for this element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTracking">
            <summary>
            Gets or sets the value of IsDisplayNameTracking domain property.
            If True, the DisplayName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for DisplayName
            </summary>
            <summary>
            Value handler for the NamedDomainElement.IsDisplayNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the NamedDomainElement.IsDisplayNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.IsDisplayNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the NamedDomainElement.IsDisplayNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.NamePropertyHandler">
            <summary>
            Value handler for the NamedDomainElement.Name domain property.
            </summary>
            <summary>
            Add a change handler to name to update DisplayName
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the NamedDomainElement.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the NamedDomainElement.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayNamePropertyHandler">
            <summary>
            Value handler for the NamedDomainElement.DisplayName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the NamedDomainElement.DisplayName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.DisplayNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the NamedDomainElement.DisplayName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeywordPropertyHandler">
            <summary>
            Value handler for the NamedDomainElement.HelpKeyword domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeywordPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the NamedDomainElement.HelpKeyword domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeywordPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeywordPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement.HelpKeywordPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the NamedDomainElement.HelpKeyword domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.ValidateDslLibraryBaseMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.DomainClassId">
            <summary>
            DslLibrary domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.NamespaceDomainPropertyId">
            <summary>
            Namespace domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.namespacePropertyStorage">
            <summary>
            Storage for Namespace
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifierDomainPropertyId">
            <summary>
            AccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.accessModifierPropertyStorage">
            <summary>
            Storage for AccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersionDomainPropertyId">
            <summary>
            MajorVersion domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.majorVersionPropertyStorage">
            <summary>
            Storage for MajorVersion
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersionDomainPropertyId">
            <summary>
            MinorVersion domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.minorVersionPropertyStorage">
            <summary>
            Storage for MinorVersion
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.BuildDomainPropertyId">
            <summary>
            Build domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.buildPropertyStorage">
            <summary>
            Storage for Build
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.RevisionDomainPropertyId">
            <summary>
            Revision domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.revisionPropertyStorage">
            <summary>
            Storage for Revision
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.ValidateMonikerAmbiguity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check to make sure all elements in the model will have unambiguous monikers when serialized.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeRelateDomainClass(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Merge in properties with the attendent side effects on XmlSerialization data
            </summary>
            <param name="sourceElement"></param>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeRelateExplorerBehavior(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Merge ExplorerBehavior into the DslLibrary
            </summary>
            <param name="sourceElement"></param>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeDisconnectExplorerBehavior(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Doing exact the opposite of MergeRelateExplorerBehavior;
            </summary>
            <param name="sourceElement"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeRelateConnector(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Merge in properties with the attendent side effects on XmlSerialization data
            </summary>
            <param name="sourceElement"></param>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MergeRelateBaseShape(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Merge in properties with the attendent side effects on XmlSerialization data
            </summary>
            <param name="sourceElement"></param>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AddXmlClassData(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Add XmlClassData to match the given reference type.
            </summary>
            <param name="referenceType"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Called when the Namespace of a DslLibrary changes
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Namespace">
            <summary>
            Gets or sets the value of Namespace domain property.
            Namespace of a DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifier">
            <summary>
            Gets or sets the value of AccessModifier domain property.
            Determines if the access modifier for the class generated from the DSL library
            is public or internal.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersion">
            <summary>
            Gets or sets the value of MajorVersion domain property.
            First part of the four part version number.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersion">
            <summary>
            Gets or sets the value of MinorVersion domain property.
            Second part of the four part version number.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Build">
            <summary>
            Gets or sets the value of Build domain property.
            Last part of the four part version number.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Revision">
            <summary>
            Gets or sets the value of Revision domain property.
            Third part of the four part version number.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Classes">
            <summary>
            Gets a list of Classes.
            Domain classes defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.ReferenceTypes">
            <summary>
            Gets a list of ReferenceTypes.
            Reference types defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Relationships">
            <summary>
            Gets a list of Relationships.
            Domain relationships defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Types">
            <summary>
            Gets a list of Types.
            Domain types defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.ConnectionBuilders">
            <summary>
            Gets a list of ConnectionBuilders.
            Connection builders defining the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.ExplorerBehavior">
            <summary>
            Gets or sets ExplorerBehavior.
            Explorer behavior defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Connectors">
            <summary>
            Gets a list of Connectors.
            Connectors defined by DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.DiagramElements">
            <summary>
            Gets a list of DiagramElements.
            Diagram elements defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.Shapes">
            <summary>
            Gets a list of Shapes.
            Shapes defined by the DSL library.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.XmlSerializationBehavior">
            <summary>
            Gets or sets XmlSerializationBehavior.
            Xml serialization behavior defined by the DSL library.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.NamespacePropertyHandler">
            <summary>
            Value handler for the DslLibrary.Namespace domain property.
            </summary>
            <summary>
            Handler for namespace changing
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.NamespacePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslLibrary.Namespace domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.NamespacePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.NamespacePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.NamespacePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslLibrary.Namespace domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifierPropertyHandler">
            <summary>
            Value handler for the DslLibrary.AccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslLibrary.AccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase,Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.AccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslLibrary.AccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersionPropertyHandler">
            <summary>
            Value handler for the DslLibrary.MajorVersion domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslLibrary.MajorVersion domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MajorVersionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslLibrary.MajorVersion domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersionPropertyHandler">
            <summary>
            Value handler for the DslLibrary.MinorVersion domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslLibrary.MinorVersion domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.MinorVersionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslLibrary.MinorVersion domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.BuildPropertyHandler">
            <summary>
            Value handler for the DslLibrary.Build domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.BuildPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslLibrary.Build domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.BuildPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.BuildPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.BuildPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslLibrary.Build domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.RevisionPropertyHandler">
            <summary>
            Value handler for the DslLibrary.Revision domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.RevisionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslLibrary.Revision domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.RevisionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.RevisionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibraryBase.RevisionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslLibrary.Revision domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship">
            <summary>
            DomainClass DomainRelationship
            Defines a relationship between two domain classes.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass">
            <summary>
            DomainClass DomainClass
            Defines a domain class.
            </summary>
            <summary>
            Partial class on DomainClass to implement IPathHost
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.IPathHost">
            <summary>
            Interface optionally implemented by an embedding parent of a path object to provide 
            path-related environmental data.
            </summary>
            <remarks>
            DomainPath will walk up the embedding hierarchy until it finds this or hits a DslLibrary and gives up.
            This means that it doesn't need to be implemented every place that a path is hosted, but can be in order to improve performance.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.IPathHost.ProvideNamespace(Microsoft.VisualStudio.Modeling.ElementLink)">
            <summary>
            Gives the implementor the opportunity to supply a default namespace for the DomainPath so
            it need not be specified in the concrete syntax.
            </summary>
            <remarks>
            Returning [null] indicates that the host does provide a namespace.
            String.Empty is considered an implementation specifying no namespace.
            </remarks>
            <param name="embeddingLink">
            The relationship link by which the path is connected to its direct parent.
            This parameter allows the host to distinguish between multiple child Paths
            </param>
            <returns>
            The namespace to use for the DomainPath if one is not provided in the conccrete syntax.
            </returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.IPathHost.GetPathStartingPoints">
            <summary>
            Allows the implementor to return a list of DomainClasses (including
            DomainRelationships) from which this path can start.
            </summary>
            <remarks>
            Returning [null] indicates that the host does provide an implementation.
            Returning an empty list indicates that there are no roots.
            </remarks>
            <returns>
            A list of DomainClasses from which the path can start
            </returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.namespaceStorage">
            <summary>
            Storage for Namespace DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GetNamespaceValue">
            <summary>
            Gets the value of Namespace
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.SetNamespaceValue(System.String)">
            <summary>
            Sets the value of Namespace
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.DomainClassId">
            <summary>
            DomainClass domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifierDomainPropertyId">
            <summary>
            InheritanceModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.inheritanceModifierPropertyStorage">
            <summary>
            Storage for InheritanceModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifierDomainPropertyId">
            <summary>
            AccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.accessModifierPropertyStorage">
            <summary>
            Storage for AccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.NamespaceDomainPropertyId">
            <summary>
            Namespace domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructorDomainPropertyId">
            <summary>
            HasCustomConstructor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.hasCustomConstructorPropertyStorage">
            <summary>
            Storage for HasCustomConstructor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerivedDomainPropertyId">
            <summary>
            GeneratesDoubleDerived domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.generatesDoubleDerivedPropertyStorage">
            <summary>
            Storage for GeneratesDoubleDerived
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTrackingDomainPropertyId">
            <summary>
            IsNamespaceTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.isNamespaceTrackingPropertyStorage">
            <summary>
            Storage for IsNamespaceTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GetFullName(System.Boolean)">
            <summary>
            Gets the fully qualified name for this class
            </summary>
            <param name="includeGlobal">whether or not to append 'global::' to the full name</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasMonikerKeyPropertyDefined">
            <summary>
            Return true if any of the properties in this class or a base has IsMonikerKey == true.
            Able to handle cycles in the inheritance hierarchy.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GetRelativeName(System.String,System.Boolean)">
            <summary>
            Gets the name of the domain class relative to the current namespace. If
            the current namespace is the same as this.Namespace, then we return this.Name. 
            If not, we return this.GetFullName()
            </summary>
            <param name="currentNamespace"></param>
            <param name="includeGlobal">whether or not to prepend 'global::' if a fully qualified name is returned</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsDerivedFrom(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Test if this class is derived from the given class.
            </summary>
            <param name="candidateBase"></param>
            <returns>Whether this class is the same as or derived from the given base class</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.CollectDescendents``1(System.Collections.Generic.List{``0},``0)">
            <summary>
            Internal helper method to collect the descendent classes of the current class.
            </summary>
            <param name="descendants">Collection for holding all the descendents from the startingClass</param>
            <param name="startingClass">indicates where the start traverse clas is</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GetBaseClassSafely(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Get the base class unless its the same as the originator. Designer to allow base hierarchy traversal without infinite loop breaks.
            </summary>
            <param name="originatingClass"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.MergeRelateDomainProperty(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Merge in properties with the attendent side effects on XmlSerialization data
            </summary>
            <param name="sourceElement"></param>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configure a newly merged DomainClass
            </summary>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AddExposeProperty(System.String,System.String,System.String)">
            <summary>
            Add a custom storage domain property to expose some internal property of a shape
            </summary>
            <param name="newPropName">The name of the new property</param>
            <param name="typeNamespace">The namespace of the type that the new property should have</param>
            <param name="typeName">The name of the type that the new property should have</param>
            <remarks>
            This method should only be used for reference types that are in the rhs swimlane
            (i.e. diagram elements and diagram), but there is no single base class for these.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.CalculateNamespace">
            <summary>
            Calculates the value of Namespace
            </summary>
            <returns>The value of Namespace</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.CalculateDescription">
            <summary>
            Calculate the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.OnInheritanceModifierChanged(Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier,Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier)">
            <summary>
            Called when InheritanceModifier on a DomainClass changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Called when the Namespace of a DomainClass changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.OnNameChanged(System.String,System.String)">
            <summary>
            Called when a DomainClass' Name changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ReservedClassNames">
            <summary>
            The generated code includes classes with these names, so DSL authors mustn't use them.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ReservedXmlNames">
            <summary>
            These names are used in CDS as XML names, and bust serialization if used
            as XML names in user data. 
            Also, the corresponding names XXXMoniker are disallowed as MonikerNames.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ValidateReservedNameClash(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check for clashes with reserved names
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsReservedMonikerName(System.String)">
            <summary>
            Check whether a moniker name is on the reserved list.
            </summary>
            <param name="monikerName">may be null</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ValidateDomainClassOnLoad(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Load checks.
            Check that base class is of a compatible type.
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ValidateBaseClass(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check that the base class isn't sealed and has compatible access.
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ValidateElementName(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            No more than one property per class may be marked IsElementName.
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GetElementDataName(Microsoft.VisualStudio.Modeling.DslDefinition.XmlElementData)">
            <summary>
            Get a non-xml name to identify the XmlElementData.
            </summary>
            <param name="element">DomainProperty != null or DomainRelationship.Source.PropertyName != null</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsMappedInHierarchy">
            <summary>
            Safely traverses the inheritance hierarchy to find any PEL mappings, avoiding 
            cycle traps whether or not these include the start point. Note this may be called from
            validation and tracking properties.
            </summary>
            <returns>true if the DomainClass has or inherits any PEL mappings</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsMapped">
            <summary>
            Answer whether this DomainClass is locally mapped to a shape. 
            Does not detect inherited mappings.
            </summary>
            <returns>true if mapped</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifier">
            <summary>
            Gets or sets the value of InheritanceModifier domain property.
            Determines if the inheritance modifier of the .Net class generated from the
            domain class is none, abstract or sealed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifier">
            <summary>
            Gets or sets the value of AccessModifier domain property.
            Determines if the access modifier for the domain class is public or internal.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.Namespace">
            <summary>
            Gets or sets the value of Namespace domain property.
            Namespace affiliated with this domain class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructor">
            <summary>
            Gets or sets the value of HasCustomConstructor domain property.
            If True, indicates that a custom constructor will be provided in code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerived">
            <summary>
            Gets or sets the value of GeneratesDoubleDerived domain property.
            If True, will generate both a base class with all functionality and a partial
            class to support customization through overrides.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTracking">
            <summary>
            Gets or sets the value of IsNamespaceTracking domain property.
            If True, the Namespace property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the reference type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.Properties">
            <summary>
            Gets a list of Properties.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ElementMergeDirectives">
            <summary>
            Gets a list of ElementMergeDirectives.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.CustomTypeDescriptor">
            <summary>
            Gets or sets CustomTypeDescriptor.
            Definition of the custom type descriptor for the class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base class of this domain class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.SubClasses">
            <summary>
            Gets a list of SubClasses.
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.ClassHasBaseClass.BaseClass
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.RolesPlayed">
            <summary>
            Gets a list of RolesPlayed.
            Roles played by the class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.ClassData">
            <summary>
            Gets or sets ClassData.
            Xml serialization configuration data for the domain class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AllDescendants">
            <summary>
            Gets a read-only list of all domain classes directly or indirectly derived form this one.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AllProperties">
            <summary>
            The set of all DomainProperties both defined on this class and inherited from base classes
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AllRolesPlayed">
            <summary>
            The set of all DomainRoles both played directly by this class and inherited from base classes
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTrackingPropertyHandler">
            <summary>
            Tracking change handler for Namespace
            </summary>
            <summary>
            Value handler for the DomainClass.IsNamespaceTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainClass.IsNamespaceTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.IsNamespaceTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainClass.IsNamespaceTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifierPropertyHandler">
            <summary>
            Value handler for the DomainClass.InheritanceModifier domain property.
            </summary>
            <summary>
            InheritanceModifier changed handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainClass.InheritanceModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.InheritanceModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainClass.InheritanceModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifierPropertyHandler">
            <summary>
            Value handler for the DomainClass.AccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainClass.AccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.AccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainClass.AccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.NamespacePropertyHandler">
            <summary>
            Value handler for the DomainClass.Namespace domain property.
            </summary>
            <summary>
            Handler for namespace changing
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.NamespacePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainClass.Namespace domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.NamespacePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.NamespacePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.NamespacePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainClass.Namespace domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructorPropertyHandler">
            <summary>
            Value handler for the DomainClass.HasCustomConstructor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainClass.HasCustomConstructor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.HasCustomConstructorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainClass.HasCustomConstructor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerivedPropertyHandler">
            <summary>
            Value handler for the DomainClass.GeneratesDoubleDerived domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerivedPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainClass.GeneratesDoubleDerived domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerivedPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerivedPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass.GeneratesDoubleDerivedPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainClass.GeneratesDoubleDerived domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.ValidateDomainRelationshipMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.CalculateName">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.DomainClassId">
            <summary>
            DomainRelationship domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicatesDomainPropertyId">
            <summary>
            AllowsDuplicates domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.allowsDuplicatesPropertyStorage">
            <summary>
            Storage for AllowsDuplicates
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbeddingDomainPropertyId">
            <summary>
            IsEmbedding domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.isEmbeddingPropertyStorage">
            <summary>
            Storage for IsEmbedding
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTrackingDomainPropertyId">
            <summary>
            IsNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.isNameTrackingPropertyStorage">
            <summary>
            Storage for IsNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.FindRoleByName(System.String)">
            <summary>
            Find one of the roles of this relationship given its Name
            </summary>
            <param name="roleName"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.FindRoleByPropertyName(System.String)">
            <summary>
            Find one of the roles of this relationship given its PropertyName
            </summary>
            <param name="propertyName"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.FindByName(Microsoft.VisualStudio.Modeling.Partition,System.String)">
            <summary>
            Find a named relationship in the given partition
            </summary>
            <param name="partition"></param>
            <param name="relFullName"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.OnDeleting">
            <summary>
            OnDeleting override to remove the automatically created ElementMergeDirective and ConnectionBuilder
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configure this relationship if it has been merged into the model
            </summary>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.CalculateNameForDomainRelationship">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.OnNameChanged(System.String,System.String)">
            <summary>
            Handler for change of Name of DomainRelationship
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Handler for change of Namespace of DomainRelationship
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.OnInheritanceModifierChanged(Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier,Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier)">
            <summary>
            Handler for InheritanceModifier changed on a DomainRelationship
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.ValidateDomainRelationship(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Additional to the validations inherited from DomainClass.
            </summary>
            <param name="context">context object for logging errors/warnings/informationals</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyUseFullForm(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            If this relationship or its ancestors has a property, the source role of this relationship should be UseFullForm.
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyBaseRelationships(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            3420 - roleplayers of a base relationship are compatible 
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyRoles(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            private method to verify roles belong to the DomainRelationship
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyDerivedRoleCompatibility(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Discourage the linking of instances of derived class via links of an inappropriately general type. 
            	1. Both roles in the derived relationship should have different role player types from the concrete base
            	2. Assuming (1) is true, then the property names should be the same (only one collection is being modelled)
            In essence the desire is to only support one form of derived relationship where the base relationship is concrete.
            This is for the specific case of constraining the relationship for a derived role player type to reference another
            specific derived role player type. For example in the DSL Designer we have ClassHasBaseClass, a concrete relationship,
            with the derived relationship DiagramHasBaseDiagram. Where one diagram class is derived from another, the link type
            should be DiagramHasBaseDiagram and never ClassHasBaseClass. Similarly for the other derivation of ClassHasBaseClass.
            There is, however, only one such relationship between a "class" and its "base class", so there should only be one
            property on the role players for the opposite role player.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyAbstractDomainRelWithMultiplicityOneMustHaveOneConcreteChild(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship)">
            <summary>
            Verify case where an abstract relationship with a minimum multiplicity of 1 must have at least one concrete derived relationship
            </summary>
            <param name="context"></param>
            <param name="rel"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyDerivedRoleMultiplicityOne(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Collections.ObjectModel.ReadOnlyCollection{Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole})">
            <summary>
            Verify B, C, D condition above.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.ReportInvalidUpperBoundOnDerivedRelationshp(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Method to report the violation listed above (see table above).
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyAbstractBaseAndSingleDerivation(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            helper method to validate Abstract base + single derived relationship
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.FindRolesInDescendentRelationshipPlayedBySameDomainClass(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            For the given base role, this method will find all the descendent roles (via descendent DomainRelationship)
            whose role player is the same as baseRole.RolePlayer
            </summary>
            <param name="baseRole"></param>
            <param name="derivedRole"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyLinkConnectDirective(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            private method to verify against the LinkConnectDirective. If the rel is refereed by any LinkConnectDirective, it can't be abstract
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyIsEmbeddingFlag(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check IsEmbedding conforms to base; check multiplicity and target type.
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.VerifyAllowDuplicatesFlag(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            private method to verify against the AllowDuplicates flag. We have constraint when the flag is true
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsMapped">
            <summary>
            Answer whether this relationship is locally mapped to a connector. 
            Does not detect inherited mappings.
            </summary>
            <returns>true if mapped</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.ProxyIsNameTracking">
            <summary>
            Supply a storage-backed implementation of IsNameTracking
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicates">
            <summary>
            Gets or sets the value of AllowsDuplicates domain property.
            If True, permits duplicate links of this domain relationship to be created
            between the same two elements.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbedding">
            <summary>
            Gets or sets the value of IsEmbedding domain property.
            Indicates whether the relationship is an embedding or reference relationship.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTracking">
            <summary>
            Gets or sets the value of IsNameTracking domain property.
            If True, the Name property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.Roles">
            <summary>
            Gets a list of Roles.
            Roles of the relationship. There should be exactly two.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.Target">
            <summary>
            Gets or sets Target.
            Target role of the relationship.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.Source">
            <summary>
            Gets or sets Source.
            Source role of the relationship.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.BaseClass">
            <summary>
            Gets or sets BaseClass.
            The base relationship of this domain relationship.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.XmlRelationshipData">
            <summary>
            Gets or sets XmlRelationshipData.
            Xml serialization configuration data for the domain relationship.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllDescendantRelationships">
            <summary>
            Gets a read-only list of all domain relationships directly or indirectly derived form this one.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for Name
            </summary>
            <summary>
            Value handler for the DomainRelationship.IsNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRelationship.IsNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRelationship.IsNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicatesPropertyHandler">
            <summary>
            Value handler for the DomainRelationship.AllowsDuplicates domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicatesPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRelationship.AllowsDuplicates domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicatesPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicatesPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.AllowsDuplicatesPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRelationship.AllowsDuplicates domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbeddingPropertyHandler">
            <summary>
            Value handler for the DomainRelationship.IsEmbedding domain property.
            </summary>
            <summary>
            Handle IsEmbedding change
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbeddingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRelationship.IsEmbedding domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbeddingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbeddingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship.IsEmbeddingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRelationship.IsEmbedding domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole">
            <summary>
            DomainClass DomainRole
            Defines a role of a domain relationship. A relationship has exactly two roles.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.ValidateDomainRoleMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.propertyNameStorage">
            <summary>
            Storage for PropertyName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.GetPropertyNameValue">
            <summary>
            Gets the value of PropertyName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.SetPropertyNameValue(System.String)">
            <summary>
            Sets the value of PropertyName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.multiplicityStorage">
            <summary>
            Storage for Multiplicity DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.GetMultiplicityValue">
            <summary>
            Gets the value of Multiplicity
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.SetMultiplicityValue(Microsoft.VisualStudio.Modeling.DslDefinition.Multiplicity)">
            <summary>
            Sets the value of Multiplicity
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.propagatesDeleteStorage">
            <summary>
            Storage for PropagatesDelete DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.GetPropagatesDeleteValue">
            <summary>
            Gets the value of PropagatesDelete
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.SetPropagatesDeleteValue(System.Boolean)">
            <summary>
            Sets the value of PropagatesDelete
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.propagatesCopyStorage">
            <summary>
            Storage for PropagatesCopy DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.GetPropagatesCopyValue">
            <summary>
            Gets the value of PropagatesCopy
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.SetPropagatesCopyValue(System.Boolean)">
            <summary>
            Sets the value of PropagatesCopy
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.propertyDisplayNameStorage">
            <summary>
            Storage for PropertyDisplayName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.GetPropertyDisplayNameValue">
            <summary>
            Gets the value of PropertyDisplayName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.SetPropertyDisplayNameValue(System.String)">
            <summary>
            Sets the value of PropertyDisplayName
            </summary>
            <param name="value"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculateName">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.DomainClassId">
            <summary>
            DomainRole domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyNameDomainPropertyId">
            <summary>
            PropertyName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTrackingDomainPropertyId">
            <summary>
            IsPropertyNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropertyNameTrackingPropertyStorage">
            <summary>
            Storage for IsPropertyNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.MultiplicityDomainPropertyId">
            <summary>
            Multiplicity domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDeleteDomainPropertyId">
            <summary>
            PropagatesDelete domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGeneratorDomainPropertyId">
            <summary>
            IsPropertyGenerator domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropertyGeneratorPropertyStorage">
            <summary>
            Storage for IsPropertyGenerator
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopyDomainPropertyId">
            <summary>
            PropagatesCopy domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CategoryDomainPropertyId">
            <summary>
            Category domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.categoryPropertyStorage">
            <summary>
            Storage for Category
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifierDomainPropertyId">
            <summary>
            PropertyGetterAccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.propertyGetterAccessModifierPropertyStorage">
            <summary>
            Storage for PropertyGetterAccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifierDomainPropertyId">
            <summary>
            PropertySetterAccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.propertySetterAccessModifierPropertyStorage">
            <summary>
            Storage for PropertySetterAccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsableDomainPropertyId">
            <summary>
            IsPropertyBrowsable domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropertyBrowsablePropertyStorage">
            <summary>
            Storage for IsPropertyBrowsable
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnlyDomainPropertyId">
            <summary>
            IsPropertyUIReadOnly domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropertyUIReadOnlyPropertyStorage">
            <summary>
            Storage for IsPropertyUIReadOnly
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTrackingDomainPropertyId">
            <summary>
            IsNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isNameTrackingPropertyStorage">
            <summary>
            Storage for IsNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTrackingDomainPropertyId">
            <summary>
            IsMultiplicityTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isMultiplicityTrackingPropertyStorage">
            <summary>
            Storage for IsMultiplicityTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTrackingDomainPropertyId">
            <summary>
            IsPropagatesDeleteTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropagatesDeleteTrackingPropertyStorage">
            <summary>
            Storage for IsPropagatesDeleteTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTrackingDomainPropertyId">
            <summary>
            IsPropagatesCopyTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropagatesCopyTrackingPropertyStorage">
            <summary>
            Storage for IsPropagatesCopyTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayNameDomainPropertyId">
            <summary>
            PropertyDisplayName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTrackingDomainPropertyId">
            <summary>
            IsPropertyDisplayNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.isPropertyDisplayNameTrackingPropertyStorage">
            <summary>
            Storage for IsPropertyDisplayNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculatePropertyName">
            <summary>
            Calculates the value of PropertyName
            </summary>
            <returns>The value of PropertyName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculateMultiplicity">
            <summary>
            Calculates the value of Multiplicity
            </summary>
            <returns>The value of Multiplicity</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculatePropagatesDelete">
            <summary>
            Calculates the value of PropagatesDelete
            </summary>
            <returns>The value of PropagatesDelete</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculatePropagatesCopy">
            <summary>
            Calculates the value of PropagatesCopy
            </summary>
            <returns>The value of PropagatesCopy</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculatePropertyDisplayName">
            <summary>
            Calculates the value of PropertyDisplayName
            </summary>
            <returns>The value of PropertyDisplayName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculateDescription">
            <summary>
            Calculate the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CalculateNameForDomainRole">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.OnNameChanged(System.String,System.String)">
            <summary>
            Handler for change of Name of DomainRole
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.ValidateName(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check the Role Name and Property Name are valid.
            </summary>
            <param name="context"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.ProxyIsNameTracking">
            <summary>
            Supply a storage-backed implementation of IsNameTracking
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyName">
            <summary>
            Gets or sets the value of PropertyName domain property.
            Name of the generated property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTracking">
            <summary>
            Gets or sets the value of IsPropertyNameTracking domain property.
            If True, the PropertyName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.Multiplicity">
            <summary>
            Gets or sets the value of Multiplicity domain property.
            Constrains the number of links for which an element may play this role. If
            multiplicity is 0..* or 1..*, the generated property represents a collection.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDelete">
            <summary>
            Gets or sets the value of PropagatesDelete domain property.
            If True, an element playing this role in a link is deleted when the link is
            deleted.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGenerator">
            <summary>
            Gets or sets the value of IsPropertyGenerator domain property.
            If True, a property on the role player of this role is generated.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopy">
            <summary>
            Gets or sets the value of PropagatesCopy domain property.
            If True, an element playing this role in a link is copied when the link is
            copied.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.Category">
            <summary>
            Gets or sets the value of Category domain property.
            Category under which the generated property appears in the properties window.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifier">
            <summary>
            Gets or sets the value of PropertyGetterAccessModifier domain property.
            Determines the access modifier for the getter of the generated property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifier">
            <summary>
            Gets or sets the value of PropertySetterAccessModifier domain property.
            Determines the access modifier for the setter of the generated property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsable">
            <summary>
            Gets or sets the value of IsPropertyBrowsable domain property.
            If True, the generated property is marked as browsable in its corresponding
            property descriptor. As a result, it can be browsed through the properties
            window.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnly">
            <summary>
            Gets or sets the value of IsPropertyUIReadOnly domain property.
            If True, the generated property can not be edited through the UI when browsed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTracking">
            <summary>
            Gets or sets the value of IsNameTracking domain property.
            If True, the Name property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTracking">
            <summary>
            Gets or sets the value of IsMultiplicityTracking domain property.
            If True, the Multiplicity property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTracking">
            <summary>
            Gets or sets the value of IsPropagatesDeleteTracking domain property.
            If True, the PropagatesDelete property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTracking">
            <summary>
            Gets or sets the value of IsPropagatesCopyTracking domain property.
            If True, the PropagatesCopy property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayName">
            <summary>
            Gets or sets the value of PropertyDisplayName domain property.
            The name that will be displayed in the generated designer for the generated
            property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTracking">
            <summary>
            Gets or sets the value of IsPropertyDisplayNameTracking domain property.
            If True, the PropertyDisplayName property tracks other data in the DSL
            definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.Relationship">
            <summary>
            Gets or sets Relationship.
            Relationship defining the role.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.RolePlayer">
            <summary>
            Gets or sets RolePlayer.
            Class of element playing this role in the relationship.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CollectionType">
            <summary>
            Gets or sets CollectionType.
            External type used as the collection type for the generated property from this
            role.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.Opposite">
            <summary>
            The opposite role
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.BaseRole">
            <summary>
            Gets the base role for this role
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMany">
            <summary>
            Returns true if the multiplicity of this role is ZeroMany or OneMany.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsEmbedding">
            <summary>
            Checks if this role is the source role, and the relationship is an embedding relationship
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsEmbedded">
            <summary>
            Checks if this role is the target role, and the relationship is an embedding relationship
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsSource">
            <summary>
            Checks if this role is the source role
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for PropertyName
            </summary>
            <summary>
            Value handler for the DomainRole.IsPropertyNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropertyNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropertyNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTrackingPropertyHandler">
            <summary>
            Tracking change handler for Multiplicity
            </summary>
            <summary>
            Value handler for the DomainRole.IsMultiplicityTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsMultiplicityTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsMultiplicityTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsMultiplicityTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTrackingPropertyHandler">
            <summary>
            Tracking change handler for PropagatesDelete
            </summary>
            <summary>
            Value handler for the DomainRole.IsPropagatesDeleteTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropagatesDeleteTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesDeleteTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropagatesDeleteTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTrackingPropertyHandler">
            <summary>
            Tracking change handler for PropagatesCopy
            </summary>
            <summary>
            Value handler for the DomainRole.IsPropagatesCopyTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropagatesCopyTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropagatesCopyTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropagatesCopyTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for PropertyDisplayName
            </summary>
            <summary>
            Value handler for the DomainRole.IsPropertyDisplayNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropertyDisplayNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyDisplayNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropertyDisplayNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for Name
            </summary>
            <summary>
            Value handler for the DomainRole.IsNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyNamePropertyHandler">
            <summary>
            Value handler for the DomainRole.PropertyName domain property.
            </summary>
            <summary>
            
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.PropertyName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.PropertyName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.MultiplicityPropertyHandler">
            <summary>
            Value handler for the DomainRole.Multiplicity domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.MultiplicityPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.Multiplicity domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.MultiplicityPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.MultiplicityPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.Multiplicity)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.MultiplicityPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.Multiplicity domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDeletePropertyHandler">
            <summary>
            Value handler for the DomainRole.PropagatesDelete domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDeletePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.PropagatesDelete domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDeletePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDeletePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesDeletePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.PropagatesDelete domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGeneratorPropertyHandler">
            <summary>
            Value handler for the DomainRole.IsPropertyGenerator domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGeneratorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropertyGenerator domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGeneratorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGeneratorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyGeneratorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropertyGenerator domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopyPropertyHandler">
            <summary>
            Value handler for the DomainRole.PropagatesCopy domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.PropagatesCopy domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopyPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropagatesCopyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.PropagatesCopy domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CategoryPropertyHandler">
            <summary>
            Value handler for the DomainRole.Category domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CategoryPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.Category domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CategoryPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CategoryPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.CategoryPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.Category domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifierPropertyHandler">
            <summary>
            Value handler for the DomainRole.PropertyGetterAccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.PropertyGetterAccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyGetterAccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.PropertyGetterAccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifierPropertyHandler">
            <summary>
            Value handler for the DomainRole.PropertySetterAccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.PropertySetterAccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertySetterAccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.PropertySetterAccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsablePropertyHandler">
            <summary>
            Value handler for the DomainRole.IsPropertyBrowsable domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsablePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropertyBrowsable domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsablePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsablePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyBrowsablePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropertyBrowsable domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnlyPropertyHandler">
            <summary>
            Value handler for the DomainRole.IsPropertyUIReadOnly domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnlyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.IsPropertyUIReadOnly domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnlyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnlyPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.IsPropertyUIReadOnlyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.IsPropertyUIReadOnly domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayNamePropertyHandler">
            <summary>
            Value handler for the DomainRole.PropertyDisplayName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainRole.PropertyDisplayName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole.PropertyDisplayNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainRole.PropertyDisplayName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective">
            <summary>
            DomainClass LinkConnectDirective
            Defines how links of a specific relationship get created by a connection
            builder.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.ValidateLinkConnectDirectiveMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.DomainClassId">
            <summary>
            LinkConnectDirective domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnectDomainPropertyId">
            <summary>
            UsesCustomConnect domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.usesCustomConnectPropertyStorage">
            <summary>
            Storage for UsesCustomConnect
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnect">
            <summary>
            Gets or sets the value of UsesCustomConnect domain property.
            If True, the connection logic is defined by custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.ConnectionBuilder">
            <summary>
            Gets or sets ConnectionBuilder.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.TargetDirectives">
            <summary>
            Gets a list of TargetDirectives.
            Role directives specifying how a an element is connected to the target of a
            link.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.SourceDirectives">
            <summary>
            Gets a list of SourceDirectives.
            Role directives specifying how a an element is connected to the source of a
            link.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.DomainRelationship">
            <summary>
            Gets or sets DomainRelationship.
            Relationship for which the directive specifies link creation.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnectPropertyHandler">
            <summary>
            Value handler for the LinkConnectDirective.UsesCustomConnect domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnectPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the LinkConnectDirective.UsesCustomConnect domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnectPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnectPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.LinkConnectDirective.UsesCustomConnectPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the LinkConnectDirective.UsesCustomConnect domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective">
            <summary>
            DomainClass RolePlayerConnectDirective
            Directive for connecting a role player to a link. Part of a link connect
            directive.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.ValidateRolePlayerConnectDirectiveMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.DomainClassId">
            <summary>
            RolePlayerConnectDirective domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAcceptDomainPropertyId">
            <summary>
            UsesRoleSpecificCustomAccept domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.usesRoleSpecificCustomAcceptPropertyStorage">
            <summary>
            Storage for UsesRoleSpecificCustomAccept
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnectDomainPropertyId">
            <summary>
            UsesRoleSpecificCustomConnect domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.usesRoleSpecificCustomConnectPropertyStorage">
            <summary>
            Storage for UsesRoleSpecificCustomConnect
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAccept">
            <summary>
            Gets or sets the value of UsesRoleSpecificCustomAccept domain property.
            If True, acceptance for connection is defined in custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnect">
            <summary>
            Gets or sets the value of UsesRoleSpecificCustomConnect domain property.
            If True, connection is performed by custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.PathToRolePlayer">
            <summary>
            Gets or sets PathToRolePlayer.
            Path to the role player being connected.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.TargetOf">
            <summary>
            Gets or sets TargetOf.
            Link connect directive this is a target directive of.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.SourceOf">
            <summary>
            Gets or sets SourceOf.
            Link connect directive this is a source directive of.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.AcceptingClass">
            <summary>
            Gets or sets AcceptingClass.
            Role players of this class are accepted for connection.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAcceptPropertyHandler">
            <summary>
            Value handler for the RolePlayerConnectDirective.UsesRoleSpecificCustomAccept domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAcceptPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the RolePlayerConnectDirective.UsesRoleSpecificCustomAccept domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAcceptPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAcceptPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomAcceptPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the RolePlayerConnectDirective.UsesRoleSpecificCustomAccept domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnectPropertyHandler">
            <summary>
            Value handler for the RolePlayerConnectDirective.UsesRoleSpecificCustomConnect domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnectPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the RolePlayerConnectDirective.UsesRoleSpecificCustomConnect domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnectPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnectPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.RolePlayerConnectDirective.UsesRoleSpecificCustomConnectPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the RolePlayerConnectDirective.UsesRoleSpecificCustomConnect domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective">
            <summary>
            DomainClass ElementMergeDirective
            Defines the behavior for merging elements of a designated index class into an
            existing element structure.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.ValidateElementMergeDirectiveMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.DomainClassId">
            <summary>
            ElementMergeDirective domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAcceptDomainPropertyId">
            <summary>
            UsesCustomAccept domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.usesCustomAcceptPropertyStorage">
            <summary>
            Storage for UsesCustomAccept
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMergeDomainPropertyId">
            <summary>
            UsesCustomMerge domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.usesCustomMergePropertyStorage">
            <summary>
            Storage for UsesCustomMerge
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclassesDomainPropertyId">
            <summary>
            AppliesToSubclasses domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.appliesToSubclassesPropertyStorage">
            <summary>
            Storage for AppliesToSubclasses
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAccept">
            <summary>
            Gets or sets the value of UsesCustomAccept domain property.
            If True, custom code defines whether or not an element of the indexing class can
            be accepted for merge.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMerge">
            <summary>
            Gets or sets the value of UsesCustomMerge domain property.
            If True, custom code defines how an element of the indexing class is merged.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclasses">
            <summary>
            Gets or sets the value of AppliesToSubclasses domain property.
            If False, the merge directive governs merging of elements of the indexing class
            only, not its subclasses.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.ForwardingPath">
            <summary>
            Gets or sets ForwardingPath.
            Path to element to which merge request is forwarded.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.LinkCreationPaths">
            <summary>
            Gets a list of LinkCreationPaths.
            Link creation paths defined by the merge directive.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.DirectiveOf">
            <summary>
            Gets or sets DirectiveOf.
            Class for which this is a merge directive.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.Index">
            <summary>
            Gets or sets Index.
            Class of element whose merging behavior the directive defines.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAcceptPropertyHandler">
            <summary>
            Value handler for the ElementMergeDirective.UsesCustomAccept domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAcceptPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ElementMergeDirective.UsesCustomAccept domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAcceptPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAcceptPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomAcceptPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ElementMergeDirective.UsesCustomAccept domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMergePropertyHandler">
            <summary>
            Value handler for the ElementMergeDirective.UsesCustomMerge domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMergePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ElementMergeDirective.UsesCustomMerge domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMergePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMergePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.UsesCustomMergePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ElementMergeDirective.UsesCustomMerge domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclassesPropertyHandler">
            <summary>
            Value handler for the ElementMergeDirective.AppliesToSubclasses domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclassesPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ElementMergeDirective.AppliesToSubclasses domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclassesPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclassesPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementMergeDirective.AppliesToSubclassesPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ElementMergeDirective.AppliesToSubclasses domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment">
            <summary>
            DomainClass PathSegment
            Segment of a domain path.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.ValidatePathSegmentMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.DomainClassId">
            <summary>
            PathSegment domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.InterpretationDomainPropertyId">
            <summary>
            Interpretation domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.interpretationPropertyStorage">
            <summary>
            Storage for Interpretation
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.PathSegmentInterpretation)">
            <summary>
            Construct a segment with a specified role an interpretation
            </summary>
            <param name="store"></param>
            <param name="role"></param>
            <param name="interpretation"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.PathSegmentInterpretation)">
            <summary>
            Construct a segment with a specified role an interpretation
            </summary>
            <param name="partition"></param>
            <param name="role"></param>
            <param name="interpretation"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.Interpretation">
            <summary>
            Gets or sets the value of Interpretation domain property.
            If Elements, the segment navigates to elements playing the designated role for
            the given links; if Links, the segment navigates to the links in which the given
            elements play the designated role.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.Path">
            <summary>
            Gets or sets Path.
            Path defining the segment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.Role">
            <summary>
            Gets or sets Role.
            Role referenced by the segment.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.InterpretationPropertyHandler">
            <summary>
            Value handler for the PathSegment.Interpretation domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.InterpretationPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the PathSegment.Interpretation domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.InterpretationPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.InterpretationPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment,Microsoft.VisualStudio.Modeling.DslDefinition.PathSegmentInterpretation)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PathSegment.InterpretationPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the PathSegment.Interpretation domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Editor">
            <summary>
            DomainClass Editor
            Definition of an editor, which may be a designer or custom editor.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.ValidateEditorMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.DomainClassId">
            <summary>
            Editor domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtensionDomainPropertyId">
            <summary>
            FileExtension domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.fileExtensionPropertyStorage">
            <summary>
            Storage for FileExtension
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.IconDomainPropertyId">
            <summary>
            Icon domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.iconPropertyStorage">
            <summary>
            Storage for Icon
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuidDomainPropertyId">
            <summary>
            EditorGuid domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.editorGuidPropertyStorage">
            <summary>
            Storage for EditorGuid
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configure an editor after it has been merged in to a Dsl.
            </summary>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.ValidateEditorSerializationBehaviorOnLoad(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Validate DslEditor - may not be required after V1
            </summary>
            <param name="context"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtension">
            <summary>
            Gets or sets the value of FileExtension domain property.
            File extension registered for the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.Icon">
            <summary>
            Gets or sets the value of Icon domain property.
            Icon associated with the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuid">
            <summary>
            Gets or sets the value of EditorGuid domain property.
            Guid for the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.Dsl">
            <summary>
            Gets or sets Dsl.
            Dsl defining the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.Validation">
            <summary>
            Gets or sets Validation.
            Validation behavior defined by the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.XmlSerializationDefinition">
            <summary>
            Gets or sets XmlSerializationDefinition.
            Xml serialization behavior wrapper defined by the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.ToolboxTabs">
            <summary>
            Gets a list of ToolboxTabs.
            Toolbox tabs defined by the editor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.RootClass">
            <summary>
            Gets or sets RootClass.
            Root class defining the element represented by the top node of the explorer and
            at the root of the xml document persisting a model.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtensionPropertyHandler">
            <summary>
            Value handler for the Editor.FileExtension domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtensionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Editor.FileExtension domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtensionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Editor)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtensionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Editor,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.FileExtensionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Editor.FileExtension domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.IconPropertyHandler">
            <summary>
            Value handler for the Editor.Icon domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.IconPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Editor.Icon domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.IconPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Editor)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.IconPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Editor,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.IconPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Editor.Icon domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuidPropertyHandler">
            <summary>
            Value handler for the Editor.EditorGuid domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuidPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Editor.EditorGuid domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuidPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Editor)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuidPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Editor,System.Guid)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EditorGuidPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Editor.EditorGuid domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EmbedCheck.VerifyCorrectEmbedding(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Postcondition: singleEmbeddings.ContainsKey(domainClass). 
            If domainClass is the target, directly or by inheritance, of any embedding role with a multiplicity of
            one, then singleEmbeddings[domainClass] == that role; otherwise, null.
            </summary>
            <param name="context"></param>
            <param name="domainClass"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Editor.EmbedCheck.IsInheritedRole(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            True iff baseRole.Relationship is a transitive base relationship of subRole.Relationship
            </summary>
            <param name="subRole"></param>
            <param name="baseRole"></param>
            <returns></returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool">
            <summary>
            DomainClass ElementTool
            Defines a tool for creating elements.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool">
            <summary>
            DomainClass Tool
            Description for Microsoft.VisualStudio.Modeling.DslDefinition.Tool
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.captionStorage">
            <summary>
            Storage for Caption DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.GetCaptionValue">
            <summary>
            Gets the value of Caption
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.SetCaptionValue(System.String)">
            <summary>
            Sets the value of Caption
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.tooltipStorage">
            <summary>
            Storage for Tooltip DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.GetTooltipValue">
            <summary>
            Gets the value of Tooltip
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.SetTooltipValue(System.String)">
            <summary>
            Sets the value of Tooltip
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.helpKeywordStorage">
            <summary>
            Storage for HelpKeyword DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.GetHelpKeywordValue">
            <summary>
            Gets the value of HelpKeyword
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.SetHelpKeywordValue(System.String)">
            <summary>
            Sets the value of HelpKeyword
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.DomainClassId">
            <summary>
            Tool domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIconDomainPropertyId">
            <summary>
            ToolboxIcon domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.toolboxIconPropertyStorage">
            <summary>
            Storage for ToolboxIcon
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CaptionDomainPropertyId">
            <summary>
            Caption domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.TooltipDomainPropertyId">
            <summary>
            Tooltip domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeywordDomainPropertyId">
            <summary>
            HelpKeyword domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTrackingDomainPropertyId">
            <summary>
            IsCaptionTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.isCaptionTrackingPropertyStorage">
            <summary>
            Storage for IsCaptionTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTrackingDomainPropertyId">
            <summary>
            IsTooltipTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.isTooltipTrackingPropertyStorage">
            <summary>
            Storage for IsTooltipTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTrackingDomainPropertyId">
            <summary>
            IsHelpKeywordTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.isHelpKeywordTrackingPropertyStorage">
            <summary>
            Storage for IsHelpKeywordTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CalculateCaption">
            <summary>
            Calculates the value of Caption
            </summary>
            <returns>The value of Caption</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CalculateTooltip">
            <summary>
            Calculates the value of Tooltip
            </summary>
            <returns>The value of Tooltip</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CalculateHelpKeyword">
            <summary>
            Calculates the value of HelpKeyword
            </summary>
            <returns>The value of HelpKeyword</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the tool, used for reference.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIcon">
            <summary>
            Gets or sets the value of ToolboxIcon domain property.
            Relative file path of icon displayed in the toolbox for this tool.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.Caption">
            <summary>
            Gets or sets the value of Caption domain property.
            Caption for the tool as displayed in the UI.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.Tooltip">
            <summary>
            Gets or sets the value of Tooltip domain property.
            Text used for the tooltip.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeyword">
            <summary>
            Gets or sets the value of HelpKeyword domain property.
            Optional keyword used to index F1 help for the tool.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTracking">
            <summary>
            Gets or sets the value of IsCaptionTracking domain property.
            If True, the Caption property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTracking">
            <summary>
            Gets or sets the value of IsTooltipTracking domain property.
            If True, the Tooltip property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTracking">
            <summary>
            Gets or sets the value of IsHelpKeywordTracking domain property.
            If True, the HelpKeyword property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxTab">
            <summary>
            Gets or sets ToolboxTab.
            Toolbox tab defining the tool.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTrackingPropertyHandler">
            <summary>
            Tracking change handler for Caption
            </summary>
            <summary>
            Value handler for the Tool.IsCaptionTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.IsCaptionTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsCaptionTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.IsCaptionTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTrackingPropertyHandler">
            <summary>
            Tracking change handler for Tooltip
            </summary>
            <summary>
            Value handler for the Tool.IsTooltipTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.IsTooltipTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsTooltipTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.IsTooltipTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTrackingPropertyHandler">
            <summary>
            Tracking change handler for HelpKeyword
            </summary>
            <summary>
            Value handler for the Tool.IsHelpKeywordTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.IsHelpKeywordTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.IsHelpKeywordTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.IsHelpKeywordTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.NamePropertyHandler">
            <summary>
            Value handler for the Tool.Name domain property.
            </summary>
            <summary>
            Handler for Name changes
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIconPropertyHandler">
            <summary>
            Value handler for the Tool.ToolboxIcon domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIconPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.ToolboxIcon domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIconPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIconPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.ToolboxIconPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.ToolboxIcon domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CaptionPropertyHandler">
            <summary>
            Value handler for the Tool.Caption domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CaptionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.Caption domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CaptionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CaptionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.CaptionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.Caption domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.TooltipPropertyHandler">
            <summary>
            Value handler for the Tool.Tooltip domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.TooltipPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.Tooltip domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.TooltipPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.TooltipPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.TooltipPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.Tooltip domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeywordPropertyHandler">
            <summary>
            Value handler for the Tool.HelpKeyword domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeywordPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Tool.HelpKeyword domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeywordPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeywordPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Tool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Tool.HelpKeywordPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Tool.HelpKeyword domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.ValidateElementToolMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.DomainClassId">
            <summary>
            ElementTool domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIconDomainPropertyId">
            <summary>
            CursorIcon domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.cursorIconPropertyStorage">
            <summary>
            Storage for CursorIcon
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIcon">
            <summary>
            Gets or sets the value of CursorIcon domain property.
            Icon used for the tool's cursor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.Class">
            <summary>
            Gets or sets Class.
            Class of element the tool creates.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIconPropertyHandler">
            <summary>
            Value handler for the ElementTool.CursorIcon domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIconPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ElementTool.CursorIcon domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIconPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIconPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ElementTool.CursorIconPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ElementTool.CursorIcon domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool">
            <summary>
            DomainClass ConnectionTool
            Defines a tool on the toolbox for making a connection.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ValidateConnectionToolMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.DomainClassId">
            <summary>
            ConnectionTool domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirectionDomainPropertyId">
            <summary>
            ReversesDirection domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.reversesDirectionPropertyStorage">
            <summary>
            Storage for ReversesDirection
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIconDomainPropertyId">
            <summary>
            SourceCursorIcon domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.sourceCursorIconPropertyStorage">
            <summary>
            Storage for SourceCursorIcon
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIconDomainPropertyId">
            <summary>
            TargetCursorIcon domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.targetCursorIconPropertyStorage">
            <summary>
            Storage for TargetCursorIcon
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirection">
            <summary>
            Gets or sets the value of ReversesDirection domain property.
            If True, the first element selected is treated as the target of the connection
            and the second element as the source.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIcon">
            <summary>
            Gets or sets the value of SourceCursorIcon domain property.
            Icon used for the cursor of the tool before the first element is selected.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIcon">
            <summary>
            Gets or sets the value of TargetCursorIcon domain property.
            Icon used for the cursor of the tool after the first element is selected.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ConnectionBuilder">
            <summary>
            Gets or sets ConnectionBuilder.
            Connection builder which the tool uses to make a connection.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirectionPropertyHandler">
            <summary>
            Value handler for the ConnectionTool.ReversesDirection domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirectionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectionTool.ReversesDirection domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirectionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirectionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.ReversesDirectionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectionTool.ReversesDirection domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIconPropertyHandler">
            <summary>
            Value handler for the ConnectionTool.SourceCursorIcon domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIconPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectionTool.SourceCursorIcon domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIconPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIconPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.SourceCursorIconPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectionTool.SourceCursorIcon domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIconPropertyHandler">
            <summary>
            Value handler for the ConnectionTool.TargetCursorIcon domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIconPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectionTool.TargetCursorIcon domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIconPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIconPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionTool.TargetCursorIconPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectionTool.TargetCursorIcon domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl">
            <summary>
            DomainClass Dsl
            Definition of a Domain Specific Language, which is also a DslLibrary.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary">
            <summary>
            DomainClass DslLibrary
            Defines a library of components of a DSL definition.
            </summary>
            <summary>
            Partial class on DslLibrary to implement IPathHost
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.GetFullName(System.Boolean)">
            <summary>
            Gets the full name of this DslLibrary
            </summary>
            <param name="includeGlobal">Whether or not to prepend 'global::' to the full name</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.ConstructFullName(System.String,System.String,System.Boolean)">
            <summary>
            Internal helper method to construct full name from namespace + name.
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.GetRelativeName(System.String,System.Boolean)">
            <summary>
            Gets the name of the DslLibrary relative to the current namespace. If
            the current namespace is the same as this.Namespace, then we return this.Name. 
            If not, we return this.GetFullName()
            </summary>
            <param name="currentNamespace"></param>
            <param name="includeGlobal">whether or not to prepend 'global::' if a fully qualfied name is returned</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.FindDomainEnumeration(System.String)">
            <summary>
            For the given full name, this method returns the found DomianEnumeration.
            </summary>
            <returns>null if we can't find the domain enum</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.EnsureTypeExists(System.String,System.String)">
            <summary>
            Ensure that the given type is in the model by creating it if it isn't.
            </summary>
            <param name="typeNamespace"></param>
            <param name="typeName"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.CalculateDescription">
            <summary>
            Calculate the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Called when the Namespace of a DslLibrary changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.OnNameChanged(System.String,System.String)">
            <summary>
            Called when a DslLibrary's Name changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary.MergeDomainRelationship">
            <summary>
            Flag that a DomainRelationship is about to be merged and request that extra data for it is provided
            </summary>
            <remarks>
            If this event is not handled or the data in the event args is not provided then the merge will fail.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ValidateDslMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.packageNamespaceStorage">
            <summary>
            Storage for PackageNamespace DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.GetPackageNamespaceValue">
            <summary>
            Gets the value of PackageNamespace
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.SetPackageNamespaceValue(System.String)">
            <summary>
            Sets the value of PackageNamespace
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.DomainClassId">
            <summary>
            Dsl domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductNameDomainPropertyId">
            <summary>
            ProductName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.productNamePropertyStorage">
            <summary>
            Storage for ProductName
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyNameDomainPropertyId">
            <summary>
            CompanyName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.companyNamePropertyStorage">
            <summary>
            Storage for CompanyName
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuidDomainPropertyId">
            <summary>
            PackageGuid domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.packageGuidPropertyStorage">
            <summary>
            Storage for PackageGuid
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespaceDomainPropertyId">
            <summary>
            PackageNamespace domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTrackingDomainPropertyId">
            <summary>
            IsPackageNamespaceTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.isPackageNamespaceTrackingPropertyStorage">
            <summary>
            Storage for IsPackageNamespaceTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CalculatePackageNamespace">
            <summary>
            Calculates the value of PackageNamespace
            </summary>
            <returns>The value of PackageNamespace</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.OnNameChanged(System.String,System.String)">
            <summary>
            Handler for Name changes on a Dsl
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Handler for Namespace change on a Dsl
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductName">
            <summary>
            Gets or sets the value of ProductName domain property.
            The name of the product that will be registered for the Visual Studio package
            generated for this DSL.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyName">
            <summary>
            Gets or sets the value of CompanyName domain property.
            Name of the company for which the designer generated will be registered in
            Visual Studio.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuid">
            <summary>
            Gets or sets the value of PackageGuid domain property.
            The guid for the Visual Studio package generated for this DSL.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespace">
            <summary>
            Gets or sets the value of PackageNamespace domain property.
            The namespace for the Visual Studio package generated for this DSL.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTracking">
            <summary>
            Gets or sets the value of IsPackageNamespaceTracking domain property.
            If True, the PackageNamespace property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.Editor">
            <summary>
            Gets or sets Editor.
            Editor defined by the DSL.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.Explorer">
            <summary>
            Gets or sets Explorer.
            Explorer defined by the DSL.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.Diagram">
            <summary>
            Gets or sets Diagram.
            Diagram defined by the DSL.
            </summary>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.MergeDiagramElementMap">
            <summary>
            Flag that a DiagramElementMap is about to be merged and request that extra data for it is provided
            </summary>
            <remarks>
            If this event is not handled or the data in the event args is not provided then the merge will fail.
            </remarks>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ExplorerTitleMenuName">
            <summary>
            Returns the text used in both the Model Explorer and menu (ie Menu View->"Other Windows"->ExplorerTitleMenuName)
            It constructs the title based on the Explorer.Title + "Explorer"
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTrackingPropertyHandler">
            <summary>
            Tracking change handler for PackageNamespace
            </summary>
            <summary>
            Value handler for the Dsl.IsPackageNamespaceTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Dsl.IsPackageNamespaceTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.IsPackageNamespaceTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Dsl.IsPackageNamespaceTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductNamePropertyHandler">
            <summary>
            Value handler for the Dsl.ProductName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Dsl.ProductName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.ProductNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Dsl.ProductName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyNamePropertyHandler">
            <summary>
            Value handler for the Dsl.CompanyName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Dsl.CompanyName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.CompanyNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Dsl.CompanyName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuidPropertyHandler">
            <summary>
            Value handler for the Dsl.PackageGuid domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuidPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Dsl.PackageGuid domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuidPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuidPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl,System.Guid)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageGuidPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Dsl.PackageGuid domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespacePropertyHandler">
            <summary>
            Value handler for the Dsl.PackageNamespace domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespacePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Dsl.PackageNamespace domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespacePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespacePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Dsl,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Dsl.PackageNamespacePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Dsl.PackageNamespace domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer">
            <summary>
            DomainClass Explorer
            Defines the explorer window associated with the editor for a DSL.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ValidateExplorerMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.titleStorage">
            <summary>
            Storage for Title DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.GetTitleValue">
            <summary>
            Gets the value of Title
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.SetTitleValue(System.String)">
            <summary>
            Sets the value of Title
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.DomainClassId">
            <summary>
            Explorer domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuidDomainPropertyId">
            <summary>
            ExplorerGuid domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.explorerGuidPropertyStorage">
            <summary>
            Storage for ExplorerGuid
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.TitleDomainPropertyId">
            <summary>
            Title domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTrackingDomainPropertyId">
            <summary>
            IsTitleTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.isTitleTrackingPropertyStorage">
            <summary>
            Storage for IsTitleTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.CalculateTitle">
            <summary>
            Calculates the value of Title
            </summary>
            <returns>The value of Title</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuid">
            <summary>
            Gets or sets the value of ExplorerGuid domain property.
            Guid for the explorer window.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.Title">
            <summary>
            Gets or sets the value of Title domain property.
            Text used in the view menu entry and window tab to identify the explorer window.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTracking">
            <summary>
            Gets or sets the value of IsTitleTracking domain property.
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTracking
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.Dsl">
            <summary>
            Gets or sets Dsl.
            Dsl defining the explorer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.Behavior">
            <summary>
            Gets or sets Behavior.
            Explorer behavior used by this explorer.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTrackingPropertyHandler">
            <summary>
            Tracking change handler for Title
            </summary>
            <summary>
            Value handler for the Explorer.IsTitleTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Explorer.IsTitleTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Explorer)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Explorer,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.IsTitleTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Explorer.IsTitleTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuidPropertyHandler">
            <summary>
            Value handler for the Explorer.ExplorerGuid domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuidPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Explorer.ExplorerGuid domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuidPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Explorer)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuidPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Explorer,System.Guid)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.ExplorerGuidPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Explorer.ExplorerGuid domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.TitlePropertyHandler">
            <summary>
            Value handler for the Explorer.Title domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.TitlePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Explorer.Title domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.TitlePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Explorer)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.TitlePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Explorer,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Explorer.TitlePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Explorer.Title domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition">
            <summary>
            DomainClass XmlSerializationDefinition
            Defines the Xml serializer used by an editor.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.ValidateXmlSerializationDefinitionMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.DomainClassId">
            <summary>
            XmlSerializationDefinition domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespaceDomainPropertyId">
            <summary>
            RootNamespace domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.rootNamespacePropertyStorage">
            <summary>
            Storage for RootNamespace
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoadDomainPropertyId">
            <summary>
            CustomPostLoad domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.customPostLoadPropertyStorage">
            <summary>
            Storage for CustomPostLoad
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValueDomainPropertyId">
            <summary>
            WriteOptionalPropertiesWithDefaultValue domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.writeOptionalPropertiesWithDefaultValuePropertyStorage">
            <summary>
            Storage for WriteOptionalPropertiesWithDefaultValue
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.ValidateXmlSerializationDefinition(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            </summary>
            <param name="context">context object for logging errors/warnings/informationals</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.ValidateXmlSerializationDefinitionOnLoad(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            </summary>
            <param name="context">context object for logging errors/warnings/informationals</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespace">
            <summary>
            Gets or sets the value of RootNamespace domain property.
            Root xml namespace.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoad">
            <summary>
            Gets or sets the value of CustomPostLoad domain property.
            If True,  custom code is provided to perform further processing post load.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValue">
            <summary>
            Gets or sets the value of WriteOptionalPropertiesWithDefaultValue domain property.
            If True, properties with default value will be be written out to the saved file.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.Editor">
            <summary>
            Gets or sets Editor.
            Editor defining the xml serialization behavior wrapper.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.Behavior">
            <summary>
            Gets or sets Behavior.
            Xml serialization behavior used by the definition.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespacePropertyHandler">
            <summary>
            Value handler for the XmlSerializationDefinition.RootNamespace domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespacePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationDefinition.RootNamespace domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespacePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespacePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.RootNamespacePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationDefinition.RootNamespace domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoadPropertyHandler">
            <summary>
            Value handler for the XmlSerializationDefinition.CustomPostLoad domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoadPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationDefinition.CustomPostLoad domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoadPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoadPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.CustomPostLoadPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationDefinition.CustomPostLoad domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValuePropertyHandler">
            <summary>
            Value handler for the XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValue domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValuePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValue domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValuePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValuePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValuePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationDefinition.WriteOptionalPropertiesWithDefaultValue domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings">
            <summary>
            DomainClass ExplorerNodeSettings
            Defines custom settings for explorer nodes representing elements of the
            designated class.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ValidateExplorerNodeSettingsMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.DomainClassId">
            <summary>
            ExplorerNodeSettings domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplayDomainPropertyId">
            <summary>
            IconToDisplay domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.iconToDisplayPropertyStorage">
            <summary>
            Storage for IconToDisplay
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClassDomainPropertyId">
            <summary>
            ShowsDomainClass domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.showsDomainClassPropertyStorage">
            <summary>
            Storage for ShowsDomainClass
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplay">
            <summary>
            Gets or sets the value of IconToDisplay domain property.
            Icon to be displayed against nodes representing elements of the designated
            class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClass">
            <summary>
            Gets or sets the value of ShowsDomainClass domain property.
            If True, the name of the domain class is shown in the explorer node label.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.PropertyDisplayed">
            <summary>
            Gets or sets PropertyDisplayed.
            Path to the property used to label for the explorer node.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ExplorerBehavior">
            <summary>
            Gets or sets ExplorerBehavior.
            Explorer behavior defining the custom explorer node settings.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.Class">
            <summary>
            Gets or sets Class.
            Class of element to which the settings apply.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplayPropertyHandler">
            <summary>
            Value handler for the ExplorerNodeSettings.IconToDisplay domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplayPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ExplorerNodeSettings.IconToDisplay domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplayPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplayPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.IconToDisplayPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ExplorerNodeSettings.IconToDisplay domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClassPropertyHandler">
            <summary>
            Value handler for the ExplorerNodeSettings.ShowsDomainClass domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClassPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ExplorerNodeSettings.ShowsDomainClass domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClassPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClassPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerNodeSettings.ShowsDomainClassPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ExplorerNodeSettings.ShowsDomainClass domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath">
            <summary>
            DomainClass PropertyPath
            Defines a path navigating to an element or elements and a property of interest
            on the element(s).
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.ValidatePropertyPathMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.DomainClassId">
            <summary>
            PropertyPath domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configures element on completion of the merge operation.
            </summary>
            <param name="elementGroup">Element group being merged.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.VerifyPropertyPath(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,System.String,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Check a property path.
            </summary>
            <param name="context">Validation context</param>
            <param name="contextDescription">Prefix string for the error message</param>
            <param name="container">Element to be selected when error is double clicked</param>
            <param name="sourceClass">Class that path should start on.</param>
            <param name="sourceDiagramElement"></param>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.PathToProperty">
            <summary>
            Gets or sets PathToProperty.
            Path to the property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyPath.Property">
            <summary>
            Gets or sets Property.
            Designated property of the element reached by the path.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram">
            <summary>
            DomainClass Diagram
            Defines a diagram, involving the definition of shape and connector maps.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ValidateDiagramMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.DomainClassId">
            <summary>
            Diagram domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColorDomainPropertyId">
            <summary>
            FillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.fillColorPropertyStorage">
            <summary>
            Storage for FillColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColorDomainPropertyId">
            <summary>
            TextColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.textColorPropertyStorage">
            <summary>
            Storage for TextColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesFillColorDomainPropertyId">
            <summary>
            ExposesFillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesTextColorDomainPropertyId">
            <summary>
            ExposesTextColor domain property Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.GetExposesFillColorValue">
            <summary>
            Calculated property calculator for ExposesFillColor
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.GetExposesTextColorValue">
            <summary>
            Calculated property calculator for ExposesTextColor
            </summary>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColor">
            <summary>
            Gets or sets the value of FillColor domain property.
            Fill color for the diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColor">
            <summary>
            Gets or sets the value of TextColor domain property.
            Color of text rendered on the diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesFillColor">
            <summary>
            Gets or sets the value of ExposesFillColor domain property.
            If True, a domain property has been added to the diagram to allow the fill color
            to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesTextColor">
            <summary>
            Gets or sets the value of ExposesTextColor domain property.
            If True, a domain property has been added to the diagram to allow the text color
            to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ShapeMaps">
            <summary>
            Gets a list of ShapeMaps.
            Shape maps defined by the diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ConnectorMaps">
            <summary>
            Gets a list of ConnectorMaps.
            Connector maps defined by the diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.Class">
            <summary>
            Gets or sets Class.
            The class of element represented by a diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.Designer">
            <summary>
            Gets or sets Designer.
            Designer referencing the diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base diagram of the diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColorPropertyHandler">
            <summary>
            Value handler for the Diagram.FillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Diagram.FillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Diagram)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Diagram,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.FillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Diagram.FillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColorPropertyHandler">
            <summary>
            Value handler for the Diagram.TextColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Diagram.TextColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Diagram)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Diagram,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.TextColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Diagram.TextColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesFillColorPropertyHandler">
            <summary>
            Value handler for the Diagram.ExposesFillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesFillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Diagram.ExposesFillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesFillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Diagram)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesFillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Diagram.ExposesFillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesTextColorPropertyHandler">
            <summary>
            Value handler for the Diagram.ExposesTextColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesTextColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Diagram.ExposesTextColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesTextColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Diagram)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Diagram.ExposesTextColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Diagram.ExposesTextColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap">
            <summary>
            DomainClass CompartmentMap
            Defines mapping from a compartment to a collection of elements.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.ValidateCompartmentMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DomainClassId">
            <summary>
            CompartmentMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilterDomainPropertyId">
            <summary>
            UsesCustomFilter domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.usesCustomFilterPropertyStorage">
            <summary>
            Storage for UsesCustomFilter
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomStringDomainPropertyId">
            <summary>
            DisplaysCustomString domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.displaysCustomStringPropertyStorage">
            <summary>
            Storage for DisplaysCustomString
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilter">
            <summary>
            Gets or sets the value of UsesCustomFilter domain property.
            If True, the  for each element in the compartment is defined by custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomString">
            <summary>
            Gets or sets the value of DisplaysCustomString domain property.
            If True, the string displayed for each element in the compartment is defined by
            custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.ElementsDisplayed">
            <summary>
            Gets or sets ElementsDisplayed.
            Path identifying the collection of elements displayed in the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.PropertyDisplayed">
            <summary>
            Gets or sets PropertyDisplayed.
            Property path identifying the property to be displayed for each element in the
            compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.ShapeMap">
            <summary>
            Gets or sets ShapeMap.
            Shape map defining the compartment map.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.Compartment">
            <summary>
            Gets or sets Compartment.
            Compartment referenced by the compartment map.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilterPropertyHandler">
            <summary>
            Value handler for the CompartmentMap.UsesCustomFilter domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilterPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the CompartmentMap.UsesCustomFilter domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilterPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilterPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.UsesCustomFilterPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the CompartmentMap.UsesCustomFilter domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomStringPropertyHandler">
            <summary>
            Value handler for the CompartmentMap.DisplaysCustomString domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomStringPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the CompartmentMap.DisplaysCustomString domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomStringPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomStringPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentMap.DisplaysCustomStringPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the CompartmentMap.DisplaysCustomString domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap">
            <summary>
            DomainClass DecoratorMap
            Defines a mapping between a decorator and a domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.ValidateDecoratorMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.DomainClassId">
            <summary>
            DecoratorMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.PropertyDisplayed">
            <summary>
            Gets or sets PropertyDisplayed.
            Path identifying property to be displayed by decorator.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.VisibilityPropertyPath">
            <summary>
            Gets or sets VisibilityPropertyPath.
            Path identifying property used to decide whether or not the decorator is
            visible.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.DiagramElementMap">
            <summary>
            Gets or sets DiagramElementMap.
            Diagram element map to which the decorator map belongs.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DecoratorMap.Decorator">
            <summary>
            Gets or sets Decorator.
            Decorator referenced by map.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Designer">
            <summary>
            DomainClass Designer
            Defines an editor with a graphical design surface.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Designer.ValidateDesignerMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Designer.DomainClassId">
            <summary>
            Designer domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Designer.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Designer.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Designer.Diagram">
            <summary>
            Gets or sets Diagram.
            Diagram definition used for the designer.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap">
            <summary>
            DomainClass CompartmentShapeMap
            Defines a mapping between a compartment shape and a domain class.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap">
            <summary>
            DomainClass BaseShapeMap
            Base class for all shape maps.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMap">
            <summary>
            DomainClass DiagramElementMap
            Abstract base class for the definition of mappings between diagram elements and
            domain classes or relationships.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMap.DomainClassId">
            <summary>
            DiagramElementMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMap.DecoratorMaps">
            <summary>
            Gets a list of DecoratorMaps.
            Decorator maps defined by the diagram element map.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.ValidateBaseShapeMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.DomainClassId">
            <summary>
            BaseShapeMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElementDomainPropertyId">
            <summary>
            HasCustomParentElement domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.hasCustomParentElementPropertyStorage">
            <summary>
            Storage for HasCustomParentElement
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShapeDomainPropertyId">
            <summary>
            HasCustomParentShape domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.hasCustomParentShapePropertyStorage">
            <summary>
            Storage for HasCustomParentShape
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configure a BaseShapeMap that is merged with no endpoints
            </summary>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.SetBaseShape(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape)">
            <summary>
            Set the value of BaseShape
            </summary>
            <param name="shape"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.VerifyParent(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check the Parent Element Path, which we know is non-empty and a valid path to something.
            </summary>
            <param name="context"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.VerifyParentShapeIsCompatible(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Collections.Generic.List{Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMapCache.ShapeMapInfo})">
            <summary>
            Check that each possible parent shape is compatible with this shape.
            Checks each subclass of parent, but doesn't check where there are 
            multiple shape maps on one domain class, or where there is anything custom.
            </summary>
            <param name="context"></param>
            <param name="targetRole"></param>
            <param name="possibleMaps"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.VerifyParentHasShapeMap(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Collections.Generic.List{Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMapCache.ShapeMapInfo})">
            <summary>
            Check that any parent instance will be mapped to a shape. 
            That is, check that all concrete subclasses in the tree rooted at the 
            parent element class have or inherit a shape map.
            </summary>
            <param name="context"></param>
            <param name="parentElementClass"></param>
            <param name="possibleMaps">List of all mapped classes in this subtree.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElement">
            <summary>
            Gets or sets the value of HasCustomParentElement domain property.
            Indicates that the parent element will be identified through custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShape">
            <summary>
            Gets or sets the value of HasCustomParentShape domain property.
            Indicates that the parent shape will be identified through custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.ParentElementPath">
            <summary>
            Gets or sets ParentElementPath.
            Path to the subject of the shape, swimlane or diagram that parents the mapped
            shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.Diagram">
            <summary>
            Gets or sets Diagram.
            Diagram defining the shape map.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.DecoratorMaps">
            <summary>
            Gets a list of DecoratorMaps.
            Decorator maps defined by the shape map.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.Class">
            <summary>
            Gets or sets Class.
            Class being mapped.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.BaseShape">
            <summary>
            Gets or sets BaseShape.
            Base shape referenced by the map.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElementPropertyHandler">
            <summary>
            Value handler for the BaseShapeMap.HasCustomParentElement domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElementPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the BaseShapeMap.HasCustomParentElement domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElementPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElementPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentElementPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the BaseShapeMap.HasCustomParentElement domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShapePropertyHandler">
            <summary>
            Value handler for the BaseShapeMap.HasCustomParentShape domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShapePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the BaseShapeMap.HasCustomParentShape domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShapePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShapePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap.HasCustomParentShapePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the BaseShapeMap.HasCustomParentShape domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.ValidateCompartmentShapeMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.DomainClassId">
            <summary>
            CompartmentShapeMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.SetBaseShape(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape)">
            <summary>
            Set the value of BaseShape using the appropriate concrete type
            </summary>
            <param name="shape"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.CompartmentMaps">
            <summary>
            Gets a list of CompartmentMaps.
            Compartment maps defined by the compartment shape map.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeMap.CompartmentShape">
            <summary>
            Gets or sets CompartmentShape.
            Compartment shape being mapped.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap">
            <summary>
            DomainClass ShapeMap
            Defines a mapping between a shape and domain class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap.ValidateShapeMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap.DomainClassId">
            <summary>
            ShapeMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap.SetBaseShape(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape)">
            <summary>
            Set the value of BaseShape using the appropriate concrete type
            </summary>
            <param name="shape"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ShapeMap.Shape">
            <summary>
            Gets or sets Shape.
            Shape being mapped.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap">
            <summary>
            DomainClass ConnectorMap
            Defines a mapping between a connector and a domain relationship.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ValidateConnectorMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.DomainClassId">
            <summary>
            ConnectorMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSourceDomainPropertyId">
            <summary>
            ConnectsCustomSource domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.connectsCustomSourcePropertyStorage">
            <summary>
            Storage for ConnectsCustomSource
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTargetDomainPropertyId">
            <summary>
            ConnectsCustomTarget domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.connectsCustomTargetPropertyStorage">
            <summary>
            Storage for ConnectsCustomTarget
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configure a ConnectorMap that is merged with no endpoints
            </summary>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.HasOrInheritsShapeMap(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,Microsoft.VisualStudio.Modeling.DslDefinition.Diagram)">
            <summary>
            Check that this class has or inherits a ShapeMap in the given diagram.
            </summary>
            <param name="domainClass">May be null</param>
            <param name="diagram"></param>
            <returns>True if a ShapeMap was found.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConcreteSubClassWithoutShapeMap(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,Microsoft.VisualStudio.Modeling.DslDefinition.Diagram,System.Int32)">
            <summary>
            Check that every concrete subclass of a given root has a ShapeMap in this diagram.
            Returns null if OK; otherwise, returns an example of a concrete subclass (or root itself) without a ShapeMap.
            </summary>
            <param name="root">root class to check</param>
            <param name="diagram">The diagram that the ShapeMaps should belong to</param>
            <param name="loopProtect">Recursion count in case of loop in BaseClass graph</param>
            <returns>null if OK; otherwise, a concrete class without a shape map</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSource">
            <summary>
            Gets or sets the value of ConnectsCustomSource domain property.
            If True, the element presented by the shape at the source of the connector is
            identified through custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTarget">
            <summary>
            Gets or sets the value of ConnectsCustomTarget domain property.
            If True, the element presented by the shape at the target of the connector is
            identified through custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.Diagram">
            <summary>
            Gets or sets Diagram.
            Diagram defining the connector map.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.DecoratorMaps">
            <summary>
            Gets a list of DecoratorMaps.
            Decorator maps defined by the connector map.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.Connector">
            <summary>
            Gets or sets Connector.
            Connector being mapped.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.Relationship">
            <summary>
            Gets or sets Relationship.
            Relationship being mapped.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSourcePropertyHandler">
            <summary>
            Value handler for the ConnectorMap.ConnectsCustomSource domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSourcePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectorMap.ConnectsCustomSource domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSourcePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSourcePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomSourcePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectorMap.ConnectsCustomSource domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTargetPropertyHandler">
            <summary>
            Value handler for the ConnectorMap.ConnectsCustomTarget domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTargetPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectorMap.ConnectsCustomTarget domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTargetPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTargetPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorMap.ConnectsCustomTargetPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectorMap.ConnectsCustomTarget domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData">
            <summary>
            DomainClass XmlClassData
            Defines how elements of a specific domain class are serialized in xml.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ValidateXmlClassDataMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.typeNameStorage">
            <summary>
            Storage for TypeName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetTypeNameValue">
            <summary>
            Gets the value of TypeName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SetTypeNameValue(System.String)">
            <summary>
            Sets the value of TypeName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.elementNameStorage">
            <summary>
            Storage for ElementName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetElementNameValue">
            <summary>
            Gets the value of ElementName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SetElementNameValue(System.String)">
            <summary>
            Sets the value of ElementName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.serializeIdStorage">
            <summary>
            Storage for SerializeId DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetSerializeIdValue">
            <summary>
            Gets the value of SerializeId
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SetSerializeIdValue(System.Boolean)">
            <summary>
            Sets the value of SerializeId
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.monikerAttributeNameStorage">
            <summary>
            Storage for MonikerAttributeName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetMonikerAttributeNameValue">
            <summary>
            Gets the value of MonikerAttributeName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SetMonikerAttributeNameValue(System.String)">
            <summary>
            Sets the value of MonikerAttributeName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.monikerElementNameStorage">
            <summary>
            Storage for MonikerElementName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetMonikerElementNameValue">
            <summary>
            Gets the value of MonikerElementName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SetMonikerElementNameValue(System.String)">
            <summary>
            Sets the value of MonikerElementName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.monikerTypeNameStorage">
            <summary>
            Storage for MonikerTypeName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetMonikerTypeNameValue">
            <summary>
            Gets the value of MonikerTypeName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SetMonikerTypeNameValue(System.String)">
            <summary>
            Sets the value of MonikerTypeName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.DomainClassId">
            <summary>
            XmlClassData domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeNameDomainPropertyId">
            <summary>
            TypeName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementNameDomainPropertyId">
            <summary>
            ElementName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustomDomainPropertyId">
            <summary>
            IsCustom domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isCustomPropertyStorage">
            <summary>
            Storage for IsCustom
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeIdDomainPropertyId">
            <summary>
            SerializeId domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeNameDomainPropertyId">
            <summary>
            MonikerAttributeName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementNameDomainPropertyId">
            <summary>
            MonikerElementName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeNameDomainPropertyId">
            <summary>
            MonikerTypeName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTrackingDomainPropertyId">
            <summary>
            IsTypeNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isTypeNameTrackingPropertyStorage">
            <summary>
            Storage for IsTypeNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTrackingDomainPropertyId">
            <summary>
            IsElementNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isElementNameTrackingPropertyStorage">
            <summary>
            Storage for IsElementNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTrackingDomainPropertyId">
            <summary>
            IsSerializeIdTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isSerializeIdTrackingPropertyStorage">
            <summary>
            Storage for IsSerializeIdTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTrackingDomainPropertyId">
            <summary>
            IsMonikerAttributeNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isMonikerAttributeNameTrackingPropertyStorage">
            <summary>
            Storage for IsMonikerAttributeNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTrackingDomainPropertyId">
            <summary>
            IsMonikerElementNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isMonikerElementNameTrackingPropertyStorage">
            <summary>
            Storage for IsMonikerElementNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTrackingDomainPropertyId">
            <summary>
            IsMonikerTypeNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.isMonikerTypeNameTrackingPropertyStorage">
            <summary>
            Storage for IsMonikerTypeNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateTypeName">
            <summary>
            Calculates the value of TypeName
            </summary>
            <returns>The value of TypeName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateElementName">
            <summary>
            Calculates the value of ElementName
            </summary>
            <returns>The value of ElementName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateSerializeId">
            <summary>
            Calculates the value of SerializeId
            </summary>
            <returns>The value of SerializeId</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.GetSerializeIdValueSafely(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Version of SerializeId getter that avoids infinite recursion up the base class hierarchy
            </summary>
            <remarks>Make sure this code matches the templatized code for a tracking property.</remarks>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateSerializeIdSafely(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Version of SerializeId calculation that avoids infinite recursion up the base class hierarchy
            </summary>
            <param name="initialClass"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsDirectlyReferenceable(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Determines whether this class is directly referenced as the target of a domain relationship,
            shape (including connector) mapping, or is the diagram root.
            This does not take into account any inherited relationships, and should not call any 
            functions/properties that recurse up the inheritance chain
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateMonikerAttributeName">
            <summary>
            Calculates the value of MonikerAttributeName
            </summary>
            <returns>The value of MonikerAttributeName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateMonikerElementName">
            <summary>
            Calculates the value of MonikerElementName
            </summary>
            <returns>The value of MonikerElementName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.CalculateMonikerTypeName">
            <summary>
            Calculates the value of MonikerTypeName
            </summary>
            <returns>The value of MonikerTypeName</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeName">
            <summary>
            Gets or sets the value of TypeName domain property.
            Name of the xml type generated in the xsd from the designated domain class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementName">
            <summary>
            Gets or sets the value of ElementName domain property.
            Xml element name used to serialize elements of the designated domain class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustom">
            <summary>
            Gets or sets the value of IsCustom domain property.
            If True, serialization of elements of the designated domain class is defined in
            custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeId">
            <summary>
            Gets or sets the value of SerializeId domain property.
            If True, serialize the element Id.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeName">
            <summary>
            Gets or sets the value of MonikerAttributeName domain property.
            Name of attribute used in moniker elements to contain the reference. If blank,
            the name of the key property or id is used.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementName">
            <summary>
            Gets or sets the value of MonikerElementName domain property.
            Name of the xml element used for monikers to elements of the designated class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeName">
            <summary>
            Gets or sets the value of MonikerTypeName domain property.
            Name of the xsd type generated for monikers to elements of this class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTracking">
            <summary>
            Gets or sets the value of IsTypeNameTracking domain property.
            If True, the TypeName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTracking">
            <summary>
            Gets or sets the value of IsElementNameTracking domain property.
            If True, the ElementName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTracking">
            <summary>
            Gets or sets the value of IsSerializeIdTracking domain property.
            If True, the SerializeId property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTracking">
            <summary>
            Gets or sets the value of IsMonikerAttributeNameTracking domain property.
            If True, the MonikerAttributeName property tracks other data in the DSL
            definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTracking">
            <summary>
            Gets or sets the value of IsMonikerElementNameTracking domain property.
            If True, the MonikerElementName property tracks other data in the DSL
            definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTracking">
            <summary>
            Gets or sets the value of IsMonikerTypeNameTracking domain property.
            If True, the MonikerTypeName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.Behavior">
            <summary>
            Gets or sets Behavior.
            Defining xml serialization behavior.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementData">
            <summary>
            Gets a list of ElementData.
            Xml serialization configuration data for elements of the class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.DomainClass">
            <summary>
            Gets or sets DomainClass.
            Class to which the xml serialization configuration data applies.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for TypeName
            </summary>
            <summary>
            Value handler for the XmlClassData.IsTypeNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsTypeNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsTypeNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsTypeNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for ElementName
            </summary>
            <summary>
            Value handler for the XmlClassData.IsElementNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsElementNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsElementNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsElementNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTrackingPropertyHandler">
            <summary>
            Tracking change handler for SerializeId
            </summary>
            <summary>
            Value handler for the XmlClassData.IsSerializeIdTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsSerializeIdTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsSerializeIdTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsSerializeIdTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for MonikerAttributeName
            </summary>
            <summary>
            Value handler for the XmlClassData.IsMonikerAttributeNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsMonikerAttributeNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerAttributeNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsMonikerAttributeNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for MonikerElementName
            </summary>
            <summary>
            Value handler for the XmlClassData.IsMonikerElementNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsMonikerElementNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerElementNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsMonikerElementNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for MonikerTypeName
            </summary>
            <summary>
            Value handler for the XmlClassData.IsMonikerTypeNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsMonikerTypeNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsMonikerTypeNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsMonikerTypeNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeNamePropertyHandler">
            <summary>
            Value handler for the XmlClassData.TypeName domain property.
            </summary>
            <summary>
            TypeName change handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.TypeName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.TypeNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.TypeName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementNamePropertyHandler">
            <summary>
            Value handler for the XmlClassData.ElementName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.ElementName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.ElementNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.ElementName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustomPropertyHandler">
            <summary>
            Value handler for the XmlClassData.IsCustom domain property.
            </summary>
            <summary>
            IsCustom change handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustomPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.IsCustom domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustomPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustomPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.IsCustomPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.IsCustom domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeIdPropertyHandler">
            <summary>
            Value handler for the XmlClassData.SerializeId domain property.
            </summary>
            <summary>
            SerializeId change handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeIdPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.SerializeId domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeIdPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeIdPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.SerializeIdPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.SerializeId domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeNamePropertyHandler">
            <summary>
            Value handler for the XmlClassData.MonikerAttributeName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.MonikerAttributeName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerAttributeNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.MonikerAttributeName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementNamePropertyHandler">
            <summary>
            Value handler for the XmlClassData.MonikerElementName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.MonikerElementName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerElementNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.MonikerElementName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeNamePropertyHandler">
            <summary>
            Value handler for the XmlClassData.MonikerTypeName domain property.
            </summary>
            <summary>
            MonikerTypeName change handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlClassData.MonikerTypeName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlClassData.MonikerTypeNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlClassData.MonikerTypeName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData">
            <summary>
            DomainClass XmlRelationshipData
            Defines how links of a specific domain relationship are serialized in xml.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlElementData">
            <summary>
            DomainClass XmlElementData
            Abstract base class for definitions how parts of elements of a domain class are
            serialized in xml.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlElementData.DomainClassId">
            <summary>
            XmlElementData domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlElementData.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlElementData.ClassData">
            <summary>
            Gets or sets ClassData.
            Xml class data defining the element data.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlElementData.Order">
            <summary>
            Returns the index of this XmlElementData in the XmlClassData.ElementData collection
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.ValidateXmlRelationshipDataMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.useFullFormStorage">
            <summary>
            Storage for UseFullForm DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.GetUseFullFormValue">
            <summary>
            Gets the value of UseFullForm
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.SetUseFullFormValue(System.Boolean)">
            <summary>
            Sets the value of UseFullForm
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.roleElementNameStorage">
            <summary>
            Storage for RoleElementName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.GetRoleElementNameValue">
            <summary>
            Gets the value of RoleElementName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.SetRoleElementNameValue(System.String)">
            <summary>
            Sets the value of RoleElementName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.DomainClassId">
            <summary>
            XmlRelationshipData domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElementDomainPropertyId">
            <summary>
            OmitElement domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.omitElementPropertyStorage">
            <summary>
            Storage for OmitElement
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullFormDomainPropertyId">
            <summary>
            UseFullForm domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementNameDomainPropertyId">
            <summary>
            RoleElementName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerializationDomainPropertyId">
            <summary>
            HasCustomMonikerSerialization domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.hasCustomMonikerSerializationPropertyStorage">
            <summary>
            Storage for HasCustomMonikerSerialization
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTrackingDomainPropertyId">
            <summary>
            IsRoleElementNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.isRoleElementNameTrackingPropertyStorage">
            <summary>
            Storage for IsRoleElementNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTrackingDomainPropertyId">
            <summary>
            IsUseFullFormTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.isUseFullFormTrackingPropertyStorage">
            <summary>
            Storage for IsUseFullFormTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.CalculateUseFullForm">
            <summary>
            Calculates the value of UseFullForm
            </summary>
            <returns>The value of UseFullForm</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.CalculateRoleElementName">
            <summary>
            Calculates the value of RoleElementName
            </summary>
            <returns>The value of RoleElementName</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElement">
            <summary>
            Gets or sets the value of OmitElement domain property.
            If True, the xml tag corresponding to the source role is omitted from the
            schema.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullForm">
            <summary>
            Gets or sets the value of UseFullForm domain property.
            If True, links of the relationship are serialized in their full form.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementName">
            <summary>
            Gets or sets the value of RoleElementName domain property.
            Name of xml element that is derived from the source role. Defaults to the
            property name.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerialization">
            <summary>
            Gets or sets the value of HasCustomMonikerSerialization domain property.
            If true, the user can customize the way that the moniker is represented in its
            serialized form.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTracking">
            <summary>
            Gets or sets the value of IsRoleElementNameTracking domain property.
            If True, the RoleElementName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTracking">
            <summary>
            Gets or sets the value of IsUseFullFormTracking domain property.
            If True, the UseFullForm property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.DomainRelationship">
            <summary>
            Gets or sets DomainRelationship.
            Relationship to which the xml serialization configuration data applies.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTrackingPropertyHandler">
            <summary>
            Tracking change handler for UseFullForm
            </summary>
            <summary>
            Value handler for the XmlRelationshipData.IsUseFullFormTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlRelationshipData.IsUseFullFormTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsUseFullFormTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlRelationshipData.IsUseFullFormTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for RoleElementName
            </summary>
            <summary>
            Value handler for the XmlRelationshipData.IsRoleElementNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlRelationshipData.IsRoleElementNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.IsRoleElementNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlRelationshipData.IsRoleElementNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElementPropertyHandler">
            <summary>
            Value handler for the XmlRelationshipData.OmitElement domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElementPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlRelationshipData.OmitElement domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElementPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElementPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.OmitElementPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlRelationshipData.OmitElement domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullFormPropertyHandler">
            <summary>
            Value handler for the XmlRelationshipData.UseFullForm domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullFormPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlRelationshipData.UseFullForm domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullFormPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullFormPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.UseFullFormPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlRelationshipData.UseFullForm domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementNamePropertyHandler">
            <summary>
            Value handler for the XmlRelationshipData.RoleElementName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlRelationshipData.RoleElementName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.RoleElementNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlRelationshipData.RoleElementName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerializationPropertyHandler">
            <summary>
            Value handler for the XmlRelationshipData.HasCustomMonikerSerialization domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerializationPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlRelationshipData.HasCustomMonikerSerialization domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerializationPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerializationPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlRelationshipData.HasCustomMonikerSerializationPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlRelationshipData.HasCustomMonikerSerialization domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData">
            <summary>
            DomainClass XmlPropertyData
            Defines how values of a specific domain property are serialized in xml.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.ValidateXmlPropertyDataMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.xmlNameStorage">
            <summary>
            Storage for XmlName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.GetXmlNameValue">
            <summary>
            Gets the value of XmlName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.SetXmlNameValue(System.String)">
            <summary>
            Sets the value of XmlName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.representationStorage">
            <summary>
            Storage for Representation DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.GetRepresentationValue">
            <summary>
            Gets the value of Representation
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.SetRepresentationValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyRepresentation)">
            <summary>
            Sets the value of Representation
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.DomainClassId">
            <summary>
            XmlPropertyData domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlNameDomainPropertyId">
            <summary>
            XmlName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.RepresentationDomainPropertyId">
            <summary>
            Representation domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKeyDomainPropertyId">
            <summary>
            IsMonikerKey domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.isMonikerKeyPropertyStorage">
            <summary>
            Storage for IsMonikerKey
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifierDomainPropertyId">
            <summary>
            IsMonikerQualifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.isMonikerQualifierPropertyStorage">
            <summary>
            Storage for IsMonikerQualifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTrackingDomainPropertyId">
            <summary>
            IsXmlNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.isXmlNameTrackingPropertyStorage">
            <summary>
            Storage for IsXmlNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTrackingDomainPropertyId">
            <summary>
            IsRepresentationTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.isRepresentationTrackingPropertyStorage">
            <summary>
            Storage for IsRepresentationTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.CalculateXmlName">
            <summary>
            Calculates the value of XmlName
            </summary>
            <returns>The value of XmlName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.CalculateRepresentation">
            <summary>
            Calculates the value of Representation
            </summary>
            <returns>The value of Representation</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlName">
            <summary>
            Gets or sets the value of XmlName domain property.
            Name used for the xml attribute or element representing the property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.Representation">
            <summary>
            Gets or sets the value of Representation domain property.
            If Attribute, the property is serialized as an xml attribute; if Element, it is
            serialized as an element; if Ignore, it is not serialized.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKey">
            <summary>
            Gets or sets the value of IsMonikerKey domain property.
            If True, the property is used as the key for creating monikers.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifier">
            <summary>
            Gets or sets the value of IsMonikerQualifier domain property.
            If True, the property is used for creating the qualifier in monikers.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTracking">
            <summary>
            Gets or sets the value of IsXmlNameTracking domain property.
            If True, the XmlName property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTracking">
            <summary>
            Gets or sets the value of IsRepresentationTracking domain property.
            If True, the Representation property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.DomainProperty">
            <summary>
            Gets or sets DomainProperty.
            Property to which the xml serialization configuration data applies.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for XmlName
            </summary>
            <summary>
            Value handler for the XmlPropertyData.IsXmlNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlPropertyData.IsXmlNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsXmlNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlPropertyData.IsXmlNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTrackingPropertyHandler">
            <summary>
            Tracking change handler for Representation
            </summary>
            <summary>
            Value handler for the XmlPropertyData.IsRepresentationTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlPropertyData.IsRepresentationTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsRepresentationTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlPropertyData.IsRepresentationTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlNamePropertyHandler">
            <summary>
            Value handler for the XmlPropertyData.XmlName domain property.
            </summary>
            <summary>
            XmlName change handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlPropertyData.XmlName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.XmlNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlPropertyData.XmlName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.RepresentationPropertyHandler">
            <summary>
            Value handler for the XmlPropertyData.Representation domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.RepresentationPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlPropertyData.Representation domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.RepresentationPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.RepresentationPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData,Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyRepresentation)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.RepresentationPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlPropertyData.Representation domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKeyPropertyHandler">
            <summary>
            Value handler for the XmlPropertyData.IsMonikerKey domain property.
            </summary>
            <summary>
            IsMonikerKey change handler
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKeyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlPropertyData.IsMonikerKey domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKeyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKeyPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerKeyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlPropertyData.IsMonikerKey domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifierPropertyHandler">
            <summary>
            Value handler for the XmlPropertyData.IsMonikerQualifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlPropertyData.IsMonikerQualifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlPropertyData.IsMonikerQualifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlPropertyData.IsMonikerQualifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap">
            <summary>
            DomainClass SwimLaneMap
            Defines a mapping between a swimlane and a domain class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap.ValidateSwimLaneMapMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap.DomainClassId">
            <summary>
            SwimLaneMap domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap.SetBaseShape(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape)">
            <summary>
            Set the value of BaseShape using the appropriate concrete type
            </summary>
            <param name="shape"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLaneMap.SwimLane">
            <summary>
            Gets or sets SwimLane.
            Swimlane being mapped.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode">
            <summary>
            DomainClass InheritanceNode
            Node in a Dsl Designer diagram tree which references an inheritance link.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode">
            <summary>
            DomainClass ArcNode
            Abstract class for nodes used in a Dsl Designer diagram tree.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode">
            <summary>
            DomainClass TreeNode
            Abstract base class for nodes in a Dsl Designer diagram tree.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.DomainClassId">
            <summary>
            TreeNode domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpandedDomainPropertyId">
            <summary>
            IsInheritanceTreeExpanded domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.isInheritanceTreeExpandedPropertyStorage">
            <summary>
            Storage for IsInheritanceTreeExpanded
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpandedDomainPropertyId">
            <summary>
            IsRelationshipTreeExpanded domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.isRelationshipTreeExpandedPropertyStorage">
            <summary>
            Storage for IsRelationshipTreeExpanded
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpanded">
            <summary>
            Gets or sets the value of IsInheritanceTreeExpanded domain property.
            If True, the inheritance tree is expanded beneath this node.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpanded">
            <summary>
            Gets or sets the value of IsRelationshipTreeExpanded domain property.
            If True, the relationship tree is expanded beneath this node.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.Subject">
            <summary>
            The class that this node represents on the diagram
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpandedPropertyHandler">
            <summary>
            Value handler for the TreeNode.IsInheritanceTreeExpanded domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpandedPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the TreeNode.IsInheritanceTreeExpanded domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpandedPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpandedPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsInheritanceTreeExpandedPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the TreeNode.IsInheritanceTreeExpanded domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpandedPropertyHandler">
            <summary>
            Value handler for the TreeNode.IsRelationshipTreeExpanded domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpandedPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the TreeNode.IsRelationshipTreeExpanded domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpandedPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpandedPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode.IsRelationshipTreeExpandedPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the TreeNode.IsRelationshipTreeExpanded domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.DomainClassId">
            <summary>
            ArcNode domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeafDomainPropertyId">
            <summary>
            IsLeaf domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.isLeafPropertyStorage">
            <summary>
            Storage for IsLeaf
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.GetArcNodesFromSubject(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the arcs whose subject is the parameter
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.GetArcNodesFromSource(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the arcs whose source is the parameter
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.TestDescendantOfSelf(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Test to see if an arc is a descendant of itself
            </summary>
            <param name="theClass"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.OnDeleting">
            <summary>
            OnDeleting override for ArcNode to create a RootNode if this arcnode is a non-leaf node
            and it's being deleted because a class further up the tree got deleted. 
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeaf">
            <summary>
            Gets or sets the value of IsLeaf domain property.
            Description for Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeaf
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.DiagramTree">
            <summary>
            Gets or sets DiagramTree.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.ArcSource">
            <summary>
            Get the element representing the LHS of the arc
            </summary>
            <returns>The element representing the LHS of the arc</returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeafPropertyHandler">
            <summary>
            Value handler for the ArcNode.IsLeaf domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeafPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ArcNode.IsLeaf domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeafPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeafPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode.IsLeafPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ArcNode.IsLeaf domain property.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.ValidateInheritanceNodeMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.DomainClassId">
            <summary>
            InheritanceNode domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.ChooseMergeTarget(Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Gets the ModelElement to be used as the target for the ElementGroupPrototype merge 
            process.  
            This is called by the merge process when this element is the target of the merge.  
            This provides this element with the opportunity to forward the target to something 
            other than itself.
            </summary>
            <param name="elementGroupPrototype">The ElementGroupPrototype that will be reconstituted and merged with the target element.</param>
            <returns>The ModelElement to use as the target for the merge process.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.ChooseMergeTarget(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Gets the ModelElement to be used as the target for the ElementGroup merge 
            process.  
            This is called by the merge process when this element is the target of the merge.  
            This provides this element with the opportunity to forward the target to something 
            other than itself.
            </summary>
            <param name="elementGroup">The ElementGroup that will be merged with the target element.</param>
            <returns>The ModelElement to use as the target for the merge process.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.GetInheritanceNodesFromBaseClass(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the nodes whose base classes is the parameter
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.GetInheritanceNodeFromSubClass(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the single node whose subclass is the parameter
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.GetInheritanceNodeFromInheritanceLink(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.ClassHasBaseClass)">
            <summary>
            Gets the node whose link is the given parameter
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.InheritanceLink">
            <summary>
            Gets or sets InheritanceLink.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.Subject">
            <summary>
            The class that this node represents on the diagram
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceNode.ArcSource">
            <summary>
            The LHS of the arc
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode">
            <summary>
            DomainClass RootNode
            Root node in a Dsl Designer diagram tree.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.ValidateRootNodeMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.DomainClassId">
            <summary>
            RootNode domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.ChooseMergeTarget(Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Gets the ModelElement to be used as the target for the ElementGroupPrototype merge 
            process.  
            This is called by the merge process when this element is the target of the merge.  
            This provides this element with the opportunity to forward the target to something 
            other than itself.
            </summary>
            <param name="elementGroupPrototype">The ElementGroupPrototype that will be reconstituted and merged with the target element.</param>
            <returns>The ModelElement to use as the target for the merge process.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.ChooseMergeTarget(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Gets the ModelElement to be used as the target for the ElementGroup merge 
            process.  
            This is called by the merge process when this element is the target of the merge.  
            This provides this element with the opportunity to forward the target to something 
            other than itself.
            </summary>
            <param name="elementGroup">The ElementGroup that will be merged with the target element.</param>
            <returns>The ModelElement to use as the target for the merge process.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.DiagramTree">
            <summary>
            Gets or sets DiagramTree.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.Class">
            <summary>
            Gets or sets Class.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RootNode.Subject">
            <summary>
            The class that this node represents on the diagram
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode">
            <summary>
            DomainClass SourceRoleNode
            Node in a Dsl Designer diagram tree which references a source role.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.ValidateSourceRoleNodeMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.DomainClassId">
            <summary>
            SourceRoleNode domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.ChooseMergeTarget(Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Gets the ModelElement to be used as the target for the ElementGroupPrototype merge 
            process.  
            This is called by the merge process when this element is the target of the merge.  
            This provides this element with the opportunity to forward the target to something 
            other than itself.
            </summary>
            <param name="elementGroupPrototype">The ElementGroupPrototype that will be reconstituted and merged with the target element.</param>
            <returns>The ModelElement to use as the target for the merge process.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.ChooseMergeTarget(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Gets the ModelElement to be used as the target for the ElementGroup merge 
            process.  
            This is called by the merge process when this element is the target of the merge.  
            This provides this element with the opportunity to forward the target to something 
            other than itself.
            </summary>
            <param name="elementGroup">The ElementGroup that will be merged with the target element.</param>
            <returns>The ModelElement to use as the target for the merge process.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.GetRoleNodesFromSource(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the nodes whose source is the parameter
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.GetRoleNodesFromRolePlayer(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the nodes whose roleplayer is the parameter
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.GetRoleNodeFromRole(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree,Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets the node whose role is the given parameter
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.Role">
            <summary>
            Gets or sets Role.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.Subject">
            <summary>
            The class that this node represents on the diagram
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.SourceRoleNode.ArcSource">
            <summary>
            The LHS of the arc
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState">
            <summary>
            DomainClass DslDesignerDiagramState
            Defines the state of a diagram representing a DSL definition.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.ValidateDslDesignerDiagramStateMultiplicity(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Checks that the relationships that have a multiplicity of One or OneMany do actually have a link.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.DomainClassId">
            <summary>
            DslDesignerDiagramState domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.DeleteRootNode(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Remove any root node representing the given subject in either tree
            </summary>
            <param name="subject">Whether a root was found and deleted</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.GetNodesFromSubject(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Find all nodes containing a class within either tree
            </summary>
            <param name="candidate"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.GetArcNodesFromSubject(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the arcs whose subject is the parameter in either tree
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.GetRoleNodeFromRole(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRole)">
            <summary>
            Gets the SourceRoleNode for the given role in either tree
            </summary>
            <param name="role"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.GetInheritanceNodeFromSubClass(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Gets the InheritanceNode for the given subClass in either tree
            </summary>
            <param name="subClass"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.FindDefinition(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Find the definition node on the diagram for a given class
            </summary>
            <param name="subject">The class to find the definition of</param>
            <returns>The definiton node</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.RelocateDefinition(Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode)">
            <summary>
            Move the definition node to the given arc
            </summary>
            <param name="arc"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.CreateRoot(Microsoft.VisualStudio.Modeling.DslDesigner.ArcNode)">
            <summary>
            Create a root from the given arc
            </summary>
            <param name="arc"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.ReparentTreeNodesUnderClass(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Reparent
            </summary>
            <param name="newDefinition">A newly enshrined definition TreeNode</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.GetOppositeTree(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree)">
            <summary>
            Get the other tree to the one given.
            </summary>
            <param name="tree"></param>
            <returns>The opposite tree</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.EnsureTrees">
            <summary>
            Make sure that the basic tree structures are present.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.GetDefaultTreeForClass(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Get the correct default tree for a given class, ensuring that the intermediate structures are in place.
            </summary>
            <remarks>
            Don't use this except for creating brand new TreeNodes as classes can end up in either tree after user intervention.
            </remarks>
            <param name="theClass">The class to find the right tree for</param>
            <returns>The correct tree</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.DiagramTrees">
            <summary>
            Gets a list of DiagramTrees.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramState.Diagram">
            <summary>
            Gets or sets Diagram.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration">
            <summary>
            DomainClass DomainEnumeration
            Defines an enumeration.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType">
            <summary>
            DomainClass DomainType
            Abstract base class for external types and enumerations.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.namespaceStorage">
            <summary>
            Storage for Namespace DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.GetNamespaceValue">
            <summary>
            Gets the value of Namespace
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.SetNamespaceValue(System.String)">
            <summary>
            Sets the value of Namespace
            </summary>
            <param name="value"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.CalculateNamespace">
            <summary>
            Calculates the value of Namespace
            </summary>
            <remarks>The base implementation just returns the storage, so that Namespace behaves like a regular property</remarks>
            <returns>The value of Namespace</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.DomainClassId">
            <summary>
            DomainType domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamespaceDomainPropertyId">
            <summary>
            Namespace domain property Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.GetFullName(System.Boolean)">
            <summary>
            Gets the fully qualified name of this domain type
            </summary>
            <param name="includeGlobal">whether or not to prepend 'global::' to the full name</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.GetRelativeName(System.String,System.Boolean)">
            <summary>
            Gets the name of the domain type relative to the current namespace. If
            the current namespace is the same as this.Namespace, then we return this.Name. 
            If not, we return this.GetFullName()
            </summary>
            <param name="currentNamespace"></param>
            <param name="includeGlobal">whether or not to prepend 'global::' if the fully qualified name is returned</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.OnNameChanged(System.String,System.String)">
            <summary>
            Called when the Name of a type changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Called when the Namespace of a type changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.ProxyIsNamespaceTracking">
            <summary>
            Virtualized version of IsNamespaceTracking to cope with the fact that derived classes own the IsNamespaceTracking flags
            </summary>
            <remarks>
            Override to map to real IsNamespaceTracking property on classes where Namespace is a tracking property.
            </remarks>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.Namespace">
            <summary>
            Gets or sets the value of Namespace domain property.
            Namespace affiliated with this type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the domain type.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamePropertyHandler">
            <summary>
            Value handler for the DomainType.Name domain property.
            </summary>
            <summary>
            Property handler for Name of a type changing
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainType.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainType)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainType,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainType.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamespacePropertyHandler">
            <summary>
            Value handler for the DomainType.Namespace domain property.
            </summary>
            <summary>
            Property handler for Namespace of a type changing
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamespacePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainType.Namespace domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamespacePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainType)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamespacePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainType,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainType.NamespacePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainType.Namespace domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.descriptionStorage">
            <summary>
            Storage for Description DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.GetDescriptionValue">
            <summary>
            Gets the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.SetDescriptionValue(System.String)">
            <summary>
            Sets the value of Description
            </summary>
            <param name="value"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CalculateNamespace">
            <summary>
            Calculates the value of Namespace
            </summary>
            <returns>The value of Namespace</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DomainClassId">
            <summary>
            DomainEnumeration domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlagsDomainPropertyId">
            <summary>
            IsFlags domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.isFlagsPropertyStorage">
            <summary>
            Storage for IsFlags
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifierDomainPropertyId">
            <summary>
            AccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.accessModifierPropertyStorage">
            <summary>
            Storage for AccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DescriptionDomainPropertyId">
            <summary>
            Description domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTrackingDomainPropertyId">
            <summary>
            IsDescriptionTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.isDescriptionTrackingPropertyStorage">
            <summary>
            Storage for IsDescriptionTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CustomAttributesDomainPropertyId">
            <summary>
            CustomAttributes domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTrackingDomainPropertyId">
            <summary>
            IsNamespaceTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.isNamespaceTrackingPropertyStorage">
            <summary>
            Storage for IsNamespaceTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsValidEnumDefault(System.String)">
            <summary>
            For the passed in enum default string (in "Enum1" or "F1 | F2 | F3" form), this method determines whether
            the enumDefaults conforms to the literals defined in DomainEnumeration
            </summary>
            <param name="enumDefaults"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.FindLiteral(System.String)">
            <summary>
            Given the literal name, this method returns the corresponding EnumerationLiteral
            </summary>
            <param name="literal">liternal name</param>
            <returns>null if we can't find one</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.GetCustomAttributesValue">
            <summary>
            Method to supply the readonly custom attribute CustomAttributes
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.MergeRelateEnumerationLiteral(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Custom merge method for adding a new literal into the DomainEnum
            </summary>
            <param name="sourceElement"></param>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CalculateDescription">
            <summary>
            Calculates the value of Description
            </summary>
            <returns>The value of Description</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CalculateNamespaceForDomainEnumeration">
            <summary>
            Calculates the value of Namespace
            </summary>
            <returns>The value of Namespace</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.OnNameChanged(System.String,System.String)">
            <summary>
            Name of enumeration changed
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.OnNamespaceChanged(System.String,System.String)">
            <summary>
            Namespace of enumeration changed
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.ProxyIsNamespaceTracking">
            <summary>
            Supply a storage-backed implementation of IsNamespaceTracking
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlags">
            <summary>
            Gets or sets the value of IsFlags domain property.
            If True, defines a flags enumeration.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifier">
            <summary>
            Gets or sets the value of AccessModifier domain property.
            Determines if the access modifier for the domain enumeration is public or
            internal.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.Description">
            <summary>
            Gets or sets the value of Description domain property.
            Used in the UI and in the code documentation of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTracking">
            <summary>
            Gets or sets the value of IsDescriptionTracking domain property.
            If True, the Description property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CustomAttributes">
            <summary>
            Gets or sets the value of CustomAttributes domain property.
            Used to attribute the code generated from this element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTracking">
            <summary>
            Gets or sets the value of IsNamespaceTracking domain property.
            If True, the Namespace property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.Literals">
            <summary>
            Gets a list of Literals.
            Literals defined by the enumeration.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.Attributes">
            <summary>
            Gets a list of Attributes.
            Clr attributes defined for the enumeration.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTrackingPropertyHandler">
            <summary>
            Tracking change handler for Description
            </summary>
            <summary>
            Value handler for the DomainEnumeration.IsDescriptionTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainEnumeration.IsDescriptionTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsDescriptionTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainEnumeration.IsDescriptionTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTrackingPropertyHandler">
            <summary>
            Tracking change handler for Namespace
            </summary>
            <summary>
            Value handler for the DomainEnumeration.IsNamespaceTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainEnumeration.IsNamespaceTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsNamespaceTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainEnumeration.IsNamespaceTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlagsPropertyHandler">
            <summary>
            Value handler for the DomainEnumeration.IsFlags domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlagsPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainEnumeration.IsFlags domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlagsPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlagsPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.IsFlagsPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainEnumeration.IsFlags domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifierPropertyHandler">
            <summary>
            Value handler for the DomainEnumeration.AccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainEnumeration.AccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration,Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.AccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainEnumeration.AccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DescriptionPropertyHandler">
            <summary>
            Value handler for the DomainEnumeration.Description domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DescriptionPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainEnumeration.Description domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DescriptionPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DescriptionPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.DescriptionPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainEnumeration.Description domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CustomAttributesPropertyHandler">
            <summary>
            Value handler for the DomainEnumeration.CustomAttributes domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CustomAttributesPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainEnumeration.CustomAttributes domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CustomAttributesPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainEnumeration.CustomAttributesPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainEnumeration.CustomAttributes domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder">
            <summary>
            DomainClass ConnectionBuilder
            Defines a connection builder, which is used to create binary connections between
            model elements.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.nameStorage">
            <summary>
            Storage for Name DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.GetNameValue">
            <summary>
            Gets the value of Name
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.SetNameValue(System.String)">
            <summary>
            Sets the value of Name
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.DomainClassId">
            <summary>
            ConnectionBuilder domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustomDomainPropertyId">
            <summary>
            IsCustom domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.isCustomPropertyStorage">
            <summary>
            Storage for IsCustom
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTrackingDomainPropertyId">
            <summary>
            IsNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.isNameTrackingPropertyStorage">
            <summary>
            Storage for IsNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.CalculateName">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the connection builder.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustom">
            <summary>
            Gets or sets the value of IsCustom domain property.
            If True, the behavior of the connection builder is defined in custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTracking">
            <summary>
            Gets or sets the value of IsNameTracking domain property.
            If True, the Name property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.LinkConnectDirectives">
            <summary>
            Gets a list of LinkConnectDirectives.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the connection builder.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for Name
            </summary>
            <summary>
            Value handler for the ConnectionBuilder.IsNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectionBuilder.IsNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectionBuilder.IsNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.NamePropertyHandler">
            <summary>
            Value handler for the ConnectionBuilder.Name domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectionBuilder.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectionBuilder.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustomPropertyHandler">
            <summary>
            Value handler for the ConnectionBuilder.IsCustom domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustomPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ConnectionBuilder.IsCustom domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustomPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustomPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ConnectionBuilder.IsCustomPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ConnectionBuilder.IsCustom domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab">
            <summary>
            DomainClass ToolboxTab
            Defines the collection of tools that appear on a single tab in the toolbox.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.tabTextStorage">
            <summary>
            Storage for TabText DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.GetTabTextValue">
            <summary>
            Gets the value of TabText
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.SetTabTextValue(System.String)">
            <summary>
            Sets the value of TabText
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.DomainClassId">
            <summary>
            ToolboxTab domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabTextDomainPropertyId">
            <summary>
            TabText domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTrackingDomainPropertyId">
            <summary>
            IsTabTextTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.isTabTextTrackingPropertyStorage">
            <summary>
            Storage for IsTabTextTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.CalculateTabText">
            <summary>
            Calculates the value of TabText
            </summary>
            <returns>The value of TabText</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.ValidateTools(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Validate tools in this Tab. 
            We do them here rather than in their own class because some constraints depend on access to the Editor.
            </summary>
            <param name="context"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabText">
            <summary>
            Gets or sets the value of TabText domain property.
            Text used to label the tab.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTracking">
            <summary>
            Gets or sets the value of IsTabTextTracking domain property.
            If True, the TabText property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.Tools">
            <summary>
            Gets a list of Tools.
            Tools in the toolbox tab.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.Editor">
            <summary>
            Gets or sets Editor.
            The editor defining the toolbox tab.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTrackingPropertyHandler">
            <summary>
            Tracking change handler for TabText
            </summary>
            <summary>
            Value handler for the ToolboxTab.IsTabTextTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ToolboxTab.IsTabTextTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.IsTabTextTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ToolboxTab.IsTabTextTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabTextPropertyHandler">
            <summary>
            Value handler for the ToolboxTab.TabText domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabTextPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ToolboxTab.TabText domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabTextPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabTextPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ToolboxTab.TabTextPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ToolboxTab.TabText domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior">
            <summary>
            DomainClass ExplorerBehavior
            Defines custom explorer behavior for designated nodes.
            </summary>
            <summary>
            Partial class to implement IPathHost
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.nameStorage">
            <summary>
            Storage for Name DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.GetNameValue">
            <summary>
            Gets the value of Name
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.SetNameValue(System.String)">
            <summary>
            Sets the value of Name
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.DomainClassId">
            <summary>
            ExplorerBehavior domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTrackingDomainPropertyId">
            <summary>
            IsNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.isNameTrackingPropertyStorage">
            <summary>
            Storage for IsNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.CalculateName">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Identifier for referencing the explorer behavior.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTracking">
            <summary>
            Gets or sets the value of IsNameTracking domain property.
            If True, the Name property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the explorer behavior.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.HiddenNodes">
            <summary>
            Gets a list of HiddenNodes.
            Paths to elements whose explorer nodes should be hidden.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.CustomNodeSettings">
            <summary>
            Gets a list of CustomNodeSettings.
            Custom node settings defined for the explorer behavior.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for Name
            </summary>
            <summary>
            Value handler for the ExplorerBehavior.IsNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ExplorerBehavior.IsNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.IsNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ExplorerBehavior.IsNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.NamePropertyHandler">
            <summary>
            Value handler for the ExplorerBehavior.Name domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ExplorerBehavior.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ExplorerBehavior.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ExplorerBehavior.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator">
            <summary>
            DomainClass Decorator
            Defines a decorator for a shape or connector.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.displayNameStorage">
            <summary>
            Storage for DisplayName DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.GetDisplayNameValue">
            <summary>
            Gets the value of DisplayName
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.SetDisplayNameValue(System.String)">
            <summary>
            Sets the value of DisplayName
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DomainClassId">
            <summary>
            Decorator domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayNameDomainPropertyId">
            <summary>
            DisplayName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTrackingDomainPropertyId">
            <summary>
            IsDisplayNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.isDisplayNameTrackingPropertyStorage">
            <summary>
            Storage for IsDisplayNameTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.CalculateDisplayName">
            <summary>
            Calculates the value of DisplayName
            </summary>
            <returns>The value of DisplayName</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.OnNameChanged(System.String,System.String)">
            <summary>
            Called when the Name of a Decorator changes
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the decorator.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayName">
            <summary>
            Gets or sets the value of DisplayName domain property.
            The name that will be displayed in the generated designer for this decorator.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTracking">
            <summary>
            Gets or sets the value of IsDisplayNameTracking domain property.
            If True, the Name property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DiagramElement">
            <summary>
            Gets or sets DiagramElement.
            Diagram element to which the decorator belongs.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for DisplayName
            </summary>
            <summary>
            Value handler for the Decorator.IsDisplayNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Decorator.IsDisplayNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Decorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Decorator,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.IsDisplayNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Decorator.IsDisplayNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.NamePropertyHandler">
            <summary>
            Value handler for the Decorator.Name domain property.
            </summary>
            <summary>
            Add a change handler to name to update DisplayName
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Decorator.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Decorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Decorator,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Decorator.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayNamePropertyHandler">
            <summary>
            Value handler for the Decorator.DisplayName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Decorator.DisplayName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Decorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Decorator,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Decorator.DisplayNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Decorator.DisplayName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator">
            <summary>
            DomainClass TextDecorator
            Defines a decorator that displays text.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.defaultTextStorage">
            <summary>
            Storage for DefaultText DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.GetDefaultTextValue">
            <summary>
            Gets the value of DefaultText
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.SetDefaultTextValue(System.String)">
            <summary>
            Sets the value of DefaultText
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DomainClassId">
            <summary>
            TextDecorator domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultTextDomainPropertyId">
            <summary>
            DefaultText domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStyleDomainPropertyId">
            <summary>
            FontStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.fontStylePropertyStorage">
            <summary>
            Storage for FontStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSizeDomainPropertyId">
            <summary>
            FontSize domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.fontSizePropertyStorage">
            <summary>
            Storage for FontSize
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTrackingDomainPropertyId">
            <summary>
            IsDefaultTextTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.isDefaultTextTrackingPropertyStorage">
            <summary>
            Storage for IsDefaultTextTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.CalculateDefaultText">
            <summary>
            Calculates the value of DefaultText
            </summary>
            <returns>The value of DefaultText</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.OnNameChanged(System.String,System.String)">
            <summary>
            Handler for the Name of a TextDecorator changing
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultText">
            <summary>
            Gets or sets the value of DefaultText domain property.
            Default text to be displayed, when the decorator is unmapped.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStyle">
            <summary>
            Gets or sets the value of FontStyle domain property.
            Font style for the text displayed in the decorator.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSize">
            <summary>
            Gets or sets the value of FontSize domain property.
            Font size for the text displayed in the decorator.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTracking">
            <summary>
            Gets or sets the value of IsDefaultTextTracking domain property.
            If True, the DefaultText property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTrackingPropertyHandler">
            <summary>
            Tracking change handler for DefaultText
            </summary>
            <summary>
            Value handler for the TextDecorator.IsDefaultTextTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the TextDecorator.IsDefaultTextTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.IsDefaultTextTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the TextDecorator.IsDefaultTextTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultTextPropertyHandler">
            <summary>
            Value handler for the TextDecorator.DefaultText domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultTextPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the TextDecorator.DefaultText domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultTextPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultTextPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.DefaultTextPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the TextDecorator.DefaultText domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStylePropertyHandler">
            <summary>
            Value handler for the TextDecorator.FontStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the TextDecorator.FontStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator,System.Drawing.FontStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the TextDecorator.FontStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSizePropertyHandler">
            <summary>
            Value handler for the TextDecorator.FontSize domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSizePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the TextDecorator.FontSize domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSizePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSizePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.TextDecorator.FontSizePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the TextDecorator.FontSize domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement">
            <summary>
            DomainClass DiagramElement
            Abstract base class for the definition of diagram elements, including shapes and
            connectors.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.fixedTooltipTextStorage">
            <summary>
            Storage for FixedTooltipText DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.GetFixedTooltipTextValue">
            <summary>
            Gets the value of FixedTooltipText
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.SetFixedTooltipTextValue(System.String)">
            <summary>
            Sets the value of FixedTooltipText
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.DomainClassId">
            <summary>
            DiagramElement domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipTypeDomainPropertyId">
            <summary>
            TooltipType domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.tooltipTypePropertyStorage">
            <summary>
            Storage for TooltipType
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipTextDomainPropertyId">
            <summary>
            FixedTooltipText domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTrackingDomainPropertyId">
            <summary>
            IsFixedTooltipTextTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.isFixedTooltipTextTrackingPropertyStorage">
            <summary>
            Storage for IsFixedTooltipTextTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColorDomainPropertyId">
            <summary>
            TextColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.textColorPropertyStorage">
            <summary>
            Storage for TextColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.ExposesTextColorDomainPropertyId">
            <summary>
            ExposesTextColor domain property Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.GetExposesTextColorValue">
            <summary>
            Calculated property calculator for ExposesTextColor
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.CalculateFixedTooltipText">
            <summary>
            Calculates the value of FixedTooltipText
            </summary>
            <returns>The value of FixedTooltipText</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.OnNameChanged(System.String,System.String)">
            <summary>
            Name of DiagramElement changed
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipType">
            <summary>
            Gets or sets the value of TooltipType domain property.
            If Fixed, the fixed tooltip text is used as the tooltip, if variable the tooltip
            is defined in custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipText">
            <summary>
            Gets or sets the value of FixedTooltipText domain property.
            Text used for a fixed tooltip.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTracking">
            <summary>
            Gets or sets the value of IsFixedTooltipTextTracking domain property.
            If True, the FixedTooltipText property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColor">
            <summary>
            Gets or sets the value of TextColor domain property.
            Color used for text decorators associated with this diagram element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.ExposesTextColor">
            <summary>
            Gets or sets the value of ExposesTextColor domain property.
            If True, a domain property has been added to the connector to allow the text
            color to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.Decorators">
            <summary>
            Gets a list of Decorators.
            Decorators for the diagram element.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the diagram element.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTrackingPropertyHandler">
            <summary>
            Tracking change handler for FixedTooltipText
            </summary>
            <summary>
            Value handler for the DiagramElement.IsFixedTooltipTextTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DiagramElement.IsFixedTooltipTextTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.IsFixedTooltipTextTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DiagramElement.IsFixedTooltipTextTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipTypePropertyHandler">
            <summary>
            Value handler for the DiagramElement.TooltipType domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipTypePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DiagramElement.TooltipType domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipTypePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipTypePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement,Microsoft.VisualStudio.Modeling.DslDefinition.TooltipType)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TooltipTypePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DiagramElement.TooltipType domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipTextPropertyHandler">
            <summary>
            Value handler for the DiagramElement.FixedTooltipText domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipTextPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DiagramElement.FixedTooltipText domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipTextPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipTextPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.FixedTooltipTextPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DiagramElement.FixedTooltipText domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColorPropertyHandler">
            <summary>
            Value handler for the DiagramElement.TextColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DiagramElement.TextColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.TextColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DiagramElement.TextColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.ExposesTextColorPropertyHandler">
            <summary>
            Value handler for the DiagramElement.ExposesTextColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.ExposesTextColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DiagramElement.ExposesTextColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.ExposesTextColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElement.ExposesTextColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DiagramElement.ExposesTextColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior">
            <summary>
            DomainClass XmlSerializationBehavior
            Defines how elements of the domain classes included in the DSL or DSL library
            definition are serialized as xml.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.nameStorage">
            <summary>
            Storage for Name DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.GetNameValue">
            <summary>
            Gets the value of Name
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.SetNameValue(System.String)">
            <summary>
            Sets the value of Name
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.namespaceStorage">
            <summary>
            Storage for Namespace DomainProperty
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.GetNamespaceValue">
            <summary>
            Gets the value of Namespace
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.SetNamespaceValue(System.String)">
            <summary>
            Sets the value of Namespace
            </summary>
            <param name="value"></param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.DomainClassId">
            <summary>
            XmlSerializationBehavior domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTrackingDomainPropertyId">
            <summary>
            IsNameTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.isNameTrackingPropertyStorage">
            <summary>
            Storage for IsNameTracking
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamespaceDomainPropertyId">
            <summary>
            Namespace domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTrackingDomainPropertyId">
            <summary>
            IsNamespaceTracking domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.isNamespaceTrackingPropertyStorage">
            <summary>
            Storage for IsNamespaceTracking
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.CalculateName">
            <summary>
            Calculates the value of Name
            </summary>
            <returns>The value of Name</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.CalculateNamespace">
            <summary>
            Calculates the value of Namespace
            </summary>
            <returns>The value of Namespace</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.GetFullName(System.Boolean)">
            <summary>
            Gets the fully qualified name of the XmlSerializationBehavior
            </summary>
            <param name="includeGlobal">whether or not to prepend 'global::' to the full name</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.GetRelativeName(System.String,System.Boolean)">
            <summary>
            Gets the name of the xml serialization behavior relative to the current namespace. If
            the current namespace is the same as this.Namespace, then we return this.Name. 
            If not, we return this.GetFullName()
            </summary>
            <param name="currentNamespace"></param>
            <param name="includeGlobal">whether or not to prepend 'global::' if the full name is returned</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.FindClassData(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Locate the XmlClassData for the given class
            </summary>
            <param name="classToFind"></param>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name used for reference.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTracking">
            <summary>
            Gets or sets the value of IsNameTracking domain property.
            If True, the Name property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.Namespace">
            <summary>
            Gets or sets the value of Namespace domain property.
            Namespace of the classes generated from the XmlSerializationBehavior.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTracking">
            <summary>
            Gets or sets the value of IsNamespaceTracking domain property.
            If True, the Namespace property tracks other data in the DSL definition.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the xml serialization behavior.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.ClassData">
            <summary>
            Gets a list of ClassData.
            Xml serialization configuration data defined by this behavior, indexed by class.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTrackingPropertyHandler">
            <summary>
            Tracking change handler for Name
            </summary>
            <summary>
            Value handler for the XmlSerializationBehavior.IsNameTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationBehavior.IsNameTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNameTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationBehavior.IsNameTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTrackingPropertyHandler">
            <summary>
            Tracking change handler for Namespace
            </summary>
            <summary>
            Value handler for the XmlSerializationBehavior.IsNamespaceTracking domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTrackingPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationBehavior.IsNamespaceTracking domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTrackingPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTrackingPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.IsNamespaceTrackingPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationBehavior.IsNamespaceTracking domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamePropertyHandler">
            <summary>
            Value handler for the XmlSerializationBehavior.Name domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationBehavior.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationBehavior.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamespacePropertyHandler">
            <summary>
            Value handler for the XmlSerializationBehavior.Namespace domain property.
            </summary>
            <summary>
            Handle Namespace changes
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamespacePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the XmlSerializationBehavior.Namespace domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamespacePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamespacePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.NamespacePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the XmlSerializationBehavior.Namespace domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.ClassDataChecker">
            <summary>
            Helper for checking role and property names.
            Create one of these and then call it for each class in the model.
            Caches names of classes already seen.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.ClassDataChecker.CheckRoleAndPropertyNames(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Check role and property names of a class for duplication among siblings and ancestors.
            </summary>
            <param name="domainClass"></param>
            <param name="xmlNames">Use the XML property and role names.</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.XmlSerializationBehavior.ClassDataChecker.VerifyNoClash(System.Collections.Generic.Dictionary{System.String,Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement},System.String,Microsoft.VisualStudio.Modeling.DslDefinition.NamedDomainElement,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Report any duplicate names, and add this one to the dictionary.
            </summary>
            <param name="names"></param>
            <param name="name">Dictionary of names to roles or properties</param>
            <param name="element">Role or Property</param>
            <param name="ownerClass"></param>
            <param name="xmlData">The name is the XML name of the role or property</param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor">
            <summary>
            TypeDescriptor for DomainPath or PropertyPath.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.#ctor(System.ComponentModel.ICustomTypeDescriptor,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            DslDefinitionModelElementTypeDescriptor ctor. It's calling base class directly.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.GetProperties">
            <summary>
            Override base to supply property descriptors for each property in the model elemnt.
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.GetProperties(System.Attribute[])">
            <summary>
            Method to supply our own set of property descriptors for the designated ModelElement.
            </summary>
            <param name="attributes"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.CreatePropertyDescriptor(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            Create the PropertyDescriptor for a given DomainProperty
            </summary>
            <param name="requestor"></param>
            <param name="domainPropertyInfo"></param>
            <param name="attributes"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.CreateRolePlayerPropertyDescriptor(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainRoleInfo,System.Attribute[])">
            <summary>
            Method to create a PropertyDescriptor which describes a relationship and role to be displayed in the grid.
            </summary>
            <param name="sourceRolePlayer">ModelElement playing the source role.</param>
            <param name="targetRoleInfo">DomainRoleInfo describing the target role.</param>
            <param name="sourceDomainRoleInfoAttributes">Attributes on the source DomainRoleInfo</param>
            <returns>RolePlayerPropertyDescriptor</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.ShouldCreatePropertyDescriptor(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo)">
            <summary>
            Gets whether to create type descriptor for a givne property.
            </summary>
            <param name="requestor">Element.</param>
            <param name="domainProperty">Property.</param>
            <returns>True to create descriptor and false otherwise.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.CreateEditorIconPropertyDescriptor(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            If this is Editor.Icon property, we will have to provide our own prop desc. This is so that we can update the File.ico file if user changes 
            Ediro.Icon 
            </summary>
            <param name="requestor"></param>
            <param name="domainPropertyInfo"></param>
            <param name="attributes"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Design.DslDefinitionModelElementTypeDescriptor.CreateDomainEnumPropertyDescriptor(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainPropertyInfo,System.Attribute[])">
            <summary>
            If this is the DefaultValue domain property whose type is of DomainEnumeration, we will supply our own DomainEnumPropertyDescriptor.
            If not, return null so the caller can call the base.
            </summary>
            <param name="requestor"></param>
            <param name="domainPropertyInfo"></param>
            <param name="attributes"></param>
            <returns></returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase">
            <summary>
            Helper class for serializing and deserializing DslDefinitionModel models.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.ResetTrackingProperties(Microsoft.VisualStudio.Modeling.Store)">
            <summary>
            Reset IsXxxTracking properties to their natural values based on comparing storage with calculation
            </summary>
            <param name="store"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.LoadModel(Microsoft.VisualStudio.Modeling.Store,System.String,Microsoft.VisualStudio.Modeling.ISchemaResolver,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Loads a DslLibrary instance into the default partition of the given store, and ignore serialization result.
            </summary>
            <param name="store">The new DslLibrary instance will be created into the default partition of this store.</param>
            <param name="fileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="schemaResolver">
            An ISchemaResolver that allows the serializer to do schema validation on the root element (and everything inside it).
            If null is passed, schema validation will not be performed.
            </param>
            <param name="validationController">
            A ValidationController that will be used to do load-time validation (validations with validation category "Load"). If null
            is passed, load-time validation will not be performed.
            </param>
            <returns>The loaded DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.LoadModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Store,System.String,Microsoft.VisualStudio.Modeling.ISchemaResolver,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Loads a DslLibrary instance into the default partition of the given store.
            </summary>
            <param name="serializationResult">Stores serialization result from the load operation.</param>
            <param name="store">The new DslLibrary instance will be created into the default partition of this store.</param>
            <param name="fileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="schemaResolver">
            An ISchemaResolver that allows the serializer to do schema validation on the root element (and everything inside it).
            If null is passed, schema validation will not be performed.
            </param>
            <param name="validationController">
            A ValidationController that will be used to do load-time validation (validations with validation category "Load"). If null
            is passed, load-time validation will not be performed.
            </param>
            <returns>The loaded DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.LoadModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Partition,System.String,Microsoft.VisualStudio.Modeling.ISchemaResolver,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Loads a DslLibrary instance.
            </summary>
            <param name="serializationResult">Stores serialization result from the load operation.</param>
            <param name="partition">Partition in which the new DslLibrary instance will be created.</param>
            <param name="fileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="schemaResolver">
            An ISchemaResolver that allows the serializer to do schema validation on the root element (and everything inside it).
            If null is passed, schema validation will not be performed.
            </param>
            <param name="validationController">
            A ValidationController that will be used to do load-time validation (validations with validation category "Load"). If null
            is passed, load-time validation will not be performed.
            </param>
            <returns>The loaded DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String)">
            <summary>
            Saves the given model root to the given file, with default encoding (UTF-8), and optional properties with default value will not
            be written out.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="fileName">Name of the file in which the DslLibrary instance will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String,System.Boolean)">
            <summary>
            Saves the given model to the given file, with default encoding (UTF-8).
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="fileName">Name of the file in which the DslLibrary instance will be saved.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String,System.Text.Encoding,System.Boolean)">
            <summary>
            Saves the given model root to the given file, with specified encoding.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="fileName">Name of the file in which the DslLibrary instance will be saved.</param>
            <param name="encoding">Encoding to use when saving the DslLibrary instance.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.InternalSaveModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String,System.Text.Encoding,System.Boolean)">
            <summary>
            Saves the given model root as a in-memory stream.
            This is a helper used by SaveModel() and SaveModelAndDiagram(). When saving the model and the diagram together, we want to make sure that 
            both can be saved without error before writing the content to disk, so we serialize the model into a in-memory stream first.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="fileName">Name of the file in which the DslLibrary instance will be saved.</param>
            <param name="encoding">Encoding to use when saving the DslLibrary instance.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
            <returns>In-memory stream containing the serialized DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.InternalSaveDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String,System.Text.Encoding,System.Boolean)">
            <summary>
            Saves the given model root as a in-memory stream.
            This is a helper used by SaveModel() and SaveModelAndDiagram(). When saving the model and the diagram together, we want to make sure that 
            both can be saved without error before writing the content to disk, so we serialize the model into a in-memory stream first.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
            <param name="encoding">Encoding to use when saving the diagram.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
            <returns>In-memory stream containing the serialized DslDesignerDiagram instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.CreateModelHelper(Microsoft.VisualStudio.Modeling.Partition)">
            <summary>
            Helper method to create and initialize a new DslLibrary.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.LoadModelAndDiagram(Microsoft.VisualStudio.Modeling.Store,System.String,System.String,Microsoft.VisualStudio.Modeling.ISchemaResolver,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Loads a DslLibrary instance and its associated diagram file into the default partition of the given store, and ignore serialization result.
            </summary>
            <param name="store">The new DslLibrary instance will be created into the default partition of this store.</param>
            <param name="modelFileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="diagramFileName">Name of the file from which the DslDesignerDiagram instance will be deserialized.</param>
            <param name="schemaResolver">
            An ISchemaResolver that allows the serializer to do schema validation on the root element (and everything inside it).
            If null is passed, schema validation will not be performed.
            </param>
            <param name="validationController">
            A ValidationController that will be used to do load-time validation (validations with validation category "Load"). If null
            is passed, load-time validation will not be performed.
            </param>
            <returns>The loaded DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.LoadModelAndDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Store,System.String,System.String,Microsoft.VisualStudio.Modeling.ISchemaResolver,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Loads a DslLibrary instance and its associated diagram file into the default partition of the given store.
            </summary>
            <param name="serializationResult">Stores serialization result from the load operation.</param>
            <param name="store">The new DslLibrary instance will be created into the default partition of this store.</param>
            <param name="modelFileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="diagramFileName">Name of the file from which the DslDesignerDiagram instance will be deserialized.</param>
            <param name="schemaResolver">
            An ISchemaResolver that allows the serializer to do schema validation on the root element (and everything inside it).
            If null is passed, schema validation will not be performed.
            </param>
            <param name="validationController">
            A ValidationController that will be used to do load-time validation (validations with validation category "Load"). If null
            is passed, load-time validation will not be performed.
            </param>
            <returns>The loaded DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.LoadModelAndDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Partition,System.String,Microsoft.VisualStudio.Modeling.Partition,System.String,Microsoft.VisualStudio.Modeling.ISchemaResolver,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Loads a DslLibrary instance and its associated diagram file.
            </summary>
            <param name="serializationResult">Stores serialization result from the load operation.</param>
            <param name="modelPartition">Partition in which the new DslLibrary instance will be created.</param>
            <param name="modelFileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="diagramPartition">Partition in which the new DslDesignerDiagram instance will be created.</param>
            <param name="diagramFileName">Name of the file from which the DslDesignerDiagram instance will be deserialized.</param>
            <param name="schemaResolver">
            An ISchemaResolver that allows the serializer to do schema validation on the root element (and everything inside it).
            If null is passed, schema validation will not be performed.
            </param>
            <param name="validationController">
            A ValidationController that will be used to do load-time validation (validations with validation category "Load"). If null
            is passed, load-time validation will not be performed.
            </param>
            <returns>The loaded DslLibrary instance.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.CreateDiagramHelper(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Helper method to create and initialize a new DslDesignerDiagram.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveModelAndDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String)">
            <summary>
            Saves the given diagram to the given file, with default encoding (UTF-8), and optional properties with default value will not
            be written out.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="modelFileName">Name of the file in which the CanonicalSampleRoot instance will be saved.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveModelAndDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String,System.Boolean)">
            <summary>
            Saves the given diagram to the given file, with default encoding (UTF-8).
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="modelFileName">Name of the file in which the CanonicalSampleRoot instance will be saved.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveModelAndDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.String,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String,System.Text.Encoding,System.Boolean)">
            <summary>
            Saves the given DslLibrary and DslDesignerDiagram to the given files, with specified encoding.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="modelRoot">DslLibrary instance to be saved.</param>
            <param name="modelFileName">Name of the file in which the CanonicalSampleRoot instance will be saved.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
            <param name="encoding">Encoding to use when saving the diagram.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String)">
            <summary>
            Saves the given diagram to the given file, with default encoding (UTF-8), and optional properties with default value will not
            be written out.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String,System.Boolean)">
            <summary>
            Saves the given diagram to the given file, with default encoding (UTF-8).
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SaveDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram,System.String,System.Text.Encoding,System.Boolean)">
            <summary>
            Saves the given DslDesignerDiagram to the given file, with specified encoding.
            </summary>
            <param name="serializationResult">Stores serialization result from the save operation.</param>
            <param name="diagram">DslDesignerDiagram to be saved.</param>
            <param name="diagramFileName">Name of the file in which the diagram will be saved.</param>
            <param name="encoding">Encoding to use when saving the diagram.</param>
            <param name="writeOptionalPropertiesWithDefaultValue">Whether optional properties with default value will be saved.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.GetSerializedModelString(Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,System.Text.Encoding)">
            <summary>
            Return the model in XML format
            </summary>
            <param name="modelRoot">ExampleModel instance to be saved.</param>
            <param name="encoding">Encoding to use when saving the ExampleModel instance.</param>
            <returns>Model in XML form</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.directory">
            <summary>
            DomainXmlSerializerDirectory instance used by this DslDefinitionModelSerializationHelper class.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.GetMonikerResolvers(Microsoft.VisualStudio.Modeling.Store)">
            <summary>
            This method creates one SimpleMonikerResolver instance for each DomainModel used in serialization.
            </summary>
            <param name="store">Store on which moniker resolvers will be set up.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SetupMonikerResolver(Microsoft.VisualStudio.Modeling.SerializationContext,Microsoft.VisualStudio.Modeling.Store)">
            <summary>
            Ensure that moniker resolvers are installed properly on the given store, so that deserialization can be carried out correctly.
            </summary>
            <param name="serializationContext">SerializationContext of the current operations.</param>
            <param name="store">Store on which moniker resolvers will be set up.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.CheckForOrphanedShapes(Microsoft.VisualStudio.Modeling.Diagrams.Diagram,Microsoft.VisualStudio.Modeling.SerializationResult)">
            <summary>
            Go through the diagram to find all shapes that are not connected to a model element. Some of them may be by design, the rest are out-of-sync shapes.
            We want to make sure that all out-of-sync shapes are given a chance to fix themselves up, or post proper warning/error messages.
            </summary>
            <param name="diagram">The diagram of which the shapes are being checked.</param>
            <param name="serializationResult">SerializationResult to store warning/error in case an orphaned shape choose to do so.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OnPostLoadModel(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Partition,System.String,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary)">
            <summary>
            Customize Model Loading.
            </summary>
            <param name="serializationResult">Stores serialization result from the load operation.</param>
            <param name="partition">Partition in which the new DslLibrary instance will be created.</param>
            <param name="fileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="modelRoot">The root of the file that was loaded.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OnPostLoadModelAndDiagram(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Partition,System.String,Microsoft.VisualStudio.Modeling.Partition,System.String,Microsoft.VisualStudio.Modeling.DslDefinition.DslLibrary,Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram)">
            <summary>
            Customize Model and Diagram Loading.
            </summary>
            <param name="serializationResult">Stores serialization result from the load operation.</param>
            <param name="modelPartition">Partition in which the new DslLibrary instance will be created.</param>
            <param name="modelFileName">Name of the file from which the DslLibrary instance will be deserialized.</param>
            <param name="diagramPartition">Partition in which the new DslDesignerDiagram instance will be created.</param>
            <param name="diagramFileName">Name of the file from which the DslDesignerDiagram instance will be deserialized.</param>
            <param name="modelRoot">The root of the file that was loaded.</param>
            <param name="diagram">The diagram matching the modelRoot.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.Directory">
            <summary>
            DomainXmlSerializerDirectory instance used by this DslDefinitionModelSerializationHelper class.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver">
            <summary>
            An utility class to collect validation messages during serialization, and store them in serialization result.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.serializationResult">
            <summary>
            SerializationResult to store the messages.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.validationController">
            <summary>
            ValidationController to get messages from.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.#ctor(Microsoft.VisualStudio.Modeling.SerializationResult,Microsoft.VisualStudio.Modeling.Validation.ValidationController)">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.Finalize">
            <summary>
            Destructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.OnValidationMessageAdded(Microsoft.VisualStudio.Modeling.Validation.ValidationMessage)">
            <summary>
            Called with validation messages are added.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.Dispose">
            <summary>
            IDisposable.Dispose().
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.SerializationValidationObserver.Dispose(System.Boolean)">
            <summary>
            Unregister the observer on dispose.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OrphanedShapeIterator">
            <summary>
            An iterator to collect all the orphaned shapes.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OrphanedShapeIterator.orphanedShapes">
            <summary>
            Stores all iterated orphaned shapes.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OrphanedShapeIterator.diagram">
            <summary>
            Diagram that contains the shapes to be iterated.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OrphanedShapeIterator.#ctor(System.Collections.Generic.List{Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement},Microsoft.VisualStudio.Modeling.Diagrams.Diagram)">
            <summary>
            Constructor.
            </summary>
            <param name="orphanedShapes">Storage for all iterated orphaned shapes.</param>
            <param name="diagram">Diagram that contains the shapes to be iterated.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelSerializationHelperBase.OrphanedShapeIterator.OnShape(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Called when a shape is encountered during iteration. The shape will be stored if it's orphaned.
            A shape is considered "orphaned" if:
            1) It has a PresentationViewsSubject link out of it, but the Subject cannot be resolved.
            2) It is a connector, and the Subject is null (regardless of the existence of PresentationViewsSubject relationship).
            </summary>
            <param name="shape">Shape encountered.</param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink">
            <summary>
            ConnectionBuilder class to provide logic for constructing connections between elements.
            </summary>
            <summary>
            ConnectionBuilder for Inheritance
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.CanAcceptSource(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given model element is acceptable to this ConnectionBuilder as the source of a connection.
            </summary>
            <param name="candidate">The model element to test.</param>
            <returns>Whether the element can be used as the source of a connection.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.CanAcceptTarget(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given model element is acceptable to this ConnectionBuilder as the target of a connection.
            </summary>
            <param name="candidate">The model element to test.</param>
            <returns>Whether the element can be used as the target of a connection.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.CanAcceptSourceAndTarget(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given pair of model elements are acceptable to this ConnectionBuilder as the source and target of a connection
            </summary>
            <param name="candidateSource">The model element to test as a source</param>
            <param name="candidateTarget">The model element to test as a target</param>
            <returns>Whether the elements can be used as the source and target of a connection</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.Connect(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Make a connection between the given pair of source and target elements
            </summary>
            <param name="source">The model element to use as the source of the connection</param>
            <param name="target">The model element to use as the target of the connection</param>
            <returns>A link representing the created connection</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.CanAcceptTreeNodeAsSource(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Accept only nodes which don't already have base classes as source.
            </summary>
            <param name="candidate"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.CanAcceptTreeNodesAsSourceAndTarget(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode,Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Accept only targets that would not cause a loop and are of the same broad family.
            </summary>
            <param name="sourceNode"></param>
            <param name="targetNode"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateInheritanceLink.ConnectSourceToTarget(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Make the connection
            </summary>
            <param name="source"></param>
            <param name="target"></param>
            <returns></returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CreateEmbeddingRelationship">
            <summary>
            ConnectionBuilder class to provide logic for constructing connections between elements.
            </summary>
            <summary>
            ConnectionBuilder class to provide logic for constructing connections between elements.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateEmbeddingRelationship.CanAcceptSource(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given model element is acceptable to this ConnectionBuilder as the source of a connection.
            </summary>
            <param name="candidate">The model element to test.</param>
            <returns>Whether the element can be used as the source of a connection.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateEmbeddingRelationship.CanAcceptTarget(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given model element is acceptable to this ConnectionBuilder as the target of a connection.
            </summary>
            <param name="candidate">The model element to test.</param>
            <returns>Whether the element can be used as the target of a connection.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateEmbeddingRelationship.CanAcceptSourceAndTarget(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given pair of model elements are acceptable to this ConnectionBuilder as the source and target of a connection
            </summary>
            <param name="candidateSource">The model element to test as a source</param>
            <param name="candidateTarget">The model element to test as a target</param>
            <returns>Whether the elements can be used as the source and target of a connection</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateEmbeddingRelationship.Connect(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Make a connection between the given pair of source and target elements
            </summary>
            <param name="source">The model element to use as the source of the connection</param>
            <param name="target">The model element to use as the target of the connection</param>
            <returns>A link representing the created connection</returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CreateReferenceRelationship">
            <summary>
            ConnectionBuilder class to provide logic for constructing connections between elements.
            </summary>
            <summary>
            ConnectionBuilder class to provide logic for constructing connections between elements.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateReferenceRelationship.CanAcceptSource(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given model element is acceptable to this ConnectionBuilder as the source of a connection.
            </summary>
            <param name="candidate">The model element to test.</param>
            <returns>Whether the element can be used as the source of a connection.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateReferenceRelationship.CanAcceptTarget(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given model element is acceptable to this ConnectionBuilder as the target of a connection.
            </summary>
            <param name="candidate">The model element to test.</param>
            <returns>Whether the element can be used as the target of a connection.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateReferenceRelationship.CanAcceptSourceAndTarget(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Test whether a given pair of model elements are acceptable to this ConnectionBuilder as the source and target of a connection
            </summary>
            <param name="candidateSource">The model element to test as a source</param>
            <param name="candidateTarget">The model element to test as a target</param>
            <returns>Whether the elements can be used as the source and target of a connection</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateReferenceRelationship.Connect(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Make a connection between the given pair of source and target elements
            </summary>
            <param name="source">The model element to use as the source of the connection</param>
            <param name="target">The model element to use as the target of the connection</param>
            <returns>A link representing the created connection</returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CreateDiagramElementMap">
            <summary>
            Empty ConnectionBuilder class as a placeholder for custom code.
            </summary>
            <summary>
            ConnectionBuilder class to provide logic for constructing connections that represent shape maps
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateDiagramElementMap.CanAcceptSource(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Can this connection builder accept the given element as its connection source
            </summary>
            <param name="sourceElement"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateDiagramElementMap.CanAcceptSourceAndTarget(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Can this connection builder accept the given elements as its connection source and targets.
            </summary>
            <param name="sourceElement"></param>
            <param name="targetElement"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateDiagramElementMap.Connect(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Make the connection between the given elements.
            </summary>
            <param name="sourceElement"></param>
            <param name="targetElement"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateDiagramElementMap.CreateDefaultParentElementPath(Microsoft.VisualStudio.Modeling.DslDefinition.BaseShapeMap)">
            <summary>
            Create a default parent element path for the given map
            </summary>
            <param name="map"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CreateDiagramElementMap.GetEmbeddingParent(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Get the role leading to the next class up the embedding hierarchy in the case of a singly parented class
            </summary>
            <remarks>Returns null if the class is multiply parented</remarks>
            <param name="child"></param>
            <returns>The role connecting to the embedding parent domain class or null</returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction">
            <summary>
            Handles interaction between the ConnectionBuilder and the corresponding ConnectionTool.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.#ctor(Microsoft.VisualStudio.Modeling.Diagrams.Diagram)">
            <summary>
            Constructs a new EmbeddingRelationshipToolConnectAction for the given Diagram.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.GetCursor(System.Windows.Forms.Cursor,Microsoft.VisualStudio.Modeling.Diagrams.DiagramClientView,Microsoft.VisualStudio.Modeling.Diagrams.PointD)">
            <summary>
            Gets the cursor corresponding to the given mouse position.
            </summary>
            <remarks>
            Changes the cursor to Cursors.No before the first mouse click if the source shape is not valid.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.GetConnectionTypes(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Returns the EmbeddingRelationshipToolConnectionType associated with this action.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.EmbeddingRelationshipToolConnectionTypeBase.#ctor">
            <summary>
            Constructs a new the EmbeddingRelationshipToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.EmbeddingRelationshipToolConnectionTypeBase.CanCreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,System.String@)">
            <summary>
            Called by the base ConnectAction class to determine if the given shapes can be connected.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateEmbeddingRelationship.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.EmbeddingRelationshipToolConnectionTypeBase.IsValidSourceAndTarget(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Called by the base ConnectAction class to ask whether the given source and target are valid.
            </summary>
            <remarks>
            Always return true here, to give CanCreateConnection a chance to decide.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.EmbeddingRelationshipToolConnectionTypeBase.CreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.PaintFeedbackArgs)">
            <summary>
            Called by the base ConnectAction class to create the underlying relationship.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateEmbeddingRelationship.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EmbeddingRelationshipToolConnectAction.EmbeddingRelationshipToolConnectionType.#ctor">
            <summary>
            Constructs a new the EmbeddingRelationshipToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction">
            <summary>
            Handles interaction between the ConnectionBuilder and the corresponding ConnectionTool.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.#ctor(Microsoft.VisualStudio.Modeling.Diagrams.Diagram)">
            <summary>
            Constructs a new ReferenceRelationshipToolConnectAction for the given Diagram.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.GetCursor(System.Windows.Forms.Cursor,Microsoft.VisualStudio.Modeling.Diagrams.DiagramClientView,Microsoft.VisualStudio.Modeling.Diagrams.PointD)">
            <summary>
            Gets the cursor corresponding to the given mouse position.
            </summary>
            <remarks>
            Changes the cursor to Cursors.No before the first mouse click if the source shape is not valid.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.GetConnectionTypes(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Returns the ReferenceRelationshipToolConnectionType associated with this action.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.ReferenceRelationshipToolConnectionTypeBase.#ctor">
            <summary>
            Constructs a new the ReferenceRelationshipToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.ReferenceRelationshipToolConnectionTypeBase.CanCreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,System.String@)">
            <summary>
            Called by the base ConnectAction class to determine if the given shapes can be connected.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateReferenceRelationship.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.ReferenceRelationshipToolConnectionTypeBase.IsValidSourceAndTarget(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Called by the base ConnectAction class to ask whether the given source and target are valid.
            </summary>
            <remarks>
            Always return true here, to give CanCreateConnection a chance to decide.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.ReferenceRelationshipToolConnectionTypeBase.CreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.PaintFeedbackArgs)">
            <summary>
            Called by the base ConnectAction class to create the underlying relationship.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateReferenceRelationship.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ReferenceRelationshipToolConnectAction.ReferenceRelationshipToolConnectionType.#ctor">
            <summary>
            Constructs a new the ReferenceRelationshipToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction">
            <summary>
            Handles interaction between the ConnectionBuilder and the corresponding ConnectionTool.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.#ctor(Microsoft.VisualStudio.Modeling.Diagrams.Diagram)">
            <summary>
            Constructs a new InheritanceToolConnectAction for the given Diagram.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.GetCursor(System.Windows.Forms.Cursor,Microsoft.VisualStudio.Modeling.Diagrams.DiagramClientView,Microsoft.VisualStudio.Modeling.Diagrams.PointD)">
            <summary>
            Gets the cursor corresponding to the given mouse position.
            </summary>
            <remarks>
            Changes the cursor to Cursors.No before the first mouse click if the source shape is not valid.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.GetConnectionTypes(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Returns the InheritanceToolConnectionType associated with this action.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.InheritanceToolConnectionTypeBase.#ctor">
            <summary>
            Constructs a new the InheritanceToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.InheritanceToolConnectionTypeBase.CanCreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,System.String@)">
            <summary>
            Called by the base ConnectAction class to determine if the given shapes can be connected.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateInheritanceLink.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.InheritanceToolConnectionTypeBase.IsValidSourceAndTarget(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Called by the base ConnectAction class to ask whether the given source and target are valid.
            </summary>
            <remarks>
            Always return true here, to give CanCreateConnection a chance to decide.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.InheritanceToolConnectionTypeBase.CreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.PaintFeedbackArgs)">
            <summary>
            Called by the base ConnectAction class to create the underlying relationship.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateInheritanceLink.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceToolConnectAction.InheritanceToolConnectionType.#ctor">
            <summary>
            Constructs a new the InheritanceToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction">
            <summary>
            Handles interaction between the ConnectionBuilder and the corresponding ConnectionTool.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.#ctor(Microsoft.VisualStudio.Modeling.Diagrams.Diagram)">
            <summary>
            Constructs a new DiagramElementMapToolConnectAction for the given Diagram.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.GetCursor(System.Windows.Forms.Cursor,Microsoft.VisualStudio.Modeling.Diagrams.DiagramClientView,Microsoft.VisualStudio.Modeling.Diagrams.PointD)">
            <summary>
            Gets the cursor corresponding to the given mouse position.
            </summary>
            <remarks>
            Changes the cursor to Cursors.No before the first mouse click if the source shape is not valid.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.GetConnectionTypes(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Returns the DiagramElementMapToolConnectionType associated with this action.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.DiagramElementMapToolConnectionTypeBase.#ctor">
            <summary>
            Constructs a new the DiagramElementMapToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.DiagramElementMapToolConnectionTypeBase.CanCreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,System.String@)">
            <summary>
            Called by the base ConnectAction class to determine if the given shapes can be connected.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateDiagramElementMap.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.DiagramElementMapToolConnectionTypeBase.IsValidSourceAndTarget(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Called by the base ConnectAction class to ask whether the given source and target are valid.
            </summary>
            <remarks>
            Always return true here, to give CanCreateConnection a chance to decide.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.DiagramElementMapToolConnectionTypeBase.CreateConnection(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.PaintFeedbackArgs)">
            <summary>
            Called by the base ConnectAction class to create the underlying relationship.
            </summary>
            <remarks>
            This implementation delegates calls to the ConnectionBuilder CreateDiagramElementMap.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DiagramElementMapToolConnectAction.DiagramElementMapToolConnectionType.#ctor">
            <summary>
            Constructs a new the DiagramElementMapToolConnectionType with the given ConnectionBuilder.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector">
            <summary>
            DomainClass InheritanceConnector
            Description for Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.FindInheritanceConnectorDecorator(System.String)">
            <summary>
            Finds a decorator associated with InheritanceConnector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.InitializeResources(Microsoft.VisualStudio.Modeling.Diagrams.StyleSet)">
            <summary>
            Initializes style set resources for this shape type
            </summary>
            <param name="classStyleSet">The style set for this shape class</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.DomainClassId">
            <summary>
            InheritanceConnector domain class Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrderDomainPropertyId">
            <summary>
            TreeOrder domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.treeOrderPropertyStorage">
            <summary>
            Storage for TreeOrder
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.Forwarder(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Forward type description to true Subject.
            </summary>
            <param name="source"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.FixConnectorEnds">
            <summary>
            Fix the endpoints of the connector
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.OnKeyDown(Microsoft.VisualStudio.Modeling.Diagrams.DiagramKeyEventArgs)">
            <summary>
            Connector ignores nudge keys
            </summary>
            <param name="e"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.GetToolTipText(Microsoft.VisualStudio.Modeling.Diagrams.DiagramItem)">
            <summary>
            Text of tooltip
            </summary>
            <param name="item"></param>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.ClassStyleSet">
            <summary>
            Per-class style set for this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.ShapeFields">
            <summary>
            Per-class ShapeFields for this shape.
            </summary>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.DecoratorsInitialized">
            <summary>
            Event fired when decorator initialization is complete for this shape type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.Decorators">
            <summary>
            List containing decorators used by this type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrder">
            <summary>
            Gets or sets the value of TreeOrder domain property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.CanManuallyRoute">
            <summary>
            Connector can't manually route
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.CanMove">
            <summary>
            Connector can't move
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.DefaultRoutingStyle">
            <summary>
            Use a more conducive routing style
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.HasToolTip">
            <summary>
            Connector has tooltip
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.AccessibleName">
            <summary>
            Get the accesible name for the connector
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrderPropertyHandler">
            <summary>
            Value handler for the InheritanceConnector.TreeOrder domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrderPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the InheritanceConnector.TreeOrder domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrderPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrderPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.InheritanceConnector.TreeOrderPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the InheritanceConnector.TreeOrder domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase">
            <summary>
            Double-derived base class for DomainClass RoleConnector
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.FindRoleConnectorDecorator(System.String)">
            <summary>
            Finds a decorator associated with RoleConnector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.OnInitialize">
            <summary>
            Shape instance initialization.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.InitializeResources(Microsoft.VisualStudio.Modeling.Diagrams.StyleSet)">
            <summary>
            Initializes style set resources for this shape type
            </summary>
            <param name="classStyleSet">The style set for this shape class</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.InitializeShapeFields(System.Collections.Generic.IList{Microsoft.VisualStudio.Modeling.Diagrams.ShapeField})">
            <summary>
            Initialize the collection of shape fields associated with this shape type.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.InitializeDecorators(System.Collections.Generic.IList{Microsoft.VisualStudio.Modeling.Diagrams.ShapeField},System.Collections.Generic.IList{Microsoft.VisualStudio.Modeling.Diagrams.Decorator})">
            <summary>
            Initialize the collection of decorators associated with this shape type.  This method also
            creates shape fields for outer decorators, because these are not part of the shape fields collection
            associated with the shape, so they must be created here rather than in InitializeShapeFields.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.DomainClassId">
            <summary>
            RoleConnector domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbolDomainPropertyId">
            <summary>
            MultiplicitySymbol domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrderDomainPropertyId">
            <summary>
            TreeOrder domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.treeOrderPropertyStorage">
            <summary>
            Storage for TreeOrder
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.GetMultiplicitySymbolValue">
            <summary>
            Get the string for the multiplicity label
            </summary>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.ClassStyleSet">
            <summary>
            Per-class style set for this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.ShapeFields">
            <summary>
            Per-class ShapeFields for this shape.
            </summary>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.DecoratorsInitialized">
            <summary>
            Event fired when decorator initialization is complete for this shape type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.Decorators">
            <summary>
            List containing decorators used by this type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbol">
            <summary>
            Gets or sets the value of MultiplicitySymbol domain property.
            Description for
            Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.Multiplicity Symbol
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrder">
            <summary>
            Gets or sets the value of TreeOrder domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbolPropertyHandler">
            <summary>
            Value handler for the RoleConnector.MultiplicitySymbol domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbolPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the RoleConnector.MultiplicitySymbol domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbolPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbolPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.MultiplicitySymbolPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the RoleConnector.MultiplicitySymbol domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrderPropertyHandler">
            <summary>
            Value handler for the RoleConnector.TreeOrder domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrderPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the RoleConnector.TreeOrder domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrderPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrderPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnectorBase.TreeOrderPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the RoleConnector.TreeOrder domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector">
            <summary>
            DomainClass RoleConnector
            Description for Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.OnInitialize">
            <summary>
            Initialize grid.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.Forwarder(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Forward type description to true Subject.
            </summary>
            <param name="source"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.UpdateDecoratorStylesAndPosition">
            <summary>
            Updates the styles of decorators and their host decorator shape positions that are dependent on the styles.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.EnsureMappingDependentState">
            <summary>
            Update state of shape that is dependent on it being mapped to an element.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.FixConnectorEnds">
            <summary>
            Fix the endpoints of the connector
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.OnKeyDown(Microsoft.VisualStudio.Modeling.Diagrams.DiagramKeyEventArgs)">
            <summary>
            Connector ignores nudge keys
            </summary>
            <param name="e"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.GetToolTipText(Microsoft.VisualStudio.Modeling.Diagrams.DiagramItem)">
            <summary>
            Text of tooltip
            </summary>
            <param name="item"></param>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.CanManuallyRoute">
            <summary>
            Connector can't manually route
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.CanMove">
            <summary>
            Connector can't move
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.DefaultRoutingStyle">
            <summary>
            Use a more conducive routing style
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.HasToolTip">
            <summary>
            Connector has tooltip
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.AccessibleName">
            <summary>
            Get the accesible name for the connector
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.RoleConnector.IsPropertyGeneratorVisualUpdateRule">
            <summary>
            Rule to update dynamic styles when IsPropertyGenerator changes - has to be a rule as it requires updating decorator position when font style changes.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector">
            <summary>
            DomainClass MapConnector
            Description for Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.FindMapConnectorDecorator(System.String)">
            <summary>
            Finds a decorator associated with MapConnector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.InitializeResources(Microsoft.VisualStudio.Modeling.Diagrams.StyleSet)">
            <summary>
            Initializes style set resources for this shape type
            </summary>
            <param name="classStyleSet">The style set for this shape class</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.DomainClassId">
            <summary>
            MapConnector domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.Forwarder(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Forward type description to true Subject.
            </summary>
            <param name="source"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.OnDoubleClick(Microsoft.VisualStudio.Modeling.Diagrams.DiagramPointEventArgs)">
            <summary>
            Make double-click show details window.
            </summary>
            <param name="e"></param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.ClassStyleSet">
            <summary>
            Per-class style set for this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.ShapeFields">
            <summary>
            Per-class ShapeFields for this shape.
            </summary>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.DecoratorsInitialized">
            <summary>
            Event fired when decorator initialization is complete for this shape type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.Decorators">
            <summary>
            List containing decorators used by this type.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.DefaultRoutingStyle">
            <summary>
            Gets the default line routing style for this connector.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.CanManuallyRoute">
            <summary>
            Connector can't manually route
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector.AccessibleName">
            <summary>
            Get the accesible name for the connector
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase">
            <summary>
            Double-derived base class for DomainClass DslDesignerDiagram
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.InitializeResources(Microsoft.VisualStudio.Modeling.Diagrams.StyleSet)">
            <summary>
            Initializes style set resources for this shape type
            </summary>
            <param name="classStyleSet">The style set for this shape class</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.InitializeSwimlanes">
            <summary>
            Initializes the starting swimlanes in a new Diagram.
            </summary>
            <remarks>
            This method is not called during successful deserialization, only when either a blank diagram is created or diagram deserialization fails and a diagram is created to make things work.
            
            This method does not create shapes for swimlanes with shape maps specified in the DSL definition, only those swimlanes which are not mapped.
            The assumption here is that if a swimlane is mapped to a domain class, then an instance of that class  will be created when the element mapped to the diagram is created,
            and swimlane shapes will be created as part of view fixup.
            </remarks>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.subscribedCompartmentItemsEvents">
            <summary>
            Whether compartment items change events are subscribed to.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.SubscribeCompartmentItemsEvents">
            <summary>
            Subscribe to events fired when compartment items changes.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.UnsubscribeCompartmentItemsEvents">
            <summary>
            Unsubscribe to events fired when compartment items changes.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentItemAdded(System.Object,Microsoft.VisualStudio.Modeling.ElementAddedEventArgs)">
            <summary>
            Event for element added.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentItemDeleted(System.Object,Microsoft.VisualStudio.Modeling.ElementDeletedEventArgs)">
            <summary>
            Event for element deleted.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentItemPropertyChanged(System.Object,Microsoft.VisualStudio.Modeling.ElementPropertyChangedEventArgs)">
            <summary>
            Event for element property changed.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentItemRolePlayerChanged(System.Object,Microsoft.VisualStudio.Modeling.RolePlayerChangedEventArgs)">
            <summary>
            Event for role-player changed.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentItemRolePlayerOrderChanged(System.Object,Microsoft.VisualStudio.Modeling.RolePlayerOrderChangedEventArgs)">
            <summary>
            Event for role-player order changed.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ShouldAddShapeForElement(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Called during view fixup to ask the parent whether a shape should be created for the given child element.
            </summary>
            <remarks>
            Always return true, since we assume there is only one diagram per model file for DSL scenarios.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.OnChildConfiguring(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,System.Boolean)">
            <summary>
            Called during view fixup to configure the given child element, after it has been created.
            </summary>
            <remarks>
            Custom code for choosing the shapes attached to either end of a connector is called from here.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GetSourceAndTargetForConnector(Microsoft.VisualStudio.Modeling.Diagrams.BinaryLinkShape,Microsoft.VisualStudio.Modeling.Diagrams.NodeShape@,Microsoft.VisualStudio.Modeling.Diagrams.NodeShape@)">
            <summary>
            helper method to find the shapes for either end of a connector, including calling the user's custom code
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GetEndShapesForConnector(Microsoft.VisualStudio.Modeling.Diagrams.BinaryLinkShape)">
            <summary>
            Helper method to find shapes for either end of a connector by looking for shapes associated with either end of the relationship mapped to the connector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GetSourceRolePlayerForLinkMappedByConnector(Microsoft.VisualStudio.Modeling.Diagrams.BinaryLinkShape)">
            <summary>
            Get the source role-player of the link that would be mapped by the given connector
            </summary>
            <param name="connector">The given connector.</param>
            <returns>The source role-player of the link that would be mapped by the given connector.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GetTargetRolePlayerForLinkMappedByConnector(Microsoft.VisualStudio.Modeling.Diagrams.BinaryLinkShape)">
            <summary>
            Get the target role-player of the link that would be mapped by the given connector
            </summary>
            <param name="connector">The given connector.</param>
            <returns>The target role-player of the link that would be mapped by the given connector.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CreateChildShape(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Creates a new shape for the given model element as part of view fixup
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.InitializeShapeFields(System.Collections.Generic.IList{Microsoft.VisualStudio.Modeling.Diagrams.ShapeField})">
            <summary>
            Initialize shape decorator mappings.  This is done here rather than in individual shapes because decorator maps
            are defined per diagram type rather than per shape type.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.OnViewMouseEnter(Microsoft.VisualStudio.Modeling.Diagrams.DiagramPointEventArgs)">
            <summary>
            Override to provide the right mouse action when trying
            to create links on the diagram
            </summary>
            <param name="pointArgs"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.OnConnectActionDeactivated(System.Object,Microsoft.VisualStudio.Modeling.Diagrams.DiagramEventArgs)">
            <summary>
            Snap toolbox selection back to regular pointer after using a custom connect action.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.Dispose(System.Boolean)">
            <summary>
            Dispose of connect actions.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.DomainClassId">
            <summary>
            DslDesignerDiagram domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayoutDomainPropertyId">
            <summary>
            TriggerDiagramLayout domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.triggerDiagramLayoutPropertyStorage">
            <summary>
            Storage for TriggerDiagramLayout
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CreateMatchingShapeForNodeSubject(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Make the right shape for the subject of a given tree node.
            </summary>
            <param name="node"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GetMap(Microsoft.VisualStudio.Modeling.DslDesigner.MapConnector)">
            <summary>
            Get the DiagramElementMap mapped by this MapConnector. The mapped map can be either a ShapeMap or a ConnectorMap.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GetPresentation(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Get the shape presenting the given mel on this diagram (if any)
            </summary>
            <param name="element"></param>
            <returns>the shape presenting element on this diagram or null</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ShouldExcludeFromInvalidationTracking(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Calculates whether or not specific types of shapes should be excluded
            from the invalidation tracking for the diagram. 
            </summary>
            <param name="shape">shape to check</param>
            <returns>true means exclude it from the tracking; false don't exclude it.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.IsRelationshipRequired(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship)">
            <summary>
            Test if a relationship must be shown on the diagram as a class
            </summary>
            <param name="relationship"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.FindSubject(Microsoft.VisualStudio.Modeling.Diagrams.CompartmentShape)">
            <summary>
            Gets the Subject associated with the given Shape.
            </summary>
            <param name="shape">Shape whose Subject will be returned.</param>
            <returns>Subject of the given Shape.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ClassStyleSet">
            <summary>
            Per-class style set for this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ShapeFields">
            <summary>
            Per-class ShapeFields for this shape
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TargetToolboxItemFilterAttributes">
            <summary>
            Toolbox item filter attributes for this diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.HasSwimlanes">
            <summary>
            Gets whether or not swimlanes are supported in this Diagram.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayout">
            <summary>
            Gets or sets the value of TriggerDiagramLayout domain property.
            Description for
            Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.Trigger Diagram
            Layout
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.DiagramState">
            <summary>
            Gets or sets DiagramState.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.DomainModelElementsSwimLane">
            <summary>
            Access the DomainModelElements swimlane shape
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.DiagramElementsSwimLane">
            <summary>
            Access the DiagramElements swimlane shape
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.AbstractClassShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for AbstractClassShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.AbstractClassShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for AbstractClassShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ClassShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for ClassShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ClassShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for ClassShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.RelationshipAsClassShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for RelationshipAsClassShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.RelationshipAsClassShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for RelationshipAsClassShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.DiagramShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for DiagramShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.DiagramShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for DiagramShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ShapeShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for ShapeShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ShapeShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for ShapeShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GeometryShapeShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for GeometryShapeShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.GeometryShapeShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for GeometryShapeShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.PortShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for PortShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.PortShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for PortShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.SwimLaneShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for SwimLaneShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.SwimLaneShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for SwimLaneShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ImageShapeShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for ImageShapeShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ImageShapeShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for ImageShapeShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentShapeShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for CompartmentShapeShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.CompartmentShapeShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for CompartmentShapeShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ConnectorShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for ConnectorShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.ConnectorShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for ConnectorShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.RelationshipShapeDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for RelationshipShape.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.RelationshipShapeDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for RelationshipShape.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.RoleConnectorDecoratorMap">
            <summary>
            Class containing decorator path traversal methods for RoleConnector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.RoleConnectorDecoratorMap.OnDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for RoleConnector.  Adds decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayoutPropertyHandler">
            <summary>
            Value handler for the DslDesignerDiagram.TriggerDiagramLayout domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayoutPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DslDesignerDiagram.TriggerDiagramLayout domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayoutPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayoutPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramBase.TriggerDiagramLayoutPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DslDesignerDiagram.TriggerDiagramLayout domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram">
            <summary>
            DomainClass DslDesignerDiagram
            Description for Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.navigateSwimlaneSwitch">
            <summary>
            Flip this every time the navigation goes into the swimlanes
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.OnInitialize">
            <summary>
            Set up event watchers for Holophraxis
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.EnsureDiagramState">
            <summary>
            Make sure we've got a DiagramState object
            </summary>
            <returns></returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.rand">
            <summary>
            Random number generator to help graph layout object balance its internal structures 
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.OnChildConfiguring(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,System.Boolean)">
            <summary>
            Override the setup of shapes on the diagram.
            </summary>
            <param name="child"></param>
            <param name="createdDuringViewFixup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ConfigureConnectorEndPoints(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            When a connector is about to be configured, configure any needed ends first.
            </summary>
            <param name="child"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ChooseParentShape(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Pick parenting for children of diagram.
            </summary>
            <param name="childShape"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.GetSwimlaneForTree(Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree)">
            <summary>
            Get the swimlane representing a given tree
            </summary>
            <param name="tree"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.GetClassShapeReferenceType(Microsoft.VisualStudio.Modeling.DslDesigner.AbstractClassShapeBase)">
            <summary>
            Get the class that a class shape is mapped to.
            </summary>
            <param name="shape"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.InitializeShapeFields(System.Collections.Generic.IList{Microsoft.VisualStudio.Modeling.Diagrams.ShapeField})">
            <summary>
            Setup ShapeFields/Decorators for Shapes used on this diagram.
            </summary>
            <param name="shapeFields"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.OnClassShapeDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for any concrete class derived from AbstractClassShape.  Adds EXTRA decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.OnRelationshipShapeDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for RelationshipShape.  Adds EXTRA decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.OnRoleConnectorDecoratorsInitialized(System.Object,System.EventArgs)">
            <summary>
            Event handler called when decorator initialization is complete for RoleConnector.  Adds EXTRA decorator mappings for this shape or connector.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.OnChildAssociatedPropertyChanged(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement,Microsoft.VisualStudio.Modeling.Diagrams.PropertyChangedEventArgs)">
            <summary>
            Called when a property associated with a child shape has changed.
            </summary>
            <param name="shape"></param>
            <param name="e"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.NestedTreeSetVisible(Microsoft.VisualStudio.Modeling.DslDesigner.AbstractClassShape,System.Boolean)">
            <summary>
            Set [in]visible the relationships sourced at this concept.
            </summary>
            <param name="shape"></param>
            <param name="visible"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.InheritanceTreeSetVisible(Microsoft.VisualStudio.Modeling.DslDesigner.AbstractClassShape,System.Boolean)">
            <summary>
            Set [in]visible the inheritors of this concept.
            </summary>
            <param name="shape"></param>
            <param name="visible"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ScheduleLayout">
            <summary>
            Raises an event to cause layout after end of current outer transaction.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ScheduleLayout(Microsoft.VisualStudio.Modeling.Diagrams.ShapeElement)">
            <summary>
            Raises an event to cause layout after end of current outer transaction.
            </summary>
            <param name="shapeToEnsureVisible">A shape that must be visible after the layout</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ActionLayoutRule">
            <summary>
            Reposition all shapes on the diagram.
            Called from ReLayoutRule.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.InitializeSwimlanes">
            <summary>
            When we're creating a diagram from scratch this will be called so we can clear the flag and allow the layout to proceed.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.PerformLayout">
            <summary>
            Lay out the diagram.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.GetOppositeSwimlane(Microsoft.VisualStudio.Modeling.Diagrams.SwimlaneShape)">
            <summary>
            Get the opposite swimlane to the given one
            </summary>
            <param name="originalSwimlane"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.IsReferenceTypeRequiredOnDiagram(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Must the given class be shown on the diagram.
            </summary>
            <param name="checkee"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ToggleUserRoot(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Toggle whether a reference type is a diagram root at the user's behest
            </summary>
            <param name="userRoot">The root to toggle</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.IsUserRoot(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Is the given type a root as specified by the user
            </summary>
            <param name="candidate"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.EnsureRelationshipAsClassOnDiagrams(Microsoft.VisualStudio.Modeling.DslDefinition.DomainRelationship)">
            <summary>
            Make sure that the given relationship is shown as a class on all diagrams
            </summary>
            <param name="relationship"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.NavigateDescend(Microsoft.VisualStudio.Modeling.Diagrams.SelectedShapesCollection)">
            <summary>
            Navigate into alternating swimlanes
            </summary>
            <param name="selection"></param>
            <returns></returns>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.BeginLongOperation">
            <summary>
            Event to notify clients that we're about to do something that might be time-expensive, such as relayout or restructure.
            </summary>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.ShowDetails">
            <summary>
            Request that the container of this diagram show details windows
            </summary>
        </member>
        <member name="E:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.NavigateToShape">
            <summary>
            Request that the container of this diagram navigate to the given shape
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagram.LayoutRule">
            <summary>
            Rule class to handle scheduling layout of the diagram.
            </summary>
            <remarks>
            Runs just before line rerouting - must run after shape anchoring.
            </remarks>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.FixUpDiagram">
            <summary>
            Rule that initiates view fixup when an element that has an associated shape is added to the model. 
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemAddRule">
            <summary>
            Rule to update compartments when an item is added to the list
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemAddRule.ElementAdded(Microsoft.VisualStudio.Modeling.ElementAddedEventArgs)">
            <summary>
            Called when an element is added. 
            </summary>
            <param name="e"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemAddRule.UpdateCompartments(System.Collections.IEnumerable,System.Type,System.String,System.Boolean)">
            <summary>
            Updates the compartments for the shapes associated to the given list of model elements
            </summary>
            <param name="elements">List of model elements</param>
            <param name="shapeType">The type of shape that needs updating</param>
            <param name="compartmentName">The name of the compartment to update</param>
            <param name="repaintOnly">If true, the method will only invalidate the shape for a repaint, without re-initializing the shape.</param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemDeleteRule">
            <summary>
            Rule to update compartments when an items is removed from the list
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemDeleteRule.ElementDeleted(Microsoft.VisualStudio.Modeling.ElementDeletedEventArgs)">
            <summary>
            Called when an element is deleted
            </summary>
            <param name="e"></param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemChangeRule">
            <summary>
            Rule to update compartments when the property on an item being displayed changes.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemChangeRule.ElementPropertyChanged(Microsoft.VisualStudio.Modeling.ElementPropertyChangedEventArgs)">
            <summary>
            Called when an element is changed
            </summary>
            <param name="e"></param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemRolePlayerChangeRule">
            <summary>
            Rule to update compartments when a roleplayer change happens
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemRolePlayerChangeRule.RolePlayerChanged(Microsoft.VisualStudio.Modeling.RolePlayerChangedEventArgs)">
            <summary>
            Called when the roleplayer on a link changes.
            </summary>
            <param name="e"></param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemRolePlayerPositionChangeRule">
            <summary>
            Rule to update compartments when the order of items in the list changes.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.CompartmentItemRolePlayerPositionChangeRule.RolePlayerPositionChanged(Microsoft.VisualStudio.Modeling.RolePlayerOrderChangedEventArgs)">
            <summary>
            Called when the order of a roleplayer in a relationship changes
            </summary>
            <param name="e"></param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DecoratorPropertyChanged">
            <summary>
            A rule which fires when data mapped to outer text decorators has changed,
            so we can update the decorator host's bounds.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.ConnectorRolePlayerChanged">
            <summary>
            Reroute a connector when the role players of its underlying relationship change
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.ConnectorRolePlayerChanged.RolePlayerChanged(Microsoft.VisualStudio.Modeling.RolePlayerChangedEventArgs)">
            <summary>
            Reroute a connector when the role players of its underlying relationship change
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty">
            <summary>
            DomainClass DomainProperty
            Description for Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DomainClassId">
            <summary>
            DomainProperty domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValueDomainPropertyId">
            <summary>
            DefaultValue domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.KindDomainPropertyId">
            <summary>
            Kind domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.kindPropertyStorage">
            <summary>
            Storage for Kind
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CategoryDomainPropertyId">
            <summary>
            Category domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.categoryPropertyStorage">
            <summary>
            Storage for Category
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifierDomainPropertyId">
            <summary>
            GetterAccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.getterAccessModifierPropertyStorage">
            <summary>
            Storage for GetterAccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifierDomainPropertyId">
            <summary>
            SetterAccessModifier domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.setterAccessModifierPropertyStorage">
            <summary>
            Storage for SetterAccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementNameDomainPropertyId">
            <summary>
            IsElementName domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.isElementNamePropertyStorage">
            <summary>
            Storage for IsElementName
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsableDomainPropertyId">
            <summary>
            IsBrowsable domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.isBrowsablePropertyStorage">
            <summary>
            Storage for IsBrowsable
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnlyDomainPropertyId">
            <summary>
            IsUIReadOnly domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.isUIReadOnlyPropertyStorage">
            <summary>
            Storage for IsUIReadOnly
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.defaultValueStorage">
            <summary>
            Custom storage for DefaultValue, which has null value by default (all the generated
            string-type properties have string.Empty value by default).
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetDefaultValueValue">
            <summary>
            Get the value of DefaultValue property.
            </summary>
            <returns>Value of DefaultValue property.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetDefaultValueValue(System.String)">
            <summary>
            Set the value of DefaultValue property.
            </summary>
            <param name="newValue">New value of DefaultValue property.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.MergeConfigure(Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Configure a newly merged DomainProperty
            </summary>
            <param name="elementGroup"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CalculateDescription">
            <summary>
            Calculate the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.OnNameChanged(System.String,System.String)">
            <summary>
            Handler for change of name of a DomainProperty
            </summary>
            <param name="oldValue"></param>
            <param name="newValue"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.ValidateName(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Check the property name is valid.
            Overrides the ValidateName in NamedDomainElement.
            </summary>
            <param name="context"></param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.ValidateDefaultValue(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Validate the domain property
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.ValidateElementName(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Validate the domain class
            </summary>
            <param name="context">context object for logging errors/warnings/informationals</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValue">
            <summary>
            Gets or sets the value of DefaultValue domain property.
            Default value for the property, provided as a string.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.Kind">
            <summary>
            Gets or sets the value of Kind domain property.
            Determines whether the property is normal, calculated or requires custom
            storage.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.Category">
            <summary>
            Gets or sets the value of Category domain property.
            Category under which the property appears in the properties window.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifier">
            <summary>
            Gets or sets the value of GetterAccessModifier domain property.
            Determines the access modifier for the getter.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifier">
            <summary>
            Gets or sets the value of SetterAccessModifier domain property.
            Determines the access modifier for the setter.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementName">
            <summary>
            Gets or sets the value of IsElementName domain property.
            If True, the property should be used as the name of the element in which the
            property is embedded.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsable">
            <summary>
            Gets or sets the value of IsBrowsable domain property.
            If True, the property is marked as browsable in its corresponding property
            descriptor. As a result, it can be browsed through the properties window.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnly">
            <summary>
            Gets or sets the value of IsUIReadOnly domain property.
            If True, the property can not be edited through the UI when browsed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.Class">
            <summary>
            Gets or sets Class.
            Class for which this is a domain property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.Type">
            <summary>
            Gets or sets Type.
            Type of the property.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.ElementNameProvider">
            <summary>
            Gets or sets ElementNameProvider.
            External type which provides values for this property, which must have Is
            Element Name set to true.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.XmlElement">
            <summary>
            Gets or sets XmlElement.
            Xml serialization configuration data for the domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValuePropertyHandler">
            <summary>
            Value handler for the DomainProperty.DefaultValue domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValuePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.DefaultValue domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValuePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValuePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.DefaultValuePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.DefaultValue domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.KindPropertyHandler">
            <summary>
            Value handler for the DomainProperty.Kind domain property.
            </summary>
            <summary>
            Change handler for Kind
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.KindPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.Kind domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.KindPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.KindPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.KindPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.Kind domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CategoryPropertyHandler">
            <summary>
            Value handler for the DomainProperty.Category domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CategoryPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.Category domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CategoryPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CategoryPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.CategoryPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.Category domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifierPropertyHandler">
            <summary>
            Value handler for the DomainProperty.GetterAccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.GetterAccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.GetterAccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.GetterAccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifierPropertyHandler">
            <summary>
            Value handler for the DomainProperty.SetterAccessModifier domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifierPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.SetterAccessModifier domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifierPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifierPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.SetterAccessModifierPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.SetterAccessModifier domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementNamePropertyHandler">
            <summary>
            Value handler for the DomainProperty.IsElementName domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementNamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.IsElementName domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementNamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementNamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsElementNamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.IsElementName domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsablePropertyHandler">
            <summary>
            Value handler for the DomainProperty.IsBrowsable domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsablePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.IsBrowsable domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsablePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsablePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsBrowsablePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.IsBrowsable domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnlyPropertyHandler">
            <summary>
            Value handler for the DomainProperty.IsUIReadOnly domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnlyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainProperty.IsUIReadOnly domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnlyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnlyPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainProperty.IsUIReadOnlyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainProperty.IsUIReadOnly domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral">
            <summary>
            DomainClass EnumerationLiteral
            Defines a literal for an enumeration.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.DomainClassId">
            <summary>
            EnumerationLiteral domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.ValueDomainPropertyId">
            <summary>
            Value domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.valuePropertyStorage">
            <summary>
            Storage for Value
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.CalculateDescription">
            <summary>
            Calculate the value of Description
            </summary>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the literal.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.Value">
            <summary>
            Gets or sets the value of Value domain property.
            Integer associated with the literal. May be null.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.Enumeration">
            <summary>
            Gets or sets Enumeration.
            Enumeration defining the literal.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.NamePropertyHandler">
            <summary>
            Value handler for the EnumerationLiteral.Name domain property.
            </summary>
            <summary>
            Update description when Name property changes
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the EnumerationLiteral.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the EnumerationLiteral.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.ValuePropertyHandler">
            <summary>
            Value handler for the EnumerationLiteral.Value domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.ValuePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the EnumerationLiteral.Value domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.ValuePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.ValuePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral,System.Nullable{System.Int32})">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.EnumerationLiteral.ValuePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the EnumerationLiteral.Value domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExternalType">
            <summary>
            DomainClass ExternalType
            Provides a point of reference to an external type.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExternalType.DomainClassId">
            <summary>
            ExternalType domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExternalType.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExternalType.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute">
            <summary>
            DomainClass ClrAttribute
            Defines CLR attributes in a DSL definition.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.DomainClassId">
            <summary>
            ClrAttribute domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.ValidateClrAttribute(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Validate the domain class
            </summary>
            <param name="context">context object for logging errors/warnings/informationals</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the attribute.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.Parameters">
            <summary>
            Gets a list of Parameters.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.NamePropertyHandler">
            <summary>
            Value handler for the ClrAttribute.Name domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ClrAttribute.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ClrAttribute.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ClrAttribute.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter">
            <summary>
            DomainClass AttributeParameter
            Parameter of a Clr Attribute.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.DomainClassId">
            <summary>
            AttributeParameter domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.ValueDomainPropertyId">
            <summary>
            Value domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.valuePropertyStorage">
            <summary>
            Storage for Value
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the attribute parameter.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.Value">
            <summary>
            Gets or sets the value of Value domain property.
            Value of this attribute parameter.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.Attribute">
            <summary>
            Gets or sets Attribute.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.NamePropertyHandler">
            <summary>
            Value handler for the AttributeParameter.Name domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the AttributeParameter.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the AttributeParameter.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.ValuePropertyHandler">
            <summary>
            Value handler for the AttributeParameter.Value domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.ValuePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the AttributeParameter.Value domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.ValuePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.ValuePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.AttributeParameter.ValuePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the AttributeParameter.Value domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath">
            <summary>
            DomainClass DomainPath
            An expression for navigating across domain classes and relationships in a DSL
            definition.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.SegmentSeparatorCharacter">
            <summary>
            The separator used between segments in a DomainPath's concrete syntax
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.LinksInterpretationCharacter">
            <summary>
            The character used to denote that a role should be interpreted as a traversal to Links in a DomainPath's concrete syntax
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.ElementsInterpretationCharacter">
            <summary>
            The character used to denote that a role should be interpreted as a traversal to Elements in a DomainPath's concrete syntax
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.DomainClassId">
            <summary>
            DomainPath domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.lastInitializationData">
            <summary>
            The last string that this DomainPath was initialized from.
            </summary>
            <remarks>
            There are no guarantees that this matches the current content of the path.
            Only use this if you know you haven't changed the object since Initialize
            This is used to "ressurect" DomainPaths that were discarded as part of UI parsing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.InitializeFromDeletedPath(Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath)">
            <summary>
            Initialize a current, active DomainPath with the initialization data from a previously deleted one
            </summary>
            <param name="deletedPath"></param>
            <returns>Whether the path has segments</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.Compare(Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath,Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath)">
            <summary>
            Compare two DomainPaths for value equivalence
            </summary>
            <returns>True if the paths are equivalent</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.Initialize(System.String,System.Boolean)">
            <summary>
            Initialize a DomainPath from a serialized format
            </summary>
            <param name="serialization"></param>
            <param name="monikerize">Whether to monikerize the Role references in any PathSegments created</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.GetHostProvidedNamespace">
            <summary>
            Walk the embedding hierarchy looking for an IPathHost to give us a default namespace
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.GetValidStartingPoints">
            <summary>
            Returns a list of DomainClasses from which the path
            can start.
            </summary>
            <remarks>
            Walks up the embedding hierarchy looking for an IPathHost that
            to give us the list.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.ExecuteActionOnPathHost(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.ActOnPathHost)">
            <summary>
            Recursively walks up the embedding hierarchy looking for implementations
            of IPathHost. When it finds one, it executes the specified delegate.
            </summary>
            <remarks>
            The delegate returns a boolean indicating whether to continue searching.
            </remarks>
            <param name="child">Child object from which to start</param>
            <param name="op">Action to execute when an IPathHost implementation is found</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.GetParentPathHost(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Walks up the embedding hierarchy and returns the first
            class above the child that implements IPathHost.
            </summary>
            <remarks>
            Returns null if no matches found.
            The search starts above the child i.e. the child will never
            be returned, even if it implements IPathHost.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.ToString">
            <summary>
            Serialize a path to a string using the concrete syntax.
            </summary>
            <returns>The path expressed as a string</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.VerifyPath(Microsoft.VisualStudio.Modeling.Validation.ValidationContext,System.String,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Check for errors in a DomainPath.
            Type compatibility checks are more strict at the start of a path than between segments and at the end.
            The starting class must be type-compatible with the initial segment. 
            The target class of each segment must be either type-compatible or castable to the source of the next.
            </summary>
            <param name="context"></param>
            <param name="contextDescription">Prefix to any error message generated here.</param>
            <param name="container">Element to select when error message is double clicked.</param>
            <param name="startType">DomainClass with which the start of the path should be compatible (or null to omit this check)</param>
            <param name="endType">DomainClass with which the end of the path should be compatible (or null to omit this check)</param>
            <returns>True if no errors</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.ValidateCanParseDomainPath(Microsoft.VisualStudio.Modeling.Validation.ValidationContext)">
            <summary>
            Validate that the domain path can be parsed. If if can't be parsed,
            then it won't be possible to reload the model.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.Segments">
            <summary>
            Gets a list of Segments.
            Segments of the path.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.IsCollectionPath">
            <summary>
            Is this path collection valued or single valued?
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.TargetType">
            <summary>
            The type of the final link 
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainPath.ActOnPathHost">
            <summary>
            Delegate called by ExecuteActionOnPathHost as it walks up the embedding hierarchy
            </summary>
            <param name="host">The path host on which to operate</param>
            <returns>A flag that indicates whether to continue processing (true=continue)</returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CustomEditor">
            <summary>
            DomainClass CustomEditor
            Defines an editor whose main design surface is implemented by custom code.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CustomEditor.DomainClassId">
            <summary>
            CustomEditor domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CustomEditor.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CustomEditor.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Validation">
            <summary>
            DomainClass Validation
            Defines the validation behavior for an editor.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.DomainClassId">
            <summary>
            Validation domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenuDomainPropertyId">
            <summary>
            UsesMenu domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.usesMenuPropertyStorage">
            <summary>
            Storage for UsesMenu
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpenDomainPropertyId">
            <summary>
            UsesOpen domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.usesOpenPropertyStorage">
            <summary>
            Storage for UsesOpen
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSaveDomainPropertyId">
            <summary>
            UsesSave domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.usesSavePropertyStorage">
            <summary>
            Storage for UsesSave
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustomDomainPropertyId">
            <summary>
            UsesCustom domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.usesCustomPropertyStorage">
            <summary>
            Storage for UsesCustom
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoadDomainPropertyId">
            <summary>
            UsesLoad domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.usesLoadPropertyStorage">
            <summary>
            Storage for UsesLoad
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenu">
            <summary>
            Gets or sets the value of UsesMenu domain property.
            If True, validation methods which execute when the validate menu option is
            selected are employed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpen">
            <summary>
            Gets or sets the value of UsesOpen domain property.
            If True, validation methods which execute on open (after successful load) are
            employed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSave">
            <summary>
            Gets or sets the value of UsesSave domain property.
            If True, validation methods which execute on save are employed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustom">
            <summary>
            Gets or sets the value of UsesCustom domain property.
            If True, custom validation methods are employed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoad">
            <summary>
            Gets or sets the value of UsesLoad domain property.
            If True, validation methods which execute on load are employed.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.Editor">
            <summary>
            Gets or sets Editor.
            Editor defining the validation behavior.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenuPropertyHandler">
            <summary>
            Value handler for the Validation.UsesMenu domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenuPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Validation.UsesMenu domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenuPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenuPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesMenuPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Validation.UsesMenu domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpenPropertyHandler">
            <summary>
            Value handler for the Validation.UsesOpen domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpenPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Validation.UsesOpen domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpenPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpenPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesOpenPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Validation.UsesOpen domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSavePropertyHandler">
            <summary>
            Value handler for the Validation.UsesSave domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSavePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Validation.UsesSave domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSavePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSavePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesSavePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Validation.UsesSave domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustomPropertyHandler">
            <summary>
            Value handler for the Validation.UsesCustom domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustomPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Validation.UsesCustom domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustomPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustomPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesCustomPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Validation.UsesCustom domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoadPropertyHandler">
            <summary>
            Value handler for the Validation.UsesLoad domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoadPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Validation.UsesLoad domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoadPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoadPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Validation,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Validation.UsesLoadPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Validation.UsesLoad domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Port">
            <summary>
            DomainClass Port
            Defines a port shape.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape">
            <summary>
            DomainClass GeometryShape
            Defines a shape with a geometric outline.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape">
            <summary>
            DomainClass Shape
            Abstract base class for geometry and compartment shapes.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape">
            <summary>
            DomainClass BaseShape
            Abstract base class for all kinds of shape.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape.DomainClassId">
            <summary>
            BaseShape domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.BaseShape.DslLibrary">
            <summary>
            Gets or sets DslLibrary.
            Dsl library defining the shape.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.DomainClassId">
            <summary>
            Shape domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor.
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColorDomainPropertyId">
            <summary>
            FillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.fillColorPropertyStorage">
            <summary>
            Storage for FillColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColorDomainPropertyId">
            <summary>
            OutlineColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.outlineColorPropertyStorage">
            <summary>
            Storage for OutlineColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidthDomainPropertyId">
            <summary>
            InitialWidth domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.initialWidthPropertyStorage">
            <summary>
            Storage for InitialWidth
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeightDomainPropertyId">
            <summary>
            InitialHeight domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.initialHeightPropertyStorage">
            <summary>
            Storage for InitialHeight
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStyleDomainPropertyId">
            <summary>
            OutlineDashStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.outlineDashStylePropertyStorage">
            <summary>
            Storage for OutlineDashStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThicknessDomainPropertyId">
            <summary>
            OutlineThickness domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.outlineThicknessPropertyStorage">
            <summary>
            Storage for OutlineThickness
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientModeDomainPropertyId">
            <summary>
            FillGradientMode domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.fillGradientModePropertyStorage">
            <summary>
            Storage for FillGradientMode
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPointsDomainPropertyId">
            <summary>
            HasDefaultConnectionPoints domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.hasDefaultConnectionPointsPropertyStorage">
            <summary>
            Storage for HasDefaultConnectionPoints
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineColorAsPropertyDomainPropertyId">
            <summary>
            ExposesOutlineColorAsProperty domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillColorAsPropertyDomainPropertyId">
            <summary>
            ExposesFillColorAsProperty domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineDashStyleAsPropertyDomainPropertyId">
            <summary>
            ExposesOutlineDashStyleAsProperty domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineThicknessAsPropertyDomainPropertyId">
            <summary>
            ExposesOutlineThicknessAsProperty domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillGradientModeDomainPropertyId">
            <summary>
            ExposesFillGradientMode domain property Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.GetExposesOutlineColorAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesOutlineColor
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.GetExposesFillColorAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesFillColor
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.GetExposesOutlineDashStyleAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesOutlineDashStyle
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.GetExposesOutlineThicknessAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesOutlineThickness
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.GetExposesFillGradientModeValue">
            <summary>
            Calculated property calculator for ExposesFillGradientMode
            </summary>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColor">
            <summary>
            Gets or sets the value of FillColor domain property.
            Fill color of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColor">
            <summary>
            Gets or sets the value of OutlineColor domain property.
            Outline color of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidth">
            <summary>
            Gets or sets the value of InitialWidth domain property.
            Initial width of this shape, in inches.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeight">
            <summary>
            Gets or sets the value of InitialHeight domain property.
            Initial height of this shape, in inches.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStyle">
            <summary>
            Gets or sets the value of OutlineDashStyle domain property.
            Outline dash style of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThickness">
            <summary>
            Gets or sets the value of OutlineThickness domain property.
            Outline thickness of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientMode">
            <summary>
            Gets or sets the value of FillGradientMode domain property.
            Fill gradient mode of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPoints">
            <summary>
            Gets or sets the value of HasDefaultConnectionPoints domain property.
            If True, the shape will use top, bottom, left and right connection points in the
            generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineColorAsProperty">
            <summary>
            Gets or sets the value of ExposesOutlineColorAsProperty domain property.
            If True, a domain property has been added to the shape to allow the outline
            color to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillColorAsProperty">
            <summary>
            Gets or sets the value of ExposesFillColorAsProperty domain property.
            If True, a domain property has been added to the shape to allow the fill color
            to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineDashStyleAsProperty">
            <summary>
            Gets or sets the value of ExposesOutlineDashStyleAsProperty domain property.
            If True, a domain property has been added to the shape to allow the outline dash
            style to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineThicknessAsProperty">
            <summary>
            Gets or sets the value of ExposesOutlineThicknessAsProperty domain property.
            If True, a domain property has been added to the shape to allow the outline
            thickness to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillGradientMode">
            <summary>
            Gets or sets the value of ExposesFillGradientMode domain property.
            If True, a domain property has been added to the shape to allow the fill
            gradient mode to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColorPropertyHandler">
            <summary>
            Value handler for the Shape.FillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.FillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.FillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColorPropertyHandler">
            <summary>
            Value handler for the Shape.OutlineColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.OutlineColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.OutlineColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidthPropertyHandler">
            <summary>
            Value handler for the Shape.InitialWidth domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidthPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.InitialWidth domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidthPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidthPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialWidthPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.InitialWidth domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeightPropertyHandler">
            <summary>
            Value handler for the Shape.InitialHeight domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeightPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.InitialHeight domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeightPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeightPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.InitialHeightPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.InitialHeight domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStylePropertyHandler">
            <summary>
            Value handler for the Shape.OutlineDashStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.OutlineDashStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Drawing.Drawing2D.DashStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineDashStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.OutlineDashStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThicknessPropertyHandler">
            <summary>
            Value handler for the Shape.OutlineThickness domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThicknessPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.OutlineThickness domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThicknessPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThicknessPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.OutlineThicknessPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.OutlineThickness domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientModePropertyHandler">
            <summary>
            Value handler for the Shape.FillGradientMode domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientModePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.FillGradientMode domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientModePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientModePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,Microsoft.VisualStudio.Modeling.DslDefinition.FillGradientMode)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.FillGradientModePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.FillGradientMode domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPointsPropertyHandler">
            <summary>
            Value handler for the Shape.HasDefaultConnectionPoints domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPointsPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.HasDefaultConnectionPoints domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPointsPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPointsPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.HasDefaultConnectionPointsPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.HasDefaultConnectionPoints domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineColorAsPropertyPropertyHandler">
            <summary>
            Value handler for the Shape.ExposesOutlineColorAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineColorAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.ExposesOutlineColorAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineColorAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineColorAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.ExposesOutlineColorAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillColorAsPropertyPropertyHandler">
            <summary>
            Value handler for the Shape.ExposesFillColorAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillColorAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.ExposesFillColorAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillColorAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillColorAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.ExposesFillColorAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineDashStyleAsPropertyPropertyHandler">
            <summary>
            Value handler for the Shape.ExposesOutlineDashStyleAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineDashStyleAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.ExposesOutlineDashStyleAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineDashStyleAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineDashStyleAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.ExposesOutlineDashStyleAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineThicknessAsPropertyPropertyHandler">
            <summary>
            Value handler for the Shape.ExposesOutlineThicknessAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineThicknessAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.ExposesOutlineThicknessAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineThicknessAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesOutlineThicknessAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.ExposesOutlineThicknessAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillGradientModePropertyHandler">
            <summary>
            Value handler for the Shape.ExposesFillGradientMode domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillGradientModePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Shape.ExposesFillGradientMode domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillGradientModePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Shape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Shape.ExposesFillGradientModePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Shape.ExposesFillGradientMode domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.DomainClassId">
            <summary>
            GeometryShape domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.GeometryDomainPropertyId">
            <summary>
            Geometry domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.geometryPropertyStorage">
            <summary>
            Storage for Geometry
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.Geometry">
            <summary>
            Gets or sets the value of Geometry domain property.
            Outline geometry of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base geometry shape of this geometry shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.GeometryPropertyHandler">
            <summary>
            Value handler for the GeometryShape.Geometry domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.GeometryPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the GeometryShape.Geometry domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.GeometryPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.GeometryPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape,Microsoft.VisualStudio.Modeling.DslDefinition.ShapeGeometry)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.GeometryShape.GeometryPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the GeometryShape.Geometry domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Port.DomainClassId">
            <summary>
            Port domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Port.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Port.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Port.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base port of this port.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Port.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor">
            <summary>
            DomainClass DomainTypeDescriptor
            Allows the default type descriptor for a domain class to be customized.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.DomainClassId">
            <summary>
            DomainTypeDescriptor domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCodedDomainPropertyId">
            <summary>
            CustomCoded domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.customCodedPropertyStorage">
            <summary>
            Storage for CustomCoded
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCoded">
            <summary>
            Gets or sets the value of CustomCoded domain property.
            If True, the type descriptor is defined by custom code.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.PathsOfCustomPropertyDescriptors">
            <summary>
            Gets a list of PathsOfCustomPropertyDescriptors.
            Paths identifying properties to be included in the type descriptor.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.Class">
            <summary>
            Gets or sets Class.
            Class to which the custom type descriptor applies.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCodedPropertyHandler">
            <summary>
            Value handler for the DomainTypeDescriptor.CustomCoded domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCodedPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the DomainTypeDescriptor.CustomCoded domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCodedPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCodedPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DomainTypeDescriptor.CustomCodedPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the DomainTypeDescriptor.CustomCoded domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector">
            <summary>
            DomainClass Connector
            Defines a connector.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DomainClassId">
            <summary>
            Connector domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ColorDomainPropertyId">
            <summary>
            Color domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.colorPropertyStorage">
            <summary>
            Storage for Color
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStyleDomainPropertyId">
            <summary>
            DashStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.dashStylePropertyStorage">
            <summary>
            Storage for DashStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStyleDomainPropertyId">
            <summary>
            SourceEndStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.sourceEndStylePropertyStorage">
            <summary>
            Storage for SourceEndStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStyleDomainPropertyId">
            <summary>
            TargetEndStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.targetEndStylePropertyStorage">
            <summary>
            Storage for TargetEndStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ThicknessDomainPropertyId">
            <summary>
            Thickness domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.thicknessPropertyStorage">
            <summary>
            Storage for Thickness
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStyleDomainPropertyId">
            <summary>
            RoutingStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.routingStylePropertyStorage">
            <summary>
            Storage for RoutingStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesColorAsPropertyDomainPropertyId">
            <summary>
            ExposesColorAsProperty domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesDashStyleAsPropertyDomainPropertyId">
            <summary>
            ExposesDashStyleAsProperty domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesThicknessAsPropertyDomainPropertyId">
            <summary>
            ExposesThicknessAsProperty domain property Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.GetExposesColorAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesColor
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.GetExposesDashStyleAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesDashStyle
            </summary>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.GetExposesThicknessAsPropertyValue">
            <summary>
            Calculated property calculator for ExposesThickness
            </summary>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.Color">
            <summary>
            Gets or sets the value of Color domain property.
            The color of this connector.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStyle">
            <summary>
            Gets or sets the value of DashStyle domain property.
            The dash style for the line for this connector.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStyle">
            <summary>
            Gets or sets the value of SourceEndStyle domain property.
            The source end style for this connector.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStyle">
            <summary>
            Gets or sets the value of TargetEndStyle domain property.
            The target end style for this connector.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.Thickness">
            <summary>
            Gets or sets the value of Thickness domain property.
            The thickness of the line for this connector, measured in inches.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStyle">
            <summary>
            Gets or sets the value of RoutingStyle domain property.
            The style used for routing the connector. A rectilinear connector makes right
            angled turns as necessary, a straight connector does not.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesColorAsProperty">
            <summary>
            Gets or sets the value of ExposesColorAsProperty domain property.
            If True, then a domain property has been added to the connector to allow the
            color to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesDashStyleAsProperty">
            <summary>
            Gets or sets the value of ExposesDashStyleAsProperty domain property.
            If True, then a domain property has been added to the connector to allow the
            dash style to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesThicknessAsProperty">
            <summary>
            Gets or sets the value of ExposesThicknessAsProperty domain property.
            If True, then a domain property has been added to the connector to allow the
            thickness to be exposed in the properties window of the generated designer.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base connector of this connector.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ColorPropertyHandler">
            <summary>
            Value handler for the Connector.Color domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.Color domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.Color domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStylePropertyHandler">
            <summary>
            Value handler for the Connector.DashStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.DashStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector,System.Drawing.Drawing2D.DashStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.DashStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.DashStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStylePropertyHandler">
            <summary>
            Value handler for the Connector.SourceEndStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.SourceEndStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector,Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorEndStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.SourceEndStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.SourceEndStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStylePropertyHandler">
            <summary>
            Value handler for the Connector.TargetEndStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.TargetEndStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector,Microsoft.VisualStudio.Modeling.DslDefinition.ConnectorEndStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.TargetEndStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.TargetEndStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ThicknessPropertyHandler">
            <summary>
            Value handler for the Connector.Thickness domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ThicknessPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.Thickness domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ThicknessPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ThicknessPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ThicknessPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.Thickness domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStylePropertyHandler">
            <summary>
            Value handler for the Connector.RoutingStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.RoutingStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector,Microsoft.VisualStudio.Modeling.DslDefinition.RoutingStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.RoutingStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.RoutingStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesColorAsPropertyPropertyHandler">
            <summary>
            Value handler for the Connector.ExposesColorAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesColorAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.ExposesColorAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesColorAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesColorAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.ExposesColorAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesDashStyleAsPropertyPropertyHandler">
            <summary>
            Value handler for the Connector.ExposesDashStyleAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesDashStyleAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.ExposesDashStyleAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesDashStyleAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesDashStyleAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.ExposesDashStyleAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesThicknessAsPropertyPropertyHandler">
            <summary>
            Value handler for the Connector.ExposesThicknessAsProperty domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesThicknessAsPropertyPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Connector.ExposesThicknessAsProperty domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesThicknessAsPropertyPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Connector)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Connector.ExposesThicknessAsPropertyPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Connector.ExposesThicknessAsProperty domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment">
            <summary>
            DomainClass Compartment
            Defines a compartment of a compartment shape.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DomainClassId">
            <summary>
            Compartment domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColorDomainPropertyId">
            <summary>
            FillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.fillColorPropertyStorage">
            <summary>
            Storage for FillColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColorDomainPropertyId">
            <summary>
            TitleFillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.titleFillColorPropertyStorage">
            <summary>
            Storage for TitleFillColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.NameDomainPropertyId">
            <summary>
            Name domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.namePropertyStorage">
            <summary>
            Storage for Name
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseStateDomainPropertyId">
            <summary>
            DefaultExpandCollapseState domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.defaultExpandCollapseStatePropertyStorage">
            <summary>
            Storage for DefaultExpandCollapseState
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStyleDomainPropertyId">
            <summary>
            TitleFontStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.titleFontStylePropertyStorage">
            <summary>
            Storage for TitleFontStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSizeDomainPropertyId">
            <summary>
            TitleFontSize domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.titleFontSizePropertyStorage">
            <summary>
            Storage for TitleFontSize
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStyleDomainPropertyId">
            <summary>
            EntryFontStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.entryFontStylePropertyStorage">
            <summary>
            Storage for EntryFontStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSizeDomainPropertyId">
            <summary>
            EntryFontSize domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.entryFontSizePropertyStorage">
            <summary>
            Storage for EntryFontSize
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleDomainPropertyId">
            <summary>
            Title domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.titlePropertyStorage">
            <summary>
            Storage for Title
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColorDomainPropertyId">
            <summary>
            EntryTextColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.entryTextColorPropertyStorage">
            <summary>
            Storage for EntryTextColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColorDomainPropertyId">
            <summary>
            TitleTextColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.titleTextColorPropertyStorage">
            <summary>
            Storage for TitleTextColor
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColor">
            <summary>
            Gets or sets the value of FillColor domain property.
            Fill color of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColor">
            <summary>
            Gets or sets the value of TitleFillColor domain property.
            Fill color for the title area of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.Name">
            <summary>
            Gets or sets the value of Name domain property.
            Name of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseState">
            <summary>
            Gets or sets the value of DefaultExpandCollapseState domain property.
            If Expanded, then the compartment is expanded on creation.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStyle">
            <summary>
            Gets or sets the value of TitleFontStyle domain property.
            Font style for text in the title of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSize">
            <summary>
            Gets or sets the value of TitleFontSize domain property.
            Font size for text in the title of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStyle">
            <summary>
            Gets or sets the value of EntryFontStyle domain property.
            Font style of an entry in the compartment list.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSize">
            <summary>
            Gets or sets the value of EntryFontSize domain property.
            Font size of an entry in the compartment list.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.Title">
            <summary>
            Gets or sets the value of Title domain property.
            Text that is displayed as the title of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColor">
            <summary>
            Gets or sets the value of EntryTextColor domain property.
            Text color of an entry in the compartment list.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColor">
            <summary>
            Gets or sets the value of TitleTextColor domain property.
            Color of text in the title of the compartment.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.Shape">
            <summary>
            Gets or sets Shape.
            Compartment shape defining the compartments.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.CompartmentMaps">
            <summary>
            Gets a list of CompartmentMaps.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColorPropertyHandler">
            <summary>
            Value handler for the Compartment.FillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.FillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.FillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.FillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColorPropertyHandler">
            <summary>
            Value handler for the Compartment.TitleFillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.TitleFillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.TitleFillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.NamePropertyHandler">
            <summary>
            Value handler for the Compartment.Name domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.NamePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.Name domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.NamePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.NamePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.NamePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.Name domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseStatePropertyHandler">
            <summary>
            Value handler for the Compartment.DefaultExpandCollapseState domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseStatePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.DefaultExpandCollapseState domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseStatePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseStatePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,Microsoft.VisualStudio.Modeling.DslDefinition.ExpandCollapseState)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.DefaultExpandCollapseStatePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.DefaultExpandCollapseState domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStylePropertyHandler">
            <summary>
            Value handler for the Compartment.TitleFontStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.TitleFontStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Drawing.FontStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.TitleFontStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSizePropertyHandler">
            <summary>
            Value handler for the Compartment.TitleFontSize domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSizePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.TitleFontSize domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSizePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSizePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleFontSizePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.TitleFontSize domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStylePropertyHandler">
            <summary>
            Value handler for the Compartment.EntryFontStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.EntryFontStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Drawing.FontStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.EntryFontStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSizePropertyHandler">
            <summary>
            Value handler for the Compartment.EntryFontSize domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSizePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.EntryFontSize domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSizePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSizePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Int32)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryFontSizePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.EntryFontSize domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitlePropertyHandler">
            <summary>
            Value handler for the Compartment.Title domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitlePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.Title domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitlePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitlePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitlePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.Title domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColorPropertyHandler">
            <summary>
            Value handler for the Compartment.EntryTextColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.EntryTextColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.EntryTextColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.EntryTextColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColorPropertyHandler">
            <summary>
            Value handler for the Compartment.TitleTextColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the Compartment.TitleTextColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.Compartment,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.Compartment.TitleTextColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the Compartment.TitleTextColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape">
            <summary>
            DomainClass CompartmentShape
            Defines a shape with compartments that can contain lists of single-line text
            entries.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DomainClassId">
            <summary>
            CompartmentShape domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.GeometryDomainPropertyId">
            <summary>
            Geometry domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.geometryPropertyStorage">
            <summary>
            Storage for Geometry
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleDomainPropertyId">
            <summary>
            IsSingleCompartmentHeaderVisible domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.isSingleCompartmentHeaderVisiblePropertyStorage">
            <summary>
            Storage for IsSingleCompartmentHeaderVisible
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseStateDomainPropertyId">
            <summary>
            DefaultExpandCollapseState domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.defaultExpandCollapseStatePropertyStorage">
            <summary>
            Storage for DefaultExpandCollapseState
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.Geometry">
            <summary>
            Gets or sets the value of Geometry domain property.
            Outline geometry of this shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisible">
            <summary>
            Gets or sets the value of IsSingleCompartmentHeaderVisible domain property.
            If False and the shape has a single compartment, the header of the compartment
            is not visible.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseState">
            <summary>
            Gets or sets the value of DefaultExpandCollapseState domain property.
            If Expanded, the compartments are shown on creation. If Collapsed, they are not.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.Compartments">
            <summary>
            Gets a list of Compartments.
            Compartments defined by the compartment shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base compartment shape of this compartment shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.GeometryPropertyHandler">
            <summary>
            Value handler for the CompartmentShape.Geometry domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.GeometryPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the CompartmentShape.Geometry domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.GeometryPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.GeometryPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape,Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShapeGeometry)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.GeometryPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the CompartmentShape.Geometry domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisiblePropertyHandler">
            <summary>
            Value handler for the CompartmentShape.IsSingleCompartmentHeaderVisible domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisiblePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the CompartmentShape.IsSingleCompartmentHeaderVisible domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisiblePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisiblePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape,System.Boolean)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.IsSingleCompartmentHeaderVisiblePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the CompartmentShape.IsSingleCompartmentHeaderVisible domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseStatePropertyHandler">
            <summary>
            Value handler for the CompartmentShape.DefaultExpandCollapseState domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseStatePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the CompartmentShape.DefaultExpandCollapseState domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseStatePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseStatePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape,Microsoft.VisualStudio.Modeling.DslDefinition.ExpandCollapseState)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.CompartmentShape.DefaultExpandCollapseStatePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the CompartmentShape.DefaultExpandCollapseState domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape">
            <summary>
            DomainClass ImageShape
            Defines a shape that displays an image.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.DomainClassId">
            <summary>
            ImageShape domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.ImageDomainPropertyId">
            <summary>
            Image domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.imagePropertyStorage">
            <summary>
            Storage for Image
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.Image">
            <summary>
            Gets or sets the value of Image domain property.
            Path to the image file to be used for this image shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base image shape of this image shape.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.SubClasses">
            <summary>
            Gets a list of SubClasses.
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.ImageShapeHasBaseImageShape.BaseImageShape
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.ImagePropertyHandler">
            <summary>
            Value handler for the ImageShape.Image domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.ImagePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the ImageShape.Image domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.ImagePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.ImagePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.ImageShape.ImagePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the ImageShape.Image domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator">
            <summary>
            DomainClass IconDecorator
            Defines a decorator that displays an icon or image.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DomainClassId">
            <summary>
            IconDecorator domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIconDomainPropertyId">
            <summary>
            DefaultIcon domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.defaultIconPropertyStorage">
            <summary>
            Storage for DefaultIcon
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIcon">
            <summary>
            Gets or sets the value of DefaultIcon domain property.
            Path to the icon or image file to be displayed by default.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIconPropertyHandler">
            <summary>
            Value handler for the IconDecorator.DefaultIcon domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIconPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the IconDecorator.DefaultIcon domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIconPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIconPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.IconDecorator.DefaultIconPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the IconDecorator.DefaultIcon domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.ExpandCollapseDecorator">
            <summary>
            DomainClass ExpandCollapseDecorator
            Special decorator used for showing and hiding the compartments or subshapes of a
            shape.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.ExpandCollapseDecorator.DomainClassId">
            <summary>
            ExpandCollapseDecorator domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExpandCollapseDecorator.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.ExpandCollapseDecorator.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter">
            <summary>
            DomainClass PropertyFilter
            Defines a filter for a domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.DomainClassId">
            <summary>
            PropertyFilter domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValueDomainPropertyId">
            <summary>
            FilteringValue domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.filteringValuePropertyStorage">
            <summary>
            Storage for FilteringValue
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValue">
            <summary>
            Gets or sets the value of FilteringValue domain property.
            The value for which the filter returns true.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.VisibilityPropertyPath">
            <summary>
            Gets or sets VisibilityPropertyPath.
            Visibility property path defining the filter.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValuePropertyHandler">
            <summary>
            Value handler for the PropertyFilter.FilteringValue domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValuePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the PropertyFilter.FilteringValue domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValuePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValuePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter,System.String)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyFilter.FilteringValuePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the PropertyFilter.FilteringValue domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.VisibilityPropertyPath">
            <summary>
            DomainClass VisibilityPropertyPath
            Defines a property path used to determine whether an element such as a decorator
            is visible or not.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.VisibilityPropertyPath.DomainClassId">
            <summary>
            VisibilityPropertyPath domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.VisibilityPropertyPath.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.VisibilityPropertyPath.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.VisibilityPropertyPath.PropertyFilters">
            <summary>
            Gets a list of PropertyFilters.
            Property values used for filtering.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane">
            <summary>
            DomainClass SwimLane
            Defines a swimlane.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.DomainClassId">
            <summary>
            SwimLane domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColorDomainPropertyId">
            <summary>
            HeaderFillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.headerFillColorPropertyStorage">
            <summary>
            Storage for HeaderFillColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStyleDomainPropertyId">
            <summary>
            SeparatorLineStyle domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.separatorLineStylePropertyStorage">
            <summary>
            Storage for SeparatorLineStyle
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColorDomainPropertyId">
            <summary>
            SeparatorColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.separatorColorPropertyStorage">
            <summary>
            Storage for SeparatorColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColorDomainPropertyId">
            <summary>
            BodyFillColor domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.bodyFillColorPropertyStorage">
            <summary>
            Storage for BodyFillColor
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidthDomainPropertyId">
            <summary>
            InitialWidth domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.initialWidthPropertyStorage">
            <summary>
            Storage for InitialWidth
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeightDomainPropertyId">
            <summary>
            InitialHeight domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.initialHeightPropertyStorage">
            <summary>
            Storage for InitialHeight
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.AlignmentDomainPropertyId">
            <summary>
            Alignment domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.alignmentPropertyStorage">
            <summary>
            Storage for Alignment
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThicknessDomainPropertyId">
            <summary>
            SeparatorThickness domain property Id.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.separatorThicknessPropertyStorage">
            <summary>
            Storage for SeparatorThickness
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.CanMerge(Microsoft.VisualStudio.Modeling.ProtoElementBase,Microsoft.VisualStudio.Modeling.ElementGroupPrototype)">
            <summary>
            Returns a value indicating whether the source element represented by the
            specified root ProtoElement can be added to this element.
            </summary>
            <param name="rootElement">
            The root ProtoElement representing a source element.  This can be null, 
            in which case the ElementGroupPrototype does not contain an ProtoElements
            and the code should inspect the ElementGroupPrototype context information.
            </param>
            <param name="elementGroupPrototype">The ElementGroupPrototype that contains the root ProtoElement.</param>
            <returns>true if the source element represented by the ProtoElement can be added to this target element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.MergeRelate(Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementGroup)">
            <summary>
            Called by the Merge process to create a relationship between 
            this target element and the specified source element. 
            Typically, a parent-child relationship is established
            between the target element (the parent) and the source element 
            (the child), but any relationship can be established.
            </summary>
            <param name="sourceElement">The element that is to be related to this model element.</param>
            <param name="elementGroup">The group of source ModelElements that have been rehydrated into the target store.</param>
            <remarks>
            This method is overriden to create the relationship between the target element and the specified source element.
            The base method does nothing.
            </remarks>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.MergeDisconnect(Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Performs operation opposite to MergeRelate - i.e. disconnects a given
            element from the current one (removes links created by MergeRelate).
            </summary>
            <param name="sourceElement">Element to be unmerged/disconnected.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColor">
            <summary>
            Gets or sets the value of HeaderFillColor domain property.
            Fill color for the header of the swimlane.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStyle">
            <summary>
            Gets or sets the value of SeparatorLineStyle domain property.
            Style of the separator line.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColor">
            <summary>
            Gets or sets the value of SeparatorColor domain property.
            Color of the separator line.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColor">
            <summary>
            Gets or sets the value of BodyFillColor domain property.
            Fill color for the body of the swimlane.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidth">
            <summary>
            Gets or sets the value of InitialWidth domain property.
            Initial width of this swimlane, in inches. Only applicable to vertical
            swimlanes.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeight">
            <summary>
            Gets or sets the value of InitialHeight domain property.
            Initial height of this swimlane, in inches. Only applicable to horizontal
            swimlanes.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.Alignment">
            <summary>
            Gets or sets the value of Alignment domain property.
            Whether the swimlane is horizontally or vertically aligned.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThickness">
            <summary>
            Gets or sets the value of SeparatorThickness domain property.
            Thickness of the separator line.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.Decorators">
            <summary>
            Gets a list of Decorators.
            Decorators defined by the swimlane.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BaseClass">
            <summary>
            Gets or sets BaseClass.
            Base swimlane of this swimlane.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SubClasses">
            <summary>
            Gets a list of SubClasses.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColorPropertyHandler">
            <summary>
            Value handler for the SwimLane.HeaderFillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.HeaderFillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.HeaderFillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.HeaderFillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStylePropertyHandler">
            <summary>
            Value handler for the SwimLane.SeparatorLineStyle domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStylePropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.SeparatorLineStyle domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStylePropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStylePropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Drawing.Drawing2D.DashStyle)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorLineStylePropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.SeparatorLineStyle domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColorPropertyHandler">
            <summary>
            Value handler for the SwimLane.SeparatorColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.SeparatorColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.SeparatorColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColorPropertyHandler">
            <summary>
            Value handler for the SwimLane.BodyFillColor domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColorPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.BodyFillColor domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColorPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColorPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Drawing.Color)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.BodyFillColorPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.BodyFillColor domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidthPropertyHandler">
            <summary>
            Value handler for the SwimLane.InitialWidth domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidthPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.InitialWidth domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidthPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidthPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialWidthPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.InitialWidth domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeightPropertyHandler">
            <summary>
            Value handler for the SwimLane.InitialHeight domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeightPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.InitialHeight domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeightPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeightPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.InitialHeightPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.InitialHeight domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.AlignmentPropertyHandler">
            <summary>
            Value handler for the SwimLane.Alignment domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.AlignmentPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.Alignment domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.AlignmentPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.AlignmentPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,Microsoft.VisualStudio.Modeling.Diagrams.SwimlaneAlignment)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.AlignmentPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.Alignment domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThicknessPropertyHandler">
            <summary>
            Value handler for the SwimLane.SeparatorThickness domain property.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThicknessPropertyHandler.Instance">
            <summary>
            Gets the singleton instance of the SwimLane.SeparatorThickness domain property value handler.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThicknessPropertyHandler.GetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane)">
            <summary>
            Gets a strongly-typed value of the property on specified element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <returns>Property value.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThicknessPropertyHandler.SetValue(Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane,System.Double)">
            <summary>
            Sets property value on an element.
            </summary>
            <param name="element">Element which owns the property.</param>
            <param name="newValue">New property value.</param>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.SwimLane.SeparatorThicknessPropertyHandler.DomainPropertyId">
            <summary>
            Gets the Id of the SwimLane.SeparatorThickness domain property.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree">
            <summary>
            DomainClass DslDesignerDiagramTree
            Defines the tree structure for a diagram representing a DSL definition.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.DomainClassId">
            <summary>
            DslDesignerDiagramTree domain class Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.#ctor(Microsoft.VisualStudio.Modeling.Store,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="store">Store where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.#ctor(Microsoft.VisualStudio.Modeling.Partition,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Constructor
            </summary>
            <param name="partition">Partition where new element is to be created.</param>
            <param name="propertyAssignments">List of domain property id/value pairs to set once the element is created.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.TreeContainsClass(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Find out if a reference type is already represented in a tree
            </summary>
            <param name="candidate"></param>
            <param name="notLeaf">Only return true if the reference type already has a non-leaf stored in the tree; leaves are ignored</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.GetNodeFromClass(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass,System.Boolean)">
            <summary>
            Find a node containing a class within a tree
            </summary>
            <param name="candidate"></param>
            <param name="notLeaf">Only return a node if the reference type already has a non-leaf stored in the tree; leaves are ignored</param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.GetNodesFromSubject(Microsoft.VisualStudio.Modeling.DslDefinition.DomainClass)">
            <summary>
            Find all nodes containing a class within a tree
            </summary>
            <param name="candidate"></param>
            <returns></returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.GetTreeFromNode(Microsoft.VisualStudio.Modeling.DslDesigner.TreeNode)">
            <summary>
            Get the tree the node is part of
            </summary>
            <param name="node"></param>
            <returns>The containing tree</returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.Roots">
            <summary>
            Gets a list of Roots.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.DiagramState">
            <summary>
            Gets or sets DiagramState.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDesigner.DslDesignerDiagramTree.Arcs">
            <summary>
            Gets a list of Arcs.
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel">
            <summary>
            DomainModel DslDefinitionModelDomainModel
            Definition of the Dsl Designer.
            </summary>
            <summary>
            DomainModel class for DomainDomainModel
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.ResourceBaseName">
            <summary>
            The base name of this model's resources.
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.DomainModelId">
            <summary>
            DslDefinitionModelDomainModel domain model Id.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.#ctor(Microsoft.VisualStudio.Modeling.Store)">
            <summary>
            Constructor.
            </summary>
            <param name="store">Store containing the domain model.</param>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.GetGeneratedDomainModelTypes">
            <summary>
            Gets the list of generated domain model types (classes, rules, relationships).
            </summary>
            <returns>List of types.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.GetGeneratedDomainProperties">
            <summary>
            Gets the list of generated domain properties.
            </summary>
            <returns>List of property data.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.GetGeneratedDomainRoles">
            <summary>
            Gets the list of generated domain roles.
            </summary>
            <returns>List of role data.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.CreateElement(Microsoft.VisualStudio.Modeling.Partition,System.Type,Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Creates an element of specified type.
            </summary>
            <param name="partition">Partition where element is to be created.</param>
            <param name="elementType">Element type which belongs to this domain model.</param>
            <param name="propertyAssignments">New element property assignments.</param>
            <returns>Created element.</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.CreateElementLink(Microsoft.VisualStudio.Modeling.Partition,System.Type,Microsoft.VisualStudio.Modeling.RoleAssignment[],Microsoft.VisualStudio.Modeling.PropertyAssignment[])">
            <summary>
            Creates an element link of specified type.
            </summary>
            <param name="partition">Partition where element is to be created.</param>
            <param name="elementLinkType">Element link type which belongs to this domain model.</param>
            <param name="roleAssignments">List of relationship role assignments for the new link.</param>
            <param name="propertyAssignments">New element property assignments.</param>
            <returns>Created element link.</returns>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.copyClosure">
            <summary>
            CopyClosure cache
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.removeClosure">
            <summary>
            DeleteClosure cache
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.GetClosureFilter(Microsoft.VisualStudio.Modeling.ClosureType,System.Collections.Generic.ICollection{Microsoft.VisualStudio.Modeling.ModelElement})">
            <summary>
            Returns an IElementVisitorFilter that corresponds to the ClosureType.
            </summary>
            <param name="type">closure type</param>
            <param name="rootElements">collection of root elements</param>
            <returns>IElementVisitorFilter or null</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.EnableDiagramRules(Microsoft.VisualStudio.Modeling.Store)">
            <summary>
            Enables rules in this domain model related to diagram fixup for the given store.
            If diagram data will be loaded into the store, this method should be called first to ensure
            that the diagram behaves properly.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.DisableDiagramRules(Microsoft.VisualStudio.Modeling.Store)">
            <summary>
            Disables rules in this domain model related to diagram fixup for the given store.
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.GetCustomDomainModelTypes">
            <summary>
            Override to add the fake ModelElementDomainClass.
            </summary>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.ResourceManager">
            <summary>
            Gets the DomainModel's ResourceManager. If the ResourceManager does not already exist, then it is created.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.SingletonResourceManager">
            <summary>
            Gets the Singleton ResourceManager for this domain model.
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.CopyClosure">
            <summary>
            CopyClosure cache
            </summary>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDomainModel.DeleteClosure">
            <summary>
            DeleteClosure cache
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosure">
            <summary>
            Remove closure visitor filter
            </summary>
            <summary>
            This is a VisitorFilter that is usually invoked by the BreadthFirstRolePlayerFirstElementWalker as the result
            of a user deleting a ModelElement.  The walker traverses the tree of relationships with DSL attribute 
            PropagatesDelete true, and as it visits each node the walker adds that element to the list of elements to be 
            deleted (the closure), then examines all associated links for more candidates.  In this way the single action 
            of deleting a DomanRelationship is extended to delete associated DomainRoles, various Shapes, and the Links 
            connecting them.
            </summary>
            <remarks>
            Class is defined in ..\GeneratedCode\DomainModel.cs, which is generated from the DSL Definition model.
            </remarks>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosureBase">
            <summary>
            Base class for remove closure visitor filter
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosureBase.domainRoles">
            <summary>
            DomainRoles
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosureBase.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosureBase.ShouldVisitRelationship(Microsoft.VisualStudio.Modeling.ElementWalker,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainRoleInfo,Microsoft.VisualStudio.Modeling.DomainRelationshipInfo,Microsoft.VisualStudio.Modeling.ElementLink)">
            <summary>
            Called to ask the filter if a particular relationship from a source element should be included in the traversal
            </summary>
            <param name="walker">ElementWalker that is traversing the model</param>
            <param name="sourceElement">Model Element playing the source role</param>
            <param name="sourceRoleInfo">DomainRoleInfo of the role that the source element is playing in the relationship</param>
            <param name="domainRelationshipInfo">DomainRelationshipInfo for the ElementLink in question</param>
            <param name="targetRelationship">Relationship in question</param>
            <returns>Yes if the relationship should be traversed</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosureBase.ShouldVisitRolePlayer(Microsoft.VisualStudio.Modeling.ElementWalker,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementLink,Microsoft.VisualStudio.Modeling.DomainRoleInfo,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Called to ask the filter if a particular role player should be Visited during traversal
            </summary>
            <param name="walker">ElementWalker that is traversing the model</param>
            <param name="sourceElement">Model Element playing the source role</param>
            <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
            <param name="targetDomainRole">DomainRoleInfo of the target role</param>
            <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosureBase.DomainRoles">
            <summary>
            DomainRoles
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosure.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelDeleteClosure.ShouldVisitRolePlayer(Microsoft.VisualStudio.Modeling.ElementWalker,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementLink,Microsoft.VisualStudio.Modeling.DomainRoleInfo,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            This method is called to ask the filter if a particular role player associated with an ElementLink should 
            be Visited during traversal. This overrides the generated ShouldVisitRolePlayer() method, which examines 
            the PropagateDelete attribute on the ElementLink to decide whether to visit the associated role players. 
            In this case the RelationshipPort, the shape drawn as a little square where a relationship is connected to 
            a class, was not deleted with the relationship. The reason is that the link used to connect the 
            RelationshipPort (a shape) to the RoleConnector (also a shape) is a subtype of ElementLink called 
            LinkConnectsToNode. Instances of this link type are used to associate various NodeShapes with LinkShapes 
            and so do not propagate deletes, although in the case of the RelationshipPort it should. The same problem 
            existed for InheritancePort, which like RelationshipPort extends TogglePort.
            
            This method is called for every ElementLink visited during a delete. If the link in question is an
            instance of LinkConnectsToNode and the roleplayer is a TogglePort, then the port shape may not be needed
            anymore. By checking how many links are left to the target role player this method returns 
            VisitorFilterResult.YES if there is exactly one link to the port, VisitorFilterResult.DoNotCare otherwise.
            This ensures that when the last link to the node is deleted the port shape is deleted as well.
            </summary>
            <param name="walker">ElementWalker that is traversing the model</param>
            <param name="sourceElement">Model Element playing the source role</param>
            <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
            <param name="targetDomainRole">DomainRoleInfo of the target role</param>
            <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
            <returns></returns>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosure">
            <summary>
            Copy closure visitor filter
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosureBase">
            <summary>
            Base class for copy closure visitor filter
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosureBase.domainRoles">
            <summary>
            DomainRoles
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosureBase.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosureBase.ShouldVisitRelationship(Microsoft.VisualStudio.Modeling.ElementWalker,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.DomainRoleInfo,Microsoft.VisualStudio.Modeling.DomainRelationshipInfo,Microsoft.VisualStudio.Modeling.ElementLink)">
            <summary>
            Called to ask the filter if a particular relationship from a source element should be included in the traversal
            </summary>
            <param name="walker">ElementWalker traversing the model</param>
            <param name="sourceElement">Model Element playing the source role</param>
            <param name="sourceRoleInfo">DomainRoleInfo of the role that the source element is playing in the relationship</param>
            <param name="domainRelationshipInfo">DomainRelationshipInfo for the ElementLink in question</param>
            <param name="targetRelationship">Relationship in question</param>
            <returns>Yes if the relationship should be traversed</returns>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosureBase.ShouldVisitRolePlayer(Microsoft.VisualStudio.Modeling.ElementWalker,Microsoft.VisualStudio.Modeling.ModelElement,Microsoft.VisualStudio.Modeling.ElementLink,Microsoft.VisualStudio.Modeling.DomainRoleInfo,Microsoft.VisualStudio.Modeling.ModelElement)">
            <summary>
            Called to ask the filter if a particular role player should be Visited during traversal
            </summary>
            <param name="walker">ElementWalker traversing the model</param>
            <param name="sourceElement">Model Element playing the source role</param>
            <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
            <param name="targetDomainRole">DomainRoleInfo of the target role</param>
            <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
            <returns></returns>
        </member>
        <member name="P:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosureBase.DomainRoles">
            <summary>
            DomainRoles
            </summary>
        </member>
        <member name="M:Microsoft.VisualStudio.Modeling.DslDefinition.DslDefinitionModelCopyClosure.#ctor">
            <summary>
            Constructor
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier">
            <summary>
            DomainEnumeration: AccessModifier
            Description for Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Public">
            <summary>
            Public
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Public
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Assembly">
            <summary>
            Assembly
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Assembly
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Private">
            <summary>
            Private
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Private
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Family">
            <summary>
            Family
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.Family
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.FamilyOrAssembly">
            <summary>
            FamilyOrAssembly
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.AccessModifier.FamilyOrAssembly
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier">
            <summary>
            DomainEnumeration: TypeAccessModifier
            Description for Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier.Public">
            <summary>
            Public
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier.Public
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier.Assembly">
            <summary>
            Assembly
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.TypeAccessModifier.Assembly
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier">
            <summary>
            DomainEnumeration: InheritanceModifier
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier.None">
            <summary>
            None
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier.None
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier.Abstract">
            <summary>
            Abstract
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier.Abstract
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier.Sealed">
            <summary>
            Sealed
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.InheritanceModifier.Sealed
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind">
            <summary>
            DomainEnumeration: PropertyKind
            Description for Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind.Normal">
            <summary>
            Normal
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind.Normal
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind.Calculated">
            <summary>
            Calculated
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind.Calculated
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind.CustomStorage">
            <summary>
            CustomStorage
            Description for
            Microsoft.VisualStudio.Modeling.DslDefinition.PropertyKind.CustomStorage
            </summary>
        </member>
        <member name="T:Microsoft.VisualStudio.Modeling.DslDefinition.Multiplicity">
            <summary>
            DomainEnumeration: Multiplicity
            Description for Microsoft.VisualStudio.Modeling.DslDefinition.Multiplicity
            </summary>
        </member>
        <member name="F:Microsoft.VisualStudio.Modeling.DslDefinition.Multiplicity.ZeroMany">
            <summary>
        