/***************************************************************************

Copyright (c) Microsoft Corporation. All rights reserved.
This code is licensed under the Visual Studio SDK license terms.
THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.

This code is a part of the Visual Studio Library.

***************************************************************************/

#ifndef IDEBUGBREAKPOINTCHECKSUMREQUEST2_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
#define IDEBUGBREAKPOINTCHECKSUMREQUEST2_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5

#if _MSC_VER > 1000
#pragma once
#endif

#include "msdbg.h"

#pragma warning(push)
#pragma warning(disable : 4510) // default constructor could not be generated
#pragma warning(disable : 4610) // can never be instantiated - user defined constructor required
#pragma warning(disable : 4512) // assignment operator could not be generated
#pragma warning(disable : 6011) // Dereferencing NULL pointer (a NULL derference is just another kind of failure for a unit test

namespace VSL
{

class IDebugBreakpointChecksumRequest2NotImpl :
	public IDebugBreakpointChecksumRequest2
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IDebugBreakpointChecksumRequest2NotImpl)

public:

	typedef IDebugBreakpointChecksumRequest2 Interface;

	STDMETHOD(GetChecksum)(
		/*[in]*/ REFGUID /*guidAlgorithm*/,
		/*[out]*/ CHECKSUM_DATA* /*pChecksumData*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(IsChecksumEnabled)(
		/*[out]*/ BOOL* /*pfChecksumEnabled*/)VSL_STDMETHOD_NOTIMPL
};

class IDebugBreakpointChecksumRequest2MockImpl :
	public IDebugBreakpointChecksumRequest2,
	public MockBase
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IDebugBreakpointChecksumRequest2MockImpl)

public:

VSL_DEFINE_MOCK_CLASS_TYPDEFS(IDebugBreakpointChecksumRequest2MockImpl)

	typedef IDebugBreakpointChecksumRequest2 Interface;
	struct GetChecksumValidValues
	{
		/*[in]*/ REFGUID guidAlgorithm;
		/*[out]*/ CHECKSUM_DATA* pChecksumData;
		HRESULT retValue;
	};

	STDMETHOD(GetChecksum)(
		/*[in]*/ REFGUID guidAlgorithm,
		/*[out]*/ CHECKSUM_DATA* pChecksumData)
	{
		VSL_DEFINE_MOCK_METHOD(GetChecksum)

		VSL_CHECK_VALIDVALUE(guidAlgorithm);

		VSL_SET_VALIDVALUE(pChecksumData);

		VSL_RETURN_VALIDVALUES();
	}
	struct IsChecksumEnabledValidValues
	{
		/*[out]*/ BOOL* pfChecksumEnabled;
		HRESULT retValue;
	};

	STDMETHOD(IsChecksumEnabled)(
		/*[out]*/ BOOL* pfChecksumEnabled)
	{
		VSL_DEFINE_MOCK_METHOD(IsChecksumEnabled)

		VSL_SET_VALIDVALUE(pfChecksumEnabled);

		VSL_RETURN_VALIDVALUES();
	}
};


} // namespace VSL

#pragma warning(pop)

#endif // IDEBUGBREAKPOINTCHECKSUMREQUEST2_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
