/***************************************************************************

Copyright (c) Microsoft Corporation. All rights reserved.
This code is licensed under the Visual Studio SDK license terms.
THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.

This code is a part of the Visual Studio Library.

***************************************************************************/

#ifndef IVSCOMPOUNDACTION_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
#define IVSCOMPOUNDACTION_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5

#if _MSC_VER > 1000
#pragma once
#endif

#include "textmgr.h"

#pragma warning(push)
#pragma warning(disable : 4510) // default constructor could not be generated
#pragma warning(disable : 4610) // can never be instantiated - user defined constructor required
#pragma warning(disable : 4512) // assignment operator could not be generated
#pragma warning(disable : 6011) // Dereferencing NULL pointer (a NULL derference is just another kind of failure for a unit test

namespace VSL
{

class IVsCompoundActionNotImpl :
	public IVsCompoundAction
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IVsCompoundActionNotImpl)

public:

	typedef IVsCompoundAction Interface;

	STDMETHOD(OpenCompoundAction)(
		/*[in]*/ const WCHAR* /*pszDescription*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(AbortCompoundAction)()VSL_STDMETHOD_NOTIMPL

	STDMETHOD(CloseCompoundAction)()VSL_STDMETHOD_NOTIMPL

	STDMETHOD(FlushEditActions)()VSL_STDMETHOD_NOTIMPL
};

class IVsCompoundActionMockImpl :
	public IVsCompoundAction,
	public MockBase
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IVsCompoundActionMockImpl)

public:

VSL_DEFINE_MOCK_CLASS_TYPDEFS(IVsCompoundActionMockImpl)

	typedef IVsCompoundAction Interface;
	struct OpenCompoundActionValidValues
	{
		/*[in]*/ WCHAR* pszDescription;
		HRESULT retValue;
	};

	STDMETHOD(OpenCompoundAction)(
		/*[in]*/ const WCHAR* pszDescription)
	{
		VSL_DEFINE_MOCK_METHOD(OpenCompoundAction)

		VSL_CHECK_VALIDVALUE_STRINGW(pszDescription);

		VSL_RETURN_VALIDVALUES();
	}
	struct AbortCompoundActionValidValues
	{
		HRESULT retValue;
	};

	STDMETHOD(AbortCompoundAction)()
	{
		VSL_DEFINE_MOCK_METHOD_NOARGS(AbortCompoundAction)

		VSL_RETURN_VALIDVALUES();
	}
	struct CloseCompoundActionValidValues
	{
		HRESULT retValue;
	};

	STDMETHOD(CloseCompoundAction)()
	{
		VSL_DEFINE_MOCK_METHOD_NOARGS(CloseCompoundAction)

		VSL_RETURN_VALIDVALUES();
	}
	struct FlushEditActionsValidValues
	{
		HRESULT retValue;
	};

	STDMETHOD(FlushEditActions)()
	{
		VSL_DEFINE_MOCK_METHOD_NOARGS(FlushEditActions)

		VSL_RETURN_VALIDVALUES();
	}
};


} // namespace VSL

#pragma warning(pop)

#endif // IVSCOMPOUNDACTION_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
