/***************************************************************************

Copyright (c) Microsoft Corporation. All rights reserved.
This code is licensed under the Visual Studio SDK license terms.
THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.

***************************************************************************/

using System.Diagnostics.CodeAnalysis;

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project. Project-level
// suppressions either have no target or are given a specific target
// and scoped to a namespace, type, member, etc.
//
// To add a suppression to this file, right-click the message in the
// Error List, point to "Suppress Message(s)", and click "In Project
// Suppression File". You do not need to add suppressions to this
// file manually.

// The below contains suppressions from LinkDemand occurring from calls to the Marshal type's methods.
// Calls to these methods are absolute necessary to do successful VS integration. 
// All these methods are called from the VS Kernel, through interface calls that are expanded in the below methods. 
// Some of the below methods are non public but their caller's then are methods that are VS Integration interface implementations.
// The methods in which the LinkDemands were suppressed should be revisited though if adding further LinkDemands or directly Demanding UnmanagedCode Permission is a better choice.

[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ConfigProvider.#AddCfgsOfCfgName(System.String,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ConfigProvider.#DeleteCfgsOfCfgName(System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.DocumentManager.#RenameDocument(System.IServiceProvider,System.String,System.String,System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.DocumentManager.#UpdateCaption(System.IServiceProvider,System.String,System.IntPtr)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileDocumentManager.#Open(System.Boolean,System.Boolean,System.Guid,Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame&,Microsoft.VisualStudio.Package.WindowFrameShowAction)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileNode.#RenameDocument(System.String,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileNode.#SetEditLabel(System.String,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#AddNewFolder()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#CloseDocumentWindow(Microsoft.VisualStudio.Package.HierarchyNode)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#DisplayContextMenu(System.Collections.Generic.IList`1<Microsoft.VisualStudio.Package.HierarchyNode>,System.IntPtr)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#GetOuterHierarchy(Microsoft.VisualStudio.Package.HierarchyNode)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#GetProperty(System.Int32)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#IsItemDirty(System.UInt32,System.IntPtr,System.Int32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#Remove(System.Boolean)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#SaveItem(Microsoft.VisualStudio.Shell.Interop.VSSAVEFLAGS,System.String,System.UInt32,System.IntPtr,System.Int32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ImageHandler.#GetIconHandle(System.Int32)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#Init(System.String,System.String,System.String,Microsoft.VisualStudio.Shell.Interop.__VSCREATEPROJFLAGS)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#IsItemDirty(System.UInt32,System.IntPtr,System.Int32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#LockRDTEntry()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#RenameNestedProjectInParentProject(System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#SaveItem(Microsoft.VisualStudio.Shell.Interop.VSSAVEFLAGS,System.String,System.UInt32,System.IntPtr,System.Int32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.OleServiceProvider.#QueryService(System.Guid&,System.Guid&,System.IntPtr&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectConfig.#.ctor(Microsoft.VisualStudio.Package.ProjectNode,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectConfig.#DebugLaunch(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectConfig.#Microsoft.VisualStudio.Shell.Interop.IVsProjectFlavorCfg.get_CfgType(System.Guid&,System.IntPtr&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectConfig.#SetConfigurationProperty(System.String,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#CloseChildren()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#GetNestedHierarchy(System.UInt32,System.Guid&,System.IntPtr&,System.UInt32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#OpenChildren()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectElement.#ItemName")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectElement.#SetMetadata(System.String,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectFactory.#CreateProject(System.String,System.String,System.String,System.UInt32,System.Guid&,System.IntPtr&,System.Int32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AddComponent(Microsoft.VisualStudio.Shell.Interop.VSADDCOMPOPERATION,System.UInt32,System.IntPtr[],System.IntPtr,Microsoft.VisualStudio.Shell.Interop.VSADDCOMPRESULT[])")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AddItemWithSpecific(System.UInt32,Microsoft.VisualStudio.Shell.Interop.VSADDITEMOPERATION,System.String,System.UInt32,System.String[],System.IntPtr,System.UInt32,System.Guid&,System.String,System.Guid&,Microsoft.VisualStudio.Shell.Interop.VSADDRESULT[])")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AddProjectReference()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AllowPasteCommand()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#CleanAndFlushClipboard()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#CopyToClipboard()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#GetOutputAssembly(System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#GetProjectOptions(System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#GetSelectedNodes()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#InitializeForOuter(System.String,System.String,System.String,System.UInt32,System.Guid&,System.IntPtr&,System.Int32&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#PackageSelectionData(System.Text.StringBuilder,System.Boolean)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#PrepareBuild(System.String,System.Boolean)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#SetOutputLogger(Microsoft.VisualStudio.Shell.Interop.IVsOutputWindowPane)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#SetProjectProperty(System.String,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#TransferItem(System.String,System.String,Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#.ctor()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ReferenceContainerNode.#AddReferenceFromSelectorData(Microsoft.VisualStudio.Shell.Interop.VSCOMPONENTSELECTORDATA)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.SingleFileGeneratorFactory.#CreateGeneratorInstance(System.String,System.Int32&,System.Int32&,System.Int32&,Microsoft.VisualStudio.Shell.Interop.IVsSingleFileGenerator&)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.SuspendFileChanges.#Suspend()")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.SettingsPage.#GetPageInfo(Microsoft.VisualStudio.OLE.Interop.PROPPAGEINFO[])")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.Utilities.#GetImageList(System.Object)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.Utilities.#IsSameComObject(System.Object,System.Object)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.Utilities.#QueryInterfaceIUnknown(System.Object)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#DoSave(System.Boolean,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#Open(System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#DoSave(System.Boolean,System.String)")]
[assembly: SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#RenameProjectFile(System.String)")]

//The following suppressions will baseline the FxCop Errors in MPF Project sources
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods.#GetLocalPath(System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods.#SignedHIWORD(System.Int32)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods.#SignedLOWORD(System.Int32)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.NativeMethods+ConnectionPointCookie", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods+ConnectionPointCookie.#.ctor(System.Object,System.Object,System.Type,System.Boolean)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.NativeMethods+DataStreamFromComStream", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.NativeMethods+LOGFONT", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods+OLECMDTEXT.#GetFlags(System.IntPtr)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods+OLECMDTEXT.#GetText(System.IntPtr)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.NativeMethods+OLECMDTEXT.#SetText(System.IntPtr,System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.NativeMethods+OleComponentUIManager", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.NativeMethods+StreamConsts", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.UnsafeNativeMethods.#GlobalLock(System.Runtime.InteropServices.HandleRef)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Portability", "CA1901:PInvokeDeclarationsShouldBePortable", Scope = "member", Target = "Microsoft.VisualStudio.UnsafeNativeMethods.#GlobalSize(System.IntPtr)", MessageId = "return")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.UnsafeNativeMethods.#GlobalSize(System.Runtime.InteropServices.HandleRef)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Portability", "CA1901:PInvokeDeclarationsShouldBePortable", Scope = "member", Target = "Microsoft.VisualStudio.UnsafeNativeMethods.#GlobalSize(System.Runtime.InteropServices.HandleRef)", MessageId = "return")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.UnsafeNativeMethods.#GlobalUnlock(System.Runtime.InteropServices.HandleRef)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Portability", "CA1901:PInvokeDeclarationsShouldBePortable", Scope = "member", Target = "Microsoft.VisualStudio.UnsafeNativeMethods.#RegisterClipboardFormat(System.String)", MessageId = "return")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1813:AvoidUnsealedAttributes", Scope = "type", Target = "Microsoft.VisualStudio.Package.AutomationBrowsableAttribute", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ComReferenceNode.#.ctor(Microsoft.VisualStudio.Package.ProjectNode,Microsoft.VisualStudio.Shell.Interop.VSCOMPONENTSELECTORDATA)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ConfigProvider.#NewConfigProperties", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.DataObject.#ForceCast(System.Int32)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.DocumentManager.#CloseWindowFrame(Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame&)", MessageId = "0#")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.DocumentManager.#Open(System.Guid&,System.IntPtr,Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame&,Microsoft.VisualStudio.Package.WindowFrameShowAction)", MessageId = "0#")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.DocumentManager.#OpenWithSpecific(System.UInt32,System.Guid&,System.String,System.Guid&,System.IntPtr,Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame&,Microsoft.VisualStudio.Package.WindowFrameShowAction)", MessageId = "1#")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.DocumentManager.#OpenWithSpecific(System.UInt32,System.Guid&,System.String,System.Guid&,System.IntPtr,Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame&,Microsoft.VisualStudio.Package.WindowFrameShowAction)", MessageId = "3#")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.DragDropHelper.#CreateFormatEtc()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.DragDropHelper.#FillFormatEtc(Microsoft.VisualStudio.OLE.Interop.FORMATETC&,System.UInt16,Microsoft.VisualStudio.OLE.Interop.FORMATETC&)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.DragDropHelper.#OleCopyFormatEtc(Microsoft.VisualStudio.OLE.Interop.FORMATETC&,Microsoft.VisualStudio.OLE.Interop.FORMATETC&)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.EnumDependencies.#Clone(Microsoft.VisualStudio.Shell.Interop.IVsEnumDependencies&)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsEnumDependencies.Skip(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileChangeManager.#Dispose()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsFileChangeEx.UnadviseFileChange(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileDocumentManager.#Open(System.Boolean,System.Boolean,System.Guid&,System.IntPtr,Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame&,Microsoft.VisualStudio.Package.WindowFrameShowAction)", MessageId = "2#")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileNode.#AfterSaveItemAs(System.IntPtr,System.String)", MessageId = "System.String.Trim")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileNode.#RenameCaseOnlyChange(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIHierarchyWindow.ExpandItem(Microsoft.VisualStudio.Shell.Interop.IVsUIHierarchy,System.UInt32,Microsoft.VisualStudio.Shell.Interop.EXPANDFLAGS)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileNode.#RenameCaseOnlyChange(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIShell.RefreshPropertyBrowser(System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.FileNode.#RenameFileNode(System.String,System.String,System.UInt32)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIHierarchyWindow.ExpandItem(Microsoft.VisualStudio.Shell.Interop.IVsUIHierarchy,System.UInt32,Microsoft.VisualStudio.Shell.Interop.EXPANDFLAGS)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.GlobalPropertyHandler.#GetEnvironmentDirectoryLocation()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsShell.GetProperty(System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.GlobalPropertyHandler.#SetSolutionProperties()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolution.GetSolutionInfo(System.String@,System.String@,System.String@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#CloseDocumentWindow(Microsoft.VisualStudio.Package.HierarchyNode)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IEnumRunningDocuments.Reset")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#FindNodesOfType`1(System.Collections.Generic.List`1<!!0>)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#QueryStatusOnNode(System.Guid,System.UInt32,System.IntPtr,Microsoft.VisualStudio.Package.QueryStatusResult&)", MessageId = "3#")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#SaveItem(Microsoft.VisualStudio.Shell.Interop.VSSAVEFLAGS,System.String,System.UInt32,System.IntPtr,System.Int32&)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIShell.SaveDocDataToFile(Microsoft.VisualStudio.Shell.Interop.VSSAVEFLAGS,System.Object,System.String,System.String@,System.Int32@)")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#SetGuidProperty(System.Int32,System.Guid&)", MessageId = "1#")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2233:OperationsShouldNotOverflow", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#UnadviseHierarchyEvents(System.UInt32)", MessageId = "cookie-1")]
[assembly: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "Microsoft.VisualStudio.Package.HierarchyNode.#Url", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "Microsoft.VisualStudio.Package.IBuildDependencyUpdate.#BuildDependencies", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#BuildFinishedHandler(System.Object,Microsoft.Build.Framework.BuildFinishedEventArgs)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsOutputWindowPane.OutputStringThreadSafe(System.String)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#get_ErrorString()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#get_IsLogTaskDone()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#set_IsLogTaskDone(System.Boolean)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#LogEvent(System.Object,Microsoft.Build.Framework.BuildEventArgs)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsOutputWindowPane.OutputStringThreadSafe(System.String)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#NavigateTo(System.Object,System.EventArgs)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame.GetProperty(System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#NavigateTo(System.Object,System.EventArgs)", MessageId = "Microsoft.VisualStudio.TextManager.Interop.IVsTextManager.NavigateToLineAndColumn(Microsoft.VisualStudio.TextManager.Interop.IVsTextBuffer,System.Guid@,System.Int32,System.Int32,System.Int32,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#NavigateTo(System.Object,System.EventArgs)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#ShutdownLogger()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.IDEBuildLogger.#get_WarningString()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ImageHandler.#.ctor(System.Windows.Forms.ImageList)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#DelegateGetPropertyToNested(System.Int32)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetProperty(System.UInt32,System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#GetIconHandle(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetProperty(System.UInt32,System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#Init(System.String,System.String,System.String,Microsoft.VisualStudio.Shell.Interop.__VSCREATEPROJFLAGS)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#InitializeInstanceGuid()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetGuidProperty(System.UInt32,System.Int32,System.Guid@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#InitializeInstanceGuid()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.SetGuidProperty(System.UInt32,System.Int32,System.Guid@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#InitImageHandler()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetProperty(System.UInt32,System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#OnChanged(System.Int32)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsProject3.GetMkDocument(System.UInt32,System.String@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#SaveItem(Microsoft.VisualStudio.Shell.Interop.VSSAVEFLAGS,System.String,System.UInt32,System.IntPtr,System.Int32&)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIShell.SaveDocDataToFile(Microsoft.VisualStudio.Shell.Interop.VSSAVEFLAGS,System.Object,System.String,System.String@,System.Int32@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.NestedProjectNode.#SetDocCookieOnNestedHier(System.UInt32)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.SetProperty(System.UInt32,System.Int32,System.Object)")]
[assembly: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "Microsoft.VisualStudio.Package.OleServiceProvider+ServiceCreatorCallback", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.OleServiceProvider+ServiceData.#.ctor(System.Type,System.Object,Microsoft.VisualStudio.Package.OleServiceProvider+ServiceCreatorCallback,System.Boolean)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectConfig.#IsFlavorDirty(Microsoft.VisualStudio.Shell.Interop._PersistStorageType)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IPersistXMLFragment.IsFragmentDirty(System.UInt32,System.Int32@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#ReloadNestedProjectNode(Microsoft.VisualStudio.Package.NestedProjectNode)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsFireSolutionEvents.FireOnAfterLoadProject(Microsoft.VisualStudio.Shell.Interop.IVsHierarchy)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#ReloadNestedProjectNode(Microsoft.VisualStudio.Package.NestedProjectNode)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolution.CloseSolutionElement(System.UInt32,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy,System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#ReloadNestedProjectNode(Microsoft.VisualStudio.Package.NestedProjectNode)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolution.GetProjectOfUniqueName(System.String,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#RunVsTemplateWizard(Microsoft.VisualStudio.Package.ProjectElement,System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsDetermineWizardTrust.OnWizardCompleted")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectContainerNode.#RunVsTemplateWizard(Microsoft.VisualStudio.Package.ProjectElement,System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsDetermineWizardTrust.OnWizardInitiated(System.String,System.Guid@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectDocumentsListener.#Dispose(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsTrackProjectDocuments2.UnadviseTrackProjectDocumentsEvents(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectDocumentsListener.#Init()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsTrackProjectDocuments2.AdviseTrackProjectDocumentsEvents(Microsoft.VisualStudio.Shell.Interop.IVsTrackProjectDocumentsEvents2,System.UInt32@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AddFolderFromOtherProject(System.String,Microsoft.VisualStudio.Package.HierarchyNode)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AddItemWithSpecific(System.UInt32,Microsoft.VisualStudio.Shell.Interop.VSADDITEMOPERATION,System.String,System.UInt32,System.String[],System.IntPtr,System.UInt32,System.Guid&,System.String,System.Guid&,Microsoft.VisualStudio.Shell.Interop.VSADDRESULT[])", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsFileChangeEx.IgnoreFile(System.UInt32,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#AddReferenceCouldNotBeAddedErrorMessage(System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#CleanAndFlushClipboard()", MessageId = "Microsoft.VisualStudio.UnsafeNativeMethods.CloseClipboard")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#CleanAndFlushClipboard()", MessageId = "Microsoft.VisualStudio.UnsafeNativeMethods.EmptyClipboard")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#CleanAndFlushClipboard()", MessageId = "Microsoft.VisualStudio.UnsafeNativeMethods.OleFlushClipboard")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#CreateFolderNodes(System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#GetNestedProjectForHierarchy(Microsoft.VisualStudio.Shell.Interop.IVsHierarchy)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsProject3.GetMkDocument(System.UInt32,System.String@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#get_GlobalPropetyHandler()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#IsFlavorDirty()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IPersistXMLFragment.IsFragmentDirty(System.UInt32,System.Int32@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#get_IsReadOnly()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#Load(System.String,System.String,System.String,System.UInt32,System.Guid&,System.Int32&)", MessageId = "4#")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#Microsoft.VisualStudio.Shell.Interop.IVsBuildPropertyStorage.GetItemAttribute(System.UInt32,System.String,System.String&)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#Microsoft.VisualStudio.Shell.Interop.IVsBuildPropertyStorage.SetItemAttribute(System.UInt32,System.String,System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#get_Package()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#PersistXMLFragments()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsCfg.get_DisplayName(System.String@)")]
[assembly: SuppressMessage("Microsoft.Design", "CA1030:UseEventsWhereAppropriate", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#RaiseProjectPropertyChanged(System.String,System.String,System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#RenameProjectFile(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIShell.RefreshPropertyBrowser(System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#RunWizard(Microsoft.VisualStudio.Package.HierarchyNode,System.String,System.String,System.IntPtr)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsDetermineWizardTrust.OnWizardCompleted")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#RunWizard(Microsoft.VisualStudio.Package.HierarchyNode,System.String,System.String,System.IntPtr)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsDetermineWizardTrust.OnWizardInitiated(System.String,System.Guid@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#SaveAs(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIShell.RefreshPropertyBrowser(System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#SaveAs(System.String)", MessageId = "System.String.Trim")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectNode.#SetOutputLogger(Microsoft.VisualStudio.Shell.Interop.IVsOutputWindowPane)", MessageId = "Microsoft.VisualStudio.Shell.Interop.ILocalRegistry2.GetLocalRegistryRoot(System.String@)")]
[assembly: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "Microsoft.VisualStudio.Package.ProjectNode+ImageName", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#AdditionalSearchPaths", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#AllowUnsafeCode", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#BaseAddress", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#BugReportFileName", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#CheckedArithmetic", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#CodePage", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#CompileAndExecute", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#DefinedPreProcessorSymbols", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#DisplayCommandLineHelp", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#EmitManifest", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#EncodeOutputInUTF8", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#FileAlignment", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#FullyQualifiyPaths", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#HeuristicReferenceResolution", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#IncrementalCompile", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#ModuleKind", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#NoStandardLibrary", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#Optimize", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#PDBOnly", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#RecursiveWildcard", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#ReferencedModules", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#RootNamespace", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#SuppressedWarnings", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#SuppressLogo", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#TargetPlatform", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#TargetPlatformLocation", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#UserLocaleId", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#Win32Icon", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectOptions.#XMLDocFileName", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectPackage.#ReadProjectTrustInformation()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolutionPersistence.LoadPackageUserOpts(Microsoft.VisualStudio.Shell.Interop.IVsPersistSolutionOpts,System.String)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectPackage.#SetProjectTrustLevel(System.Guid,Microsoft.VisualStudio.Package.ProjectTrustLevel)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2234:PassSystemUriObjectsInsteadOfStrings", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectReferenceNode.#.ctor(Microsoft.VisualStudio.Package.ProjectNode,Microsoft.VisualStudio.Package.ProjectElement)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.ProjectReferenceNode.#get_CanRemoveReference()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.PropertiesEditorLauncher.#EditComponent(System.ComponentModel.ITypeDescriptorContext,System.Object)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsPropertyPageFrame.ReportError(System.Int32)")]
[assembly: SuppressMessage("Microsoft.Design", "CA1019:DefineAccessorsForAttributeArguments", Scope = "type", Target = "Microsoft.VisualStudio.Package.PropertyPageTypeConverterAttribute", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.ReferenceContainerNode.#CreateFileComponent(Microsoft.VisualStudio.Shell.Interop.VSCOMPONENTSELECTORDATA)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1819:PropertiesShouldNotReturnArrays", Scope = "member", Target = "Microsoft.VisualStudio.Package.ReferenceContainerNode.#SupportedReferenceTypes", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.ReferenceNode.#ShowReferenceAlreadyExistMessage()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.RegisteredProjectType.#get_PackageGuidValue()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.RegisteredProjectType.#get_ProjectTemplatesDirValue()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SecurityWarningDialog.#SetupComponents()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIShell.GetAppName(System.String@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SelectionListener.#Dispose(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsMonitorSelection.UnadviseSelectionEvents(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SelectionListener.#Init()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsMonitorSelection.AdviseSelectionEvents(Microsoft.VisualStudio.Shell.Interop.IVsSelectionEvents,System.UInt32@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SettingsPage.#SetObjects(System.UInt32,System.Object[])", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsCfgProvider.GetCfgs(System.UInt32,Microsoft.VisualStudio.Shell.Interop.IVsCfg[],System.UInt32[],System.UInt32[])")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SingleFileGenerator.#GetBufferContents(System.String,Microsoft.VisualStudio.TextManager.Interop.IVsTextStream&)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsBatchUpdate.FlushPendingUpdates(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.SingleFileGenerator.#InvokeGenerator(Microsoft.VisualStudio.Package.FileNode)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.SingleFileGeneratorNodeProperties.#_customTool", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1051:DoNotDeclareVisibleInstanceFields", Scope = "member", Target = "Microsoft.VisualStudio.Package.SingleFileGeneratorNodeProperties.#_customToolNamespace", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SolutionListener.#Dispose(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolution.UnadviseSolutionEvents(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SolutionListener.#Init()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolution.AdviseSolutionEvents(Microsoft.VisualStudio.Shell.Interop.IVsSolutionEvents,System.UInt32@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SolutionListenerForProjectReferenceUpdate.#GetProjectReferenceOnNodeForHierarchy(System.Collections.Generic.IList`1<Microsoft.VisualStudio.Package.ReferenceNode>,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetCanonicalName(System.UInt32,System.String@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.SolutionListenerForProjectReferenceUpdate.#GetProjectReferenceOnNodeForHierarchy(System.Collections.Generic.IList`1<Microsoft.VisualStudio.Package.ReferenceNode>,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetGuidProperty(System.UInt32,System.Int32,System.Guid@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.SR.#GetObject(System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.SR.#GetString(System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.SR.#get_Resources()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.TokenProcessor.#DeleteTokens(System.String&,Microsoft.VisualStudio.Package.DeleteToken)", MessageId = "0#")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.TokenProcessor.#GuidToForm2(System.Guid)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.TokenProcessor.#ReplaceBetweenTokens(System.String&,Microsoft.VisualStudio.Package.ReplaceBetweenPairToken)", MessageId = "0#")]
[assembly: SuppressMessage("Microsoft.Design", "CA1045:DoNotPassTypesByReference", Scope = "member", Target = "Microsoft.VisualStudio.Package.TokenProcessor.#ReplaceTokens(System.String&,Microsoft.VisualStudio.Package.ReplacePairToken)", MessageId = "0#")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.TokenProcessor.#UntokenFile(System.String,System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.UpdateSolutionEventsListener.#Dispose(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolutionBuildManager2.UnadviseUpdateSolutionEvents(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.UpdateSolutionEventsListener.#Dispose(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsSolutionBuildManager3.UnadviseUpdateSolutionEvents3(System.UInt32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.Utilities.#InitializeMsBuildEngine(Microsoft.Build.BuildEngine.Engine,System.IServiceProvider)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.Utilities.#InitializeMsBuildProject(Microsoft.Build.BuildEngine.Engine,System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.Utilities.#IsInAutomationFunction(System.IServiceProvider)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.Package.VSMDCodeDomProvider", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.VisualStudio.Package.VsMenus", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "Microsoft.VisualStudio.Package.VsMenus.#guidSHLMainMenu", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "Microsoft.VisualStudio.Package.VsMenus.#guidStandardCommandSet2K", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "Microsoft.VisualStudio.Package.VsMenus.#guidStandardCommandSet97", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "Microsoft.VisualStudio.Package.VsMenus.#guidVsUIHierarchyWindowCmds", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "Microsoft.VisualStudio.Package.VsMenus.#guidVSUISet", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "Microsoft.VisualStudio.Package.VsMenus.#guidVsVbaPkg", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OABuildManager.#GetOutputMoniker(System.Object)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OABuildManager.#GetOutputMoniker(System.Object)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsOutput2.get_CanonicalName(System.String@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OABuildManager.#OnDesignTimeOutputDeleted(System.Object,System.EventArgs)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_Document()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_Document()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_Document()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.GetDocumentFromDocCookie(System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#DoSave(System.Boolean,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#DoSave(System.Boolean,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_IsOpen(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_IsOpen(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_IsDirty()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#get_IsDirty()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#Open(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAFileItem.#Open(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#get_ConfigurationManager()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.GetConfigMgr(System.Object,System.UInt32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#Delete()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#Delete()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#DoSave(System.Boolean,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#DoSave(System.Boolean,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#set_IsDirty(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#set_IsDirty(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#set_Name(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#set_Name(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#get_Properties()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.GetProperties(System.Object,System.Object,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#set_Saved(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProject.#set_Saved(System.Boolean)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#Delete()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#Delete()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#ExpandView()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#ExpandView()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#ExpandView()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsUIHierarchyWindow.ExpandItem(Microsoft.VisualStudio.Shell.Interop.IVsUIHierarchy,System.UInt32,Microsoft.VisualStudio.Shell.Interop.EXPANDFLAGS)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#set_Name(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#set_Name(System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#Remove()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItem`1.#Remove()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItems.#AddFolder(System.String,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItems.#AddFolder(System.String,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItems.#AddFromTemplate(System.String,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItems.#AddFromTemplate(System.String,System.String)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItems.#AddItem(System.String,Microsoft.VisualStudio.Shell.Interop.VSADDITEMOPERATION)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProjectItems.#AddItem(System.String,Microsoft.VisualStudio.Shell.Interop.VSADDITEMOPERATION)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2214:DoNotCallOverridableMethodsInConstructors", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProperties.#.ctor(Microsoft.VisualStudio.Package.NodeProperties)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProperty.#set_IndexedValue(System.Object,System.Object,System.Object,System.Object,System.Object)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProperty.#set_IndexedValue(System.Object,System.Object,System.Object,System.Object,System.Object)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProperty.#set_Value(System.Object)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.EnterAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAProperty.#set_Value(System.Object)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsExtensibility3.ExitAutomationFunction")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAReferences.#Item(System.Object)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Automation.OAReferences.#OnReferenceChanged(System.Object,Microsoft.VisualStudio.Package.HierarchyNodeEventArgs)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.Package.Web.CodeBehindCodeGenerator", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1307:SpecifyStringComparison", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.CodeBehindCodeGenerator.#GetDesignerItem(Microsoft.VisualStudio.Package.Web.VsHierarchyItem,System.Boolean)", MessageId = "System.String.LastIndexOf(System.String)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.CodeBehindCodeGenerator.#Microsoft.VisualStudio.Web.Application.IVsCodeBehindCodeGenerator.Initialize(Microsoft.VisualStudio.Shell.Interop.IVsHierarchy)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetSite(Microsoft.VisualStudio.OLE.Interop.IServiceProvider@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.FieldData.#.ctor(System.String)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.FieldData.#get_Class()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.FieldData.#get_IsPrivate()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#.ctor(Microsoft.VisualStudio.Shell.Interop.IVsHierarchy)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#Caption()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#GetDocumentText()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsPersistDocData.Close")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#GetGuidPropHelper(Microsoft.VisualStudio.Shell.Interop.__VSHPROPID)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetGuidProperty(System.UInt32,System.Int32,System.Guid@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#GetPropHelper(Microsoft.VisualStudio.Shell.Interop.__VSHPROPID2)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#GetPropHelper(System.UInt32,System.Int32)", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetProperty(System.UInt32,System.Int32,System.Object@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#GetRunningDocData()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsRunningDocumentTable.FindAndLockDocument(System.UInt32,System.String,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy@,System.UInt32@,System.IntPtr@,System.UInt32@)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#GetRunningDocumentTextBuffer()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsTextBufferProvider.GetTextBuffer(Microsoft.VisualStudio.TextManager.Interop.IVsTextLines@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#get_Hierarchy()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#IsRootNode()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#ProjectDir()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#ProjectItems()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#ProjRelativePath()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#ProjRelativeUrl()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#Root()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#SaveName()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#Site()", MessageId = "Microsoft.VisualStudio.Shell.Interop.IVsHierarchy.GetSite(Microsoft.VisualStudio.OLE.Interop.IServiceProvider@)")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#UIHierarchy()", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.VsHierarchyItem.#set_VsItemID(System.UInt32)", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Scope = "type", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities", MessageId = "")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1806:DoNotIgnoreMethodResults", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities.#CreateInstance`1(System.IServiceProvider,System.Guid)", MessageId = "Microsoft.VisualStudio.Shell.Interop.ILocalRegistry.CreateInstance(System.Guid,System.Object,System.Guid@,System.UInt32,System.IntPtr@)")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1307:SpecifyStringComparison", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities.#EnsureTrailingBackSlash(System.String)", MessageId = "System.String.EndsWith(System.String)")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1307:SpecifyStringComparison", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities.#EnsureTrailingSlash(System.String)", MessageId = "System.String.EndsWith(System.String)")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1307:SpecifyStringComparison", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities.#MakeRelativePath(System.String,System.String)", MessageId = "System.String.EndsWith(System.String)")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1307:SpecifyStringComparison", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities.#MakeRelativePath(System.String,System.String)", MessageId = "System.String.LastIndexOf(System.String)")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1307:SpecifyStringComparison", Scope = "member", Target = "Microsoft.VisualStudio.Package.Web.WAUtilities.#MakeRelativePath(System.String,System.String)", MessageId = "System.String.StartsWith(System.String)")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1701:ResourceStringCompoundWordsShouldBeCasedCorrectly", Scope = "resource", Target = "Microsoft.VisualStudio.Package.Project.resources", MessageId = "dataset")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "Microsoft.VisualStudio.Package.Project.resources", MessageId = "msbuild")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "Microsoft.VisualStudio.Package.SecurityWarningDialog.resources", MessageId = "Intelli")]
