//-----------------------------------------------------------------------------
// Copyright 1994-2000 Microsoft Corporation.  All Rights Reserved.
//
// File:		msotl.h
// Contents:	This file describes the MSO interfaces.
//-----------------------------------------------------------------------------
/* This header file machine-generated by mktyplib.exe */
/* Interface to type library: Office */

#ifndef _Office_H_
#define _Office_H_

#define IAccessible IAccessible_MSO

DEFINE_GUID(LIBID_Office,0x2DF8D04CL,0x5BFA,0x101B,0xBD,0xE5,0x00,0xAA,0x00,0x44,0xDE,0x52);
#ifndef BEGIN_INTERFACE
#define BEGIN_INTERFACE
#endif

typedef enum {
    msoLineDashStyleMixed = -2,
    msoLineSolid = 1,
    msoLineSquareDot,
    msoLineRoundDot,
    msoLineDash,
    msoLineDashDot,
    msoLineDashDotDot,
    msoLineLongDash,
    msoLineLongDashDot
} MsoLineDashStyle;

typedef enum {
    msoLineStyleMixed = -2,
    msoLineSingle = 1,
    msoLineThinThin,
    msoLineThinThick,
    msoLineThickThin,
    msoLineThickBetweenThin
} MsoLineStyle;

typedef enum {
    msoArrowheadStyleMixed = -2,
    msoArrowheadNone = 1,
    msoArrowheadTriangle,
    msoArrowheadOpen,
    msoArrowheadStealth,
    msoArrowheadDiamond,
    msoArrowheadOval
} MsoArrowheadStyle;

typedef enum {
    msoArrowheadWidthMixed = -2,
    msoArrowheadNarrow = 1,
    msoArrowheadWidthMedium,
    msoArrowheadWide
} MsoArrowheadWidth;

typedef enum {
    msoArrowheadLengthMixed = -2,
    msoArrowheadShort = 1,
    msoArrowheadLengthMedium,
    msoArrowheadLong
} MsoArrowheadLength;

typedef enum {
    msoFillMixed = -2,
    msoFillSolid = 1,
    msoFillPatterned,
    msoFillGradient,
    msoFillTextured,
    msoFillBackground,
    msoFillPicture
} MsoFillType;

typedef enum {
    msoGradientMixed = -2,
    msoGradientHorizontal = 1,
    msoGradientVertical,
    msoGradientDiagonalUp,
    msoGradientDiagonalDown,
    msoGradientFromCorner,
    msoGradientFromTitle,
    msoGradientFromCenter
} MsoGradientStyle;

typedef enum {
    msoGradientColorMixed = -2,
    msoGradientOneColor = 1,
    msoGradientTwoColors,
    msoGradientPresetColors
} MsoGradientColorType;

typedef enum {
    msoTextureTypeMixed = -2,
    msoTexturePreset = 1,
    msoTextureUserDefined
} MsoTextureType;

typedef enum {
    msoPresetTextureMixed = -2,
    msoTexturePapyrus = 1,
    msoTextureCanvas,
    msoTextureDenim,
    msoTextureWovenMat,
    msoTextureWaterDroplets,
    msoTexturePaperBag,
    msoTextureFishFossil,
    msoTextureSand,
    msoTextureGreenMarble,
    msoTextureWhiteMarble,
    msoTextureBrownMarble,
    msoTextureGranite,
    msoTextureNewsprint,
    msoTextureRecycledPaper,
    msoTextureParchment,
    msoTextureStationery,
    msoTextureBlueTissuePaper,
    msoTexturePinkTissuePaper,
    msoTexturePurpleMesh,
    msoTextureBouquet,
    msoTextureCork,
    msoTextureWalnut,
    msoTextureOak,
    msoTextureMediumWood
} MsoPresetTexture;

typedef enum {
    msoPatternMixed = -2,
    msoPattern5Percent = 1,
    msoPattern10Percent,
    msoPattern20Percent,
    msoPattern25Percent,
    msoPattern30Percent,
    msoPattern40Percent,
    msoPattern50Percent,
    msoPattern60Percent,
    msoPattern70Percent,
    msoPattern75Percent,
    msoPattern80Percent,
    msoPattern90Percent,
    msoPatternDarkHorizontal,
    msoPatternDarkVertical,
    msoPatternDarkDownwardDiagonal,
    msoPatternDarkUpwardDiagonal,
    msoPatternSmallCheckerBoard,
    msoPatternTrellis,
    msoPatternLightHorizontal,
    msoPatternLightVertical,
    msoPatternLightDownwardDiagonal,
    msoPatternLightUpwardDiagonal,
    msoPatternSmallGrid,
    msoPatternDottedDiamond,
    msoPatternWideDownwardDiagonal,
    msoPatternWideUpwardDiagonal,
    msoPatternDashedUpwardDiagonal,
    msoPatternDashedDownwardDiagonal,
    msoPatternNarrowVertical,
    msoPatternNarrowHorizontal,
    msoPatternDashedVertical,
    msoPatternDashedHorizontal,
    msoPatternLargeConfetti,
    msoPatternLargeGrid,
    msoPatternHorizontalBrick,
    msoPatternLargeCheckerBoard,
    msoPatternSmallConfetti,
    msoPatternZigZag,
    msoPatternSolidDiamond,
    msoPatternDiagonalBrick,
    msoPatternOutlinedDiamond,
    msoPatternPlaid,
    msoPatternSphere,
    msoPatternWeave,
    msoPatternDottedGrid,
    msoPatternDivot,
    msoPatternShingle,
    msoPatternWave
} MsoPatternType;

typedef enum {
    msoPresetGradientMixed = -2,
    msoGradientEarlySunset = 1,
    msoGradientLateSunset,
    msoGradientNightfall,
    msoGradientDaybreak,
    msoGradientHorizon,
    msoGradientDesert,
    msoGradientOcean,
    msoGradientCalmWater,
    msoGradientFire,
    msoGradientFog,
    msoGradientMoss,
    msoGradientPeacock,
    msoGradientWheat,
    msoGradientParchment,
    msoGradientMahogany,
    msoGradientRainbow,
    msoGradientRainbowII,
    msoGradientGold,
    msoGradientGoldII,
    msoGradientBrass,
    msoGradientChrome,
    msoGradientChromeII,
    msoGradientSilver,
    msoGradientSapphire
} MsoPresetGradientType;

typedef enum {
    msoShadowMixed = -2,
    msoShadow1 = 1,
    msoShadow2,
    msoShadow3,
    msoShadow4,
    msoShadow5,
    msoShadow6,
    msoShadow7,
    msoShadow8,
    msoShadow9,
    msoShadow10,
    msoShadow11,
    msoShadow12,
    msoShadow13,
    msoShadow14,
    msoShadow15,
    msoShadow16,
    msoShadow17,
    msoShadow18,
    msoShadow19,
    msoShadow20
} MsoShadowType;

typedef enum {
    msoTextEffectMixed = -2,
    msoTextEffect1 = 0,
    msoTextEffect2,
    msoTextEffect3,
    msoTextEffect4,
    msoTextEffect5,
    msoTextEffect6,
    msoTextEffect7,
    msoTextEffect8,
    msoTextEffect9,
    msoTextEffect10,
    msoTextEffect11,
    msoTextEffect12,
    msoTextEffect13,
    msoTextEffect14,
    msoTextEffect15,
    msoTextEffect16,
    msoTextEffect17,
    msoTextEffect18,
    msoTextEffect19,
    msoTextEffect20,
    msoTextEffect21,
    msoTextEffect22,
    msoTextEffect23,
    msoTextEffect24,
    msoTextEffect25,
    msoTextEffect26,
    msoTextEffect27,
    msoTextEffect28,
    msoTextEffect29,
    msoTextEffect30
} MsoPresetTextEffect;

typedef enum {
    msoTextEffectShapeMixed = -2,
    msoTextEffectShapePlainText = 1,
    msoTextEffectShapeStop,
    msoTextEffectShapeTriangleUp,
    msoTextEffectShapeTriangleDown,
    msoTextEffectShapeChevronUp,
    msoTextEffectShapeChevronDown,
    msoTextEffectShapeRingInside,
    msoTextEffectShapeRingOutside,
    msoTextEffectShapeArchUpCurve,
    msoTextEffectShapeArchDownCurve,
    msoTextEffectShapeCircleCurve,
    msoTextEffectShapeButtonCurve,
    msoTextEffectShapeArchUpPour,
    msoTextEffectShapeArchDownPour,
    msoTextEffectShapeCirclePour,
    msoTextEffectShapeButtonPour,
    msoTextEffectShapeCurveUp,
    msoTextEffectShapeCurveDown,
    msoTextEffectShapeCanUp,
    msoTextEffectShapeCanDown,
    msoTextEffectShapeWave1,
    msoTextEffectShapeWave2,
    msoTextEffectShapeDoubleWave1,
    msoTextEffectShapeDoubleWave2,
    msoTextEffectShapeInflate,
    msoTextEffectShapeDeflate,
    msoTextEffectShapeInflateBottom,
    msoTextEffectShapeDeflateBottom,
    msoTextEffectShapeInflateTop,
    msoTextEffectShapeDeflateTop,
    msoTextEffectShapeDeflateInflate,
    msoTextEffectShapeDeflateInflateDeflate,
    msoTextEffectShapeFadeRight,
    msoTextEffectShapeFadeLeft,
    msoTextEffectShapeFadeUp,
    msoTextEffectShapeFadeDown,
    msoTextEffectShapeSlantUp,
    msoTextEffectShapeSlantDown,
    msoTextEffectShapeCascadeUp,
    msoTextEffectShapeCascadeDown
} MsoPresetTextEffectShape;

typedef enum {
    msoTextEffectAlignmentMixed = -2,
    msoTextEffectAlignmentLeft = 1,
    msoTextEffectAlignmentCentered,
    msoTextEffectAlignmentRight,
    msoTextEffectAlignmentLetterJustify,
    msoTextEffectAlignmentWordJustify,
    msoTextEffectAlignmentStretchJustify
} MsoTextEffectAlignment;

typedef enum {
    msoPresetLightingDirectionMixed = -2,
    msoLightingTopLeft = 1,
    msoLightingTop,
    msoLightingTopRight,
    msoLightingLeft,
    msoLightingNone,
    msoLightingRight,
    msoLightingBottomLeft,
    msoLightingBottom,
    msoLightingBottomRight
} MsoPresetLightingDirection;

typedef enum {
    msoPresetLightingSoftnessMixed = -2,
    msoLightingDim = 1,
    msoLightingNormal,
    msoLightingBright
} MsoPresetLightingSoftness;

typedef enum {
    msoPresetMaterialMixed = -2,
    msoMaterialMatte = 1,
    msoMaterialPlastic,
    msoMaterialMetal,
    msoMaterialWireFrame
} MsoPresetMaterial;

typedef enum {
    msoPresetExtrusionDirectionMixed = -2,
    msoExtrusionBottomRight = 1,
    msoExtrusionBottom,
    msoExtrusionBottomLeft,
    msoExtrusionRight,
    msoExtrusionNone,
    msoExtrusionLeft,
    msoExtrusionTopRight,
    msoExtrusionTop,
    msoExtrusionTopLeft
} MsoPresetExtrusionDirection;

typedef enum {
    msoPresetThreeDFormatMixed = -2,
    msoThreeD1 = 1,
    msoThreeD2,
    msoThreeD3,
    msoThreeD4,
    msoThreeD5,
    msoThreeD6,
    msoThreeD7,
    msoThreeD8,
    msoThreeD9,
    msoThreeD10,
    msoThreeD11,
    msoThreeD12,
    msoThreeD13,
    msoThreeD14,
    msoThreeD15,
    msoThreeD16,
    msoThreeD17,
    msoThreeD18,
    msoThreeD19,
    msoThreeD20
} MsoPresetThreeDFormat;

typedef enum {
    msoExtrusionColorTypeMixed = -2,
    msoExtrusionColorAutomatic = 1,
    msoExtrusionColorCustom
} MsoExtrusionColorType;

typedef enum {
    msoAlignLefts = 0,
    msoAlignCenters,
    msoAlignRights,
    msoAlignTops,
    msoAlignMiddles,
    msoAlignBottoms
} MsoAlignCmd;

typedef enum {
    msoDistributeHorizontally = 0,
    msoDistributeVertically
} MsoDistributeCmd;

typedef enum {
    msoConnectorTypeMixed = -2,
    msoConnectorStraight = 1,
    msoConnectorElbow,
    msoConnectorCurve
} MsoConnectorType;

typedef enum {
    msoHorizontalAnchorMixed = -2,
    msoAnchorNone = 1,
    msoAnchorCenter
} MsoHorizontalAnchor;

typedef enum {
    msoVerticalAnchorMixed = -2,
    msoAnchorTop = 1,
    msoAnchorTopBaseline,
    msoAnchorMiddle,
    msoAnchorBottom,
    msoAnchorBottomBaseLine
} MsoVerticalAnchor;

typedef enum {
    msoOrientationMixed = -2,
    msoOrientationHorizontal = 1,
    msoOrientationVertical
} MsoOrientation;

typedef enum {
    msoBringToFront = 0,
    msoSendToBack,
    msoBringForward,
    msoSendBackward,
    msoBringInFrontOfText,
    msoSendBehindText
} MsoZOrderCmd;

typedef enum {
    msoSegmentLine = 0,
    msoSegmentCurve
} MsoSegmentType;

typedef enum {
    msoEditingAuto = 0,
    msoEditingCorner,
    msoEditingSmooth,
    msoEditingSymmetric
} MsoEditingType;

typedef enum {
    msoShapeMixed = -2,
    msoShapeRectangle = 1,
    msoShapeParallelogram,
    msoShapeTrapezoid,
    msoShapeDiamond,
    msoShapeRoundedRectangle,
    msoShapeOctagon,
    msoShapeIsoscelesTriangle,
    msoShapeRightTriangle,
    msoShapeOval,
    msoShapeHexagon,
    msoShapeCross,
    msoShapeRegularPentagon,
    msoShapeCan,
    msoShapeCube,
    msoShapeBevel,
    msoShapeFoldedCorner,
    msoShapeSmileyFace,
    msoShapeDonut,
    msoShapeNoSymbol,
    msoShapeBlockArc,
    msoShapeHeart,
    msoShapeLightningBolt,
    msoShapeSun,
    msoShapeMoon,
    msoShapeArc,
    msoShapeDoubleBracket,
    msoShapeDoubleBrace,
    msoShapePlaque,
    msoShapeLeftBracket,
    msoShapeRightBracket,
    msoShapeLeftBrace,
    msoShapeRightBrace,
    msoShapeRightArrow,
    msoShapeLeftArrow,
    msoShapeUpArrow,
    msoShapeDownArrow,
    msoShapeLeftRightArrow,
    msoShapeUpDownArrow,
    msoShapeQuadArrow,
    msoShapeLeftRightUpArrow,
    msoShapeBentArrow,
    msoShapeUTurnArrow,
    msoShapeLeftUpArrow,
    msoShapeBentUpArrow,
    msoShapeCurvedRightArrow,
    msoShapeCurvedLeftArrow,
    msoShapeCurvedUpArrow,
    msoShapeCurvedDownArrow,
    msoShapeStripedRightArrow,
    msoShapeNotchedRightArrow,
    msoShapePentagon,
    msoShapeChevron,
    msoShapeRightArrowCallout,
    msoShapeLeftArrowCallout,
    msoShapeUpArrowCallout,
    msoShapeDownArrowCallout,
    msoShapeLeftRightArrowCallout,
    msoShapeUpDownArrowCallout,
    msoShapeQuadArrowCallout,
    msoShapeCircularArrow,
    msoShapeFlowchartProcess,
    msoShapeFlowchartAlternateProcess,
    msoShapeFlowchartDecision,
    msoShapeFlowchartData,
    msoShapeFlowchartPredefinedProcess,
    msoShapeFlowchartInternalStorage,
    msoShapeFlowchartDocument,
    msoShapeFlowchartMultidocument,
    msoShapeFlowchartTerminator,
    msoShapeFlowchartPreparation,
    msoShapeFlowchartManualInput,
    msoShapeFlowchartManualOperation,
    msoShapeFlowchartConnector,
    msoShapeFlowchartOffpageConnector,
    msoShapeFlowchartCard,
    msoShapeFlowchartPunchedTape,
    msoShapeFlowchartSummingJunction,
    msoShapeFlowchartOr,
    msoShapeFlowchartCollate,
    msoShapeFlowchartSort,
    msoShapeFlowchartExtract,
    msoShapeFlowchartMerge,
    msoShapeFlowchartStoredData,
    msoShapeFlowchartDelay,
    msoShapeFlowchartSequentialAccessStorage,
    msoShapeFlowchartMagneticDisk,
    msoShapeFlowchartDirectAccessStorage,
    msoShapeFlowchartDisplay,
    msoShapeExplosion1,
    msoShapeExplosion2,
    msoShape4pointStar,
    msoShape5pointStar,
    msoShape8pointStar,
    msoShape16pointStar,
    msoShape24pointStar,
    msoShape32pointStar,
    msoShapeUpRibbon,
    msoShapeDownRibbon,
    msoShapeCurvedUpRibbon,
    msoShapeCurvedDownRibbon,
    msoShapeVerticalScroll,
    msoShapeHorizontalScroll,
    msoShapeWave,
    msoShapeDoubleWave,
    msoShapeRectangularCallout,
    msoShapeRoundedRectangularCallout,
    msoShapeOvalCallout,
    msoShapeCloudCallout,
    msoShapeLineCallout1,
    msoShapeLineCallout2,
    msoShapeLineCallout3,
    msoShapeLineCallout4,
    msoShapeLineCallout1AccentBar,
    msoShapeLineCallout2AccentBar,
    msoShapeLineCallout3AccentBar,
    msoShapeLineCallout4AccentBar,
    msoShapeLineCallout1NoBorder,
    msoShapeLineCallout2NoBorder,
    msoShapeLineCallout3NoBorder,
    msoShapeLineCallout4NoBorder,
    msoShapeLineCallout1BorderandAccentBar,
    msoShapeLineCallout2BorderandAccentBar,
    msoShapeLineCallout3BorderandAccentBar,
    msoShapeLineCallout4BorderandAccentBar,
    msoShapeActionButtonCustom,
    msoShapeActionButtonHome,
    msoShapeActionButtonHelp,
    msoShapeActionButtonInformation,
    msoShapeActionButtonBackorPrevious,
    msoShapeActionButtonForwardorNext,
    msoShapeActionButtonBeginning,
    msoShapeActionButtonEnd,
    msoShapeActionButtonReturn,
    msoShapeActionButtonDocument,
    msoShapeActionButtonSound,
    msoShapeActionButtonMovie,
    msoShapeBalloon,
    msoShapeNotPrimitive
} MsoAutoShapeType;

typedef enum {
    msoShapeTypeMixed = -2,
    msoAutoShape = 1,
    msoCallout,
    msoChart,
    msoComment,
    msoFreeform,
    msoGroup,
    msoEmbeddedOLEObject,
    msoFormControl,
    msoLine,
    msoLinkedOLEObject,
    msoLinkedPicture,
    msoOLEControlObject,
    msoPicture,
    msoPlaceholder,
    msoTextEffect,
    msoMedia,
    msoTextBox,
    msoScriptAnchor,
    msoTable,
    msoCanvas,
    msoDiagram
} MsoShapeType;

typedef enum {
    msoFlipHorizontal = 0,
    msoFlipVertical
} MsoFlipCmd;

typedef enum {
    msoTrue = -1,
    msoFalse,
    msoCTrue,
    msoTriStateToggle = -3,
    msoTriStateMixed = -2
} MsoTriState;

typedef enum {
    msoColorTypeMixed = -2,
    msoColorTypeRGB = 1,
    msoColorTypeScheme,
    msoColorTypeCMYK,
    msoColorTypeCMS,
    msoColorTypeInk
} MsoColorType;

typedef enum {
    msoPictureMixed = -2,
    msoPictureAutomatic = 1,
    msoPictureGrayscale,
    msoPictureBlackAndWhite,
    msoPictureWatermark
} MsoPictureColorType;

typedef enum {
    msoCalloutAngleMixed = -2,
    msoCalloutAngleAutomatic = 1,
    msoCalloutAngle30,
    msoCalloutAngle45,
    msoCalloutAngle60,
    msoCalloutAngle90
} MsoCalloutAngleType;

typedef enum {
    msoCalloutDropMixed = -2,
    msoCalloutDropCustom = 1,
    msoCalloutDropTop,
    msoCalloutDropCenter,
    msoCalloutDropBottom
} MsoCalloutDropType;

typedef enum {
    msoCalloutMixed = -2,
    msoCalloutOne = 1,
    msoCalloutTwo,
    msoCalloutThree,
    msoCalloutFour
} MsoCalloutType;

typedef enum {
    msoBlackWhiteMixed = -2,
    msoBlackWhiteAutomatic = 1,
    msoBlackWhiteGrayScale,
    msoBlackWhiteLightGrayScale,
    msoBlackWhiteInverseGrayScale,
    msoBlackWhiteGrayOutline,
    msoBlackWhiteBlackTextAndLine,
    msoBlackWhiteHighContrast,
    msoBlackWhiteBlack,
    msoBlackWhiteWhite,
    msoBlackWhiteDontShow
} MsoBlackWhiteMode;

typedef enum {
    msoIntegerMixed = 32768,
    msoSingleMixed = 0x80000000
} MsoMixedType;

typedef enum {
    msoTextOrientationMixed = -2,
    msoTextOrientationHorizontal = 1,
    msoTextOrientationUpward,
    msoTextOrientationDownward,
    msoTextOrientationVerticalFarEast,
    msoTextOrientationVertical,
    msoTextOrientationHorizontalRotatedFarEast
} MsoTextOrientation;

typedef enum {
    msoScaleFromTopLeft = 0,
    msoScaleFromMiddle,
    msoScaleFromBottomRight
} MsoScaleFrom;

typedef long MsoRGBType;

typedef enum {
    msoBarLeft = 0,
    msoBarTop,
    msoBarRight,
    msoBarBottom,
    msoBarFloating,
    msoBarPopup,
    msoBarMenuBar
} MsoBarPosition;

typedef enum {
    msoBarNoProtection = 0,
    msoBarNoCustomize = 1,
    msoBarNoResize = 2,
    msoBarNoMove = 4,
    msoBarNoChangeVisible = 8,
    msoBarNoChangeDock = 16,
    msoBarNoVerticalDock = 32,
    msoBarNoHorizontalDock = 64
} MsoBarProtection;

typedef enum {
    msoBarTypeNormal = 0,
    msoBarTypeMenuBar,
    msoBarTypePopup
} MsoBarType;

typedef enum {
    msoControlCustom = 0,
    msoControlButton,
    msoControlEdit,
    msoControlDropdown,
    msoControlComboBox,
    msoControlButtonDropdown,
    msoControlSplitDropdown,
    msoControlOCXDropdown,
    msoControlGenericDropdown,
    msoControlGraphicDropdown,
    msoControlPopup,
    msoControlGraphicPopup,
    msoControlButtonPopup,
    msoControlSplitButtonPopup,
    msoControlSplitButtonMRUPopup,
    msoControlLabel,
    msoControlExpandingGrid,
    msoControlSplitExpandingGrid,
    msoControlGrid,
    msoControlGauge,
    msoControlGraphicCombo,
    msoControlPane,
    msoControlActiveX,
    msoControlSpinner,
    msoControlLabelEx,
    msoControlWorkPane,
    msoControlAutoCompleteCombo
} MsoControlType;

typedef enum {
    msoButtonUp = 0,
    msoButtonDown = -1,
    msoButtonMixed = 2
} MsoButtonState;

typedef enum {
    msoControlOLEUsageNeither = 0,
    msoControlOLEUsageServer,
    msoControlOLEUsageClient,
    msoControlOLEUsageBoth
} MsoControlOLEUsage;

typedef enum {
    msoButtonWrapText = 4,
    msoButtonTextBelow = 8
} MsoButtonStyleHidden;

typedef enum {
    msoButtonAutomatic = 0,
    msoButtonIcon = 1,
    msoButtonCaption = 2,
    msoButtonIconAndCaption = 3,
    msoButtonIconAndWrapCaption = 7,
    msoButtonIconAndCaptionBelow = 11,
    msoButtonWrapCaption = 14,
    msoButtonIconAndWrapCaptionBelow = 15
} MsoButtonStyle;

typedef enum {
    msoComboNormal = 0,
    msoComboLabel = 1
} MsoComboStyle;

typedef enum {
    msoOLEMenuGroupNone = -1,
    msoOLEMenuGroupFile = 0,
    msoOLEMenuGroupEdit,
    msoOLEMenuGroupContainer,
    msoOLEMenuGroupObject,
    msoOLEMenuGroupWindow,
    msoOLEMenuGroupHelp
} MsoOLEMenuGroup;

typedef enum {
    msoMenuAnimationNone = 0,
    msoMenuAnimationRandom,
    msoMenuAnimationUnfold,
    msoMenuAnimationSlide
} MsoMenuAnimation;

typedef enum {
    msoBarRowFirst = 0,
    msoBarRowLast = -1
} MsoBarRow;

typedef enum {
    msoCommandBarButtonHyperlinkNone = 0,
    msoCommandBarButtonHyperlinkOpen,
    msoCommandBarButtonHyperlinkInsertPicture
} MsoCommandBarButtonHyperlinkType;

typedef enum {
    msoHyperlinkRange = 0,
    msoHyperlinkShape = 1,
    msoHyperlinkInlineShape = 2
} MsoHyperlinkType;

typedef enum {
    msoMethodGet = 0,
    msoMethodPost = 1
} MsoExtraInfoMethod;

typedef enum {
    msoAnimationIdle = 1,
    msoAnimationGreeting = 2,
    msoAnimationGoodbye = 3,
    msoAnimationBeginSpeaking = 4,
    msoAnimationRestPose = 5,
    msoAnimationCharacterSuccessMajor = 6,
    msoAnimationGetAttentionMajor = 11,
    msoAnimationGetAttentionMinor = 12,
    msoAnimationSearching = 13,
    msoAnimationPrinting = 18,
    msoAnimationGestureRight = 19,
    msoAnimationWritingNotingSomething = 22,
    msoAnimationWorkingAtSomething = 23,
    msoAnimationThinking = 24,
    msoAnimationSendingMail = 25,
    msoAnimationListensToComputer = 26,
    msoAnimationDisappear = 31,
    msoAnimationAppear = 32,
    msoAnimationGetArtsy = 100,
    msoAnimationGetTechy = 101,
    msoAnimationGetWizardy = 102,
    msoAnimationCheckingSomething = 103,
    msoAnimationLookDown = 104,
    msoAnimationLookDownLeft = 105,
    msoAnimationLookDownRight = 106,
    msoAnimationLookLeft = 107,
    msoAnimationLookRight = 108,
    msoAnimationLookUp = 109,
    msoAnimationLookUpLeft = 110,
    msoAnimationLookUpRight = 111,
    msoAnimationSaving = 112,
    msoAnimationGestureDown = 113,
    msoAnimationGestureLeft = 114,
    msoAnimationGestureUp = 115,
    msoAnimationEmptyTrash = 116
} MsoAnimationType;

typedef enum {
    msoButtonSetNone = 0,
    msoButtonSetOK = 1,
    msoButtonSetCancel = 2,
    msoButtonSetOkCancel = 3,
    msoButtonSetYesNo = 4,
    msoButtonSetYesNoCancel = 5,
    msoButtonSetBackClose = 6,
    msoButtonSetNextClose = 7,
    msoButtonSetBackNextClose = 8,
    msoButtonSetRetryCancel = 9,
    msoButtonSetAbortRetryIgnore = 10,
    msoButtonSetSearchClose = 11,
    msoButtonSetBackNextSnooze = 12,
    msoButtonSetTipsOptionsClose = 13,
    msoButtonSetYesAllNoCancel = 14
} MsoButtonSetType;

typedef enum {
    msoIconNone = 0,
    msoIconAlert = 2,
    msoIconTip,
    msoIconAlertInfo,
    msoIconAlertWarning,
    msoIconAlertQuery,
    msoIconAlertCritical
} MsoIconType;

typedef enum {
    msoBalloonTypeButtons = 0,
    msoBalloonTypeBullets,
    msoBalloonTypeNumbers
} MsoBalloonType;

typedef enum {
    msoModeModal = 0,
    msoModeAutoDown,
    msoModeModeless
} MsoModeType;

typedef enum {
    msoBalloonErrorNone = 0,
    msoBalloonErrorOther = 1,
    msoBalloonErrorTooBig = 2,
    msoBalloonErrorOutOfMemory = 3,
    msoBalloonErrorBadPictureRef = 4,
    msoBalloonErrorBadReference = 5,
    msoBalloonErrorButtonlessModal = 6,
    msoBalloonErrorButtonModeless = 7,
    msoBalloonErrorBadCharacter = 8,
    msoBalloonErrorCOMFailure = 9,
    msoBalloonErrorCharNotTopmostForModal = 10,
    msoBalloonErrorTooManyControls = 11
} MsoBalloonErrorType;

typedef enum {
    msoWizardActInactive = 0,
    msoWizardActActive = 1,
    msoWizardActSuspend = 2,
    msoWizardActResume = 3
} MsoWizardActType;

typedef enum {
    msoWizardMsgLocalStateOn = 1,
    msoWizardMsgLocalStateOff = 2,
    msoWizardMsgShowHelp = 3,
    msoWizardMsgSuspending = 4,
    msoWizardMsgResuming = 5
} MsoWizardMsgType;

typedef enum {
    msoBalloonButtonYesToAll = -15,
    msoBalloonButtonOptions = -14,
    msoBalloonButtonTips = -13,
    msoBalloonButtonClose = -12,
    msoBalloonButtonSnooze = -11,
    msoBalloonButtonSearch = -10,
    msoBalloonButtonIgnore = -9,
    msoBalloonButtonAbort = -8,
    msoBalloonButtonRetry = -7,
    msoBalloonButtonNext = -6,
    msoBalloonButtonBack = -5,
    msoBalloonButtonNo = -4,
    msoBalloonButtonYes = -3,
    msoBalloonButtonCancel = -2,
    msoBalloonButtonOK = -1,
    msoBalloonButtonNull = 0
} MsoBalloonButtonType;

typedef enum {
    offPropertyTypeNumber = 1,
    offPropertyTypeBoolean = 2,
    offPropertyTypeDate = 3,
    offPropertyTypeString = 4,
    offPropertyTypeFloat = 5
} DocProperties;

typedef enum {
    msoPropertyTypeNumber = 1,
    msoPropertyTypeBoolean = 2,
    msoPropertyTypeDate = 3,
    msoPropertyTypeString = 4,
    msoPropertyTypeFloat = 5
} MsoDocProperties;

typedef enum {
    msoLanguageIDInstall = 1,
    msoLanguageIDUI = 2,
    msoLanguageIDHelp = 3,
    msoLanguageIDExeMode = 4,
    msoLanguageIDUIPrevious = 5
} MsoAppLanguageID;

typedef enum {
    MsoFarEastLineBreakLanguageJapanese = 1041,
    MsoFarEastLineBreakLanguageKorean = 1042,
    MsoFarEastLineBreakLanguageSimplifiedChinese = 2052,
    MsoFarEastLineBreakLanguageTraditionalChinese = 1028
} MsoFarEastLineBreakLanguageID;

typedef enum tagMsoOrgChartOrientation MsoOrgChartOrientation;

typedef enum tagMsoDiagramType MsoDiagramType;

typedef enum tagMsoDiagramNodeType MsoDiagramNodeType;

typedef enum {
    msoFeatureInstallNone = 0,
    msoFeatureInstallOnDemand = 1,
    msoFeatureInstallOnDemandWithUI = 2
} MsoFeatureInstall;

interface CommandBars;

#ifdef __cplusplus
class MsoCommandBars;
#endif

interface CommandBar;

interface CommandBarControls;

interface CommandBarControl;

interface COMAddIn;

interface COMAddIns;

interface Adjustments;

interface CalloutFormat;

interface ColorFormat;

interface ConnectorFormat;

interface FillFormat;

interface FreeformBuilder;

interface GroupShapes;

interface CanvasShapes;

interface LineFormat;

interface ShapeNode;

interface ShapeNodes;

interface PictureFormat;

interface ShadowFormat;

interface Shape;

interface ShapeRange;

interface Shapes;

interface Signature;

interface TextEffectFormat;

interface TextFrame;

interface ThreeDFormat;

interface IMsoDiagram;

interface DiagramNode;

interface DiagramNodes;

interface DiagramNodeChildren;

interface FileDialogFilter;

interface FileDialogFilters;

interface FileDialogSelectedItems;

interface FileDialog;

interface ScopeFolder;

interface SearchScopes;

interface SearchFolders;

interface FileTypes;

DEFINE_GUID(IID_IAccessible,0x618736E0L,0x3C3D,0x11CF,0x81,0x0C,0x00,0xAA,0x00,0x38,0x9B,0x71);

/* Definition of interface: IAccessible */
#undef INTERFACE
#define INTERFACE IAccessible

DECLARE_INTERFACE_(IAccessible, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;
};

DEFINE_GUID(IID__IMsoDispObj,0x000C0300L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: _IMsoDispObj */
#undef INTERFACE
#define INTERFACE _IMsoDispObj

DECLARE_INTERFACE_(_IMsoDispObj, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
};

DEFINE_GUID(IID__IMsoOleAccDispObj,0x000C0301L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: _IMsoOleAccDispObj */
#undef INTERFACE
#define INTERFACE _IMsoOleAccDispObj

DECLARE_INTERFACE_(_IMsoOleAccDispObj, IAccessible)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;
#endif

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
};

DEFINE_GUID(IID_CommandBars,0x000C0302L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBars */
#undef INTERFACE
#define INTERFACE CommandBars

DECLARE_INTERFACE_(CommandBars, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* CommandBars methods */
    STDMETHOD(get_ActionControl)(THIS_ CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_ActiveMenuBar)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(Add)(THIS_ VARIANT Name, VARIANT Position, VARIANT MenuBar, VARIANT Temporary, CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pcToolbars) PURE;
    STDMETHOD(get_DisplayTooltips)(THIS_ VARIANT_BOOL FAR* pvarfDisplayTooltips) PURE;
    STDMETHOD(put_DisplayTooltips)(THIS_ VARIANT_BOOL varfDisplayTooltips) PURE;
    STDMETHOD(get_DisplayKeysInTooltips)(THIS_ VARIANT_BOOL FAR* pvarfDisplayKeys) PURE;
    STDMETHOD(put_DisplayKeysInTooltips)(THIS_ VARIANT_BOOL varfDisplayKeys) PURE;
    STDMETHOD(FindControl)(THIS_ VARIANT Type, VARIANT Id, VARIANT Tag, VARIANT Visible, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Item)(THIS_ VARIANT Index, CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_LargeButtons)(THIS_ VARIANT_BOOL FAR* pvarfLargeButtons) PURE;
    STDMETHOD(put_LargeButtons)(THIS_ VARIANT_BOOL varfLargeButtons) PURE;
    STDMETHOD(get_MenuAnimationStyle)(THIS_ MsoMenuAnimation FAR* pma) PURE;
    STDMETHOD(put_MenuAnimationStyle)(THIS_ MsoMenuAnimation ma) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(ReleaseFocus)(THIS) PURE;
    STDMETHOD(get_IdsString)(THIS_ int ids, BSTR FAR* pbstrName, int FAR* pcch) PURE;
    STDMETHOD(get_TmcGetName)(THIS_ int tmc, BSTR FAR* pbstrName, int FAR* pcch) PURE;
    STDMETHOD(get_AdaptiveMenus)(THIS_ VARIANT_BOOL FAR* pvarfAdaptiveMenus) PURE;
    STDMETHOD(put_AdaptiveMenus)(THIS_ VARIANT_BOOL varfAdaptiveMenus) PURE;
    STDMETHOD(FindControls)(THIS_ VARIANT Type, VARIANT Id, VARIANT Tag, VARIANT Visible, CommandBarControls FAR* FAR* ppcbcs) PURE;
    STDMETHOD(AddEx)(THIS_ VARIANT TbidOrName, VARIANT Position, VARIANT MenuBar, VARIANT Temporary, VARIANT TbtrProtection, CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_DisplayFonts)(THIS_ VARIANT_BOOL FAR* pvarfDisplayFonts) PURE;
    STDMETHOD(put_DisplayFonts)(THIS_ VARIANT_BOOL varfDisplayFonts) PURE;
    STDMETHOD(get_DisableCustomize)(THIS_ VARIANT_BOOL FAR* pvarfDisableCustomize) PURE;
    STDMETHOD(put_DisableCustomize)(THIS_ VARIANT_BOOL varfDisableCustomize) PURE;
    STDMETHOD(get_DisableAskAQuestionDropdown)(THIS_ VARIANT_BOOL FAR* pvarfDisableAskAQuestionDropdown) PURE;
    STDMETHOD(put_DisableAskAQuestionDropdown)(THIS_ VARIANT_BOOL varfDisableAskAQuestionDropdown) PURE;
};

DEFINE_GUID(IID_CommandBar,0x000C0304L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBar */
#undef INTERFACE
#define INTERFACE CommandBar

DECLARE_INTERFACE_(CommandBar, _IMsoOleAccDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* CommandBar methods */
    STDMETHOD(get_BuiltIn)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(get_Context)(THIS_ BSTR FAR* pbstrContext) PURE;
    STDMETHOD(put_Context)(THIS_ BSTR Context) PURE;
    STDMETHOD(get_Controls)(THIS_ CommandBarControls FAR* FAR* ppcbcs) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(get_Enabled)(THIS_ VARIANT_BOOL FAR* pvarfEnabled) PURE;
    STDMETHOD(put_Enabled)(THIS_ VARIANT_BOOL varfEnabled) PURE;
    STDMETHOD(FindControl)(THIS_ VARIANT Type, VARIANT Id, VARIANT Tag, VARIANT Visible, VARIANT Recursive, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Height)(THIS_ int FAR* pdy) PURE;
    STDMETHOD(put_Height)(THIS_ int dy) PURE;
    STDMETHOD(get_Index)(THIS_ int FAR* pi) PURE;
    STDMETHOD(get_InstanceId)(THIS_ long FAR* pid) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* pxpLeft) PURE;
    STDMETHOD(put_Left)(THIS_ int xpLeft) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR Name) PURE;
    STDMETHOD(get_NameLocal)(THIS_ BSTR FAR* pbstrNameLocal) PURE;
    STDMETHOD(put_NameLocal)(THIS_ BSTR NameLocal) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Position)(THIS_ MsoBarPosition FAR* ppos) PURE;
    STDMETHOD(put_Position)(THIS_ MsoBarPosition pos) PURE;
    STDMETHOD(get_RowIndex)(THIS_ int FAR* piRow) PURE;
    STDMETHOD(put_RowIndex)(THIS_ int iRow) PURE;
    STDMETHOD(get_Protection)(THIS_ MsoBarProtection FAR* pprot) PURE;
    STDMETHOD(put_Protection)(THIS_ MsoBarProtection prot) PURE;
    STDMETHOD(Reset)(THIS) PURE;
    STDMETHOD(ShowPopup)(THIS_ VARIANT x, VARIANT y) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* pypTop) PURE;
    STDMETHOD(put_Top)(THIS_ int ypTop) PURE;
    STDMETHOD(get_Type)(THIS_ MsoBarType FAR* ptype) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL Visible) PURE;
    STDMETHOD(get_Width)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_Width)(THIS_ int dx) PURE;
    STDMETHOD(get_AdaptiveMenu)(THIS_ VARIANT_BOOL FAR* pvarfAdaptiveMenu) PURE;
    STDMETHOD(put_AdaptiveMenu)(THIS_ VARIANT_BOOL varfAdaptiveMenu) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
};

DEFINE_GUID(IID_CommandBarControls,0x000C0306L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBarControls */
#undef INTERFACE
#define INTERFACE CommandBarControls

DECLARE_INTERFACE_(CommandBarControls, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* CommandBarControls methods */
    STDMETHOD(Add)(THIS_ VARIANT Type, VARIANT Id, VARIANT Parameter, VARIANT Before, VARIANT Temporary, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pcToolbarControls) PURE;
    STDMETHOD(get_Item)(THIS_ VARIANT Index, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
    STDMETHOD(get_Parent)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
};

DEFINE_GUID(IID_CommandBarControl,0x000C0308L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBarControl */
#undef INTERFACE
#define INTERFACE CommandBarControl

DECLARE_INTERFACE_(CommandBarControl, _IMsoOleAccDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* CommandBarControl methods */
    STDMETHOD(get_BeginGroup)(THIS_ VARIANT_BOOL FAR* pvarfBeginGroup) PURE;
    STDMETHOD(put_BeginGroup)(THIS_ VARIANT_BOOL varfBeginGroup) PURE;
    STDMETHOD(get_BuiltIn)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(get_Caption)(THIS_ BSTR FAR* pbstrCaption) PURE;
    STDMETHOD(put_Caption)(THIS_ BSTR bstrCaption) PURE;
    STDMETHOD(get_Control)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Copy)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(Delete)(THIS_ VARIANT Temporary) PURE;
    STDMETHOD(get_DescriptionText)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_DescriptionText)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(get_Enabled)(THIS_ VARIANT_BOOL FAR* pvarfEnabled) PURE;
    STDMETHOD(put_Enabled)(THIS_ VARIANT_BOOL varfEnabled) PURE;
    STDMETHOD(Execute)(THIS) PURE;
    STDMETHOD(get_Height)(THIS_ int FAR* pdy) PURE;
    STDMETHOD(put_Height)(THIS_ int dy) PURE;
    STDMETHOD(get_HelpContextId)(THIS_ int FAR* pid) PURE;
    STDMETHOD(put_HelpContextId)(THIS_ int id) PURE;
    STDMETHOD(get_HelpFile)(THIS_ BSTR FAR* pbstrFilename) PURE;
    STDMETHOD(put_HelpFile)(THIS_ BSTR bstrFilename) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(get_Index)(THIS_ int FAR* pi) PURE;
    STDMETHOD(get_InstanceId)(THIS_ long FAR* pid) PURE;
    STDMETHOD(Move)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* px) PURE;
    STDMETHOD(get_OLEUsage)(THIS_ MsoControlOLEUsage FAR* pcou) PURE;
    STDMETHOD(put_OLEUsage)(THIS_ MsoControlOLEUsage cou) PURE;
    STDMETHOD(get_OnAction)(THIS_ BSTR FAR* pbstrOnAction) PURE;
    STDMETHOD(put_OnAction)(THIS_ BSTR bstrOnAction) PURE;
    STDMETHOD(get_Parent)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Parameter)(THIS_ BSTR FAR* pbstrParam) PURE;
    STDMETHOD(put_Parameter)(THIS_ BSTR bstrParam) PURE;
    STDMETHOD(get_Priority)(THIS_ int FAR* pnPri) PURE;
    STDMETHOD(put_Priority)(THIS_ int nPri) PURE;
    STDMETHOD(Reset)(THIS) PURE;
    STDMETHOD(SetFocus)(THIS) PURE;
    STDMETHOD(get_Tag)(THIS_ BSTR FAR* pbstrTag) PURE;
    STDMETHOD(put_Tag)(THIS_ BSTR bstrTag) PURE;
    STDMETHOD(get_TooltipText)(THIS_ BSTR FAR* pbstrTooltip) PURE;
    STDMETHOD(put_TooltipText)(THIS_ BSTR bstrTooltip) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* py) PURE;
    STDMETHOD(get_Type)(THIS_ MsoControlType FAR* ptype) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL varfVisible) PURE;
    STDMETHOD(get_Width)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_Width)(THIS_ int dx) PURE;
    STDMETHOD(get_IsPriorityDropped)(THIS_ VARIANT_BOOL FAR* pvarfDropped) PURE;
    STDMETHOD(Reserved1)(THIS) PURE;
    STDMETHOD(Reserved2)(THIS) PURE;
    STDMETHOD(Reserved3)(THIS) PURE;
    STDMETHOD(Reserved4)(THIS) PURE;
    STDMETHOD(Reserved5)(THIS) PURE;
    STDMETHOD(Reserved6)(THIS) PURE;
    STDMETHOD(Reserved7)(THIS) PURE;
};

DEFINE_GUID(IID_CommandBarButton,0x000C030EL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBarButton */
#undef INTERFACE
#define INTERFACE CommandBarButton

DECLARE_INTERFACE_(CommandBarButton, CommandBarControl)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;

    /* CommandBarControl methods */
    STDMETHOD(get_BeginGroup)(THIS_ VARIANT_BOOL FAR* pvarfBeginGroup) PURE;
    STDMETHOD(put_BeginGroup)(THIS_ VARIANT_BOOL varfBeginGroup) PURE;
    STDMETHOD(get_BuiltIn)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(get_Caption)(THIS_ BSTR FAR* pbstrCaption) PURE;
    STDMETHOD(put_Caption)(THIS_ BSTR bstrCaption) PURE;
    STDMETHOD(get_Control)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Copy)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(Delete)(THIS_ VARIANT Temporary) PURE;
    STDMETHOD(get_DescriptionText)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_DescriptionText)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(get_Enabled)(THIS_ VARIANT_BOOL FAR* pvarfEnabled) PURE;
    STDMETHOD(put_Enabled)(THIS_ VARIANT_BOOL varfEnabled) PURE;
    STDMETHOD(Execute)(THIS) PURE;
    STDMETHOD(get_Height)(THIS_ int FAR* pdy) PURE;
    STDMETHOD(put_Height)(THIS_ int dy) PURE;
    STDMETHOD(get_HelpContextId)(THIS_ int FAR* pid) PURE;
    STDMETHOD(put_HelpContextId)(THIS_ int id) PURE;
    STDMETHOD(get_HelpFile)(THIS_ BSTR FAR* pbstrFilename) PURE;
    STDMETHOD(put_HelpFile)(THIS_ BSTR bstrFilename) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(get_Index)(THIS_ int FAR* pi) PURE;
    STDMETHOD(get_InstanceId)(THIS_ long FAR* pid) PURE;
    STDMETHOD(Move)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* px) PURE;
    STDMETHOD(get_OLEUsage)(THIS_ MsoControlOLEUsage FAR* pcou) PURE;
    STDMETHOD(put_OLEUsage)(THIS_ MsoControlOLEUsage cou) PURE;
    STDMETHOD(get_OnAction)(THIS_ BSTR FAR* pbstrOnAction) PURE;
    STDMETHOD(put_OnAction)(THIS_ BSTR bstrOnAction) PURE;
    STDMETHOD(get_Parent)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Parameter)(THIS_ BSTR FAR* pbstrParam) PURE;
    STDMETHOD(put_Parameter)(THIS_ BSTR bstrParam) PURE;
    STDMETHOD(get_Priority)(THIS_ int FAR* pnPri) PURE;
    STDMETHOD(put_Priority)(THIS_ int nPri) PURE;
    STDMETHOD(Reset)(THIS) PURE;
    STDMETHOD(SetFocus)(THIS) PURE;
    STDMETHOD(get_Tag)(THIS_ BSTR FAR* pbstrTag) PURE;
    STDMETHOD(put_Tag)(THIS_ BSTR bstrTag) PURE;
    STDMETHOD(get_TooltipText)(THIS_ BSTR FAR* pbstrTooltip) PURE;
    STDMETHOD(put_TooltipText)(THIS_ BSTR bstrTooltip) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* py) PURE;
    STDMETHOD(get_Type)(THIS_ MsoControlType FAR* ptype) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL varfVisible) PURE;
    STDMETHOD(get_Width)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_Width)(THIS_ int dx) PURE;
    STDMETHOD(get_IsPriorityDropped)(THIS_ VARIANT_BOOL FAR* pvarfDropped) PURE;
    STDMETHOD(Reserved1)(THIS) PURE;
    STDMETHOD(Reserved2)(THIS) PURE;
    STDMETHOD(Reserved3)(THIS) PURE;
    STDMETHOD(Reserved4)(THIS) PURE;
    STDMETHOD(Reserved5)(THIS) PURE;
    STDMETHOD(Reserved6)(THIS) PURE;
    STDMETHOD(Reserved7)(THIS) PURE;
#endif

    /* CommandBarButton methods */
    STDMETHOD(get_BuiltInFace)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(put_BuiltInFace)(THIS_ VARIANT_BOOL varfBuiltIn) PURE;
    STDMETHOD(CopyFace)(THIS) PURE;
    STDMETHOD(get_FaceId)(THIS_ int FAR* pid) PURE;
    STDMETHOD(put_FaceId)(THIS_ int id) PURE;
    STDMETHOD(PasteFace)(THIS) PURE;
    STDMETHOD(get_ShortcutText)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_ShortcutText)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(get_State)(THIS_ MsoButtonState FAR* pstate) PURE;
    STDMETHOD(put_State)(THIS_ MsoButtonState state) PURE;
    STDMETHOD(get_Style)(THIS_ MsoButtonStyle FAR* pstyle) PURE;
    STDMETHOD(put_Style)(THIS_ MsoButtonStyle style) PURE;
    STDMETHOD(get_HyperlinkType)(THIS_ MsoCommandBarButtonHyperlinkType FAR* phlType) PURE;
    STDMETHOD(put_HyperlinkType)(THIS_ MsoCommandBarButtonHyperlinkType hlType) PURE;
    STDMETHOD(get_Picture)(THIS_ IPictureDisp FAR* FAR* ppdispPicture) PURE;
    STDMETHOD(put_Picture)(THIS_ IPictureDisp FAR* pdispPicture) PURE;
    STDMETHOD(get_Mask)(THIS_ IPictureDisp FAR* FAR* ppipictdispMask) PURE;
    STDMETHOD(put_Mask)(THIS_ IPictureDisp FAR* pipictdispMask) PURE;
};

DEFINE_GUID(IID_CommandBarPopup,0x000C030AL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBarPopup */
#undef INTERFACE
#define INTERFACE CommandBarPopup

DECLARE_INTERFACE_(CommandBarPopup, CommandBarControl)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;

    /* CommandBarControl methods */
    STDMETHOD(get_BeginGroup)(THIS_ VARIANT_BOOL FAR* pvarfBeginGroup) PURE;
    STDMETHOD(put_BeginGroup)(THIS_ VARIANT_BOOL varfBeginGroup) PURE;
    STDMETHOD(get_BuiltIn)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(get_Caption)(THIS_ BSTR FAR* pbstrCaption) PURE;
    STDMETHOD(put_Caption)(THIS_ BSTR bstrCaption) PURE;
    STDMETHOD(get_Control)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Copy)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(Delete)(THIS_ VARIANT Temporary) PURE;
    STDMETHOD(get_DescriptionText)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_DescriptionText)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(get_Enabled)(THIS_ VARIANT_BOOL FAR* pvarfEnabled) PURE;
    STDMETHOD(put_Enabled)(THIS_ VARIANT_BOOL varfEnabled) PURE;
    STDMETHOD(Execute)(THIS) PURE;
    STDMETHOD(get_Height)(THIS_ int FAR* pdy) PURE;
    STDMETHOD(put_Height)(THIS_ int dy) PURE;
    STDMETHOD(get_HelpContextId)(THIS_ int FAR* pid) PURE;
    STDMETHOD(put_HelpContextId)(THIS_ int id) PURE;
    STDMETHOD(get_HelpFile)(THIS_ BSTR FAR* pbstrFilename) PURE;
    STDMETHOD(put_HelpFile)(THIS_ BSTR bstrFilename) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(get_Index)(THIS_ int FAR* pi) PURE;
    STDMETHOD(get_InstanceId)(THIS_ long FAR* pid) PURE;
    STDMETHOD(Move)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* px) PURE;
    STDMETHOD(get_OLEUsage)(THIS_ MsoControlOLEUsage FAR* pcou) PURE;
    STDMETHOD(put_OLEUsage)(THIS_ MsoControlOLEUsage cou) PURE;
    STDMETHOD(get_OnAction)(THIS_ BSTR FAR* pbstrOnAction) PURE;
    STDMETHOD(put_OnAction)(THIS_ BSTR bstrOnAction) PURE;
    STDMETHOD(get_Parent)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Parameter)(THIS_ BSTR FAR* pbstrParam) PURE;
    STDMETHOD(put_Parameter)(THIS_ BSTR bstrParam) PURE;
    STDMETHOD(get_Priority)(THIS_ int FAR* pnPri) PURE;
    STDMETHOD(put_Priority)(THIS_ int nPri) PURE;
    STDMETHOD(Reset)(THIS) PURE;
    STDMETHOD(SetFocus)(THIS) PURE;
    STDMETHOD(get_Tag)(THIS_ BSTR FAR* pbstrTag) PURE;
    STDMETHOD(put_Tag)(THIS_ BSTR bstrTag) PURE;
    STDMETHOD(get_TooltipText)(THIS_ BSTR FAR* pbstrTooltip) PURE;
    STDMETHOD(put_TooltipText)(THIS_ BSTR bstrTooltip) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* py) PURE;
    STDMETHOD(get_Type)(THIS_ MsoControlType FAR* ptype) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL varfVisible) PURE;
    STDMETHOD(get_Width)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_Width)(THIS_ int dx) PURE;
    STDMETHOD(get_IsPriorityDropped)(THIS_ VARIANT_BOOL FAR* pvarfDropped) PURE;
    STDMETHOD(Reserved1)(THIS) PURE;
    STDMETHOD(Reserved2)(THIS) PURE;
    STDMETHOD(Reserved3)(THIS) PURE;
    STDMETHOD(Reserved4)(THIS) PURE;
    STDMETHOD(Reserved5)(THIS) PURE;
    STDMETHOD(Reserved6)(THIS) PURE;
    STDMETHOD(Reserved7)(THIS) PURE;
#endif

    /* CommandBarPopup methods */
    STDMETHOD(get_CommandBar)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Controls)(THIS_ CommandBarControls FAR* FAR* ppcbcs) PURE;
    STDMETHOD(get_OLEMenuGroup)(THIS_ MsoOLEMenuGroup FAR* pomg) PURE;
    STDMETHOD(put_OLEMenuGroup)(THIS_ MsoOLEMenuGroup omg) PURE;
};

DEFINE_GUID(IID_CommandBarComboBox,0x000C030CL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CommandBarComboBox */
#undef INTERFACE
#define INTERFACE CommandBarComboBox

DECLARE_INTERFACE_(CommandBarComboBox, CommandBarControl)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;

    /* CommandBarControl methods */
    STDMETHOD(get_BeginGroup)(THIS_ VARIANT_BOOL FAR* pvarfBeginGroup) PURE;
    STDMETHOD(put_BeginGroup)(THIS_ VARIANT_BOOL varfBeginGroup) PURE;
    STDMETHOD(get_BuiltIn)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(get_Caption)(THIS_ BSTR FAR* pbstrCaption) PURE;
    STDMETHOD(put_Caption)(THIS_ BSTR bstrCaption) PURE;
    STDMETHOD(get_Control)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Copy)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(Delete)(THIS_ VARIANT Temporary) PURE;
    STDMETHOD(get_DescriptionText)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_DescriptionText)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(get_Enabled)(THIS_ VARIANT_BOOL FAR* pvarfEnabled) PURE;
    STDMETHOD(put_Enabled)(THIS_ VARIANT_BOOL varfEnabled) PURE;
    STDMETHOD(Execute)(THIS) PURE;
    STDMETHOD(get_Height)(THIS_ int FAR* pdy) PURE;
    STDMETHOD(put_Height)(THIS_ int dy) PURE;
    STDMETHOD(get_HelpContextId)(THIS_ int FAR* pid) PURE;
    STDMETHOD(put_HelpContextId)(THIS_ int id) PURE;
    STDMETHOD(get_HelpFile)(THIS_ BSTR FAR* pbstrFilename) PURE;
    STDMETHOD(put_HelpFile)(THIS_ BSTR bstrFilename) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(get_Index)(THIS_ int FAR* pi) PURE;
    STDMETHOD(get_InstanceId)(THIS_ long FAR* pid) PURE;
    STDMETHOD(Move)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* px) PURE;
    STDMETHOD(get_OLEUsage)(THIS_ MsoControlOLEUsage FAR* pcou) PURE;
    STDMETHOD(put_OLEUsage)(THIS_ MsoControlOLEUsage cou) PURE;
    STDMETHOD(get_OnAction)(THIS_ BSTR FAR* pbstrOnAction) PURE;
    STDMETHOD(put_OnAction)(THIS_ BSTR bstrOnAction) PURE;
    STDMETHOD(get_Parent)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Parameter)(THIS_ BSTR FAR* pbstrParam) PURE;
    STDMETHOD(put_Parameter)(THIS_ BSTR bstrParam) PURE;
    STDMETHOD(get_Priority)(THIS_ int FAR* pnPri) PURE;
    STDMETHOD(put_Priority)(THIS_ int nPri) PURE;
    STDMETHOD(Reset)(THIS) PURE;
    STDMETHOD(SetFocus)(THIS) PURE;
    STDMETHOD(get_Tag)(THIS_ BSTR FAR* pbstrTag) PURE;
    STDMETHOD(put_Tag)(THIS_ BSTR bstrTag) PURE;
    STDMETHOD(get_TooltipText)(THIS_ BSTR FAR* pbstrTooltip) PURE;
    STDMETHOD(put_TooltipText)(THIS_ BSTR bstrTooltip) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* py) PURE;
    STDMETHOD(get_Type)(THIS_ MsoControlType FAR* ptype) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL varfVisible) PURE;
    STDMETHOD(get_Width)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_Width)(THIS_ int dx) PURE;
    STDMETHOD(get_IsPriorityDropped)(THIS_ VARIANT_BOOL FAR* pvarfDropped) PURE;
    STDMETHOD(Reserved1)(THIS) PURE;
    STDMETHOD(Reserved2)(THIS) PURE;
    STDMETHOD(Reserved3)(THIS) PURE;
    STDMETHOD(Reserved4)(THIS) PURE;
    STDMETHOD(Reserved5)(THIS) PURE;
    STDMETHOD(Reserved6)(THIS) PURE;
    STDMETHOD(Reserved7)(THIS) PURE;
#endif

    /* CommandBarComboBox methods */
    STDMETHOD(AddItem)(THIS_ BSTR Text, VARIANT Index) PURE;
    STDMETHOD(Clear)(THIS) PURE;
    STDMETHOD(get_DropDownLines)(THIS_ int FAR* pcLines) PURE;
    STDMETHOD(put_DropDownLines)(THIS_ int cLines) PURE;
    STDMETHOD(get_DropDownWidth)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_DropDownWidth)(THIS_ int dx) PURE;
    STDMETHOD(get_List)(THIS_ int Index, BSTR FAR* pbstrItem) PURE;
    STDMETHOD(put_List)(THIS_ int Index, BSTR bstrItem) PURE;
    STDMETHOD(get_ListCount)(THIS_ int FAR* pcItems) PURE;
    STDMETHOD(get_ListHeaderCount)(THIS_ int FAR* pcItems) PURE;
    STDMETHOD(put_ListHeaderCount)(THIS_ int cItems) PURE;
    STDMETHOD(get_ListIndex)(THIS_ int FAR* pi) PURE;
    STDMETHOD(put_ListIndex)(THIS_ int i) PURE;
    STDMETHOD(RemoveItem)(THIS_ int Index) PURE;
    STDMETHOD(get_Style)(THIS_ MsoComboStyle FAR* pstyle) PURE;
    STDMETHOD(put_Style)(THIS_ MsoComboStyle style) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR bstrText) PURE;
};

DEFINE_GUID(IID__CommandBarActiveX,0x000C030DL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: _CommandBarActiveX */
#undef INTERFACE
#define INTERFACE _CommandBarActiveX

DECLARE_INTERFACE_(_CommandBarActiveX, CommandBarControl)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* IAccessible methods */
    STDMETHOD(get_accParent)(THIS_ IDispatch * FAR* ppdispParent) PURE;
    STDMETHOD(get_accChildCount)(THIS_ long FAR* pcountChildren) PURE;
    STDMETHOD(get_accChild)(THIS_ VARIANT varChild, IDispatch * FAR* ppdispChild) PURE;
    STDMETHOD(get_accName)(THIS_ VARIANT varChild, BSTR FAR* pszName) PURE;
    STDMETHOD(get_accValue)(THIS_ VARIANT varChild, BSTR FAR* pszValue) PURE;
    STDMETHOD(get_accDescription)(THIS_ VARIANT varChild, BSTR FAR* pszDescription) PURE;
    STDMETHOD(get_accRole)(THIS_ VARIANT varChild, VARIANT FAR* pvarRole) PURE;
    STDMETHOD(get_accState)(THIS_ VARIANT varChild, VARIANT FAR* pvarState) PURE;
    STDMETHOD(get_accHelp)(THIS_ VARIANT varChild, BSTR FAR* pszHelp) PURE;
    STDMETHOD(get_accHelpTopic)(THIS_ BSTR FAR* pszHelpFile, VARIANT varChild, long FAR* pidTopic) PURE;
    STDMETHOD(get_accKeyboardShortcut)(THIS_ VARIANT varChild, BSTR FAR* pszKeyboardShortcut) PURE;
    STDMETHOD(get_accFocus)(THIS_ VARIANT FAR* pvarChild) PURE;
    STDMETHOD(get_accSelection)(THIS_ VARIANT FAR* pvarChildren) PURE;
    STDMETHOD(get_accDefaultAction)(THIS_ VARIANT varChild, BSTR FAR* pszDefaultAction) PURE;
    STDMETHOD(accSelect)(THIS_ long flagsSelect, VARIANT varChild) PURE;
    STDMETHOD(accLocation)(THIS_ long FAR* pxLeft, long FAR* pyTop, long FAR* pcxWidth, long FAR* pcyHeight, VARIANT varChild) PURE;
    STDMETHOD(accNavigate)(THIS_ long navDir, VARIANT varStart, VARIANT FAR* pvarEndUpAt) PURE;
    STDMETHOD(accHitTest)(THIS_ long xLeft, long yTop, VARIANT FAR* pvarChild) PURE;
    STDMETHOD(accDoDefaultAction)(THIS_ VARIANT varChild) PURE;
    STDMETHOD(put_accName)(THIS_ VARIANT varChild, BSTR szName) PURE;
    STDMETHOD(put_accValue)(THIS_ VARIANT varChild, BSTR szValue) PURE;

    /* _IMsoOleAccDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;

    /* CommandBarControl methods */
    STDMETHOD(get_BeginGroup)(THIS_ VARIANT_BOOL FAR* pvarfBeginGroup) PURE;
    STDMETHOD(put_BeginGroup)(THIS_ VARIANT_BOOL varfBeginGroup) PURE;
    STDMETHOD(get_BuiltIn)(THIS_ VARIANT_BOOL FAR* pvarfBuiltIn) PURE;
    STDMETHOD(get_Caption)(THIS_ BSTR FAR* pbstrCaption) PURE;
    STDMETHOD(put_Caption)(THIS_ BSTR bstrCaption) PURE;
    STDMETHOD(get_Control)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Copy)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(Delete)(THIS_ VARIANT Temporary) PURE;
    STDMETHOD(get_DescriptionText)(THIS_ BSTR FAR* pbstrText) PURE;
    STDMETHOD(put_DescriptionText)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(get_Enabled)(THIS_ VARIANT_BOOL FAR* pvarfEnabled) PURE;
    STDMETHOD(put_Enabled)(THIS_ VARIANT_BOOL varfEnabled) PURE;
    STDMETHOD(Execute)(THIS) PURE;
    STDMETHOD(get_Height)(THIS_ int FAR* pdy) PURE;
    STDMETHOD(put_Height)(THIS_ int dy) PURE;
    STDMETHOD(get_HelpContextId)(THIS_ int FAR* pid) PURE;
    STDMETHOD(put_HelpContextId)(THIS_ int id) PURE;
    STDMETHOD(get_HelpFile)(THIS_ BSTR FAR* pbstrFilename) PURE;
    STDMETHOD(put_HelpFile)(THIS_ BSTR bstrFilename) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(get_Index)(THIS_ int FAR* pi) PURE;
    STDMETHOD(get_InstanceId)(THIS_ long FAR* pid) PURE;
    STDMETHOD(Move)(THIS_ VARIANT Bar, VARIANT Before, CommandBarControl FAR* FAR* ppcbc) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* px) PURE;
    STDMETHOD(get_OLEUsage)(THIS_ MsoControlOLEUsage FAR* pcou) PURE;
    STDMETHOD(put_OLEUsage)(THIS_ MsoControlOLEUsage cou) PURE;
    STDMETHOD(get_OnAction)(THIS_ BSTR FAR* pbstrOnAction) PURE;
    STDMETHOD(put_OnAction)(THIS_ BSTR bstrOnAction) PURE;
    STDMETHOD(get_Parent)(THIS_ CommandBar FAR* FAR* ppcb) PURE;
    STDMETHOD(get_Parameter)(THIS_ BSTR FAR* pbstrParam) PURE;
    STDMETHOD(put_Parameter)(THIS_ BSTR bstrParam) PURE;
    STDMETHOD(get_Priority)(THIS_ int FAR* pnPri) PURE;
    STDMETHOD(put_Priority)(THIS_ int nPri) PURE;
    STDMETHOD(Reset)(THIS) PURE;
    STDMETHOD(SetFocus)(THIS) PURE;
    STDMETHOD(get_Tag)(THIS_ BSTR FAR* pbstrTag) PURE;
    STDMETHOD(put_Tag)(THIS_ BSTR bstrTag) PURE;
    STDMETHOD(get_TooltipText)(THIS_ BSTR FAR* pbstrTooltip) PURE;
    STDMETHOD(put_TooltipText)(THIS_ BSTR bstrTooltip) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* py) PURE;
    STDMETHOD(get_Type)(THIS_ MsoControlType FAR* ptype) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL varfVisible) PURE;
    STDMETHOD(get_Width)(THIS_ int FAR* pdx) PURE;
    STDMETHOD(put_Width)(THIS_ int dx) PURE;
    STDMETHOD(get_IsPriorityDropped)(THIS_ VARIANT_BOOL FAR* pvarfDropped) PURE;
    STDMETHOD(Reserved1)(THIS) PURE;
    STDMETHOD(Reserved2)(THIS) PURE;
    STDMETHOD(Reserved3)(THIS) PURE;
    STDMETHOD(Reserved4)(THIS) PURE;
    STDMETHOD(Reserved5)(THIS) PURE;
    STDMETHOD(Reserved6)(THIS) PURE;
    STDMETHOD(Reserved7)(THIS) PURE;
#endif

    /* _CommandBarActiveX methods */
    STDMETHOD(get_ControlCLSID)(THIS_ BSTR FAR* pbstrClsid) PURE;
    STDMETHOD(put_ControlCLSID)(THIS_ BSTR bstrClsid) PURE;
    STDMETHOD(get_QueryControlInterface)(THIS_ BSTR bstrIid, IUnknown * FAR* ppUnk) PURE;
    STDMETHOD(SetInnerObjectFactory)(THIS_ IUnknown * pUnk) PURE;
    STDMETHOD(EnsureControl)(THIS) PURE;
    STDMETHOD(put_InitWith)(THIS_ IUnknown * pStm) PURE;
};

DEFINE_GUID(IID_Adjustments,0x000C0310L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Adjustments */
#undef INTERFACE
#define INTERFACE Adjustments

DECLARE_INTERFACE_(Adjustments, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Adjustments methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* Count) PURE;
    STDMETHOD(get_Item)(THIS_ int Index, float FAR* Val) PURE;
    STDMETHOD(put_Item)(THIS_ int Index, float Val) PURE;
};

DEFINE_GUID(IID_CalloutFormat,0x000C0311L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CalloutFormat */
#undef INTERFACE
#define INTERFACE CalloutFormat

DECLARE_INTERFACE_(CalloutFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* CalloutFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(AutomaticLength)(THIS) PURE;
    STDMETHOD(CustomDrop)(THIS_ float Drop) PURE;
    STDMETHOD(CustomLength)(THIS_ float Length) PURE;
    STDMETHOD(PresetDrop)(THIS_ MsoCalloutDropType DropType) PURE;
    STDMETHOD(get_Accent)(THIS_ MsoTriState FAR* Accent) PURE;
    STDMETHOD(put_Accent)(THIS_ MsoTriState Accent) PURE;
    STDMETHOD(get_Angle)(THIS_ MsoCalloutAngleType FAR* Angle) PURE;
    STDMETHOD(put_Angle)(THIS_ MsoCalloutAngleType Angle) PURE;
    STDMETHOD(get_AutoAttach)(THIS_ MsoTriState FAR* AutoAttach) PURE;
    STDMETHOD(put_AutoAttach)(THIS_ MsoTriState AutoAttach) PURE;
    STDMETHOD(get_AutoLength)(THIS_ MsoTriState FAR* AutoLength) PURE;
    STDMETHOD(get_Border)(THIS_ MsoTriState FAR* Border) PURE;
    STDMETHOD(put_Border)(THIS_ MsoTriState Border) PURE;
    STDMETHOD(get_Drop)(THIS_ float FAR* Drop) PURE;
    STDMETHOD(get_DropType)(THIS_ MsoCalloutDropType FAR* DropType) PURE;
    STDMETHOD(get_Gap)(THIS_ float FAR* Gap) PURE;
    STDMETHOD(put_Gap)(THIS_ float Gap) PURE;
    STDMETHOD(get_Length)(THIS_ float FAR* Length) PURE;
    STDMETHOD(get_Type)(THIS_ MsoCalloutType FAR* Type) PURE;
    STDMETHOD(put_Type)(THIS_ MsoCalloutType Type) PURE;
};

DEFINE_GUID(IID_ColorFormat,0x000C0312L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ColorFormat */
#undef INTERFACE
#define INTERFACE ColorFormat

DECLARE_INTERFACE_(ColorFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ColorFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_RGB)(THIS_ MsoRGBType FAR* RGB) PURE;
    STDMETHOD(put_RGB)(THIS_ MsoRGBType RGB) PURE;
    STDMETHOD(get_SchemeColor)(THIS_ int FAR* SchemeColor) PURE;
    STDMETHOD(put_SchemeColor)(THIS_ int SchemeColor) PURE;
    STDMETHOD(get_Type)(THIS_ MsoColorType FAR* Type) PURE;
    STDMETHOD(get_TintAndShade)(THIS_ float FAR* pValue) PURE;
    STDMETHOD(put_TintAndShade)(THIS_ float value) PURE;
};

DEFINE_GUID(IID_ConnectorFormat,0x000C0313L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ConnectorFormat */
#undef INTERFACE
#define INTERFACE ConnectorFormat

DECLARE_INTERFACE_(ConnectorFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ConnectorFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(BeginConnect)(THIS_ Shape FAR* ConnectedShape, int ConnectionSite) PURE;
    STDMETHOD(BeginDisconnect)(THIS) PURE;
    STDMETHOD(EndConnect)(THIS_ Shape FAR* ConnectedShape, int ConnectionSite) PURE;
    STDMETHOD(EndDisconnect)(THIS) PURE;
    STDMETHOD(get_BeginConnected)(THIS_ MsoTriState FAR* BeginConnected) PURE;
    STDMETHOD(get_BeginConnectedShape)(THIS_ Shape FAR* FAR* BeginConnectedShape) PURE;
    STDMETHOD(get_BeginConnectionSite)(THIS_ int FAR* BeginConnectionSite) PURE;
    STDMETHOD(get_EndConnected)(THIS_ MsoTriState FAR* EndConnected) PURE;
    STDMETHOD(get_EndConnectedShape)(THIS_ Shape FAR* FAR* EndConnectedShape) PURE;
    STDMETHOD(get_EndConnectionSite)(THIS_ int FAR* EndConnectionSite) PURE;
    STDMETHOD(get_Type)(THIS_ MsoConnectorType FAR* Type) PURE;
    STDMETHOD(put_Type)(THIS_ MsoConnectorType Type) PURE;
};

DEFINE_GUID(IID_FillFormat,0x000C0314L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FillFormat */
#undef INTERFACE
#define INTERFACE FillFormat

DECLARE_INTERFACE_(FillFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FillFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(Background)(THIS) PURE;
    STDMETHOD(OneColorGradient)(THIS_ MsoGradientStyle Style, int Variant, float Degree) PURE;
    STDMETHOD(Patterned)(THIS_ MsoPatternType Pattern) PURE;
    STDMETHOD(PresetGradient)(THIS_ MsoGradientStyle Style, int Variant, MsoPresetGradientType PresetGradientType) PURE;
    STDMETHOD(PresetTextured)(THIS_ MsoPresetTexture PresetTexture) PURE;
    STDMETHOD(Solid)(THIS) PURE;
    STDMETHOD(TwoColorGradient)(THIS_ MsoGradientStyle Style, int Variant) PURE;
    STDMETHOD(UserPicture)(THIS_ BSTR PictureFile) PURE;
    STDMETHOD(UserTextured)(THIS_ BSTR TextureFile) PURE;
    STDMETHOD(get_BackColor)(THIS_ ColorFormat FAR* FAR* BackColor) PURE;
    STDMETHOD(put_BackColor)(THIS_ ColorFormat FAR* BackColor) PURE;
    STDMETHOD(get_ForeColor)(THIS_ ColorFormat FAR* FAR* ForeColor) PURE;
    STDMETHOD(put_ForeColor)(THIS_ ColorFormat FAR* ForeColor) PURE;
    STDMETHOD(get_GradientColorType)(THIS_ MsoGradientColorType FAR* GradientColorType) PURE;
    STDMETHOD(get_GradientDegree)(THIS_ float FAR* GradientDegree) PURE;
    STDMETHOD(get_GradientStyle)(THIS_ MsoGradientStyle FAR* GradientStyle) PURE;
    STDMETHOD(get_GradientVariant)(THIS_ int FAR* GradientVariant) PURE;
    STDMETHOD(get_Pattern)(THIS_ MsoPatternType FAR* Pattern) PURE;
    STDMETHOD(get_PresetGradientType)(THIS_ MsoPresetGradientType FAR* PresetGradientType) PURE;
    STDMETHOD(get_PresetTexture)(THIS_ MsoPresetTexture FAR* PresetTexture) PURE;
    STDMETHOD(get_TextureName)(THIS_ BSTR FAR* TextureName) PURE;
    STDMETHOD(get_TextureType)(THIS_ MsoTextureType FAR* TextureType) PURE;
    STDMETHOD(get_Transparency)(THIS_ float FAR* Transparency) PURE;
    STDMETHOD(put_Transparency)(THIS_ float Transparency) PURE;
    STDMETHOD(get_Type)(THIS_ MsoFillType FAR* Type) PURE;
    STDMETHOD(get_Visible)(THIS_ MsoTriState FAR* Visible) PURE;
    STDMETHOD(put_Visible)(THIS_ MsoTriState Visible) PURE;
};

DEFINE_GUID(IID_FreeformBuilder,0x000C0315L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FreeformBuilder */
#undef INTERFACE
#define INTERFACE FreeformBuilder

DECLARE_INTERFACE_(FreeformBuilder, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FreeformBuilder methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(AddNodes)(THIS_ MsoSegmentType SegmentType, MsoEditingType EditingType, float X1, float Y1, float X2, float Y2, float X3, float Y3) PURE;
    STDMETHOD(ConvertToShape)(THIS_ Shape FAR* FAR* Freeform) PURE;
};

DEFINE_GUID(IID_GroupShapes,0x000C0316L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: GroupShapes */
#undef INTERFACE
#define INTERFACE GroupShapes

DECLARE_INTERFACE_(GroupShapes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* GroupShapes methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pnShapes) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, Shape FAR* FAR* Item) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
    STDMETHOD(Range)(THIS_ VARIANT Index, ShapeRange FAR* FAR* Range) PURE;
};

DEFINE_GUID(IID_LineFormat,0x000C0317L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: LineFormat */
#undef INTERFACE
#define INTERFACE LineFormat

DECLARE_INTERFACE_(LineFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* LineFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_BackColor)(THIS_ ColorFormat FAR* FAR* BackColor) PURE;
    STDMETHOD(put_BackColor)(THIS_ ColorFormat FAR* BackColor) PURE;
    STDMETHOD(get_BeginArrowheadLength)(THIS_ MsoArrowheadLength FAR* BeginArrowheadLength) PURE;
    STDMETHOD(put_BeginArrowheadLength)(THIS_ MsoArrowheadLength BeginArrowheadLength) PURE;
    STDMETHOD(get_BeginArrowheadStyle)(THIS_ MsoArrowheadStyle FAR* BeginArrowheadStyle) PURE;
    STDMETHOD(put_BeginArrowheadStyle)(THIS_ MsoArrowheadStyle BeginArrowheadStyle) PURE;
    STDMETHOD(get_BeginArrowheadWidth)(THIS_ MsoArrowheadWidth FAR* BeginArrowheadWidth) PURE;
    STDMETHOD(put_BeginArrowheadWidth)(THIS_ MsoArrowheadWidth BeginArrowheadWidth) PURE;
    STDMETHOD(get_DashStyle)(THIS_ MsoLineDashStyle FAR* DashStyle) PURE;
    STDMETHOD(put_DashStyle)(THIS_ MsoLineDashStyle DashStyle) PURE;
    STDMETHOD(get_EndArrowheadLength)(THIS_ MsoArrowheadLength FAR* EndArrowheadLength) PURE;
    STDMETHOD(put_EndArrowheadLength)(THIS_ MsoArrowheadLength EndArrowheadLength) PURE;
    STDMETHOD(get_EndArrowheadStyle)(THIS_ MsoArrowheadStyle FAR* EndArrowheadStyle) PURE;
    STDMETHOD(put_EndArrowheadStyle)(THIS_ MsoArrowheadStyle EndArrowheadStyle) PURE;
    STDMETHOD(get_EndArrowheadWidth)(THIS_ MsoArrowheadWidth FAR* EndArrowheadWidth) PURE;
    STDMETHOD(put_EndArrowheadWidth)(THIS_ MsoArrowheadWidth EndArrowheadWidth) PURE;
    STDMETHOD(get_ForeColor)(THIS_ ColorFormat FAR* FAR* ForeColor) PURE;
    STDMETHOD(put_ForeColor)(THIS_ ColorFormat FAR* ForeColor) PURE;
    STDMETHOD(get_Pattern)(THIS_ MsoPatternType FAR* Pattern) PURE;
    STDMETHOD(put_Pattern)(THIS_ MsoPatternType Pattern) PURE;
    STDMETHOD(get_Style)(THIS_ MsoLineStyle FAR* Style) PURE;
    STDMETHOD(put_Style)(THIS_ MsoLineStyle Style) PURE;
    STDMETHOD(get_Transparency)(THIS_ float FAR* Transparency) PURE;
    STDMETHOD(put_Transparency)(THIS_ float Transparency) PURE;
    STDMETHOD(get_Visible)(THIS_ MsoTriState FAR* Visible) PURE;
    STDMETHOD(put_Visible)(THIS_ MsoTriState Visible) PURE;
    STDMETHOD(get_Weight)(THIS_ float FAR* Weight) PURE;
    STDMETHOD(put_Weight)(THIS_ float Weight) PURE;
    STDMETHOD(get_InsetPen)(THIS_ MsoTriState FAR* InsetPen) PURE;
    STDMETHOD(put_InsetPen)(THIS_ MsoTriState InsetPen) PURE;
};

DEFINE_GUID(IID_ShapeNode,0x000C0318L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ShapeNode */
#undef INTERFACE
#define INTERFACE ShapeNode

DECLARE_INTERFACE_(ShapeNode, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ShapeNode methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_EditingType)(THIS_ MsoEditingType FAR* EditingType) PURE;
    STDMETHOD(get_Points)(THIS_ VARIANT FAR* Points) PURE;
    STDMETHOD(get_SegmentType)(THIS_ MsoSegmentType FAR* SegmentType) PURE;
};

DEFINE_GUID(IID_ShapeNodes,0x000C0319L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ShapeNodes */
#undef INTERFACE
#define INTERFACE ShapeNodes

DECLARE_INTERFACE_(ShapeNodes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ShapeNodes methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* Count) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, ShapeNode FAR* FAR* Item) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* _NewEnum) PURE;
    STDMETHOD(Delete)(THIS_ int Index) PURE;
    STDMETHOD(Insert)(THIS_ int Index, MsoSegmentType SegmentType, MsoEditingType EditingType, float X1, float Y1, float X2, float Y2, float X3, float Y3) PURE;
    STDMETHOD(SetEditingType)(THIS_ int Index, MsoEditingType EditingType) PURE;
    STDMETHOD(SetPosition)(THIS_ int Index, float X1, float Y1) PURE;
    STDMETHOD(SetSegmentType)(THIS_ int Index, MsoSegmentType SegmentType) PURE;
};

DEFINE_GUID(IID_PictureFormat,0x000C031AL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: PictureFormat */
#undef INTERFACE
#define INTERFACE PictureFormat

DECLARE_INTERFACE_(PictureFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* PictureFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(IncrementBrightness)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementContrast)(THIS_ float Increment) PURE;
    STDMETHOD(get_Brightness)(THIS_ float FAR* Brightness) PURE;
    STDMETHOD(put_Brightness)(THIS_ float Brightness) PURE;
    STDMETHOD(get_ColorType)(THIS_ MsoPictureColorType FAR* ColorType) PURE;
    STDMETHOD(put_ColorType)(THIS_ MsoPictureColorType ColorType) PURE;
    STDMETHOD(get_Contrast)(THIS_ float FAR* Contrast) PURE;
    STDMETHOD(put_Contrast)(THIS_ float Contrast) PURE;
    STDMETHOD(get_CropBottom)(THIS_ float FAR* CropBottom) PURE;
    STDMETHOD(put_CropBottom)(THIS_ float CropBottom) PURE;
    STDMETHOD(get_CropLeft)(THIS_ float FAR* CropLeft) PURE;
    STDMETHOD(put_CropLeft)(THIS_ float CropLeft) PURE;
    STDMETHOD(get_CropRight)(THIS_ float FAR* CropRight) PURE;
    STDMETHOD(put_CropRight)(THIS_ float CropRight) PURE;
    STDMETHOD(get_CropTop)(THIS_ float FAR* CropTop) PURE;
    STDMETHOD(put_CropTop)(THIS_ float CropTop) PURE;
    STDMETHOD(get_TransparencyColor)(THIS_ MsoRGBType FAR* TransparencyColor) PURE;
    STDMETHOD(put_TransparencyColor)(THIS_ MsoRGBType TransparencyColor) PURE;
    STDMETHOD(get_TransparentBackground)(THIS_ MsoTriState FAR* TransparentBackground) PURE;
    STDMETHOD(put_TransparentBackground)(THIS_ MsoTriState TransparentBackground) PURE;
};

DEFINE_GUID(IID_ShadowFormat,0x000C031BL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ShadowFormat */
#undef INTERFACE
#define INTERFACE ShadowFormat

DECLARE_INTERFACE_(ShadowFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ShadowFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(IncrementOffsetX)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementOffsetY)(THIS_ float Increment) PURE;
    STDMETHOD(get_ForeColor)(THIS_ ColorFormat FAR* FAR* ForeColor) PURE;
    STDMETHOD(put_ForeColor)(THIS_ ColorFormat FAR* ForeColor) PURE;
    STDMETHOD(get_Obscured)(THIS_ MsoTriState FAR* Obscured) PURE;
    STDMETHOD(put_Obscured)(THIS_ MsoTriState Obscured) PURE;
    STDMETHOD(get_OffsetX)(THIS_ float FAR* OffsetX) PURE;
    STDMETHOD(put_OffsetX)(THIS_ float OffsetX) PURE;
    STDMETHOD(get_OffsetY)(THIS_ float FAR* OffsetY) PURE;
    STDMETHOD(put_OffsetY)(THIS_ float OffsetY) PURE;
    STDMETHOD(get_Transparency)(THIS_ float FAR* Transparency) PURE;
    STDMETHOD(put_Transparency)(THIS_ float Transparency) PURE;
    STDMETHOD(get_Type)(THIS_ MsoShadowType FAR* Type) PURE;
    STDMETHOD(put_Type)(THIS_ MsoShadowType Type) PURE;
    STDMETHOD(get_Visible)(THIS_ MsoTriState FAR* Visible) PURE;
    STDMETHOD(put_Visible)(THIS_ MsoTriState Visible) PURE;
};

typedef enum {
    msoScriptLanguageJava = 1,
    msoScriptLanguageVisualBasic = 2,
    msoScriptLanguageASP = 3,
    msoScriptLanguageOther = 4
} MsoScriptLanguage;

typedef enum {
    msoScriptLocationInHead = 1,
    msoScriptLocationInBody = 2
} MsoScriptLocation;

DEFINE_GUID(IID_Script,0x000C0341L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Script */
#undef INTERFACE
#define INTERFACE Script

DECLARE_INTERFACE_(Script, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Script methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Extended)(THIS_ BSTR FAR* Extended) PURE;
    STDMETHOD(put_Extended)(THIS_ BSTR Extended) PURE;
    STDMETHOD(get_Id)(THIS_ BSTR FAR* Id) PURE;
    STDMETHOD(put_Id)(THIS_ BSTR Id) PURE;
    STDMETHOD(get_Language)(THIS_ MsoScriptLanguage FAR* Language) PURE;
    STDMETHOD(put_Language)(THIS_ MsoScriptLanguage Language) PURE;
    STDMETHOD(get_Location)(THIS_ MsoScriptLocation FAR* Location) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(get_Shape)(THIS_ IDispatch * FAR* Object) PURE;
    STDMETHOD(get_ScriptText)(THIS_ BSTR FAR* Script) PURE;
    STDMETHOD(put_ScriptText)(THIS_ BSTR Script) PURE;
};

DEFINE_GUID(IID_Scripts,0x000C0340L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Scripts */
#undef INTERFACE
#define INTERFACE Scripts

DECLARE_INTERFACE_(Scripts, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Scripts methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* Count) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* _NewEnum) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, Script FAR* FAR* Item) PURE;
    STDMETHOD(Add)(THIS_ IDispatch * Anchor, MsoScriptLocation Location, MsoScriptLanguage Language, BSTR Id, BSTR Extended, BSTR ScriptText, Script FAR* FAR* Add) PURE;
    STDMETHOD(Delete)(THIS) PURE;
};

DEFINE_GUID(IID_Shape,0x000C031CL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Shape */
#undef INTERFACE
#define INTERFACE Shape

DECLARE_INTERFACE_(Shape, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Shape methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(Apply)(THIS) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(Duplicate)(THIS_ Shape FAR* FAR* Duplicate) PURE;
    STDMETHOD(Flip)(THIS_ MsoFlipCmd FlipCmd) PURE;
    STDMETHOD(IncrementLeft)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementRotation)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementTop)(THIS_ float Increment) PURE;
    STDMETHOD(PickUp)(THIS) PURE;
    STDMETHOD(RerouteConnections)(THIS) PURE;
    STDMETHOD(ScaleHeight)(THIS_ float Factor, MsoTriState RelativeToOriginalSize, MsoScaleFrom fScale) PURE;
    STDMETHOD(ScaleWidth)(THIS_ float Factor, MsoTriState RelativeToOriginalSize, MsoScaleFrom fScale) PURE;
    STDMETHOD(Select)(THIS_ VARIANT Replace) PURE;
    STDMETHOD(SetShapesDefaultProperties)(THIS) PURE;
    STDMETHOD(Ungroup)(THIS_ ShapeRange FAR* FAR* Ungroup) PURE;
    STDMETHOD(ZOrder)(THIS_ MsoZOrderCmd ZOrderCmd) PURE;
    STDMETHOD(get_Adjustments)(THIS_ Adjustments FAR* FAR* Adjustments) PURE;
    STDMETHOD(get_AutoShapeType)(THIS_ MsoAutoShapeType FAR* AutoShapeType) PURE;
    STDMETHOD(put_AutoShapeType)(THIS_ MsoAutoShapeType AutoShapeType) PURE;
    STDMETHOD(get_BlackWhiteMode)(THIS_ MsoBlackWhiteMode FAR* BlackWhiteMode) PURE;
    STDMETHOD(put_BlackWhiteMode)(THIS_ MsoBlackWhiteMode BlackWhiteMode) PURE;
    STDMETHOD(get_Callout)(THIS_ CalloutFormat FAR* FAR* Callout) PURE;
    STDMETHOD(get_ConnectionSiteCount)(THIS_ int FAR* ConnectionSiteCount) PURE;
    STDMETHOD(get_Connector)(THIS_ MsoTriState FAR* Connector) PURE;
    STDMETHOD(get_ConnectorFormat)(THIS_ ConnectorFormat FAR* FAR* ConnectorFormat) PURE;
    STDMETHOD(get_Fill)(THIS_ FillFormat FAR* FAR* Fill) PURE;
    STDMETHOD(get_GroupItems)(THIS_ GroupShapes FAR* FAR* GroupItems) PURE;
    STDMETHOD(get_Height)(THIS_ float FAR* Height) PURE;
    STDMETHOD(put_Height)(THIS_ float Height) PURE;
    STDMETHOD(get_HorizontalFlip)(THIS_ MsoTriState FAR* HorizontalFlip) PURE;
    STDMETHOD(get_Left)(THIS_ float FAR* Left) PURE;
    STDMETHOD(put_Left)(THIS_ float Left) PURE;
    STDMETHOD(get_Line)(THIS_ LineFormat FAR* FAR* Line) PURE;
    STDMETHOD(get_LockAspectRatio)(THIS_ MsoTriState FAR* LockAspectRatio) PURE;
    STDMETHOD(put_LockAspectRatio)(THIS_ MsoTriState LockAspectRatio) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* Name) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR Name) PURE;
    STDMETHOD(get_Nodes)(THIS_ ShapeNodes FAR* FAR* Nodes) PURE;
    STDMETHOD(get_Rotation)(THIS_ float FAR* Rotation) PURE;
    STDMETHOD(put_Rotation)(THIS_ float Rotation) PURE;
    STDMETHOD(get_PictureFormat)(THIS_ PictureFormat FAR* FAR* Picture) PURE;
    STDMETHOD(get_Shadow)(THIS_ ShadowFormat FAR* FAR* Shadow) PURE;
    STDMETHOD(get_TextEffect)(THIS_ TextEffectFormat FAR* FAR* TextEffect) PURE;
    STDMETHOD(get_TextFrame)(THIS_ TextFrame FAR* FAR* TextFrame) PURE;
    STDMETHOD(get_ThreeD)(THIS_ ThreeDFormat FAR* FAR* ThreeD) PURE;
    STDMETHOD(get_Top)(THIS_ float FAR* Top) PURE;
    STDMETHOD(put_Top)(THIS_ float Top) PURE;
    STDMETHOD(get_Type)(THIS_ MsoShapeType FAR* Type) PURE;
    STDMETHOD(get_VerticalFlip)(THIS_ MsoTriState FAR* VerticalFlip) PURE;
    STDMETHOD(get_Vertices)(THIS_ VARIANT FAR* Vertices) PURE;
    STDMETHOD(get_Visible)(THIS_ MsoTriState FAR* Visible) PURE;
    STDMETHOD(put_Visible)(THIS_ MsoTriState Visible) PURE;
    STDMETHOD(get_Width)(THIS_ float FAR* Width) PURE;
    STDMETHOD(put_Width)(THIS_ float Width) PURE;
    STDMETHOD(get_ZOrderPosition)(THIS_ int FAR* ZOrderPosition) PURE;
    STDMETHOD(get_Script)(THIS_ Script FAR* FAR* Script) PURE;
    STDMETHOD(get_AlternativeText)(THIS_ BSTR FAR* AlternativeText) PURE;
    STDMETHOD(put_AlternativeText)(THIS_ BSTR AlternativeText) PURE;
    STDMETHOD(get_HasDiagram)(THIS_ MsoTriState FAR* pHasDiagram) PURE;
    STDMETHOD(get_Diagram)(THIS_ IMsoDiagram FAR* FAR* Diagram) PURE;
    STDMETHOD(get_HasDiagramNode)(THIS_ MsoTriState FAR* pHasDiagram) PURE;
    STDMETHOD(get_DiagramNode)(THIS_ DiagramNode FAR* FAR* DiagramNode) PURE;
    STDMETHOD(get_Child)(THIS_ MsoTriState FAR* Child) PURE;
    STDMETHOD(get_ParentGroup)(THIS_ Shape FAR* FAR* Parent) PURE;
    STDMETHOD(get_CanvasItems)(THIS_ CanvasShapes FAR* FAR* CanvasShapes) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(CanvasCropLeft)(THIS_ float Increment) PURE;
    STDMETHOD(CanvasCropTop)(THIS_ float Increment) PURE;
    STDMETHOD(CanvasCropRight)(THIS_ float Increment) PURE;
    STDMETHOD(CanvasCropBottom)(THIS_ float Increment) PURE;
    STDMETHOD(put_RTF)(THIS_ BSTR Text) PURE;
};

DEFINE_GUID(IID_ShapeRange,0x000C031DL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ShapeRange */
#undef INTERFACE
#define INTERFACE ShapeRange

DECLARE_INTERFACE_(ShapeRange, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ShapeRange methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* Count) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, Shape FAR* FAR* Item) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* _NewEnum) PURE;
    STDMETHOD(Align)(THIS_ MsoAlignCmd AlignCmd, MsoTriState RelativeTo) PURE;
    STDMETHOD(Apply)(THIS) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(Distribute)(THIS_ MsoDistributeCmd DistributeCmd, MsoTriState RelativeTo) PURE;
    STDMETHOD(Duplicate)(THIS_ ShapeRange FAR* FAR* Duplicate) PURE;
    STDMETHOD(Flip)(THIS_ MsoFlipCmd FlipCmd) PURE;
    STDMETHOD(IncrementLeft)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementRotation)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementTop)(THIS_ float Increment) PURE;
    STDMETHOD(Group)(THIS_ Shape FAR* FAR* Group) PURE;
    STDMETHOD(PickUp)(THIS) PURE;
    STDMETHOD(Regroup)(THIS_ Shape FAR* FAR* Regroup) PURE;
    STDMETHOD(RerouteConnections)(THIS) PURE;
    STDMETHOD(ScaleHeight)(THIS_ float Factor, MsoTriState RelativeToOriginalSize, MsoScaleFrom fScale) PURE;
    STDMETHOD(ScaleWidth)(THIS_ float Factor, MsoTriState RelativeToOriginalSize, MsoScaleFrom fScale) PURE;
    STDMETHOD(Select)(THIS_ VARIANT Replace) PURE;
    STDMETHOD(SetShapesDefaultProperties)(THIS) PURE;
    STDMETHOD(Ungroup)(THIS_ ShapeRange FAR* FAR* Ungroup) PURE;
    STDMETHOD(ZOrder)(THIS_ MsoZOrderCmd ZOrderCmd) PURE;
    STDMETHOD(get_Adjustments)(THIS_ Adjustments FAR* FAR* Adjustments) PURE;
    STDMETHOD(get_AutoShapeType)(THIS_ MsoAutoShapeType FAR* AutoShapeType) PURE;
    STDMETHOD(put_AutoShapeType)(THIS_ MsoAutoShapeType AutoShapeType) PURE;
    STDMETHOD(get_BlackWhiteMode)(THIS_ MsoBlackWhiteMode FAR* BlackWhiteMode) PURE;
    STDMETHOD(put_BlackWhiteMode)(THIS_ MsoBlackWhiteMode BlackWhiteMode) PURE;
    STDMETHOD(get_Callout)(THIS_ CalloutFormat FAR* FAR* Callout) PURE;
    STDMETHOD(get_ConnectionSiteCount)(THIS_ int FAR* ConnectionSiteCount) PURE;
    STDMETHOD(get_Connector)(THIS_ MsoTriState FAR* Connector) PURE;
    STDMETHOD(get_ConnectorFormat)(THIS_ ConnectorFormat FAR* FAR* ConnectorFormat) PURE;
    STDMETHOD(get_Fill)(THIS_ FillFormat FAR* FAR* Fill) PURE;
    STDMETHOD(get_GroupItems)(THIS_ GroupShapes FAR* FAR* GroupItems) PURE;
    STDMETHOD(get_Height)(THIS_ float FAR* Height) PURE;
    STDMETHOD(put_Height)(THIS_ float Height) PURE;
    STDMETHOD(get_HorizontalFlip)(THIS_ MsoTriState FAR* HorizontalFlip) PURE;
    STDMETHOD(get_Left)(THIS_ float FAR* Left) PURE;
    STDMETHOD(put_Left)(THIS_ float Left) PURE;
    STDMETHOD(get_Line)(THIS_ LineFormat FAR* FAR* Line) PURE;
    STDMETHOD(get_LockAspectRatio)(THIS_ MsoTriState FAR* LockAspectRatio) PURE;
    STDMETHOD(put_LockAspectRatio)(THIS_ MsoTriState LockAspectRatio) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* Name) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR Name) PURE;
    STDMETHOD(get_Nodes)(THIS_ ShapeNodes FAR* FAR* Nodes) PURE;
    STDMETHOD(get_Rotation)(THIS_ float FAR* Rotation) PURE;
    STDMETHOD(put_Rotation)(THIS_ float Rotation) PURE;
    STDMETHOD(get_PictureFormat)(THIS_ PictureFormat FAR* FAR* Picture) PURE;
    STDMETHOD(get_Shadow)(THIS_ ShadowFormat FAR* FAR* Shadow) PURE;
    STDMETHOD(get_TextEffect)(THIS_ TextEffectFormat FAR* FAR* TextEffect) PURE;
    STDMETHOD(get_TextFrame)(THIS_ TextFrame FAR* FAR* TextFrame) PURE;
    STDMETHOD(get_ThreeD)(THIS_ ThreeDFormat FAR* FAR* ThreeD) PURE;
    STDMETHOD(get_Top)(THIS_ float FAR* Top) PURE;
    STDMETHOD(put_Top)(THIS_ float Top) PURE;
    STDMETHOD(get_Type)(THIS_ MsoShapeType FAR* Type) PURE;
    STDMETHOD(get_VerticalFlip)(THIS_ MsoTriState FAR* VerticalFlip) PURE;
    STDMETHOD(get_Vertices)(THIS_ VARIANT FAR* Vertices) PURE;
    STDMETHOD(get_Visible)(THIS_ MsoTriState FAR* Visible) PURE;
    STDMETHOD(put_Visible)(THIS_ MsoTriState Visible) PURE;
    STDMETHOD(get_Width)(THIS_ float FAR* Width) PURE;
    STDMETHOD(put_Width)(THIS_ float Width) PURE;
    STDMETHOD(get_ZOrderPosition)(THIS_ int FAR* ZOrderPosition) PURE;
    STDMETHOD(get_Script)(THIS_ Script FAR* FAR* Script) PURE;
    STDMETHOD(get_AlternativeText)(THIS_ BSTR FAR* AlternativeText) PURE;
    STDMETHOD(put_AlternativeText)(THIS_ BSTR AlternativeText) PURE;
    STDMETHOD(get_HasDiagram)(THIS_ MsoTriState FAR* pHasDiagram) PURE;
    STDMETHOD(get_Diagram)(THIS_ IMsoDiagram FAR* FAR* Diagram) PURE;
    STDMETHOD(get_HasDiagramNode)(THIS_ MsoTriState FAR* pHasDiagram) PURE;
    STDMETHOD(get_DiagramNode)(THIS_ DiagramNode FAR* FAR* DiagramNode) PURE;
    STDMETHOD(get_Child)(THIS_ MsoTriState FAR* Child) PURE;
    STDMETHOD(get_ParentGroup)(THIS_ Shape FAR* FAR* Parent) PURE;
    STDMETHOD(get_CanvasItems)(THIS_ CanvasShapes FAR* FAR* CanvasShapes) PURE;
    STDMETHOD(get_Id)(THIS_ int FAR* pid) PURE;
    STDMETHOD(CanvasCropLeft)(THIS_ float Increment) PURE;
    STDMETHOD(CanvasCropTop)(THIS_ float Increment) PURE;
    STDMETHOD(CanvasCropRight)(THIS_ float Increment) PURE;
    STDMETHOD(CanvasCropBottom)(THIS_ float Increment) PURE;
    STDMETHOD(put_RTF)(THIS_ BSTR Text) PURE;
};

DEFINE_GUID(IID_Shapes,0x000C031EL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Shapes */
#undef INTERFACE
#define INTERFACE Shapes

DECLARE_INTERFACE_(Shapes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Shapes methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* Count) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, Shape FAR* FAR* Item) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* _NewEnum) PURE;
    STDMETHOD(AddCallout)(THIS_ MsoCalloutType Type, float Left, float Top, float Width, float Height, Shape FAR* FAR* Callout) PURE;
    STDMETHOD(AddConnector)(THIS_ MsoConnectorType Type, float BeginX, float BeginY, float EndX, float EndY, Shape FAR* FAR* Connector) PURE;
    STDMETHOD(AddCurve)(THIS_ VARIANT SafeArrayOfPoints, Shape FAR* FAR* Curve) PURE;
    STDMETHOD(AddLabel)(THIS_ MsoTextOrientation Orientation, float Left, float Top, float Width, float Height, Shape FAR* FAR* Label) PURE;
    STDMETHOD(AddLine)(THIS_ float BeginX, float BeginY, float EndX, float EndY, Shape FAR* FAR* Line) PURE;
    STDMETHOD(AddPicture)(THIS_ BSTR FileName, MsoTriState LinkToFile, MsoTriState SaveWithDocument, float Left, float Top, float Width, float Height, Shape FAR* FAR* Picture) PURE;
    STDMETHOD(AddPolyline)(THIS_ VARIANT SafeArrayOfPoints, Shape FAR* FAR* Polyline) PURE;
    STDMETHOD(AddShape)(THIS_ MsoAutoShapeType Type, float Left, float Top, float Width, float Height, Shape FAR* FAR* Shape) PURE;
    STDMETHOD(AddTextEffect)(THIS_ MsoPresetTextEffect PresetTextEffect, BSTR Text, BSTR FontName, float FontSize, MsoTriState FontBold, MsoTriState FontItalic, float Left, float Top, Shape FAR* FAR* TextEffect) PURE;
    STDMETHOD(AddTextbox)(THIS_ MsoTextOrientation Orientation, float Left, float Top, float Width, float Height, Shape FAR* FAR* Textbox) PURE;
    STDMETHOD(BuildFreeform)(THIS_ MsoEditingType EditingType, float X1, float Y1, FreeformBuilder FAR* FAR* FreeformBuilder) PURE;
    STDMETHOD(Range)(THIS_ VARIANT Index, ShapeRange FAR* FAR* Range) PURE;
    STDMETHOD(SelectAll)(THIS) PURE;
    STDMETHOD(get_Background)(THIS_ Shape FAR* FAR* Background) PURE;
    STDMETHOD(get_Default)(THIS_ Shape FAR* FAR* Default) PURE;
    STDMETHOD(AddDiagram)(THIS_ enum tagMsoDiagramType Type, float Left, float Top, float Width, float Height, Shape FAR* FAR* Diagram) PURE;
    STDMETHOD(AddCanvas)(THIS_ float Left, float Top, float Width, float Height, Shape FAR* FAR* Shape) PURE;
};

DEFINE_GUID(IID_TextEffectFormat,0x000C031FL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: TextEffectFormat */
#undef INTERFACE
#define INTERFACE TextEffectFormat

DECLARE_INTERFACE_(TextEffectFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* TextEffectFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(ToggleVerticalText)(THIS) PURE;
    STDMETHOD(get_Alignment)(THIS_ MsoTextEffectAlignment FAR* Alignment) PURE;
    STDMETHOD(put_Alignment)(THIS_ MsoTextEffectAlignment Alignment) PURE;
    STDMETHOD(get_FontBold)(THIS_ MsoTriState FAR* FontBold) PURE;
    STDMETHOD(put_FontBold)(THIS_ MsoTriState FontBold) PURE;
    STDMETHOD(get_FontItalic)(THIS_ MsoTriState FAR* FontItalic) PURE;
    STDMETHOD(put_FontItalic)(THIS_ MsoTriState FontItalic) PURE;
    STDMETHOD(get_FontName)(THIS_ BSTR FAR* FontName) PURE;
    STDMETHOD(put_FontName)(THIS_ BSTR FontName) PURE;
    STDMETHOD(get_FontSize)(THIS_ float FAR* FontSize) PURE;
    STDMETHOD(put_FontSize)(THIS_ float FontSize) PURE;
    STDMETHOD(get_KernedPairs)(THIS_ MsoTriState FAR* KernedPairs) PURE;
    STDMETHOD(put_KernedPairs)(THIS_ MsoTriState KernedPairs) PURE;
    STDMETHOD(get_NormalizedHeight)(THIS_ MsoTriState FAR* NormalizedHeight) PURE;
    STDMETHOD(put_NormalizedHeight)(THIS_ MsoTriState NormalizedHeight) PURE;
    STDMETHOD(get_PresetShape)(THIS_ MsoPresetTextEffectShape FAR* PresetShape) PURE;
    STDMETHOD(put_PresetShape)(THIS_ MsoPresetTextEffectShape PresetShape) PURE;
    STDMETHOD(get_PresetTextEffect)(THIS_ MsoPresetTextEffect FAR* Preset) PURE;
    STDMETHOD(put_PresetTextEffect)(THIS_ MsoPresetTextEffect Preset) PURE;
    STDMETHOD(get_RotatedChars)(THIS_ MsoTriState FAR* RotatedChars) PURE;
    STDMETHOD(put_RotatedChars)(THIS_ MsoTriState RotatedChars) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* Text) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR Text) PURE;
    STDMETHOD(get_Tracking)(THIS_ float FAR* Tracking) PURE;
    STDMETHOD(put_Tracking)(THIS_ float Tracking) PURE;
};

DEFINE_GUID(IID_TextFrame,0x000C0320L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: TextFrame */
#undef INTERFACE
#define INTERFACE TextFrame

DECLARE_INTERFACE_(TextFrame, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* TextFrame methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_MarginBottom)(THIS_ float FAR* MarginBottom) PURE;
    STDMETHOD(put_MarginBottom)(THIS_ float MarginBottom) PURE;
    STDMETHOD(get_MarginLeft)(THIS_ float FAR* MarginLeft) PURE;
    STDMETHOD(put_MarginLeft)(THIS_ float MarginLeft) PURE;
    STDMETHOD(get_MarginRight)(THIS_ float FAR* MarginRight) PURE;
    STDMETHOD(put_MarginRight)(THIS_ float MarginRight) PURE;
    STDMETHOD(get_MarginTop)(THIS_ float FAR* MarginTop) PURE;
    STDMETHOD(put_MarginTop)(THIS_ float MarginTop) PURE;
    STDMETHOD(get_Orientation)(THIS_ MsoTextOrientation FAR* Orientation) PURE;
    STDMETHOD(put_Orientation)(THIS_ MsoTextOrientation Orientation) PURE;
};

DEFINE_GUID(IID_ThreeDFormat,0x000C0321L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ThreeDFormat */
#undef INTERFACE
#define INTERFACE ThreeDFormat

DECLARE_INTERFACE_(ThreeDFormat, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ThreeDFormat methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(IncrementRotationX)(THIS_ float Increment) PURE;
    STDMETHOD(IncrementRotationY)(THIS_ float Increment) PURE;
    STDMETHOD(ResetRotation)(THIS) PURE;
    STDMETHOD(SetThreeDFormat)(THIS_ MsoPresetThreeDFormat PresetThreeDFormat) PURE;
    STDMETHOD(SetExtrusionDirection)(THIS_ MsoPresetExtrusionDirection PresetExtrusionDirection) PURE;
    STDMETHOD(get_Depth)(THIS_ float FAR* Depth) PURE;
    STDMETHOD(put_Depth)(THIS_ float Depth) PURE;
    STDMETHOD(get_ExtrusionColor)(THIS_ ColorFormat FAR* FAR* ExtrusionColor) PURE;
    STDMETHOD(get_ExtrusionColorType)(THIS_ MsoExtrusionColorType FAR* ExtrusionColorType) PURE;
    STDMETHOD(put_ExtrusionColorType)(THIS_ MsoExtrusionColorType ExtrusionColorType) PURE;
    STDMETHOD(get_Perspective)(THIS_ MsoTriState FAR* Perspective) PURE;
    STDMETHOD(put_Perspective)(THIS_ MsoTriState Perspective) PURE;
    STDMETHOD(get_PresetExtrusionDirection)(THIS_ MsoPresetExtrusionDirection FAR* PresetExtrusionDirection) PURE;
    STDMETHOD(get_PresetLightingDirection)(THIS_ MsoPresetLightingDirection FAR* PresetLightingDirection) PURE;
    STDMETHOD(put_PresetLightingDirection)(THIS_ MsoPresetLightingDirection PresetLightingDirection) PURE;
    STDMETHOD(get_PresetLightingSoftness)(THIS_ MsoPresetLightingSoftness FAR* PresetLightingSoftness) PURE;
    STDMETHOD(put_PresetLightingSoftness)(THIS_ MsoPresetLightingSoftness PresetLightingSoftness) PURE;
    STDMETHOD(get_PresetMaterial)(THIS_ MsoPresetMaterial FAR* PresetMaterial) PURE;
    STDMETHOD(put_PresetMaterial)(THIS_ MsoPresetMaterial PresetMaterial) PURE;
    STDMETHOD(get_PresetThreeDFormat)(THIS_ MsoPresetThreeDFormat FAR* PresetThreeDFormat) PURE;
    STDMETHOD(get_RotationX)(THIS_ float FAR* RotationX) PURE;
    STDMETHOD(put_RotationX)(THIS_ float RotationX) PURE;
    STDMETHOD(get_RotationY)(THIS_ float FAR* RotationY) PURE;
    STDMETHOD(put_RotationY)(THIS_ float RotationY) PURE;
    STDMETHOD(get_Visible)(THIS_ MsoTriState FAR* Visible) PURE;
    STDMETHOD(put_Visible)(THIS_ MsoTriState Visible) PURE;
};

DEFINE_GUID(IID_IMsoDispCagNotifySink,0x000C0359L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: IMsoDispCagNotifySink */
#undef INTERFACE
#define INTERFACE IMsoDispCagNotifySink

DECLARE_INTERFACE_(IMsoDispCagNotifySink, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IMsoDispCagNotifySink methods */
    STDMETHOD(InsertClip)(THIS_ IUnknown * pClipMoniker, IUnknown * pItemMoniker) PURE;
    STDMETHOD(WindowIsClosing)(THIS) PURE;
};

DEFINE_GUID(IID_Balloon,0x000C0324L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Balloon */
#undef INTERFACE
#define INTERFACE Balloon

DECLARE_INTERFACE_(Balloon, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Balloon methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Checkboxes)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Labels)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(put_BalloonType)(THIS_ MsoBalloonType bty) PURE;
    STDMETHOD(get_BalloonType)(THIS_ MsoBalloonType FAR* pbty) PURE;
    STDMETHOD(put_Icon)(THIS_ MsoIconType icn) PURE;
    STDMETHOD(get_Icon)(THIS_ MsoIconType FAR* picn) PURE;
    STDMETHOD(put_Heading)(THIS_ BSTR bstr) PURE;
    STDMETHOD(get_Heading)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR bstr) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(put_Mode)(THIS_ MsoModeType md) PURE;
    STDMETHOD(get_Mode)(THIS_ MsoModeType FAR* pmd) PURE;
    STDMETHOD(put_Animation)(THIS_ MsoAnimationType fca) PURE;
    STDMETHOD(get_Animation)(THIS_ MsoAnimationType FAR* pfca) PURE;
    STDMETHOD(put_Button)(THIS_ MsoButtonSetType sbs) PURE;
    STDMETHOD(get_Button)(THIS_ MsoButtonSetType FAR* psbs) PURE;
    STDMETHOD(put_Callback)(THIS_ BSTR bstr) PURE;
    STDMETHOD(get_Callback)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(put_Private)(THIS_ long lPrivate) PURE;
    STDMETHOD(get_Private)(THIS_ long FAR* plPrivate) PURE;
    STDMETHOD(SetAvoidRectangle)(THIS_ int Left, int Top, int Right, int Bottom) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(Show)(THIS_ MsoBalloonButtonType FAR* pibtn) PURE;
    STDMETHOD(Close)(THIS) PURE;
};

DEFINE_GUID(IID_BalloonCheckboxes,0x000C0326L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: BalloonCheckboxes */
#undef INTERFACE
#define INTERFACE BalloonCheckboxes

DECLARE_INTERFACE_(BalloonCheckboxes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* BalloonCheckboxes methods */
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Item)(THIS_ int Index, IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pccbx) PURE;
    STDMETHOD(put_Count)(THIS_ int ccbx) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
};

DEFINE_GUID(IID_BalloonCheckbox,0x000C0328L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: BalloonCheckbox */
#undef INTERFACE
#define INTERFACE BalloonCheckbox

DECLARE_INTERFACE_(BalloonCheckbox, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* BalloonCheckbox methods */
    STDMETHOD(get_Item)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(put_Checked)(THIS_ VARIANT_BOOL varfChecked) PURE;
    STDMETHOD(get_Checked)(THIS_ VARIANT_BOOL FAR* pvarfChecked) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR bstr) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* pbstr) PURE;
};

DEFINE_GUID(IID_BalloonLabels,0x000C032EL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: BalloonLabels */
#undef INTERFACE
#define INTERFACE BalloonLabels

DECLARE_INTERFACE_(BalloonLabels, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* BalloonLabels methods */
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Item)(THIS_ int Index, IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pcwz) PURE;
    STDMETHOD(put_Count)(THIS_ int cwz) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
};

DEFINE_GUID(IID_BalloonLabel,0x000C0330L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: BalloonLabel */
#undef INTERFACE
#define INTERFACE BalloonLabel

DECLARE_INTERFACE_(BalloonLabel, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* BalloonLabel methods */
    STDMETHOD(get_Item)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR bstr) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* pbstr) PURE;
};

DEFINE_GUID(IID_AnswerWizardFiles,0x000C0361L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: AnswerWizardFiles */
#undef INTERFACE
#define INTERFACE AnswerWizardFiles

DECLARE_INTERFACE_(AnswerWizardFiles, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* AnswerWizardFiles methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Item)(THIS_ int Index, BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pCount) PURE;
    STDMETHOD(Add)(THIS_ BSTR FileName) PURE;
    STDMETHOD(Delete)(THIS_ BSTR FileName) PURE;
};

DEFINE_GUID(IID_AnswerWizard,0x000C0360L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: AnswerWizard */
#undef INTERFACE
#define INTERFACE AnswerWizard

DECLARE_INTERFACE_(AnswerWizard, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* AnswerWizard methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Files)(THIS_ AnswerWizardFiles FAR* FAR* Files) PURE;
    STDMETHOD(ClearFileList)(THIS) PURE;
    STDMETHOD(ResetFileList)(THIS) PURE;
};

typedef enum tagMsoAlertButtonType MsoAlertButtonType;

typedef enum tagMsoAlertIconType MsoAlertIconType;

typedef enum tagMsoAlertDefaultType MsoAlertDefaultType;

typedef enum tagMsoAlertCancelType MsoAlertCancelType;

DEFINE_GUID(IID_Assistant,0x000C0322L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Assistant */
#undef INTERFACE
#define INTERFACE Assistant

DECLARE_INTERFACE_(Assistant, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Assistant methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Move)(THIS_ int xLeft, int yTop) PURE;
    STDMETHOD(put_Top)(THIS_ int yTop) PURE;
    STDMETHOD(get_Top)(THIS_ int FAR* pyTop) PURE;
    STDMETHOD(put_Left)(THIS_ int xLeft) PURE;
    STDMETHOD(get_Left)(THIS_ int FAR* pxLeft) PURE;
    STDMETHOD(Help)(THIS) PURE;
    STDMETHOD(StartWizard)(THIS_ VARIANT_BOOL On, BSTR Callback, long PrivateX, VARIANT Animation, VARIANT CustomTeaser, VARIANT Top, VARIANT Left, VARIANT Bottom, VARIANT Right, long FAR* plWizID) PURE;
    STDMETHOD(EndWizard)(THIS_ long WizardID, VARIANT_BOOL varfSuccess, VARIANT Animation) PURE;
    STDMETHOD(ActivateWizard)(THIS_ long WizardID, MsoWizardActType act, VARIANT Animation) PURE;
    STDMETHOD(ResetTips)(THIS) PURE;
    STDMETHOD(get_NewBalloon)(THIS_ Balloon FAR* FAR* ppibal) PURE;
    STDMETHOD(get_BalloonError)(THIS_ MsoBalloonErrorType FAR* pbne) PURE;
    STDMETHOD(get_Visible)(THIS_ VARIANT_BOOL FAR* pvarfVisible) PURE;
    STDMETHOD(put_Visible)(THIS_ VARIANT_BOOL varfVisible) PURE;
    STDMETHOD(get_Animation)(THIS_ MsoAnimationType FAR* pfca) PURE;
    STDMETHOD(put_Animation)(THIS_ MsoAnimationType fca) PURE;
    STDMETHOD(get_Reduced)(THIS_ VARIANT_BOOL FAR* pvarfReduced) PURE;
    STDMETHOD(put_Reduced)(THIS_ VARIANT_BOOL varfReduced) PURE;
    STDMETHOD(put_AssistWithHelp)(THIS_ VARIANT_BOOL varfAssistWithHelp) PURE;
    STDMETHOD(get_AssistWithHelp)(THIS_ VARIANT_BOOL FAR* pvarfAssistWithHelp) PURE;
    STDMETHOD(put_AssistWithWizards)(THIS_ VARIANT_BOOL varfAssistWithWizards) PURE;
    STDMETHOD(get_AssistWithWizards)(THIS_ VARIANT_BOOL FAR* pvarfAssistWithWizards) PURE;
    STDMETHOD(put_AssistWithAlerts)(THIS_ VARIANT_BOOL varfAssistWithAlerts) PURE;
    STDMETHOD(get_AssistWithAlerts)(THIS_ VARIANT_BOOL FAR* pvarfAssistWithAlerts) PURE;
    STDMETHOD(put_MoveWhenInTheWay)(THIS_ VARIANT_BOOL varfMove) PURE;
    STDMETHOD(get_MoveWhenInTheWay)(THIS_ VARIANT_BOOL FAR* pvarfMove) PURE;
    STDMETHOD(put_Sounds)(THIS_ VARIANT_BOOL varfSounds) PURE;
    STDMETHOD(get_Sounds)(THIS_ VARIANT_BOOL FAR* pvarfSounds) PURE;
    STDMETHOD(put_FeatureTips)(THIS_ VARIANT_BOOL varfFeatures) PURE;
    STDMETHOD(get_FeatureTips)(THIS_ VARIANT_BOOL FAR* pvarfFeatures) PURE;
    STDMETHOD(put_MouseTips)(THIS_ VARIANT_BOOL varfMouse) PURE;
    STDMETHOD(get_MouseTips)(THIS_ VARIANT_BOOL FAR* pvarfMouse) PURE;
    STDMETHOD(put_KeyboardShortcutTips)(THIS_ VARIANT_BOOL varfKeyboardShortcuts) PURE;
    STDMETHOD(get_KeyboardShortcutTips)(THIS_ VARIANT_BOOL FAR* pvarfKeyboardShortcuts) PURE;
    STDMETHOD(put_HighPriorityTips)(THIS_ VARIANT_BOOL varfHighPriorityTips) PURE;
    STDMETHOD(get_HighPriorityTips)(THIS_ VARIANT_BOOL FAR* pvarfHighPriorityTips) PURE;
    STDMETHOD(put_TipOfDay)(THIS_ VARIANT_BOOL varfTipOfDay) PURE;
    STDMETHOD(get_TipOfDay)(THIS_ VARIANT_BOOL FAR* pvarfTipOfDay) PURE;
    STDMETHOD(put_GuessHelp)(THIS_ VARIANT_BOOL varfGuessHelp) PURE;
    STDMETHOD(get_GuessHelp)(THIS_ VARIANT_BOOL FAR* pvarfGuessHelp) PURE;
    STDMETHOD(put_SearchWhenProgramming)(THIS_ VARIANT_BOOL varfSearchInProgram) PURE;
    STDMETHOD(get_SearchWhenProgramming)(THIS_ VARIANT_BOOL FAR* pvarfSearchInProgram) PURE;
    STDMETHOD(get_Item)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_FileName)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(put_FileName)(THIS_ BSTR bstr) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_On)(THIS_ VARIANT_BOOL FAR* pvarfOn) PURE;
    STDMETHOD(put_On)(THIS_ VARIANT_BOOL varfOn) PURE;
    STDMETHOD(DoAlert)(THIS_ BSTR bstrAlertTitle, BSTR bstrAlertText, enum tagMsoAlertButtonType alb, enum tagMsoAlertIconType alc, enum tagMsoAlertDefaultType ald, enum tagMsoAlertCancelType alq, VARIANT_BOOL varfSysAlert, int FAR* pibtn) PURE;
};

DEFINE_GUID(IID_DocumentProperty,0x2DF8D04EL,0x5BFA,0x101B,0xBD,0xE5,0x00,0xAA,0x00,0x44,0xDE,0x52);

/* Definition of interface: MsoDocumentProperty */
#undef INTERFACE
#define INTERFACE MsoDocumentProperty

DECLARE_INTERFACE_(MsoDocumentProperty, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* MsoDocumentProperty methods */
    STDMETHOD_(IDispatch *, get_Parent)(THIS) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(get_Name)(THIS_ long lcid, BSTR FAR* pbstrRetVal) PURE;
    STDMETHOD(put_Name)(THIS_ long lcid, BSTR bstrName) PURE;
    STDMETHOD(get_Value)(THIS_ long lcid, VARIANT FAR* pvargRetVal) PURE;
    STDMETHOD(put_Value)(THIS_ long lcid, VARIANT vargVal) PURE;
    STDMETHOD(get_Type)(THIS_ long lcid, MsoDocProperties FAR* ptypeRetVal) PURE;
    STDMETHOD(put_Type)(THIS_ long lcid, MsoDocProperties type) PURE;
    STDMETHOD(get_LinkToContent)(THIS_ VARIANT_BOOL FAR* pfLinkRetVal) PURE;
    STDMETHOD(put_LinkToContent)(THIS_ VARIANT_BOOL fLink) PURE;
    STDMETHOD(get_LinkSource)(THIS_ BSTR FAR* pbstrSourceRetVal) PURE;
    STDMETHOD(put_LinkSource)(THIS_ BSTR bstrSource) PURE;
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
};

DEFINE_GUID(IID_DocumentProperties,0x2DF8D04DL,0x5BFA,0x101B,0xBD,0xE5,0x00,0xAA,0x00,0x44,0xDE,0x52);

/* Definition of interface: MsoDocumentProperties */
#undef INTERFACE
#define INTERFACE MsoDocumentProperties

DECLARE_INTERFACE_(MsoDocumentProperties, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* MsoDocumentProperties methods */
    STDMETHOD_(IDispatch *, get_Parent)(THIS) PURE;
    STDMETHOD(get_Item)(THIS_ VARIANT Index, long lcid, MsoDocumentProperty FAR* FAR* ppIDocProp) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* pc) PURE;
    STDMETHOD(Add)(THIS_ BSTR Name, VARIANT_BOOL LinkToContent, VARIANT Type, VARIANT Value, VARIANT LinkSource, long lcid, MsoDocumentProperty FAR* FAR* ppIDocProp) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
};

typedef enum {
    msoOptionsNew = 1,
    msoOptionsAdd,
    msoOptionsWithin
} MsoFileFindOptions;

typedef enum {
    msoViewFileInfo = 1,
    msoViewPreview,
    msoViewSummaryInfo
} MsoFileFindView;

typedef enum {
    msoFileFindSortbyAuthor = 1,
    msoFileFindSortbyDateCreated,
    msoFileFindSortbyLastSavedBy,
    msoFileFindSortbyDateSaved,
    msoFileFindSortbyFileName,
    msoFileFindSortbySize,
    msoFileFindSortbyTitle
} MsoFileFindSortBy;

typedef enum {
    msoListbyName = 1,
    msoListbyTitle
} MsoFileFindListBy;

DEFINE_GUID(IID_IFoundFiles,0x000C0338L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: IFoundFiles */
#undef INTERFACE
#define INTERFACE IFoundFiles

DECLARE_INTERFACE_(IFoundFiles, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IFoundFiles methods */
    STDMETHOD(get_Item)(THIS_ int Index, BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pCount) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

DEFINE_GUID(IID_IFind,0x000C0337L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: IFind */
#undef INTERFACE
#define INTERFACE IFind

DECLARE_INTERFACE_(IFind, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IFind methods */
    STDMETHOD(get_SearchPath)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_SubDir)(THIS_ VARIANT_BOOL FAR* retval) PURE;
    STDMETHOD(get_Title)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Author)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Keywords)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Subject)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Options)(THIS_ MsoFileFindOptions FAR* penmOptions) PURE;
    STDMETHOD(get_MatchCase)(THIS_ VARIANT_BOOL FAR* retval) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_PatternMatch)(THIS_ VARIANT_BOOL FAR* retval) PURE;
    STDMETHOD(get_DateSavedFrom)(THIS_ VARIANT FAR* pdatSavedFrom) PURE;
    STDMETHOD(get_DateSavedTo)(THIS_ VARIANT FAR* pdatSavedTo) PURE;
    STDMETHOD(get_SavedBy)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_DateCreatedFrom)(THIS_ VARIANT FAR* pdatCreatedFrom) PURE;
    STDMETHOD(get_DateCreatedTo)(THIS_ VARIANT FAR* pdatCreatedTo) PURE;
    STDMETHOD(get_View)(THIS_ MsoFileFindView FAR* penmView) PURE;
    STDMETHOD(get_SortBy)(THIS_ MsoFileFindSortBy FAR* penmSortBy) PURE;
    STDMETHOD(get_ListBy)(THIS_ MsoFileFindListBy FAR* penmListBy) PURE;
    STDMETHOD(get_SelectedFile)(THIS_ int FAR* pintSelectedFile) PURE;
    STDMETHOD(get_Results)(THIS_ IFoundFiles FAR* FAR* pdisp) PURE;
    STDMETHOD(Show)(THIS_ int FAR* pRows) PURE;
    STDMETHOD(put_SearchPath)(THIS_ BSTR bstrSearchPath) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR bstrName) PURE;
    STDMETHOD(put_SubDir)(THIS_ VARIANT_BOOL fSubDir) PURE;
    STDMETHOD(put_Title)(THIS_ BSTR bstrTitle) PURE;
    STDMETHOD(put_Author)(THIS_ BSTR bstrAuthor) PURE;
    STDMETHOD(put_Keywords)(THIS_ BSTR bstrKeywords) PURE;
    STDMETHOD(put_Subject)(THIS_ BSTR bstrSubject) PURE;
    STDMETHOD(put_Options)(THIS_ MsoFileFindOptions enmOptions) PURE;
    STDMETHOD(put_MatchCase)(THIS_ VARIANT_BOOL fOptions) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR bstrText) PURE;
    STDMETHOD(put_PatternMatch)(THIS_ VARIANT_BOOL fPatternMatch) PURE;
    STDMETHOD(put_DateSavedFrom)(THIS_ VARIANT datSavedFrom) PURE;
    STDMETHOD(put_DateSavedTo)(THIS_ VARIANT datSavedTo) PURE;
    STDMETHOD(put_SavedBy)(THIS_ BSTR bstrSavedBy) PURE;
    STDMETHOD(put_DateCreatedFrom)(THIS_ VARIANT datCreatedFrom) PURE;
    STDMETHOD(put_DateCreatedTo)(THIS_ VARIANT datCreatedTo) PURE;
    STDMETHOD(put_View)(THIS_ MsoFileFindView enmView) PURE;
    STDMETHOD(put_SortBy)(THIS_ MsoFileFindSortBy enmSortBy) PURE;
    STDMETHOD(put_ListBy)(THIS_ MsoFileFindListBy enmListBy) PURE;
    STDMETHOD(put_SelectedFile)(THIS_ int intSelectedFile) PURE;
    STDMETHOD(Execute)(THIS) PURE;
    STDMETHOD(Load)(THIS_ BSTR bstrQueryName) PURE;
    STDMETHOD(Save)(THIS_ BSTR bstrQueryName) PURE;
    STDMETHOD(Delete)(THIS_ BSTR bstrQueryName) PURE;
    STDMETHOD(get_FileType)(THIS_ long FAR* plFileType) PURE;
    STDMETHOD(put_FileType)(THIS_ long lFileType) PURE;
};

typedef enum {
    msoLastModifiedYesterday = 1,
    msoLastModifiedToday,
    msoLastModifiedLastWeek,
    msoLastModifiedThisWeek,
    msoLastModifiedLastMonth,
    msoLastModifiedThisMonth,
    msoLastModifiedAnyTime
} MsoLastModified;

typedef enum {
    msoSortByFileName = 1,
    msoSortBySize,
    msoSortByFileType,
    msoSortByLastModified,
    msoSortByNone
} MsoSortBy;

typedef enum {
    msoSortOrderAscending = 1,
    msoSortOrderDescending
} MsoSortOrder;

typedef enum {
    msoConnectorAnd = 1,
    msoConnectorOr
} MsoConnector;

typedef enum {
    msoConditionFileTypeAllFiles = 1,
    msoConditionFileTypeOfficeFiles,
    msoConditionFileTypeWordDocuments,
    msoConditionFileTypeExcelWorkbooks,
    msoConditionFileTypePowerPointPresentations,
    msoConditionFileTypeBinders,
    msoConditionFileTypeDatabases,
    msoConditionFileTypeTemplates,
    msoConditionIncludes,
    msoConditionIncludesPhrase,
    msoConditionBeginsWith,
    msoConditionEndsWith,
    msoConditionIncludesNearEachOther,
    msoConditionIsExactly,
    msoConditionIsNot,
    msoConditionYesterday,
    msoConditionToday,
    msoConditionTomorrow,
    msoConditionLastWeek,
    msoConditionThisWeek,
    msoConditionNextWeek,
    msoConditionLastMonth,
    msoConditionThisMonth,
    msoConditionNextMonth,
    msoConditionAnytime,
    msoConditionAnytimeBetween,
    msoConditionOn,
    msoConditionOnOrAfter,
    msoConditionOnOrBefore,
    msoConditionInTheNext,
    msoConditionInTheLast,
    msoConditionEquals,
    msoConditionDoesNotEqual,
    msoConditionAnyNumberBetween,
    msoConditionAtMost,
    msoConditionAtLeast,
    msoConditionMoreThan,
    msoConditionLessThan,
    msoConditionIsYes,
    msoConditionIsNo,
    msoConditionIncludesFormsOf,
    msoConditionFreeText,
    msoConditionFileTypeOutlookItems,
    msoConditionFileTypeMailItem,
    msoConditionFileTypeCalendarItem,
    msoConditionFileTypeContactItem,
    msoConditionFileTypeNoteItem,
    msoConditionFileTypeJournalItem,
    msoConditionFileTypeTaskItem,
    msoConditionFileTypePhotoDrawFiles,
    msoConditionFileTypeDataConnectionFiles,
    msoConditionFileTypePublisherFiles,
    msoConditionFileTypeProjectFiles,
    msoConditionFileTypeDocumentImagingFiles,
    msoConditionFileTypeVisioFiles,
    msoConditionFileTypeDesignerFiles,
    msoConditionFileTypeWebPages,
    msoConditionEqualsLow,
    msoConditionEqualsNormal,
    msoConditionEqualsHigh,
    msoConditionNotEqualToLow,
    msoConditionNotEqualToNormal,
    msoConditionNotEqualToHigh,
    msoConditionEqualsNotStarted,
    msoConditionEqualsInProgress,
    msoConditionEqualsCompleted,
    msoConditionEqualsWaitingForSomeoneElse,
    msoConditionEqualsDeferred,
    msoConditionNotEqualToNotStarted,
    msoConditionNotEqualToInProgress,
    msoConditionNotEqualToCompleted,
    msoConditionNotEqualToWaitingForSomeoneElse,
    msoConditionNotEqualToDeferred
} MsoCondition;

typedef enum {
    msoFileTypeAllFiles = 1,
    msoFileTypeOfficeFiles,
    msoFileTypeWordDocuments,
    msoFileTypeExcelWorkbooks,
    msoFileTypePowerPointPresentations,
    msoFileTypeBinders,
    msoFileTypeDatabases,
    msoFileTypeTemplates,
    msoFileTypeOutlookItems,
    msoFileTypeMailItem,
    msoFileTypeCalendarItem,
    msoFileTypeContactItem,
    msoFileTypeNoteItem,
    msoFileTypeJournalItem,
    msoFileTypeTaskItem,
    msoFileTypePhotoDrawFiles,
    msoFileTypeDataConnectionFiles,
    msoFileTypePublisherFiles,
    msoFileTypeProjectFiles,
    msoFileTypeDocumentImagingFiles,
    msoFileTypeVisioFiles,
    msoFileTypeDesignerFiles,
    msoFileTypeWebPages
} MsoFileType;

DEFINE_GUID(IID_FoundFiles,0x000C0331L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FoundFiles */
#undef INTERFACE
#define INTERFACE FoundFiles

DECLARE_INTERFACE_(FoundFiles, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FoundFiles methods */
    STDMETHOD(get_Item)(THIS_ int Index, long lcid, BSTR FAR* pbstrFile) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* pc) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

DEFINE_GUID(IID_PropertyTest,0x000C0333L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: PropertyTest */
#undef INTERFACE
#define INTERFACE PropertyTest

DECLARE_INTERFACE_(PropertyTest, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* PropertyTest methods */
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrRetVal) PURE;
    STDMETHOD(get_Condition)(THIS_ MsoCondition FAR* pConditionRetVal) PURE;
    STDMETHOD(get_Value)(THIS_ VARIANT FAR* pvargRetVal) PURE;
    STDMETHOD(get_SecondValue)(THIS_ VARIANT FAR* pvargRetVal2) PURE;
    STDMETHOD(get_Connector)(THIS_ MsoConnector FAR* pConnector) PURE;
};

DEFINE_GUID(IID_PropertyTests,0x000C0334L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: PropertyTests */
#undef INTERFACE
#define INTERFACE PropertyTests

DECLARE_INTERFACE_(PropertyTests, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* PropertyTests methods */
    STDMETHOD(get_Item)(THIS_ int Index, long lcid, PropertyTest FAR* FAR* ppIDocProp) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* pc) PURE;
    STDMETHOD(Add)(THIS_ BSTR Name, MsoCondition Condition, VARIANT Value, VARIANT SecondValue, MsoConnector Connector) PURE;
    STDMETHOD(Remove)(THIS_ int Index) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

DEFINE_GUID(IID_FileSearch,0x000C0332L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FileSearch */
#undef INTERFACE
#define INTERFACE FileSearch

DECLARE_INTERFACE_(FileSearch, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FileSearch methods */
    STDMETHOD(get_SearchSubFolders)(THIS_ VARIANT_BOOL FAR* SearchSubFoldersRetVal) PURE;
    STDMETHOD(put_SearchSubFolders)(THIS_ VARIANT_BOOL SearchSubFolders) PURE;
    STDMETHOD(get_MatchTextExactly)(THIS_ VARIANT_BOOL FAR* MatchTextRetVal) PURE;
    STDMETHOD(put_MatchTextExactly)(THIS_ VARIANT_BOOL MatchText) PURE;
    STDMETHOD(get_MatchAllWordForms)(THIS_ VARIANT_BOOL FAR* MatchAllWordFormsRetVal) PURE;
    STDMETHOD(put_MatchAllWordForms)(THIS_ VARIANT_BOOL MatchAllWordForms) PURE;
    STDMETHOD(get_FileName)(THIS_ BSTR FAR* FileNameRetVal) PURE;
    STDMETHOD(put_FileName)(THIS_ BSTR FileName) PURE;
    STDMETHOD(get_FileType)(THIS_ MsoFileType FAR* FileTypeRetVal) PURE;
    STDMETHOD(put_FileType)(THIS_ MsoFileType FileType) PURE;
    STDMETHOD(get_LastModified)(THIS_ MsoLastModified FAR* LastModifiedRetVal) PURE;
    STDMETHOD(put_LastModified)(THIS_ MsoLastModified LastModified) PURE;
    STDMETHOD(get_TextOrProperty)(THIS_ BSTR FAR* TextOrProperty) PURE;
    STDMETHOD(put_TextOrProperty)(THIS_ BSTR TextOrProperty) PURE;
    STDMETHOD(get_LookIn)(THIS_ BSTR FAR* LookInRetVal) PURE;
    STDMETHOD(put_LookIn)(THIS_ BSTR LookIn) PURE;
    STDMETHOD(Execute)(THIS_ MsoSortBy SortBy, MsoSortOrder SortOrder, VARIANT_BOOL AlwaysAccurate, int FAR* pRet) PURE;
    STDMETHOD(NewSearch)(THIS) PURE;
    STDMETHOD(get_FoundFiles)(THIS_ FoundFiles FAR* FAR* FoundFilesRet) PURE;
    STDMETHOD(get_PropertyTests)(THIS_ PropertyTests FAR* FAR* PropTestsRet) PURE;
    STDMETHOD(get_SearchScopes)(THIS_ SearchScopes FAR* FAR* SearchScopesRet) PURE;
    STDMETHOD(get_SearchFolders)(THIS_ SearchFolders FAR* FAR* SearchFoldersRet) PURE;
    STDMETHOD(get_FileTypes)(THIS_ FileTypes FAR* FAR* FileTypesRet) PURE;
    STDMETHOD(RefreshScopes)(THIS) PURE;
};

DEFINE_GUID(IID_COMAddIn,0x000C033AL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: COMAddIn */
#undef INTERFACE
#define INTERFACE COMAddIn

DECLARE_INTERFACE_(COMAddIn, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* COMAddIn methods */
    STDMETHOD(get_Description)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_Description)(THIS_ BSTR Value) PURE;
    STDMETHOD(get_ProgId)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(get_Guid)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(get_Connect)(THIS_ VARIANT_BOOL FAR* RetValue) PURE;
    STDMETHOD(put_Connect)(THIS_ VARIANT_BOOL Value) PURE;
    STDMETHOD(get_Object)(THIS_ IDispatch * FAR* RetValue) PURE;
    STDMETHOD(put_Object)(THIS_ IDispatch * Value) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* RetVal) PURE;
};

DEFINE_GUID(IID_COMAddIns,0x000C0339L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: COMAddIns */
#undef INTERFACE
#define INTERFACE COMAddIns

DECLARE_INTERFACE_(COMAddIns, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* COMAddIns methods */
    STDMETHOD(Item)(THIS_ VARIANT FAR* Index, COMAddIn FAR* FAR* RetValue) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* RetValue) PURE;
    STDMETHOD(Update)(THIS) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(SetAppModal)(THIS_ VARIANT_BOOL varfModal) PURE;
};

typedef enum {
    msoLanguageIDMixed = -2,
    msoLanguageIDNone = 0,
    msoLanguageIDNoProofing = 1024,
    msoLanguageIDAfrikaans = 1078,
    msoLanguageIDAlbanian = 1052,
    msoLanguageIDAmharic = 1118,
    msoLanguageIDArabicAlgeria = 5121,
    msoLanguageIDArabicBahrain = 15361,
    msoLanguageIDArabicEgypt = 3073,
    msoLanguageIDArabicIraq = 2049,
    msoLanguageIDArabicJordan = 11265,
    msoLanguageIDArabicKuwait = 13313,
    msoLanguageIDArabicLebanon = 12289,
    msoLanguageIDArabicLibya = 4097,
    msoLanguageIDArabicMorocco = 6145,
    msoLanguageIDArabicOman = 8193,
    msoLanguageIDArabicQatar = 16385,
    msoLanguageIDArabic = 1025,
    msoLanguageIDArabicSyria = 10241,
    msoLanguageIDArabicTunisia = 7169,
    msoLanguageIDArabicUAE = 14337,
    msoLanguageIDArabicYemen = 9217,
    msoLanguageIDArmenian = 1067,
    msoLanguageIDAssamese = 1101,
    msoLanguageIDAzeriCyrillic = 2092,
    msoLanguageIDAzeriLatin = 1068,
    msoLanguageIDBasque = 1069,
    msoLanguageIDByelorussian = 1059,
    msoLanguageIDBengali = 1093,
    msoLanguageIDBulgarian = 1026,
    msoLanguageIDBurmese = 1109,
    msoLanguageIDCatalan = 1027,
    msoLanguageIDChineseHongKongSAR = 3076,
    msoLanguageIDChineseMacaoSAR = 5124,
    msoLanguageIDSimplifiedChinese = 2052,
    msoLanguageIDChineseSingapore = 4100,
    msoLanguageIDTraditionalChinese = 1028,
    msoLanguageIDCherokee = 1116,
    msoLanguageIDCroatian = 1050,
    msoLanguageIDCzech = 1029,
    msoLanguageIDDanish = 1030,
    msoLanguageIDDivehi = 1125,
    msoLanguageIDBelgianDutch = 2067,
    msoLanguageIDDutch = 1043,
    msoLanguageIDDzongkhaBhutan = 2129,
    msoLanguageIDEdo = 1126,
    msoLanguageIDEnglishAUS = 3081,
    msoLanguageIDEnglishBelize = 10249,
    msoLanguageIDEnglishCanadian = 4105,
    msoLanguageIDEnglishCaribbean = 9225,
    msoLanguageIDEnglishIndonesia = 14345,
    msoLanguageIDEnglishIreland = 6153,
    msoLanguageIDEnglishJamaica = 8201,
    msoLanguageIDEnglishNewZealand = 5129,
    msoLanguageIDEnglishPhilippines = 13321,
    msoLanguageIDEnglishSouthAfrica = 7177,
    msoLanguageIDEnglishTrinidadTobago = 11273,
    msoLanguageIDEnglishUK = 2057,
    msoLanguageIDEnglishUS = 1033,
    msoLanguageIDEnglishZimbabwe = 12297,
    msoLanguageIDEstonian = 1061,
    msoLanguageIDFaeroese = 1080,
    msoLanguageIDFarsi = 1065,
    msoLanguageIDFilipino = 1124,
    msoLanguageIDFinnish = 1035,
    msoLanguageIDBelgianFrench = 2060,
    msoLanguageIDFrenchCameroon = 11276,
    msoLanguageIDFrenchCanadian = 3084,
    msoLanguageIDFrenchCotedIvoire = 12300,
    msoLanguageIDFrench = 1036,
    msoLanguageIDFrenchHaiti = 15372,
    msoLanguageIDFrenchLuxembourg = 5132,
    msoLanguageIDFrenchMali = 13324,
    msoLanguageIDFrenchMonaco = 6156,
    msoLanguageIDFrenchMorocco = 14348,
    msoLanguageIDFrenchReunion = 8204,
    msoLanguageIDFrenchSenegal = 10252,
    msoLanguageIDSwissFrench = 4108,
    msoLanguageIDFrenchWestIndies = 7180,
    msoLanguageIDFrenchZaire = 9228,
    msoLanguageIDFrisianNetherlands = 1122,
    msoLanguageIDFulfulde = 1127,
    msoLanguageIDGaelicIreland = 2108,
    msoLanguageIDGaelicScotland = 1084,
    msoLanguageIDGalician = 1110,
    msoLanguageIDGeorgian = 1079,
    msoLanguageIDGermanAustria = 3079,
    msoLanguageIDGerman = 1031,
    msoLanguageIDGermanLiechtenstein = 5127,
    msoLanguageIDGermanLuxembourg = 4103,
    msoLanguageIDSwissGerman = 2055,
    msoLanguageIDGreek = 1032,
    msoLanguageIDGuarani = 1140,
    msoLanguageIDGujarati = 1095,
    msoLanguageIDHausa = 1128,
    msoLanguageIDHawaiian = 1141,
    msoLanguageIDHebrew = 1037,
    msoLanguageIDHindi = 1081,
    msoLanguageIDHungarian = 1038,
    msoLanguageIDIbibio = 1129,
    msoLanguageIDIcelandic = 1039,
    msoLanguageIDIgbo = 1136,
    msoLanguageIDIndonesian = 1057,
    msoLanguageIDInuktitut = 1117,
    msoLanguageIDItalian = 1040,
    msoLanguageIDSwissItalian = 2064,
    msoLanguageIDJapanese = 1041,
    msoLanguageIDKannada = 1099,
    msoLanguageIDKanuri = 1137,
    msoLanguageIDKazakh = 1087,
    msoLanguageIDKhmer = 1107,
    msoLanguageIDKirghiz = 1088,
    msoLanguageIDKonkani = 1111,
    msoLanguageIDKorean = 1042,
    msoLanguageIDKyrgyz = 1088,
    msoLanguageIDLatin = 1142,
    msoLanguageIDLao = 1108,
    msoLanguageIDLatvian = 1062,
    msoLanguageIDLithuanian = 1063,
    msoLanguageIDMacedonian = 1071,
    msoLanguageIDMalaysian = 1086,
    msoLanguageIDMalayBruneiDarussalam = 2110,
    msoLanguageIDMalayalam = 1100,
    msoLanguageIDMaltese = 1082,
    msoLanguageIDManipuri = 1112,
    msoLanguageIDMarathi = 1102,
    msoLanguageIDMongolian = 1104,
    msoLanguageIDNepali = 1121,
    msoLanguageIDNorwegianBokmol = 1044,
    msoLanguageIDNorwegianNynorsk = 2068,
    msoLanguageIDOriya = 1096,
    msoLanguageIDOromo = 1138,
    msoLanguageIDPashto = 1123,
    msoLanguageIDPolish = 1045,
    msoLanguageIDBrazilianPortuguese = 1046,
    msoLanguageIDPortuguese = 2070,
    msoLanguageIDPunjabi = 1094,
    msoLanguageIDRhaetoRomanic = 1047,
    msoLanguageIDRomanianMoldova = 2072,
    msoLanguageIDRomanian = 1048,
    msoLanguageIDRussianMoldova = 2073,
    msoLanguageIDRussian = 1049,
    msoLanguageIDSamiLappish = 1083,
    msoLanguageIDSanskrit = 1103,
    msoLanguageIDSerbianCyrillic = 3098,
    msoLanguageIDSerbianLatin = 2074,
    msoLanguageIDSesotho = 1072,
    msoLanguageIDSindhi = 1113,
    msoLanguageIDSindhiPakistan = 2137,
    msoLanguageIDSinhalese = 1115,
    msoLanguageIDSlovak = 1051,
    msoLanguageIDSlovenian = 1060,
    msoLanguageIDSomali = 1143,
    msoLanguageIDSorbian = 1070,
    msoLanguageIDSpanishArgentina = 11274,
    msoLanguageIDSpanishBolivia = 16394,
    msoLanguageIDSpanishChile = 13322,
    msoLanguageIDSpanishColombia = 9226,
    msoLanguageIDSpanishCostaRica = 5130,
    msoLanguageIDSpanishDominicanRepublic = 7178,
    msoLanguageIDSpanishEcuador = 12298,
    msoLanguageIDSpanishElSalvador = 17418,
    msoLanguageIDSpanishGuatemala = 4106,
    msoLanguageIDSpanishHonduras = 18442,
    msoLanguageIDMexicanSpanish = 2058,
    msoLanguageIDSpanishNicaragua = 19466,
    msoLanguageIDSpanishPanama = 6154,
    msoLanguageIDSpanishParaguay = 15370,
    msoLanguageIDSpanishPeru = 10250,
    msoLanguageIDSpanishPuertoRico = 20490,
    msoLanguageIDSpanishModernSort = 3082,
    msoLanguageIDSpanish = 1034,
    msoLanguageIDSpanishUruguay = 14346,
    msoLanguageIDSpanishVenezuela = 8202,
    msoLanguageIDSutu = 1072,
    msoLanguageIDSwahili = 1089,
    msoLanguageIDSwedishFinland = 2077,
    msoLanguageIDSwedish = 1053,
    msoLanguageIDSyriac = 1114,
    msoLanguageIDTajik = 1064,
    msoLanguageIDTamil = 1097,
    msoLanguageIDTamazight = 1119,
    msoLanguageIDTamazightLatin = 2143,
    msoLanguageIDTatar = 1092,
    msoLanguageIDTelugu = 1098,
    msoLanguageIDThai = 1054,
    msoLanguageIDTibetan = 1105,
    msoLanguageIDTigrignaEthiopic = 1139,
    msoLanguageIDTigrignaEritrea = 2163,
    msoLanguageIDTsonga = 1073,
    msoLanguageIDTswana = 1074,
    msoLanguageIDTurkish = 1055,
    msoLanguageIDTurkmen = 1090,
    msoLanguageIDUkrainian = 1058,
    msoLanguageIDUrdu = 1056,
    msoLanguageIDUzbekCyrillic = 2115,
    msoLanguageIDUzbekLatin = 1091,
    msoLanguageIDVenda = 1075,
    msoLanguageIDVietnamese = 1066,
    msoLanguageIDWelsh = 1106,
    msoLanguageIDXhosa = 1076,
    msoLanguageIDYi = 1144,
    msoLanguageIDYiddish = 1085,
    msoLanguageIDYoruba = 1130,
    msoLanguageIDZulu = 1077
} MsoLanguageID;

DEFINE_GUID(IID_LanguageSettings,0x000C0353L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: LanguageSettings */
#undef INTERFACE
#define INTERFACE LanguageSettings

DECLARE_INTERFACE_(LanguageSettings, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* LanguageSettings methods */
    STDMETHOD(get_LanguageID)(THIS_ MsoAppLanguageID id, int FAR* plid) PURE;
    STDMETHOD(get_LanguagePreferredForEditing)(THIS_ MsoLanguageID lid, VARIANT_BOOL FAR* pf) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
};

DEFINE_GUID(IID_ICommandBarsEvents,0x55F88892L,0x7708,0x11D1,0xAC,0xEB,0x00,0x60,0x08,0x96,0x1D,0xA5);

/* Definition of interface: ICommandBarsEvents */
#undef INTERFACE
#define INTERFACE ICommandBarsEvents

DECLARE_INTERFACE_(ICommandBarsEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* ICommandBarsEvents methods */
    STDMETHOD_(void, OnUpdate)(THIS) PURE;
};

DEFINE_GUID(DIID__CommandBarsEvents,0x000C0352L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of dispatch interface: CommandBarsEvents */
#undef INTERFACE
#define INTERFACE CommandBarsEvents

DECLARE_INTERFACE_(CommandBarsEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

/* Capable of dispatching all the methods of interface ICommandBarsEvents */
};

DEFINE_GUID(CLSID_CommandBars,0x55F88893L,0x7708,0x11D1,0xAC,0xEB,0x00,0x60,0x08,0x96,0x1D,0xA5);

#ifdef __cplusplus
class MsoCommandBars;
#endif

#ifdef __cplusplus
class MsoCommandBarComboBox;
#endif

DEFINE_GUID(IID_ICommandBarComboBoxEvents,0x55F88896L,0x7708,0x11D1,0xAC,0xEB,0x00,0x60,0x08,0x96,0x1D,0xA5);

/* Definition of interface: ICommandBarComboBoxEvents */
#undef INTERFACE
#define INTERFACE ICommandBarComboBoxEvents

DECLARE_INTERFACE_(ICommandBarComboBoxEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* ICommandBarComboBoxEvents methods */
    STDMETHOD_(void, Change)(THIS_ CommandBarComboBox FAR* Ctrl) PURE;
};

DEFINE_GUID(DIID__CommandBarComboBoxEvents,0x000C0354L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of dispatch interface: CommandBarComboBoxEvents */
#undef INTERFACE
#define INTERFACE CommandBarComboBoxEvents

DECLARE_INTERFACE_(CommandBarComboBoxEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

/* Capable of dispatching all the methods of interface ICommandBarComboBoxEvents */
};

DEFINE_GUID(CLSID_CommandBarComboBox,0x55F88897L,0x7708,0x11D1,0xAC,0xEB,0x00,0x60,0x08,0x96,0x1D,0xA5);

#ifdef __cplusplus
class MsoCommandBarComboBox;
#endif

#ifdef __cplusplus
class MsoCommandBarButton;
#endif

DEFINE_GUID(IID_ICommandBarButtonEvents,0x55F88890L,0x7708,0x11D1,0xAC,0xEB,0x00,0x60,0x08,0x96,0x1D,0xA5);

/* Definition of interface: ICommandBarButtonEvents */
#undef INTERFACE
#define INTERFACE ICommandBarButtonEvents

DECLARE_INTERFACE_(ICommandBarButtonEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* ICommandBarButtonEvents methods */
    STDMETHOD_(void, Click)(THIS_ CommandBarButton FAR* Ctrl, VARIANT_BOOL FAR* CancelDefault) PURE;
};

DEFINE_GUID(DIID__CommandBarButtonEvents,0x000C0351L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of dispatch interface: CommandBarButtonEvents */
#undef INTERFACE
#define INTERFACE CommandBarButtonEvents

DECLARE_INTERFACE_(CommandBarButtonEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

/* Capable of dispatching all the methods of interface ICommandBarButtonEvents */
};

DEFINE_GUID(CLSID_CommandBarButton,0x55F88891L,0x7708,0x11D1,0xAC,0xEB,0x00,0x60,0x08,0x96,0x1D,0xA5);

#ifdef __cplusplus
class MsoCommandBarButton;
#endif

typedef enum {
    msoScreenSize544x376 = 0,
    msoScreenSize640x480,
    msoScreenSize720x512,
    msoScreenSize800x600,
    msoScreenSize1024x768,
    msoScreenSize1152x882,
    msoScreenSize1152x900,
    msoScreenSize1280x1024,
    msoScreenSize1600x1200,
    msoScreenSize1800x1440,
    msoScreenSize1920x1200
} MsoScreenSize;

typedef enum {
    msoCharacterSetArabic = 1,
    msoCharacterSetCyrillic,
    msoCharacterSetEnglishWesternEuropeanOtherLatinScript,
    msoCharacterSetGreek,
    msoCharacterSetHebrew,
    msoCharacterSetJapanese,
    msoCharacterSetKorean,
    msoCharacterSetMultilingualUnicode,
    msoCharacterSetSimplifiedChinese,
    msoCharacterSetThai,
    msoCharacterSetTraditionalChinese,
    msoCharacterSetVietnamese
} MsoCharacterSet;

typedef enum {
    msoEncodingThai = 874,
    msoEncodingJapaneseShiftJIS = 932,
    msoEncodingSimplifiedChineseGBK = 936,
    msoEncodingKorean = 949,
    msoEncodingTraditionalChineseBig5 = 950,
    msoEncodingUnicodeLittleEndian = 1200,
    msoEncodingUnicodeBigEndian = 1201,
    msoEncodingCentralEuropean = 1250,
    msoEncodingCyrillic = 1251,
    msoEncodingWestern = 1252,
    msoEncodingGreek = 1253,
    msoEncodingTurkish = 1254,
    msoEncodingHebrew = 1255,
    msoEncodingArabic = 1256,
    msoEncodingBaltic = 1257,
    msoEncodingVietnamese = 1258,
    msoEncodingAutoDetect = 50001,
    msoEncodingJapaneseAutoDetect = 50932,
    msoEncodingSimplifiedChineseAutoDetect = 50936,
    msoEncodingKoreanAutoDetect = 50949,
    msoEncodingTraditionalChineseAutoDetect = 50950,
    msoEncodingCyrillicAutoDetect = 51251,
    msoEncodingGreekAutoDetect = 51253,
    msoEncodingArabicAutoDetect = 51256,
    msoEncodingISO88591Latin1 = 28591,
    msoEncodingISO88592CentralEurope = 28592,
    msoEncodingISO88593Latin3 = 28593,
    msoEncodingISO88594Baltic = 28594,
    msoEncodingISO88595Cyrillic = 28595,
    msoEncodingISO88596Arabic = 28596,
    msoEncodingISO88597Greek = 28597,
    msoEncodingISO88598Hebrew = 28598,
    msoEncodingISO88599Turkish = 28599,
    msoEncodingISO885915Latin9 = 28605,
    msoEncodingISO2022JPNoHalfwidthKatakana = 50220,
    msoEncodingISO2022JPJISX02021984 = 50221,
    msoEncodingISO2022JPJISX02011989 = 50222,
    msoEncodingISO2022KR = 50225,
    msoEncodingISO2022CNTraditionalChinese = 50227,
    msoEncodingISO2022CNSimplifiedChinese = 50229,
    msoEncodingMacRoman = 10000,
    msoEncodingMacJapanese = 10001,
    msoEncodingMacTraditionalChineseBig5 = 10002,
    msoEncodingMacKorean = 10003,
    msoEncodingMacArabic = 10004,
    msoEncodingMacHebrew = 10005,
    msoEncodingMacGreek1 = 10006,
    msoEncodingMacCyrillic = 10007,
    msoEncodingMacSimplifiedChineseGB2312 = 10008,
    msoEncodingMacRomania = 10010,
    msoEncodingMacUkraine = 10017,
    msoEncodingMacLatin2 = 10029,
    msoEncodingMacIcelandic = 10079,
    msoEncodingMacTurkish = 10081,
    msoEncodingMacCroatia = 10082,
    msoEncodingEBCDICUSCanada = 37,
    msoEncodingEBCDICInternational = 500,
    msoEncodingEBCDICMultilingualROECELatin2 = 870,
    msoEncodingEBCDICGreekModern = 875,
    msoEncodingEBCDICTurkishLatin5 = 1026,
    msoEncodingEBCDICGermany = 20273,
    msoEncodingEBCDICDenmarkNorway = 20277,
    msoEncodingEBCDICFinlandSweden = 20278,
    msoEncodingEBCDICItaly = 20280,
    msoEncodingEBCDICLatinAmericaSpain = 20284,
    msoEncodingEBCDICUnitedKingdom = 20285,
    msoEncodingEBCDICJapaneseKatakanaExtended = 20290,
    msoEncodingEBCDICFrance = 20297,
    msoEncodingEBCDICArabic = 20420,
    msoEncodingEBCDICGreek = 20423,
    msoEncodingEBCDICHebrew = 20424,
    msoEncodingEBCDICKoreanExtended = 20833,
    msoEncodingEBCDICThai = 20838,
    msoEncodingEBCDICIcelandic = 20871,
    msoEncodingEBCDICTurkish = 20905,
    msoEncodingEBCDICRussian = 20880,
    msoEncodingEBCDICSerbianBulgarian = 21025,
    msoEncodingEBCDICJapaneseKatakanaExtendedAndJapanese = 50930,
    msoEncodingEBCDICUSCanadaAndJapanese = 50931,
    msoEncodingEBCDICKoreanExtendedAndKorean = 50933,
    msoEncodingEBCDICSimplifiedChineseExtendedAndSimplifiedChinese = 50935,
    msoEncodingEBCDICUSCanadaAndTraditionalChinese = 50937,
    msoEncodingEBCDICJapaneseLatinExtendedAndJapanese = 50939,
    msoEncodingOEMUnitedStates = 437,
    msoEncodingOEMGreek437G = 737,
    msoEncodingOEMBaltic = 775,
    msoEncodingOEMMultilingualLatinI = 850,
    msoEncodingOEMMultilingualLatinII = 852,
    msoEncodingOEMCyrillic = 855,
    msoEncodingOEMTurkish = 857,
    msoEncodingOEMPortuguese = 860,
    msoEncodingOEMIcelandic = 861,
    msoEncodingOEMHebrew = 862,
    msoEncodingOEMCanadianFrench = 863,
    msoEncodingOEMArabic = 864,
    msoEncodingOEMNordic = 865,
    msoEncodingOEMCyrillicII = 866,
    msoEncodingOEMModernGreek = 869,
    msoEncodingEUCJapanese = 51932,
    msoEncodingEUCChineseSimplifiedChinese = 51936,
    msoEncodingEUCKorean = 51949,
    msoEncodingEUCTaiwaneseTraditionalChinese = 51950,
    msoEncodingISCIIDevanagari = 57002,
    msoEncodingISCIIBengali = 57003,
    msoEncodingISCIITamil = 57004,
    msoEncodingISCIITelugu = 57005,
    msoEncodingISCIIAssamese = 57006,
    msoEncodingISCIIOriya = 57007,
    msoEncodingISCIIKannada = 57008,
    msoEncodingISCIIMalayalam = 57009,
    msoEncodingISCIIGujarati = 57010,
    msoEncodingISCIIPunjabi = 57011,
    msoEncodingArabicASMO = 708,
    msoEncodingArabicTransparentASMO = 720,
    msoEncodingKoreanJohab = 1361,
    msoEncodingTaiwanCNS = 20000,
    msoEncodingTaiwanTCA = 20001,
    msoEncodingTaiwanEten = 20002,
    msoEncodingTaiwanIBM5550 = 20003,
    msoEncodingTaiwanTeleText = 20004,
    msoEncodingTaiwanWang = 20005,
    msoEncodingIA5IRV = 20105,
    msoEncodingIA5German = 20106,
    msoEncodingIA5Swedish = 20107,
    msoEncodingIA5Norwegian = 20108,
    msoEncodingUSASCII = 20127,
    msoEncodingT61 = 20261,
    msoEncodingISO6937NonSpacingAccent = 20269,
    msoEncodingKOI8R = 20866,
    msoEncodingExtAlphaLowercase = 21027,
    msoEncodingKOI8U = 21866,
    msoEncodingEuropa3 = 29001,
    msoEncodingHZGBSimplifiedChinese = 52936,
    msoEncodingUTF7 = 65000,
    msoEncodingUTF8 = 65001
} MsoEncoding;

DEFINE_GUID(IID_WebPageFont,0x000C0913L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: WebPageFont */
#undef INTERFACE
#define INTERFACE WebPageFont

DECLARE_INTERFACE_(WebPageFont, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* WebPageFont methods */
    STDMETHOD(get_ProportionalFont)(THIS_ BSTR FAR* pstr) PURE;
    STDMETHOD(put_ProportionalFont)(THIS_ BSTR str) PURE;
    STDMETHOD(get_ProportionalFontSize)(THIS_ float FAR* pf) PURE;
    STDMETHOD(put_ProportionalFontSize)(THIS_ float f) PURE;
    STDMETHOD(get_FixedWidthFont)(THIS_ BSTR FAR* pstr) PURE;
    STDMETHOD(put_FixedWidthFont)(THIS_ BSTR str) PURE;
    STDMETHOD(get_FixedWidthFontSize)(THIS_ float FAR* pf) PURE;
    STDMETHOD(put_FixedWidthFontSize)(THIS_ float f) PURE;
};

DEFINE_GUID(IID_WebPageFonts,0x000C0914L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: WebPageFonts */
#undef INTERFACE
#define INTERFACE WebPageFonts

DECLARE_INTERFACE_(WebPageFonts, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* WebPageFonts methods */
    STDMETHOD(get_Count)(THIS_ int FAR* Count) PURE;
    STDMETHOD(get_Item)(THIS_ MsoCharacterSet Index, WebPageFont FAR* FAR* Item) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* _NewEnum) PURE;
};

typedef enum {
    msoHTMLProjectOpenSourceView = 1,
    msoHTMLProjectOpenTextView = 2
} MsoHTMLProjectOpen;

typedef enum {
    msoHTMLProjectStateDocumentLocked = 1,
    msoHTMLProjectStateProjectLocked = 2,
    msoHTMLProjectStateDocumentProjectUnlocked = 3
} MsoHTMLProjectState;

DEFINE_GUID(IID_HTMLProjectItem,0x000C0358L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: HTMLProjectItem */
#undef INTERFACE
#define INTERFACE HTMLProjectItem

DECLARE_INTERFACE_(HTMLProjectItem, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* HTMLProjectItem methods */
    STDMETHOD(get_Name)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(get_IsOpen)(THIS_ VARIANT_BOOL FAR* RetValue) PURE;
    STDMETHOD(LoadFromFile)(THIS_ BSTR FileName) PURE;
    STDMETHOD(Open)(THIS_ MsoHTMLProjectOpen OpenKind) PURE;
    STDMETHOD(SaveCopyAs)(THIS_ BSTR FileName) PURE;
    STDMETHOD(get_Text)(THIS_ BSTR FAR* Text) PURE;
    STDMETHOD(put_Text)(THIS_ BSTR Text) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
};

DEFINE_GUID(IID_HTMLProjectItems,0x000C0357L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: HTMLProjectItems */
#undef INTERFACE
#define INTERFACE HTMLProjectItems

DECLARE_INTERFACE_(HTMLProjectItems, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* HTMLProjectItems methods */
    STDMETHOD(Item)(THIS_ VARIANT FAR* Index, HTMLProjectItem FAR* FAR* RetValue) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* RetValue) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
};

DEFINE_GUID(IID_HTMLProject,0x000C0356L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: HTMLProject */
#undef INTERFACE
#define INTERFACE HTMLProject

DECLARE_INTERFACE_(HTMLProject, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* HTMLProject methods */
    STDMETHOD(get_State)(THIS_ MsoHTMLProjectState FAR* State) PURE;
    STDMETHOD(RefreshProject)(THIS_ VARIANT_BOOL Refresh) PURE;
    STDMETHOD(RefreshDocument)(THIS_ VARIANT_BOOL Refresh) PURE;
    STDMETHOD(get_HTMLProjectItems)(THIS_ HTMLProjectItems FAR* FAR* HTMLProjectItems) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(Open)(THIS_ MsoHTMLProjectOpen OpenKind) PURE;
};

DEFINE_GUID(IID_MsoDebugOptions,0x000C035AL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: MsoDebugOptions */
#undef INTERFACE
#define INTERFACE MsoDebugOptions

DECLARE_INTERFACE_(MsoDebugOptions, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* MsoDebugOptions methods */
    STDMETHOD(get_FeatureReports)(THIS_ int FAR* puintFeatureReports) PURE;
    STDMETHOD(put_FeatureReports)(THIS_ int uintFeatureReports) PURE;
    STDMETHOD(get_OutputToDebugger)(THIS_ VARIANT_BOOL FAR* pvarfOutputToDebugger) PURE;
    STDMETHOD(put_OutputToDebugger)(THIS_ VARIANT_BOOL varfOutputToDebugger) PURE;
    STDMETHOD(get_OutputToFile)(THIS_ VARIANT_BOOL FAR* pvarfOutputToFile) PURE;
    STDMETHOD(put_OutputToFile)(THIS_ VARIANT_BOOL varfOutputToFile) PURE;
    STDMETHOD(get_OutputToMessageBox)(THIS_ VARIANT_BOOL FAR* pvarfOutputToMessageBox) PURE;
    STDMETHOD(put_OutputToMessageBox)(THIS_ VARIANT_BOOL varfOutputToMessageBox) PURE;
};

typedef enum {
    msoFileDialogOpen = 1,
    msoFileDialogSaveAs,
    msoFileDialogFilePicker,
    msoFileDialogFolderPicker
} MsoFileDialogType;

typedef enum {
    msoFileDialogViewList = 1,
    msoFileDialogViewDetails,
    msoFileDialogViewProperties,
    msoFileDialogViewPreview,
    msoFileDialogViewThumbnail,
    msoFileDialogViewLargeIcons,
    msoFileDialogViewSmallIcons,
    msoFileDialogViewWebView
} MsoFileDialogView;

DEFINE_GUID(IID_FileDialogSelectedItems,0x000C0363L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FileDialogSelectedItems */
#undef INTERFACE
#define INTERFACE FileDialogSelectedItems

DECLARE_INTERFACE_(FileDialogSelectedItems, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FileDialogSelectedItems methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* pcFiles) PURE;
    STDMETHOD(Item)(THIS_ int Index, BSTR FAR* Item) PURE;
};

DEFINE_GUID(IID_FileDialogFilter,0x000C0364L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FileDialogFilter */
#undef INTERFACE
#define INTERFACE FileDialogFilter

DECLARE_INTERFACE_(FileDialogFilter, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FileDialogFilter methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Extensions)(THIS_ BSTR FAR* Extensions) PURE;
    STDMETHOD(get_Description)(THIS_ BSTR FAR* Description) PURE;
};

DEFINE_GUID(IID_FileDialogFilters,0x000C0365L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FileDialogFilters */
#undef INTERFACE
#define INTERFACE FileDialogFilters

DECLARE_INTERFACE_(FileDialogFilters, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FileDialogFilters methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
    STDMETHOD(get_Count)(THIS_ long FAR* pcFilters) PURE;
    STDMETHOD(Item)(THIS_ int Index, FileDialogFilter FAR* FAR* Item) PURE;
    STDMETHOD(Delete)(THIS_ VARIANT filter) PURE;
    STDMETHOD(Clear)(THIS) PURE;
    STDMETHOD(Add)(THIS_ BSTR Description, BSTR Extensions, VARIANT Position, FileDialogFilter FAR* FAR* Add) PURE;
};

DEFINE_GUID(IID_FileDialog,0x000C0362L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FileDialog */
#undef INTERFACE
#define INTERFACE FileDialog

DECLARE_INTERFACE_(FileDialog, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FileDialog methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Filters)(THIS_ FileDialogFilters FAR* FAR* Filters) PURE;
    STDMETHOD(get_FilterIndex)(THIS_ int FAR* FilterIndex) PURE;
    STDMETHOD(put_FilterIndex)(THIS_ int FilterIndex) PURE;
    STDMETHOD(get_Title)(THIS_ BSTR FAR* Title) PURE;
    STDMETHOD(put_Title)(THIS_ BSTR Title) PURE;
    STDMETHOD(get_ButtonName)(THIS_ BSTR FAR* ButtonName) PURE;
    STDMETHOD(put_ButtonName)(THIS_ BSTR ButtonName) PURE;
    STDMETHOD(get_AllowMultiSelect)(THIS_ VARIANT_BOOL FAR* pvarfAllowMultiSelect) PURE;
    STDMETHOD(put_AllowMultiSelect)(THIS_ VARIANT_BOOL varfAllowMultiSelect) PURE;
    STDMETHOD(get_InitialView)(THIS_ MsoFileDialogView FAR* pinitialview) PURE;
    STDMETHOD(put_InitialView)(THIS_ MsoFileDialogView initialview) PURE;
    STDMETHOD(get_InitialFileName)(THIS_ BSTR FAR* InitialFileName) PURE;
    STDMETHOD(put_InitialFileName)(THIS_ BSTR InitialFileName) PURE;
    STDMETHOD(get_SelectedItems)(THIS_ FileDialogSelectedItems FAR* FAR* Files) PURE;
    STDMETHOD(get_DialogType)(THIS_ MsoFileDialogType FAR* pdialogtype) PURE;
    STDMETHOD(get_Item)(THIS_ BSTR FAR* Name) PURE;
    STDMETHOD(Show)(THIS_ int FAR* rval) PURE;
    STDMETHOD(Execute)(THIS) PURE;
};

typedef enum {
    msoAutomationSecurityLow = 1,
    msoAutomationSecurityByUI = 2,
    msoAutomationSecurityForceDisable = 3
} MsoAutomationSecurity;

DEFINE_GUID(IID_SignatureSet,0x000C0410L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: SignatureSet */
#undef INTERFACE
#define INTERFACE SignatureSet

DECLARE_INTERFACE_(SignatureSet, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* SignatureSet methods */
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppienum) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* pcSig) PURE;
    STDMETHOD(get_Item)(THIS_ int iSig, Signature FAR* FAR* ppidisp) PURE;
    STDMETHOD(Add)(THIS_ Signature FAR* FAR* ppidisp) PURE;
    STDMETHOD(Commit)(THIS) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
};

DEFINE_GUID(IID_Signature,0x000C0411L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: Signature */
#undef INTERFACE
#define INTERFACE Signature

DECLARE_INTERFACE_(Signature, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* Signature methods */
    STDMETHOD(get_Signer)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_Issuer)(THIS_ BSTR FAR* pbstr) PURE;
    STDMETHOD(get_ExpireDate)(THIS_ VARIANT FAR* pvarDate) PURE;
    STDMETHOD(get_IsValid)(THIS_ VARIANT_BOOL FAR* pfValid) PURE;
    STDMETHOD(get_AttachCertificate)(THIS_ VARIANT_BOOL FAR* pfAttach) PURE;
    STDMETHOD(put_AttachCertificate)(THIS_ VARIANT_BOOL fAttach) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_IsCertificateExpired)(THIS_ VARIANT_BOOL FAR* pfExpired) PURE;
    STDMETHOD(get_IsCertificateRevoked)(THIS_ VARIANT_BOOL FAR* pfExpired) PURE;
    STDMETHOD(get_SignDate)(THIS_ VARIANT FAR* pvarDate) PURE;
};

typedef enum {
    mfPlainText = 1,
    mfHTML = 2,
    mfRTF = 3
} MailFormat;

DEFINE_GUID(IID_IMsoEnvelopeVB,0x000672ACL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: IMsoEnvelopeVB */
#undef INTERFACE
#define INTERFACE IMsoEnvelopeVB

DECLARE_INTERFACE_(IMsoEnvelopeVB, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IMsoEnvelopeVB methods */
    STDMETHOD(get_Introduction)(THIS_ BSTR FAR* pbstrIntro) PURE;
    STDMETHOD(put_Introduction)(THIS_ BSTR bstrIntro) PURE;
    STDMETHOD(get_Item)(THIS_ IDispatch * FAR* ppdisp) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppdisp) PURE;
    STDMETHOD(get_CommandBars)(THIS_ IDispatch * FAR* ppdisp) PURE;
};

DEFINE_GUID(DIID_IMsoEnvelopeVBEvents,0x000672ADL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of dispatch interface: IMsoEnvelopeVBEvents */
#undef INTERFACE
#define INTERFACE IMsoEnvelopeVBEvents

DECLARE_INTERFACE_(IMsoEnvelopeVBEvents, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IMsoEnvelopeVBEvents methods:
    void EnvelopeShow(void);
    void EnvelopeHide(void);
    */
};

DEFINE_GUID(CLSID_MsoEnvelope,0x0006F01AL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

#ifdef __cplusplus
class MsoEnvelope;
#endif

typedef enum tagMsoAlertButtonType {
    msoAlertButtonOK = 0,
    msoAlertButtonOKCancel = 1,
    msoAlertButtonAbortRetryIgnore = 2,
    msoAlertButtonYesNoCancel = 3,
    msoAlertButtonYesNo = 4,
    msoAlertButtonRetryCancel = 5,
    msoAlertButtonYesAllNoCancel = 6
} MsoAlertButtonType;

typedef enum tagMsoAlertIconType {
    msoAlertIconNoIcon = 0,
    msoAlertIconCritical = 1,
    msoAlertIconQuery = 2,
    msoAlertIconWarning = 3,
    msoAlertIconInfo = 4
} MsoAlertIconType;

typedef enum tagMsoAlertDefaultType {
    msoAlertDefaultFirst = 0,
    msoAlertDefaultSecond = 1,
    msoAlertDefaultThird = 2,
    msoAlertDefaultFourth = 3,
    msoAlertDefaultFifth = 4
} MsoAlertDefaultType;

typedef enum tagMsoAlertCancelType {
    msoAlertCancelDefault = -1,
    msoAlertCancelFirst = 0,
    msoAlertCancelSecond = 1,
    msoAlertCancelThird = 2,
    msoAlertCancelFourth = 3,
    msoAlertCancelFifth = 4
} MsoAlertCancelType;

typedef enum {
    msoSearchInMyComputer = 0,
    msoSearchInOutlook = 1,
    msoSearchInMyNetworkPlaces = 2,
    msoSearchInCustom = 3
} MsoSearchIn;

typedef enum {
    msoTargetBrowserV3,
    msoTargetBrowserV4,
    msoTargetBrowserIE4,
    msoTargetBrowserIE5,
    msoTargetBrowserIE6
} MsoTargetBrowser;

DEFINE_GUID(IID_FileTypes,0x000C036CL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: FileTypes */
#undef INTERFACE
#define INTERFACE FileTypes

DECLARE_INTERFACE_(FileTypes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* FileTypes methods */
    STDMETHOD(get_Item)(THIS_ int Index, MsoFileType FAR* MsoFileTypeRet) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* iCountRetVal) PURE;
    STDMETHOD(Add)(THIS_ MsoFileType FileType) PURE;
    STDMETHOD(Remove)(THIS_ int Index) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

DEFINE_GUID(IID_SearchFolders,0x000C036AL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: SearchFolders */
#undef INTERFACE
#define INTERFACE SearchFolders

DECLARE_INTERFACE_(SearchFolders, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* SearchFolders methods */
    STDMETHOD(get_Item)(THIS_ int Index, ScopeFolder FAR* FAR* ScopeFolderRet) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* iCountRetVal) PURE;
    STDMETHOD(Add)(THIS_ ScopeFolder FAR* ScopeFolder) PURE;
    STDMETHOD(Remove)(THIS_ int Index) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

DEFINE_GUID(IID_ScopeFolders,0x000C0369L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ScopeFolders */
#undef INTERFACE
#define INTERFACE ScopeFolders

DECLARE_INTERFACE_(ScopeFolders, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ScopeFolders methods */
    STDMETHOD(get_Item)(THIS_ int Index, ScopeFolder FAR* FAR* ScopeFolderRet) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* iCountRetVal) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

DEFINE_GUID(IID_ScopeFolder,0x000C0368L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ScopeFolder */
#undef INTERFACE
#define INTERFACE ScopeFolder

DECLARE_INTERFACE_(ScopeFolder, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ScopeFolder methods */
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Path)(THIS_ BSTR FAR* pbstrPath) PURE;
    STDMETHOD(get_ScopeFolders)(THIS_ ScopeFolders FAR* FAR* ScopeFoldersRet) PURE;
    STDMETHOD(AddToSearchFolders)(THIS) PURE;
};

DEFINE_GUID(IID_SearchScope,0x000C0367L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: SearchScope */
#undef INTERFACE
#define INTERFACE SearchScope

DECLARE_INTERFACE_(SearchScope, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* SearchScope methods */
    STDMETHOD(get_Type)(THIS_ MsoSearchIn FAR* MsoSearchInRetVal) PURE;
    STDMETHOD(get_ScopeFolder)(THIS_ ScopeFolder FAR* FAR* ScopeFolderRet) PURE;
};

DEFINE_GUID(IID_SearchScopes,0x000C0366L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: SearchScopes */
#undef INTERFACE
#define INTERFACE SearchScopes

DECLARE_INTERFACE_(SearchScopes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* SearchScopes methods */
    STDMETHOD(get_Item)(THIS_ int Index, SearchScope FAR* FAR* SearchScopeRet) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* iCountRetVal) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
};

typedef enum tagMsoOrgChartOrientation {
    msoOrgChartOrientationMixed = -2,
    msoOrgChartOrientationVertical = 1
} MsoOrgChartOrientation;

typedef enum {
    msoOrgChartLayoutMixed = -2,
    msoOrgChartLayoutStandard = 1,
    msoOrgChartLayoutBothHanging,
    msoOrgChartLayoutLeftHanging,
    msoOrgChartLayoutRightHanging
} MsoOrgChartLayoutType;

typedef enum {
    msoBeforeNode = 1,
    msoAfterNode,
    msoBeforeFirstSibling,
    msoAfterLastSibling
} MsoRelativeNodePosition;

typedef enum tagMsoDiagramType {
    msoDiagramMixed = -2,
    msoDiagramOrgChart = 1,
    msoDiagramCycle,
    msoDiagramRadial,
    msoDiagramPyramid,
    msoDiagramVenn,
    msoDiagramTarget
} MsoDiagramType;

typedef enum tagMsoDiagramNodeType {
    msoDiagramNode = 1,
    msoDiagramAssistant
} MsoDiagramNodeType;

DEFINE_GUID(IID_IMsoDiagram,0x000C036DL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: IMsoDiagram */
#undef INTERFACE
#define INTERFACE IMsoDiagram

DECLARE_INTERFACE_(IMsoDiagram, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* IMsoDiagram methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Nodes)(THIS_ DiagramNodes FAR* FAR* Nodes) PURE;
    STDMETHOD(get_Type)(THIS_ enum tagMsoDiagramType FAR* Type) PURE;
    STDMETHOD(get_AutoLayout)(THIS_ MsoTriState FAR* AutoLayout) PURE;
    STDMETHOD(put_AutoLayout)(THIS_ MsoTriState AutoLayout) PURE;
    STDMETHOD(get_Reverse)(THIS_ MsoTriState FAR* Reverse) PURE;
    STDMETHOD(put_Reverse)(THIS_ MsoTriState Reverse) PURE;
    STDMETHOD(get_AutoFormat)(THIS_ MsoTriState FAR* AutoFormat) PURE;
    STDMETHOD(put_AutoFormat)(THIS_ MsoTriState AutoFormat) PURE;
    STDMETHOD(Convert)(THIS_ enum tagMsoDiagramType Type) PURE;
};

DEFINE_GUID(IID_DiagramNodes,0x000C036EL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: DiagramNodes */
#undef INTERFACE
#define INTERFACE DiagramNodes

DECLARE_INTERFACE_(DiagramNodes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* DiagramNodes methods */
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, DiagramNode FAR* FAR* ppdn) PURE;
    STDMETHOD(SelectAll)(THIS) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* iDiagramNodes) PURE;
};

DEFINE_GUID(IID_DiagramNodeChildren,0x000C036FL,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: DiagramNodeChildren */
#undef INTERFACE
#define INTERFACE DiagramNodeChildren

DECLARE_INTERFACE_(DiagramNodeChildren, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* DiagramNodeChildren methods */
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* ppunkEnum) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, DiagramNode FAR* FAR* Node) PURE;
    STDMETHOD(AddNode)(THIS_ VARIANT Index, enum tagMsoDiagramNodeType NodeType, DiagramNode FAR* FAR* NewNode) PURE;
    STDMETHOD(SelectAll)(THIS) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* iDiagramNodes) PURE;
    STDMETHOD(get_FirstChild)(THIS_ DiagramNode FAR* FAR* First) PURE;
    STDMETHOD(get_LastChild)(THIS_ DiagramNode FAR* FAR* Last) PURE;
};

DEFINE_GUID(IID_DiagramNode,0x000C0370L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: DiagramNode */
#undef INTERFACE
#define INTERFACE DiagramNode

DECLARE_INTERFACE_(DiagramNode, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* DiagramNode methods */
    STDMETHOD(AddNode)(THIS_ MsoRelativeNodePosition Pos, enum tagMsoDiagramNodeType NodeType, DiagramNode FAR* FAR* NewNode) PURE;
    STDMETHOD(Delete)(THIS) PURE;
    STDMETHOD(MoveNode)(THIS_ DiagramNode FAR* TargetNode, MsoRelativeNodePosition Pos) PURE;
    STDMETHOD(ReplaceNode)(THIS_ DiagramNode FAR* TargetNode) PURE;
    STDMETHOD(SwapNode)(THIS_ DiagramNode FAR* TargetNode, VARIANT_BOOL SwapChildren) PURE;
    STDMETHOD(CloneNode)(THIS_ VARIANT_BOOL CopyChildren, DiagramNode FAR* TargetNode, MsoRelativeNodePosition Pos, DiagramNode FAR* FAR* Node) PURE;
    STDMETHOD(TransferChildren)(THIS_ DiagramNode FAR* ReceivingNode) PURE;
    STDMETHOD(NextNode)(THIS_ DiagramNode FAR* FAR* NextNode) PURE;
    STDMETHOD(PrevNode)(THIS_ DiagramNode FAR* FAR* PrevNode) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Children)(THIS_ DiagramNodeChildren FAR* FAR* Children) PURE;
    STDMETHOD(get_Shape)(THIS_ Shape FAR* FAR* Shape) PURE;
    STDMETHOD(get_Root)(THIS_ DiagramNode FAR* FAR* Root) PURE;
    STDMETHOD(get_Diagram)(THIS_ IMsoDiagram FAR* FAR* Diagram) PURE;
    STDMETHOD(get_Layout)(THIS_ MsoOrgChartLayoutType FAR* Type) PURE;
    STDMETHOD(put_Layout)(THIS_ MsoOrgChartLayoutType Type) PURE;
    STDMETHOD(get_TextShape)(THIS_ Shape FAR* FAR* Shape) PURE;
};

DEFINE_GUID(IID_CanvasShapes,0x000C0371L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: CanvasShapes */
#undef INTERFACE
#define INTERFACE CanvasShapes

DECLARE_INTERFACE_(CanvasShapes, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* CanvasShapes methods */
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_Count)(THIS_ int FAR* Count) PURE;
    STDMETHOD(Item)(THIS_ VARIANT Index, Shape FAR* FAR* Item) PURE;
    STDMETHOD(get__NewEnum)(THIS_ IUnknown * FAR* _NewEnum) PURE;
    STDMETHOD(AddCallout)(THIS_ MsoCalloutType Type, float Left, float Top, float Width, float Height, Shape FAR* FAR* Callout) PURE;
    STDMETHOD(AddConnector)(THIS_ MsoConnectorType Type, float BeginX, float BeginY, float EndX, float EndY, Shape FAR* FAR* Connector) PURE;
    STDMETHOD(AddCurve)(THIS_ VARIANT SafeArrayOfPoints, Shape FAR* FAR* Curve) PURE;
    STDMETHOD(AddLabel)(THIS_ MsoTextOrientation Orientation, float Left, float Top, float Width, float Height, Shape FAR* FAR* Label) PURE;
    STDMETHOD(AddLine)(THIS_ float BeginX, float BeginY, float EndX, float EndY, Shape FAR* FAR* Line) PURE;
    STDMETHOD(AddPicture)(THIS_ BSTR FileName, MsoTriState LinkToFile, MsoTriState SaveWithDocument, float Left, float Top, float Width, float Height, Shape FAR* FAR* Picture) PURE;
    STDMETHOD(AddPolyline)(THIS_ VARIANT SafeArrayOfPoints, Shape FAR* FAR* Polyline) PURE;
    STDMETHOD(AddShape)(THIS_ MsoAutoShapeType Type, float Left, float Top, float Width, float Height, Shape FAR* FAR* Shape) PURE;
    STDMETHOD(AddTextEffect)(THIS_ MsoPresetTextEffect PresetTextEffect, BSTR Text, BSTR FontName, float FontSize, MsoTriState FontBold, MsoTriState FontItalic, float Left, float Top, Shape FAR* FAR* TextEffect) PURE;
    STDMETHOD(AddTextbox)(THIS_ MsoTextOrientation Orientation, float Left, float Top, float Width, float Height, Shape FAR* FAR* Textbox) PURE;
    STDMETHOD(BuildFreeform)(THIS_ MsoEditingType EditingType, float X1, float Y1, FreeformBuilder FAR* FAR* FreeformBuilder) PURE;
    STDMETHOD(Range)(THIS_ VARIANT Index, ShapeRange FAR* FAR* Range) PURE;
    STDMETHOD(SelectAll)(THIS) PURE;
    STDMETHOD(get_Background)(THIS_ Shape FAR* FAR* Background) PURE;
};

typedef enum {
    msoMoveRowFirst = -4,
    msoMoveRowPrev = -3,
    msoMoveRowNext = -2,
    msoMoveRowNbr = -1
} MsoMoveRow;

DEFINE_GUID(IID_OfficeDataSourceObject,0x000C1530L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: OfficeDataSourceObject */
#undef INTERFACE
#define INTERFACE OfficeDataSourceObject

DECLARE_INTERFACE_(OfficeDataSourceObject, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* OfficeDataSourceObject methods */
    STDMETHOD(get_ConnectString)(THIS_ BSTR FAR* pbstrConnect) PURE;
    STDMETHOD(put_ConnectString)(THIS_ BSTR bstrConnect) PURE;
    STDMETHOD(get_Table)(THIS_ BSTR FAR* pbstrTable) PURE;
    STDMETHOD(put_Table)(THIS_ BSTR bstrTable) PURE;
    STDMETHOD(get_DataSource)(THIS_ BSTR FAR* pbstrSrc) PURE;
    STDMETHOD(put_DataSource)(THIS_ BSTR bstrSrc) PURE;
    STDMETHOD(get_Columns)(THIS_ IDispatch * FAR* ppColumns) PURE;
    STDMETHOD(get_RowCount)(THIS_ long FAR* pcRows) PURE;
    STDMETHOD(get_Filters)(THIS_ IDispatch * FAR* ppFilters) PURE;
    STDMETHOD(Move)(THIS_ MsoMoveRow msoMoveRow, int RowNbr, int FAR* rval) PURE;
    STDMETHOD(Open)(THIS_ BSTR bstrSrc, BSTR bstrConnect, BSTR bstrTable, long fOpenExclusive, long fNeverPrompt) PURE;
    STDMETHOD(SetSortOrder)(THIS_ BSTR SortField1, VARIANT_BOOL SortAscending1, BSTR SortField2, VARIANT_BOOL SortAscending2, BSTR SortField3, VARIANT_BOOL SortAscending3) PURE;
    STDMETHOD(ApplyFilter)(THIS) PURE;
};

DEFINE_GUID(IID_ODSOColumn,0x000C1531L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ODSOColumn */
#undef INTERFACE
#define INTERFACE ODSOColumn

DECLARE_INTERFACE_(ODSOColumn, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ODSOColumn methods */
    STDMETHOD(get_Index)(THIS_ long FAR* plIndex) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* pbstrName) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppParent) PURE;
    STDMETHOD(get_Value)(THIS_ BSTR FAR* pbstrValue) PURE;
};

DEFINE_GUID(IID_ODSOColumns,0x000C1532L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ODSOColumns */
#undef INTERFACE
#define INTERFACE ODSOColumns

DECLARE_INTERFACE_(ODSOColumns, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ODSOColumns methods */
    STDMETHOD(get_Count)(THIS_ long FAR* plCount) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppParentOdso) PURE;
    STDMETHOD(Item)(THIS_ VARIANT varIndex, IDispatch * FAR* ppColumn) PURE;
};

typedef enum {
    msoFilterComparisonEqual = 0,
    msoFilterComparisonNotEqual = 1,
    msoFilterComparisonLessThan = 2,
    msoFilterComparisonGreaterThan = 3,
    msoFilterComparisonLessThanEqual = 4,
    msoFilterComparisonGreaterThanEqual = 5,
    msoFilterComparisonIsBlank = 6,
    msoFilterComparisonIsNotBlank = 7,
    msoFilterComparisonContains = 8,
    msoFilterComparisonNotContains = 9
} MsoFilterComparison;

typedef enum {
    msoFilterConjunctionAnd = 0,
    msoFilterConjunctionOr = 1
} MsoFilterConjunction;

DEFINE_GUID(IID_ODSOFilter,0x000C1533L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ODSOFilter */
#undef INTERFACE
#define INTERFACE ODSOFilter

DECLARE_INTERFACE_(ODSOFilter, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ODSOFilter methods */
    STDMETHOD(get_Index)(THIS_ long FAR* plIndex) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppParent) PURE;
    STDMETHOD(get_Column)(THIS_ BSTR FAR* pbstrCol) PURE;
    STDMETHOD(put_Column)(THIS_ BSTR bstrCol) PURE;
    STDMETHOD(get_Comparison)(THIS_ MsoFilterComparison FAR* pComparison) PURE;
    STDMETHOD(put_Comparison)(THIS_ MsoFilterComparison Comparison) PURE;
    STDMETHOD(get_CompareTo)(THIS_ BSTR FAR* pbstrCompareTo) PURE;
    STDMETHOD(put_CompareTo)(THIS_ BSTR bstrCompareTo) PURE;
    STDMETHOD(get_Conjunction)(THIS_ MsoFilterConjunction FAR* pConjunction) PURE;
    STDMETHOD(put_Conjunction)(THIS_ MsoFilterConjunction Conjunction) PURE;
};

DEFINE_GUID(IID_ODSOFilters,0x000C1534L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: ODSOFilters */
#undef INTERFACE
#define INTERFACE ODSOFilters

DECLARE_INTERFACE_(ODSOFilters, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* ODSOFilters methods */
    STDMETHOD(get_Count)(THIS_ long FAR* plCount) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* ppParentOdso) PURE;
    STDMETHOD(Item)(THIS_ long Index, IDispatch * FAR* ppColumn) PURE;
    STDMETHOD(Add)(THIS_ BSTR column, MsoFilterComparison Comparison, MsoFilterConjunction Conjunction, BSTR bstrCompareTo, VARIANT_BOOL DeferUpdate) PURE;
    STDMETHOD(Delete)(THIS_ long Index, VARIANT_BOOL DeferUpdate) PURE;
};

typedef enum {
    msoOpenDocument = 0,
    msoNew,
    msoNewfromExistingFile,
    msoNewfromTemplate,
    msoBottomSection
} MsoFileNewSection;

typedef enum {
    msoEditFile = 0,
    msoCreateNewFile,
    msoOpenFile
} MsoFileNewAction;

DEFINE_GUID(IID_NewFile,0x000C0936L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: NewFile */
#undef INTERFACE
#define INTERFACE NewFile

DECLARE_INTERFACE_(NewFile, _IMsoDispObj)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;

    /* _IMsoDispObj methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppidisp) PURE;
    STDMETHOD(get_Creator)(THIS_ long FAR* plCreator) PURE;
#endif

    /* NewFile methods */
    STDMETHOD(Add)(THIS_ BSTR Filename, VARIANT Section, VARIANT DisplayName, VARIANT Action, VARIANT_BOOL FAR* pvarf) PURE;
    STDMETHOD(Remove)(THIS_ BSTR Filename, VARIANT Section, VARIANT DisplayName, VARIANT Action, VARIANT_BOOL FAR* pvarf) PURE;
};

DEFINE_GUID(IID_WebComponent,0x000CD100L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: WebComponent */
#undef INTERFACE
#define INTERFACE WebComponent

DECLARE_INTERFACE_(WebComponent, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* WebComponent methods */
    STDMETHOD(get_Shape)(THIS_ IDispatch * FAR* RetValue) PURE;
    STDMETHOD(get_URL)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_URL)(THIS_ BSTR URL) PURE;
    STDMETHOD(get_HTML)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_HTML)(THIS_ BSTR HTML) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR Name) PURE;
    STDMETHOD(get_Width)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(put_Width)(THIS_ long Width) PURE;
    STDMETHOD(get_Height)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(put_Height)(THIS_ long Height) PURE;
    STDMETHOD(SetPlaceHolderGraphic)(THIS_ BSTR PlaceHolderGraphic) PURE;
    STDMETHOD(Commit)(THIS) PURE;
    STDMETHOD(Revert)(THIS) PURE;
};

DEFINE_GUID(IID_WebComponentWindowExternal,0x000CD101L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: WebComponentWindowExternal */
#undef INTERFACE
#define INTERFACE WebComponentWindowExternal

DECLARE_INTERFACE_(WebComponentWindowExternal, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* WebComponentWindowExternal methods */
    STDMETHOD(get_InterfaceVersion)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(get_ApplicationName)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(get_ApplicationVersion)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* RetValue) PURE;
    STDMETHOD(CloseWindow)(THIS) PURE;
    STDMETHOD(get_WebComponent)(THIS_ WebComponent FAR* FAR* RetValue) PURE;
};

DEFINE_GUID(IID_WebComponentFormat,0x000CD102L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: WebComponentFormat */
#undef INTERFACE
#define INTERFACE WebComponentFormat

DECLARE_INTERFACE_(WebComponentFormat, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* WebComponentFormat methods */
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* RetValue) PURE;
    STDMETHOD(get_Parent)(THIS_ IDispatch * FAR* Parent) PURE;
    STDMETHOD(get_URL)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_URL)(THIS_ BSTR URL) PURE;
    STDMETHOD(get_HTML)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_HTML)(THIS_ BSTR HTML) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR Name) PURE;
    STDMETHOD(get_Width)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(put_Width)(THIS_ long Width) PURE;
    STDMETHOD(get_Height)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(put_Height)(THIS_ long Height) PURE;
    STDMETHOD(get_PreviewGraphic)(THIS_ BSTR FAR* RetVal) PURE;
    STDMETHOD(put_PreviewGraphic)(THIS_ BSTR PreviewGraphic) PURE;
    STDMETHOD(LaunchPropertiesWindow)(THIS) PURE;
};

typedef enum {
    msoLanguageIDChineseHongKong = 3076,
    msoLanguageIDChineseMacao = 5124,
    msoLanguageIDEnglishTrinidad = 11273
} MsoLanguageIDHidden;

typedef unsigned long DWORD;

typedef int BOOL;

DEFINE_GUID(IID_ILicWizExternal,0x4CAC6328L,0xB9B0,0x11D3,0x8D,0x59,0x00,0x50,0x04,0x83,0x84,0xE3);

/* Definition of interface: ILicWizExternal */
#undef INTERFACE
#define INTERFACE ILicWizExternal

DECLARE_INTERFACE_(ILicWizExternal, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* ILicWizExternal methods */
    STDMETHOD(PrintHtmlDocument)(THIS_ IUnknown * punkHtmlDoc) PURE;
    STDMETHOD(InvokeDateTimeApplet)(THIS) PURE;
    STDMETHOD(FormatDate)(THIS_ DATE date, BSTR pFormat, BSTR FAR* pDateString) PURE;
    STDMETHOD(ShowHelp)(THIS_ VARIANT FAR* pvarId) PURE;
    STDMETHOD(Terminate)(THIS) PURE;
    STDMETHOD(DisableVORWReminder)(THIS_ long BPC) PURE;
    STDMETHOD(SaveReceipt)(THIS_ BSTR bstrReceipt, BSTR FAR* pbstrPath) PURE;
    STDMETHOD(OpenInDefaultBrowser)(THIS_ BSTR bstrUrl) PURE;
    STDMETHOD(MsoAlert)(THIS_ BSTR bstrText, BSTR bstrButtons, BSTR bstrIcon, long FAR* plRet) PURE;
    STDMETHOD(DepositPidKey)(THIS_ BSTR bstrKey, BOOL fMORW, long FAR* plRet) PURE;
    STDMETHOD(WriteLog)(THIS_ BSTR bstrMessage) PURE;
    STDMETHOD(ResignDpc)(THIS_ BSTR bstrProductCode) PURE;
    STDMETHOD(ResetPID)(THIS) PURE;
    STDMETHOD(SetDialogSize)(THIS_ long dx, long dy) PURE;
    STDMETHOD(VerifyClock)(THIS_ long lMode, long FAR* plRet) PURE;
    STDMETHOD(SortSelectOptions)(THIS_ IDispatch * pdispSelect) PURE;
    STDMETHOD(InternetDisconnect)(THIS) PURE;
    STDMETHOD(GetConnectedState)(THIS_ BOOL FAR* pfConnected) PURE;
    STDMETHOD(get_Context)(THIS_ long FAR* plwctx) PURE;
    STDMETHOD(get_Validator)(THIS_ IDispatch * FAR* ppdispValidator) PURE;
    STDMETHOD(get_LicAgent)(THIS_ IDispatch * FAR* ppdispLicAgent) PURE;
    STDMETHOD(get_CountryInfo)(THIS_ BSTR FAR* pbstrUrl) PURE;
    STDMETHOD(put_WizardVisible)(THIS_ BOOL fVisible) PURE;
    STDMETHOD(put_WizardTitle)(THIS_ BSTR bstrTitle) PURE;
    STDMETHOD(get_AnimationEnabled)(THIS_ BOOL FAR* fEnabled) PURE;
    STDMETHOD(put_CurrentHelpId)(THIS_ long lHelpId) PURE;
    STDMETHOD(get_OfficeOnTheWebUrl)(THIS_ BSTR FAR* bstrUrl) PURE;
};

DEFINE_GUID(IID_ILicValidator,0x919AA22CL,0xB9AD,0x11D3,0x8D,0x59,0x00,0x50,0x04,0x83,0x84,0xE3);

/* Definition of interface: ILicValidator */
#undef INTERFACE
#define INTERFACE ILicValidator

DECLARE_INTERFACE_(ILicValidator, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* ILicValidator methods */
    STDMETHOD(get_Products)(THIS_ VARIANT FAR* pVariant) PURE;
    STDMETHOD(get_Selection)(THIS_ int FAR* piSel) PURE;
    STDMETHOD(put_Selection)(THIS_ int iSel) PURE;
};

DEFINE_GUID(IID_ILicAgent,0x00194002L,0xD9C3,0x11D3,0x8D,0x59,0x00,0x50,0x04,0x83,0x84,0xE3);

/* Definition of interface: ILicAgent */
#undef INTERFACE
#define INTERFACE ILicAgent

DECLARE_INTERFACE_(ILicAgent, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* ILicAgent methods */
    STDMETHOD(Initialize)(THIS_ DWORD dwBPC, DWORD dwMode, BSTR bstrLicSource, DWORD FAR* pdwRetCode) PURE;
    STDMETHOD(GetFirstName)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetFirstName)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetLastName)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetLastName)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetOrgName)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetOrgName)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetEmail)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetEmail)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetPhone)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetPhone)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetAddress1)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetAddress1)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetCity)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetCity)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetState)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetState)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetCountryCode)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetCountryCode)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetCountryDesc)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetCountryDesc)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetZip)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetZip)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetIsoLanguage)(THIS_ DWORD FAR* pdwVal) PURE;
    STDMETHOD(SetIsoLanguage)(THIS_ DWORD dwNewVal) PURE;
    STDMETHOD(GetMSUpdate)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetMSUpdate)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetMSOffer)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetMSOffer)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetOtherOffer)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetOtherOffer)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetAddress2)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetAddress2)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(CheckSystemClock)(THIS_ DWORD FAR* pdwRetCode) PURE;
    STDMETHOD(GetExistingExpiryDate)(THIS_ DATE FAR* pDateVal) PURE;
    STDMETHOD(GetNewExpiryDate)(THIS_ DATE FAR* pDateVal) PURE;
    STDMETHOD(GetBillingFirstName)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingFirstName)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingLastName)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingLastName)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingPhone)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingPhone)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingAddress1)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingAddress1)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingAddress2)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingAddress2)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingCity)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingCity)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingState)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingState)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingCountryCode)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingCountryCode)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(GetBillingZip)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(SetBillingZip)(THIS_ BSTR bstrNewVal) PURE;
    STDMETHOD(SaveBillingInfo)(THIS_ BOOL bSave, DWORD FAR* pdwRetVal) PURE;
    STDMETHOD(IsCCRenewalCountry)(THIS_ BSTR bstrCountryCode, BOOL FAR* pbRetVal) PURE;
    STDMETHOD(GetVATLabel)(THIS_ BSTR bstrCountryCode, BSTR FAR* pbstrVATLabel) PURE;
    STDMETHOD(GetCCRenewalExpiryDate)(THIS_ DATE FAR* pDateVal) PURE;
    STDMETHOD(SetVATNumber)(THIS_ BSTR bstrVATNumber) PURE;
    STDMETHOD(SetCreditCardType)(THIS_ BSTR bstrCCCode) PURE;
    STDMETHOD(SetCreditCardNumber)(THIS_ BSTR bstrCCNumber) PURE;
    STDMETHOD(SetCreditCardExpiryYear)(THIS_ DWORD dwCCYear) PURE;
    STDMETHOD(SetCreditCardExpiryMonth)(THIS_ DWORD dwCCMonth) PURE;
    STDMETHOD(GetCreditCardCount)(THIS_ DWORD FAR* pdwCount) PURE;
    STDMETHOD(GetCreditCardCode)(THIS_ DWORD dwIndex, BSTR FAR* pbstrCode) PURE;
    STDMETHOD(GetCreditCardName)(THIS_ DWORD dwIndex, BSTR FAR* pbstrName) PURE;
    STDMETHOD(GetVATNumber)(THIS_ BSTR FAR* pbstrVATNumber) PURE;
    STDMETHOD(GetCreditCardType)(THIS_ BSTR FAR* pbstrCCCode) PURE;
    STDMETHOD(GetCreditCardNumber)(THIS_ BSTR FAR* pbstrCCNumber) PURE;
    STDMETHOD(GetCreditCardExpiryYear)(THIS_ DWORD FAR* pdwCCYear) PURE;
    STDMETHOD(GetCreditCardExpiryMonth)(THIS_ DWORD FAR* pdwCCMonth) PURE;
    STDMETHOD(GetDisconnectOption)(THIS_ BOOL FAR* pbRetVal) PURE;
    STDMETHOD(SetDisconnectOption)(THIS_ BOOL bNewVal) PURE;
    STDMETHOD(AsyncProcessHandshakeRequest)(THIS_ BOOL bReviseCustInfo) PURE;
    STDMETHOD(AsyncProcessNewLicenseRequest)(THIS) PURE;
    STDMETHOD(AsyncProcessReissueLicenseRequest)(THIS) PURE;
    STDMETHOD(AsyncProcessRetailRenewalLicenseRequest)(THIS) PURE;
    STDMETHOD(AsyncProcessReviseCustInfoRequest)(THIS) PURE;
    STDMETHOD(AsyncProcessCCRenewalPriceRequest)(THIS) PURE;
    STDMETHOD(AsyncProcessCCRenewalLicenseRequest)(THIS) PURE;
    STDMETHOD(GetAsyncProcessReturnCode)(THIS_ DWORD FAR* pdwRetCode) PURE;
    STDMETHOD(IsUpgradeAvailable)(THIS_ BOOL FAR* pbUpgradeAvailable) PURE;
    STDMETHOD(WantUpgrade)(THIS_ BOOL bWantUpgrade) PURE;
    STDMETHOD(AsyncProcessDroppedLicenseRequest)(THIS) PURE;
    STDMETHOD(GenerateInstallationId)(THIS_ BSTR FAR* pbstrVal) PURE;
    STDMETHOD(DepositConfirmationId)(THIS_ BSTR bstrVal, DWORD FAR* pdwRetCode) PURE;
    STDMETHOD(VerifyCheckDigits)(THIS_ BSTR bstrCIDIID, BOOL FAR* pbValue) PURE;
    STDMETHOD(GetCurrentExpiryDate)(THIS_ DATE FAR* pDateVal) PURE;
    STDMETHOD(CancelAsyncProcessRequest)(THIS_ BOOL bIsLicenseRequest) PURE;
    STDMETHOD(GetCurrencyDescription)(THIS_ DWORD dwCurrencyIndex, BSTR FAR* pbstrVal) PURE;
    STDMETHOD(GetPriceItemCount)(THIS_ DWORD FAR* pdwCount) PURE;
    STDMETHOD(GetPriceItemLabel)(THIS_ DWORD dwIndex, BSTR FAR* pbstrVal) PURE;
    STDMETHOD(GetPriceItemValue)(THIS_ DWORD dwCurrencyIndex, DWORD dwIndex, BSTR FAR* pbstrVal) PURE;
    STDMETHOD(GetInvoiceText)(THIS_ BSTR FAR* pNewVal) PURE;
    STDMETHOD(GetBackendErrorMsg)(THIS_ BSTR FAR* pbstrErrMsg) PURE;
    STDMETHOD(GetCurrencyOption)(THIS_ DWORD FAR* dwCurrencyOption) PURE;
    STDMETHOD(SetCurrencyOption)(THIS_ DWORD dwCurrencyOption) PURE;
    STDMETHOD(GetEndOfLifeHtmlText)(THIS_ BSTR FAR* pbstrHtmlText) PURE;
    STDMETHOD(DisplaySSLCert)(THIS_ DWORD FAR* dwRetCode) PURE;
};

DEFINE_GUID(IID_IMsoEServicesDialog,0x000C0372L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: IMsoEServicesDialog */
#undef INTERFACE
#define INTERFACE IMsoEServicesDialog

DECLARE_INTERFACE_(IMsoEServicesDialog, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* IMsoEServicesDialog methods */
    STDMETHOD(Close)(THIS_ VARIANT_BOOL ApplyWebComponentChanges) PURE;
    STDMETHOD(AddTrustedDomain)(THIS_ BSTR Domain) PURE;
    STDMETHOD(get_ApplicationName)(THIS_ BSTR FAR* RetVal) PURE;
    STDMETHOD(get_Application)(THIS_ IDispatch * FAR* ppdisp) PURE;
    STDMETHOD(get_WebComponent)(THIS_ IDispatch * FAR* ppdisp) PURE;
    STDMETHOD(get_ClipArt)(THIS_ IDispatch * FAR* ppdisp) PURE;
};

DEFINE_GUID(IID_WebComponentProperties,0x000C0373L,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

/* Definition of interface: WebComponentProperties */
#undef INTERFACE
#define INTERFACE WebComponentProperties

DECLARE_INTERFACE_(WebComponentProperties, IDispatch)
{
BEGIN_INTERFACE
#ifndef NO_BASEINTERFACE_FUNCS

    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR* ppvObj) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    /* IDispatch methods */
    STDMETHOD(GetTypeInfoCount)(THIS_ UINT FAR* pctinfo) PURE;

    STDMETHOD(GetTypeInfo)(
      THIS_
      UINT itinfo,
      LCID lcid,
      ITypeInfo FAR* FAR* pptinfo) PURE;

    STDMETHOD(GetIDsOfNames)(
      THIS_
      REFIID riid,
      OLECHAR FAR* FAR* rgszNames,
      UINT cNames,
      LCID lcid,
      DISPID FAR* rgdispid) PURE;

    STDMETHOD(Invoke)(
      THIS_
      DISPID dispidMember,
      REFIID riid,
      LCID lcid,
      WORD wFlags,
      DISPPARAMS FAR* pdispparams,
      VARIANT FAR* pvarResult,
      EXCEPINFO FAR* pexcepinfo,
      UINT FAR* puArgErr) PURE;
#endif

    /* WebComponentProperties methods */
    STDMETHOD(get_Shape)(THIS_ IDispatch * FAR* RetValue) PURE;
    STDMETHOD(get_Name)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_Name)(THIS_ BSTR Name) PURE;
    STDMETHOD(get_URL)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_URL)(THIS_ BSTR URL) PURE;
    STDMETHOD(get_HTML)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_HTML)(THIS_ BSTR HTML) PURE;
    STDMETHOD(get_PreviewGraphic)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_PreviewGraphic)(THIS_ BSTR PreviewGraphic) PURE;
    STDMETHOD(get_PreviewHTML)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_PreviewHTML)(THIS_ BSTR PreviewHTML) PURE;
    STDMETHOD(get_Width)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(put_Width)(THIS_ long Width) PURE;
    STDMETHOD(get_Height)(THIS_ long FAR* RetValue) PURE;
    STDMETHOD(put_Height)(THIS_ long Height) PURE;
    STDMETHOD(get_Tag)(THIS_ BSTR FAR* RetValue) PURE;
    STDMETHOD(put_Tag)(THIS_ BSTR Tag) PURE;
};

#undef IAccessible

#endif
