/***************************************************************************

Copyright (c) Microsoft Corporation. All rights reserved.
This code is licensed under the Visual Studio SDK license terms.
THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.

This code is a part of the Visual Studio Library.

***************************************************************************/

#ifndef VSLCOMPARISON_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
#define VSLCOMPARISON_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5

#if _MSC_VER > 1000
#pragma once
#endif

#include <VSL.h>

namespace VSL
{

#define _VSL_BINARY_COMPARE(type) \
inline bool operator==(const type& rLeft, const type& rRight) \
{ \
	return (0 == ::memcmp(&rLeft, &rRight, sizeof(type))); \
} \

// Common System Types

#ifndef VSL_VARIANT_EQUIVALENCE_DISP_E_BADVARTYPE_RETURN 
#define VSL_VARIANT_EQUIVALENCE_DISP_E_BADVARTYPE_RETURN false
#endif

inline bool operator==(const VARIANT& rLeft, const VARIANT& rRight)
{
	HRESULT hr = ::VarCmp(const_cast<VARIANT*>(&rLeft), const_cast<VARIANT*>(&rRight), LOCALE_USER_DEFAULT, 0);
	if(DISP_E_BADVARTYPE == hr)
	{
		if(rLeft.vt == rRight.vt)
		{
			if(rLeft.vt == VT_UNKNOWN)
			{
				CComPtr<IUnknown> pIUnknown = rLeft.punkVal;
				return pIUnknown.IsEqualObject(rRight.punkVal);
			}
			// REVIEW - what other cases are needed?
		}
		return VSL_VARIANT_EQUIVALENCE_DISP_E_BADVARTYPE_RETURN;
	}
	return (VARCMP_EQ == static_cast<int>(hr));
}

_VSL_BINARY_COMPARE(ULARGE_INTEGER)
_VSL_BINARY_COMPARE(LARGE_INTEGER)
_VSL_BINARY_COMPARE(CY)
_VSL_BINARY_COMPARE(POINTS)
_VSL_BINARY_COMPARE(POINT)
_VSL_BINARY_COMPARE(POINTL)
_VSL_BINARY_COMPARE(SIZE)
_VSL_BINARY_COMPARE(SYSTEMTIME)
_VSL_BINARY_COMPARE(OLECMDTEXT)
_VSL_BINARY_COMPARE(RECT)
_VSL_BINARY_COMPARE(DISPPARAMS)
_VSL_BINARY_COMPARE(LOGFONTW)
_VSL_BINARY_COMPARE(CUSTDATA)
_VSL_BINARY_COMPARE(EXCEPINFO)
_VSL_BINARY_COMPARE(BINDPTR)
_VSL_BINARY_COMPARE(STATSTG)
_VSL_BINARY_COMPARE(CAUUID)
_VSL_BINARY_COMPARE(FILETIME)
_VSL_BINARY_COMPARE(RPCOLEMESSAGE)
_VSL_BINARY_COMPARE(QACONTROL)
_VSL_BINARY_COMPARE(PROPPAGEINFO)
_VSL_BINARY_COMPARE(PROPBAG2)
_VSL_BINARY_COMPARE(STGMEDIUM)
_VSL_BINARY_COMPARE(CALPOLESTR)
_VSL_BINARY_COMPARE(CADWORD)
_VSL_BINARY_COMPARE(POINTF)
_VSL_BINARY_COMPARE(CONTROLINFO)
_VSL_BINARY_COMPARE(MULTI_QI)
_VSL_BINARY_COMPARE(TEXTMETRICW)
_VSL_BINARY_COMPARE(FORMATETC)
_VSL_BINARY_COMPARE(LICINFO)
_VSL_BINARY_COMPARE(BIND_OPTS)
_VSL_BINARY_COMPARE(STATDATA)
_VSL_BINARY_COMPARE(TLIBATTR)
_VSL_BINARY_COMPARE(MSG)
_VSL_BINARY_COMPARE(OLECMD)
_VSL_BINARY_COMPARE(OLEVERB)
_VSL_BINARY_COMPARE(CONNECTDATA)
_VSL_BINARY_COMPARE(StorageLayout)
_VSL_BINARY_COMPARE(TYPEATTR)
_VSL_BINARY_COMPARE(FUNCDESC)
_VSL_BINARY_COMPARE(VARDESC)
_VSL_BINARY_COMPARE(QACONTAINER)
_VSL_BINARY_COMPARE(LOGPALETTE)
_VSL_BINARY_COMPARE(TYPEDESC)

#ifdef _IMM_
_VSL_BINARY_COMPARE(CANDIDATEFORM)
#endif // _IMM_

#ifdef __olecm_h__
_VSL_BINARY_COMPARE(OLECRINFO)
_VSL_BINARY_COMPARE(OLECHOSTINFO)
#endif // __olecm_h__

// Common Visaul Studio Types
_VSL_BINARY_COMPARE(VSSAVETREEITEM)
_VSL_BINARY_COMPARE(VSOPENFILENAMEW)
_VSL_BINARY_COMPARE(VSSAVEFILENAMEW)
_VSL_BINARY_COMPARE(VSBROWSEINFOW)
_VSL_BINARY_COMPARE(VSSWATCHMETRICS)
_VSL_BINARY_COMPARE(VsPropertyBrowserState)
_VSL_BINARY_COMPARE(VSPROPSHEETPAGE)
_VSL_BINARY_COMPARE(VSTREEDISPLAYDATA)
_VSL_BINARY_COMPARE(VSOBNAVIGATIONINFO2)
_VSL_BINARY_COMPARE(FontInfo)
_VSL_BINARY_COMPARE(ColorableItemInfo)
_VSL_BINARY_COMPARE(AllColorableItemInfo)
_VSL_BINARY_COMPARE(VSITEMSELECTION)
_VSL_BINARY_COMPARE(TBXITEMINFO)
_VSL_BINARY_COMPARE(VSTASKCOLUMN)
_VSL_BINARY_COMPARE(VSCOMPONENTSELECTORDATA)
_VSL_BINARY_COMPARE(VSOBNAVIGATIONINFO3)
_VSL_BINARY_COMPARE(TextSpan)
_VSL_BINARY_COMPARE(VSOBSEARCHCRITERIA2)
_VSL_BINARY_COMPARE(OLEMENUID)
_VSL_BINARY_COMPARE(VSOBJCLIPFORMAT)
_VSL_BINARY_COMPARE(VSTREELISTITEMCHANGE)
_VSL_BINARY_COMPARE(VSDEFAULTPREVIEWER)
_VSL_BINARY_COMPARE(TSHELL_CMD)
_VSL_BINARY_COMPARE(NewSyntheticRegion)
_VSL_BINARY_COMPARE(VSBROWSECONTAINER)
_VSL_BINARY_COMPARE(SYMBOL_DESCRIPTION_NODE)
_VSL_BINARY_COMPARE(VsDebugTargetInfo2)
_VSL_BINARY_COMPARE(NewOutlineRegion)
_VSL_BINARY_COMPARE(NewHiddenRegion)
_VSL_BINARY_COMPARE(VsDebugTargetInfo)
_VSL_BINARY_COMPARE(VSCOMPONENTSELECTORTABINIT)
_VSL_BINARY_COMPARE(COMREFERENCE)
_VSL_BINARY_COMPARE(VSNSEBROWSEINFOW)
_VSL_BINARY_COMPARE(VSDRAWITEMSTRUCT)
_VSL_BINARY_COMPARE(VSSWATCHRENDER)
_VSL_BINARY_COMPARE(VSOBNAVNAMEINFONODE2)
_VSL_BINARY_COMPARE(VSOBSEARCHCRITERIA)
_VSL_BINARY_COMPARE(VSOBNAVNAMEINFONODE)
_VSL_BINARY_COMPARE(VSOBJECTINFO)
_VSL_BINARY_COMPARE(MEINIT)
_VSL_BINARY_COMPARE(VsTextPos)

#ifdef __customfind_h__
_VSL_BINARY_COMPARE(VSBROWSESCOPEW)
#endif

#ifdef __dte_h__
_VSL_BINARY_COMPARE(VxDTE::Project)
#endif // __dte_h__

#ifdef __encbuild_h__
_VSL_BINARY_COMPARE(ENC_EXCEPTION_SPAN)
_VSL_BINARY_COMPARE(ENC_ACTIVE_STATEMENT)
#endif // __encbuild_h__

#ifdef __IVsQueryEditQuerySave2_h__
_VSL_BINARY_COMPARE(VSQEQS_FILE_ATTRIBUTE_DATA)
#endif // __IVsQueryEditQuerySave2_h__

#ifdef __msdbg_h__
_VSL_BINARY_COMPARE(BSTR_ARRAY)
_VSL_BINARY_COMPARE(AD_PROCESS_ID)
_VSL_BINARY_COMPARE(TEXT_POSITION)
_VSL_BINARY_COMPARE(BP_CONDITION)
_VSL_BINARY_COMPARE(BP_PASSCOUNT)
_VSL_BINARY_COMPARE(WATCH_COOKIE)
_VSL_BINARY_COMPARE(PROCESS_LAUNCH_INFO)
_VSL_BINARY_COMPARE(RESUME_COOKIE)
_VSL_BINARY_COMPARE(CONST_GUID_ARRAY)
_VSL_BINARY_COMPARE(COMPUTER_INFO)
_VSL_BINARY_COMPARE(THREADPROPERTIES)
_VSL_BINARY_COMPARE(FRAMEINFO)
_VSL_BINARY_COMPARE(DEBUG_PROPERTY_INFO)
_VSL_BINARY_COMPARE(ENUMERATED_PROCESS_ARRAY)
_VSL_BINARY_COMPARE(REMOTE_PROCESS_INFO)
_VSL_BINARY_COMPARE(DEBUG_REFERENCE_INFO)
_VSL_BINARY_COMPARE(PROVIDER_PROCESS_DATA)
_VSL_BINARY_COMPARE(GUID_ARRAY)
_VSL_BINARY_COMPARE(PROCESS_INFO)
_VSL_BINARY_COMPARE(BP_ERROR_RESOLUTION_INFO)
_VSL_BINARY_COMPARE(PENDING_BP_STATE_INFO)
_VSL_BINARY_COMPARE(NATIVE_EXCEPTION_INFO)
_VSL_BINARY_COMPARE(MODULE_SYMBOL_SEARCH_INFO)
_VSL_BINARY_COMPARE(MACHINE_INFO)
_VSL_BINARY_COMPARE(MODULE_INFO)
_VSL_BINARY_COMPARE(CONTEXT_INFO)
_VSL_BINARY_COMPARE(EXCEPTION_INFO)
_VSL_BINARY_COMPARE(BP_RESOLUTION_INFO)
_VSL_BINARY_COMPARE(BP_REQUEST_INFO2)
_VSL_BINARY_COMPARE(BP_REQUEST_INFO)
_VSL_BINARY_COMPARE(CHECKSUM_DATA)
_VSL_BINARY_COMPARE(DEBUG_CUSTOM_VIEWER)
_VSL_BINARY_COMPARE(JMC_CODE_SPEC)
_VSL_BINARY_COMPARE(CODE_PATH)
_VSL_BINARY_COMPARE(DisassemblyData)
#endif // __msdbg_h__

#ifdef __textmgr_h__
_VSL_BINARY_COMPARE(TextAddress)
_VSL_BINARY_COMPARE(TIPSIZEDATA)
_VSL_BINARY_COMPARE(LINEDATAEX)
_VSL_BINARY_COMPARE(SELECTIONSTATE)
_VSL_BINARY_COMPARE(VIEWPREFERENCES)
_VSL_BINARY_COMPARE(FRAMEPREFERENCES)
_VSL_BINARY_COMPARE(LANGPREFERENCES)
_VSL_BINARY_COMPARE(FONTCOLORPREFERENCES)
_VSL_BINARY_COMPARE(MARKERDATA)
_VSL_BINARY_COMPARE(LINEDATA)
_VSL_BINARY_COMPARE(TabStop)
_VSL_BINARY_COMPARE(ChangeInput)
_VSL_BINARY_COMPARE(BUFFERINITEX)
#endif // __textmgr_h__

#ifdef __singlefileeditor_h__
_VSL_BINARY_COMPARE(ExternalError)
_VSL_BINARY_COMPARE(NewSpanMapping)
_VSL_BINARY_COMPARE(TextSpanAndCookie)
#endif // __singlefileeditor_h__

#ifdef __textmgr2_h__
_VSL_BINARY_COMPARE(FRAMEPREFERENCES2)
_VSL_BINARY_COMPARE(LANGPREFERENCES2)
_VSL_BINARY_COMPARE(FONTCOLORPREFERENCES2)
_VSL_BINARY_COMPARE(SMARTTAGSIZEDATA)
_VSL_BINARY_COMPARE(VIEWPREFERENCES2)
_VSL_BINARY_COMPARE(NewHiddenRegionEx)
#endif // __textmgr2_h__

// NOTE - this can not be an operator <, as one parameter must be of class type for that operatore
inline bool IsStringLessThen(_In_ wchar_t* szIsLessThen, _In_ wchar_t* szThis)
{
	return (0 > ::wcscmp(szIsLessThen, szThis));
}

} // namespace VSL

#endif VSLCOMPARISON_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5