/***************************************************************************

Copyright (c) Microsoft Corporation. All rights reserved.
This code is licensed under the Visual Studio SDK license terms.
THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.

This code is a part of the Visual Studio Library.

***************************************************************************/

#ifndef IPERSISTFILEFORMAT_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
#define IPERSISTFILEFORMAT_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5

#if _MSC_VER > 1000
#pragma once
#endif

#include "fpstfmt.h"

#pragma warning(push)
#pragma warning(disable : 4510) // default constructor could not be generated
#pragma warning(disable : 4610) // can never be instantiated - user defined constructor required
#pragma warning(disable : 4512) // assignment operator could not be generated
#pragma warning(disable : 6011) // Dereferencing NULL pointer (a NULL derference is just another kind of failure for a unit test

namespace VSL
{

class IPersistFileFormatNotImpl :
	public IPersistFileFormat
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IPersistFileFormatNotImpl)

public:

	typedef IPersistFileFormat Interface;

	STDMETHOD(IsDirty)(
		/*[out]*/ BOOL* /*pfIsDirty*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(InitNew)(
		/*[in]*/ DWORD /*nFormatIndex*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(Load)(
		/*[in]*/ LPCOLESTR /*pszFilename*/,
		/*[in]*/ DWORD /*grfMode*/,
		/*[in]*/ BOOL /*fReadOnly*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(Save)(
		/*[in]*/ LPCOLESTR /*pszFilename*/,
		/*[in]*/ BOOL /*fRemember*/,
		/*[in]*/ DWORD /*nFormatIndex*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(SaveCompleted)(
		/*[in]*/ LPCOLESTR /*pszFilename*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(GetCurFile)(
		/*[out]*/ LPOLESTR* /*ppszFilename*/,
		/*[out]*/ DWORD* /*pnFormatIndex*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(GetFormatList)(
		/*[out]*/ LPOLESTR* /*ppszFormatList*/)VSL_STDMETHOD_NOTIMPL

	STDMETHOD(GetClassID)(
		/*[out]*/ CLSID* /*pClassID*/)VSL_STDMETHOD_NOTIMPL
};

class IPersistFileFormatMockImpl :
	public IPersistFileFormat,
	public MockBase
{

VSL_DECLARE_NONINSTANTIABLE_BASE_CLASS(IPersistFileFormatMockImpl)

public:

VSL_DEFINE_MOCK_CLASS_TYPDEFS(IPersistFileFormatMockImpl)

	typedef IPersistFileFormat Interface;
	struct IsDirtyValidValues
	{
		/*[out]*/ BOOL* pfIsDirty;
		HRESULT retValue;
	};

	STDMETHOD(IsDirty)(
		/*[out]*/ BOOL* pfIsDirty)
	{
		VSL_DEFINE_MOCK_METHOD(IsDirty)

		VSL_SET_VALIDVALUE(pfIsDirty);

		VSL_RETURN_VALIDVALUES();
	}
	struct InitNewValidValues
	{
		/*[in]*/ DWORD nFormatIndex;
		HRESULT retValue;
	};

	STDMETHOD(InitNew)(
		/*[in]*/ DWORD nFormatIndex)
	{
		VSL_DEFINE_MOCK_METHOD(InitNew)

		VSL_CHECK_VALIDVALUE(nFormatIndex);

		VSL_RETURN_VALIDVALUES();
	}
	struct LoadValidValues
	{
		/*[in]*/ LPCOLESTR pszFilename;
		/*[in]*/ DWORD grfMode;
		/*[in]*/ BOOL fReadOnly;
		HRESULT retValue;
	};

	STDMETHOD(Load)(
		/*[in]*/ LPCOLESTR pszFilename,
		/*[in]*/ DWORD grfMode,
		/*[in]*/ BOOL fReadOnly)
	{
		VSL_DEFINE_MOCK_METHOD(Load)

		VSL_CHECK_VALIDVALUE_STRINGW(pszFilename);

		VSL_CHECK_VALIDVALUE(grfMode);

		VSL_CHECK_VALIDVALUE(fReadOnly);

		VSL_RETURN_VALIDVALUES();
	}
	struct SaveValidValues
	{
		/*[in]*/ LPCOLESTR pszFilename;
		/*[in]*/ BOOL fRemember;
		/*[in]*/ DWORD nFormatIndex;
		HRESULT retValue;
	};

	STDMETHOD(Save)(
		/*[in]*/ LPCOLESTR pszFilename,
		/*[in]*/ BOOL fRemember,
		/*[in]*/ DWORD nFormatIndex)
	{
		VSL_DEFINE_MOCK_METHOD(Save)

		VSL_CHECK_VALIDVALUE_STRINGW(pszFilename);

		VSL_CHECK_VALIDVALUE(fRemember);

		VSL_CHECK_VALIDVALUE(nFormatIndex);

		VSL_RETURN_VALIDVALUES();
	}
	struct SaveCompletedValidValues
	{
		/*[in]*/ LPCOLESTR pszFilename;
		HRESULT retValue;
	};

	STDMETHOD(SaveCompleted)(
		/*[in]*/ LPCOLESTR pszFilename)
	{
		VSL_DEFINE_MOCK_METHOD(SaveCompleted)

		VSL_CHECK_VALIDVALUE_STRINGW(pszFilename);

		VSL_RETURN_VALIDVALUES();
	}
	struct GetCurFileValidValues
	{
		/*[out]*/ LPOLESTR* ppszFilename;
		/*[out]*/ DWORD* pnFormatIndex;
		HRESULT retValue;
	};

	STDMETHOD(GetCurFile)(
		/*[out]*/ LPOLESTR* ppszFilename,
		/*[out]*/ DWORD* pnFormatIndex)
	{
		VSL_DEFINE_MOCK_METHOD(GetCurFile)

		VSL_SET_VALIDVALUE(ppszFilename);

		VSL_SET_VALIDVALUE(pnFormatIndex);

		VSL_RETURN_VALIDVALUES();
	}
	struct GetFormatListValidValues
	{
		/*[out]*/ LPOLESTR* ppszFormatList;
		HRESULT retValue;
	};

	STDMETHOD(GetFormatList)(
		/*[out]*/ LPOLESTR* ppszFormatList)
	{
		VSL_DEFINE_MOCK_METHOD(GetFormatList)

		VSL_SET_VALIDVALUE(ppszFormatList);

		VSL_RETURN_VALIDVALUES();
	}
	struct GetClassIDValidValues
	{
		/*[out]*/ CLSID* pClassID;
		HRESULT retValue;
	};

	STDMETHOD(GetClassID)(
		/*[out]*/ CLSID* pClassID)
	{
		VSL_DEFINE_MOCK_METHOD(GetClassID)

		VSL_SET_VALIDVALUE(pClassID);

		VSL_RETURN_VALIDVALUES();
	}
};


} // namespace VSL

#pragma warning(pop)

#endif // IPERSISTFILEFORMAT_H_10C49CA1_2F46_11D3_A504_00C04F5E0BA5
