/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.LaunchHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddConfigurationAction
extends Action {
    public static final String ADDCONFIG_ACTIONID = "actionid.addconfig";
    public static final String TEMPORARY_CONFIG_FLAG = "_TEMPORARY_CONFIG_";
    private final IViewPart part;

    public AddConfigurationAction(IViewPart part) {
        this.part = part;
        this.setText(HibernateConsoleMessages.AddConfigurationAction_add_config);
        this.setImageDescriptor(EclipseImages.getImageDescriptor("ADD"));
        this.setId(ADDCONFIG_ACTIONID);
    }

    public void run() {
        this.doAddConfiguration();
    }

    protected void doAddConfiguration() {
        try {
            ILaunchConfiguration wc = AddConfigurationAction.createTemporaryLaunchConfiguration();
            int res = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.part.getSite().getShell(), (ILaunchConfiguration)wc, (String)"org.eclipse.debug.ui.launchGroup.run");
            if (res != 0) {
                AddConfigurationAction.deleteTemporaryLaunchConfigurations();
            } else {
                AddConfigurationAction.makeTemporaryLaunchConfigurationsPermanent();
            }
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(this.part.getSite().getShell(), HibernateConsoleMessages.AddConfigurationAction_problem_add_console_config, ce);
        }
    }

    public static ILaunchConfiguration createTemporaryLaunchConfiguration() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = LaunchHelper.getHibernateLaunchConfigsType();
        String launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(HibernateConsoleMessages.AddConfigurationAction_hibernate);
        ILaunchConfigurationWorkingCopy wc = launchConfigurationType.newInstance(null, launchName);
        wc.setAttribute(TEMPORARY_CONFIG_FLAG, true);
        return wc.doSave();
    }

    public static void makeTemporaryLaunchConfigurationsPermanent() throws CoreException {
        List<ILaunchConfiguration> listTempConfigs = AddConfigurationAction.getTemporaryLaunchConfigurations();
        int i = 0;
        while (i < listTempConfigs.size()) {
            ILaunchConfigurationWorkingCopy wc = listTempConfigs.get(i).getWorkingCopy();
            wc.setAttribute(TEMPORARY_CONFIG_FLAG, null);
            wc.doSave();
            ++i;
        }
    }

    public static void deleteTemporaryLaunchConfigurations() throws CoreException {
        List<ILaunchConfiguration> listTempConfigs = AddConfigurationAction.getTemporaryLaunchConfigurations();
        int i = 0;
        while (i < listTempConfigs.size()) {
            listTempConfigs.get(i).delete();
            ++i;
        }
    }

    private static List<ILaunchConfiguration> getTemporaryLaunchConfigurations() throws CoreException {
        ArrayList<ILaunchConfiguration> listTempConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] configs = LaunchHelper.findHibernateLaunchConfigs();
        int i = 0;
        while (i < configs.length) {
            boolean temporary = configs[i].getAttribute(TEMPORARY_CONFIG_FLAG, false);
            if (temporary) {
                listTempConfigs.add(configs[i]);
            }
            ++i;
        }
        return listTempConfigs;
    }
}

