/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class DeleteConfigurationAction
extends SelectionListenerAction {
    public static final String DELETECONFIG_ACTIONID = "actionid.deleteconfig";
    private StructuredViewer part;

    public DeleteConfigurationAction(StructuredViewer selectionProvider) {
        super(HibernateConsoleMessages.DeleteConfigurationAction_delete_config);
        this.setEnabled(false);
        this.part = selectionProvider;
        this.setId(DELETECONFIG_ACTIONID);
    }

    public void run() {
        List selectedNonResources = this.getSelectedNonResources();
        String question = HibernateConsoleMessages.DeleteConfigurationAction_do_you_wish_del_selected_config;
        String title = HibernateConsoleMessages.DeleteConfigurationAction_delete_console_config;
        if (selectedNonResources.size() > 1) {
            question = String.valueOf(question) + HibernateConsoleMessages.DeleteConfigurationAction_str_1;
            title = String.valueOf(title) + HibernateConsoleMessages.DeleteConfigurationAction_str_2;
        }
        if (MessageDialog.openConfirm(null, (String)title, (String)(question = String.valueOf(question) + HibernateConsoleMessages.DeleteConfigurationAction_str_3))) {
            for (ConsoleConfiguration element : selectedNonResources) {
                KnownConfigurations.getInstance().removeConfiguration(element, false);
            }
            this.part.refresh();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object element : this.getSelectedNonResources()) {
                if (!(element instanceof ConsoleConfiguration)) continue;
                return true;
            }
        }
        return false;
    }
}

