/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.viewers.TreePath;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.node.BaseNode;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.OpenQueryEditorAction;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class HQLScratchpadAction
extends OpenQueryEditorAction {
    public static final String HQLSCRATCHPAD_ACTIONID = "actionid.hqlscratchpad";

    public HQLScratchpadAction() {
        super(HibernateConsoleMessages.HQLScratchpadAction_hql_editor);
        this.setImageDescriptor(EclipseImages.getImageDescriptor("HQL_EDITOR"));
        this.setToolTipText(HibernateConsoleMessages.HQLScratchpadAction_open_hql_editor);
        this.setEnabled(true);
        this.setId(HQLSCRATCHPAD_ACTIONID);
    }

    protected void openQueryEditor(ConsoleConfiguration config, String query) {
        HibernateConsolePlugin.getDefault().openScratchHQLEditor(config == null ? null : config.getName(), query);
    }

    protected String generateQuery(TreePath path) {
        BaseNode baseNode;
        ConsoleConfiguration consoleConfiguration;
        Object node = path.getLastSegment();
        if (node instanceof PersistentClass) {
            String name = ((PersistentClass)node).getEntityName();
            return "from " + name;
        }
        if (node instanceof Property) {
            String prName = ((Property)node).getName();
            PersistentClass pClass = ((Property)node).getPersistentClass();
            String enName = "";
            if (pClass != null) {
                enName = pClass.getEntityName();
                enName = enName.substring(enName.lastIndexOf(46) + 1);
            } else {
                int i = path.getSegmentCount() - 2;
                while (i > 0) {
                    if (path.getSegment(i) instanceof PersistentClass) {
                        enName = ((PersistentClass)path.getSegment(i)).getEntityName();
                        enName = enName.substring(enName.lastIndexOf(46) + 1);
                    } else if (path.getSegment(i) instanceof Property) {
                        prName = String.valueOf(((Property)path.getSegment(i)).getName()) + "." + prName;
                    }
                    --i;
                }
            }
            return "select o." + prName + " from " + enName + " o";
        }
        if (node instanceof BaseNode && (consoleConfiguration = (baseNode = (BaseNode)node).getConsoleConfiguration()).isSessionFactoryCreated()) {
            return baseNode.getHQL();
        }
        return "";
    }
}

