/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverClassHelpers {
    private Map<String, String> dialectNames = new HashMap<String, String>();
    private Map<String, Set<String>> connectionUrls = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> driverClasses = new HashMap<String, Set<String>>();
    private Map<String, String> driverToDialect = new HashMap<String, String>();

    public DriverClassHelpers() {
        this.dialectNames.put("DB2", "org.hibernate.dialect.DB2Dialect");
        this.dialectNames.put("DB2/390", "org.hibernate.dialect.DB2390Dialect");
        this.dialectNames.put("DB2/400", "org.hibernate.dialect.DB2400Dialect");
        this.dialectNames.put("Derby", "org.hibernate.dialect.DerbyDialect");
        this.dialectNames.put("FrontBase", "org.hibernate.dialect.FrontBaseDialect");
        this.dialectNames.put("HSQL", "org.hibernate.dialect.HSQLDialect");
        this.dialectNames.put("H2", "org.hibernate.dialect.H2Dialect");
        this.dialectNames.put("Informix", "org.hibernate.dialect.InformixDialect");
        this.dialectNames.put("Ingres", "org.hibernate.dialect.IngresDialect");
        this.dialectNames.put("Interbase", "org.hibernate.dialect.InterbaseDialect");
        this.dialectNames.put("Firebird", "org.hibernate.dialect.FirebirdDialect");
        this.dialectNames.put("Mckoi SQL", "org.hibernate.dialect.MckoiDialect");
        this.dialectNames.put("MySQL", "org.hibernate.dialect.MySQLDialect");
        this.dialectNames.put("MySQL (InnoDB)", "org.hibernate.dialect.MySQLInnoDBDialect");
        this.dialectNames.put("MySQL (MyISAM)", "org.hibernate.dialect.MySQLMyISAMDialect");
        this.dialectNames.put("MySQL 5", "org.hibernate.dialect.MySQL5Dialect");
        this.dialectNames.put("MySQL 5 (InnoDB)", "org.hibernate.dialect.MySQL5InnoDBDialect");
        this.dialectNames.put("Oracle 8i", "org.hibernate.dialect.Oracle8iDialect");
        this.dialectNames.put("Oracle 9i", "org.hibernate.dialect.Oracle9iDialect");
        this.dialectNames.put("Oracle 10g", "org.hibernate.dialect.Oracle10gDialect");
        this.dialectNames.put("Pointbase", "org.hibernate.dialect.PointbaseDialect");
        this.dialectNames.put("PostgreSQL", "org.hibernate.dialect.PostgreSQLDialect");
        this.dialectNames.put("Progress", "org.hibernate.dialect.ProgressDialect");
        this.dialectNames.put("SAP DB", "org.hibernate.dialect.SAPDBDialect");
        this.dialectNames.put("Sybase", "org.hibernate.dialect.SybaseDialect");
        this.dialectNames.put("Sybase 11", "org.hibernate.dialect.Sybase11Dialect");
        this.dialectNames.put("Sybase Anywhere", "org.hibernate.dialect.SybaseAnywhereDialect");
        this.dialectNames.put("SQL Server", "org.hibernate.dialect.SQLServerDialect");
        this.dialectNames.put("Teiid", "org.teiid.dialect.TeiidDialect");
        this.addDriverAndURLS("org.hibernate.dialect.HSQLDialect", "org.hsqldb.jdbcDriver", new String[]{"jdbc:hsqldb:hsql://<host>", "jdbc:hsqldb:<dbname>", "jdbc:hsqldb:."});
        this.addDriverAndURLS("org.hibernate.dialect.H2Dialect", "org.h2.Driver", new String[]{"jdbc:h2:<filename>", "jdbc:h2:mem:", "jdbc:h2:mem:<databaseName>", "jdbc:h2:tcp://<server>[:<port>]/<databaseName>"});
        this.addDriverAndURLS("org.hibernate.dialect.OracleDialect", "oracle.jdbc.driver.OracleDriver", new String[]{"jdbc:oracle:thin:@localhost:1521:orcl", "jdbc:oracle:thin:@<host>:<port1521>:<sid>"});
        this.addDriverAndURLS("org.hibernate.dialect.Oracle9Dialect", "oracle.jdbc.driver.OracleDriver", new String[]{"jdbc:oracle:thin:@localhost:1521:orcl", "jdbc:oracle:thin:@<host>:<port1521>:<sid>"});
        this.addDriverAndURLS("org.hibernate.dialect.Oracle10gDialect", "oracle.jdbc.driver.OracleDriver", new String[]{"jdbc:oracle:thin:@localhost:1521:orcl", "jdbc:oracle:thin:@<host>:<port1521>:<sid>"});
        this.addDriverAndURLS("org.hibernate.dialect.Oracle8iDialect", "oracle.jdbc.driver.OracleDriver", new String[]{"jdbc:oracle:thin:@localhost:1521:orcl", "jdbc:oracle:thin:@<host>:<port1521>:<sid>"});
        this.addDriverAndURLS("org.hibernate.dialect.MySQLDialect", "org.gjt.mm.mysql.Driver", new String[]{"jdbc:mysql://<hostname>/<database>", "jdbc:mysql:///test", "jdbc:mysql:///<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.MySQLDialect", "com.mysql.jdbc.Driver", new String[]{"jdbc:mysql://<hostname>/<database>", "jdbc:mysql:///test", "jdbc:mysql:///<name>", "jdbc:mysql://<host><:port>/<database>"});
        this.addDriverAndURLS("org.hibernate.dialect.MySQLInnoDBDialect", "org.gjt.mm.mysql.Driver", new String[]{"jdbc:mysql://<hostname>/<database>", "jdbc:mysql:///test", "jdbc:mysql:///<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.MySQLMyISAMDialect", "org.gjt.mm.mysql.Driver", new String[]{"jdbc:mysql://<hostname>/<database>", "jdbc:mysql:///test", "jdbc:mysql:///<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.MySQL5Dialect", "org.gjt.mm.mysql.Driver", new String[]{"jdbc:mysql://<hostname>/<database>", "jdbc:mysql:///test", "jdbc:mysql:///<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.MySQL5InnoDBDialect", "org.gjt.mm.mysql.Driver", new String[]{"jdbc:mysql://<hostname>/<database>", "jdbc:mysql:///test", "jdbc:mysql:///<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.PostgreSQLDialect", "org.postgresql.Driver", new String[]{"jdbc:postgresql:template1", "jdbc:postgresql:<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.ProgressDialect", "com.progress.sql.jdbc.JdbcProgressDriver", new String[]{"jdbc:JdbcProgress:T:host:port:dbname;WorkArounds=536870912"});
        this.addDriverAndURLS("org.hibernate.dialect.DB2Dialect", "COM.ibm.db2.jdbc.app.DB2Driver", new String[]{"jdbc:db2:test", "jdbc:db2:<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.DB2400Dialect", "com.ibm.as400.access.AS400JDBCDriver", new String[]{"jdbc:as400://<systemname>", "jdbc:db2:<name>"});
        this.addDriverAndURLS("org.hibernate.dialect.DerbyDialect", "org.apache.derby.jdbc.EmbeddedDriver", new String[]{"jdbc:derby:/test;create=true"});
        this.addDriverAndURLS("org.hibernate.dialect.SybaseDialect", "com.sybase.jdbc2.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:co3061835-a:5000/tempdb"});
        this.addDriverAndURLS("org.hibernate.dialect.MckoiDialect", "com.mckoi.JDBCDriver", new String[]{"jdbc:mckoi:///", "jdbc:mckoi:local://C:/mckoi1.00/db.conf"});
        this.addDriverAndURLS("org.hibernate.dialect.SAPDBDialect", "com.sap.dbtech.jdbc.DriverSapDB", new String[]{"jdbc:sapdb://localhost/TST"});
        this.addDriverAndURLS("org.hibernate.dialect.SQLServerDialect", "com.jnetdirect.jsql.JSQLDriver", new String[]{"jdbc:JSQLConnect://1E1/test"});
        this.addDriverAndURLS("org.hibernate.dialect.SQLServerDialect", "com.newatlanta.jturbo.driver.Driver", new String[]{"jdbc:JTurbo://1E1:1433/test"});
        this.addDriverAndURLS("org.hibernate.dialect.SQLServerDialect", "weblogic.jdbc.mssqlserver4.Driver", new String[]{"jdbc:weblogic:mssqlserver4:1E1:1433"});
        this.addDriverAndURLS("org.hibernate.dialect.SQLServerDialect", "com.microsoft.jdbc.sqlserver.SQLServerDriver", new String[]{"jdbc:microsoft:sqlserver://1E1;DatabaseName=test;SelectMethod=cursor"});
        this.addDriverAndURLS("org.hibernate.dialect.SQLServerDialect", "net.sourceforge.jtds.jdbc.Driver", new String[]{"jdbc:jtds:sqlserver://1E1/test"});
        this.addDriverAndURLS("org.hibernate.dialect.InterbaseDialect", "interbase.interclient.Driver", new String[]{"jdbc:interbase://localhost:3060/C:/firebird/test.gdb"});
        this.addDriverAndURLS("org.hibernate.dialect.InterbaseDialect", "org.firebirdsql.jdbc.FBDriver", new String[]{"jdbc:interbase://localhost:3060/C:/firebird/test.gdb"});
        this.addDriverAndURLS("org.hibernate.dialect.PointbaseDialect", "com.pointbase.jdbc.jdbcUniversalDriver", new String[]{"jdbc:pointbase:embedded:sample"});
        this.addDriverAndURLS("org.teiid.dialect.TeiidDialect", "org.teiid.jdbc.TeiidDriver", new String[]{"jdbc:teiid:vdb@mm://<host>:<port>;user=<user>;password=<password>", "jdbc:teiid:vdb@mms://<host>:<port>;user=<user>;password=<password>", "jdbc:teiid:vdb@<path_to>/deploy.properties;user=<user>;password=<password>"});
    }

    private void addDriverAndURLS(String dialect, String driverclass, String[] urls) {
        this.add(this.driverClasses, dialect, driverclass);
        int i = 0;
        while (i < urls.length) {
            String url = urls[i];
            this.add(this.connectionUrls, driverclass, url);
            ++i;
        }
        this.driverToDialect.put(driverclass, dialect);
    }

    private void add(Map<String, Set<String>> map, String key, String value) {
        Set<String> existing = map.get(key);
        if (existing == null) {
            existing = new HashSet<String>();
            map.put(key, existing);
        }
        existing.add(value);
    }

    public String[] getDialectNames() {
        ArrayList<String> list = new ArrayList<String>(this.dialectNames.keySet());
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public String getShortDialectName(String fullName) {
        for (Map.Entry<String, String> entry : this.dialectNames.entrySet()) {
            if (!entry.getValue().equals(fullName)) continue;
            return entry.getKey();
        }
        return fullName;
    }

    public String getDialect(String driverclass) {
        if (driverclass == null) {
            return null;
        }
        return this.driverToDialect.get(driverclass);
    }

    public String getDialectClass(String dialectName) {
        String dialectClass = this.dialectNames.get(dialectName);
        return dialectClass != null ? dialectClass : dialectName;
    }

    public String[] getDriverClasses(String dialectName) {
        Set<String> result = this.driverClasses.get(dialectName);
        if (result != null) {
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    public String[] getConnectionURLS(String driverclass) {
        Set<String> result = this.connectionUrls.get(driverclass);
        if (result != null) {
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }
}

