/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.criteriaeditor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.AbstractQueryEditor;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditorDocumentSetupParticipant;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditorInput;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditorStorage;
import org.hibernate.eclipse.criteriaeditor.JavaViewerConfiguration;
import org.hibernate.mapping.PersistentClass;

public class CriteriaEditor
extends AbstractQueryEditor {
    private CriteriaEditorDocumentSetupParticipant docSetupParticipant;
    protected QueryPage queryPage = null;

    public CriteriaEditor() {
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{PreferenceConstants.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JavaViewerConfiguration(HibernateConsolePlugin.getDefault().getJavaTextTools(), (IPreferenceStore)store, this));
        this.setPreferenceStore((IPreferenceStore)store);
        this.setEditorContextMenuId("#CriteraEditorContext");
        this.setRulerContextMenuId("#CriteraRulerContext");
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(this.getResourceBundle(), "HQLEditor_ContentAssistProposal_", (ITextEditor)this, 13);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("org.hibernate.eclipse.console.HibernateConsoleMessages");
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IDocument doc;
        super.doSetInput(input);
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (docProvider != null && (doc = docProvider.getDocument((Object)input)) != null) {
            CriteriaEditorDocumentSetupParticipant docSetupParticipant = this.getDocumentSetupParticipant();
            docSetupParticipant.setup(doc);
        }
    }

    private CriteriaEditorDocumentSetupParticipant getDocumentSetupParticipant() {
        if (this.docSetupParticipant == null) {
            this.docSetupParticipant = new CriteriaEditorDocumentSetupParticipant();
        }
        return this.docSetupParticipant;
    }

    public void executeQuery(ConsoleConfiguration cfg) {
        IWorkbenchPage activePage = this.getEditorSite().getPage();
        try {
            activePage.showView("org.hibernate.eclipse.console.views.QueryPageTabView");
        }
        catch (PartInitException partInitException) {}
        if (this.queryPage == null || !this.getPinToOneResTab()) {
            this.queryPage = cfg.executeBSHQuery(this.getQueryString(), this.getQueryInputModel().getCopyForQuery());
        } else {
            final ConsoleConfiguration cfg0 = cfg;
            cfg.execute(new ExecutionContext.Command(){

                public Object execute() {
                    KnownConfigurations.getInstance().getQueryPageModel().remove(CriteriaEditor.this.queryPage);
                    org.hibernate.classic.Session session = cfg0.getSessionFactory().openSession();
                    CriteriaEditor.this.queryPage.setModel(CriteriaEditor.this.getQueryInputModel().getCopyForQuery());
                    CriteriaEditor.this.queryPage.setQueryString(CriteriaEditor.this.getQueryString());
                    CriteriaEditor.this.queryPage.setSession((Session)session);
                    KnownConfigurations.getInstance().getQueryPageModel().add(CriteriaEditor.this.queryPage);
                    return null;
                }
            });
        }
    }

    protected IEvaluationContext getEvaluationContext(IJavaProject project) {
        IEvaluationContext evalCtx = null;
        if (project != null) {
            evalCtx = project.newEvaluationContext();
        }
        if (evalCtx != null) {
            evalCtx.setImports(this.getImports());
        }
        return evalCtx;
    }

    private String[] getImports() {
        final ConsoleConfiguration consoleConfiguration = this.getConsoleConfiguration();
        if (consoleConfiguration.getConfiguration() == null) {
            try {
                consoleConfiguration.build();
                consoleConfiguration.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        if (consoleConfiguration.hasConfiguration()) {
                            consoleConfiguration.getConfiguration().buildMappings();
                        }
                        return consoleConfiguration;
                    }
                });
            }
            catch (HibernateException e) {
                String mess = NLS.bind((String)HibernateConsoleMessages.CompletionHelper_error_could_not_build_cc, (Object)consoleConfiguration.getName());
                HibernateConsolePlugin.getDefault().logErrorMessage(mess, e);
            }
        }
        HashSet<String> imports = new HashSet<String>();
        Configuration configuration = consoleConfiguration.getConfiguration();
        if (configuration != null) {
            Iterator classMappings = configuration.getClassMappings();
            while (classMappings.hasNext()) {
                PersistentClass clazz = (PersistentClass)classMappings.next();
                String className = clazz.getClassName();
                if (className == null) continue;
                imports.add(className);
            }
        }
        imports.add("org.hibernate.*");
        imports.add("org.hibernate.criterion.*");
        return imports.toArray(new String[imports.size()]);
    }

    public void codeComplete(String prefix, CompletionProposalCollector collector, int position, IJavaProject project) throws JavaModelException {
        String code = this.getSourceViewer().getDocument().get();
        code = String.valueOf(prefix) + code;
        IEvaluationContext e = this.getEvaluationContext(project);
        if (e != null) {
            e.codeComplete(code, prefix.length() + position, (CompletionRequestor)collector);
        }
    }

    public void showEditorInput(IEditorInput editorInput) {
        if (!(this.getEditorInput() instanceof CriteriaEditorInput)) {
            super.showEditorInput(editorInput);
            return;
        }
        CriteriaEditorInput hei = (CriteriaEditorInput)this.getEditorInput();
        super.showEditorInput(editorInput);
        IStorage storage = ((CriteriaEditorInput)editorInput).getStorage();
        if (storage instanceof CriteriaEditorStorage) {
            CriteriaEditorStorage sqlEditorStorage = (CriteriaEditorStorage)storage;
            IDocument document = this.getDocumentProvider().getDocument((Object)hei);
            if (document.get().compareTo(sqlEditorStorage.getContentsString()) != 0) {
                document.set(sqlEditorStorage.getContentsString());
            }
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createToolbar(parent);
        super.createPartControl(parent);
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    CriteriaEditor.this.updateExecButton();
                }
            });
        }
        Control control = parent.getChildren()[1];
        control.setLayoutData((Object)new GridData(1808));
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        textWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CriteriaEditor.this.getSite().getPage().activate((IWorkbenchPart)CriteriaEditor.this);
            }
        });
        textWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CriteriaEditor.this.getSite().getPage().activate((IWorkbenchPart)CriteriaEditor.this);
            }
        });
        this.initTextAndToolTip(HibernateConsoleMessages.ExecuteQueryAction_run_criteria);
    }

    protected String getConnectedImageFilePath() {
        return "icons/images/criteria_editor_connect.gif";
    }

    protected String getSaveAsFileExtension() {
        return "*.crit";
    }
}

