/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.hibernate.eclipse.console.ExtensionManager;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.impl.ExporterDefinition;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.UpDownListComposite;
import org.hibernate.eclipse.launch.AddPropertyDialog;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.ExporterFactoryPropertySource;
import org.hibernate.eclipse.launch.PathHelper;

public class ExporterSettingsTab
extends AbstractLaunchConfigurationTab {
    public static final String EXPORTERS_PROPERTIES_COLUMN_PROPERTY_WIDTH = "hibernateCodeGenerationConfigurations.exporters.properties.column.property.Width";
    public static final String EXPORTERS_PROPERTIES_COLUMN_VALUE_WIDTH = "hibernateCodeGenerationConfigurations.exporters.properties.column.value.Width";
    private Button enableEJB3annotations;
    private Button enableJDK5;
    private Set<ExporterFactory> selectedExporters;
    private Set<String> deletedExporterIds;
    private Button selectAll;
    private Button deselectAll;
    private PropertySheetPage propertySheet;
    private Button add;
    private Button remove;
    private Button edit;
    private IPropertyDescriptor currentDescriptor;
    private UpDownListComposite exporterUpDown;
    private ObservableFactoryList observableFactoryList;

    public void createControl(Composite parent) {
        this.selectedExporters = new HashSet<ExporterFactory>();
        this.deletedExporterIds = new HashSet<String>();
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridData controlData = new GridData(1808);
        container.setLayoutData((Object)controlData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        this.createGeneralSettings(container);
        this.createExporterTable(container);
        this.createExporterProperties(container);
        sc.setMinSize(container.computeSize(-1, -1));
        this.dialogChanged();
        this.setControl((Control)sc);
    }

    private void createExporterProperties(Composite parent) {
        Composite exportersComposite = this.createComposite(parent, HibernateConsoleMessages.ExporterSettingsTab_properties);
        exportersComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 100;
        exportersComposite.setLayoutData((Object)gd);
        Group gr = new Group(exportersComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gr.setLayout((Layout)gridLayout);
        gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 3;
        gr.setLayoutData((Object)gd);
        Control sheet = this.createPropertySheet((Composite)gr);
        gd = new GridData(4, 4, true, true);
        sheet.setLayoutData((Object)gd);
        this.add = new Button(exportersComposite, 8);
        this.add.setEnabled(false);
        this.add.setText(HibernateConsoleMessages.ExporterSettingsTab_add);
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddPropertyDialog dialog;
                IStructuredSelection ss = (IStructuredSelection)ExporterSettingsTab.this.getExporterTable().getSelection();
                ExporterFactory ef = (ExporterFactory)ss.getFirstElement();
                if (ef != null && (dialog = new AddPropertyDialog(ExporterSettingsTab.this.getShell(), ef, null, false)).open() == 0) {
                    ef.setProperty(dialog.getPropertyName(), dialog.getPropertyValue());
                    ExporterSettingsTab.this.dialogChanged();
                    ExporterSettingsTab.this.refreshPropertySheet();
                }
            }
        });
        this.remove = new Button(exportersComposite, 8);
        this.remove.setText(HibernateConsoleMessages.ExporterSettingsTab_remove);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExporterSettingsTab.this.currentDescriptor != null) {
                    IStructuredSelection ss = (IStructuredSelection)ExporterSettingsTab.this.getExporterTable().getSelection();
                    ExporterFactory ef = (ExporterFactory)ss.getFirstElement();
                    ef.removeProperty((String)ExporterSettingsTab.this.currentDescriptor.getId());
                    ExporterSettingsTab.this.dialogChanged();
                    ExporterSettingsTab.this.refreshPropertySheet();
                }
            }
        });
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.remove.setLayoutData((Object)gd);
        this.edit = new Button(exportersComposite, 8);
        this.edit.setEnabled(false);
        this.edit.setText(HibernateConsoleMessages.ExporterSettingsTab_edit);
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.edit.setLayoutData((Object)gd);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)ExporterSettingsTab.this.getExporterTable().getSelection();
                ExporterFactory ef = (ExporterFactory)ss.getFirstElement();
                if (ef != null) {
                    AddPropertyDialog dialog;
                    String selectedPropertyId = null;
                    if (ExporterSettingsTab.this.currentDescriptor != null) {
                        selectedPropertyId = (String)ExporterSettingsTab.this.currentDescriptor.getId();
                    }
                    if ((dialog = new AddPropertyDialog(ExporterSettingsTab.this.getShell(), ef, selectedPropertyId, true)).open() == 0) {
                        ef.setProperty(dialog.getPropertyName(), dialog.getPropertyValue());
                        ExporterSettingsTab.this.dialogChanged();
                        ExporterSettingsTab.this.refreshPropertySheet();
                    }
                }
            }
        });
    }

    protected void updateCurrentDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.currentDescriptor = propertyDescriptor;
        boolean hasSelection = false;
        if (this.currentDescriptor != null) {
            hasSelection = true;
        }
        if (this.remove != null) {
            this.remove.setEnabled(hasSelection);
        }
        if (this.edit != null) {
            this.edit.setEnabled(hasSelection);
        }
    }

    private Control createPropertySheet(Composite exportersComposite) {
        this.propertySheet = new PropertySheetPage(){

            public void handleEntrySelection(ISelection selection) {
                super.handleEntrySelection(selection);
                IStructuredSelection iss = (IStructuredSelection)selection;
                IPropertyDescriptor propertyDescriptor = null;
                if (!iss.isEmpty()) {
                    MyPropertySheetEntry mse = (MyPropertySheetEntry)((Object)iss.getFirstElement());
                    propertyDescriptor = mse.getMyDescriptor();
                }
                ExporterSettingsTab.this.updateCurrentDescriptor(propertyDescriptor);
            }
        };
        this.propertySheet.createControl(exportersComposite);
        final MyPropertySheetEntry propertySheetEntry = new MyPropertySheetEntry();
        propertySheetEntry.setPropertySourceProvider(new IPropertySourceProvider(){

            public IPropertySource getPropertySource(Object object) {
                if (object instanceof ExporterFactory) {
                    return new ExporterFactoryPropertySource((ExporterFactory)object){

                        public void setPropertyValue(Object id, Object value) {
                            super.setPropertyValue(id, value);
                            ExporterSettingsTab.this.dialogChanged();
                        }
                    };
                }
                return null;
            }
        });
        this.propertySheet.setRootEntry((IPropertySheetEntry)propertySheetEntry);
        this.getExporterTable().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (s.isEmpty()) {
                    if (ExporterSettingsTab.this.add != null) {
                        ExporterSettingsTab.this.add.setEnabled(false);
                    }
                    if (ExporterSettingsTab.this.remove != null) {
                        ExporterSettingsTab.this.remove.setEnabled(false);
                    }
                    if (ExporterSettingsTab.this.edit != null) {
                        ExporterSettingsTab.this.edit.setEnabled(false);
                    }
                    propertySheetEntry.setValues(new Object[0]);
                } else {
                    if (ExporterSettingsTab.this.add != null) {
                        ExporterSettingsTab.this.add.setEnabled(true);
                    }
                    boolean hasSelection = false;
                    if (ExporterSettingsTab.this.currentDescriptor != null) {
                        hasSelection = true;
                    }
                    if (ExporterSettingsTab.this.remove != null) {
                        ExporterSettingsTab.this.remove.setEnabled(hasSelection);
                    }
                    if (ExporterSettingsTab.this.edit != null) {
                        ExporterSettingsTab.this.edit.setEnabled(hasSelection);
                    }
                    ExporterFactory ep = (ExporterFactory)s.getFirstElement();
                    propertySheetEntry.setValues(new Object[]{ep});
                }
            }
        });
        Control control = this.propertySheet.getControl();
        if (control instanceof Tree && !control.isDisposed()) {
            Tree tree = (Tree)control;
            tree.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    IPropertyDescriptor propertyDescriptor = null;
                    if (e.item != null && e.item.getData() != null) {
                        MyPropertySheetEntry mse = (MyPropertySheetEntry)((Object)e.item.getData());
                        propertyDescriptor = mse.getMyDescriptor();
                    }
                    ExporterSettingsTab.this.updateCurrentDescriptor(propertyDescriptor);
                }
            });
        }
        return control;
    }

    private void createExporterTable(Composite parent) {
        this.exporterUpDown = new UpDownListComposite(parent, 0, HibernateConsoleMessages.ExporterSettingsTab_exporters, true, (IBaseLabelProvider)new ExporterLabelProvider(), (IContentProvider)new ExporterContentProvider()){

            protected Object[] handleAdd(int idx) {
                switch (idx) {
                    case 0: {
                        Object[] selectExporters = ExporterSettingsTab.selectExporters(this.getShell(), HibernateConsoleMessages.ExporterSettingsTab_add_exporter, HibernateConsoleMessages.ExporterSettingsTab_select_exporter_you_want_to_add);
                        int i = 0;
                        while (i < selectExporters.length) {
                            ExporterDefinition exporterDefinition = (ExporterDefinition)selectExporters[i];
                            this.addDef(exporterDefinition);
                            ++i;
                        }
                        return new Object[0];
                    }
                    case 1: {
                        ExporterSettingsTab.this.getExporterTable().setAllChecked(true);
                        ExporterSettingsTab.this.selectedExporters.clear();
                        ExporterSettingsTab.this.observableFactoryList.copyUnderlyingList(ExporterSettingsTab.this.selectedExporters);
                        ExporterSettingsTab.this.dialogChanged();
                        break;
                    }
                    case 2: {
                        ExporterSettingsTab.this.getExporterTable().setAllChecked(false);
                        ExporterSettingsTab.this.selectedExporters.clear();
                        ExporterSettingsTab.this.dialogChanged();
                        break;
                    }
                }
                return null;
            }

            private void addDef(ExporterDefinition expDef) {
                int initialCount = this.getTable().getItemCount();
                boolean duplicate = false;
                do {
                    duplicate = false;
                    ++initialCount;
                    for (ExporterFactory def : ExporterSettingsTab.this.observableFactoryList.getList()) {
                        if (!def.getId().equals("" + initialCount)) continue;
                        duplicate = true;
                    }
                } while (duplicate);
                String initialName = "" + initialCount;
                ExporterFactory exporterFactory = new ExporterFactory(expDef, initialName);
                ExporterSettingsTab.this.observableFactoryList.add(exporterFactory);
                ExporterSettingsTab.this.selectedExporters.add(exporterFactory);
                ((CheckboxTableViewer)this.getTableViewer()).setChecked((Object)exporterFactory, true);
            }

            protected void handleRemove() {
                IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
                if (selection != null) {
                    for (Object item : selection) {
                        ExporterSettingsTab.this.observableFactoryList.remove((ExporterFactory)item);
                        ExporterSettingsTab.this.deletedExporterIds.add(((ExporterFactory)item).getId());
                    }
                    this.listChanged();
                }
            }

            protected void moveSelectionDown() {
                Table table = this.getTableViewer().getTable();
                int[] indices = table.getSelectionIndices();
                if (indices.length < 1) {
                    return;
                }
                int[] newSelection = new int[indices.length];
                int max = table.getItemCount() - 1;
                int i = indices.length - 1;
                while (i >= 0) {
                    int index = indices[i];
                    if (index < max) {
                        ExporterFactory data = (ExporterFactory)this.getTableViewer().getElementAt(index);
                        ExporterSettingsTab.this.observableFactoryList.moveTo(index + 1, data);
                        newSelection[i] = index + 1;
                    }
                    --i;
                }
                table.setSelection(newSelection);
                this.listChanged();
            }

            protected void moveSelectionUp() {
                Table table = this.getTableViewer().getTable();
                int[] indices = table.getSelectionIndices();
                int[] newSelection = new int[indices.length];
                int i = 0;
                while (i < indices.length) {
                    int index = indices[i];
                    if (index > 0) {
                        ExporterFactory data = (ExporterFactory)this.getTableViewer().getElementAt(index);
                        ExporterSettingsTab.this.observableFactoryList.moveTo(index - 1, data);
                        newSelection[i] = index - 1;
                    }
                    ++i;
                }
                table.setSelection(newSelection);
                this.listChanged();
            }

            protected String[] getAddButtonLabels() {
                return new String[]{HibernateConsoleMessages.ExporterSettingsTab_add, HibernateConsoleMessages.ExporterSettingsTab_select_all, HibernateConsoleMessages.ExporterSettingsTab_deselect_all};
            }

            protected void listChanged() {
                ExporterSettingsTab.this.dialogChanged();
            }
        };
        this.getExporterTable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExporterFactory factory = (ExporterFactory)event.getElement();
                if (!event.getChecked() && ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.remove(factory);
                } else if (event.getChecked() && !ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.add(factory);
                }
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.exporterUpDown.setLayoutData(gd);
    }

    private void createOldExporterTable(Composite parent) {
        Composite exporterOptions = this.createComposite(parent, HibernateConsoleMessages.ExporterSettingsTab_exporters);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 100;
        exporterOptions.setLayoutData((Object)gd);
        exporterOptions.setLayout((Layout)new GridLayout(2, false));
        Table table = new Table(exporterOptions, 2592);
        this.getExporterTable().setContentProvider((IContentProvider)new ExporterContentProvider());
        this.getExporterTable().setLabelProvider((IBaseLabelProvider)new ExporterLabelProvider());
        this.getExporterTable().setColumnProperties(new String[]{"", HibernateConsoleMessages.ExporterSettingsTab_description});
        this.getExporterTable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExporterFactory factory = (ExporterFactory)event.getElement();
                if (!event.getChecked() && ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.remove(factory);
                } else if (event.getChecked() && !ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.add(factory);
                }
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        gd.horizontalSpan = 1;
        table.setLayoutData((Object)gd);
        this.selectAll = new Button(exporterOptions, 8);
        this.selectAll.setText(HibernateConsoleMessages.ExporterSettingsTab_select_all);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExporterSettingsTab.this.getExporterTable().setAllChecked(true);
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.selectAll.setLayoutData((Object)gd);
        this.deselectAll = new Button(exporterOptions, 8);
        this.deselectAll.setText(HibernateConsoleMessages.ExporterSettingsTab_deselect_all);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExporterSettingsTab.this.getExporterTable().setAllChecked(false);
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.deselectAll.setLayoutData((Object)gd);
    }

    private void createGeneralSettings(Composite parent) {
        SelectionListener fieldlistener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExporterSettingsTab.this.dialogChanged();
            }
        };
        Composite generalSettingsComposite = this.createComposite(parent, HibernateConsoleMessages.ExporterSettingsTab_general_settings);
        generalSettingsComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.enableJDK5 = new Button(generalSettingsComposite, 32);
        this.enableJDK5.setText(HibernateConsoleMessages.ExporterSettingsTab_use_java5_syntax);
        this.enableJDK5.addSelectionListener(fieldlistener);
        this.enableEJB3annotations = new Button(generalSettingsComposite, 32);
        this.enableEJB3annotations.setText(HibernateConsoleMessages.ExporterSettingsTab_generate_ejb3annotations);
        this.enableEJB3annotations.addSelectionListener(fieldlistener);
    }

    private Composite createComposite(Composite parent, String name) {
        new Label(parent, 0).setText(name);
        Composite client = new Composite(parent, 0);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setLayout((Layout)new GridLayout());
        return client;
    }

    private void dialogChanged() {
        boolean configSelected = true;
        if (!configSelected) {
            this.updateStatus(HibernateConsoleMessages.ExporterSettingsTab_console_configuration_must_be_specified);
            return;
        }
        if (this.selectedExporters.size() == 0) {
            this.updateStatus(HibernateConsoleMessages.ExporterSettingsTab_at_least_one_exporter_option_must_be_selected);
            return;
        }
        for (ExporterFactory ef : this.selectedExporters) {
            String str = ef.getProperties().get("outputdir");
            String msg = null;
            if (str != null && (msg = PathHelper.checkDirectory(str, String.valueOf(HibernateConsoleMessages.ExporterSettingsTab_output_directory_for) + " " + ef.getExporterDefinition().getDescription(), true)) != null) {
                this.updateStatus(msg);
                return;
            }
            str = ef.getProperties().get("template_path");
            if (str == null || (msg = PathHelper.checkDirectory(str, String.valueOf(HibernateConsoleMessages.ExporterSettingsTab_template_directory_for) + " " + ef.getExporterDefinition().getDescription(), true)) == null) continue;
            this.updateStatus(msg);
            return;
        }
        this.updateStatus(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkDirectory(IPath path, String name) {
        IProject proj;
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res == null) return NLS.bind((String)HibernateConsoleMessages.ExporterSettingsTab_does_not_exist, (Object)name);
        int resType = res.getType();
        if (resType != 4) {
            if (resType != 2) return NLS.bind((String)HibernateConsoleMessages.ExporterSettingsTab_has_to_be_folder_or_project, (Object)name);
        }
        if ((proj = res.getProject()).isOpen()) return null;
        return NLS.bind((String)HibernateConsoleMessages.ExporterSettingsTab_project_for_is_closed, (Object)name);
    }

    protected String checkFile(IPath path, String name) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 1) {
                return null;
            }
            return NLS.bind((String)HibernateConsoleMessages.ExporterSettingsTab_must_be_file, (Object)name);
        }
        return NLS.bind((String)HibernateConsoleMessages.ExporterSettingsTab_does_not_exist, (Object)name);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.updateLaunchConfigurationDialog();
    }

    private Path pathOrNull(String p) {
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ExporterAttributes attributes = new ExporterAttributes(configuration);
            this.selectedExporters.clear();
            this.enableEJB3annotations.setSelection(attributes.isEJB3Enabled());
            this.enableJDK5.setSelection(attributes.isJDK5Enabled());
            List<ExporterFactory> exporterFactories = attributes.getExporterFactories();
            this.observableFactoryList = new ObservableFactoryList(exporterFactories);
            this.getExporterTable().setInput((Object)this.observableFactoryList);
            for (ExporterFactory exporterFactory : exporterFactories) {
                if (exporterFactory.isEnabled()) {
                    this.getExporterTable().setChecked((Object)exporterFactory, true);
                    this.selectedExporters.add(exporterFactory);
                    continue;
                }
                this.getExporterTable().setChecked((Object)exporterFactory, false);
            }
            this.refreshPropertySheet();
            this.dialogChanged();
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.ExporterSettingsTab_problem_when_reading_hibernate_tools_launch_configuration, ce);
        }
    }

    public void setupPropertyColumsWidth() {
        Control control = this.propertySheet.getControl();
        if (control instanceof Tree && !control.isDisposed()) {
            Tree tree = (Tree)control;
            TreeColumn[] columns = tree.getColumns();
            IPreferenceStore preferenceStore = HibernateConsolePlugin.getDefault().getPreferenceStore();
            int colWidth_0 = preferenceStore.getInt(EXPORTERS_PROPERTIES_COLUMN_PROPERTY_WIDTH);
            int colWidth_1 = preferenceStore.getInt(EXPORTERS_PROPERTIES_COLUMN_VALUE_WIDTH);
            if (colWidth_0 > 0 && colWidth_1 > 0) {
                columns[0].setWidth(colWidth_0);
                columns[1].setWidth(colWidth_1);
            } else {
                Rectangle area = tree.getClientArea();
                if (area.width > 0) {
                    int width = area.width * 40 / 100;
                    if (width < 2) {
                        width = 2;
                    }
                    columns[0].setWidth(width);
                    width = area.width - columns[0].getWidth() - 4;
                    if (width < 2) {
                        width = 2;
                    }
                    columns[1].setWidth(width);
                }
            }
        }
    }

    public void storePropertyColumsWidth() {
        if (this.propertySheet == null) {
            return;
        }
        Control control = this.propertySheet.getControl();
        if (control != null && control instanceof Tree && !control.isDisposed()) {
            Tree tree = (Tree)control;
            IPreferenceStore preferenceStore = HibernateConsolePlugin.getDefault().getPreferenceStore();
            TreeColumn[] columns = tree.getColumns();
            preferenceStore.setValue(EXPORTERS_PROPERTIES_COLUMN_PROPERTY_WIDTH, columns[0].getWidth());
            preferenceStore.setValue(EXPORTERS_PROPERTIES_COLUMN_VALUE_WIDTH, columns[1].getWidth());
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        this.setupPropertyColumsWidth();
    }

    public void dispose() {
        this.storePropertyColumsWidth();
        super.dispose();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.storePropertyColumsWidth();
        super.deactivated(workingCopy);
    }

    private void refreshPropertySheet() {
        this.getExporterTable().setSelection(this.getExporterTable().getSelection());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.hibernate.tools.ejb3", this.enableEJB3annotations.getSelection());
        configuration.setAttribute("org.hibernate.tools.jdk5", this.enableJDK5.getSelection());
        List<ExporterFactory> exporterFactories = ((ObservableFactoryList)this.getExporterTable().getInput()).getList();
        ExporterAttributes.saveExporterFactories(configuration, exporterFactories, this.selectedExporters, this.deletedExporterIds);
        this.deletedExporterIds.clear();
    }

    public String getName() {
        return HibernateConsoleMessages.ExporterSettingsTab_exporters_2;
    }

    public Image getImage() {
        return EclipseImages.getImage("images/hicon.gif");
    }

    private CheckboxTableViewer getExporterTable() {
        return (CheckboxTableViewer)this.exporterUpDown.getTableViewer();
    }

    public static Object[] selectExporters(Shell shell, String title, String description) {
        ExporterLabelProvider labelProvider = new ExporterLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setElements(ExtensionManager.findExporterDefinitionsAsMap().values().toArray());
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return new ExporterDefinition[0];
    }

    private static class ExporterContentProvider
    implements IStructuredContentProvider,
    PropertyChangeListener {
        private AbstractTableViewer viewer;

        private ExporterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ObservableFactoryList)inputElement).getList().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (AbstractTableViewer)viewer;
            ObservableFactoryList ol = (ObservableFactoryList)oldInput;
            ObservableFactoryList newList = (ObservableFactoryList)newInput;
            if (ol != null) {
                ol.removePropertyChangeListener(this);
            }
            if (newList != null) {
                newList.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("addElement".equals(evt.getPropertyName())) {
                this.viewer.add(evt.getNewValue());
            }
            if ("removeElement".equals(evt.getPropertyName())) {
                this.viewer.remove(evt.getOldValue());
            }
            if ("insertElement".equals(evt.getPropertyName())) {
                this.viewer.insert(evt.getNewValue(), ((Integer)evt.getOldValue()).intValue());
            }
        }
    }

    private static class ExporterLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        Map<String, Image> exp2img = new HashMap<String, Image>();

        private ExporterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ExporterDefinition definition = this.getExporterDefinition(element);
            Image image = this.exp2img.get(definition.getId());
            if (image == null) {
                image = definition.getIconDescriptor().createImage();
                this.exp2img.put(definition.getId(), image);
            }
            return image;
        }

        private ExporterDefinition getExporterDefinition(Object element) {
            if (element instanceof ExporterFactory) {
                ExporterFactory ef = (ExporterFactory)element;
                return ef.getExporterDefinition();
            }
            return (ExporterDefinition)element;
        }

        public String getColumnText(Object element, int columnIndex) {
            ExporterDefinition definition = this.getExporterDefinition(element);
            return definition.getDescription();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            for (Image img : this.exp2img.values()) {
                if (img == null) continue;
                img.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    public class MyPropertySheetEntry
    extends PropertySheetEntry {
        public IPropertyDescriptor getMyDescriptor() {
            return super.getDescriptor();
        }

        protected PropertySheetEntry createChildEntry() {
            return new MyPropertySheetEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObservableFactoryList {
        List<ExporterFactory> underlyingList = new ArrayList<ExporterFactory>();
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public ObservableFactoryList(List<ExporterFactory> exporterFactories) {
            this.underlyingList = exporterFactories;
        }

        public void copyUnderlyingList(Set<ExporterFactory> list) {
            list.addAll(this.underlyingList);
        }

        public void moveTo(int i, ExporterFactory data) {
            this.underlyingList.remove(data);
            this.remove(data);
            this.underlyingList.add(i, data);
            this.pcs.firePropertyChange("insertElement", (Object)i, data);
        }

        void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.pcs.addPropertyChangeListener(pcl);
        }

        public List<ExporterFactory> getList() {
            return Collections.unmodifiableList(this.underlyingList);
        }

        void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.pcs.removePropertyChangeListener(pcl);
        }

        boolean add(ExporterFactory o) {
            boolean changed = this.underlyingList.add(o);
            this.pcs.firePropertyChange("addElement", null, o);
            return changed;
        }

        boolean remove(ExporterFactory o) {
            boolean changed = this.underlyingList.remove(o);
            this.pcs.firePropertyChange("removeElement", o, null);
            return changed;
        }
    }
}

