/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.eclipse.console.model.IRevEngGenerator;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.editors.reveng.FormTextEntryListenerAdapter;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.FormTextEntry;

public class GeneratorDetailsPage
extends RevEngDetailsPage
implements IDetailsPage,
PropertyChangeListener {
    private FormTextEntry nameEntry;
    private IRevEngGenerator generator;

    protected void buildContents(FormToolkit toolkit, Section section, Composite client) {
        section.setText(MapperMessages.GeneratorDetailsPage_id_generator_details);
        section.setDescription(MapperMessages.GeneratorDetailsPage_set_the_properties_of_the_selected_generator);
        this.nameEntry = new FormTextEntry(client, toolkit, MapperMessages.GeneratorDetailsPage_class, 0);
        this.nameEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                GeneratorDetailsPage.this.generator.setGeneratorClassName(entry.getValue());
            }
        });
        Button button = toolkit.createButton(client, MapperMessages.GeneratorDetailsPage_add_param, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorDetailsPage.this.handleAddParameter();
            }
        });
    }

    protected void handleAddParameter() {
        this.generator.addParameter();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IRevEngGenerator newTable = (IRevEngGenerator)((IStructuredSelection)selection).getFirstElement();
        if (this.generator != null) {
            this.generator.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (newTable != null) {
            newTable.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.generator = newTable;
        this.update();
    }

    private void update() {
        this.nameEntry.setValue(this.generator.getGeneratorClassName());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }
}

