/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.actions;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramContentOutlinePage;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmDiagram;

public class LexicalSortingAction
extends Action {
    public static final String ACTION_ID = "toggleLexicalSortingId";
    private DiagramViewer diagramViewer;
    private DiagramContentOutlinePage outlinePage;

    public LexicalSortingAction(DiagramViewer diagramViewer, DiagramContentOutlinePage outlinePage) {
        super(DiagramViewerMessages.DiagramViewer_OutlinePage_Sort_label, 2);
        this.setId(ACTION_ID);
        this.diagramViewer = diagramViewer;
        this.outlinePage = outlinePage;
        this.setText(DiagramViewerMessages.DiagramViewer_OutlinePage_Sort_label);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
        this.setToolTipText(DiagramViewerMessages.DiagramViewer_OutlinePage_Sort_tooltip);
        this.setDescription(DiagramViewerMessages.DiagramViewer_OutlinePage_Sort_description);
        boolean checked = this.getOrmDiagram().isDeepIntoSort();
        this.setChecked(checked);
        if (checked) {
            this.valueChanged(checked);
        }
    }

    public void run() {
        this.valueChanged(!this.getOrmDiagram().isDeepIntoSort());
        this.setChecked(this.getOrmDiagram().isDeepIntoSort());
    }

    private void valueChanged(final boolean on) {
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                OrmDiagram od = LexicalSortingAction.this.getOrmDiagram();
                od.setDeepIntoSort(on);
                od.refresh();
                if (LexicalSortingAction.this.outlinePage != null) {
                    LexicalSortingAction.this.outlinePage.setContents(od);
                }
            }
        });
    }

    protected Display getDisplay() {
        if (this.diagramViewer != null && this.diagramViewer.getEditPartViewer() != null && this.diagramViewer.getEditPartViewer().getControl() != null) {
            return this.diagramViewer.getEditPartViewer().getControl().getDisplay();
        }
        if (this.outlinePage != null && this.outlinePage.getOutline() != null) {
            return this.outlinePage.getOutline().getDisplay();
        }
        return null;
    }

    public void setOutlinePage(DiagramContentOutlinePage outlinePage) {
        this.outlinePage = outlinePage;
    }

    protected OrmDiagram getOrmDiagram() {
        if (this.diagramViewer != null) {
            return this.diagramViewer.getOrmDiagram();
        }
        if (this.outlinePage != null) {
            return this.outlinePage.getOrmDiagram();
        }
        return null;
    }
}

