/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Utils;
import org.jboss.tools.hibernate.ui.view.HibernateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shape
extends BaseElement {
    public static final String SET_FOCUS = "setFocus";
    public static final String IDENT = "indent";
    private int indent = 0;
    private List<Connection> sourceConnections = new ArrayList<Connection>();
    private List<Connection> targetConnections = new ArrayList<Connection>();
    private Object ormElement;
    private BaseElement parent;
    private static IPropertyDescriptor[] descriptors_property = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", "name"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"value", "value"), new TextPropertyDescriptor((Object)"persistanceClass", "persistanceClass"), new TextPropertyDescriptor((Object)"selectable", "selectable"), new TextPropertyDescriptor((Object)"insertable", "insertable"), new TextPropertyDescriptor((Object)"updateable", "updateable"), new TextPropertyDescriptor((Object)"cascade", "cascade"), new TextPropertyDescriptor((Object)"lazy", "lazy"), new TextPropertyDescriptor((Object)"optional", "optional"), new TextPropertyDescriptor((Object)"naturalIdentifier", "naturalIdentifier"), new TextPropertyDescriptor((Object)"nodeName", "nodeName"), new TextPropertyDescriptor((Object)"optimisticLocked", "optimisticLocked")};
    private static IPropertyDescriptor[] descriptors_column = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", "name"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"value", "value"), new TextPropertyDescriptor((Object)"nullable", "nullable"), new TextPropertyDescriptor((Object)"unique", "unique")};
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_CLASS = "persistanceClass";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_SELECT = "selectable";
    private static final String PROPERTY_INSERT = "insertable";
    private static final String PROPERTY_UPDATE = "updateable";
    private static final String PROPERTY_CASCADE = "cascade";
    private static final String PROPERTY_LAZY = "lazy";
    private static final String PROPERTY_OPTIONAL = "optional";
    private static final String PROPERTY_NATURAL_IDENTIFIER = "naturalIdentifier";
    private static final String PROPERTY_NODE_NAME = "nodeName";
    private static final String PROPERTY_OPTIMISTIC_LOCKED = "optimisticLocked";
    private static final String PROPERTY_NULLABLE = "nullable";
    private static final String PROPERTY_UNIQUE = "unique";

    protected Shape(Object ioe) {
        this.ormElement = ioe;
    }

    @Override
    public BaseElement getParent() {
        return this.parent;
    }

    public void setParent(BaseElement element) {
        this.parent = element;
    }

    public OrmDiagram getOrmDiagram() {
        OrmDiagram res = null;
        BaseElement el = this;
        while (el != null) {
            if (el instanceof OrmDiagram) {
                res = (OrmDiagram)el;
                break;
            }
            el = ((BaseElement)el).getParent();
        }
        return res;
    }

    public void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this && !this.sourceConnections.contains(conn)) {
            this.sourceConnections.add(conn);
        } else if (conn.getTarget() == this && !this.targetConnections.contains(conn)) {
            this.targetConnections.add(conn);
        }
    }

    public List<Connection> getSourceConnections() {
        return this.sourceConnections;
    }

    public List<Connection> getTargetConnections() {
        return this.targetConnections;
    }

    public Object getOrmElement() {
        return this.ormElement;
    }

    @Override
    public String getKey() {
        return Utils.getName(this.getOrmElement()).replaceAll("\\$", "..");
    }

    public void setFocus() {
        this.firePropertyChange(SET_FOCUS, null, null);
    }

    public int getIndent() {
        return this.indent;
    }

    protected void setIndent(int indent) {
        this.indent = indent;
    }

    @Override
    public void updateVisibleValue(boolean initState) {
        Connection.ConnectionType ct;
        boolean state;
        super.updateVisibleValue(initState);
        for (Connection connection : this.sourceConnections) {
            state = true;
            ct = connection.getConnectionType();
            switch (ct) {
                case ClassMapping: {
                    state = this.getOrmDiagram().getConnectionsVisibilityClassMapping();
                    break;
                }
                case PropertyMapping: {
                    state = this.getOrmDiagram().getConnectionsVisibilityPropertyMapping();
                    break;
                }
                case Association: {
                    state = this.getOrmDiagram().getConnectionsVisibilityAssociation();
                    break;
                }
                case ForeignKeyConstraint: {
                    state = this.getOrmDiagram().getConnectionsVisibilityForeignKeyConstraint();
                }
            }
            connection.updateVisibleValue(state);
        }
        for (Connection connection : this.targetConnections) {
            state = true;
            ct = connection.getConnectionType();
            switch (ct) {
                case ClassMapping: {
                    state = this.getOrmDiagram().getConnectionsVisibilityClassMapping();
                    break;
                }
                case PropertyMapping: {
                    state = this.getOrmDiagram().getConnectionsVisibilityPropertyMapping();
                    break;
                }
                case Association: {
                    state = this.getOrmDiagram().getConnectionsVisibilityAssociation();
                    break;
                }
                case ForeignKeyConstraint: {
                    state = this.getOrmDiagram().getConnectionsVisibilityForeignKeyConstraint();
                }
            }
            connection.updateVisibleValue(state);
        }
    }

    @Override
    public void loadState(IMemento memento) {
        int indentTmp;
        super.loadState(memento);
        this.indent = indentTmp = this.getPrValue(memento, IDENT, 0);
    }

    @Override
    protected void loadFromProperties(Properties properties) {
        int indentTmp;
        super.loadFromProperties(properties);
        this.indent = indentTmp = this.getPrValue(properties, IDENT, 0);
    }

    @Override
    public void saveState(IMemento memento) {
        this.setPrValue(memento, IDENT, this.indent);
        super.saveState(memento);
    }

    @Override
    protected void saveInProperties(Properties properties) {
        this.setPrValue(properties, IDENT, this.indent);
        super.saveInProperties(properties);
    }

    public String toString() {
        if (this.ormElement == null) {
            return super.toString();
        }
        return this.ormElement.toString();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getOrmElement() instanceof Property) {
            return descriptors_property;
        }
        if (this.getOrmElement() instanceof Column) {
            return descriptors_column;
        }
        return super.getPropertyDescriptors();
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        Object res = null;
        Column col = null;
        if (this.getOrmElement() instanceof Column) {
            col = (Column)this.getOrmElement();
        }
        Property prop = null;
        if (this.getOrmElement() instanceof Property) {
            prop = (Property)this.getOrmElement();
        }
        if (prop != null) {
            if (PROPERTY_NAME.equals(propertyId)) {
                res = prop.getName();
            } else if (PROPERTY_TYPE.equals(propertyId)) {
                Value value = prop.getValue();
                res = value instanceof Component ? prop.getValue().toString() : prop.getType().getReturnedClass().getName();
            } else if (PROPERTY_VALUE.equals(propertyId)) {
                res = prop.getValue().toString();
            } else if (PROPERTY_CLASS.equals(propertyId)) {
                if (prop.getPersistentClass() != null) {
                    res = prop.getPersistentClass().getClassName();
                }
            } else if (PROPERTY_SELECT.equals(propertyId)) {
                res = Boolean.valueOf(prop.isSelectable()).toString();
            } else if (PROPERTY_INSERT.equals(propertyId)) {
                res = Boolean.valueOf(prop.isInsertable()).toString();
            } else if (PROPERTY_UPDATE.equals(propertyId)) {
                res = Boolean.valueOf(prop.isUpdateable()).toString();
            } else if (PROPERTY_CASCADE.equals(propertyId)) {
                res = prop.getCascade();
            } else if (PROPERTY_LAZY.equals(propertyId)) {
                res = Boolean.valueOf(prop.isLazy()).toString();
            } else if (PROPERTY_OPTIONAL.equals(propertyId)) {
                res = Boolean.valueOf(prop.isOptional()).toString();
            } else if (PROPERTY_NATURAL_IDENTIFIER.equals(propertyId)) {
                res = Boolean.valueOf(prop.isNaturalIdentifier()).toString();
            } else if (PROPERTY_NODE_NAME.equals(propertyId)) {
                res = prop.getNodeName();
            } else if (PROPERTY_OPTIMISTIC_LOCKED.equals(propertyId)) {
                res = Boolean.valueOf(prop.isOptimisticLocked()).toString();
            }
        } else if (col != null) {
            if (PROPERTY_NAME.equals(propertyId)) {
                res = col.getName();
            } else if (PROPERTY_TYPE.equals(propertyId)) {
                String sqlType = col.getSqlType();
                if (sqlType == null) {
                    this.getOrmDiagram().getLabelProvider().updateColumnSqlType(col);
                    sqlType = col.getSqlType();
                }
                StringBuffer name = new StringBuffer();
                if (sqlType != null) {
                    name.append(sqlType.toUpperCase());
                    name.append(HibernateUtils.getTable(col) != null && HibernateUtils.isPrimaryKey(col) ? " PK" : "");
                    name.append(HibernateUtils.getTable(col) != null && HibernateUtils.isForeignKey(col) ? " FK" : "");
                }
                res = name.toString();
            } else if (PROPERTY_VALUE.equals(propertyId)) {
                res = col.getValue().toString();
            } else if (PROPERTY_NULLABLE.equals(propertyId)) {
                res = Boolean.valueOf(col.isNullable()).toString();
            } else if (PROPERTY_UNIQUE.equals(propertyId)) {
                res = Boolean.valueOf(col.isUnique()).toString();
            }
        }
        if (res == null) {
            res = super.getPropertyValue(propertyId);
        }
        return this.toEmptyStr(res);
    }
}

