/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import org.eclipse.jface.resource.ImageDescriptor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.diagram.UiPlugin;
import org.jboss.tools.hibernate.ui.view.HibernateUtils;
import org.jboss.tools.hibernate.ui.view.ImageBundle;

public class OrmImageMap {
    private OrmImageMap() {
    }

    public static ImageDescriptor getImageDescriptor(Object obj) {
        String imageName = null;
        if (obj instanceof Table) {
            imageName = OrmImageMap.getImageName((Table)obj);
        } else if (obj instanceof Column) {
            imageName = OrmImageMap.getImageName((Column)obj);
        } else if (obj instanceof Property) {
            imageName = OrmImageMap.getImageName((Property)obj);
        } else if (obj instanceof OneToMany) {
            imageName = OrmImageMap.getImageName((OneToMany)obj);
        } else if (obj instanceof SimpleValue) {
            imageName = OrmImageMap.getImageName((SimpleValue)obj);
        } else if (obj instanceof PersistentClass) {
            imageName = OrmImageMap.getImageName((PersistentClass)obj);
        } else if (obj instanceof String) {
            imageName = "Image_Error";
        }
        return UiPlugin.getImageDescriptor("images/" + ImageBundle.getString(imageName));
    }

    public static String getImageName(Table table) {
        return "Image_DatabaseTable";
    }

    public static String getImageName(Column column) {
        String str = "Image_DatabaseColumn";
        boolean primaryKey = HibernateUtils.isPrimaryKey(column);
        boolean foreignKey = HibernateUtils.isForeignKey(column);
        Table table = HibernateUtils.getTable(column);
        if (column.isUnique()) {
            str = "Image_DatabaseUniqueKeyColumn";
        } else if (primaryKey && table != null && foreignKey) {
            str = "Image_DatabasePrimaryForeignKeysColumn";
        } else if (primaryKey) {
            str = "Image_DatabasePrimaryKeyColumn";
        } else if (table != null && foreignKey) {
            str = "Image_DatabaseForeignKeyColumn";
        }
        return str;
    }

    public static String getImageName(Property field) {
        String str = "Image_PersistentFieldSimple";
        if (field == null) {
            return str;
        }
        PersistentClass persistentClass = field.getPersistentClass();
        if (persistentClass != null && persistentClass.getVersion() == field) {
            str = "Image_PersistentFieldSimple_version";
        } else if (persistentClass != null && persistentClass.getIdentifierProperty() == field) {
            str = "Image_PersistentFieldSimple_id";
        } else if (field.getValue() != null) {
            Value value = field.getValue();
            if (value instanceof OneToMany) {
                str = "Image_PersistentFieldOne-to-many";
            } else if (value instanceof OneToOne) {
                str = "Image_PersistentFieldOne-to-one";
            } else if (value instanceof ManyToOne) {
                str = "Image_PersistentFieldMany-to-one";
            } else if (value instanceof Any) {
                str = "Image_PersistentFieldAny";
            } else {
                Type type = null;
                try {
                    type = field.getType();
                }
                catch (Exception exception) {}
                if (type != null && type.isCollectionType()) {
                    str = value instanceof PrimitiveArray ? "Image_Collection_primitive_array" : (value instanceof Array ? "Image_Collection_array" : (value instanceof List ? "Image_Collection_list" : (value instanceof Set ? "Image_Collection_set" : (value instanceof Map ? "Image_Collection_map" : (value instanceof Bag ? "Image_Collection_bag" : (value instanceof IdentifierBag ? "Image_Collection_idbag" : "Image_Collection"))))));
                }
            }
        } else if ("parent".equals(field.getName())) {
            str = "Image_PersistentFieldParent";
        }
        return str;
    }

    public static String getImageName(OneToMany field) {
        return "Image_PersistentFieldOne-to-many";
    }

    public static String getImageName(SimpleValue field) {
        String res = "Image_PersistentFieldSimple";
        if (field instanceof Any) {
            res = "Image_PersistentFieldMany-to-any";
        } else if (field instanceof Component) {
            res = "Image_PersistentFieldComponent";
        } else if (field instanceof DependantValue) {
            DependantValue mapping = (DependantValue)field;
            if (mapping.getTable().getIdentifierValue() == mapping) {
                res = "Image_PersistentFieldComponent_id";
            }
        } else if (field instanceof ManyToOne) {
            res = "Image_PersistentFieldMany-to-many";
        }
        return res;
    }

    public static String getImageName(PersistentClass persistentClass) {
        return "Image_PersistentClass";
    }
}

