/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.ui.view.OrmImageMap;
import org.jboss.tools.hibernate.ui.view.OrmLabelMap;

public class OrmLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(25);
    protected String consoleConfigName;
    protected Mapping mapping = null;
    protected Dialect dialect = null;

    public OrmLabelProvider() {
    }

    public OrmLabelProvider(String consoleConfigName) {
        this.setConsoleConfigName(consoleConfigName);
    }

    public void setConsoleConfigName(String consoleConfigName) {
        if (this.consoleConfigName == consoleConfigName) {
            return;
        }
        this.consoleConfigName = consoleConfigName;
        this.mapping = null;
        this.dialect = null;
    }

    protected Configuration getConfig() {
        final ConsoleConfiguration consoleConfig = this.getConsoleConfig();
        if (consoleConfig != null) {
            Configuration config = consoleConfig.getConfiguration();
            if (config == null) {
                try {
                    consoleConfig.build();
                }
                catch (HibernateException hibernateException) {}
                consoleConfig.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        if (consoleConfig.hasConfiguration()) {
                            consoleConfig.getConfiguration().buildMappings();
                        }
                        return consoleConfig;
                    }
                });
                config = consoleConfig.getConfiguration();
            }
            return config;
        }
        return null;
    }

    protected ConsoleConfiguration getConsoleConfig() {
        KnownConfigurations knownConfigurations = KnownConfigurations.getInstance();
        ConsoleConfiguration consoleConfig = knownConfigurations.find(this.consoleConfigName);
        return consoleConfig;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = OrmImageMap.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        Image image = this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object obj) {
        if (obj instanceof Column) {
            this.updateColumnSqlType((Column)obj);
        }
        return OrmLabelMap.getLabel(obj);
    }

    public void dispose() {
        Iterator<Image> i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.imageCache.clear();
    }

    public Color getForeground(Object element) {
        if (element instanceof RootClass) {
            return Display.getCurrent().getSystemColor(6);
        }
        if (element instanceof Property) {
            return Display.getCurrent().getSystemColor(10);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        return null;
    }

    public boolean updateColumnSqlType(Column column) {
        String dialectName;
        String sqlType = column.getSqlType();
        if (sqlType != null) {
            return false;
        }
        Configuration config = this.getConfig();
        if (this.mapping == null && config != null) {
            this.mapping = config.buildMapping();
        }
        if (this.dialect == null && config != null && (dialectName = config.getProperty("hibernate.dialect")) != null) {
            try {
                this.dialect = (Dialect)Class.forName(dialectName).newInstance();
            }
            catch (InstantiationException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Exception: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Exception: ", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Exception: ", (Throwable)e);
            }
        }
        if (this.dialect != null) {
            try {
                sqlType = column.getSqlType(this.dialect, this.mapping);
            }
            catch (Exception exception) {}
        }
        if (sqlType != null) {
            column.setSqlType(sqlType);
            return true;
        }
        return false;
    }
}

