/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.OpenMappingUtils;
import org.hibernate.eclipse.jdt.ui.Activator;
import org.hibernate.eclipse.jdt.ui.internal.BasicQuickAssistProcessor;
import org.hibernate.eclipse.jdt.ui.internal.ExternalActionQuickAssistProposal;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.SaveQueryEditorListener;

public class CriteriaQuickAssistProcessor
extends BasicQuickAssistProcessor {
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        IJavaCompletionProposal[] result = new IJavaCompletionProposal[]{};
        if (!this.hasAssists(context)) {
            return result;
        }
        IDocument document = this.getDocument(context.getCompilationUnit());
        try {
            String contents = document.get(context.getSelectionOffset(), context.getSelectionLength());
            final Point position = new Point(context.getSelectionOffset(), context.getSelectionLength());
            result = new IJavaCompletionProposal[]{new ExternalActionQuickAssistProposal(contents, EclipseImages.getImage((String)"images/criteria_editor.gif"), JdtUiMessages.CriteriaQuickAssistProcessor_copy_to_criteria_editor, context){

                public void apply(IDocument target) {
                    IEditorPart editorPart = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    ITextEditor[] textEditors = OpenMappingUtils.getTextEditors((IEditorPart)editorPart);
                    if (textEditors.length == 0) {
                        return;
                    }
                    new SaveQueryEditorListener(textEditors[0], this.getName(), this.getContents(), position, 1);
                }
            }};
        }
        catch (BadLocationException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(JdtUiMessages.CriteriaQuickAssistProcessor_errormessage, (Throwable)e);
        }
        return result;
    }

    private IDocument getDocument(ICompilationUnit cu) throws JavaModelException {
        IFile file = (IFile)cu.getResource();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)new FileEditorInput(file));
        if (document == null) {
            return new Document(cu.getSource());
        }
        return document;
    }
}

