/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.OpenMappingUtils;
import org.hibernate.eclipse.jdt.ui.Activator;
import org.hibernate.eclipse.jdt.ui.internal.BasicQuickAssistProcessor;
import org.hibernate.eclipse.jdt.ui.internal.ExternalActionQuickAssistProposal;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.SaveQueryEditorListener;

public class HQLQuickAssistProcessor
extends BasicQuickAssistProcessor {
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        IJavaCompletionProposal[] result = new IJavaCompletionProposal[]{};
        if (!this.hasAssists(context)) {
            return result;
        }
        ASTNode coveringNode = context.getCoveringNode();
        if (!(coveringNode instanceof StringLiteral)) {
            return result;
        }
        final StringLiteral stringLiteral = (StringLiteral)coveringNode;
        String contents = stringLiteral.getLiteralValue();
        result = new IJavaCompletionProposal[]{new ExternalActionQuickAssistProposal(contents, EclipseImages.getImage((String)"HQL_EDITOR"), JdtUiMessages.HQLQuickAssistProcessor_copy_to_hql_editor, context){

            public void apply(IDocument document) {
                IEditorPart editorPart = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                ITextEditor[] textEditors = OpenMappingUtils.getTextEditors((IEditorPart)editorPart);
                if (textEditors.length == 0) {
                    return;
                }
                Point position = new Point(stringLiteral.getStartPosition() + 1, stringLiteral.getLength() - 2);
                new SaveQueryEditorListener(textEditors[0], this.getName(), this.getContents(), position, 0);
            }
        }};
        return result;
    }
}

