/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.collect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.CollectEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.OwnerType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefFieldInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.AnnotStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllEntitiesInfoCollector {
    protected Map<String, EntityInfo> mapCUs_Info = new TreeMap<String, EntityInfo>();
    protected AnnotStyle annotationStylePreference = AnnotStyle.FIELDS;

    public void initCollector() {
        this.mapCUs_Info.clear();
    }

    public void updateOwner(ProcessItem pi) {
        if (pi.refEntityInfo.refType == RefType.ONE2ONE) {
            if (pi.refEntityInfo.owner == OwnerType.UNDEF && pi.refEntityInfo2.owner == OwnerType.UNDEF || pi.refEntityInfo.owner == OwnerType.YES && pi.refEntityInfo2.owner == OwnerType.YES || pi.refEntityInfo.owner == OwnerType.NO && pi.refEntityInfo2.owner == OwnerType.NO) {
                if (pi.refEntityInfo.fullyQualifiedName.compareTo(pi.refEntityInfo2.fullyQualifiedName) > 0) {
                    pi.refEntityInfo.owner = OwnerType.YES;
                    pi.refEntityInfo2.owner = OwnerType.NO;
                } else {
                    pi.refEntityInfo.owner = OwnerType.NO;
                    pi.refEntityInfo2.owner = OwnerType.YES;
                }
            } else if (pi.refEntityInfo.owner == OwnerType.UNDEF || pi.refEntityInfo2.owner == OwnerType.UNDEF) {
                if (pi.refEntityInfo.owner == OwnerType.YES) {
                    pi.refEntityInfo2.owner = OwnerType.NO;
                } else if (pi.refEntityInfo.owner == OwnerType.NO) {
                    pi.refEntityInfo2.owner = OwnerType.YES;
                } else if (pi.refEntityInfo2.owner == OwnerType.YES) {
                    pi.refEntityInfo.owner = OwnerType.NO;
                } else if (pi.refEntityInfo2.owner == OwnerType.NO) {
                    pi.refEntityInfo.owner = OwnerType.YES;
                }
            }
        } else if (pi.refEntityInfo.refType == RefType.ONE2MANY) {
            pi.refEntityInfo.owner = OwnerType.YES;
            pi.refEntityInfo2.owner = OwnerType.NO;
        } else if (pi.refEntityInfo.refType == RefType.MANY2ONE) {
            pi.refEntityInfo.owner = OwnerType.NO;
            pi.refEntityInfo2.owner = OwnerType.YES;
        } else if (pi.refEntityInfo.refType == RefType.MANY2MANY) {
            if (pi.refEntityInfo.owner == OwnerType.UNDEF && pi.refEntityInfo2.owner == OwnerType.UNDEF || pi.refEntityInfo.owner == OwnerType.YES && pi.refEntityInfo2.owner == OwnerType.YES || pi.refEntityInfo.owner == OwnerType.NO && pi.refEntityInfo2.owner == OwnerType.NO) {
                if (pi.refEntityInfo.fullyQualifiedName.compareTo(pi.refEntityInfo2.fullyQualifiedName) > 0) {
                    pi.refEntityInfo.owner = OwnerType.YES;
                    pi.refEntityInfo2.owner = OwnerType.NO;
                } else {
                    pi.refEntityInfo.owner = OwnerType.NO;
                    pi.refEntityInfo2.owner = OwnerType.YES;
                }
            } else if (pi.refEntityInfo.owner == OwnerType.UNDEF || pi.refEntityInfo2.owner == OwnerType.UNDEF) {
                if (pi.refEntityInfo.owner == OwnerType.YES) {
                    pi.refEntityInfo2.owner = OwnerType.NO;
                } else if (pi.refEntityInfo.owner == OwnerType.NO) {
                    pi.refEntityInfo2.owner = OwnerType.YES;
                } else if (pi.refEntityInfo2.owner == OwnerType.YES) {
                    pi.refEntityInfo.owner = OwnerType.NO;
                } else if (pi.refEntityInfo2.owner == OwnerType.NO) {
                    pi.refEntityInfo.owner = OwnerType.YES;
                }
            }
        }
    }

    public boolean hasMappedSuperclassVersion(String javaProjectName, String parentName) {
        if (parentName == null) {
            return false;
        }
        EntityInfo entryInfoParent = this.mapCUs_Info.get(String.valueOf(javaProjectName) + "/" + parentName);
        if (entryInfoParent == null) {
            return false;
        }
        return entryInfoParent.isAddMappedSuperclassFlag() || entryInfoParent.hasMappedSuperclassAnnotation();
    }

    public void resolveRelations() {
        EntityInfo entryInfo;
        Iterator<Map.Entry<String, EntityInfo>> it = null;
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            String parentName;
            EntityInfo entityInfo = entry.getValue();
            String javaProjectName = entityInfo.getJavaProjectName();
            if (this.hasMappedSuperclassVersion(javaProjectName, parentName = entityInfo.getFullyQualifiedParentName())) {
                entityInfo.setAddVersionFlag(false);
            } else {
                entityInfo.setAddVersionFlag(true);
            }
            entityInfo.updateVersionImport(entityInfo.isAddVersionFlag());
        }
        int fromVariableCounter = 0;
        int fromMethodCounter = 0;
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            EntityInfo entryInfo2 = entry.getValue();
            entryInfo2.generateRefFieldInfoMap();
            fromVariableCounter += entryInfo2.getFromVariableCounter();
            fromMethodCounter += entryInfo2.getFromMethodCounter();
        }
        this.annotationStylePreference = fromVariableCounter >= fromMethodCounter ? AnnotStyle.FIELDS : AnnotStyle.GETTERS;
        EntityProcessor ep = new EntityProcessor();
        IConnector promptsConnector = new IConnector(){

            public boolean updateRelation() {
                if (this.pi == null) {
                    return false;
                }
                if (this.pi.refEntityInfo == null || this.pi.refEntityInfo2 == null) {
                    return false;
                }
                int hasPrompt = 0;
                if (this.pi.fieldId != null && this.pi.fieldId.equals(this.pi.refEntityInfo2.mappedBy)) {
                    hasPrompt |= 1;
                }
                if (this.pi.fieldId2 != null && this.pi.fieldId2.equals(this.pi.refEntityInfo.mappedBy)) {
                    hasPrompt |= 2;
                }
                if (hasPrompt != 0) {
                    if (hasPrompt == 1) {
                        if (this.pi.refEntityInfo2.refType == RefType.ONE2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.ONE2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.MANY2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.MANY2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.MANY2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    } else if (hasPrompt == 2) {
                        if (this.pi.refEntityInfo.refType == RefType.ONE2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId;
                            this.pi.refEntityInfo2.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId2;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo.refType == RefType.ONE2MANY) {
                            this.pi.refEntityInfo.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId;
                            this.pi.refEntityInfo2.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId2;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo.refType == RefType.MANY2ONE) {
                            this.pi.refEntityInfo.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId;
                            this.pi.refEntityInfo2.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId2;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo.refType == RefType.MANY2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId;
                            this.pi.refEntityInfo2.refType = RefType.MANY2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId2;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    }
                    if (this.pi.refEntityInfo.refType == RefType.ONE2ONE) {
                        if (this.pi.refEntityInfo2.refType == RefType.ONE2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.ONE2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    } else if (this.pi.refEntityInfo.refType == RefType.ONE2MANY) {
                        if (this.pi.refEntityInfo2.refType == RefType.ONE2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.ONE2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.MANY2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    }
                }
                return true;
            }
        };
        ep.setConnector(promptsConnector);
        ep.enumEntityPairs();
        IConnector simpleRelConnector = new IConnector(){

            public boolean updateRelation() {
                if (this.pi == null) {
                    return false;
                }
                if (this.pi.refEntityInfo == null || this.pi.refEntityInfo2 == null) {
                    return false;
                }
                if (this.pi.refEntityInfo.mappedBy == null && this.pi.refEntityInfo2.mappedBy == null) {
                    if (this.pi.refEntityInfo.refType == RefType.ONE2ONE) {
                        if (this.pi.refEntityInfo2.refType == RefType.ONE2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.ONE2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    } else if (this.pi.refEntityInfo.refType == RefType.ONE2MANY) {
                        if (this.pi.refEntityInfo2.refType == RefType.ONE2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.MANY2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    } else if (this.pi.refEntityInfo.refType == RefType.MANY2ONE) {
                        if (this.pi.refEntityInfo2.refType == RefType.ONE2MANY) {
                            this.pi.refEntityInfo.refType = RefType.MANY2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2MANY;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        } else if (this.pi.refEntityInfo2.refType == RefType.MANY2ONE) {
                            this.pi.refEntityInfo.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                            this.pi.refEntityInfo2.refType = RefType.ONE2ONE;
                            this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                            AllEntitiesInfoCollector.this.updateOwner(this.pi);
                        }
                    }
                }
                return true;
            }
        };
        ep.setConnector(simpleRelConnector);
        ep.enumEntityPairs();
        IConnector m2mRelConnector = new IConnector(){

            public boolean updateRelation() {
                if (this.pi == null) {
                    return false;
                }
                if (this.pi.refEntityInfo == null || this.pi.refEntityInfo2 == null) {
                    return false;
                }
                if (this.pi.refEntityInfo.mappedBy == null && this.pi.refEntityInfo2.mappedBy == null && this.pi.refEntityInfo.refType == RefType.ONE2MANY && this.pi.refEntityInfo2.refType == RefType.ONE2MANY && this.pi.refEntityInfo2.mappedBy == null) {
                    this.pi.refEntityInfo.refType = RefType.MANY2MANY;
                    this.pi.refEntityInfo.mappedBy = this.pi.fieldId2;
                    this.pi.refEntityInfo2.refType = RefType.MANY2MANY;
                    this.pi.refEntityInfo2.mappedBy = this.pi.fieldId;
                    AllEntitiesInfoCollector.this.updateOwner(this.pi);
                }
                return true;
            }
        };
        ep.setConnector(m2mRelConnector);
        ep.enumEntityPairs();
        EntitySingleCandidateResolver escr = new EntitySingleCandidateResolver();
        escr.enumEntityPairs();
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            entryInfo = entry.getValue();
            Iterator<Map.Entry<String, RefEntityInfo>> referencesIt = entryInfo.getReferences().entrySet().iterator();
            boolean isOne2One = false;
            boolean isOne2Many = false;
            boolean isMany2One = false;
            boolean isMany2Many = false;
            while (referencesIt.hasNext()) {
                Map.Entry<String, RefEntityInfo> entry2 = referencesIt.next();
                RefEntityInfo refEntityInfo = entry2.getValue();
                if (refEntityInfo == null) continue;
                if (refEntityInfo.refType == RefType.ONE2ONE && !refEntityInfo.resolvedAnnotationName) {
                    isOne2One = true;
                    continue;
                }
                if (refEntityInfo.refType == RefType.ONE2MANY && !refEntityInfo.resolvedAnnotationName) {
                    isOne2Many = true;
                    continue;
                }
                if (refEntityInfo.refType == RefType.MANY2ONE && !refEntityInfo.resolvedAnnotationName) {
                    isMany2One = true;
                    continue;
                }
                if (refEntityInfo.refType != RefType.MANY2MANY || refEntityInfo.resolvedAnnotationName) continue;
                isMany2Many = true;
            }
            if (isOne2One) {
                entryInfo.addRequiredImport("javax.persistence.OneToOne");
            }
            if (isOne2Many) {
                entryInfo.addRequiredImport("javax.persistence.OneToMany");
            }
            if (isMany2One) {
                entryInfo.addRequiredImport("javax.persistence.ManyToOne");
            }
            if (!isMany2Many) continue;
            entryInfo.addRequiredImport("javax.persistence.ManyToMany");
        }
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            entryInfo = entry.getValue();
            entryInfo.generateRefFieldInfoMap();
        }
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            entryInfo = entry.getValue();
            this.adjustParentId(entryInfo);
        }
    }

    public void adjustParentId(EntityInfo ei) {
        if (ei == null) {
            return;
        }
        EntityInfo parentEI = this.mapCUs_Info.get(String.valueOf(ei.getJavaProjectName()) + "/" + ei.getFullyQualifiedParentName());
        this.adjustParentId(parentEI);
        ei.adjustPrimaryId(parentEI);
    }

    public void collect(String fullyQualifiedName, String projectName, int depth) {
        if (fullyQualifiedName == null || depth < 0) {
            return;
        }
        if (this.mapCUs_Info.containsKey(String.valueOf(projectName) + "/" + fullyQualifiedName)) {
            return;
        }
        IJavaProject javaProject = Utils.findJavaProject(projectName);
        ICompilationUnit icu = Utils.findCompilationUnit(javaProject, fullyQualifiedName);
        this.collect(icu, depth);
    }

    public void collect(ICompilationUnit icu, int depth) {
        if (icu == null || depth < 0) {
            return;
        }
        CompilationUnit cu = Utils.getCompilationUnit(icu, true);
        if (cu == null) {
            return;
        }
        if (cu.types() == null || cu.types().size() == 0) {
            return;
        }
        boolean hasTypeDeclaration = false;
        for (Object tmp : cu.types()) {
            if (!(tmp instanceof TypeDeclaration)) continue;
            hasTypeDeclaration = true;
            break;
        }
        if (!hasTypeDeclaration) {
            return;
        }
        IJavaProject javaProject = icu.getJavaProject();
        String projectName = javaProject != null ? javaProject.getProject().getName() : "";
        ArrayList<String> fullyQualifiedNames = new ArrayList<String>();
        if (cu.getTypeRoot() == null || cu.getTypeRoot().findPrimaryType() == null) {
            for (Object tmp : cu.types()) {
                if (!(tmp instanceof TypeDeclaration)) continue;
                fullyQualifiedNames.add(((TypeDeclaration)tmp).resolveBinding().getBinaryName());
            }
        } else {
            fullyQualifiedNames.add(cu.getTypeRoot().findPrimaryType().getFullyQualifiedName());
        }
        for (String fullyQualifiedName : fullyQualifiedNames) {
            if (this.mapCUs_Info.containsKey(String.valueOf(projectName) + "/" + fullyQualifiedName)) continue;
            CollectEntityInfo finder = new CollectEntityInfo(fullyQualifiedName);
            cu.accept((ASTVisitor)finder);
            EntityInfo result = finder.getEntityInfo();
            if (result == null) continue;
            result.adjustParameters();
            result.setJavaProjectName(projectName);
            this.mapCUs_Info.put(String.valueOf(projectName) + "/" + fullyQualifiedName, result);
            if (depth <= 0) continue;
            Iterator<String> itDep = result.getDependences();
            while (itDep.hasNext()) {
                String fullyQualifiedNameTmp = itDep.next();
                this.collect(fullyQualifiedNameTmp, projectName, depth - 1);
            }
        }
    }

    public Map<String, EntityInfo> getMapCUs_Info() {
        return this.mapCUs_Info;
    }

    public int getNonAbstractCUNumber() {
        Iterator<Map.Entry<String, EntityInfo>> it = null;
        int nonAbstractCUNumber = 0;
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            EntityInfo entryInfo = entry.getValue();
            if (entryInfo.isAbstractFlag()) continue;
            ++nonAbstractCUNumber;
        }
        return nonAbstractCUNumber;
    }

    public int getNonInterfaceCUNumber() {
        Iterator<Map.Entry<String, EntityInfo>> it = null;
        int nonInterfaceCUNumber = 0;
        for (Map.Entry<String, EntityInfo> entry : this.mapCUs_Info.entrySet()) {
            EntityInfo entryInfo = entry.getValue();
            if (entryInfo.isInterfaceFlag()) continue;
            ++nonInterfaceCUNumber;
        }
        return nonInterfaceCUNumber;
    }

    public AnnotStyle getAnnotationStylePreference() {
        return this.annotationStylePreference;
    }

    protected class EntityProcessor {
        protected IConnector connector;

        protected EntityProcessor() {
        }

        public void setConnector(IConnector connector) {
            this.connector = connector;
        }

        public void enumEntityPairs() {
            Iterator<Map.Entry<String, EntityInfo>> it = AllEntitiesInfoCollector.this.mapCUs_Info.entrySet().iterator();
            ProcessItem pi = new ProcessItem();
            while (it.hasNext()) {
                Map.Entry<String, EntityInfo> entry = it.next();
                EntityInfo entryInfo = entry.getValue();
                String fullyQualifiedName = entryInfo.getFullyQualifiedName();
                String javaProjectName = entryInfo.getJavaProjectName();
                assert (entry.getKey().equals(String.valueOf(javaProjectName) + "/" + fullyQualifiedName));
                for (Map.Entry<String, RefEntityInfo> entry2 : entryInfo.getReferences().entrySet()) {
                    pi.fieldId = entry2.getKey();
                    pi.refEntityInfo = entry2.getValue();
                    String fullyQualifiedName2 = pi.refEntityInfo.fullyQualifiedName;
                    EntityInfo entryInfo2 = AllEntitiesInfoCollector.this.mapCUs_Info.get(String.valueOf(javaProjectName) + "/" + fullyQualifiedName2);
                    assert (fullyQualifiedName2.equals(entryInfo2.getFullyQualifiedName()));
                    if (entryInfo2 == null || pi.refEntityInfo == null) continue;
                    pi.refEntityInfo2 = null;
                    pi.fieldId2 = null;
                    Set<RefFieldInfo> setRefEntityInfo = entryInfo2.getRefFieldInfoSet(fullyQualifiedName);
                    if (setRefEntityInfo != null) {
                        if (setRefEntityInfo.size() == 1) {
                            Iterator<RefFieldInfo> itTmp = setRefEntityInfo.iterator();
                            RefFieldInfo rfi = itTmp.next();
                            pi.fieldId2 = rfi.fieldId;
                            pi.refEntityInfo2 = entryInfo2.getFieldIdRefEntityInfo(pi.fieldId2);
                        } else if (setRefEntityInfo.size() > 1) {
                            pi.refEntityInfo2 = null;
                        }
                    }
                    if (this.connector == null) continue;
                    this.connector.setProcessItem(pi);
                    this.connector.updateRelation();
                }
            }
        }
    }

    protected class EntitySingleCandidateResolver {
        protected EntitySingleCandidateResolver() {
        }

        public void enumEntityPairs() {
            Iterator<Map.Entry<String, EntityInfo>> it = AllEntitiesInfoCollector.this.mapCUs_Info.entrySet().iterator();
            ProcessItem pi = new ProcessItem();
            while (it.hasNext()) {
                Map.Entry<String, EntityInfo> entry = it.next();
                EntityInfo entryInfo = entry.getValue();
                String fullyQualifiedName = entryInfo.getFullyQualifiedName();
                String javaProjectName = entryInfo.getJavaProjectName();
                assert (entry.getKey().equals(String.valueOf(javaProjectName) + "/" + fullyQualifiedName));
                for (Map.Entry<String, RefEntityInfo> entry2 : entryInfo.getReferences().entrySet()) {
                    pi.fieldId = entry2.getKey();
                    pi.refEntityInfo = entry2.getValue();
                    String fullyQualifiedName2 = pi.refEntityInfo.fullyQualifiedName;
                    EntityInfo entryInfo2 = AllEntitiesInfoCollector.this.mapCUs_Info.get(String.valueOf(javaProjectName) + "/" + fullyQualifiedName2);
                    assert (fullyQualifiedName2.equals(entryInfo2.getFullyQualifiedName()));
                    if (entryInfo2 == null || pi.refEntityInfo == null) continue;
                    pi.refEntityInfo2 = null;
                    pi.fieldId2 = null;
                    Set<RefFieldInfo> setRefEntityInfo = entryInfo2.getRefFieldInfoSet(fullyQualifiedName);
                    if (setRefEntityInfo == null || setRefEntityInfo.size() <= 1) continue;
                    RefType suitableRefType = RefType.UNDEF;
                    if (pi.refEntityInfo.refType == RefType.ONE2ONE) {
                        suitableRefType = RefType.ONE2ONE;
                    } else if (pi.refEntityInfo.refType == RefType.ONE2MANY) {
                        suitableRefType = RefType.MANY2ONE;
                    } else if (pi.refEntityInfo.refType == RefType.MANY2ONE) {
                        suitableRefType = RefType.ONE2MANY;
                    } else if (pi.refEntityInfo.refType == RefType.MANY2MANY) {
                        suitableRefType = RefType.MANY2MANY;
                    }
                    RefFieldInfo rfiSingleCandidat = null;
                    Iterator<RefFieldInfo> itTmp = setRefEntityInfo.iterator();
                    while (itTmp.hasNext()) {
                        RefFieldInfo rfi = itTmp.next();
                        if (rfi.refType != suitableRefType) continue;
                        if (rfiSingleCandidat != null) break;
                        rfiSingleCandidat = rfi;
                    }
                    if (itTmp.hasNext() || rfiSingleCandidat == null) continue;
                    pi.fieldId2 = rfiSingleCandidat.fieldId;
                    pi.refEntityInfo2 = entryInfo2.getFieldIdRefEntityInfo(pi.fieldId2);
                    pi.refEntityInfo.mappedBy = pi.fieldId2;
                    pi.refEntityInfo2.mappedBy = pi.fieldId;
                    AllEntitiesInfoCollector.this.updateOwner(pi);
                }
            }
        }
    }

    protected abstract class IConnector {
        protected ProcessItem pi;

        protected IConnector() {
        }

        public void setProcessItem(ProcessItem processItem) {
            this.pi = processItem;
        }

        public abstract boolean updateRelation();
    }

    protected static class ProcessItem {
        public String fieldId = null;
        public String fieldId2 = null;
        public RefEntityInfo refEntityInfo = null;
        public RefEntityInfo refEntityInfo2 = null;

        protected ProcessItem() {
        }
    }
}

