/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.common;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.OwnerType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefColumnInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefFieldInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInfo {
    protected String javaProjectName = "";
    protected String fullyQualifiedName = "";
    protected String fullyQualifiedParentName = "";
    protected boolean compilerProblemsFlag = false;
    protected boolean implicitConstructorFlag = true;
    protected boolean defaultConstructorFlag = false;
    protected boolean addEntityFlag = true;
    protected boolean addMappedSuperclassFlag = false;
    protected boolean hasMappedSuperclassAnnotation = false;
    protected Set<String> setExistingImports = new TreeSet<String>();
    protected Set<String> setRequiredImports = new TreeSet<String>();
    protected boolean addSerializableInterfaceFlag = true;
    protected boolean isAbstractFlag = false;
    protected boolean isInterfaceFlag = false;
    protected Set<String> dependences = new TreeSet<String>();
    protected String primaryIdName = "";
    protected boolean addPrimaryIdFlag = true;
    protected boolean addGeneratedValueFlag = true;
    protected boolean addVersionFlag = false;
    protected FieldGetterType versionFieldGetter = FieldGetterType.UNDEF;
    protected boolean hasVersionAnnotation = false;
    protected Map<String, RefEntityInfo> references = new TreeMap<String, RefEntityInfo>();
    protected Map<String, RefColumnInfo> columns = new TreeMap<String, RefColumnInfo>();
    protected Map<String, Set<RefFieldInfo>> mapRefFieldInfo = null;
    protected Set<String> primaryIdCandidates = new TreeSet<String>();
    protected int fromVariableCounter = 0;
    protected int fromMethodCounter = 0;

    public void generateRefFieldInfoMap() {
        this.mapRefFieldInfo = new TreeMap<String, Set<RefFieldInfo>>();
        for (Map.Entry<String, RefEntityInfo> entry : this.getReferences().entrySet()) {
            RefEntityInfo refEntityInfo = entry.getValue();
            Set<Object> fieldInfoSet = null;
            fieldInfoSet = this.mapRefFieldInfo.containsKey(refEntityInfo.fullyQualifiedName) ? this.mapRefFieldInfo.get(refEntityInfo.fullyQualifiedName) : new TreeSet();
            RefFieldInfo fieldInfo = new RefFieldInfo(entry.getKey(), refEntityInfo.refType);
            fieldInfoSet.add(fieldInfo);
            this.mapRefFieldInfo.put(refEntityInfo.fullyQualifiedName, fieldInfoSet);
        }
        Iterator<Map.Entry<String, RefEntityInfo>> referencesIt = null;
    }

    public void adjustPrimaryId(EntityInfo parentEI) {
        String parentPrimaryIdName;
        if (parentEI != null && (parentPrimaryIdName = parentEI.getPrimaryIdName()) != null && parentPrimaryIdName.length() > 0) {
            this.primaryIdName = "";
        }
        if (this.isAddPrimaryIdFlag()) {
            this.setAddPrimaryIdFlag(this.primaryIdName.length() > 0);
            if (this.isAddPrimaryIdFlag()) {
                this.addRequiredImport("javax.persistence.Id");
            }
        }
        if (this.isAddGeneratedValueFlag()) {
            this.setAddGeneratedValueFlag(this.primaryIdName.length() > 0);
            if (this.isAddGeneratedValueFlag()) {
                this.addRequiredImport("javax.persistence.GeneratedValue");
            }
        }
    }

    public RefType getFieldIdRelValue(String fieldId) {
        if (this.references == null || fieldId == null || !this.references.containsKey(fieldId)) {
            return RefType.UNDEF;
        }
        return this.references.get((Object)fieldId).refType;
    }

    public boolean getFieldIdAnnotatedValue(String fieldId) {
        if (this.references == null || fieldId == null || !this.references.containsKey(fieldId)) {
            return false;
        }
        return this.references.get((Object)fieldId).annotated;
    }

    public String getFieldIdFQNameValue(String fieldId) {
        if (this.references == null || fieldId == null || !this.references.containsKey(fieldId)) {
            return "";
        }
        return this.references.get((Object)fieldId).fullyQualifiedName;
    }

    public RefEntityInfo getFieldIdRefEntityInfo(String fieldId) {
        if (this.references == null || fieldId == null || !this.references.containsKey(fieldId)) {
            return null;
        }
        return this.references.get(fieldId);
    }

    public void adjustParameters() {
        if (this.isImplicitConstructorFlag() || this.isDefaultConstructorFlag()) {
            this.setAddSerializableInterfaceFlag(false);
        } else {
            this.addRequiredImport("java.io.Serializable");
        }
        if (this.isAddEntityFlag()) {
            this.addRequiredImport("javax.persistence.Entity");
        } else {
            this.removeRequiredImport("javax.persistence.Entity");
        }
        if (this.isAddMappedSuperclassFlag()) {
            this.addRequiredImport("javax.persistence.MappedSuperclass");
        } else {
            this.removeRequiredImport("javax.persistence.MappedSuperclass");
        }
        this.updateVersionImport(FieldGetterType.UNDEF != this.getVersionFieldGetter());
        this.updateColumnAnnotationImport(false);
        for (Map.Entry<String, RefEntityInfo> entry : this.getReferences().entrySet()) {
            RefEntityInfo refEntityInfo = entry.getValue();
            if (refEntityInfo.owner != OwnerType.NO) continue;
            this.addRequiredImport("javax.persistence.JoinColumn");
        }
        this.primaryIdName = null;
        String entityName = this.getName().toLowerCase();
        for (String name : this.primaryIdCandidates) {
            String check = name.toLowerCase();
            if ("id".equalsIgnoreCase(check)) {
                this.primaryIdName = name;
                break;
            }
            if (check.indexOf("id") != -1 && check.indexOf(entityName) != -1) {
                if (this.primaryIdName == null) {
                    this.primaryIdName = name;
                    continue;
                }
                if (this.primaryIdName.toLowerCase().indexOf(entityName) != -1 && this.primaryIdName.length() <= name.length()) continue;
                this.primaryIdName = name;
                continue;
            }
            if (check.indexOf("id") == -1) continue;
            if (this.primaryIdName == null) {
                this.primaryIdName = name;
                continue;
            }
            if (this.primaryIdName.toLowerCase().indexOf(entityName) != -1 || this.primaryIdName.length() <= name.length()) continue;
            this.primaryIdName = name;
        }
        if (this.primaryIdName == null) {
            this.primaryIdName = "";
        }
    }

    public void updateVersionImport(boolean includeFlag) {
        if (includeFlag) {
            this.addRequiredImport("javax.persistence.Version");
        } else {
            this.removeRequiredImport("javax.persistence.Version");
        }
    }

    public void updateColumnAnnotationImport(boolean nonDefault) {
        if (this.isNonColumnAnnotatedStringField() && nonDefault) {
            this.addRequiredImport("javax.persistence.Column");
        } else {
            this.removeRequiredImport("javax.persistence.Column");
        }
    }

    public String getName() {
        String[] arr = this.fullyQualifiedName.split("\\.");
        if (arr.length > 0) {
            return arr[arr.length - 1];
        }
        return "";
    }

    public String getJavaProjectName() {
        return this.javaProjectName;
    }

    public void setJavaProjectName(String javaProjectName) {
        this.javaProjectName = javaProjectName;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public String getFullyQualifiedParentName() {
        return this.fullyQualifiedParentName;
    }

    public void setFullyQualifiedParentName(String fullyQualifiedParentName) {
        this.fullyQualifiedParentName = fullyQualifiedParentName;
    }

    public boolean isCompilerProblemsFlag() {
        return this.compilerProblemsFlag;
    }

    public void setCompilerProblemsFlag(boolean compilerProblemsFlag) {
        this.compilerProblemsFlag = compilerProblemsFlag;
    }

    public boolean isImplicitConstructorFlag() {
        return this.implicitConstructorFlag;
    }

    public void setImplicitConstructorFlag(boolean implicitConstructorFlag) {
        this.implicitConstructorFlag = implicitConstructorFlag;
    }

    public boolean isDefaultConstructorFlag() {
        return this.defaultConstructorFlag;
    }

    public void setDefaultConstructorFlag(boolean defaultConstructorFlag) {
        this.defaultConstructorFlag = defaultConstructorFlag;
    }

    public boolean isAddEntityFlag() {
        return this.addEntityFlag;
    }

    public void setAddEntityFlag(boolean addEntityFlag) {
        this.addEntityFlag = addEntityFlag;
    }

    public boolean isAddMappedSuperclassFlag() {
        return this.addMappedSuperclassFlag;
    }

    public void setAddMappedSuperclassFlag(boolean addMappedSuperclassFlag) {
        this.addMappedSuperclassFlag = addMappedSuperclassFlag;
    }

    public boolean hasMappedSuperclassAnnotation() {
        return this.hasMappedSuperclassAnnotation;
    }

    public void setHasMappedSuperclassAnnotation(boolean hasMappedSuperclassAnnotation) {
        this.hasMappedSuperclassAnnotation = hasMappedSuperclassAnnotation;
    }

    public boolean isAddSerializableInterfaceFlag() {
        return this.addSerializableInterfaceFlag;
    }

    public void setAddSerializableInterfaceFlag(boolean addSerializableInterfaceFlag) {
        this.addSerializableInterfaceFlag = addSerializableInterfaceFlag;
    }

    public boolean isAbstractFlag() {
        return this.isAbstractFlag;
    }

    public void setAbstractFlag(boolean isAbstractFlag) {
        this.isAbstractFlag = isAbstractFlag;
    }

    public boolean isInterfaceFlag() {
        return this.isInterfaceFlag;
    }

    public void setInterfaceFlag(boolean isInterfaceFlag) {
        this.isInterfaceFlag = isInterfaceFlag;
    }

    public String getPrimaryIdName() {
        return this.primaryIdName;
    }

    public void setPrimaryIdName(String primaryIdName) {
        this.primaryIdName = primaryIdName;
    }

    public Map<String, RefEntityInfo> getReferences() {
        return this.references;
    }

    public void addReference(String fieldId, String fullyQualifiedName, RefType refType) {
        if (this.references == null || fieldId == null) {
            return;
        }
        if (this.references.containsKey(fieldId)) {
            RefEntityInfo rei = this.references.get(fieldId);
            if (rei != null) {
                if (rei.fullyQualifiedName != null) assert (rei.fullyQualifiedName.equals(fullyQualifiedName));
                if (rei.refType != null) assert (rei.refType.equals((Object)refType));
            }
            return;
        }
        this.references.put(fieldId, new RefEntityInfo(fullyQualifiedName, refType));
    }

    public void updateReference(String fieldId, boolean annotated, RefType refType, String mappedBy, boolean resolvedAnnotationName, boolean fromVariable) {
        if (this.references == null || fieldId == null || !this.references.containsKey(fieldId)) {
            return;
        }
        RefEntityInfo rei = this.references.get(fieldId);
        if (rei != null) {
            if (rei.updateCounter == 0) {
                rei.annotated = annotated;
                rei.refType = refType;
                rei.mappedBy = mappedBy;
                if (rei.mappedBy != null) {
                    rei.owner = OwnerType.YES;
                }
                rei.resolvedAnnotationName = resolvedAnnotationName;
            } else assert (false);
            ++rei.updateCounter;
        }
        if (fromVariable) {
            ++this.fromVariableCounter;
        } else {
            ++this.fromMethodCounter;
        }
    }

    public void updateAnnotationColumn(String fieldId, NormalAnnotation node, boolean exist) {
        if (this.columns == null || fieldId == null) {
            return;
        }
        RefColumnInfo rci = this.columns.get(fieldId);
        if (rci == null) {
            rci = new RefColumnInfo(fieldId);
        }
        if (!rci.isExist()) {
            rci.setExist(exist);
        }
        if (node != null) {
            Map<String, Expression> rciValues = rci.getValues();
            for (Object obj : node.values()) {
                if (!(obj instanceof MemberValuePair)) continue;
                MemberValuePair mvp = (MemberValuePair)obj;
                rciValues.put(mvp.getName().getIdentifier(), mvp.getValue());
            }
        }
        this.columns.put(fieldId, rci);
    }

    public RefColumnInfo getRefColumnInfo(String fieldId) {
        return this.columns.get(fieldId);
    }

    public boolean isNonColumnAnnotatedStringField() {
        boolean res = false;
        for (Map.Entry<String, RefColumnInfo> entry : this.columns.entrySet()) {
            if (entry.getValue().isExist()) continue;
            res = true;
            break;
        }
        return res;
    }

    public Set<RefFieldInfo> getRefFieldInfoSet(String fullyQualifiedName) {
        if (this.mapRefFieldInfo == null) {
            return null;
        }
        return this.mapRefFieldInfo.get(fullyQualifiedName);
    }

    public Iterator<String> getDependences() {
        return this.dependences.iterator();
    }

    public void addDependency(String entityFullyQualifiedName) {
        this.dependences.add(entityFullyQualifiedName);
    }

    public void addPrimaryIdCandidate(String name) {
        if (name != null && name.length() > 0) {
            this.primaryIdCandidates.add(name);
        }
    }

    public boolean isAddPrimaryIdFlag() {
        return this.addPrimaryIdFlag;
    }

    public void setAddPrimaryIdFlag(boolean addPrimaryIdFlag) {
        this.addPrimaryIdFlag = addPrimaryIdFlag;
    }

    public boolean isAddGeneratedValueFlag() {
        return this.addGeneratedValueFlag;
    }

    public void setAddGeneratedValueFlag(boolean addGeneratedValueFlag) {
        this.addGeneratedValueFlag = addGeneratedValueFlag;
    }

    public boolean isAddVersionFlag() {
        return this.addVersionFlag;
    }

    public void setAddVersionFlag(boolean addVersionFlag) {
        this.addVersionFlag = addVersionFlag;
    }

    public FieldGetterType getVersionFieldGetter() {
        return this.versionFieldGetter;
    }

    public void setVersionFieldGetter(FieldGetterType versionFieldGetter) {
        this.versionFieldGetter = versionFieldGetter;
    }

    public boolean hasVersionAnnotation() {
        return this.hasVersionAnnotation;
    }

    public void setHasVersionAnnotation(boolean hasVersionAnnotation) {
        this.hasVersionAnnotation = hasVersionAnnotation;
    }

    public void addExistingImport(String existingImport) {
        this.setExistingImports.add(existingImport);
    }

    public void removeExistingImport(String existingImport) {
        this.setExistingImports.remove(existingImport);
    }

    public void collectExistingImport(Set<String> setExistingImports) {
        setExistingImports.addAll(this.setExistingImports);
    }

    public void addRequiredImport(String requiredImport) {
        this.setRequiredImports.add(requiredImport);
    }

    public void removeRequiredImport(String requiredImport) {
        this.setRequiredImports.remove(requiredImport);
    }

    public void collectRequiredImport(Set<String> setRequiredImports) {
        setRequiredImports.addAll(this.setRequiredImports);
    }

    public boolean needImport(String checkImport) {
        return !this.setExistingImports.contains(checkImport) && this.setRequiredImports.contains(checkImport);
    }

    public int getFromVariableCounter() {
        return this.fromVariableCounter;
    }

    public int getFromMethodCounter() {
        return this.fromMethodCounter;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityInfo)) {
            return false;
        }
        EntityInfo ei = (EntityInfo)obj;
        return this.getFullyQualifiedName().equals(ei.getFullyQualifiedName()) && this.getFullyQualifiedParentName().equals(ei.getFullyQualifiedParentName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FieldGetterType {
        UNDEF(0),
        FIELD(1),
        GETTER(2),
        FIELD_GETTER(3);

        private int id;

        private FieldGetterType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static String getClassName() {
            return FieldGetterType.class.getName();
        }
    }
}

