/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.text.edits.MalformedTreeException;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.jdt.ui.Activator;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfosCollection;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.AnnotStyle;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.ChangeStructure;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.ProcessEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.HibernateJPAWizard;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.HibernateJPAWizardDataFactory;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardData;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllEntitiesProcessor
implements IHibernateJPAWizardParams {
    protected IPreferenceStore preferenceStore = null;
    protected AnnotStyle annotationStyle = AnnotStyle.FIELDS;
    protected AnnotStyle annotationStylePreference = AnnotStyle.FIELDS;
    public static final String storePropertyName = "hibernate.jpa.generation.AnnotationStyle.preference";
    protected int defaultStrLength = 255;
    public static final String storeDefaultStrLength = "hibernate.jpa.generation.DefaultStrLength.preference";
    protected boolean enableOptLock = false;
    public static final String storeEnableOptLock = "hibernate.jpa.generation.EnableOptLock.preference";
    protected ArrayList<ChangeStructure> changes = new ArrayList();

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = Activator.getDefault().getPreferenceStore();
        }
        return this.preferenceStore;
    }

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public void initPreferences() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        int value = preferenceStore.getInt(storePropertyName);
        if (value >= AnnotStyle.values().length) {
            value = 0;
        }
        this.annotationStyle = AnnotStyle.values()[value];
        value = preferenceStore.getInt(storeDefaultStrLength);
        if (value <= 0) {
            value = 255;
        }
        this.defaultStrLength = value;
        this.enableOptLock = preferenceStore.getBoolean(storeEnableOptLock);
    }

    public void savePreferences() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        int value = 0;
        while (value < AnnotStyle.values().length) {
            if (AnnotStyle.values()[value] == this.annotationStyle) break;
            ++value;
        }
        if (value >= AnnotStyle.values().length) {
            value = 0;
        }
        preferenceStore.setValue(storePropertyName, value);
        preferenceStore.setValue(storeDefaultStrLength, this.defaultStrLength);
        preferenceStore.setValue(storeEnableOptLock, this.enableOptLock);
    }

    public void modify(Map<String, EntityInfo> entities, boolean askConfirmation, IStructuredSelection selection2Update) {
        this.changes.clear();
        boolean performChange = true;
        boolean res = false;
        if (!res) {
            if (this.getAnnotationStyle().equals((Object)AnnotStyle.AUTO)) {
                this.setAnnotationStyle(this.getAnnotationStylePreference());
                this.reCollectModification(entities);
                this.setAnnotationStyle(AnnotStyle.AUTO);
            } else {
                this.reCollectModification(entities);
            }
        } else {
            performChange = false;
        }
        if (askConfirmation && !this.showRefactoringDialog(entities, selection2Update)) {
            performChange = false;
        }
        if (performChange) {
            this.performCommit(entities);
        }
        this.performDisconnect();
    }

    @Override
    public void performDisconnect() {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        int i = 0;
        while (i < this.changes.size()) {
            ChangeStructure cs = this.changes.get(i);
            try {
                bufferManager.disconnect(cs.path, LocationKind.IFILE, null);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
            }
            ++i;
        }
        this.changes.clear();
    }

    protected void performCommit(Map<String, EntityInfo> entities) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        int i = 0;
        while (i < this.changes.size()) {
            ChangeStructure cs = this.changes.get(i);
            if (cs.textEdit != null && (cs.change != null && cs.change.isEnabled() || cs.change == null)) {
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(cs.path, LocationKind.IFILE);
                IDocument document = textFileBuffer.getDocument();
                try {
                    cs.textEdit.apply(document);
                }
                catch (MalformedTreeException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("MalformedTreeException: ", (Throwable)e);
                }
                catch (BadLocationException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("BadLocationException: ", (Throwable)e);
                }
                try {
                    textFileBuffer.commit(null, true);
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
                }
            }
            ++i;
        }
    }

    @Override
    public void reCollectModification(Map<String, EntityInfo> entities) {
        this.changes.clear();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        HashMap<IPath, EntityInfosCollection> modifications = new HashMap<IPath, EntityInfosCollection>();
        for (Map.Entry<String, EntityInfo> entry : entities.entrySet()) {
            if (entry.getValue().isInterfaceFlag()) continue;
            String javaProjectName = entry.getValue().getJavaProjectName();
            String fullyQualifiedName = entry.getValue().getFullyQualifiedName();
            IJavaProject javaProject = Utils.findJavaProject(javaProjectName);
            ICompilationUnit icu = Utils.findCompilationUnit(javaProject, fullyQualifiedName);
            if (icu == null) continue;
            CompilationUnit cu = Utils.getCompilationUnit(icu, true);
            IPath path = cu.getJavaElement().getPath();
            EntityInfosCollection eiCollection = null;
            if (modifications.containsKey(path)) {
                eiCollection = (EntityInfosCollection)modifications.get(path);
            } else {
                eiCollection = new EntityInfosCollection();
                eiCollection.setPath(path);
                eiCollection.setICompilationUnit(icu);
                eiCollection.setCompilationUnit(cu);
                modifications.put(path, eiCollection);
                try {
                    bufferManager.connect(path, LocationKind.IFILE, null);
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
                }
            }
            EntityInfo entityInfo = entry.getValue();
            entityInfo.updateColumnAnnotationImport(this.defaultStrLength != 255);
            entityInfo.updateVersionImport(this.enableOptLock && entityInfo.isAddVersionFlag());
            eiCollection.addEntityInfo(entityInfo);
        }
        for (EntityInfosCollection eic : modifications.values()) {
            eic.updateExistingImportSet();
            eic.updateRequiredImportSet();
            this.collectModification(bufferManager, eic, entities);
        }
    }

    public void collectModification(ITextFileBufferManager bufferManager, EntityInfosCollection entityInfos, Map<String, EntityInfo> entities) {
        ChangeStructure cs = new ChangeStructure();
        cs.icu = entityInfos.getICompilationUnit();
        cs.path = entityInfos.getPath();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(cs.path, LocationKind.IFILE);
        AST ast = entityInfos.getCompilationUnit().getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        ProcessEntityInfo processor = new ProcessEntityInfo();
        processor.setAnnotationStyle(this.annotationStyle);
        processor.setDefaultStrLength(this.defaultStrLength);
        processor.setEnableOptLock(this.enableOptLock);
        processor.setEntityInfos(entityInfos);
        processor.setEntities(entities);
        processor.setASTRewrite(rewriter);
        entityInfos.getCompilationUnit().accept((ASTVisitor)processor);
        IDocument documentChange = textFileBuffer.getDocument();
        cs.textEdit = rewriter.rewriteAST(documentChange, (Map)JavaCore.getOptions());
        this.changes.add(cs);
    }

    public boolean showRefactoringDialog(Map<String, EntityInfo> entities, IStructuredSelection selection2Update) {
        IHibernateJPAWizardData data = HibernateJPAWizardDataFactory.createHibernateJPAWizardData(entities, selection2Update, this.changes);
        HibernateJPAWizard wizard = new HibernateJPAWizard(data, this);
        return wizard.showWizard();
    }

    @Override
    public AnnotStyle getAnnotationStyle() {
        return this.annotationStyle;
    }

    @Override
    public void setAnnotationStyle(AnnotStyle annotationStyle) {
        this.annotationStyle = annotationStyle;
    }

    @Override
    public AnnotStyle getAnnotationStylePreference() {
        return this.annotationStylePreference;
    }

    public void setAnnotationStylePreference(AnnotStyle annotationStylePreference) {
        this.annotationStylePreference = annotationStylePreference;
    }

    @Override
    public int getDefaultStrLength() {
        return this.defaultStrLength;
    }

    @Override
    public void setDefaultStrLength(int defaultStrLength) {
        this.defaultStrLength = defaultStrLength;
    }

    @Override
    public boolean getEnableOptLock() {
        return this.enableOptLock;
    }

    @Override
    public void setEnableOptLock(boolean enableOptLock) {
        this.enableOptLock = enableOptLock;
    }

    @Override
    public ArrayList<ChangeStructure> getChanges() {
        return this.changes;
    }
}

