/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.AllEntitiesInfoCollector;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.wizards.ProcessEntityInfo;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationActor {
    protected Set<ICompilationUnit> selectionCU;

    public ConfigurationActor(Set<ICompilationUnit> selectionCU) {
        this.selectionCU = selectionCU;
    }

    public Map<IJavaProject, Configuration> createConfigurations(int processDepth) {
        HashMap<IJavaProject, Configuration> configs = new HashMap<IJavaProject, Configuration>();
        if (this.selectionCU.size() == 0) {
            return configs;
        }
        AllEntitiesInfoCollector collector = new AllEntitiesInfoCollector();
        Iterator<ICompilationUnit> it = this.selectionCU.iterator();
        HashMap<IJavaProject, HashSet<ICompilationUnit>> mapJP_CUSet = new HashMap<IJavaProject, HashSet<ICompilationUnit>>();
        while (it.hasNext()) {
            ICompilationUnit cu = it.next();
            HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)mapJP_CUSet.get(cu.getJavaProject());
            if (set == null) {
                set = new HashSet<ICompilationUnit>();
                mapJP_CUSet.put(cu.getJavaProject(), set);
            }
            set.add(cu);
        }
        for (Map.Entry entry : mapJP_CUSet.entrySet()) {
            IJavaProject javaProject = (IJavaProject)entry.getKey();
            Iterator setIt = ((Set)entry.getValue()).iterator();
            collector.initCollector();
            while (setIt.hasNext()) {
                ICompilationUnit icu = (ICompilationUnit)setIt.next();
                collector.collect(icu, processDepth);
            }
            collector.resolveRelations();
            configs.put(javaProject, this.createConfiguration(javaProject, collector.getMapCUs_Info()));
        }
        return configs;
    }

    protected Configuration createConfiguration(IJavaProject project, Map<String, EntityInfo> entities) {
        Configuration config = new Configuration();
        ProcessEntityInfo processor = new ProcessEntityInfo();
        processor.setEntities(entities);
        for (Map.Entry<String, EntityInfo> entry : entities.entrySet()) {
            String fullyQualifiedName = entry.getValue().getFullyQualifiedName();
            ICompilationUnit icu = Utils.findCompilationUnit(project, fullyQualifiedName);
            if (icu == null) continue;
            CompilationUnit cu = Utils.getCompilationUnit(icu, true);
            processor.setEntityInfo(entry.getValue());
            cu.accept((ASTVisitor)processor);
        }
        Mappings mappings = config.createMappings();
        Collection<PersistentClass> classesCollection = this.createHierarhyStructure(project, processor.getRootClasses());
        for (PersistentClass persistentClass : classesCollection) {
            mappings.addClass(persistentClass);
        }
        return config;
    }

    private Collection<PersistentClass> createHierarhyStructure(IJavaProject project, Map<String, RootClass> rootClasses) {
        HashMap<String, PersistentClass> pcCopy = new HashMap<String, PersistentClass>();
        for (Map.Entry<String, RootClass> entry : rootClasses.entrySet()) {
            pcCopy.put(entry.getKey(), (PersistentClass)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : pcCopy.entrySet()) {
            PersistentClass pc = null;
            try {
                pc = this.getMappedSuperclass(project, pcCopy, (RootClass)entry.getValue());
                SingleTableSubclass subclass = null;
                if (pc != null) {
                    if (pc.isAbstract().booleanValue()) {
                        subclass = new SingleTableSubclass(pc);
                        if (pc instanceof RootClass && pc.getDiscriminator() == null) {
                            SimpleValue discr = new SimpleValue();
                            discr.setTypeName("string");
                            discr.addColumn(new Column("DISCR_COL"));
                            ((RootClass)pc).setDiscriminator((Value)discr);
                        }
                    } else {
                        subclass = new JoinedSubclass(pc);
                    }
                } else {
                    pc = this.getMappedImplementedInterface(project, pcCopy, (RootClass)entry.getValue());
                    if (pc != null) {
                        subclass = new SingleTableSubclass(pc);
                    }
                }
                if (subclass == null) continue;
                PersistentClass pastClass = (PersistentClass)pcCopy.get(entry.getKey());
                subclass.setClassName(pastClass.getClassName());
                subclass.setEntityName(pastClass.getEntityName());
                subclass.setDiscriminatorValue(StringHelper.unqualify((String)pastClass.getClassName()));
                subclass.setAbstract(pastClass.isAbstract());
                if (subclass instanceof JoinedSubclass) {
                    ((JoinedSubclass)subclass).setTable(new Table(pastClass.getClassName().toUpperCase()));
                    ((JoinedSubclass)subclass).setKey((KeyValue)pc.getIdentifierProperty().getValue());
                }
                if (pastClass.getIdentifierProperty() != null) {
                    subclass.addProperty(pastClass.getIdentifierProperty());
                }
                Iterator it = pastClass.getPropertyIterator();
                while (it.hasNext()) {
                    subclass.addProperty((Property)it.next());
                }
                entry.setValue(subclass);
            }
            catch (JavaModelException e) {
                HibernateConsolePlugin.getDefault().log((Throwable)e);
            }
        }
        return pcCopy.values();
    }

    private PersistentClass getMappedSuperclass(IJavaProject project, Map<String, PersistentClass> persistentClasses, RootClass rootClass) throws JavaModelException {
        String[][] supertypes;
        IType type = Utils.findType(project, rootClass.getClassName());
        if (type.getSuperclassName() != null && (supertypes = type.resolveType(type.getSuperclassName())) != null) {
            String supertype = supertypes[0][0].length() > 0 ? String.valueOf(supertypes[0][0]) + '.' + supertypes[0][1] : supertypes[0][1];
            return persistentClasses.get(supertype);
        }
        return null;
    }

    private PersistentClass getMappedImplementedInterface(IJavaProject project, Map<String, PersistentClass> persistentClasses, RootClass rootClass) throws JavaModelException {
        String[] interfaces;
        IType type = Utils.findType(project, rootClass.getClassName());
        String[] stringArray = interfaces = type.getSuperInterfaceNames();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] fullInterfaces;
            String interfaze = stringArray[n2];
            String[][] stringArray2 = fullInterfaces = type.resolveType(interfaze);
            int n3 = fullInterfaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] fullInterface = stringArray2[n4];
                String inrefaceName = String.valueOf(fullInterface[0]) + '.' + fullInterface[1];
                if (persistentClasses.get(inrefaceName) != null) {
                    return persistentClasses.get(inrefaceName);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

