/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryContainer;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.NamedNativeQueryPropertyComposite;
import org.eclipse.jpt.ui.internal.mappings.details.NamedQueryPropertyComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedNativeQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateQueryContainer;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateAddQueryDialog;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateNamedNativeQueryPropertyComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateNamedQueryPropertyComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateQueriesComposite
extends Pane<HibernateQueryContainer> {
    private AddRemoveListPane<QueryContainer> listPane;
    private NamedNativeQueryPropertyComposite namedNativeQueryPane;
    private NamedQueryPropertyComposite namedQueryPane;
    private HibernateNamedQueryPropertyComposite hibernateNamedQueryPane;
    private HibernateNamedNativeQueryPropertyComposite hibernateNamedNativeQueryPane;
    private WritablePropertyValueModel<Query> queryHolder;

    public HibernateQueriesComposite(Pane<? extends HibernateQueryContainer> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    private void addQuery() {
        this.addQueryFromDialog(this.buildAddQueryDialog());
    }

    protected HibernateAddQueryDialog buildAddQueryDialog() {
        return new HibernateAddQueryDialog(this.getControl().getShell());
    }

    protected void addQueryFromDialog(HibernateAddQueryDialog hibernateAddQueryDialog) {
        NamedQuery query;
        if (hibernateAddQueryDialog.open() != 0) {
            return;
        }
        String queryType = hibernateAddQueryDialog.getQueryType();
        if (queryType == "namedQuery") {
            query = ((HibernateQueryContainer)this.getSubject()).addNamedQuery(((HibernateQueryContainer)this.getSubject()).namedQueriesSize());
        } else if (queryType == "namedNativeQuery") {
            query = ((HibernateQueryContainer)this.getSubject()).addNamedNativeQuery(((HibernateQueryContainer)this.getSubject()).namedNativeQueriesSize());
        } else if (queryType == "hibernateNamedQuery") {
            query = ((HibernateQueryContainer)this.getSubject()).addHibernateNamedQuery(((HibernateQueryContainer)this.getSubject()).hibernateNamedQueriesSize());
        } else if (queryType == "hibernateNamedNativeQuery") {
            query = ((HibernateQueryContainer)this.getSubject()).addHibernateNamedNativeQuery(((HibernateQueryContainer)this.getSubject()).hibernateNamedNativeQueriesSize());
        } else {
            throw new IllegalArgumentException();
        }
        query.setName(hibernateAddQueryDialog.getName());
        this.queryHolder.setValue((Object)query);
    }

    private ListValueModel<Query> buildDisplayableQueriesListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildQueriesListHolder(), new String[]{"name"});
    }

    private AddRemoveListPane<QueryContainer> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildQueriesAdapter(), this.buildDisplayableQueriesListHolder(), this.queryHolder, this.buildQueriesListLabelProvider(), "org.eclipse.jpt.ui.named_queries");
    }

    private ListValueModel<NamedNativeQuery> buildNamedNativeQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, NamedNativeQuery>(this.getSubjectHolder(), new String[]{"namedNativeQueries"}){

            protected ListIterator<NamedNativeQuery> listIterator_() {
                return ((QueryContainer)this.subject).namedNativeQueries();
            }

            protected int size_() {
                return ((QueryContainer)this.subject).namedNativeQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedNativeQuery> buildNamedNativeQueryHolder() {
        return new TransformationPropertyValueModel<Query, NamedNativeQuery>(this.queryHolder){

            protected NamedNativeQuery transform_(Query value) {
                return value instanceof NamedNativeQuery ? (NamedNativeQuery)value : null;
            }
        };
    }

    private ListValueModel<HibernateNamedQuery> buildHibernateNamedQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, HibernateNamedQuery>(this.getSubjectHolder(), new String[]{"hibernateNamedQueries"}){

            protected ListIterator<HibernateNamedQuery> listIterator_() {
                return ((HibernateQueryContainer)this.subject).hibernateNamedQueries();
            }

            protected int size_() {
                return ((HibernateQueryContainer)this.subject).hibernateNamedQueriesSize();
            }
        };
    }

    private ListValueModel<HibernateNamedNativeQuery> buildHibernateNamedNativeQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, HibernateNamedNativeQuery>(this.getSubjectHolder(), new String[]{"hibernateNamedNativeQueries"}){

            protected ListIterator<HibernateNamedNativeQuery> listIterator_() {
                return ((HibernateQueryContainer)this.subject).hibernateNamedNativeQueries();
            }

            protected int size_() {
                return ((HibernateQueryContainer)this.subject).hibernateNamedNativeQueriesSize();
            }
        };
    }

    private ListValueModel<NamedQuery> buildNamedQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, NamedQuery>(this.getSubjectHolder(), new String[]{"namedQueries"}){

            protected ListIterator<NamedQuery> listIterator_() {
                return ((QueryContainer)this.subject).namedQueries();
            }

            protected int size_() {
                return ((QueryContainer)this.subject).namedQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedQuery> buildNamedQueryHolder() {
        return new TransformationPropertyValueModel<Query, NamedQuery>(this.queryHolder){

            protected NamedQuery transform_(Query value) {
                return value instanceof NamedQuery ? (NamedQuery)value : null;
            }
        };
    }

    private PropertyValueModel<HibernateNamedQuery> buildHibernateNamedQueryHolder() {
        return new TransformationPropertyValueModel<Query, HibernateNamedQuery>(this.queryHolder){

            protected HibernateNamedQuery transform_(Query value) {
                return value instanceof HibernateNamedQuery ? (HibernateNamedQuery)value : null;
            }
        };
    }

    private PropertyValueModel<HibernateNamedNativeQuery> buildHibernateNamedNativeQueryHolder() {
        return new TransformationPropertyValueModel<Query, HibernateNamedNativeQuery>(this.queryHolder){

            protected HibernateNamedNativeQuery transform_(Query value) {
                return value instanceof HibernateNamedNativeQuery ? (HibernateNamedNativeQuery)value : null;
            }
        };
    }

    private Transformer<Query, Control> buildPaneTransformer() {
        return new Transformer<Query, Control>(){

            public Control transform(Query query) {
                if (query == null) {
                    return null;
                }
                if (query instanceof HibernateNamedQuery) {
                    return HibernateQueriesComposite.this.hibernateNamedQueryPane.getControl();
                }
                if (query instanceof HibernateNamedNativeQuery) {
                    return HibernateQueriesComposite.this.hibernateNamedNativeQueryPane.getControl();
                }
                if (query instanceof NamedNativeQuery) {
                    return HibernateQueriesComposite.this.namedNativeQueryPane.getControl();
                }
                return HibernateQueriesComposite.this.namedQueryPane.getControl();
            }
        };
    }

    private AddRemovePane.Adapter buildQueriesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                HibernateQueriesComposite.this.addQuery();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof HibernateNamedQuery) {
                        ((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).removeHibernateNamedQuery((HibernateNamedQuery)item);
                    } else if (item instanceof HibernateNamedNativeQuery) {
                        ((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).removeHibernateNamedNativeQuery((HibernateNamedNativeQuery)item);
                    } else if (item instanceof NamedQuery) {
                        ((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).removeNamedQuery((NamedQuery)item);
                    } else {
                        ((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).removeNamedNativeQuery((NamedNativeQuery)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private ListValueModel<Query> buildQueriesListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildHibernateNamedQueriesListHolder());
        list.add(this.buildHibernateNamedNativeQueriesListHolder());
        list.add(this.buildNamedQueriesListHolder());
        list.add(this.buildNamedNativeQueriesListHolder());
        return new CompositeListValueModel(list);
    }

    private ILabelProvider buildQueriesListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Query query = (Query)element;
                String name = query.getName();
                if (name == null) {
                    int index = -1;
                    index = query instanceof HibernateNamedQuery ? CollectionTools.indexOf((Iterator)((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).hibernateNamedQueries(), (Object)query) : (query instanceof HibernateNamedNativeQuery ? CollectionTools.indexOf((Iterator)((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).hibernateNamedNativeQueries(), (Object)query) : (query instanceof NamedQuery ? CollectionTools.indexOf((Iterator)((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).namedQueries(), (Object)query) : CollectionTools.indexOf((Iterator)((HibernateQueryContainer)HibernateQueriesComposite.this.getSubject()).namedNativeQueries(), (Object)query)));
                    name = NLS.bind((String)JptUiMappingsMessages.QueriesComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    private WritablePropertyValueModel<Query> buildQueryHolder() {
        return new SimplePropertyValueModel();
    }

    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    protected void initialize() {
        super.initialize();
        this.queryHolder = this.buildQueryHolder();
    }

    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.hibernateNamedQueryPane = new HibernateNamedQueryPropertyComposite((Pane<?>)this, (PropertyValueModel<? extends HibernateNamedQuery>)this.buildHibernateNamedQueryHolder(), (Composite)pageBook);
        this.hibernateNamedNativeQueryPane = new HibernateNamedNativeQueryPropertyComposite((Pane<?>)this, (PropertyValueModel<? extends HibernateNamedNativeQuery>)this.buildHibernateNamedNativeQueryHolder(), (Composite)pageBook);
        this.namedQueryPane = new NamedQueryPropertyComposite((Pane)this, this.buildNamedQueryHolder(), (Composite)pageBook);
        this.namedNativeQueryPane = new NamedNativeQueryPropertyComposite((Pane)this, this.buildNamedNativeQueryHolder(), (Composite)pageBook);
        this.installPaneSwitcher(pageBook);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.queryHolder, this.buildPaneTransformer(), pageBook);
    }
}

