/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collection;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.LabeledControl;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.jboss.tools.hibernate.jpt.core.internal.context.CacheModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.FlushModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateQuery;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateQueryPropertyComposite<T extends HibernateQuery>
extends Pane<T> {
    public HibernateQueryPropertyComposite(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initializeLayout(Composite container) {
        this.addLabeledText(container, JptUiMappingsMessages.NamedQueryComposite_nameTextLabel, this.buildNameTextHolder());
        this.addLabeledMultiLineText(container, JptUiMappingsMessages.NamedQueryPropertyComposite_query, this.buildQueryHolder(), 4, null);
        this.addTriStateCheckBoxWithDefault(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_readOnly, this.buildReadOnlyHolder(), this.buildReadOnlyStringHolder(), null);
        this.addLabeledComposite(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_flushMode, (Pane)this.addFlushModeTypeCombo(container), null);
        this.addTriStateCheckBoxWithDefault(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheable, this.buildCacheableHolder(), this.buildCacheableStringHolder(), null);
        this.addLabeledComposite(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheMode, (Pane)this.addCacheModeTypeCombo(container), null);
        this.addLabeledText(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheRegion, this.buildCacheRegionTextHolder());
        Spinner fetchSizeSpinner = this.addLabeledSpinner(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_fetchSize, this.buildFetchSizeHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultFetchSizeLabel(container), "org.eclipse.jpt.ui.mapping_columnLength");
        this.updateGridData(container, fetchSizeSpinner);
        Spinner timeoutSpinner = this.addLabeledSpinner(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_timeout, this.buildTimeoutHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultFetchSizeLabel(container), "org.eclipse.jpt.ui.mapping_columnLength");
        this.updateGridData(container, timeoutSpinner);
    }

    private Control addDefaultFetchSizeLabel(Composite container) {
        Label label = this.addLabel(container, JptUiMappingsMessages.DefaultEmpty);
        new LabeledControlUpdater((LabeledControl)new LabeledLabel(label), this.buildDefaultFetchSizeLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultFetchSizeLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultFetchSizeHolder()){

            protected String transform(Integer value) {
                int defaultValue = HibernateQueryPropertyComposite.this.getSubject() != null ? ((HibernateQuery)HibernateQueryPropertyComposite.this.getSubject()).getDefaultFetchSize() : -1;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithOneParam, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultFetchSizeHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Integer>(this.getSubjectHolder(), new String[]{"defaultFetchSize"}){

            protected Integer buildValue_() {
                return ((HibernateQuery)this.subject).getDefaultFetchSize();
            }

            protected synchronized void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    protected WritablePropertyValueModel<String> buildNameTextHolder() {
        return new PropertyAspectAdapter<HibernateQuery, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((HibernateQuery)this.subject).getName();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setName(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildQueryHolder() {
        return new PropertyAspectAdapter<HibernateQuery, String>(this.getSubjectHolder(), new String[]{"query"}){

            protected String buildValue_() {
                return ((HibernateQuery)this.subject).getQuery();
            }

            protected void setValue_(String value) {
                ((HibernateQuery)this.subject).setQuery(value);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildCacheableHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Boolean>(this.getSubjectHolder(), new String[]{"defaultCacheable", "specifiedCacheable"}){

            protected Boolean buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedCacheable();
            }

            protected void setValue_(Boolean value) {
                ((HibernateQuery)this.subject).setSpecifiedCacheable(value);
            }

            protected synchronized void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildCacheableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildCacheableHolder()){

            protected String transform(Boolean value) {
                if (HibernateQueryPropertyComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateQuery)HibernateQueryPropertyComposite.this.getSubject()).isDefaultCacheable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheableWithDefault, (Object)defaultStringValue);
                }
                return HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheable;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildReadOnlyHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Boolean>(this.getSubjectHolder(), new String[]{"defaultReadOnly", "specifiedReadOnly"}){

            protected Boolean buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedReadOnly();
            }

            protected void setValue_(Boolean value) {
                ((HibernateQuery)this.subject).setSpecifiedReadOnly(value);
            }

            protected synchronized void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildReadOnlyStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildReadOnlyHolder()){

            protected String transform(Boolean value) {
                if (HibernateQueryPropertyComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateQuery)HibernateQueryPropertyComposite.this.getSubject()).isDefaultReadOnly();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)HibernateUIMappingMessages.NamedQueryPropertyComposite_readOnlyWithDefault, (Object)defaultStringValue);
                }
                return HibernateUIMappingMessages.NamedQueryPropertyComposite_readOnly;
            }
        };
    }

    private EnumFormComboViewer<HibernateQuery, FlushModeType> addFlushModeTypeCombo(Composite container) {
        return new EnumFormComboViewer<HibernateQuery, FlushModeType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultFlushMode");
                propertyNames.add("specifiedFlushMode");
            }

            protected FlushModeType[] getChoices() {
                return FlushModeType.values();
            }

            protected FlushModeType getDefaultValue() {
                return ((HibernateQuery)this.getSubject()).getDefaultFlushMode();
            }

            protected String displayString(FlushModeType value) {
                return value.toString();
            }

            protected FlushModeType getValue() {
                return ((HibernateQuery)this.getSubject()).getSpecifiedFlushMode();
            }

            protected void setValue(FlushModeType value) {
                ((HibernateQuery)this.getSubject()).setSpecifiedFlushMode(value);
            }
        };
    }

    private EnumFormComboViewer<HibernateQuery, CacheModeType> addCacheModeTypeCombo(Composite container) {
        return new EnumFormComboViewer<HibernateQuery, CacheModeType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCacheMode");
                propertyNames.add("specifiedCacheMode");
            }

            protected CacheModeType[] getChoices() {
                return CacheModeType.values();
            }

            protected CacheModeType getDefaultValue() {
                return ((HibernateQuery)this.getSubject()).getDefaultCacheMode();
            }

            protected String displayString(CacheModeType value) {
                return value.toString();
            }

            protected CacheModeType getValue() {
                return ((HibernateQuery)this.getSubject()).getSpecifiedCacheMode();
            }

            protected void setValue(CacheModeType value) {
                ((HibernateQuery)this.getSubject()).setSpecifiedCacheMode(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildCacheRegionTextHolder() {
        return new PropertyAspectAdapter<HibernateQuery, String>(this.getSubjectHolder(), new String[]{"defaultCacheRegion", "specifiedCacheRegion"}){

            protected String buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedCacheRegion();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setSpecifiedCacheRegion(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildFetchSizeHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Integer>(this.getSubjectHolder(), new String[]{"specifiedFetchSize"}){

            protected Integer buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedFetchSize();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setSpecifiedFetchSize(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildTimeoutHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Integer>(this.getSubjectHolder(), new String[]{"specifiedTimeout"}){

            protected Integer buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedTimeout();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setSpecifiedTimeout(value);
            }
        };
    }

    protected void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

