/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.hibernate.console.KnownConfigurations;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.ui.HibernateJptUIPlugin;
import org.jboss.tools.hibernate.jpt.ui.internal.platform.HibernateJpaPlatformUi;
import org.jboss.tools.hibernate.jpt.ui.wizard.GenerateEntitiesWizardPage;

public class GenerateEntitiesWizard
extends Wizard {
    private HibernateJpaProject jpaProject;
    private GenerateEntitiesWizardPage initPage;

    public GenerateEntitiesWizard(HibernateJpaProject jpaProject, IStructuredSelection selection) {
        this.jpaProject = jpaProject;
        this.setWindowTitle(JptUiMessages.GenerateEntitiesWizard_generateEntities);
    }

    public void addPages() {
        super.addPages();
        this.initPage = new GenerateEntitiesWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.initPage);
    }

    public boolean performFinish() {
        String projectName = this.jpaProject.getName();
        ILaunchConfigurationWorkingCopy wc = HibernateJpaPlatformUi.createDefaultLaunchConfig(projectName);
        if (wc != null) {
            String concoleConfigurationName = this.initPage.getConfigurationName();
            wc.setAttribute("org.hibernate.tools.configurationname", concoleConfigurationName);
            wc.setAttribute("org.hibernate.tools.outputdir", this.initPage.getOutputDir());
            wc.setAttribute("org.hibernate.tools.schema2hbm", true);
            wc.setAttribute("org.hibernate.tools.package", this.initPage.getPackageName());
            wc.setAttribute("org.hibernate.tools.prefercompositeids", true);
            wc.setAttribute("org.hibernate.tools.reveng.detect_many_to_many", true);
            wc.setAttribute("org.hibernate.tools.reveng.detect_optimistc_lock", true);
            wc.setAttribute("org.hibernate.tools.jdk5", true);
            wc.setAttribute("org.hibernate.tools.ejb3", true);
            wc.setAttribute("hibernate.temp.use_jdbc_metadata_defaults", true);
            wc.setAttribute("org.hibernate.tools.exporters.hbmexporter.extension_id", "org.hibernate.tools.hbm2java");
            try {
                try {
                    wc.launch("run", null);
                }
                catch (CoreException e) {
                    HibernateJptUIPlugin.logException(e);
                    if (this.initPage.isTemporaryConfiguration()) {
                        KnownConfigurations.getInstance().removeConfiguration(KnownConfigurations.getInstance().find(concoleConfigurationName), false);
                    }
                }
            }
            finally {
                if (this.initPage.isTemporaryConfiguration()) {
                    KnownConfigurations.getInstance().removeConfiguration(KnownConfigurations.getInstance().find(concoleConfigurationName), false);
                }
            }
        }
        return true;
    }
}

