/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.swt.widgets.Composite;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.launch.PathHelper;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.ui.wizard.GenerateInitWizardPage;

public class GenerateEntitiesWizardPage
extends GenerateInitWizardPage {
    private StringDialogField packageName;

    public GenerateEntitiesWizardPage(HibernateJpaProject jpaProject) {
        super(jpaProject);
    }

    protected void createChildControls(Composite container) {
        this.packageName = new StringDialogField();
        this.packageName.setDialogFieldListener(this.fieldlistener);
        this.packageName.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_package);
        this.packageName.doFillIntoGrid(container, this.numColumns);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (!"".equals(this.getOutputDir())) {
            this.packageName.setFocus();
        }
    }

    protected void dialogChanged() {
        String msg;
        this.setErrorMessage(null);
        this.setMessage(null);
        String packName = this.getPackageName();
        if (packName.length() > 0) {
            IStatus val = GenerateEntitiesWizardPage.validatePackageName(packName, this.getJpaProject());
            if (val.getSeverity() == 4) {
                this.setErrorMessage(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidPackageName, (Object)val.getMessage()));
                this.setPageComplete(false);
                return;
            }
            if (val.getSeverity() == 2) {
                this.setWarningMessage(Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_DiscouragedPackageName, (Object)val.getMessage()));
            }
        } else {
            this.setWarningMessage(NewWizardMessages.NewTypeWizardPage_warning_DefaultPackageDiscouraged);
        }
        if ((msg = PathHelper.checkDirectory((String)this.getOutputDir(), (String)HibernateConsoleMessages.CodeGenerationSettingsTab_output_directory, (boolean)false)) != null) {
            this.setErrorMessage(msg);
            this.setPageComplete(false);
            return;
        }
        super.dialogChanged();
    }

    private static IStatus validatePackageName(String text, JpaProject project) {
        if (project == null || !project.getJavaProject().exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        return JavaConventionsUtil.validatePackageName((String)text, (IJavaElement)project.getJavaProject());
    }

    public String getPackageName() {
        return this.packageName.getText();
    }
}

