/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.hibernate.Hibernate;
import org.hibernate.console.ConsoleQueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryInputModel
extends Observable {
    List<ConsoleQueryParameter> parameters = new ArrayList<ConsoleQueryParameter>();
    boolean ignoreParameters = false;
    private Integer maxResults;

    public int getParameterCount() {
        return this.parameters.size();
    }

    public ConsoleQueryParameter[] getQueryParameters() {
        return this.parameters.toArray(new ConsoleQueryParameter[this.parameters.size()]);
    }

    public ConsoleQueryParameter[] getQueryParametersForQuery() {
        return this.ignoreParameters ? new ConsoleQueryParameter[]{} : this.parameters.toArray(new ConsoleQueryParameter[0]);
    }

    public QueryInputModel getCopyForQuery() {
        QueryInputModel result = new QueryInputModel();
        ConsoleQueryParameter[] queryParametersForQuery = this.getQueryParametersForQuery();
        result.parameters = Arrays.asList(queryParametersForQuery);
        result.maxResults = this.getMaxResults();
        result.ignoreParameters = this.ignoreParameters;
        return result;
    }

    public void addParameter(ConsoleQueryParameter cqp) {
        this.parameters.add(cqp);
        this.setChanged();
        this.notifyObservers("addParameter");
    }

    public void removeParameter(ConsoleQueryParameter cqp) {
        this.parameters.remove(cqp);
        this.setChanged();
        this.notifyObservers("removeParameter");
    }

    public void moveUp(ConsoleQueryParameter cqp) {
        this.move(cqp, 1, this.parameters);
    }

    public void moveDown(ConsoleQueryParameter cqp) {
        this.move(cqp, 1, this.parameters);
    }

    protected <T> void move(T tf, int shift, List<T> list) {
        int i = list.indexOf(tf);
        if (i >= 0 && i + shift < list.size() && i + shift >= 0) {
            list.remove(i);
            list.add(i + shift, tf);
        }
        this.setChanged();
        this.notifyObservers("move");
    }

    public ConsoleQueryParameter createUniqueParameter(String paramName) {
        if (this.parameters.isEmpty()) {
            return new ConsoleQueryParameter(paramName, Hibernate.STRING, "");
        }
        ConsoleQueryParameter cqp = this.parameters.get(this.parameters.size() - 1);
        ConsoleQueryParameter c = new ConsoleQueryParameter(cqp);
        c.setName(QueryInputModel.makeUnique(this.parameters.iterator(), paramName));
        return c;
    }

    private static String makeUnique(Iterator<ConsoleQueryParameter> items, String originalPropertyName) {
        int cnt = 0;
        String propertyName = originalPropertyName;
        HashSet<String> uniqueNames = new HashSet<String>();
        while (items.hasNext()) {
            ConsoleQueryParameter element = items.next();
            uniqueNames.add(element.getName());
        }
        while (uniqueNames.contains(propertyName)) {
            propertyName = String.valueOf(originalPropertyName) + "-" + ++cnt;
        }
        return propertyName;
    }

    public void setIgnoreParameters(boolean ignoreParameters) {
        this.ignoreParameters = ignoreParameters;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean ignoreParameters() {
        return this.ignoreParameters;
    }

    public void clear() {
        this.parameters.clear();
        this.setChanged();
        this.notifyObservers("clear");
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }
}

